/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xcodeml.c.decompile.XcDecAndDefObj;
import xcodeml.c.decompile.XcDeclObj;
import xcodeml.c.decompile.XcDeclsObj;
import xcodeml.c.decompile.XcFuncDefObj;
import xcodeml.c.type.XcArrayType;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcIdentTableEnum;
import xcodeml.c.type.XcLazyEvalType;
import xcodeml.c.type.XcTagAndDefSet;
import xcodeml.c.type.XcType;
import xcodeml.c.util.XcLazyVisitor;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public final class XcIdentTable {
    private Map<String, XcIdent> _mainSymMap = new HashMap<String, XcIdent>();
    private Map<String, XcIdent> _tagSymMap = new HashMap<String, XcIdent>();
    private Map<String, XcIdent> _labelSymMap = new HashMap<String, XcIdent>();
    private List<XcIdent> _tagAndTypeDefList = new ArrayList<XcIdent>();
    private XcTagAndDefSet _defineTypeSet = new XcTagAndDefSet();

    private Map<String, XcIdent> _getSymMap(XcIdentTableEnum xcIdentTableEnum) {
        switch (xcIdentTableEnum) {
            case MAIN: {
                return this._mainSymMap;
            }
            case TAGNAME: {
                return this._tagSymMap;
            }
            case ANONYM: {
                return null;
            }
        }
        return this._labelSymMap;
    }

    public void add(XcIdentTableEnum xcIdentTableEnum, XcIdent xcIdent) {
        Map<String, XcIdent> map = this._getSymMap(xcIdentTableEnum);
        switch (xcIdentTableEnum) {
            case MAIN: {
                if (!xcIdent.isTypedef()) break;
                this._defineTypeSet.addIdent(xcIdent);
                break;
            }
            case TAGNAME: {
                this._defineTypeSet.addIdent(xcIdent);
                break;
            }
        }
        if (map != null) {
            map.put(xcIdent.getSymbol(), xcIdent);
        }
    }

    public void addAnonIdent(XcIdent xcIdent) {
        this._defineTypeSet.addAnonIdent(xcIdent);
    }

    public void _lazyEval(XcLazyVisitor xcLazyVisitor, XcType xcType) {
        if (xcType == null) {
            return;
        }
        if (xcType instanceof XcArrayType) {
            do {
                xcLazyVisitor.lazyEnter((XcLazyEvalType)((Object)xcType));
                ((XcLazyEvalType)((Object)xcType)).setIsLazyEvalType(false);
            } while ((xcType = xcType.getRefType()) instanceof XcArrayType);
        }
    }

    public XcIdent getIdent(XcIdentTableEnum xcIdentTableEnum, String string) {
        Map<String, XcIdent> map = this._getSymMap(xcIdentTableEnum);
        XcIdent xcIdent = map.get(string);
        return xcIdent;
    }

    public boolean containsIdent(XcIdentTableEnum xcIdentTableEnum, String string) {
        Map<String, XcIdent> map = this._getSymMap(xcIdentTableEnum);
        return map.containsKey(string);
    }

    private void _removeExternVar(XcIdent xcIdent) {
        Set<String> set = xcIdent.getDependVar();
        for (String string : set) {
            if (this._mainSymMap.containsKey(string)) continue;
            set.remove(string);
        }
    }

    public void resolveDependency(XcLazyVisitor xcLazyVisitor) throws XmException {
        Iterator<Map.Entry<String, XcIdent>> iterator = this._mainSymMap.entrySet().iterator();
        while (iterator.hasNext()) {
            XcIdent xcIdent = iterator.next().getValue();
            xcIdent.lazyEval(xcLazyVisitor);
        }
        for (XcIdent xcIdent : this._defineTypeSet.getIdentList()) {
            xcIdent.lazyEval(xcLazyVisitor);
            xcIdent.gatherVar();
            this._removeExternVar(xcIdent);
        }
        this._defineTypeSet.resolveDepend();
        this._tagAndTypeDefList = this._defineTypeSet.getIdentList();
    }

    public void appendCode(XmcWriter xmcWriter) throws XmException {
        for (XcIdent xcIdent : this._tagAndTypeDefList) {
            if (xcIdent == null || xcIdent.isOutput()) continue;
            xcIdent.appendTagOrTypedef(xmcWriter);
            xcIdent.setOutput();
        }
    }

    public void appendCode(XmcWriter xmcWriter, XcDeclsObj xcDeclsObj) throws XmException {
        if (xcDeclsObj == null) {
            this.appendCode(xmcWriter);
        } else {
            this.appendCode(xmcWriter, xcDeclsObj.getDeclList());
        }
    }

    public void appendCode(XmcWriter xmcWriter, List<XcDecAndDefObj> list) throws XmException {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<XcDecAndDefObj> iterator = list.iterator();
        for (XcIdent xcIdent : this._tagAndTypeDefList) {
            if (xcIdent == null || xcIdent.isOutput()) continue;
            if (!xcIdent.getDependVar().isEmpty()) {
                Set<String> set = xcIdent.getDependVar();
                while (!hashSet.containsAll(set)) {
                    String string = null;
                    XcDecAndDefObj xcDecAndDefObj = iterator.next();
                    if (xcDecAndDefObj instanceof XcDeclObj) {
                        string = ((XcDeclObj)xcDecAndDefObj).getSymbol();
                    }
                    if (xcDecAndDefObj instanceof XcFuncDefObj) {
                        string = ((XcFuncDefObj)xcDecAndDefObj).getSymbol();
                    }
                    if (string != null) {
                        hashSet.add(string);
                    }
                    xmcWriter.add(xcDecAndDefObj).noLfOrLf();
                }
            }
            xcIdent.appendTagOrTypedef(xmcWriter);
            xcIdent.setOutput();
        }
        while (iterator.hasNext()) {
            XcDecAndDefObj xcDecAndDefObj = iterator.next();
            xmcWriter.add(xcDecAndDefObj).noLfOrLf();
        }
    }

    public void setTypeSet(XcTagAndDefSet xcTagAndDefSet) {
        this._defineTypeSet = xcTagAndDefSet;
    }

    public void copyTypeSet(XcTagAndDefSet xcTagAndDefSet) {
        if (xcTagAndDefSet == null) {
            return;
        }
        this._defineTypeSet.copyDefinedType(xcTagAndDefSet);
    }

    public XcTagAndDefSet getDefinedTypeSet() {
        return this._defineTypeSet;
    }
}

