/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.type;

import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Node;
import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcArrayType;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBaseTypeEnum;
import xcodeml.c.type.XcBasicType;
import xcodeml.c.type.XcCompositeType;
import xcodeml.c.type.XcEnumType;
import xcodeml.c.type.XcFuncType;
import xcodeml.c.type.XcGccAttributable;
import xcodeml.c.type.XcGccAttributeList;
import xcodeml.c.type.XcIdentTableStack;
import xcodeml.c.type.XcLazyEvalType;
import xcodeml.c.type.XcSymbolKindEnum;
import xcodeml.c.type.XcType;
import xcodeml.c.type.XcVarKindEnum;
import xcodeml.c.util.XcLazyVisitor;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public class XcIdent
extends XcObj
implements XcExprObj,
XcGccAttributable,
XcLazyEvalType {
    private String _symbol;
    private XcType _type;
    private String _tempTypeId;
    private XcExprObj _valueExpr;
    private boolean _isStatic;
    private boolean _isAuto;
    private boolean _isExtern;
    private boolean _isExternDef;
    private boolean _isRegister;
    private boolean _isTypedef;
    private boolean _isGccExtension;
    private boolean _isGccThread;
    private boolean _isBitField;
    private int _bitField;
    private boolean _isBitFieldExpr;
    private XcSymbolKindEnum _symbolKindEnum;
    private XcVarKindEnum _varKindEnum;
    private boolean _isLazyEvalType = false;
    private boolean _isIncompleteType;
    private Node[] _arraySizeBindingNodes;
    private XcGccAttributeList _gccAttrs;
    private XcType _parentType;
    private boolean _isOutput = false;
    private boolean _isDeclared = false;
    private Set<String> _dependVariables = new HashSet<String>();

    public XcIdent(String string) {
        this._symbol = string;
    }

    public XcIdent(String string, XcType xcType) {
        this._symbol = string;
        this._type = xcType;
    }

    public final String getSymbol() {
        return this._symbol;
    }

    public final void setSymbol(String string) {
        this._symbol = string;
    }

    public final XcType getType() {
        return this._type;
    }

    public final void setType(XcType xcType) {
        this._type = xcType;
    }

    public final String getTempTypeId() {
        return this._tempTypeId;
    }

    public final void setTempTypeId(String string) {
        this._tempTypeId = string;
    }

    public final XcExprObj getValue() {
        return this._valueExpr;
    }

    public final void setValue(XcExprObj xcExprObj) {
        this._valueExpr = xcExprObj;
    }

    public final boolean isStatic() {
        return this._isStatic;
    }

    public final void setIsStatic(boolean bl) {
        this._isStatic = bl;
    }

    public final boolean isAuto() {
        return this._isAuto;
    }

    public final void setIsAuto(boolean bl) {
        this._isAuto = bl;
    }

    public final boolean isExtern() {
        return this._isExtern;
    }

    public final void setIsExtern(boolean bl) {
        this._isExtern = bl;
    }

    public final boolean isExternDef() {
        return this._isExternDef;
    }

    public final void setIsExternDef(boolean bl) {
        this._isExternDef = bl;
    }

    public final boolean isTypedef() {
        return this._isTypedef;
    }

    public final void setIsTypedef(boolean bl) {
        this._isTypedef = bl;
    }

    public final boolean isRegister() {
        return this._isRegister;
    }

    public final void setIsRegister(boolean bl) {
        this._isRegister = bl;
    }

    public final boolean isGccExtension() {
        return this._isGccExtension;
    }

    public final void setIsGccExtension(boolean bl) {
        this._isGccExtension = bl;
    }

    public final boolean isGccThread() {
        return this._isGccThread;
    }

    public final void setIsGccThread(boolean bl) {
        this._isGccThread = bl;
    }

    public final XcType getParentType() {
        return this._parentType;
    }

    public final void setParentType(XcType xcType) {
        this._parentType = xcType;
    }

    public final XcSymbolKindEnum getSymbolKindEnum() {
        return this._symbolKindEnum;
    }

    final void setSymbolKindEnum(XcSymbolKindEnum xcSymbolKindEnum) {
        this._symbolKindEnum = xcSymbolKindEnum;
    }

    public final XcVarKindEnum getVarKindEnum() {
        return this._varKindEnum;
    }

    public final void setVarKindEnum(XcVarKindEnum xcVarKindEnum) {
        this._varKindEnum = xcVarKindEnum;
    }

    public final void setIsBitField(boolean bl) {
        this._isBitField = bl;
    }

    public final boolean getIsBitField() {
        return this._isBitField;
    }

    public final void setIsBitFieldExpr(boolean bl) {
        this._isBitFieldExpr = bl;
    }

    public boolean getIsBitFieldExpr() {
        return this._isBitFieldExpr;
    }

    public final int getBitField() {
        return this._bitField;
    }

    public final void setBitField(int n) {
        this._isBitField = true;
        this._isBitFieldExpr = false;
        this._bitField = n;
    }

    public XcExprObj getBitFieldExpr() {
        return this._valueExpr;
    }

    public final void setBitFieldExpr(XcExprObj xcExprObj) {
        this._isBitField = false;
        this._isBitFieldExpr = true;
        this._valueExpr = xcExprObj;
    }

    public final void appendGccExtension(XmcWriter xmcWriter) throws XmException {
        if (this._isGccExtension) {
            xmcWriter.addSpc("__extension__");
        }
    }

    public final void appendGccThread(XmcWriter xmcWriter) throws XmException {
        if (this._isGccThread) {
            xmcWriter.addSpc("__thread");
        }
    }

    @Override
    public final void appendCode(XmcWriter xmcWriter) throws XmException {
        xmcWriter.addSpc(this._symbol);
    }

    @Override
    public void addChild(XcNode xcNode) {
        if (!(xcNode instanceof XcExprObj)) {
            throw new IllegalArgumentException(xcNode.getClass().getName());
        }
        this._valueExpr = (XcExprObj)xcNode;
    }

    @Override
    public void checkChild() {
    }

    @Override
    public XcNode[] getChild() {
        if (this._valueExpr == null) {
            if (this._gccAttrs == null) {
                return null;
            }
            return XcIdent.toNodeArray(this._gccAttrs);
        }
        if (this._gccAttrs == null) {
            return XcIdent.toNodeArray(this._valueExpr);
        }
        return XcIdent.toNodeArray(this._valueExpr, this._gccAttrs);
    }

    @Override
    public final void setChild(int n, XcNode xcNode) {
        switch (n) {
            case 0: {
                this._valueExpr = (XcExprObj)xcNode;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
            }
        }
    }

    public final void resolve(XcIdentTableStack xcIdentTableStack) throws XmException {
        if (this._type != null) {
            return;
        }
        this._type = XcBaseTypeEnum.createTypeByXcode(this._tempTypeId);
        if (this._type == null) {
            this._type = xcIdentTableStack.getType(this._tempTypeId);
        }
        this._tempTypeId = null;
    }

    public final void appendTagOrTypedef(XmcWriter xmcWriter) throws XmException {
        xmcWriter.noLfOrLf();
        this.appendGccExtension(xmcWriter);
        if (this._isTypedef) {
            xmcWriter.addSpc("typedef ");
            this._type.appendTypeDefCode(xmcWriter, this._symbol);
        } else {
            this._type.appendBodyCode(xmcWriter, this._isIncompleteType);
        }
        xmcWriter.eos();
    }

    public final void appendFuncDeclCode(XmcWriter xmcWriter, boolean bl, XcGccAttributeList xcGccAttributeList) throws XmException {
        this.appendDeclAndAttrCode(xmcWriter, bl, xcGccAttributeList);
    }

    public final void appendDeclCode(XmcWriter xmcWriter, boolean bl) throws XmException {
        XcType xcType = this._type.getRealType();
        if (xcType instanceof XcArrayType) {
            this.appendArrayDeclCode(xmcWriter, bl);
        } else {
            this.appendDeclAndAttrCode(xmcWriter, bl, this._gccAttrs);
        }
    }

    public final void appendArrayDeclCode(XmcWriter xmcWriter, boolean bl) throws XmException {
        this.appendDeclAndAttrCode(xmcWriter, bl, null);
        xmcWriter.add(this._gccAttrs);
    }

    public final void appendDeclAndAttrCode(XmcWriter xmcWriter, boolean bl, XcGccAttributeList xcGccAttributeList) throws XmException {
        this.appendGccExtension(xmcWriter);
        if (this._isStatic) {
            xmcWriter.addSpc("static");
        } else if (this._isAuto) {
            xmcWriter.addSpc("auto");
        } else if (this._isExtern) {
            xmcWriter.addSpc("extern");
        } else if (this._isRegister) {
            xmcWriter.addSpc("register");
        }
        this.appendGccThread(xmcWriter);
        this._type.appendDeclCode(xmcWriter, this._symbol, true, bl, xcGccAttributeList);
    }

    public final void appendInitCode(XmcWriter xmcWriter, boolean bl) throws XmException {
        if (bl && this._type != null) {
            this._type.appendDeclCode(xmcWriter, this._symbol, false, false);
        }
        xmcWriter.add(this._gccAttrs).add(this._symbol);
        if (this._valueExpr != null) {
            xmcWriter.addSpc("=").addSpc(this._valueExpr);
        }
    }

    public String toString() {
        return "[symbol=" + this._symbol + "]";
    }

    @Override
    public void setGccAttribute(XcGccAttributeList xcGccAttributeList) {
        this._gccAttrs = xcGccAttributeList;
    }

    @Override
    public XcGccAttributeList getGccAttribute() {
        return this._gccAttrs;
    }

    @Override
    public final boolean isLazyEvalType() {
        return this._isLazyEvalType;
    }

    @Override
    public void setIsLazyEvalType(boolean bl) {
        this._isLazyEvalType = bl;
    }

    @Override
    public Node[] getLazyBindingNodes() {
        return this._arraySizeBindingNodes;
    }

    @Override
    public void setLazyBindings(Node[] nodeArray) {
        this._arraySizeBindingNodes = nodeArray;
    }

    public void setIsIncomplete(boolean bl) {
        this._isIncompleteType = bl;
    }

    public XcIdent getIncomp() {
        XcIdent xcIdent = new XcIdent(this._symbol);
        xcIdent.setType(this._type);
        xcIdent.setIsGccExtension(this._isGccExtension);
        xcIdent.setIsGccThread(this._isGccThread);
        xcIdent.setGccAttribute(this._gccAttrs);
        xcIdent.setIsIncomplete(true);
        return xcIdent;
    }

    public boolean isOutput() {
        return this._isOutput;
    }

    public void setOutput() {
        this._isOutput = true;
    }

    public boolean isDeclared() {
        return this._isDeclared;
    }

    public void setDeclared() {
        this._isDeclared = true;
    }

    private void _lazyEval(XcType xcType, XcLazyVisitor xcLazyVisitor) {
        if (xcType == null || xcType instanceof XcBaseType) {
            return;
        }
        XcGccAttributeList xcGccAttributeList = xcType.getGccAttribute();
        if (xcGccAttributeList != null) {
            xcLazyVisitor.lazyEnter(xcGccAttributeList);
        }
        if (xcType instanceof XcArrayType) {
            xcLazyVisitor.lazyEnter((XcLazyEvalType)((Object)xcType));
        }
        xcType = xcType.getRefType();
        this._lazyEval(xcType, xcLazyVisitor);
    }

    private void _lazyEval(XcIdent xcIdent, XcLazyVisitor xcLazyVisitor) {
        if (xcIdent == null) {
            return;
        }
        xcLazyVisitor.lazyEnter(xcIdent);
        if (xcIdent.getGccAttribute() != null) {
            xcLazyVisitor.lazyEnter(xcIdent.getGccAttribute());
        }
        XcType xcType = xcIdent.getType();
        this._lazyEval(xcType, xcLazyVisitor);
    }

    public void lazyEval(XcLazyVisitor xcLazyVisitor) {
        XcType xcType = this._type;
        if (this._gccAttrs != null) {
            xcLazyVisitor.lazyEnter(this._gccAttrs);
        }
        this._lazyEval(xcType, xcLazyVisitor);
        while (xcType instanceof XcBasicType) {
            xcType = xcType.getRefType();
        }
        switch (this._type.getTypeEnum()) {
            case STRUCT: 
            case UNION: {
                XcCompositeType xcCompositeType = (XcCompositeType)xcType;
                if (xcCompositeType.getMemberList() == null) break;
                for (XcIdent xcIdent : xcCompositeType.getMemberList()) {
                    this._lazyEval(xcIdent, xcLazyVisitor);
                }
                break;
            }
            case ENUM: {
                XcEnumType xcEnumType = (XcEnumType)xcType;
                if (xcEnumType.getEnumeratorList() == null) break;
                for (XcIdent xcIdent : xcEnumType.getEnumeratorList()) {
                    this._lazyEval(xcIdent, xcLazyVisitor);
                }
                break;
            }
            case FUNC: {
                XcFuncType xcFuncType = (XcFuncType)xcType;
                if (xcFuncType.getParamList() == null) break;
                xcLazyVisitor.pushParamListIdentTable(xcFuncType.getParamList());
                for (XcIdent xcIdent : xcFuncType.getParamList()) {
                    this._lazyEval(xcIdent, xcLazyVisitor);
                }
                xcLazyVisitor.popIdentTable();
                break;
            }
        }
    }

    @Override
    public Set<String> getDependVar() {
        return this._dependVariables;
    }

    private void _gatherVar(XcIdent xcIdent) {
        XcType xcType;
        Set<String> set = xcIdent.getDependVar();
        if (!set.isEmpty()) {
            this._dependVariables.addAll(set);
        }
        if ((xcType = xcIdent.getType()) == null) {
            return;
        }
        xcType = xcType.getRealType();
        while (xcType instanceof XcArrayType) {
            this._dependVariables.addAll(((XcArrayType)xcType).getDependVar());
            xcType = xcType.getRefType();
            if (xcType == null) break;
            xcType = xcType.getRealType();
        }
    }

    public void gatherVar() {
        XcType xcType = this._type;
        while (xcType instanceof XcBasicType) {
            xcType = xcType.getRefType();
        }
        switch (this._type.getTypeEnum()) {
            case STRUCT: 
            case UNION: {
                XcCompositeType xcCompositeType = (XcCompositeType)xcType;
                if (xcCompositeType.getMemberList() == null) break;
                for (XcIdent xcIdent : xcCompositeType.getMemberList()) {
                    this._gatherVar(xcIdent);
                }
                break;
            }
            case ENUM: {
                XcEnumType xcEnumType = (XcEnumType)xcType;
                if (xcEnumType.getEnumeratorList() == null) break;
                for (XcIdent xcIdent : xcEnumType.getEnumeratorList()) {
                    this._gatherVar(xcIdent);
                }
                break;
            }
        }
    }

    public static final class MoeConstant
    extends XcIdent {
        private XcEnumType _enumType;

        public MoeConstant(String string, XcEnumType xcEnumType) {
            super(string);
            this._enumType = xcEnumType;
        }

        public XcEnumType getEnumType() {
            return this._enumType;
        }
    }
}

