/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import xcodeml.c.decompile.XcAppendable;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;
import xcodeml.util.XmOption;
import xcodeml.util.XmStringUtil;

public final class XcSourcePosObj
implements XcAppendable {
    private String _filePath;
    private int _lineNum;
    private int _rawLineNum;

    public XcSourcePosObj(String string, int n, int n2) {
        this._filePath = XmStringUtil.trim((String)string);
        this._lineNum = n;
        this._rawLineNum = n2;
    }

    public XcSourcePosObj(String string, String string2, String string3) {
        this._filePath = XmStringUtil.trim((String)string);
        if (string2 != null) {
            try {
                this._lineNum = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid line number");
            }
        }
        if (string3 != null) {
            try {
                this._rawLineNum = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid raw line number");
            }
        }
    }

    public final String getFilePath() {
        return this._filePath;
    }

    public final int getLineNum() {
        return this._lineNum;
    }

    @Override
    public void appendCode(XmcWriter xmcWriter) throws XmException {
        if (XmOption.isSuppressLineDirective()) {
            return;
        }
        if (this._lineNum <= 0 || this._filePath == null) {
            return;
        }
        xmcWriter.noLfOrLf().add("# ").add(this._lineNum);
        if (this._filePath != null) {
            xmcWriter.add(" \"").add(this._filePath);
            if (xmcWriter.getIsDebugMode() && this._rawLineNum > 0) {
                xmcWriter.addSpc("(raw line = ").addSpc(this._rawLineNum).add(")");
            }
            xmcWriter.add("\"");
        }
        xmcWriter.lf();
    }
}

