/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import java.util.ArrayList;
import java.util.List;
import xcodeml.c.decompile.XcDecAndDefObj;
import xcodeml.c.decompile.XcDeclObj;
import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcFuncDefObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.decompile.XcRefObj;
import xcodeml.c.decompile.XcXmpFactory;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcIdentTable;
import xcodeml.c.type.XcType;
import xcodeml.c.type.XcTypeEnum;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;
import xcodeml.util.XmOption;

public final class XcProgramObj
extends XcObj {
    private List<XcDecAndDefObj> _declAndDefList = new ArrayList<XcDecAndDefObj>();
    private XcIdentTable _identTable;
    private String _language;
    private String _time;
    private String _version;
    private String _source;
    private String _compilerInfo;
    private XcFuncDefObj _xmpMain = null;

    public final void setIdentTable(XcIdentTable xcIdentTable) {
        this._identTable = xcIdentTable;
    }

    public final void addDeclAndDef(XcDecAndDefObj xcDecAndDefObj) {
        this._declAndDefList.add(xcDecAndDefObj);
    }

    public final List<XcDecAndDefObj> getDeclAndDefList() {
        return this._declAndDefList;
    }

    public final String getLanguage() {
        return this._language;
    }

    public final void setLanguage(String string) {
        this._language = string;
    }

    public final String getTime() {
        return this._time;
    }

    public final void setTime(String string) {
        this._time = string;
    }

    public final String getVersion() {
        return this._version;
    }

    public final void setVersion(String string) {
        this._version = string;
    }

    public final String getSource() {
        return this._source;
    }

    public final void setSource(String string) {
        this._source = string;
    }

    public final String getCompilerInfo() {
        return this._compilerInfo;
    }

    public final void setCompilerInfo(String string) {
        this._compilerInfo = string;
    }

    @Override
    public void addChild(XcNode xcNode) {
        if (!(xcNode instanceof XcDecAndDefObj)) {
            throw new IllegalArgumentException(xcNode.getClass().getName());
        }
        this.addDeclAndDef((XcDecAndDefObj)xcNode);
    }

    @Override
    public void checkChild() {
    }

    @Override
    public XcNode[] getChild() {
        if (this._declAndDefList.isEmpty()) {
            return null;
        }
        return this._declAndDefList.toArray(new XcNode[this._declAndDefList.size()]);
    }

    @Override
    public final void setChild(int n, XcNode xcNode) {
        if (n >= this._declAndDefList.size()) {
            throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
        }
        this._declAndDefList.set(n, (XcDecAndDefObj)xcNode);
    }

    private void _renameXmpMain() {
        XcFuncDefObj xcFuncDefObj = this._findMainFunc();
        if (xcFuncDefObj == null) {
            return;
        }
        ArrayList<XcIdent> arrayList = new ArrayList<XcIdent>();
        for (XcDecAndDefObj xcDecAndDefObj : this._declAndDefList) {
            XcDeclObj xcDeclObj;
            XcIdent xcIdent;
            XcType xcType;
            if (!(xcDecAndDefObj instanceof XcDeclObj) || (xcType = (xcIdent = (xcDeclObj = (XcDeclObj)xcDecAndDefObj).getIdent()).getType()).getTypeEnum() != XcTypeEnum.COARRAY) continue;
            arrayList.add(xcIdent);
        }
        XcXmpFactory.renameMain(xcFuncDefObj);
    }

    private XcFuncDefObj _findMainFunc() {
        for (XcDecAndDefObj xcDecAndDefObj : this._declAndDefList) {
            XcFuncDefObj xcFuncDefObj;
            if (!(xcDecAndDefObj instanceof XcFuncDefObj) || !(xcFuncDefObj = (XcFuncDefObj)xcDecAndDefObj).isMain()) continue;
            return xcFuncDefObj;
        }
        return null;
    }

    public final void writeTo(XmcWriter xmcWriter) throws XmException {
        xmcWriter.add("/*").lf();
        xmcWriter.add(" * Original Source  : ").add(this._source).lf();
        xmcWriter.add(" * Language         : ").add(this._language).lf();
        xmcWriter.add(" * Compiled Time    : ").add(this._time).lf();
        xmcWriter.add(" * Compiler Info    : ").add(this._compilerInfo).lf();
        xmcWriter.add(" * Compiler Version : ").add(this._version).lf();
        xmcWriter.add(" */").lf();
        this.appendCode(xmcWriter);
    }

    @Override
    public final void appendCode(XmcWriter xmcWriter) throws XmException {
        if (!XmOption.isSuppressLineDirective()) {
            xmcWriter.noLfOrLf().add("# 1 ").add("\"").add(this._source).add("\"").lf();
        }
        if (this._identTable != null) {
            this._identTable.appendCode(xmcWriter, this._declAndDefList);
        } else {
            for (XcDecAndDefObj xcDecAndDefObj : this._declAndDefList) {
                xmcWriter.add(xcDecAndDefObj);
            }
        }
    }

    final void reduce() {
        XcProgramObj._reduce(this);
    }

    private static XcNode _reduce(XcNode xcNode) {
        if (xcNode == null) {
            return null;
        }
        XcNode[] xcNodeArray = xcNode.getChild();
        if (xcNodeArray != null) {
            for (int i = 0; i < xcNodeArray.length; ++i) {
                XcNode xcNode2 = xcNodeArray[i];
                XcNode xcNode3 = XcProgramObj._reduce(xcNode2);
                if (xcNode3 == null) continue;
                xcNode.setChild(i, xcNode3);
            }
        }
        if (xcNode instanceof XcExprObj) {
            return XcProgramObj._reduceExprObj((XcExprObj)xcNode);
        }
        return null;
    }

    private static final XcNode _reduceExprObj(XcExprObj xcExprObj) {
        XcRefObj.PointerRef pointerRef;
        if (xcExprObj instanceof XcRefObj.PointerRef && (pointerRef = (XcRefObj.PointerRef)xcExprObj).getExpr() instanceof XcRefObj.Addr) {
            XcRefObj.Addr addr = (XcRefObj.Addr)pointerRef.getExpr();
            return addr.getExpr();
        }
        return null;
    }
}

