/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.decompile.XcOperatorEnum;
import xcodeml.c.decompile.XcOperatorTypeEnum;
import xcodeml.c.decompile.XcSizeOfExprObj;
import xcodeml.c.decompile.XcXmpCoArrayParent;
import xcodeml.c.obj.XcNode;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public class XcOperatorObj
extends XcObj
implements XcExprObj,
XcXmpCoArrayParent {
    private XcOperatorEnum _opeEnum;
    private XcExprObj[] _exprs;

    public XcOperatorObj() {
    }

    public XcOperatorObj(XcOperatorEnum xcOperatorEnum) {
        this._opeEnum = xcOperatorEnum;
    }

    public XcOperatorObj(XcOperatorEnum xcOperatorEnum, XcExprObj[] xcExprObjArray) {
        int n = xcOperatorEnum.getOperatorType().getNumOfExprs();
        if (xcExprObjArray == null || n > 0 && xcExprObjArray.length != n) {
            throw new IllegalArgumentException("number of expression for the operator is invalid : " + (xcExprObjArray == null ? "0" : Integer.valueOf(xcExprObjArray.length)));
        }
        this._exprs = xcExprObjArray;
        this._opeEnum = xcOperatorEnum;
    }

    public boolean isAssignExpr() {
        return XcOperatorTypeEnum.ASSIGN.equals((Object)this._opeEnum.getOperatorType());
    }

    public XcOperatorObj(XcOperatorEnum xcOperatorEnum, XcExprObj xcExprObj) throws XmException {
        this(xcOperatorEnum, new XcExprObj[]{xcExprObj});
    }

    public XcOperatorObj(XcOperatorEnum xcOperatorEnum, XcExprObj xcExprObj, XcExprObj xcExprObj2) throws XmException {
        this(xcOperatorEnum, new XcExprObj[]{xcExprObj, xcExprObj2});
    }

    public XcOperatorObj(XcOperatorEnum xcOperatorEnum, XcExprObj xcExprObj, XcExprObj xcExprObj2, XcExprObj xcExprObj3) throws XmException {
        this(xcOperatorEnum, new XcExprObj[]{xcExprObj, xcExprObj2, xcExprObj3});
    }

    public final XcOperatorEnum getOperatorEnum() {
        return this._opeEnum;
    }

    public final XcExprObj[] getExprObjs() {
        return this._exprs;
    }

    @Override
    public void addChild(XcNode xcNode) {
        if (xcNode instanceof XcExprObj) {
            if (this._exprs == null) {
                this._exprs = new XcExprObj[this._opeEnum.getOperatorType().getNumOfExprs()];
            }
            for (int i = 0; i < this._exprs.length; ++i) {
                if (this._exprs[i] != null) continue;
                this._exprs[i] = (XcExprObj)xcNode;
                return;
            }
            throw new IllegalArgumentException("too many terms : " + xcNode.getClass().getName());
        }
        throw new IllegalArgumentException(xcNode.getClass().getName());
    }

    @Override
    public void checkChild() {
        if (this instanceof LabelAddrExpr) {
            ((LabelAddrExpr)this).checkChild();
        } else {
            int n = this._opeEnum.getOperatorType().getNumOfExprs();
            if (this._exprs == null || n > 0 && this._exprs.length != n) {
                throw new IllegalArgumentException("number of expression for the operator is invalid : " + (this._exprs == null ? "0" : Integer.valueOf(this._exprs.length)));
            }
        }
    }

    @Override
    public XcNode[] getChild() {
        if (this._exprs == null) {
            return null;
        }
        switch (this._exprs.length) {
            case 1: {
                return new XcNode[]{this._exprs[0]};
            }
            case 2: {
                return new XcNode[]{this._exprs[0], this._exprs[1]};
            }
        }
        return new XcNode[]{this._exprs[0], this._exprs[1], this._exprs[2]};
    }

    @Override
    public final void setChild(int n, XcNode xcNode) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this._exprs[n] = (XcExprObj)xcNode;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
            }
        }
    }

    @Override
    public final void appendCode(XmcWriter xmcWriter) throws XmException {
        String string = this._opeEnum.getCode();
        switch (this._opeEnum.getOperatorType()) {
            case UNARY_PRE: {
                xmcWriter.add(string).addBraceIfNeeded(this._exprs[0]);
                break;
            }
            case UNARY_POST: {
                xmcWriter.spc().addBraceIfNeeded(this._exprs[0]).add(string);
                break;
            }
            case ASSIGN: 
            case BINARY: 
            case LOG: {
                xmcWriter.spc().addBraceIfNeeded(this._exprs[0]).addSpc(string).spc().addBraceIfNeeded(this._exprs[1]);
                break;
            }
            case COND: {
                if (this._exprs[2] == null) {
                    xmcWriter.spc().addBraceIfNeeded(this._exprs[0]).addSpc(string).addSpc(":").spc().addBraceIfNeeded(this._exprs[1]);
                    break;
                }
                xmcWriter.spc().addBraceIfNeeded(this._exprs[0]).addSpc(string).addBraceIfNeeded(this._exprs[1]).addSpc(":").spc().addBraceIfNeeded(this._exprs[2]);
                break;
            }
            case COMMA: {
                xmcWriter.add("(");
                for (int i = 0; i < this._exprs.length; ++i) {
                    if (i > 0) {
                        xmcWriter.add(string).spc();
                    }
                    xmcWriter.add(this._exprs[i]);
                }
                xmcWriter.add(")");
                break;
            }
            case SIZEOF: {
                if (this instanceof XcSizeOfExprObj) {
                    xmcWriter.add(string).addBrace(((XcSizeOfExprObj)this).getTypeName());
                    break;
                }
                xmcWriter.spc().add(string).addBrace(this._exprs[0]);
                break;
            }
            case LABELADDR: {
                xmcWriter.add(string).add(((LabelAddrExpr)this).getLabel());
            }
        }
    }

    @Override
    public void setCoArrayContent(XcExprObj xcExprObj) {
        this._exprs[0] = xcExprObj;
    }

    public class LabelAddrExpr
    extends XcOperatorObj {
        private String _label;

        public String getLabel() {
            return this._label;
        }

        public LabelAddrExpr(String string) {
            super(XcOperatorEnum.LABELADDR);
            this._label = string;
        }

        @Override
        public void checkChild() {
            if (this._label == null) {
                throw new IllegalArgumentException("number of expression for the operator is invalid : 0");
            }
        }
    }
}

