/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xcodeml.c.decompile.XcConstObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.decompile.XcOperandObj;
import xcodeml.c.decompile.XcStmtObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public class XcGccAsmStmtObj
extends XcStmtObj {
    private XcConstObj.StringConst _asmCode;
    private List<XcOperandObj> _inputOperands = null;
    private List<XcOperandObj> _outputOperands = null;
    private List<XcConstObj.StringConst> _clobberList = new ArrayList<XcConstObj.StringConst>();
    private boolean _isVolatile;
    private boolean _isInputOperandsEnd = false;

    public void setIsVolatile(boolean bl) {
        this._isVolatile = bl;
    }

    public boolean getIsVolatile() {
        return this._isVolatile;
    }

    public void setAsmCode(XcConstObj.StringConst stringConst) {
        this._asmCode = stringConst;
    }

    public XcConstObj.StringConst getAsmCode() {
        return this._asmCode;
    }

    public void initInputOperands() {
        this._inputOperands = new ArrayList<XcOperandObj>();
    }

    public void initOutputOperands() {
        this._outputOperands = new ArrayList<XcOperandObj>();
    }

    public void setInputOperandsEnd() {
        this._isInputOperandsEnd = true;
    }

    @Override
    public void addChild(XcNode xcNode) {
        if (xcNode instanceof XcOperandObj) {
            if (this._isInputOperandsEnd) {
                this._outputOperands.add((XcOperandObj)xcNode);
            } else {
                this._inputOperands.add((XcOperandObj)xcNode);
            }
        } else if (xcNode instanceof XcConstObj.StringConst) {
            this._clobberList.add((XcConstObj.StringConst)xcNode);
        }
    }

    @Override
    public void checkChild() {
        if (this._asmCode == null) {
            // empty if block
        }
    }

    @Override
    public XcNode[] getChild() {
        return null;
    }

    @Override
    public void setChild(int n, XcNode xcNode) {
    }

    @Override
    public void appendCode(XmcWriter xmcWriter) throws XmException {
        Iterator<XcObj> iterator;
        super.appendCode(xmcWriter);
        xmcWriter.add("__asm__");
        if (this._isVolatile) {
            xmcWriter.addSpc("volatile");
        }
        xmcWriter.add("(").add(this._asmCode);
        if (this._inputOperands != null) {
            xmcWriter.addSpc(":");
            iterator = this._inputOperands.iterator();
            while (iterator.hasNext()) {
                xmcWriter.addSpc(iterator.next());
                if (!iterator.hasNext()) continue;
                xmcWriter.addSpc(",");
            }
        }
        if (this._outputOperands != null) {
            xmcWriter.addSpc(":");
            iterator = this._outputOperands.iterator();
            while (iterator.hasNext()) {
                xmcWriter.addSpc(iterator.next());
                if (!iterator.hasNext()) continue;
                xmcWriter.addSpc(",");
            }
        }
        if (this._clobberList.size() > 0) {
            xmcWriter.addSpc(":");
            iterator = this._clobberList.iterator();
            while (iterator.hasNext()) {
                xmcWriter.addSpc(iterator.next());
                if (!iterator.hasNext()) continue;
                xmcWriter.addSpc(",");
            }
        }
        xmcWriter.add(")").eos();
    }
}

