/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import xcodeml.c.decompile.XcCompStmtObj;
import xcodeml.c.decompile.XcDecAndDefObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.decompile.XcSourcePosObj;
import xcodeml.c.decompile.XcSourcePositioned;
import xcodeml.c.decompile.XcStmtObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcFuncType;
import xcodeml.c.type.XcGccAttributable;
import xcodeml.c.type.XcGccAttributeList;
import xcodeml.c.type.XcIdent;
import xcodeml.c.type.XcParamList;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public class XcFuncDefObj
extends XcObj
implements XcDecAndDefObj,
XcGccAttributable,
XcSourcePositioned {
    private XcIdent _ident;
    private XcCompStmtObj _compStmt;
    private boolean _isGccExtension;
    private XcSourcePosObj _srcPos;
    private XcParamList _paramList = new XcParamList();
    private XcGccAttributeList _gccAttrs;

    public boolean isEllipsised() {
        return this._paramList.isEllipsised();
    }

    public void setIsEllipsised(boolean bl) {
        this._paramList.setIsEllipsised(bl);
    }

    public final void addParam(XcIdent xcIdent) {
        this._paramList.add(xcIdent);
    }

    public XcFuncDefObj(XcIdent xcIdent) {
        this._ident = xcIdent;
    }

    public XcFuncDefObj(XcIdent xcIdent, XcCompStmtObj xcCompStmtObj) {
        this._ident = xcIdent;
        this._compStmt = xcCompStmtObj;
    }

    @Override
    public final XcSourcePosObj getSourcePos() {
        return this._srcPos;
    }

    @Override
    public final void setSourcePos(XcSourcePosObj xcSourcePosObj) {
        this._srcPos = xcSourcePosObj;
    }

    public final XcIdent getIdent() {
        return this._ident;
    }

    public final XcCompStmtObj getCompStmt() {
        return this._compStmt;
    }

    public final XcParamList getParamList() {
        return this._paramList;
    }

    public final void setIsGccExtension(boolean bl) {
        this._isGccExtension = bl;
    }

    @Override
    public void addChild(XcNode xcNode) {
        if (xcNode instanceof XcCompStmtObj) {
            if (this._compStmt == null) {
                this._compStmt = (XcCompStmtObj)xcNode;
            } else {
                this._compStmt.addChild(xcNode);
            }
        } else if (xcNode instanceof XcStmtObj || xcNode instanceof XcFuncDefObj) {
            if (this._compStmt == null) {
                this._compStmt = new XcCompStmtObj();
            }
            this._compStmt.addChild(xcNode);
        } else if (xcNode instanceof XcGccAttributeList) {
            this._gccAttrs = (XcGccAttributeList)xcNode;
        } else {
            throw new IllegalArgumentException(xcNode.getClass().getName());
        }
    }

    @Override
    public void checkChild() {
    }

    @Override
    public XcNode[] getChild() {
        return XcFuncDefObj.toNodeArray(this._compStmt);
    }

    @Override
    public final void setChild(int n, XcNode xcNode) {
        switch (n) {
            case 0: {
                this._compStmt = (XcCompStmtObj)xcNode;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
            }
        }
    }

    @Override
    public void appendCode(XmcWriter xmcWriter) throws XmException {
        boolean bl = false;
        XcFuncType xcFuncType = (XcFuncType)this._ident.getType();
        xmcWriter.add(this._srcPos);
        bl = xcFuncType.isPreDecl();
        xcFuncType.setIsPreDecl(this._compStmt == null);
        XcParamList xcParamList = xcFuncType.getParamList();
        xcFuncType.setParamList(this._paramList);
        if (this._isGccExtension) {
            xmcWriter.add("__extension__ ");
        }
        this._ident.appendFuncDeclCode(xmcWriter, false, this._gccAttrs);
        xcFuncType.setParamList(xcParamList);
        xcFuncType.setIsPreDecl(bl);
        if (this._compStmt != null) {
            xmcWriter.lf().add(this._compStmt);
        } else {
            xmcWriter.lf().add("{").lf().add("}").lf();
        }
    }

    @Override
    public void setGccAttribute(XcGccAttributeList xcGccAttributeList) {
        this._gccAttrs = xcGccAttributeList;
    }

    @Override
    public XcGccAttributeList getGccAttribute() {
        return this._gccAttrs;
    }

    public String getSymbol() {
        if (this._ident == null) {
            return null;
        }
        return this._ident.getSymbol();
    }

    public void setSymbol(String string) {
        if (this._ident == null) {
            return;
        }
        this._ident.setSymbol(string);
    }

    public boolean isMain() {
        if (this._ident == null) {
            return false;
        }
        String string = this._ident.getSymbol();
        return string.equals("main");
    }
}

