/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import xcodeml.c.decompile.XcControlStmtEnum;
import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcNameObj;
import xcodeml.c.decompile.XcNullExpr;
import xcodeml.c.decompile.XcOperatorObj;
import xcodeml.c.decompile.XcStmtObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmException;

public abstract class XcControlStmtObj
extends XcStmtObj {
    private XcControlStmtEnum _controlStmtEnum;

    private XcControlStmtObj(XcControlStmtEnum xcControlStmtEnum) {
        this._controlStmtEnum = xcControlStmtEnum;
    }

    public final XcControlStmtEnum getControlStmtEnum() {
        return this._controlStmtEnum;
    }

    protected boolean _isAssignExpr(XcExprObj xcExprObj) {
        if (!(xcExprObj instanceof XcOperatorObj)) {
            return false;
        }
        return ((XcOperatorObj)xcExprObj).isAssignExpr();
    }

    public String toString() {
        return this._controlStmtEnum.toString();
    }

    public static final class GccRangedCaseLabel
    extends XcControlStmtObj {
        private XcExprObj _lowerValue;
        private XcExprObj _upperValue;

        public GccRangedCaseLabel() {
            super(XcControlStmtEnum.GCC_RANGED_CASE_LABEL);
        }

        public GccRangedCaseLabel(XcExprObj xcExprObj, XcExprObj xcExprObj2) {
            super(XcControlStmtEnum.GCC_RANGED_CASE_LABEL);
            this._lowerValue = xcExprObj;
            this._upperValue = xcExprObj2;
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcExprObj) {
                if (this._lowerValue == null) {
                    this._lowerValue = (XcExprObj)xcNode;
                } else {
                    this._upperValue = (XcExprObj)xcNode;
                }
            } else {
                throw new IllegalArgumentException(xcNode.getClass().getName());
            }
        }

        @Override
        public XcNode[] getChild() {
            return GccRangedCaseLabel.toNodeArray(this._lowerValue, this._upperValue);
        }

        @Override
        public void checkChild() {
            if (this._lowerValue == null || this._upperValue == null) {
                throw new IllegalArgumentException("no case label");
            }
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this._lowerValue = (XcExprObj)xcNode;
                    break;
                }
                case 1: {
                    this._upperValue = (XcExprObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("case ");
            xmcWriter.add(this._lowerValue);
            xmcWriter.add(" ... ");
            xmcWriter.add(this._upperValue);
            xmcWriter.add(":");
        }
    }

    public static final class Goto
    extends XcControlStmtObj {
        private XcNameObj _addr;

        public Goto() {
            super(XcControlStmtEnum.GOTO);
        }

        public final XcNameObj getAddr() {
            return this._addr;
        }

        public final void setAddr(XcNameObj xcNameObj) {
            this._addr = xcNameObj;
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (!(xcNode instanceof XcNameObj)) {
                throw new IllegalArgumentException(xcNode.getClass().getName());
            }
            this._addr = (XcNameObj)xcNode;
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this._addr = (XcNameObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public XcNode[] getChild() {
            return Goto.toNodeArray(this._addr);
        }

        @Override
        public void checkChild() {
            if (this._addr == null) {
                throw new IllegalArgumentException("no label name or address expression");
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("goto ").add(this._addr).eos();
        }
    }

    public static final class Label
    extends XcControlStmtObj {
        private String _name;

        public Label(String string) {
            super(XcControlStmtEnum.STMT_LABEL);
            this._name = string;
        }

        @Override
        public void addChild(XcNode xcNode) {
            throw new IllegalArgumentException(xcNode.getClass().getName());
        }

        @Override
        public XcNode[] getChild() {
            return null;
        }

        @Override
        public void checkChild() {
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add(this._name).addSpc(":");
        }
    }

    public static final class CaseLabel
    extends XcControlStmtObj {
        private XcExprObj _value;

        public CaseLabel() {
            this((XcExprObj)null);
        }

        public CaseLabel(XcExprObj xcExprObj) {
            super(XcControlStmtEnum.CASE_LABEL);
            this._value = xcExprObj;
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (!(xcNode instanceof XcExprObj)) {
                throw new IllegalArgumentException(xcNode.getClass().getName());
            }
            this._value = (XcExprObj)xcNode;
        }

        @Override
        public XcNode[] getChild() {
            return CaseLabel.toNodeArray(this._value);
        }

        @Override
        public void checkChild() {
            if (this._value == null) {
                throw new IllegalArgumentException("no case label");
            }
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this._value = (XcExprObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("case ");
            xmcWriter.add(this._value);
            xmcWriter.add(":");
        }
    }

    public static final class DefaultLabel
    extends Leaf {
        public DefaultLabel() {
            super(XcControlStmtEnum.DEFAULT_LABEL);
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("default:");
        }
    }

    public static final class Break
    extends Leaf {
        public Break() {
            super(XcControlStmtEnum.BREAK);
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("break").eos();
        }
    }

    public static final class Continue
    extends Leaf {
        public Continue() {
            super(XcControlStmtEnum.CONTINUE);
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("continue").eos();
        }
    }

    public static abstract class Leaf
    extends XcControlStmtObj {
        private Leaf(XcControlStmtEnum xcControlStmtEnum) {
            super(xcControlStmtEnum);
        }

        @Override
        public void addChild(XcNode xcNode) {
            throw new IllegalArgumentException(xcNode.getClass().getName());
        }

        @Override
        public XcNode[] getChild() {
            return null;
        }

        @Override
        public void checkChild() {
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
        }
    }

    public static final class Return
    extends XcControlStmtObj {
        private XcExprObj _expr;

        public Return() {
            this((XcExprObj)null);
        }

        public Return(XcExprObj xcExprObj) {
            super(XcControlStmtEnum.RETURN);
            this._expr = xcExprObj;
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (!(xcNode instanceof XcExprObj)) {
                throw new IllegalArgumentException();
            }
            this._expr = (XcExprObj)xcNode;
        }

        @Override
        public XcNode[] getChild() {
            return Return.toNodeArray(this._expr);
        }

        @Override
        public void checkChild() {
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this._expr = (XcExprObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("return");
            if (this._expr != null) {
                xmcWriter.add(" ").add(this._expr).eos();
            } else {
                xmcWriter.eos();
            }
        }
    }

    public static final class Switch
    extends Conditional {
        private XcStmtObj _stmt;

        public Switch() {
            super(XcControlStmtEnum.SWITCH);
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcExprObj) {
                this.setCondExpr((XcExprObj)xcNode);
            } else if (xcNode instanceof XcStmtObj) {
                this._stmt = (XcStmtObj)xcNode;
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public XcNode[] getChild() {
            return Switch.toNodeArray(this.getCondExpr(), this._stmt);
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this.setCondExpr((XcExprObj)xcNode);
                    break;
                }
                case 1: {
                    this._stmt = (XcStmtObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            xmcWriter.add("switch").addBrace(this.getCondExpr()).add(this._stmt);
        }
    }

    public static final class For
    extends XcControlStmtObj {
        private XcExprObj _initDecls;
        private XcExprObj _condExpr;
        private XcExprObj _incrExpr;
        private XcStmtObj _stmt;

        public For() {
            super(XcControlStmtEnum.FOR);
        }

        public final void setInitDecls(XcExprObj xcExprObj) {
            this._initDecls = xcExprObj;
        }

        public final void setCondExpr(XcExprObj xcExprObj) {
            this._condExpr = xcExprObj;
        }

        public final void setIncrExpr(XcExprObj xcExprObj) {
            this._incrExpr = xcExprObj;
        }

        public final void setStmt(XcStmtObj xcStmtObj) {
            this._stmt = xcStmtObj;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcStmtObj) {
                this._stmt = (XcStmtObj)xcNode;
                return;
            } else if (xcNode instanceof XcNullExpr) {
                if (this._initDecls == null) {
                    this._initDecls = (XcNullExpr)xcNode;
                    return;
                } else if (this._condExpr == null) {
                    this._condExpr = (XcNullExpr)xcNode;
                    return;
                } else {
                    if (this._incrExpr != null) throw new IllegalArgumentException(xcNode.getClass().getName());
                    this._incrExpr = (XcNullExpr)xcNode;
                }
                return;
            } else {
                if (!(xcNode instanceof XcExprObj)) throw new IllegalArgumentException(xcNode.getClass().getName());
                if (this._initDecls == null) {
                    this._initDecls = (XcExprObj)xcNode;
                    return;
                } else if (this._condExpr == null) {
                    this._condExpr = (XcExprObj)xcNode;
                    return;
                } else {
                    if (this._incrExpr != null) throw new IllegalArgumentException(xcNode.getClass().getName());
                    this._incrExpr = (XcExprObj)xcNode;
                }
            }
        }

        @Override
        public XcNode[] getChild() {
            return For.toNodeArray(this._initDecls, this._condExpr, this._incrExpr, this._stmt);
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this._initDecls = (XcExprObj)xcNode;
                    break;
                }
                case 1: {
                    this._condExpr = (XcExprObj)xcNode;
                    break;
                }
                case 2: {
                    this._incrExpr = (XcExprObj)xcNode;
                    break;
                }
                case 3: {
                    this._stmt = (XcStmtObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public void checkChild() {
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            boolean bl = this._isAssignExpr(this._condExpr);
            xmcWriter.add("for(").addSpc(this._initDecls);
            xmcWriter.add(";");
            if (bl) {
                xmcWriter.add("(");
            }
            xmcWriter.addSpc(this._condExpr);
            if (bl) {
                xmcWriter.add(")");
            }
            xmcWriter.add(";");
            xmcWriter.addSpc(this._incrExpr).add(")");
            if (this._stmt != null) {
                xmcWriter.addSpc(this._stmt);
            } else {
                xmcWriter.eos();
            }
        }
    }

    public static final class Do
    extends Conditional {
        private XcStmtObj _stmt;

        public Do() {
            super(XcControlStmtEnum.DO);
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcExprObj) {
                this.setCondExpr((XcExprObj)xcNode);
            } else if (xcNode instanceof XcStmtObj) {
                this._stmt = (XcStmtObj)xcNode;
            } else {
                throw new IllegalArgumentException(xcNode.getClass().getName());
            }
        }

        @Override
        public XcNode[] getChild() {
            return Do.toNodeArray(this.getCondExpr(), this._stmt);
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this.setCondExpr((XcExprObj)xcNode);
                    break;
                }
                case 1: {
                    this._stmt = (XcStmtObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            boolean bl = this._isAssignExpr(this.getCondExpr());
            xmcWriter.add("do");
            if (this._stmt != null) {
                xmcWriter.addSpc(this._stmt);
            } else {
                xmcWriter.add(";");
            }
            xmcWriter.addSpc("while");
            if (bl) {
                xmcWriter.add("(");
            }
            xmcWriter.addBrace(this.getCondExpr());
            if (bl) {
                xmcWriter.add(")");
            }
            xmcWriter.eos();
        }
    }

    public static final class While
    extends Conditional {
        private XcStmtObj _stmt;

        public While() {
            super(XcControlStmtEnum.WHILE);
        }

        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcExprObj) {
                this.setCondExpr((XcExprObj)xcNode);
            } else if (xcNode instanceof XcStmtObj) {
                this._stmt = (XcStmtObj)xcNode;
            } else {
                throw new IllegalArgumentException(xcNode.getClass().getName());
            }
        }

        @Override
        public XcNode[] getChild() {
            return While.toNodeArray(this.getCondExpr(), this._stmt);
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this.setCondExpr((XcExprObj)xcNode);
                    break;
                }
                case 1: {
                    this._stmt = (XcStmtObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            boolean bl = this._isAssignExpr(this.getCondExpr());
            xmcWriter.add("while");
            if (bl) {
                xmcWriter.add("(");
            }
            xmcWriter.addBrace(this.getCondExpr());
            if (bl) {
                xmcWriter.add(")");
            }
            if (this._stmt != null) {
                xmcWriter.addSpc(this._stmt);
            } else {
                xmcWriter.eos();
            }
        }
    }

    public static final class If
    extends Conditional {
        private XcStmtObj _thenStmt;
        private XcStmtObj _elseStmt;

        public If() {
            super(XcControlStmtEnum.IF);
        }

        public final void setThenStmt(XcStmtObj xcStmtObj) {
            this._thenStmt = xcStmtObj;
        }

        public final void setElseStmt(XcStmtObj xcStmtObj) {
            this._elseStmt = xcStmtObj;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addChild(XcNode xcNode) {
            if (xcNode instanceof XcExprObj) {
                this.setCondExpr((XcExprObj)xcNode);
                return;
            } else {
                if (!(xcNode instanceof XcStmtObj)) throw new IllegalArgumentException(xcNode.getClass().getName());
                if (this._thenStmt == null) {
                    this.setThenStmt((XcStmtObj)xcNode);
                    return;
                } else {
                    if (this._elseStmt != null) throw new IllegalArgumentException(xcNode.getClass().getName());
                    this.setElseStmt((XcStmtObj)xcNode);
                }
            }
        }

        @Override
        public XcNode[] getChild() {
            return If.toNodeArray(this.getCondExpr(), this._thenStmt, this._elseStmt);
        }

        @Override
        public final void setChild(int n, XcNode xcNode) {
            switch (n) {
                case 0: {
                    this.setCondExpr((XcExprObj)xcNode);
                    break;
                }
                case 1: {
                    this._thenStmt = (XcStmtObj)xcNode;
                    break;
                }
                case 2: {
                    this._elseStmt = (XcStmtObj)xcNode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
                }
            }
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            super.appendCode(xmcWriter);
            boolean bl = this._isAssignExpr(this.getCondExpr());
            xmcWriter.add("if");
            if (bl) {
                xmcWriter.add("(");
            }
            xmcWriter.addBrace(this.getCondExpr());
            if (bl) {
                xmcWriter.add(")");
            }
            if (this._thenStmt != null) {
                xmcWriter.addSpc(this._thenStmt);
            } else {
                xmcWriter.eos();
            }
            if (this._elseStmt != null) {
                xmcWriter.add("else ").add(this._elseStmt);
            }
        }
    }

    private static abstract class Conditional
    extends XcControlStmtObj {
        private XcExprObj _condExpr;

        public Conditional(XcControlStmtEnum xcControlStmtEnum) {
            super(xcControlStmtEnum);
        }

        public final void setCondExpr(XcExprObj xcExprObj) {
            this._condExpr = xcExprObj;
        }

        public final XcExprObj getCondExpr() {
            return this._condExpr;
        }

        @Override
        public void checkChild() {
            if (this._condExpr == null) {
                throw new IllegalArgumentException("no condition");
            }
        }
    }
}

