/*
 * Decompiled with CFR 0.152.
 */
package xcodeml.c.decompile;

import java.math.BigInteger;
import xcodeml.c.decompile.XcExprObj;
import xcodeml.c.decompile.XcObj;
import xcodeml.c.obj.XcNode;
import xcodeml.c.type.XcBaseType;
import xcodeml.c.type.XcBaseTypeEnum;
import xcodeml.c.type.XcPointerType;
import xcodeml.c.type.XcType;
import xcodeml.c.util.XmcTypeUtil;
import xcodeml.c.util.XmcWriter;
import xcodeml.util.XmBindingException;
import xcodeml.util.XmException;
import xcodeml.util.XmStringUtil;

public abstract class XcConstObj
extends XcObj
implements XcExprObj {
    private XcType _type;

    private XcConstObj(XcType xcType) {
        this._type = xcType;
    }

    public final XcType getType() {
        return this._type;
    }

    @Override
    public void addChild(XcNode xcNode) {
        throw new IllegalArgumentException(xcNode.getClass().getName());
    }

    @Override
    public void checkChild() {
    }

    @Override
    public XcNode[] getChild() {
        return null;
    }

    private static void _appendNumberLiteral(XmcWriter xmcWriter, XcType xcType, String string) {
        XcBaseTypeEnum xcBaseTypeEnum = ((XcBaseType)xcType).getBaseTypeEnum();
        String string2 = xcBaseTypeEnum.getLiteralSuffix();
        String string3 = null;
        if (string2 == null) {
            switch (xcBaseTypeEnum) {
                case INT: 
                case DOUBLE: {
                    break;
                }
                default: {
                    string3 = "(" + xcBaseTypeEnum.getCCode() + ")";
                }
            }
        }
        xmcWriter.spc().add(string3).add(string).add(string2);
    }

    @Override
    public final void setChild(int n, XcNode xcNode) {
        throw new IllegalArgumentException(n + ":" + xcNode.getClass().getName());
    }

    public static final class StringConst
    extends XcConstObj {
        private String _value;
        private boolean _isWide;
        private static XcPointerType s_chrPtrType = XmcTypeUtil.createConstCharConstPointer();

        public StringConst(String string) {
            super(s_chrPtrType);
            this._value = string;
        }

        public void setIsWide(boolean bl) {
            this._isWide = bl;
        }

        public boolean isWide() {
            return this._isWide;
        }

        public final String getValue() {
            return this._value;
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            if (this._isWide) {
                xmcWriter.add("L");
            }
            xmcWriter.add('\"').add(this._value == null ? "" : this._value).add('\"');
        }
    }

    public static final class FloatConst
    extends XcConstObj {
        private String _floatLiteral;

        public FloatConst(String string, XcBaseTypeEnum xcBaseTypeEnum) {
            super(xcBaseTypeEnum.getSingletonConstType());
            this._floatLiteral = string;
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            XcConstObj._appendNumberLiteral(xmcWriter, this.getType(), "" + this._floatLiteral);
        }
    }

    public static final class LongLongConst
    extends XcConstObj {
        private long _high;
        private long _low;
        private String _highStr;
        private String _lowStr;

        public LongLongConst(long l, long l2, XcBaseTypeEnum xcBaseTypeEnum) {
            super(xcBaseTypeEnum.getSingletonConstType());
            this._high = l;
            this._low = l2;
        }

        public LongLongConst(String string, String string2, XcBaseTypeEnum xcBaseTypeEnum) throws XmException {
            this(XmStringUtil.getAsCLong((String)string, (XmStringUtil.Radix)XmStringUtil.Radix.HEX), XmStringUtil.getAsCLong((String)string2, (XmStringUtil.Radix)XmStringUtil.Radix.HEX), xcBaseTypeEnum);
            if (!string.startsWith("0x")) {
                throw new XmBindingException("invalid hex integer value '" + string + "'");
            }
            this._highStr = string.substring(2, string.length());
            if (!string2.startsWith("0x")) {
                throw new XmBindingException("invalid hex integer value '" + string + "'");
            }
            this._lowStr = "00000000" + string2.substring(2, string2.length());
            this._lowStr = this._lowStr.substring(this._lowStr.length() - 8, this._lowStr.length());
        }

        public long getHigh() {
            return this._high;
        }

        public long getLow() {
            return this._low;
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            if (this._highStr == null || this._lowStr == null) {
                BigInteger bigInteger = new BigInteger("" + this._high).shiftLeft(32).or(new BigInteger("" + this._low));
                XcConstObj._appendNumberLiteral(xmcWriter, this.getType(), bigInteger.toString());
            } else {
                XcConstObj._appendNumberLiteral(xmcWriter, this.getType(), "0x" + this._highStr + this._lowStr);
            }
        }
    }

    public static final class IntConst
    extends XcConstObj {
        private long _value;
        private String _valueStr;

        public IntConst(long l, XcBaseTypeEnum xcBaseTypeEnum) {
            super(xcBaseTypeEnum.getSingletonConstType());
            this._value = l;
        }

        public IntConst(String string, XcBaseTypeEnum xcBaseTypeEnum) throws XmException {
            this(XmStringUtil.getAsCLong((String)string, (XmStringUtil.Radix)XmStringUtil.Radix.ALL), xcBaseTypeEnum);
            this._valueStr = string;
        }

        @Override
        public final void appendCode(XmcWriter xmcWriter) throws XmException {
            if (this._valueStr != null) {
                XcConstObj._appendNumberLiteral(xmcWriter, this.getType(), "" + this._valueStr);
            } else {
                XcConstObj._appendNumberLiteral(xmcWriter, this.getType(), "" + this._value);
            }
        }
    }
}

