module type S = sig

type (!'a, !'b) t = ('a, 'b) Hashtbl.t

(*
type ('a, 'b) t = ('a, 'b) Hashtbl.t
*)

(** Alias for {!Hashtbl.t} *)


type statistics = Hashtbl.statistics =
  {
  num_bindings: int ;
  num_buckets: int ;
  max_bucket_length: int ;
  bucket_histogram: int array }

(*
type statistics = Stdcompat__hashtbl_ext.statistics =
  {
  num_bindings: int ;
  num_buckets: int ;
  max_bucket_length: int ;
  bucket_histogram: int array }
*)
(** @since 4.00.0:
    type statistics =
      {
      num_bindings: int ;
      num_buckets: int ;
      max_bucket_length: int ;
      bucket_histogram: int array }
 *)

module type HashedType =
sig type t val equal : t -> t -> bool val hash : t -> int end
(** Alias for {!Hashtbl.HashedType} *)

(*
module type S = sig type key 
type !'a t

(*
type 'a t
*)
 val create : int -> 'a t val clear : 'a t -> unit val reset : 'a t -> unit
val copy : 'a t -> 'a t val add : 'a t -> key -> 'a -> unit
val remove : 'a t -> key -> unit val find : 'a t -> key -> 'a
val find_opt : 'a t -> key -> 'a option val find_all : 'a t -> key -> 'a list
val replace : 'a t -> key -> 'a -> unit val mem : 'a t -> key -> bool
val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Seq.t val to_seq_keys : 'a t -> key Seq.t
val to_seq_values : 'a t -> 'a Seq.t
val add_seq : 'a t -> (key * 'a) Seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
val of_seq : (key * 'a) Seq.t -> 'a t
end
*)


module type S = sig type key 
type !'a t

(*
type 'a t
*)
 val create : int -> 'a t val clear : 'a t -> unit val reset : 'a t -> unit
val copy : 'a t -> 'a t val add : 'a t -> key -> 'a -> unit
val remove : 'a t -> key -> unit val find : 'a t -> key -> 'a
val find_opt : 'a t -> key -> 'a option val find_all : 'a t -> key -> 'a list
val replace : 'a t -> key -> 'a -> unit val mem : 'a t -> key -> bool
val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Seq.t val to_seq_keys : 'a t -> key Seq.t
val to_seq_values : 'a t -> 'a Seq.t
val add_seq : 'a t -> (key * 'a) Seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
val of_seq : (key * 'a) Seq.t -> 'a t
end

(*
module type S =
sig type key type 'a t val create : int -> 'a t val clear : 'a t -> unit
val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Stdcompat__seq.t
val to_seq_keys : 'a t -> key Stdcompat__seq.t
val to_seq_values : 'a t -> 'a Stdcompat__seq.t
val add_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val of_seq : (key * 'a) Stdcompat__seq.t -> 'a t end
*)


(** @since 5.1.0:
    module type S  =
      sig
        type key
        type !'a t
        val create : int -> 'a t
        val clear : 'a t -> unit
        val reset : 'a t -> unit
        val copy : 'a t -> 'a t
        val add : 'a t -> key -> 'a -> unit
        val remove : 'a t -> key -> unit
        val find : 'a t -> key -> 'a
        val find_opt : 'a t -> key -> 'a option
        val find_all : 'a t -> key -> 'a list
        val replace : 'a t -> key -> 'a -> unit
        val mem : 'a t -> key -> bool
        val iter : (key -> 'a -> unit) -> 'a t -> unit
        val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
        val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
        val length : 'a t -> int
        val stats : 'a t -> statistics
        val to_seq : 'a t -> (key * 'a) Seq.t
        val to_seq_keys : 'a t -> key Seq.t
        val to_seq_values : 'a t -> 'a Seq.t
        val add_seq : 'a t -> (key * 'a) Seq.t -> unit
        val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
        val of_seq : (key * 'a) Seq.t -> 'a t
      end
@since 4.07.0:
module type S  =
  sig
    type key
    type !'a t
    val create : int -> 'a t
    val clear : 'a t -> unit
    val reset : 'a t -> unit
    val copy : 'a t -> 'a t
    val add : 'a t -> key -> 'a -> unit
    val remove : 'a t -> key -> unit
    val find : 'a t -> key -> 'a
    val find_opt : 'a t -> key -> 'a option
    val find_all : 'a t -> key -> 'a list
    val replace : 'a t -> key -> 'a -> unit
    val mem : 'a t -> key -> bool
    val iter : (key -> 'a -> unit) -> 'a t -> unit
    val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
    val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val length : 'a t -> int
    val stats : 'a t -> statistics
    val to_seq : 'a t -> (key * 'a) Seq.t
    val to_seq_keys : 'a t -> key Seq.t
    val to_seq_values : 'a t -> 'a Seq.t
    val add_seq : 'a t -> (key * 'a) Seq.t -> unit
    val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
    val of_seq : (key * 'a) Seq.t -> 'a t
  end
 *)


module Make = Hashtbl.Make

(*
module Make :
functor (H : HashedType) ->
sig type key = H.t type 'a t = 'a Hashtbl.Make(H).t val create : int -> 'a t
val clear : 'a t -> unit val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Stdcompat__seq.t
val to_seq_keys : 'a t -> key Stdcompat__seq.t
val to_seq_values : 'a t -> 'a Stdcompat__seq.t
val add_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val of_seq : (key * 'a) Stdcompat__seq.t -> 'a t end
*)
(** @since 4.07.0: module Make = Hashtbl.Make
 *)

(*
module type SeededHashedType =
sig type t val equal : t -> t -> bool val seeded_hash : int -> t -> int end
*)

module type SeededHashedType =
sig type t val equal : t -> t -> bool val seeded_hash : int -> t -> int end

(** @since 5.0.0:
    module type SeededHashedType  =
      sig type t val equal : t -> t -> bool val seeded_hash : int -> t -> int
      end
 *)

(*
module type SeededS = sig type key 
type !'a t

(*
type 'a t
*)
 val create : ?random:bool -> int -> 'a t val clear : 'a t -> unit
val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Seq.t val to_seq_keys : 'a t -> key Seq.t
val to_seq_values : 'a t -> 'a Seq.t
val add_seq : 'a t -> (key * 'a) Seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
val of_seq : (key * 'a) Seq.t -> 'a t
end
*)


module type SeededS = sig type key 
type !'a t

(*
type 'a t
*)
 val create : ?random:bool -> int -> 'a t val clear : 'a t -> unit
val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Seq.t val to_seq_keys : 'a t -> key Seq.t
val to_seq_values : 'a t -> 'a Seq.t
val add_seq : 'a t -> (key * 'a) Seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
val of_seq : (key * 'a) Seq.t -> 'a t
end

(*
module type SeededS =
sig type key type 'a t val create : ?random:bool -> int -> 'a t
val clear : 'a t -> unit val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Stdcompat__seq.t
val to_seq_keys : 'a t -> key Stdcompat__seq.t
val to_seq_values : 'a t -> 'a Stdcompat__seq.t
val add_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val of_seq : (key * 'a) Stdcompat__seq.t -> 'a t end
*)


(** @since 5.1.0:
    module type SeededS  =
      sig
        type key
        type !'a t
        val create : ?random:bool -> int -> 'a t
        val clear : 'a t -> unit
        val reset : 'a t -> unit
        val copy : 'a t -> 'a t
        val add : 'a t -> key -> 'a -> unit
        val remove : 'a t -> key -> unit
        val find : 'a t -> key -> 'a
        val find_opt : 'a t -> key -> 'a option
        val find_all : 'a t -> key -> 'a list
        val replace : 'a t -> key -> 'a -> unit
        val mem : 'a t -> key -> bool
        val iter : (key -> 'a -> unit) -> 'a t -> unit
        val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
        val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
        val length : 'a t -> int
        val stats : 'a t -> statistics
        val to_seq : 'a t -> (key * 'a) Seq.t
        val to_seq_keys : 'a t -> key Seq.t
        val to_seq_values : 'a t -> 'a Seq.t
        val add_seq : 'a t -> (key * 'a) Seq.t -> unit
        val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
        val of_seq : (key * 'a) Seq.t -> 'a t
      end
@since 4.07.0:
module type SeededS  =
  sig
    type key
    type !'a t
    val create : ?random:bool -> int -> 'a t
    val clear : 'a t -> unit
    val reset : 'a t -> unit
    val copy : 'a t -> 'a t
    val add : 'a t -> key -> 'a -> unit
    val remove : 'a t -> key -> unit
    val find : 'a t -> key -> 'a
    val find_opt : 'a t -> key -> 'a option
    val find_all : 'a t -> key -> 'a list
    val replace : 'a t -> key -> 'a -> unit
    val mem : 'a t -> key -> bool
    val iter : (key -> 'a -> unit) -> 'a t -> unit
    val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
    val fold : (key -> 'a -> 'b -> 'b) -> 'a t -> 'b -> 'b
    val length : 'a t -> int
    val stats : 'a t -> statistics
    val to_seq : 'a t -> (key * 'a) Seq.t
    val to_seq_keys : 'a t -> key Seq.t
    val to_seq_values : 'a t -> 'a Seq.t
    val add_seq : 'a t -> (key * 'a) Seq.t -> unit
    val replace_seq : 'a t -> (key * 'a) Seq.t -> unit
    val of_seq : (key * 'a) Seq.t -> 'a t
  end
 *)

(*
module MakeSeeded = Hashtbl.MakeSeeded
*)

module MakeSeeded :
functor (H : SeededHashedType) ->
sig type key = H.t type 'a t = 'a Stdcompat__hashtbl_ext.MakeSeeded(H).t
val create : ?random:bool -> int -> 'a t val clear : 'a t -> unit
val reset : 'a t -> unit val copy : 'a t -> 'a t
val add : 'a t -> key -> 'a -> unit val remove : 'a t -> key -> unit
val find : 'a t -> key -> 'a val find_opt : 'a t -> key -> 'a option
val find_all : 'a t -> key -> 'a list val replace : 'a t -> key -> 'a -> unit
val mem : 'a t -> key -> bool val iter : (key -> 'a -> unit) -> 'a t -> unit
val filter_map_inplace : (key -> 'a -> 'a option) -> 'a t -> unit
val fold : (key -> 'a -> 'acc -> 'acc) -> 'a t -> 'acc -> 'acc
val length : 'a t -> int val stats : 'a t -> statistics
val to_seq : 'a t -> (key * 'a) Stdcompat__seq.t
val to_seq_keys : 'a t -> key Stdcompat__seq.t
val to_seq_values : 'a t -> 'a Stdcompat__seq.t
val add_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val replace_seq : 'a t -> (key * 'a) Stdcompat__seq.t -> unit
val of_seq : (key * 'a) Stdcompat__seq.t -> 'a t end

(** @since 5.0.0: module MakeSeeded = Hashtbl.MakeSeeded
 *)

val rebuild : ?random:bool -> ('a, 'b) t -> ('a, 'b) t
(** @since 4.12.0: val rebuild : ?random:bool -> ('a, 'b) t -> ('a, 'b) t *)


val to_seq : ('a, 'b) t -> ('a * 'b) Seq.t

(*
val to_seq : ('a, 'b) t -> ('a * 'b) Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq : ('a, 'b) t -> ('a * 'b) Seq.t
 *)


val to_seq_keys : ('a, 'b) t -> 'a Seq.t

(*
val to_seq_keys : ('a, 'b) t -> 'a Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq_keys : ('a, 'b) t -> 'a Seq.t
 *)


val to_seq_values : ('a, 'b) t -> 'b Seq.t

(*
val to_seq_values : ('a, 'b) t -> 'b Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq_values : ('a, 'b) t -> 'b Seq.t
 *)


val add_seq : ('a, 'b) t -> ('a * 'b) Seq.t -> unit

(*
val add_seq : ('a, 'b) t -> ('a * 'b) Stdcompat__seq.t -> unit
*)
(** @since 4.07.0: val add_seq : ('a, 'b) t -> ('a * 'b) Seq.t -> unit
 *)


val replace_seq : ('a, 'b) t -> ('a * 'b) Seq.t -> unit

(*
val replace_seq : ('a, 'b) t -> ('a * 'b) Stdcompat__seq.t -> unit
*)
(** @since 4.07.0: val replace_seq : ('a, 'b) t -> ('a * 'b) Seq.t -> unit
 *)


val of_seq : ('a * 'b) Seq.t -> ('a, 'b) t

(*
val of_seq : ('a * 'b) Stdcompat__seq.t -> ('a, 'b) t
*)
(** @since 4.07.0: val of_seq : ('a * 'b) Seq.t -> ('a, 'b) t
 *)

val find_opt : ('a, 'b) t -> 'a -> 'b option
(** @since 4.05.0: val find_opt : ('a, 'b) t -> 'a -> 'b option *)

val filter_map_inplace : ('a -> 'b -> 'b option) -> ('a, 'b) t -> unit
(** @since 4.03.0:
    val filter_map_inplace : ('a -> 'b -> 'b option) -> ('a, 'b) t -> unit *)

val is_randomized : unit -> bool
(** @since 4.03.0: val is_randomized : unit -> bool *)

val create : ?random:bool -> int -> ('a, 'b) t
(** @since 4.00.0: val create : ?random:bool -> int -> ('a, 'b) t *)

val reset : ('a, 'b) t -> unit
(** @since 4.00.0: val reset : ('a, 'b) t -> unit *)

val randomize : unit -> unit
(** @since 4.00.0: val randomize : unit -> unit *)

val stats : ('a, 'b) t -> statistics
(** @since 4.00.0: val stats : ('a, 'b) t -> statistics *)

val seeded_hash : int -> 'a -> int
(** @since 4.00.0: val seeded_hash : int -> 'a -> int *)

val seeded_hash_param : int -> int -> int -> 'a -> int
(** @since 4.00.0: val seeded_hash_param : int -> int -> int -> 'a -> int *)

val length : ('a, 'b) t -> int
(** @since 3.08.0: val length : ('a, 'b) t -> int *)

val clear : ('a, 'b) t -> unit
(** Alias for {!Hashtbl.clear} *)

val copy : ('a, 'b) t -> ('a, 'b) t
(** Alias for {!Hashtbl.copy} *)

val add : ('a, 'b) t -> 'a -> 'b -> unit
(** Alias for {!Hashtbl.add} *)

val find : ('a, 'b) t -> 'a -> 'b
(** Alias for {!Hashtbl.find} *)

val find_all : ('a, 'b) t -> 'a -> 'b list
(** Alias for {!Hashtbl.find_all} *)

val mem : ('a, 'b) t -> 'a -> bool
(** Alias for {!Hashtbl.mem} *)

val remove : ('a, 'b) t -> 'a -> unit
(** Alias for {!Hashtbl.remove} *)

val replace : ('a, 'b) t -> 'a -> 'b -> unit
(** Alias for {!Hashtbl.replace} *)

val iter : ('a -> 'b -> unit) -> ('a, 'b) t -> unit
(** Alias for {!Hashtbl.iter} *)

(*
val fold : ('a -> 'b -> 'acc -> 'acc) -> ('a, 'b) t -> 'acc -> 'acc
*)

val fold : ('a -> 'b -> 'c -> 'c) -> ('a, 'b) t -> 'c -> 'c

(** @since 5.1.0:
    val fold : ('a -> 'b -> 'acc -> 'acc) -> ('a, 'b) t -> 'acc -> 'acc
@since 3.07.0: val fold : ('a -> 'b -> 'c -> 'c) -> ('a, 'b) t -> 'c -> 'c
 *)

val hash : 'a -> int
(** Alias for {!Hashtbl.hash} *)


val hash_param : int -> int -> 'a -> int

(*

external hash_param :
  int -> int -> 'a -> int = "caml_hash_univ_param" "noalloc"

(*
external hash_param : int -> int -> 'a -> int = "hash_univ_param" "noalloc"
*)

*)
(** @since 4.00.0: val hash_param : int -> int -> 'a -> int
@since 3.08.0:
external hash_param :
  int -> int -> 'a -> int = "caml_hash_univ_param" "noalloc"
@since 3.07.0:
external hash_param : int -> int -> 'a -> int = "hash_univ_param" "noalloc"
 *)

end
