//*****************************************************************************
//
// Copyright (C) 2021 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//
//  Redistributions of source code must retain the above copyright
//  notice, this list of conditions and the following disclaimer.
//
//  Redistributions in binary form must reproduce the above copyright
//  notice, this list of conditions and the following disclaimer in the
//  documentation and/or other materials provided with the
//  distribution.
//
//  Neither the name of Texas Instruments Incorporated nor the names of
//  its contributors may be used to endorse or promote products derived
//  from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//****************************************************************************

/********************************************************************
*
* Standard register and bit definitions for the Texas Instruments
* MSP430 microcontroller.
*
* This file supports assembler and C development for
* MSP430FR60471 devices.
*
********************************************************************/

#ifndef __MSP430FR60471
#define __MSP430FR60471

#define __MSP430_HEADER_VERSION__ 1212

#define __MSP430_HAS_MSP430XV2_CPU__  /* CPU type */
#define __MSP430FR5XX_6XX_FAMILY__

#include "in430.h"

#define __MSP430_TI_HEADERS__

#ifndef __AUTOGENERATED__
#define __AUTOGENERATED__
#endif

#ifdef __cplusplus
extern "C" {
#endif

#include <iomacros.h>

/************************************************************
* STANDARD BITS
************************************************************/

#define BIT0                (0x0001)
#define BIT1                (0x0002)
#define BIT2                (0x0004)
#define BIT3                (0x0008)
#define BIT4                (0x0010)
#define BIT5                (0x0020)
#define BIT6                (0x0040)
#define BIT7                (0x0080)
#define BIT8                (0x0100)
#define BIT9                (0x0200)
#define BITA                (0x0400)
#define BITB                (0x0800)
#define BITC                (0x1000)
#define BITD                (0x2000)
#define BITE                (0x4000)
#define BITF                (0x8000)

/************************************************************
* STATUS REGISTER BITS
************************************************************/

#define C                   (0x0001)
#define Z                   (0x0002)
#define N                   (0x0004)
#define V                   (0x0100)
#define GIE                 (0x0008)
#define CPUOFF              (0x0010)
#define OSCOFF              (0x0020)
#define SCG0                (0x0040)
#define SCG1                (0x0080)

/* Low Power Modes coded with Bits 4-7 in SR */

#ifndef __STDC__ /* Begin #defines for assembler */
#define LPM0                (CPUOFF)
#define LPM1                (SCG0+CPUOFF)
#define LPM2                (SCG1+CPUOFF)
#define LPM3                (SCG1+SCG0+CPUOFF)
#define LPM4                (SCG1+SCG0+OSCOFF+CPUOFF)
/* End #defines for assembler */

#else /* Begin #defines for C */
#define LPM0_bits           (CPUOFF)
#define LPM1_bits           (SCG0+CPUOFF)
#define LPM2_bits           (SCG1+CPUOFF)
#define LPM3_bits           (SCG1+SCG0+CPUOFF)
#define LPM4_bits           (SCG1+SCG0+OSCOFF+CPUOFF)

#define LPM0      __bis_SR_register(LPM0_bits)         /* Enter Low Power Mode 0 */
#define LPM0_EXIT __bic_SR_register_on_exit(LPM0_bits) /* Exit Low Power Mode 0 */
#define LPM1      __bis_SR_register(LPM1_bits)         /* Enter Low Power Mode 1 */
#define LPM1_EXIT __bic_SR_register_on_exit(LPM1_bits) /* Exit Low Power Mode 1 */
#define LPM2      __bis_SR_register(LPM2_bits)         /* Enter Low Power Mode 2 */
#define LPM2_EXIT __bic_SR_register_on_exit(LPM2_bits) /* Exit Low Power Mode 2 */
#define LPM3      __bis_SR_register(LPM3_bits)         /* Enter Low Power Mode 3 */
#define LPM3_EXIT __bic_SR_register_on_exit(LPM3_bits) /* Exit Low Power Mode 3 */
#define LPM4      __bis_SR_register(LPM4_bits)         /* Enter Low Power Mode 4 */
#define LPM4_EXIT __bic_SR_register_on_exit(LPM4_bits) /* Exit Low Power Mode 4 */
#endif /* End #defines for C */

/************************************************************
* PERIPHERAL FILE MAP
************************************************************/


/*****************************************************************************
 ADC12_B Registers
*****************************************************************************/

#define __MSP430_HAS_ADC12_B__                /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_ADC12_B__ 0x0800
#define ADC12_B_BASE           __MSP430_BASEADDRESS_ADC12_B__

sfr_w(ADC12CTL0);                             /* ADC12_B Control 0 */
sfr_b(ADC12CTL0_L);
sfr_b(ADC12CTL0_H);
sfr_w(ADC12CTL1);                             /* ADC12_B Control 1 */
sfr_b(ADC12CTL1_L);
sfr_b(ADC12CTL1_H);
sfr_w(ADC12CTL2);                             /* ADC12_B Control 2 */
sfr_b(ADC12CTL2_L);
sfr_b(ADC12CTL2_H);
sfr_w(ADC12CTL3);                             /* ADC12_B Control 3 */
sfr_b(ADC12CTL3_L);
sfr_b(ADC12CTL3_H);
sfr_w(ADC12LO);                               /* ADC12_B Window Comparator Low Threshold Register */
sfr_b(ADC12LO_L);
sfr_b(ADC12LO_H);
sfr_w(ADC12HI);                               /* ADC12_B Window Comparator High Threshold Register */
sfr_b(ADC12HI_L);
sfr_b(ADC12HI_H);
sfr_w(ADC12IFGR0);                            /* ADC12_B Interrupt Flag 0 */
sfr_b(ADC12IFGR0_L);
sfr_b(ADC12IFGR0_H);
sfr_w(ADC12IFGR1);                            /* ADC12_B Interrupt Flag 1 */
sfr_b(ADC12IFGR1_L);
sfr_b(ADC12IFGR1_H);
sfr_w(ADC12IFGR2);                            /* ADC12_B Interrupt Flag 2 */
sfr_b(ADC12IFGR2_L);
sfr_b(ADC12IFGR2_H);
sfr_w(ADC12IER0);                             /* ADC12_B Interrupt Enable 0 */
sfr_b(ADC12IER0_L);
sfr_b(ADC12IER0_H);
sfr_w(ADC12IER1);                             /* ADC12_B Interrupt Enable 1 */
sfr_b(ADC12IER1_L);
sfr_b(ADC12IER1_H);
sfr_w(ADC12IER2);                             /* ADC12_B Interrupt Enable 2 */
sfr_b(ADC12IER2_L);
sfr_b(ADC12IER2_H);
sfr_w(ADC12IV);                               /* ADC12_B Interrupt Vector */
sfr_b(ADC12IV_L);
sfr_b(ADC12IV_H);
sfr_w(ADC12MCTL0);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL0_L);
sfr_b(ADC12MCTL0_H);
sfr_w(ADC12MCTL1);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL1_L);
sfr_b(ADC12MCTL1_H);
sfr_w(ADC12MCTL2);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL2_L);
sfr_b(ADC12MCTL2_H);
sfr_w(ADC12MCTL3);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL3_L);
sfr_b(ADC12MCTL3_H);
sfr_w(ADC12MCTL4);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL4_L);
sfr_b(ADC12MCTL4_H);
sfr_w(ADC12MCTL5);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL5_L);
sfr_b(ADC12MCTL5_H);
sfr_w(ADC12MCTL6);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL6_L);
sfr_b(ADC12MCTL6_H);
sfr_w(ADC12MCTL7);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL7_L);
sfr_b(ADC12MCTL7_H);
sfr_w(ADC12MCTL8);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL8_L);
sfr_b(ADC12MCTL8_H);
sfr_w(ADC12MCTL9);                            /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL9_L);
sfr_b(ADC12MCTL9_H);
sfr_w(ADC12MCTL10);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL10_L);
sfr_b(ADC12MCTL10_H);
sfr_w(ADC12MCTL11);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL11_L);
sfr_b(ADC12MCTL11_H);
sfr_w(ADC12MCTL12);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL12_L);
sfr_b(ADC12MCTL12_H);
sfr_w(ADC12MCTL13);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL13_L);
sfr_b(ADC12MCTL13_H);
sfr_w(ADC12MCTL14);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL14_L);
sfr_b(ADC12MCTL14_H);
sfr_w(ADC12MCTL15);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL15_L);
sfr_b(ADC12MCTL15_H);
sfr_w(ADC12MCTL16);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL16_L);
sfr_b(ADC12MCTL16_H);
sfr_w(ADC12MCTL17);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL17_L);
sfr_b(ADC12MCTL17_H);
sfr_w(ADC12MCTL18);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL18_L);
sfr_b(ADC12MCTL18_H);
sfr_w(ADC12MCTL19);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL19_L);
sfr_b(ADC12MCTL19_H);
sfr_w(ADC12MCTL20);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL20_L);
sfr_b(ADC12MCTL20_H);
sfr_w(ADC12MCTL21);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL21_L);
sfr_b(ADC12MCTL21_H);
sfr_w(ADC12MCTL22);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL22_L);
sfr_b(ADC12MCTL22_H);
sfr_w(ADC12MCTL23);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL23_L);
sfr_b(ADC12MCTL23_H);
sfr_w(ADC12MCTL24);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL24_L);
sfr_b(ADC12MCTL24_H);
sfr_w(ADC12MCTL25);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL25_L);
sfr_b(ADC12MCTL25_H);
sfr_w(ADC12MCTL26);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL26_L);
sfr_b(ADC12MCTL26_H);
sfr_w(ADC12MCTL27);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL27_L);
sfr_b(ADC12MCTL27_H);
sfr_w(ADC12MCTL28);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL28_L);
sfr_b(ADC12MCTL28_H);
sfr_w(ADC12MCTL29);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL29_L);
sfr_b(ADC12MCTL29_H);
sfr_w(ADC12MCTL30);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL30_L);
sfr_b(ADC12MCTL30_H);
sfr_w(ADC12MCTL31);                           /* ADC12_B Memory Control 0 Register to ADC12_B Memory Control 31
                                                            Register */
sfr_b(ADC12MCTL31_L);
sfr_b(ADC12MCTL31_H);
sfr_w(ADC12MEM0);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM0_L);
sfr_b(ADC12MEM0_H);
sfr_w(ADC12MEM1);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM1_L);
sfr_b(ADC12MEM1_H);
sfr_w(ADC12MEM2);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM2_L);
sfr_b(ADC12MEM2_H);
sfr_w(ADC12MEM3);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM3_L);
sfr_b(ADC12MEM3_H);
sfr_w(ADC12MEM4);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM4_L);
sfr_b(ADC12MEM4_H);
sfr_w(ADC12MEM5);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM5_L);
sfr_b(ADC12MEM5_H);
sfr_w(ADC12MEM6);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM6_L);
sfr_b(ADC12MEM6_H);
sfr_w(ADC12MEM7);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM7_L);
sfr_b(ADC12MEM7_H);
sfr_w(ADC12MEM8);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM8_L);
sfr_b(ADC12MEM8_H);
sfr_w(ADC12MEM9);                             /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM9_L);
sfr_b(ADC12MEM9_H);
sfr_w(ADC12MEM10);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM10_L);
sfr_b(ADC12MEM10_H);
sfr_w(ADC12MEM11);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM11_L);
sfr_b(ADC12MEM11_H);
sfr_w(ADC12MEM12);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM12_L);
sfr_b(ADC12MEM12_H);
sfr_w(ADC12MEM13);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM13_L);
sfr_b(ADC12MEM13_H);
sfr_w(ADC12MEM14);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM14_L);
sfr_b(ADC12MEM14_H);
sfr_w(ADC12MEM15);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM15_L);
sfr_b(ADC12MEM15_H);
sfr_w(ADC12MEM16);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM16_L);
sfr_b(ADC12MEM16_H);
sfr_w(ADC12MEM17);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM17_L);
sfr_b(ADC12MEM17_H);
sfr_w(ADC12MEM18);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM18_L);
sfr_b(ADC12MEM18_H);
sfr_w(ADC12MEM19);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM19_L);
sfr_b(ADC12MEM19_H);
sfr_w(ADC12MEM20);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM20_L);
sfr_b(ADC12MEM20_H);
sfr_w(ADC12MEM21);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM21_L);
sfr_b(ADC12MEM21_H);
sfr_w(ADC12MEM22);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM22_L);
sfr_b(ADC12MEM22_H);
sfr_w(ADC12MEM23);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM23_L);
sfr_b(ADC12MEM23_H);
sfr_w(ADC12MEM24);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM24_L);
sfr_b(ADC12MEM24_H);
sfr_w(ADC12MEM25);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM25_L);
sfr_b(ADC12MEM25_H);
sfr_w(ADC12MEM26);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM26_L);
sfr_b(ADC12MEM26_H);
sfr_w(ADC12MEM27);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM27_L);
sfr_b(ADC12MEM27_H);
sfr_w(ADC12MEM28);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM28_L);
sfr_b(ADC12MEM28_H);
sfr_w(ADC12MEM29);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM29_L);
sfr_b(ADC12MEM29_H);
sfr_w(ADC12MEM30);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM30_L);
sfr_b(ADC12MEM30_H);
sfr_w(ADC12MEM31);                            /* ADC12_B Memory 0 Register to ADC12_B Memory 31 Register */
sfr_b(ADC12MEM31_L);
sfr_b(ADC12MEM31_H);

/* ADC12_B Register Offsets */
#define OFS_ADC12CTL0                    (0x0000)
#define OFS_ADC12CTL0_L                  OFS_ADC12CTL0
#define OFS_ADC12CTL0_H                  OFS_ADC12CTL0+1
#define OFS_ADC12CTL1                    (0x0002)
#define OFS_ADC12CTL1_L                  OFS_ADC12CTL1
#define OFS_ADC12CTL1_H                  OFS_ADC12CTL1+1
#define OFS_ADC12CTL2                    (0x0004)
#define OFS_ADC12CTL2_L                  OFS_ADC12CTL2
#define OFS_ADC12CTL2_H                  OFS_ADC12CTL2+1
#define OFS_ADC12CTL3                    (0x0006)
#define OFS_ADC12CTL3_L                  OFS_ADC12CTL3
#define OFS_ADC12CTL3_H                  OFS_ADC12CTL3+1
#define OFS_ADC12LO                      (0x0008)
#define OFS_ADC12LO_L                    OFS_ADC12LO
#define OFS_ADC12LO_H                    OFS_ADC12LO+1
#define OFS_ADC12HI                      (0x000A)
#define OFS_ADC12HI_L                    OFS_ADC12HI
#define OFS_ADC12HI_H                    OFS_ADC12HI+1
#define OFS_ADC12IFGR0                   (0x000C)
#define OFS_ADC12IFGR0_L                 OFS_ADC12IFGR0
#define OFS_ADC12IFGR0_H                 OFS_ADC12IFGR0+1
#define OFS_ADC12IFGR1                   (0x000E)
#define OFS_ADC12IFGR1_L                 OFS_ADC12IFGR1
#define OFS_ADC12IFGR1_H                 OFS_ADC12IFGR1+1
#define OFS_ADC12IFGR2                   (0x0010)
#define OFS_ADC12IFGR2_L                 OFS_ADC12IFGR2
#define OFS_ADC12IFGR2_H                 OFS_ADC12IFGR2+1
#define OFS_ADC12IER0                    (0x0012)
#define OFS_ADC12IER0_L                  OFS_ADC12IER0
#define OFS_ADC12IER0_H                  OFS_ADC12IER0+1
#define OFS_ADC12IER1                    (0x0014)
#define OFS_ADC12IER1_L                  OFS_ADC12IER1
#define OFS_ADC12IER1_H                  OFS_ADC12IER1+1
#define OFS_ADC12IER2                    (0x0016)
#define OFS_ADC12IER2_L                  OFS_ADC12IER2
#define OFS_ADC12IER2_H                  OFS_ADC12IER2+1
#define OFS_ADC12IV                      (0x0018)
#define OFS_ADC12IV_L                    OFS_ADC12IV
#define OFS_ADC12IV_H                    OFS_ADC12IV+1
#define OFS_ADC12MCTL0                   (0x0020)
#define OFS_ADC12MCTL0_L                 OFS_ADC12MCTL0
#define OFS_ADC12MCTL0_H                 OFS_ADC12MCTL0+1
#define OFS_ADC12MCTL1                   (0x0022)
#define OFS_ADC12MCTL1_L                 OFS_ADC12MCTL1
#define OFS_ADC12MCTL1_H                 OFS_ADC12MCTL1+1
#define OFS_ADC12MCTL2                   (0x0024)
#define OFS_ADC12MCTL2_L                 OFS_ADC12MCTL2
#define OFS_ADC12MCTL2_H                 OFS_ADC12MCTL2+1
#define OFS_ADC12MCTL3                   (0x0026)
#define OFS_ADC12MCTL3_L                 OFS_ADC12MCTL3
#define OFS_ADC12MCTL3_H                 OFS_ADC12MCTL3+1
#define OFS_ADC12MCTL4                   (0x0028)
#define OFS_ADC12MCTL4_L                 OFS_ADC12MCTL4
#define OFS_ADC12MCTL4_H                 OFS_ADC12MCTL4+1
#define OFS_ADC12MCTL5                   (0x002A)
#define OFS_ADC12MCTL5_L                 OFS_ADC12MCTL5
#define OFS_ADC12MCTL5_H                 OFS_ADC12MCTL5+1
#define OFS_ADC12MCTL6                   (0x002C)
#define OFS_ADC12MCTL6_L                 OFS_ADC12MCTL6
#define OFS_ADC12MCTL6_H                 OFS_ADC12MCTL6+1
#define OFS_ADC12MCTL7                   (0x002E)
#define OFS_ADC12MCTL7_L                 OFS_ADC12MCTL7
#define OFS_ADC12MCTL7_H                 OFS_ADC12MCTL7+1
#define OFS_ADC12MCTL8                   (0x0030)
#define OFS_ADC12MCTL8_L                 OFS_ADC12MCTL8
#define OFS_ADC12MCTL8_H                 OFS_ADC12MCTL8+1
#define OFS_ADC12MCTL9                   (0x0032)
#define OFS_ADC12MCTL9_L                 OFS_ADC12MCTL9
#define OFS_ADC12MCTL9_H                 OFS_ADC12MCTL9+1
#define OFS_ADC12MCTL10                  (0x0034)
#define OFS_ADC12MCTL10_L                OFS_ADC12MCTL10
#define OFS_ADC12MCTL10_H                OFS_ADC12MCTL10+1
#define OFS_ADC12MCTL11                  (0x0036)
#define OFS_ADC12MCTL11_L                OFS_ADC12MCTL11
#define OFS_ADC12MCTL11_H                OFS_ADC12MCTL11+1
#define OFS_ADC12MCTL12                  (0x0038)
#define OFS_ADC12MCTL12_L                OFS_ADC12MCTL12
#define OFS_ADC12MCTL12_H                OFS_ADC12MCTL12+1
#define OFS_ADC12MCTL13                  (0x003A)
#define OFS_ADC12MCTL13_L                OFS_ADC12MCTL13
#define OFS_ADC12MCTL13_H                OFS_ADC12MCTL13+1
#define OFS_ADC12MCTL14                  (0x003C)
#define OFS_ADC12MCTL14_L                OFS_ADC12MCTL14
#define OFS_ADC12MCTL14_H                OFS_ADC12MCTL14+1
#define OFS_ADC12MCTL15                  (0x003E)
#define OFS_ADC12MCTL15_L                OFS_ADC12MCTL15
#define OFS_ADC12MCTL15_H                OFS_ADC12MCTL15+1
#define OFS_ADC12MCTL16                  (0x0040)
#define OFS_ADC12MCTL16_L                OFS_ADC12MCTL16
#define OFS_ADC12MCTL16_H                OFS_ADC12MCTL16+1
#define OFS_ADC12MCTL17                  (0x0042)
#define OFS_ADC12MCTL17_L                OFS_ADC12MCTL17
#define OFS_ADC12MCTL17_H                OFS_ADC12MCTL17+1
#define OFS_ADC12MCTL18                  (0x0044)
#define OFS_ADC12MCTL18_L                OFS_ADC12MCTL18
#define OFS_ADC12MCTL18_H                OFS_ADC12MCTL18+1
#define OFS_ADC12MCTL19                  (0x0046)
#define OFS_ADC12MCTL19_L                OFS_ADC12MCTL19
#define OFS_ADC12MCTL19_H                OFS_ADC12MCTL19+1
#define OFS_ADC12MCTL20                  (0x0048)
#define OFS_ADC12MCTL20_L                OFS_ADC12MCTL20
#define OFS_ADC12MCTL20_H                OFS_ADC12MCTL20+1
#define OFS_ADC12MCTL21                  (0x004A)
#define OFS_ADC12MCTL21_L                OFS_ADC12MCTL21
#define OFS_ADC12MCTL21_H                OFS_ADC12MCTL21+1
#define OFS_ADC12MCTL22                  (0x004C)
#define OFS_ADC12MCTL22_L                OFS_ADC12MCTL22
#define OFS_ADC12MCTL22_H                OFS_ADC12MCTL22+1
#define OFS_ADC12MCTL23                  (0x004E)
#define OFS_ADC12MCTL23_L                OFS_ADC12MCTL23
#define OFS_ADC12MCTL23_H                OFS_ADC12MCTL23+1
#define OFS_ADC12MCTL24                  (0x0050)
#define OFS_ADC12MCTL24_L                OFS_ADC12MCTL24
#define OFS_ADC12MCTL24_H                OFS_ADC12MCTL24+1
#define OFS_ADC12MCTL25                  (0x0052)
#define OFS_ADC12MCTL25_L                OFS_ADC12MCTL25
#define OFS_ADC12MCTL25_H                OFS_ADC12MCTL25+1
#define OFS_ADC12MCTL26                  (0x0054)
#define OFS_ADC12MCTL26_L                OFS_ADC12MCTL26
#define OFS_ADC12MCTL26_H                OFS_ADC12MCTL26+1
#define OFS_ADC12MCTL27                  (0x0056)
#define OFS_ADC12MCTL27_L                OFS_ADC12MCTL27
#define OFS_ADC12MCTL27_H                OFS_ADC12MCTL27+1
#define OFS_ADC12MCTL28                  (0x0058)
#define OFS_ADC12MCTL28_L                OFS_ADC12MCTL28
#define OFS_ADC12MCTL28_H                OFS_ADC12MCTL28+1
#define OFS_ADC12MCTL29                  (0x005A)
#define OFS_ADC12MCTL29_L                OFS_ADC12MCTL29
#define OFS_ADC12MCTL29_H                OFS_ADC12MCTL29+1
#define OFS_ADC12MCTL30                  (0x005C)
#define OFS_ADC12MCTL30_L                OFS_ADC12MCTL30
#define OFS_ADC12MCTL30_H                OFS_ADC12MCTL30+1
#define OFS_ADC12MCTL31                  (0x005E)
#define OFS_ADC12MCTL31_L                OFS_ADC12MCTL31
#define OFS_ADC12MCTL31_H                OFS_ADC12MCTL31+1
#define OFS_ADC12MEM0                    (0x0060)
#define OFS_ADC12MEM0_L                  OFS_ADC12MEM0
#define OFS_ADC12MEM0_H                  OFS_ADC12MEM0+1
#define OFS_ADC12MEM1                    (0x0062)
#define OFS_ADC12MEM1_L                  OFS_ADC12MEM1
#define OFS_ADC12MEM1_H                  OFS_ADC12MEM1+1
#define OFS_ADC12MEM2                    (0x0064)
#define OFS_ADC12MEM2_L                  OFS_ADC12MEM2
#define OFS_ADC12MEM2_H                  OFS_ADC12MEM2+1
#define OFS_ADC12MEM3                    (0x0066)
#define OFS_ADC12MEM3_L                  OFS_ADC12MEM3
#define OFS_ADC12MEM3_H                  OFS_ADC12MEM3+1
#define OFS_ADC12MEM4                    (0x0068)
#define OFS_ADC12MEM4_L                  OFS_ADC12MEM4
#define OFS_ADC12MEM4_H                  OFS_ADC12MEM4+1
#define OFS_ADC12MEM5                    (0x006A)
#define OFS_ADC12MEM5_L                  OFS_ADC12MEM5
#define OFS_ADC12MEM5_H                  OFS_ADC12MEM5+1
#define OFS_ADC12MEM6                    (0x006C)
#define OFS_ADC12MEM6_L                  OFS_ADC12MEM6
#define OFS_ADC12MEM6_H                  OFS_ADC12MEM6+1
#define OFS_ADC12MEM7                    (0x006E)
#define OFS_ADC12MEM7_L                  OFS_ADC12MEM7
#define OFS_ADC12MEM7_H                  OFS_ADC12MEM7+1
#define OFS_ADC12MEM8                    (0x0070)
#define OFS_ADC12MEM8_L                  OFS_ADC12MEM8
#define OFS_ADC12MEM8_H                  OFS_ADC12MEM8+1
#define OFS_ADC12MEM9                    (0x0072)
#define OFS_ADC12MEM9_L                  OFS_ADC12MEM9
#define OFS_ADC12MEM9_H                  OFS_ADC12MEM9+1
#define OFS_ADC12MEM10                   (0x0074)
#define OFS_ADC12MEM10_L                 OFS_ADC12MEM10
#define OFS_ADC12MEM10_H                 OFS_ADC12MEM10+1
#define OFS_ADC12MEM11                   (0x0076)
#define OFS_ADC12MEM11_L                 OFS_ADC12MEM11
#define OFS_ADC12MEM11_H                 OFS_ADC12MEM11+1
#define OFS_ADC12MEM12                   (0x0078)
#define OFS_ADC12MEM12_L                 OFS_ADC12MEM12
#define OFS_ADC12MEM12_H                 OFS_ADC12MEM12+1
#define OFS_ADC12MEM13                   (0x007A)
#define OFS_ADC12MEM13_L                 OFS_ADC12MEM13
#define OFS_ADC12MEM13_H                 OFS_ADC12MEM13+1
#define OFS_ADC12MEM14                   (0x007C)
#define OFS_ADC12MEM14_L                 OFS_ADC12MEM14
#define OFS_ADC12MEM14_H                 OFS_ADC12MEM14+1
#define OFS_ADC12MEM15                   (0x007E)
#define OFS_ADC12MEM15_L                 OFS_ADC12MEM15
#define OFS_ADC12MEM15_H                 OFS_ADC12MEM15+1
#define OFS_ADC12MEM16                   (0x0080)
#define OFS_ADC12MEM16_L                 OFS_ADC12MEM16
#define OFS_ADC12MEM16_H                 OFS_ADC12MEM16+1
#define OFS_ADC12MEM17                   (0x0082)
#define OFS_ADC12MEM17_L                 OFS_ADC12MEM17
#define OFS_ADC12MEM17_H                 OFS_ADC12MEM17+1
#define OFS_ADC12MEM18                   (0x0084)
#define OFS_ADC12MEM18_L                 OFS_ADC12MEM18
#define OFS_ADC12MEM18_H                 OFS_ADC12MEM18+1
#define OFS_ADC12MEM19                   (0x0086)
#define OFS_ADC12MEM19_L                 OFS_ADC12MEM19
#define OFS_ADC12MEM19_H                 OFS_ADC12MEM19+1
#define OFS_ADC12MEM20                   (0x0088)
#define OFS_ADC12MEM20_L                 OFS_ADC12MEM20
#define OFS_ADC12MEM20_H                 OFS_ADC12MEM20+1
#define OFS_ADC12MEM21                   (0x008A)
#define OFS_ADC12MEM21_L                 OFS_ADC12MEM21
#define OFS_ADC12MEM21_H                 OFS_ADC12MEM21+1
#define OFS_ADC12MEM22                   (0x008C)
#define OFS_ADC12MEM22_L                 OFS_ADC12MEM22
#define OFS_ADC12MEM22_H                 OFS_ADC12MEM22+1
#define OFS_ADC12MEM23                   (0x008E)
#define OFS_ADC12MEM23_L                 OFS_ADC12MEM23
#define OFS_ADC12MEM23_H                 OFS_ADC12MEM23+1
#define OFS_ADC12MEM24                   (0x0090)
#define OFS_ADC12MEM24_L                 OFS_ADC12MEM24
#define OFS_ADC12MEM24_H                 OFS_ADC12MEM24+1
#define OFS_ADC12MEM25                   (0x0092)
#define OFS_ADC12MEM25_L                 OFS_ADC12MEM25
#define OFS_ADC12MEM25_H                 OFS_ADC12MEM25+1
#define OFS_ADC12MEM26                   (0x0094)
#define OFS_ADC12MEM26_L                 OFS_ADC12MEM26
#define OFS_ADC12MEM26_H                 OFS_ADC12MEM26+1
#define OFS_ADC12MEM27                   (0x0096)
#define OFS_ADC12MEM27_L                 OFS_ADC12MEM27
#define OFS_ADC12MEM27_H                 OFS_ADC12MEM27+1
#define OFS_ADC12MEM28                   (0x0098)
#define OFS_ADC12MEM28_L                 OFS_ADC12MEM28
#define OFS_ADC12MEM28_H                 OFS_ADC12MEM28+1
#define OFS_ADC12MEM29                   (0x009A)
#define OFS_ADC12MEM29_L                 OFS_ADC12MEM29
#define OFS_ADC12MEM29_H                 OFS_ADC12MEM29+1
#define OFS_ADC12MEM30                   (0x009C)
#define OFS_ADC12MEM30_L                 OFS_ADC12MEM30
#define OFS_ADC12MEM30_H                 OFS_ADC12MEM30+1
#define OFS_ADC12MEM31                   (0x009E)
#define OFS_ADC12MEM31_L                 OFS_ADC12MEM31
#define OFS_ADC12MEM31_H                 OFS_ADC12MEM31+1

/* ADC12_B Control Bits */

/* ADC12CTL0 Control Bits */
#define ADC12SC                          (0x0001)        /* start conversion */
#define ADC12SC_L                        (0x0001)
#define ADC12SC_0                        (0x0000)        /* No sample-and-conversion-start */
#define ADC12SC_1                        (0x0001)        /* Start sample-and-conversion */
#define ADC12SC_1_L                      (0x0001)
#define ADC12ENC                         (0x0002)        /* enable conversion */
#define ADC12ENC_L                       (0x0002)
#define ADC12ENC_0                       (0x0000)        /* ADC12_B disabled */
#define ADC12ENC_1                       (0x0002)        /* ADC12_B enabled */
#define ADC12ENC_1_L                     (0x0002)
#define ADC12ON                          (0x0010)        /* ADC on */
#define ADC12ON_L                        (0x0010)
#define ADC12ON_0                        (0x0000)        /* ADC12_B off */
#define ADC12ON_1                        (0x0010)        /* ADC12_B on */
#define ADC12ON_1_L                      (0x0010)
#define ADC12MSC                         (0x0080)        /* sample-and-hold time. */
#define ADC12MSC_L                       (0x0080)
#define ADC12MSC_0                       (0x0000)        /* The sampling timer requires a rising edge of the SHI signal to
                                                            trigger each sample-and-convert. */
#define ADC12MSC_1                       (0x0080)        /* The incidence of a positive(or for devices first rising edge 
                                                            of the) SHI signal triggers the sampling timer, but further 
                                                            sample-and-conversions are performed automatically as soon as 
                                                            the prior conversion is completed. */
#define ADC12MSC_1_L                     (0x0080)
#define ADC12SHT0                        (0x0f00)        /* sample-and-hold time. */
#define ADC12SHT0_H                      (0x000f)
#define ADC12SHT00                       (0x0100)        /* sample-and-hold time. */
#define ADC12SHT00_H                     (0x0001)
#define ADC12SHT01                       (0x0200)        /* sample-and-hold time. */
#define ADC12SHT01_H                     (0x0002)
#define ADC12SHT02                       (0x0400)        /* sample-and-hold time. */
#define ADC12SHT02_H                     (0x0004)
#define ADC12SHT03                       (0x0800)        /* sample-and-hold time. */
#define ADC12SHT03_H                     (0x0008)
#define ADC12SHT0_0                      (0x0000)        /* 4 ADC12CLK cycles */
#define ADC12SHT0_1                      (0x0100)        /* 8 ADC12CLK cycles */
#define ADC12SHT0_1_H                    (0x0001)
#define ADC12SHT0_2                      (0x0200)        /* 16 ADC12CLK cycles */
#define ADC12SHT0_2_H                    (0x0002)
#define ADC12SHT0_3                      (0x0300)        /* 32 ADC12CLK cycles */
#define ADC12SHT0_3_H                    (0x0003)
#define ADC12SHT0_4                      (0x0400)        /* 64 ADC12CLK cycles */
#define ADC12SHT0_4_H                    (0x0004)
#define ADC12SHT0_5                      (0x0500)        /* 96 ADC12CLK cycles */
#define ADC12SHT0_5_H                    (0x0005)
#define ADC12SHT0_6                      (0x0600)        /* 128 ADC12CLK cycles */
#define ADC12SHT0_6_H                    (0x0006)
#define ADC12SHT0_7                      (0x0700)        /* 192 ADC12CLK cycles */
#define ADC12SHT0_7_H                    (0x0007)
#define ADC12SHT0_8                      (0x0800)        /* 256 ADC12CLK cycles */
#define ADC12SHT0_8_H                    (0x0008)
#define ADC12SHT0_9                      (0x0900)        /* 384 ADC12CLK cycles */
#define ADC12SHT0_9_H                    (0x0009)
#define ADC12SHT0_10                     (0x0a00)        /* 512 ADC12CLK cycles */
#define ADC12SHT0_10_H                   (0x000a)
#define ADC12SHT0_11                     (0x0b00)        /* Reserved */
#define ADC12SHT0_11_H                   (0x000b)
#define ADC12SHT0_12                     (0x0c00)        /* Reserved */
#define ADC12SHT0_12_H                   (0x000c)
#define ADC12SHT0_13                     (0x0d00)        /* Reserved */
#define ADC12SHT0_13_H                   (0x000d)
#define ADC12SHT0_14                     (0x0e00)        /* Reserved */
#define ADC12SHT0_14_H                   (0x000e)
#define ADC12SHT0_15                     (0x0f00)        /* Reserved */
#define ADC12SHT0_15_H                   (0x000f)
#define ADC12SHT1                        (0xf000)        /* sample-and-hold time. */
#define ADC12SHT1_H                      (0x00f0)
#define ADC12SHT10                       (0x1000)        /* sample-and-hold time. */
#define ADC12SHT10_H                     (0x0010)
#define ADC12SHT11                       (0x2000)        /* sample-and-hold time. */
#define ADC12SHT11_H                     (0x0020)
#define ADC12SHT12                       (0x4000)        /* sample-and-hold time. */
#define ADC12SHT12_H                     (0x0040)
#define ADC12SHT13                       (0x8000)        /* sample-and-hold time. */
#define ADC12SHT13_H                     (0x0080)
#define ADC12SHT1_0                      (0x0000)        /* 4 ADC12CLK cycles */
#define ADC12SHT1_1                      (0x1000)        /* 8 ADC12CLK cycles */
#define ADC12SHT1_1_H                    (0x0010)
#define ADC12SHT1_2                      (0x2000)        /* 16 ADC12CLK cycles */
#define ADC12SHT1_2_H                    (0x0020)
#define ADC12SHT1_3                      (0x3000)        /* 32 ADC12CLK cycles */
#define ADC12SHT1_3_H                    (0x0030)
#define ADC12SHT1_4                      (0x4000)        /* 64 ADC12CLK cycles */
#define ADC12SHT1_4_H                    (0x0040)
#define ADC12SHT1_5                      (0x5000)        /* 96 ADC12CLK cycles */
#define ADC12SHT1_5_H                    (0x0050)
#define ADC12SHT1_6                      (0x6000)        /* 128 ADC12CLK cycles */
#define ADC12SHT1_6_H                    (0x0060)
#define ADC12SHT1_7                      (0x7000)        /* 192 ADC12CLK cycles */
#define ADC12SHT1_7_H                    (0x0070)
#define ADC12SHT1_8                      (0x8000)        /* 256 ADC12CLK cycles */
#define ADC12SHT1_8_H                    (0x0080)
#define ADC12SHT1_9                      (0x9000)        /* 384 ADC12CLK cycles */
#define ADC12SHT1_9_H                    (0x0090)
#define ADC12SHT1_10                     (0xa000)        /* 512 ADC12CLK cycles */
#define ADC12SHT1_10_H                   (0x00a0)
#define ADC12SHT1_11                     (0xb000)        /* Reserved */
#define ADC12SHT1_11_H                   (0x00b0)
#define ADC12SHT1_12                     (0xc000)        /* Reserved */
#define ADC12SHT1_12_H                   (0x00c0)
#define ADC12SHT1_13                     (0xd000)        /* Reserved */
#define ADC12SHT1_13_H                   (0x00d0)
#define ADC12SHT1_14                     (0xe000)        /* Reserved */
#define ADC12SHT1_14_H                   (0x00e0)
#define ADC12SHT1_15                     (0xf000)        /* Reserved */
#define ADC12SHT1_15_H                   (0x00f0)

/* ADC12CTL1 Control Bits */
#define ADC12BUSY                        (0x0001)        /* ADC busy */
#define ADC12BUSY_L                      (0x0001)
#define ADC12BUSY_0                      (0x0000)        /* No operation is active. */
#define ADC12BUSY_1                      (0x0001)        /* A sequence, sample, or conversion is active. */
#define ADC12BUSY_1_L                    (0x0001)
#define ADC12CONSEQ                      (0x0006)        /* conversion sequence mode select */
#define ADC12CONSEQ_L                    (0x0006)
#define ADC12CONSEQ0                     (0x0002)        /* conversion sequence mode select */
#define ADC12CONSEQ0_L                   (0x0002)
#define ADC12CONSEQ1                     (0x0004)        /* conversion sequence mode select */
#define ADC12CONSEQ1_L                   (0x0004)
#define ADC12CONSEQ_0                    (0x0000)        /* Single-channel, single-conversion */
#define ADC12CONSEQ_1                    (0x0002)        /* Sequence-of-channels */
#define ADC12CONSEQ_1_L                  (0x0002)
#define ADC12CONSEQ_2                    (0x0004)        /* Repeat-single-channel */
#define ADC12CONSEQ_2_L                  (0x0004)
#define ADC12CONSEQ_3                    (0x0006)        /* Repeat-sequence-of-channels */
#define ADC12CONSEQ_3_L                  (0x0006)
#define ADC12SSEL                        (0x0018)        /* clock source select */
#define ADC12SSEL_L                      (0x0018)
#define ADC12SSEL0                       (0x0008)        /* clock source select */
#define ADC12SSEL0_L                     (0x0008)
#define ADC12SSEL1                       (0x0010)        /* clock source select */
#define ADC12SSEL1_L                     (0x0010)
#define ADC12SSEL_0                      (0x0000)        /* ADC12OSC (MODOSC) */
#define ADC12SSEL_1                      (0x0008)        /* ACLK */
#define ADC12SSEL_1_L                    (0x0008)
#define ADC12SSEL_2                      (0x0010)        /* MCLK */
#define ADC12SSEL_2_L                    (0x0010)
#define ADC12SSEL_3                      (0x0018)        /* SMCLK */
#define ADC12SSEL_3_L                    (0x0018)
#define ADC12DIV                         (0x00e0)        /* clock divider */
#define ADC12DIV_L                       (0x00e0)
#define ADC12DIV0                        (0x0020)        /* clock divider */
#define ADC12DIV0_L                      (0x0020)
#define ADC12DIV1                        (0x0040)        /* clock divider */
#define ADC12DIV1_L                      (0x0040)
#define ADC12DIV2                        (0x0080)        /* clock divider */
#define ADC12DIV2_L                      (0x0080)
#define ADC12DIV_0                       (0x0000)        /* /1 */
#define ADC12DIV_1                       (0x0020)        /* /2 */
#define ADC12DIV_1_L                     (0x0020)
#define ADC12DIV_2                       (0x0040)        /* /3 */
#define ADC12DIV_2_L                     (0x0040)
#define ADC12DIV_3                       (0x0060)        /* /4 */
#define ADC12DIV_3_L                     (0x0060)
#define ADC12DIV_4                       (0x0080)        /* /5 */
#define ADC12DIV_4_L                     (0x0080)
#define ADC12DIV_5                       (0x00a0)        /* /6 */
#define ADC12DIV_5_L                     (0x00a0)
#define ADC12DIV_6                       (0x00c0)        /* /7 */
#define ADC12DIV_6_L                     (0x00c0)
#define ADC12DIV_7                       (0x00e0)        /* /8 */
#define ADC12DIV_7_L                     (0x00e0)
#define ADC12ISSH                        (0x0100)        /* invert signal sample-and-hold */
#define ADC12ISSH_H                      (0x0001)
#define ADC12ISSH_0                      (0x0000)        /* The sample-input signal is not inverted. */
#define ADC12ISSH_1                      (0x0100)        /* The sample-input signal is inverted. */
#define ADC12ISSH_1_H                    (0x0001)
#define ADC12SHP                         (0x0200)        /* sample-and-hold pulse-mode select */
#define ADC12SHP_H                       (0x0002)
#define ADC12SHP_0                       (0x0000)        /* SAMPCON signal is sourced from the sample-input signal. */
#define ADC12SHP_1                       (0x0200)        /* SAMPCON signal is sourced from the sampling timer. */
#define ADC12SHP_1_H                     (0x0002)
#define ADC12SHS                         (0x1c00)        /* sample-and-hold source select */
#define ADC12SHS_H                       (0x001c)
#define ADC12SHS0                        (0x0400)        /* sample-and-hold source select */
#define ADC12SHS0_H                      (0x0004)
#define ADC12SHS1                        (0x0800)        /* sample-and-hold source select */
#define ADC12SHS1_H                      (0x0008)
#define ADC12SHS2                        (0x1000)        /* sample-and-hold source select */
#define ADC12SHS2_H                      (0x0010)
#define ADC12SHS_0                       (0x0000)        /* ADC12SC bit */
#define ADC12SHS_1                       (0x0400)        /* see the device-specific data sheet for source */
#define ADC12SHS_1_H                     (0x0004)
#define ADC12SHS_2                       (0x0800)        /* see the device-specific data sheet for source */
#define ADC12SHS_2_H                     (0x0008)
#define ADC12SHS_3                       (0x0c00)        /* see the device-specific data sheet for source */
#define ADC12SHS_3_H                     (0x000c)
#define ADC12SHS_4                       (0x1000)        /* see the device-specific data sheet for source */
#define ADC12SHS_4_H                     (0x0010)
#define ADC12SHS_5                       (0x1400)        /* see the device-specific data sheet for source */
#define ADC12SHS_5_H                     (0x0014)
#define ADC12SHS_6                       (0x1800)        /* see the device-specific data sheet for source */
#define ADC12SHS_6_H                     (0x0018)
#define ADC12SHS_7                       (0x1c00)        /* see the device-specific data sheet for source */
#define ADC12SHS_7_H                     (0x001c)
#define ADC12PDIV                        (0x6000)        /* predivider */
#define ADC12PDIV_H                      (0x0060)
#define ADC12PDIV0                       (0x2000)        /* predivider */
#define ADC12PDIV0_H                     (0x0020)
#define ADC12PDIV1                       (0x4000)        /* predivider */
#define ADC12PDIV1_H                     (0x0040)
#define ADC12PDIV_0                      (0x0000)        /* Predivide by 1 */
#define ADC12PDIV_1                      (0x2000)        /* Predivide by 4 */
#define ADC12PDIV_1_H                    (0x0020)
#define ADC12PDIV_2                      (0x4000)        /* Predivide by 32 */
#define ADC12PDIV_2_H                    (0x0040)
#define ADC12PDIV_3                      (0x6000)        /* Predivide by 64 */
#define ADC12PDIV_3_H                    (0x0060)
#define ADC12PDIV__1                     (0x0000)        /* Predivide by 1 */
#define ADC12PDIV__4                     (0x2000)        /* Predivide by 4 */
#define ADC12PDIV__4_H                   (0x0020)
#define ADC12PDIV__32                    (0x4000)        /* Predivide by 32 */
#define ADC12PDIV__32_H                  (0x0040)
#define ADC12PDIV__64                    (0x6000)        /* Predivide by 64 */
#define ADC12PDIV__64_H                  (0x0060)

/* ADC12CTL2 Control Bits */
#define ADC12PWRMD                       (0x0001)        /* low-power mode */
#define ADC12PWRMD_L                     (0x0001)
#define ADC12PWRMD_0                     (0x0000)        /* Regular power mode where sample rate is not restricted */
#define ADC12PWRMD_1                     (0x0001)        /* Low power mode enable, ADC12CLK can not be greater than 1/4 
                                                            the device-specific data sheet specified maximum for 
                                                            ADC12PWRMD = 0 */
#define ADC12PWRMD_1_L                   (0x0001)
#define ADC12DF                          (0x0008)        /* data read-back format */
#define ADC12DF_L                        (0x0008)
#define ADC12DF_0                        (0x0000)        /* Binary unsigned. Theoretically for ADC12DIF = 0 and 12-bit 
                                                            mode the analog input voltage  VREF results in 0000h, the 
                                                            analog input voltage + VREF results in 0FFFh. */
#define ADC12DF_1                        (0x0008)        /* Signed binary (2s complement), left aligned. Theoretically, 
                                                            for ADC12DIF = 0 and 12-bit mode, the analog input voltage  
                                                            VREF results in 8000h, the analog input voltage + VREF results
                                                            in 7FF0h. */
#define ADC12DF_1_L                      (0x0008)
#define ADC12RES                         (0x0030)        /* resolution */
#define ADC12RES_L                       (0x0030)
#define ADC12RES0                        (0x0010)        /* resolution */
#define ADC12RES0_L                      (0x0010)
#define ADC12RES1                        (0x0020)        /* resolution */
#define ADC12RES1_L                      (0x0020)
#define ADC12RES_0                       (0x0000)        /* 8 bit (10 clock cycle conversion time) */
#define ADC12RES_1                       (0x0010)        /* 10 bit (12 clock cycle conversion time) */
#define ADC12RES_1_L                     (0x0010)
#define ADC12RES_2                       (0x0020)        /* 12 bit (14 clock cycle conversion time) */
#define ADC12RES_2_L                     (0x0020)
#define ADC12RES_3                       (0x0030)        /* Reserved */
#define ADC12RES_3_L                     (0x0030)
#define ADC12RES__8BIT                   (0x0000)        /* 8 bit (10 clock cycle conversion time) */
#define ADC12RES__10BIT                  (0x0010)        /* 10 bit (12 clock cycle conversion time) */
#define ADC12RES__10BIT_L                (0x0010)
#define ADC12RES__12BIT                  (0x0020)        /* 12 bit (14 clock cycle conversion time) */
#define ADC12RES__12BIT_L                (0x0020)

/* ADC12CTL3 Control Bits */
#define ADC12CSTARTADD                   (0x001f)        /* conversion start address */
#define ADC12CSTARTADD_L                 (0x001f)
#define ADC12CSTARTADD0                  (0x0001)        /* conversion start address */
#define ADC12CSTARTADD0_L                (0x0001)
#define ADC12CSTARTADD1                  (0x0002)        /* conversion start address */
#define ADC12CSTARTADD1_L                (0x0002)
#define ADC12CSTARTADD2                  (0x0004)        /* conversion start address */
#define ADC12CSTARTADD2_L                (0x0004)
#define ADC12CSTARTADD3                  (0x0008)        /* conversion start address */
#define ADC12CSTARTADD3_L                (0x0008)
#define ADC12CSTARTADD4                  (0x0010)        /* conversion start address */
#define ADC12CSTARTADD4_L                (0x0010)
#define ADC12CSTARTADD_0                 (0x0000)        /* Conversion start address ADC12MEM0 */
#define ADC12CSTARTADD_1                 (0x0001)        /* Conversion start address ADC12MEM1 */
#define ADC12CSTARTADD_1_L               (0x0001)
#define ADC12CSTARTADD_2                 (0x0002)        /* Conversion start address ADC12MEM2 */
#define ADC12CSTARTADD_2_L               (0x0002)
#define ADC12CSTARTADD_3                 (0x0003)        /* Conversion start address ADC12MEM3 */
#define ADC12CSTARTADD_3_L               (0x0003)
#define ADC12CSTARTADD_4                 (0x0004)        /* Conversion start address ADC12MEM4 */
#define ADC12CSTARTADD_4_L               (0x0004)
#define ADC12CSTARTADD_5                 (0x0005)        /* Conversion start address ADC12MEM5 */
#define ADC12CSTARTADD_5_L               (0x0005)
#define ADC12CSTARTADD_6                 (0x0006)        /* Conversion start address ADC12MEM6 */
#define ADC12CSTARTADD_6_L               (0x0006)
#define ADC12CSTARTADD_7                 (0x0007)        /* Conversion start address ADC12MEM7 */
#define ADC12CSTARTADD_7_L               (0x0007)
#define ADC12CSTARTADD_8                 (0x0008)        /* Conversion start address ADC12MEM8 */
#define ADC12CSTARTADD_8_L               (0x0008)
#define ADC12CSTARTADD_9                 (0x0009)        /* Conversion start address ADC12MEM9 */
#define ADC12CSTARTADD_9_L               (0x0009)
#define ADC12CSTARTADD_10                (0x000a)        /* Conversion start address ADC12MEM10 */
#define ADC12CSTARTADD_10_L              (0x000a)
#define ADC12CSTARTADD_11                (0x000b)        /* Conversion start address ADC12MEM10 */
#define ADC12CSTARTADD_11_L              (0x000b)
#define ADC12CSTARTADD_12                (0x000c)        /* Conversion start address ADC12MEM12 */
#define ADC12CSTARTADD_12_L              (0x000c)
#define ADC12CSTARTADD_13                (0x000d)        /* Conversion start address ADC12MEM13 */
#define ADC12CSTARTADD_13_L              (0x000d)
#define ADC12CSTARTADD_14                (0x000e)        /* Conversion start address ADC12MEM14 */
#define ADC12CSTARTADD_14_L              (0x000e)
#define ADC12CSTARTADD_15                (0x000f)        /* Conversion start address ADC12MEM15 */
#define ADC12CSTARTADD_15_L              (0x000f)
#define ADC12CSTARTADD_16                (0x0010)        /* Conversion start address ADC12MEM16 */
#define ADC12CSTARTADD_16_L              (0x0010)
#define ADC12CSTARTADD_17                (0x0011)        /* Conversion start address ADC12MEM17 */
#define ADC12CSTARTADD_17_L              (0x0011)
#define ADC12CSTARTADD_18                (0x0012)        /* Conversion start address ADC12MEM18 */
#define ADC12CSTARTADD_18_L              (0x0012)
#define ADC12CSTARTADD_19                (0x0013)        /* Conversion start address ADC12MEM19 */
#define ADC12CSTARTADD_19_L              (0x0013)
#define ADC12CSTARTADD_20                (0x0014)        /* Conversion start address ADC12MEM20 */
#define ADC12CSTARTADD_20_L              (0x0014)
#define ADC12CSTARTADD_21                (0x0015)        /* Conversion start address ADC12MEM21 */
#define ADC12CSTARTADD_21_L              (0x0015)
#define ADC12CSTARTADD_22                (0x0016)        /* Conversion start address ADC12MEM22 */
#define ADC12CSTARTADD_22_L              (0x0016)
#define ADC12CSTARTADD_23                (0x0017)        /* Conversion start address ADC12MEM23 */
#define ADC12CSTARTADD_23_L              (0x0017)
#define ADC12CSTARTADD_24                (0x0018)        /* Conversion start address ADC12MEM24 */
#define ADC12CSTARTADD_24_L              (0x0018)
#define ADC12CSTARTADD_25                (0x0019)        /* Conversion start address ADC12MEM25 */
#define ADC12CSTARTADD_25_L              (0x0019)
#define ADC12CSTARTADD_26                (0x001a)        /* Conversion start address ADC12MEM26 */
#define ADC12CSTARTADD_26_L              (0x001a)
#define ADC12CSTARTADD_27                (0x001b)        /* Conversion start address ADC12MEM27 */
#define ADC12CSTARTADD_27_L              (0x001b)
#define ADC12CSTARTADD_28                (0x001c)        /* Conversion start address ADC12MEM28 */
#define ADC12CSTARTADD_28_L              (0x001c)
#define ADC12CSTARTADD_29                (0x001d)        /* Conversion start address ADC12MEM29 */
#define ADC12CSTARTADD_29_L              (0x001d)
#define ADC12CSTARTADD_30                (0x001e)        /* Conversion start address ADC12MEM30 */
#define ADC12CSTARTADD_30_L              (0x001e)
#define ADC12CSTARTADD_31                (0x001f)        /* Conversion start address ADC12MEM31 */
#define ADC12CSTARTADD_31_L              (0x001f)
#define ADC12CSTARTADD__ADC12MEM0        (0x0000)        /* Conversion start address ADC12MEM0 */
#define ADC12CSTARTADD__ADC12MEM1        (0x0001)        /* Conversion start address ADC12MEM1 */
#define ADC12CSTARTADD__ADC12MEM1_L      (0x0001)
#define ADC12CSTARTADD__ADC12MEM2        (0x0002)        /* Conversion start address ADC12MEM2 */
#define ADC12CSTARTADD__ADC12MEM2_L      (0x0002)
#define ADC12CSTARTADD__ADC12MEM3        (0x0003)        /* Conversion start address ADC12MEM3 */
#define ADC12CSTARTADD__ADC12MEM3_L      (0x0003)
#define ADC12CSTARTADD__ADC12MEM4        (0x0004)        /* Conversion start address ADC12MEM4 */
#define ADC12CSTARTADD__ADC12MEM4_L      (0x0004)
#define ADC12CSTARTADD__ADC12MEM5        (0x0005)        /* Conversion start address ADC12MEM5 */
#define ADC12CSTARTADD__ADC12MEM5_L      (0x0005)
#define ADC12CSTARTADD__ADC12MEM6        (0x0006)        /* Conversion start address ADC12MEM6 */
#define ADC12CSTARTADD__ADC12MEM6_L      (0x0006)
#define ADC12CSTARTADD__ADC12MEM7        (0x0007)        /* Conversion start address ADC12MEM7 */
#define ADC12CSTARTADD__ADC12MEM7_L      (0x0007)
#define ADC12CSTARTADD__ADC12MEM8        (0x0008)        /* Conversion start address ADC12MEM8 */
#define ADC12CSTARTADD__ADC12MEM8_L      (0x0008)
#define ADC12CSTARTADD__ADC12MEM9        (0x0009)        /* Conversion start address ADC12MEM9 */
#define ADC12CSTARTADD__ADC12MEM9_L      (0x0009)
#define ADC12CSTARTADD__ADC12MEM10       (0x000a)        /* Conversion start address ADC12MEM10 */
#define ADC12CSTARTADD__ADC12MEM10_L     (0x000a)
#define ADC12CSTARTADD__ADC12MEM11       (0x000b)        /* Conversion start address ADC12MEM10 */
#define ADC12CSTARTADD__ADC12MEM11_L     (0x000b)
#define ADC12CSTARTADD__ADC12MEM12       (0x000c)        /* Conversion start address ADC12MEM12 */
#define ADC12CSTARTADD__ADC12MEM12_L     (0x000c)
#define ADC12CSTARTADD__ADC12MEM13       (0x000d)        /* Conversion start address ADC12MEM13 */
#define ADC12CSTARTADD__ADC12MEM13_L     (0x000d)
#define ADC12CSTARTADD__ADC12MEM14       (0x000e)        /* Conversion start address ADC12MEM14 */
#define ADC12CSTARTADD__ADC12MEM14_L     (0x000e)
#define ADC12CSTARTADD__ADC12MEM15       (0x000f)        /* Conversion start address ADC12MEM15 */
#define ADC12CSTARTADD__ADC12MEM15_L     (0x000f)
#define ADC12CSTARTADD__ADC12MEM16       (0x0010)        /* Conversion start address ADC12MEM16 */
#define ADC12CSTARTADD__ADC12MEM16_L     (0x0010)
#define ADC12CSTARTADD__ADC12MEM17       (0x0011)        /* Conversion start address ADC12MEM17 */
#define ADC12CSTARTADD__ADC12MEM17_L     (0x0011)
#define ADC12CSTARTADD__ADC12MEM18       (0x0012)        /* Conversion start address ADC12MEM18 */
#define ADC12CSTARTADD__ADC12MEM18_L     (0x0012)
#define ADC12CSTARTADD__ADC12MEM19       (0x0013)        /* Conversion start address ADC12MEM19 */
#define ADC12CSTARTADD__ADC12MEM19_L     (0x0013)
#define ADC12CSTARTADD__ADC12MEM20       (0x0014)        /* Conversion start address ADC12MEM20 */
#define ADC12CSTARTADD__ADC12MEM20_L     (0x0014)
#define ADC12CSTARTADD__ADC12MEM21       (0x0015)        /* Conversion start address ADC12MEM21 */
#define ADC12CSTARTADD__ADC12MEM21_L     (0x0015)
#define ADC12CSTARTADD__ADC12MEM22       (0x0016)        /* Conversion start address ADC12MEM22 */
#define ADC12CSTARTADD__ADC12MEM22_L     (0x0016)
#define ADC12CSTARTADD__ADC12MEM23       (0x0017)        /* Conversion start address ADC12MEM23 */
#define ADC12CSTARTADD__ADC12MEM23_L     (0x0017)
#define ADC12CSTARTADD__ADC12MEM24       (0x0018)        /* Conversion start address ADC12MEM24 */
#define ADC12CSTARTADD__ADC12MEM24_L     (0x0018)
#define ADC12CSTARTADD__ADC12MEM25       (0x0019)        /* Conversion start address ADC12MEM25 */
#define ADC12CSTARTADD__ADC12MEM25_L     (0x0019)
#define ADC12CSTARTADD__ADC12MEM26       (0x001a)        /* Conversion start address ADC12MEM26 */
#define ADC12CSTARTADD__ADC12MEM26_L     (0x001a)
#define ADC12CSTARTADD__ADC12MEM27       (0x001b)        /* Conversion start address ADC12MEM27 */
#define ADC12CSTARTADD__ADC12MEM27_L     (0x001b)
#define ADC12CSTARTADD__ADC12MEM28       (0x001c)        /* Conversion start address ADC12MEM28 */
#define ADC12CSTARTADD__ADC12MEM28_L     (0x001c)
#define ADC12CSTARTADD__ADC12MEM29       (0x001d)        /* Conversion start address ADC12MEM29 */
#define ADC12CSTARTADD__ADC12MEM29_L     (0x001d)
#define ADC12CSTARTADD__ADC12MEM30       (0x001e)        /* Conversion start address ADC12MEM30 */
#define ADC12CSTARTADD__ADC12MEM30_L     (0x001e)
#define ADC12CSTARTADD__ADC12MEM31       (0x001f)        /* Conversion start address ADC12MEM31 */
#define ADC12CSTARTADD__ADC12MEM31_L     (0x001f)
#define ADC12BATMAP                      (0x0040)        /* 1/2 AVCC ADC input channel selection */
#define ADC12BATMAP_L                    (0x0040)
#define ADC12BATMAP_0                    (0x0000)        /* external pin is selected for ADC input channel A31 */
#define ADC12BATMAP_1                    (0x0040)        /* ADC internal 1/2 x AVCC channel is selected for ADC input 
                                                            channel A31 */
#define ADC12BATMAP_1_L                  (0x0040)
#define ADC12TCMAP                       (0x0080)        /* temperature sensor ADC input channel selection */
#define ADC12TCMAP_L                     (0x0080)
#define ADC12TCMAP_0                     (0x0000)        /* external pin is selected for ADC input channel A30 */
#define ADC12TCMAP_1                     (0x0080)        /* ADC internal temperature sensor channel is selected for ADC 
                                                            input channel A30 */
#define ADC12TCMAP_1_L                   (0x0080)
#define ADC12ICH0MAP                     (0x0100)        /* int ch 0 sel to ADC in ch A29 */
#define ADC12ICH0MAP_H                   (0x0001)
#define ADC12ICH0MAP_0                   (0x0000)        /* external pin is selected for ADC input channel A29 */
#define ADC12ICH0MAP_1                   (0x0100)        /* ADC input channel internal 0 is selected for ADC input channel
                                                            A29, see device-specific data sheet for availability */
#define ADC12ICH0MAP_1_H                 (0x0001)
#define ADC12ICH1MAP                     (0x0200)        /* int ch 1 sel to ADC in ch A28 */
#define ADC12ICH1MAP_H                   (0x0002)
#define ADC12ICH1MAP_0                   (0x0000)        /* external pin is selected for ADC input channel A28 */
#define ADC12ICH1MAP_1                   (0x0200)        /* ADC input channel internal 1 is selected for ADC input channel
                                                            A28, see device-specific data sheet for availability */
#define ADC12ICH1MAP_1_H                 (0x0002)
#define ADC12ICH2MAP                     (0x0400)        /* int ch 2 sel to ADC in ch A27 */
#define ADC12ICH2MAP_H                   (0x0004)
#define ADC12ICH2MAP_0                   (0x0000)        /* external pin is selected for ADC input channel A27 */
#define ADC12ICH2MAP_1                   (0x0400)        /* ADC input channel internal 2 is selected for ADC input channel
                                                            A27, see device-specific data sheet for availability */
#define ADC12ICH2MAP_1_H                 (0x0004)
#define ADC12ICH3MAP                     (0x0800)        /* int ch 3 sel to ADC in ch A26 */
#define ADC12ICH3MAP_H                   (0x0008)
#define ADC12ICH3MAP_0                   (0x0000)        /* external pin is selected for ADC input channel A26 */
#define ADC12ICH3MAP_1                   (0x0800)        /* ADC input channel internal 3 is selected for ADC input channel
                                                            A26, see device-specific data sheet for availability */
#define ADC12ICH3MAP_1_H                 (0x0008)

/* ADC12LO Control Bits */
#define LOW_THRESHOLD                    (0xffff)        /* Window comparator lo threshold */
#define LOW_THRESHOLD_L                  (0x00ff)
#define LOW_THRESHOLD_H                  (0x00ff)
#define LOW_THRESHOLD0                   (0x0001)        /* Window comparator lo threshold */
#define LOW_THRESHOLD0_L                 (0x0001)
#define LOW_THRESHOLD1                   (0x0002)        /* Window comparator lo threshold */
#define LOW_THRESHOLD1_L                 (0x0002)
#define LOW_THRESHOLD2                   (0x0004)        /* Window comparator lo threshold */
#define LOW_THRESHOLD2_L                 (0x0004)
#define LOW_THRESHOLD3                   (0x0008)        /* Window comparator lo threshold */
#define LOW_THRESHOLD3_L                 (0x0008)
#define LOW_THRESHOLD4                   (0x0010)        /* Window comparator lo threshold */
#define LOW_THRESHOLD4_L                 (0x0010)
#define LOW_THRESHOLD5                   (0x0020)        /* Window comparator lo threshold */
#define LOW_THRESHOLD5_L                 (0x0020)
#define LOW_THRESHOLD6                   (0x0040)        /* Window comparator lo threshold */
#define LOW_THRESHOLD6_L                 (0x0040)
#define LOW_THRESHOLD7                   (0x0080)        /* Window comparator lo threshold */
#define LOW_THRESHOLD7_L                 (0x0080)
#define LOW_THRESHOLD8                   (0x0100)        /* Window comparator lo threshold */
#define LOW_THRESHOLD8_H                 (0x0001)
#define LOW_THRESHOLD9                   (0x0200)        /* Window comparator lo threshold */
#define LOW_THRESHOLD9_H                 (0x0002)
#define LOW_THRESHOLD10                  (0x0400)        /* Window comparator lo threshold */
#define LOW_THRESHOLD10_H                (0x0004)
#define LOW_THRESHOLD11                  (0x0800)        /* Window comparator lo threshold */
#define LOW_THRESHOLD11_H                (0x0008)
#define LOW_THRESHOLD12                  (0x1000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD12_H                (0x0010)
#define LOW_THRESHOLD13                  (0x2000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD13_H                (0x0020)
#define LOW_THRESHOLD14                  (0x4000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD14_H                (0x0040)
#define LOW_THRESHOLD15                  (0x8000)        /* Window comparator lo threshold */
#define LOW_THRESHOLD15_H                (0x0080)

/* ADC12HI Control Bits */
#define HIGH_THRESHOLD                   (0xffff)        /* Window comparator high threshold */
#define HIGH_THRESHOLD_L                 (0x00ff)
#define HIGH_THRESHOLD_H                 (0x00ff)
#define HIGH_THRESHOLD0                  (0x0001)        /* Window comparator high threshold */
#define HIGH_THRESHOLD0_L                (0x0001)
#define HIGH_THRESHOLD1                  (0x0002)        /* Window comparator high threshold */
#define HIGH_THRESHOLD1_L                (0x0002)
#define HIGH_THRESHOLD2                  (0x0004)        /* Window comparator high threshold */
#define HIGH_THRESHOLD2_L                (0x0004)
#define HIGH_THRESHOLD3                  (0x0008)        /* Window comparator high threshold */
#define HIGH_THRESHOLD3_L                (0x0008)
#define HIGH_THRESHOLD4                  (0x0010)        /* Window comparator high threshold */
#define HIGH_THRESHOLD4_L                (0x0010)
#define HIGH_THRESHOLD5                  (0x0020)        /* Window comparator high threshold */
#define HIGH_THRESHOLD5_L                (0x0020)
#define HIGH_THRESHOLD6                  (0x0040)        /* Window comparator high threshold */
#define HIGH_THRESHOLD6_L                (0x0040)
#define HIGH_THRESHOLD7                  (0x0080)        /* Window comparator high threshold */
#define HIGH_THRESHOLD7_L                (0x0080)
#define HIGH_THRESHOLD8                  (0x0100)        /* Window comparator high threshold */
#define HIGH_THRESHOLD8_H                (0x0001)
#define HIGH_THRESHOLD9                  (0x0200)        /* Window comparator high threshold */
#define HIGH_THRESHOLD9_H                (0x0002)
#define HIGH_THRESHOLD10                 (0x0400)        /* Window comparator high threshold */
#define HIGH_THRESHOLD10_H               (0x0004)
#define HIGH_THRESHOLD11                 (0x0800)        /* Window comparator high threshold */
#define HIGH_THRESHOLD11_H               (0x0008)
#define HIGH_THRESHOLD12                 (0x1000)        /* Window comparator high threshold */
#define HIGH_THRESHOLD12_H               (0x0010)
#define HIGH_THRESHOLD13                 (0x2000)        /* Window comparator high threshold */
#define HIGH_THRESHOLD13_H               (0x0020)
#define HIGH_THRESHOLD14                 (0x4000)        /* Window comparator high threshold */
#define HIGH_THRESHOLD14_H               (0x0040)
#define HIGH_THRESHOLD15                 (0x8000)        /* Window comparator high threshold */
#define HIGH_THRESHOLD15_H               (0x0080)

/* ADC12IFGR0 Control Bits */
#define ADC12IFG0                        (0x0001)        /* ADC12MEM0 interrupt flag */
#define ADC12IFG0_L                      (0x0001)
#define ADC12IFG0_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG0_1                      (0x0001)        /* Interrupt pending */
#define ADC12IFG0_1_L                    (0x0001)
#define ADC12IFG1                        (0x0002)        /* ADC12MEM1 interrupt flag */
#define ADC12IFG1_L                      (0x0002)
#define ADC12IFG1_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG1_1                      (0x0002)        /* Interrupt pending */
#define ADC12IFG1_1_L                    (0x0002)
#define ADC12IFG2                        (0x0004)        /* ADC12MEM2 interrupt flag */
#define ADC12IFG2_L                      (0x0004)
#define ADC12IFG2_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG2_1                      (0x0004)        /* Interrupt pending */
#define ADC12IFG2_1_L                    (0x0004)
#define ADC12IFG3                        (0x0008)        /* ADC12MEM3 interrupt flag */
#define ADC12IFG3_L                      (0x0008)
#define ADC12IFG3_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG3_1                      (0x0008)        /* Interrupt pending */
#define ADC12IFG3_1_L                    (0x0008)
#define ADC12IFG4                        (0x0010)        /* ADC12MEM4 interrupt flag */
#define ADC12IFG4_L                      (0x0010)
#define ADC12IFG4_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG4_1                      (0x0010)        /* Interrupt pending */
#define ADC12IFG4_1_L                    (0x0010)
#define ADC12IFG5                        (0x0020)        /* ADC12MEM5 interrupt flag */
#define ADC12IFG5_L                      (0x0020)
#define ADC12IFG5_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG5_1                      (0x0020)        /* Interrupt pending */
#define ADC12IFG5_1_L                    (0x0020)
#define ADC12IFG6                        (0x0040)        /* ADC12MEM6 interrupt flag */
#define ADC12IFG6_L                      (0x0040)
#define ADC12IFG6_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG6_1                      (0x0040)        /* Interrupt pending */
#define ADC12IFG6_1_L                    (0x0040)
#define ADC12IFG7                        (0x0080)        /* ADC12MEM7 interrupt flag */
#define ADC12IFG7_L                      (0x0080)
#define ADC12IFG7_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG7_1                      (0x0080)        /* Interrupt pending */
#define ADC12IFG7_1_L                    (0x0080)
#define ADC12IFG8                        (0x0100)        /* ADC12MEM8 interrupt flag */
#define ADC12IFG8_H                      (0x0001)
#define ADC12IFG8_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG8_1                      (0x0100)        /* Interrupt pending */
#define ADC12IFG8_1_H                    (0x0001)
#define ADC12IFG9                        (0x0200)        /* ADC12MEM9 interrupt flag */
#define ADC12IFG9_H                      (0x0002)
#define ADC12IFG9_0                      (0x0000)        /* No interrupt pending */
#define ADC12IFG9_1                      (0x0200)        /* Interrupt pending */
#define ADC12IFG9_1_H                    (0x0002)
#define ADC12IFG10                       (0x0400)        /* ADC12MEM10 interrupt flag */
#define ADC12IFG10_H                     (0x0004)
#define ADC12IFG10_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG10_1                     (0x0400)        /* Interrupt pending */
#define ADC12IFG10_1_H                   (0x0004)
#define ADC12IFG11                       (0x0800)        /* ADC12MEM11 interrupt flag */
#define ADC12IFG11_H                     (0x0008)
#define ADC12IFG11_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG11_1                     (0x0800)        /* Interrupt pending */
#define ADC12IFG11_1_H                   (0x0008)
#define ADC12IFG12                       (0x1000)        /* ADC12MEM12 interrupt flag */
#define ADC12IFG12_H                     (0x0010)
#define ADC12IFG12_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG12_1                     (0x1000)        /* Interrupt pending */
#define ADC12IFG12_1_H                   (0x0010)
#define ADC12IFG13                       (0x2000)        /* ADC12MEM13 interrupt flag */
#define ADC12IFG13_H                     (0x0020)
#define ADC12IFG13_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG13_1                     (0x2000)        /* Interrupt pending */
#define ADC12IFG13_1_H                   (0x0020)
#define ADC12IFG14                       (0x4000)        /* ADC12MEM14 interrupt flag */
#define ADC12IFG14_H                     (0x0040)
#define ADC12IFG14_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG14_1                     (0x4000)        /* Interrupt pending */
#define ADC12IFG14_1_H                   (0x0040)
#define ADC12IFG15                       (0x8000)        /* ADC12MEM15 interrupt flag */
#define ADC12IFG15_H                     (0x0080)
#define ADC12IFG15_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG15_1                     (0x8000)        /* Interrupt pending */
#define ADC12IFG15_1_H                   (0x0080)

/* ADC12IFGR1 Control Bits */
#define ADC12IFG16                       (0x0001)        /* ADC12MEM16 interrupt flag */
#define ADC12IFG16_L                     (0x0001)
#define ADC12IFG16_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG16_1                     (0x0001)        /* Interrupt pending */
#define ADC12IFG16_1_L                   (0x0001)
#define ADC12IFG17                       (0x0002)        /* ADC12MEM17 interrupt flag */
#define ADC12IFG17_L                     (0x0002)
#define ADC12IFG17_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG17_1                     (0x0002)        /* Interrupt pending */
#define ADC12IFG17_1_L                   (0x0002)
#define ADC12IFG18                       (0x0004)        /* ADC12MEM18 interrupt flag */
#define ADC12IFG18_L                     (0x0004)
#define ADC12IFG18_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG18_1                     (0x0004)        /* Interrupt pending */
#define ADC12IFG18_1_L                   (0x0004)
#define ADC12IFG19                       (0x0008)        /* ADC12MEM19 interrupt flag */
#define ADC12IFG19_L                     (0x0008)
#define ADC12IFG19_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG19_1                     (0x0008)        /* Interrupt pending */
#define ADC12IFG19_1_L                   (0x0008)
#define ADC12IFG20                       (0x0010)        /* ADC12MEM20 interrupt flag */
#define ADC12IFG20_L                     (0x0010)
#define ADC12IFG20_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG20_1                     (0x0010)        /* Interrupt pending */
#define ADC12IFG20_1_L                   (0x0010)
#define ADC12IFG21                       (0x0020)        /* ADC12MEM21 interrupt flag */
#define ADC12IFG21_L                     (0x0020)
#define ADC12IFG21_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG21_1                     (0x0020)        /* Interrupt pending */
#define ADC12IFG21_1_L                   (0x0020)
#define ADC12IFG22                       (0x0040)        /* ADC12MEM22 interrupt flag */
#define ADC12IFG22_L                     (0x0040)
#define ADC12IFG22_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG22_1                     (0x0040)        /* Interrupt pending */
#define ADC12IFG22_1_L                   (0x0040)
#define ADC12IFG23                       (0x0080)        /* ADC12MEM23 interrupt flag */
#define ADC12IFG23_L                     (0x0080)
#define ADC12IFG23_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG23_1                     (0x0080)        /* Interrupt pending */
#define ADC12IFG23_1_L                   (0x0080)
#define ADC12IFG24                       (0x0100)        /* ADC12MEM24 interrupt flag */
#define ADC12IFG24_H                     (0x0001)
#define ADC12IFG24_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG24_1                     (0x0100)        /* Interrupt pending */
#define ADC12IFG24_1_H                   (0x0001)
#define ADC12IFG25                       (0x0200)        /* ADC12MEM25 interrupt flag */
#define ADC12IFG25_H                     (0x0002)
#define ADC12IFG25_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG25_1                     (0x0200)        /* Interrupt pending */
#define ADC12IFG25_1_H                   (0x0002)
#define ADC12IFG26                       (0x0400)        /* ADC12MEM26 interrupt flag */
#define ADC12IFG26_H                     (0x0004)
#define ADC12IFG26_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG26_1                     (0x0400)        /* Interrupt pending */
#define ADC12IFG26_1_H                   (0x0004)
#define ADC12IFG27                       (0x0800)        /* ADC12MEM27 interrupt flag */
#define ADC12IFG27_H                     (0x0008)
#define ADC12IFG27_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG27_1                     (0x0800)        /* Interrupt pending */
#define ADC12IFG27_1_H                   (0x0008)
#define ADC12IFG28                       (0x1000)        /* ADC12MEM28 interrupt flag */
#define ADC12IFG28_H                     (0x0010)
#define ADC12IFG28_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG28_1                     (0x1000)        /* Interrupt pending */
#define ADC12IFG28_1_H                   (0x0010)
#define ADC12IFG29                       (0x2000)        /* ADC12MEM29 interrupt flag */
#define ADC12IFG29_H                     (0x0020)
#define ADC12IFG29_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG29_1                     (0x2000)        /* Interrupt pending */
#define ADC12IFG29_1_H                   (0x0020)
#define ADC12IFG30                       (0x4000)        /* ADC12MEM30 interrupt flag */
#define ADC12IFG30_H                     (0x0040)
#define ADC12IFG30_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG30_1                     (0x4000)        /* Interrupt pending */
#define ADC12IFG30_1_H                   (0x0040)
#define ADC12IFG31                       (0x8000)        /* ADC12MEM31 interrupt flag */
#define ADC12IFG31_H                     (0x0080)
#define ADC12IFG31_0                     (0x0000)        /* No interrupt pending */
#define ADC12IFG31_1                     (0x8000)        /* Interrupt pending */
#define ADC12IFG31_1_H                   (0x0080)

/* ADC12IFGR2 Control Bits */
#define ADC12INIFG                       (0x0002)        /* Interrupt flag for ADC12MEMx between ADC12HI and ADC12LO */
#define ADC12INIFG_L                     (0x0002)
#define ADC12INIFG_0                     (0x0000)        /* No interrupt pending */
#define ADC12INIFG_1                     (0x0002)        /* Interrupt pending */
#define ADC12INIFG_1_L                   (0x0002)
#define ADC12LOIFG                       (0x0004)        /* Interrupt flag for ADC12MEMx <ADC12LO */
#define ADC12LOIFG_L                     (0x0004)
#define ADC12LOIFG_0                     (0x0000)        /* No interrupt pending */
#define ADC12LOIFG_1                     (0x0004)        /* Interrupt pending */
#define ADC12LOIFG_1_L                   (0x0004)
#define ADC12HIIFG                       (0x0008)        /* Interrupt flag for ADC12MEMx >ADC12HI */
#define ADC12HIIFG_L                     (0x0008)
#define ADC12HIIFG_0                     (0x0000)        /* No interrupt pending */
#define ADC12HIIFG_1                     (0x0008)        /* Interrupt pending */
#define ADC12HIIFG_1_L                   (0x0008)
#define ADC12OVIFG                       (0x0010)        /* ADC12MEMx overflow-interrupt flag. */
#define ADC12OVIFG_L                     (0x0010)
#define ADC12OVIFG_0                     (0x0000)        /* No interrupt pending */
#define ADC12OVIFG_1                     (0x0010)        /* Interrupt pending */
#define ADC12OVIFG_1_L                   (0x0010)
#define ADC12TOVIFG                      (0x0020)        /* conversion-time-overflow interrupt flag */
#define ADC12TOVIFG_L                    (0x0020)
#define ADC12TOVIFG_0                    (0x0000)        /* No interrupt pending */
#define ADC12TOVIFG_1                    (0x0020)        /* Interrupt pending */
#define ADC12TOVIFG_1_L                  (0x0020)
#define ADC12RDYIFG                      (0x0040)        /* reference buffer ready interrupt flag */
#define ADC12RDYIFG_L                    (0x0040)
#define ADC12RDYIFG_0                    (0x0000)        /* No interrupt pending */
#define ADC12RDYIFG_1                    (0x0040)        /* Interrupt pending */
#define ADC12RDYIFG_1_L                  (0x0040)

/* ADC12IER0 Control Bits */
#define ADC12IE0                         (0x0001)        /* Interrupt enable 0 */
#define ADC12IE0_L                       (0x0001)
#define ADC12IE0_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE0_1                       (0x0001)        /* Interrupt enabled */
#define ADC12IE0_1_L                     (0x0001)
#define ADC12IE1                         (0x0002)        /* interrupt enable 1 */
#define ADC12IE1_L                       (0x0002)
#define ADC12IE1_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE1_1                       (0x0002)        /* Interrupt enabled */
#define ADC12IE1_1_L                     (0x0002)
#define ADC12IE2                         (0x0004)        /* interrupt enable 2 */
#define ADC12IE2_L                       (0x0004)
#define ADC12IE2_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE2_1                       (0x0004)        /* Interrupt enabled */
#define ADC12IE2_1_L                     (0x0004)
#define ADC12IE3                         (0x0008)        /* interrupt enable 3 */
#define ADC12IE3_L                       (0x0008)
#define ADC12IE3_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE3_1                       (0x0008)        /* Interrupt enabled */
#define ADC12IE3_1_L                     (0x0008)
#define ADC12IE4                         (0x0010)        /* interrupt enable 4 */
#define ADC12IE4_L                       (0x0010)
#define ADC12IE4_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE4_1                       (0x0010)        /* Interrupt enabled */
#define ADC12IE4_1_L                     (0x0010)
#define ADC12IE5                         (0x0020)        /* interrupt enable 5 */
#define ADC12IE5_L                       (0x0020)
#define ADC12IE5_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE5_1                       (0x0020)        /* Interrupt enabled */
#define ADC12IE5_1_L                     (0x0020)
#define ADC12IE6                         (0x0040)        /* interrupt enable 6 */
#define ADC12IE6_L                       (0x0040)
#define ADC12IE6_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE6_1                       (0x0040)        /* Interrupt enabled */
#define ADC12IE6_1_L                     (0x0040)
#define ADC12IE7                         (0x0080)        /* interrupt enable 7 */
#define ADC12IE7_L                       (0x0080)
#define ADC12IE7_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE7_1                       (0x0080)        /* Interrupt enabled */
#define ADC12IE7_1_L                     (0x0080)
#define ADC12IE8                         (0x0100)        /* interrupt enable 8 */
#define ADC12IE8_H                       (0x0001)
#define ADC12IE8_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE8_1                       (0x0100)        /* Interrupt enabled */
#define ADC12IE8_1_H                     (0x0001)
#define ADC12IE9                         (0x0200)        /* interrupt enable 9 */
#define ADC12IE9_H                       (0x0002)
#define ADC12IE9_0                       (0x0000)        /* Interrupt disabled */
#define ADC12IE9_1                       (0x0200)        /* Interrupt enabled */
#define ADC12IE9_1_H                     (0x0002)
#define ADC12IE10                        (0x0400)        /* interrupt enable 10 */
#define ADC12IE10_H                      (0x0004)
#define ADC12IE10_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE10_1                      (0x0400)        /* Interrupt enabled */
#define ADC12IE10_1_H                    (0x0004)
#define ADC12IE11                        (0x0800)        /* interrupt enable  11 */
#define ADC12IE11_H                      (0x0008)
#define ADC12IE11_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE11_1                      (0x0800)        /* Interrupt enabled */
#define ADC12IE11_1_H                    (0x0008)
#define ADC12IE12                        (0x1000)        /* interrupt enable 12 */
#define ADC12IE12_H                      (0x0010)
#define ADC12IE12_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE12_1                      (0x1000)        /* Interrupt enabled */
#define ADC12IE12_1_H                    (0x0010)
#define ADC12IE13                        (0x2000)        /* interrupt enable  13 */
#define ADC12IE13_H                      (0x0020)
#define ADC12IE13_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE13_1                      (0x2000)        /* Interrupt enabled */
#define ADC12IE13_1_H                    (0x0020)
#define ADC12IE14                        (0x4000)        /* interrupt enable 14 */
#define ADC12IE14_H                      (0x0040)
#define ADC12IE14_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE14_1                      (0x4000)        /* Interrupt enabled */
#define ADC12IE14_1_H                    (0x0040)
#define ADC12IE15                        (0x8000)        /* interrupt enable 15 */
#define ADC12IE15_H                      (0x0080)
#define ADC12IE15_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE15_1                      (0x8000)        /* Interrupt enabled */
#define ADC12IE15_1_H                    (0x0080)

/* ADC12IER1 Control Bits */
#define ADC12IE16                        (0x0001)        /* interrupt enable 16 */
#define ADC12IE16_L                      (0x0001)
#define ADC12IE16_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE16_1                      (0x0001)        /* Interrupt enabled */
#define ADC12IE16_1_L                    (0x0001)
#define ADC12IE17                        (0x0002)        /* interrupt enable 17 */
#define ADC12IE17_L                      (0x0002)
#define ADC12IE17_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE17_1                      (0x0002)        /* Interrupt enabled */
#define ADC12IE17_1_L                    (0x0002)
#define ADC12IE18                        (0x0004)        /* interrupt enable 18 */
#define ADC12IE18_L                      (0x0004)
#define ADC12IE18_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE18_1                      (0x0004)        /* Interrupt enabled */
#define ADC12IE18_1_L                    (0x0004)
#define ADC12IE19                        (0x0008)        /* interrupt enable  19 */
#define ADC12IE19_L                      (0x0008)
#define ADC12IE19_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE19_1                      (0x0008)        /* Interrupt enabled */
#define ADC12IE19_1_L                    (0x0008)
#define ADC12IE20                        (0x0010)        /* interrupt enable 19 */
#define ADC12IE20_L                      (0x0010)
#define ADC12IE20_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE20_1                      (0x0010)        /* Interrupt enabled */
#define ADC12IE20_1_L                    (0x0010)
#define ADC12IE21                        (0x0020)        /* interrupt enable 21 */
#define ADC12IE21_L                      (0x0020)
#define ADC12IE21_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE21_1                      (0x0020)        /* Interrupt enabled */
#define ADC12IE21_1_L                    (0x0020)
#define ADC12IE22                        (0x0040)        /* interrupt enable 22 */
#define ADC12IE22_L                      (0x0040)
#define ADC12IE22_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE22_1                      (0x0040)        /* Interrupt enabled */
#define ADC12IE22_1_L                    (0x0040)
#define ADC12IE23                        (0x0080)        /* interrupt enable 23 */
#define ADC12IE23_L                      (0x0080)
#define ADC12IE23_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE23_1                      (0x0080)        /* Interrupt enabled */
#define ADC12IE23_1_L                    (0x0080)
#define ADC12IE24                        (0x0100)        /* interrupt enable 24 */
#define ADC12IE24_H                      (0x0001)
#define ADC12IE24_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE24_1                      (0x0100)        /* Interrupt enabled */
#define ADC12IE24_1_H                    (0x0001)
#define ADC12IE25                        (0x0200)        /* interrupt enable 25 */
#define ADC12IE25_H                      (0x0002)
#define ADC12IE25_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE25_1                      (0x0200)        /* Interrupt enabled */
#define ADC12IE25_1_H                    (0x0002)
#define ADC12IE26                        (0x0400)        /* interrupt enable 26 */
#define ADC12IE26_H                      (0x0004)
#define ADC12IE26_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE26_1                      (0x0400)        /* Interrupt enabled */
#define ADC12IE26_1_H                    (0x0004)
#define ADC12IE27                        (0x0800)        /* interrupt enable 27 */
#define ADC12IE27_H                      (0x0008)
#define ADC12IE27_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE27_1                      (0x0800)        /* Interrupt enabled */
#define ADC12IE27_1_H                    (0x0008)
#define ADC12IE28                        (0x1000)        /* interrupt enable  28 */
#define ADC12IE28_H                      (0x0010)
#define ADC12IE28_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE28_1                      (0x1000)        /* Interrupt enabled */
#define ADC12IE28_1_H                    (0x0010)
#define ADC12IE29                        (0x2000)        /* interrupt enable 29 */
#define ADC12IE29_H                      (0x0020)
#define ADC12IE29_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE29_1                      (0x2000)        /* Interrupt enabled */
#define ADC12IE29_1_H                    (0x0020)
#define ADC12IE30                        (0x4000)        /* interrupt enable 30 */
#define ADC12IE30_H                      (0x0040)
#define ADC12IE30_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE30_1                      (0x4000)        /* Interrupt enabled */
#define ADC12IE30_1_H                    (0x0040)
#define ADC12IE31                        (0x8000)        /* interrupt enable 30 */
#define ADC12IE31_H                      (0x0080)
#define ADC12IE31_0                      (0x0000)        /* Interrupt disabled */
#define ADC12IE31_1                      (0x8000)        /* Interrupt enabled */
#define ADC12IE31_1_H                    (0x0080)

/* ADC12IER2 Control Bits */
#define ADC12INIE                        (0x0002)        /* interrupt enable MEMx between ADC12HI and LO */
#define ADC12INIE_L                      (0x0002)
#define ADC12INIE_0                      (0x0000)        /* Interrupt disabled */
#define ADC12INIE_1                      (0x0002)        /* Interrupt enabled */
#define ADC12INIE_1_L                    (0x0002)
#define ADC12LOIE                        (0x0004)        /* interrupt enable MEMx < ADC12LO */
#define ADC12LOIE_L                      (0x0004)
#define ADC12LOIE_0                      (0x0000)        /* Interrupt disabled */
#define ADC12LOIE_1                      (0x0004)        /* Interrupt enabled */
#define ADC12LOIE_1_L                    (0x0004)
#define ADC12HIIE                        (0x0008)        /* interrupt enable MEMx > ADC12HI */
#define ADC12HIIE_L                      (0x0008)
#define ADC12HIIE_0                      (0x0000)        /* Interrupt disabled */
#define ADC12HIIE_1                      (0x0008)        /* Interrupt enabled */
#define ADC12HIIE_1_L                    (0x0008)
#define ADC12OVIE                        (0x0010)        /* ADC12MEMx overflow-interrupt enable */
#define ADC12OVIE_L                      (0x0010)
#define ADC12OVIE_0                      (0x0000)        /* Interrupt disabled */
#define ADC12OVIE_1                      (0x0010)        /* Interrupt enabled */
#define ADC12OVIE_1_L                    (0x0010)
#define ADC12TOVIE                       (0x0020)        /* conversion-time-overflow interrupt enable */
#define ADC12TOVIE_L                     (0x0020)
#define ADC12TOVIE_0                     (0x0000)        /* Interrupt disabled */
#define ADC12TOVIE_1                     (0x0020)        /* Interrupt enabled */
#define ADC12TOVIE_1_L                   (0x0020)
#define ADC12RDYIE                       (0x0040)        /* interrupt enable ADC ref buffer ready */
#define ADC12RDYIE_L                     (0x0040)
#define ADC12RDYIE_0                     (0x0000)        /* Interrupt disabled */
#define ADC12RDYIE_1                     (0x0040)        /* Interrupt enabled */
#define ADC12RDYIE_1_L                   (0x0040)

/* ADC12IV Control Bits */
#define ADC12IV0                         (0x0001)        /* interrupt vector value */
#define ADC12IV0_L                       (0x0001)
#define ADC12IV1                         (0x0002)        /* interrupt vector value */
#define ADC12IV1_L                       (0x0002)
#define ADC12IV2                         (0x0004)        /* interrupt vector value */
#define ADC12IV2_L                       (0x0004)
#define ADC12IV3                         (0x0008)        /* interrupt vector value */
#define ADC12IV3_L                       (0x0008)
#define ADC12IV4                         (0x0010)        /* interrupt vector value */
#define ADC12IV4_L                       (0x0010)
#define ADC12IV5                         (0x0020)        /* interrupt vector value */
#define ADC12IV5_L                       (0x0020)
#define ADC12IV6                         (0x0040)        /* interrupt vector value */
#define ADC12IV6_L                       (0x0040)
#define ADC12IV7                         (0x0080)        /* interrupt vector value */
#define ADC12IV7_L                       (0x0080)
#define ADC12IV8                         (0x0100)        /* interrupt vector value */
#define ADC12IV8_H                       (0x0001)
#define ADC12IV9                         (0x0200)        /* interrupt vector value */
#define ADC12IV9_H                       (0x0002)
#define ADC12IV10                        (0x0400)        /* interrupt vector value */
#define ADC12IV10_H                      (0x0004)
#define ADC12IV11                        (0x0800)        /* interrupt vector value */
#define ADC12IV11_H                      (0x0008)
#define ADC12IV12                        (0x1000)        /* interrupt vector value */
#define ADC12IV12_H                      (0x0010)
#define ADC12IV13                        (0x2000)        /* interrupt vector value */
#define ADC12IV13_H                      (0x0020)
#define ADC12IV14                        (0x4000)        /* interrupt vector value */
#define ADC12IV14_H                      (0x0040)
#define ADC12IV15                        (0x8000)        /* interrupt vector value */
#define ADC12IV15_H                      (0x0080)
#define ADC12IV_0                        (0x0000)        /* Interrupt Source: No interrupt pending, Interrupt Flag: None */
#define ADC12IV_2                        (0x0002)        /* Interrupt Source: ADC12MEMx overflow, Interrupt Flag: 
                                                            ADC12OVIFG, Interrupt Priority: Highest */
#define ADC12IV_2_L                      (0x0002)
#define ADC12IV_4                        (0x0004)        /* Interrupt Source: Conversion time overflow, Interrupt Flag: 
                                                            ADC12TOVIFG */
#define ADC12IV_4_L                      (0x0004)
#define ADC12IV_6                        (0x0006)        /* Interrupt Source: ADC12 window high interrupt flag, Interrupt 
                                                            Flag: ADC12HIIFG */
#define ADC12IV_6_L                      (0x0006)
#define ADC12IV_8                        (0x0008)        /* Interrupt Source: ADC12 window low interrupt flag, Interrupt 
                                                            Flag: ADC12LOIFG */
#define ADC12IV_8_L                      (0x0008)
#define ADC12IV_10                       (0x000a)        /* Interrupt Source: ADC12 in-window interrupt flag, Interrupt 
                                                            Flag: ADC12INIFG */
#define ADC12IV_10_L                     (0x000a)
#define ADC12IV_12                       (0x000c)        /* Interrupt Source: ADC12MEM0 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG0 */
#define ADC12IV_12_L                     (0x000c)
#define ADC12IV_14                       (0x000e)        /* Interrupt Source: ADC12MEM1 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG1 */
#define ADC12IV_14_L                     (0x000e)
#define ADC12IV_16                       (0x0010)        /* Interrupt Source: ADC12MEM2 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG2 */
#define ADC12IV_16_L                     (0x0010)
#define ADC12IV_18                       (0x0012)        /* Interrupt Source: ADC12MEM3 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG3 */
#define ADC12IV_18_L                     (0x0012)
#define ADC12IV_20                       (0x0014)        /* Interrupt Source: ADC12MEM4 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG4 */
#define ADC12IV_20_L                     (0x0014)
#define ADC12IV_22                       (0x0016)        /* Interrupt Source: ADC12MEM5 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG5 */
#define ADC12IV_22_L                     (0x0016)
#define ADC12IV_24                       (0x0018)        /* Interrupt Source: ADC12MEM6 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG6 */
#define ADC12IV_24_L                     (0x0018)
#define ADC12IV_26                       (0x001a)        /* Interrupt Source: ADC12MEM7 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG7 */
#define ADC12IV_26_L                     (0x001a)
#define ADC12IV_28                       (0x001c)        /* Interrupt Source: ADC12MEM8 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG8 */
#define ADC12IV_28_L                     (0x001c)
#define ADC12IV_30                       (0x001e)        /* Interrupt Source: ADC12MEM9 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG9 */
#define ADC12IV_30_L                     (0x001e)
#define ADC12IV_32                       (0x0020)        /* Interrupt Source: ADC12MEM10 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG10 */
#define ADC12IV_32_L                     (0x0020)
#define ADC12IV_34                       (0x0022)        /* Interrupt Source: ADC12MEM11 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG11 */
#define ADC12IV_34_L                     (0x0022)
#define ADC12IV_36                       (0x0024)        /* Interrupt Source: ADC12MEM12 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG12 */
#define ADC12IV_36_L                     (0x0024)
#define ADC12IV_38                       (0x0026)        /* Interrupt Source: ADC12MEM13 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG13 */
#define ADC12IV_38_L                     (0x0026)
#define ADC12IV_40                       (0x0028)        /* Interrupt Source: ADC12MEM14 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG14 */
#define ADC12IV_40_L                     (0x0028)
#define ADC12IV_42                       (0x002a)        /* Interrupt Source: ADC12MEM15 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG15 */
#define ADC12IV_42_L                     (0x002a)
#define ADC12IV_44                       (0x002c)        /* Interrupt Source: ADC12MEM16 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG16 */
#define ADC12IV_44_L                     (0x002c)
#define ADC12IV_46                       (0x002e)        /* Interrupt Source: ADC12MEM17 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG17 */
#define ADC12IV_46_L                     (0x002e)
#define ADC12IV_48                       (0x0030)        /* Interrupt Source: ADC12MEM18 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG18 */
#define ADC12IV_48_L                     (0x0030)
#define ADC12IV_50                       (0x0032)        /* Interrupt Source: ADC12MEM19 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG19 */
#define ADC12IV_50_L                     (0x0032)
#define ADC12IV_52                       (0x0034)        /* Interrupt Source: ADC12MEM20 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG20 */
#define ADC12IV_52_L                     (0x0034)
#define ADC12IV_54                       (0x0036)        /* Interrupt Source: ADC12MEM21 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG21 */
#define ADC12IV_54_L                     (0x0036)
#define ADC12IV_56                       (0x0038)        /* Interrupt Source: ADC12MEM22 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG22 */
#define ADC12IV_56_L                     (0x0038)
#define ADC12IV_58                       (0x003a)        /* Interrupt Source: ADC12MEM23 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG23 */
#define ADC12IV_58_L                     (0x003a)
#define ADC12IV_60                       (0x003c)        /* Interrupt Source: ADC12MEM24 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG24 */
#define ADC12IV_60_L                     (0x003c)
#define ADC12IV_62                       (0x003e)        /* Interrupt Source: ADC12MEM25 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG25 */
#define ADC12IV_62_L                     (0x003e)
#define ADC12IV_64                       (0x0040)        /* Interrupt Source: ADC12MEM26 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG26 */
#define ADC12IV_64_L                     (0x0040)
#define ADC12IV_66                       (0x0042)        /* Interrupt Source: ADC12MEM27 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG27 */
#define ADC12IV_66_L                     (0x0042)
#define ADC12IV_68                       (0x0044)        /* Interrupt Source: ADC12MEM28 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG28 */
#define ADC12IV_68_L                     (0x0044)
#define ADC12IV_70                       (0x0046)        /* Interrupt Source: ADC12MEM29 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG29 */
#define ADC12IV_70_L                     (0x0046)
#define ADC12IV_72                       (0x0048)        /* Interrupt Source: ADC12MEM30 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG30 */
#define ADC12IV_72_L                     (0x0048)
#define ADC12IV_74                       (0x004a)        /* Interrupt Source: ADC12MEM31 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG31 */
#define ADC12IV_74_L                     (0x004a)
#define ADC12IV_76                       (0x004c)        /* Interrupt Source: ADC12RDYIFG interrupt flag, Interrupt Flag: 
                                                            ADC12RDYIFG */
#define ADC12IV_76_L                     (0x004c)
#define ADC12IV__NONE                    (0x0000)        /* Interrupt Source: No interrupt pending, Interrupt Flag: None */
#define ADC12IV__ADC12OVIFG              (0x0002)        /* Interrupt Source: ADC12MEMx overflow, Interrupt Flag: 
                                                            ADC12OVIFG, Interrupt Priority: Highest */
#define ADC12IV__ADC12OVIFG_L            (0x0002)
#define ADC12IV__ADC12TOVIFG             (0x0004)        /* Interrupt Source: Conversion time overflow, Interrupt Flag: 
                                                            ADC12TOVIFG */
#define ADC12IV__ADC12TOVIFG_L           (0x0004)
#define ADC12IV__ADC12HIIFG              (0x0006)        /* Interrupt Source: ADC12 window high interrupt flag, Interrupt 
                                                            Flag: ADC12HIIFG */
#define ADC12IV__ADC12HIIFG_L            (0x0006)
#define ADC12IV__ADC12LOIFG              (0x0008)        /* Interrupt Source: ADC12 window low interrupt flag, Interrupt 
                                                            Flag: ADC12LOIFG */
#define ADC12IV__ADC12LOIFG_L            (0x0008)
#define ADC12IV__ADC12INIFG              (0x000a)        /* Interrupt Source: ADC12 in-window interrupt flag, Interrupt 
                                                            Flag: ADC12INIFG */
#define ADC12IV__ADC12INIFG_L            (0x000a)
#define ADC12IV__ADC12IFG0               (0x000c)        /* Interrupt Source: ADC12MEM0 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG0 */
#define ADC12IV__ADC12IFG0_L             (0x000c)
#define ADC12IV__ADC12IFG1               (0x000e)        /* Interrupt Source: ADC12MEM1 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG1 */
#define ADC12IV__ADC12IFG1_L             (0x000e)
#define ADC12IV__ADC12IFG2               (0x0010)        /* Interrupt Source: ADC12MEM2 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG2 */
#define ADC12IV__ADC12IFG2_L             (0x0010)
#define ADC12IV__ADC12IFG3               (0x0012)        /* Interrupt Source: ADC12MEM3 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG3 */
#define ADC12IV__ADC12IFG3_L             (0x0012)
#define ADC12IV__ADC12IFG4               (0x0014)        /* Interrupt Source: ADC12MEM4 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG4 */
#define ADC12IV__ADC12IFG4_L             (0x0014)
#define ADC12IV__ADC12IFG5               (0x0016)        /* Interrupt Source: ADC12MEM5 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG5 */
#define ADC12IV__ADC12IFG5_L             (0x0016)
#define ADC12IV__ADC12IFG6               (0x0018)        /* Interrupt Source: ADC12MEM6 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG6 */
#define ADC12IV__ADC12IFG6_L             (0x0018)
#define ADC12IV__ADC12IFG7               (0x001a)        /* Interrupt Source: ADC12MEM7 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG7 */
#define ADC12IV__ADC12IFG7_L             (0x001a)
#define ADC12IV__ADC12IFG8               (0x001c)        /* Interrupt Source: ADC12MEM8 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG8 */
#define ADC12IV__ADC12IFG8_L             (0x001c)
#define ADC12IV__ADC12IFG9               (0x001e)        /* Interrupt Source: ADC12MEM9 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG9 */
#define ADC12IV__ADC12IFG9_L             (0x001e)
#define ADC12IV__ADC12IFG10              (0x0020)        /* Interrupt Source: ADC12MEM10 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG10 */
#define ADC12IV__ADC12IFG10_L            (0x0020)
#define ADC12IV__ADC12IFG11              (0x0022)        /* Interrupt Source: ADC12MEM11 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG11 */
#define ADC12IV__ADC12IFG11_L            (0x0022)
#define ADC12IV__ADC12IFG12              (0x0024)        /* Interrupt Source: ADC12MEM12 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG12 */
#define ADC12IV__ADC12IFG12_L            (0x0024)
#define ADC12IV__ADC12IFG13              (0x0026)        /* Interrupt Source: ADC12MEM13 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG13 */
#define ADC12IV__ADC12IFG13_L            (0x0026)
#define ADC12IV__ADC12IFG14              (0x0028)        /* Interrupt Source: ADC12MEM14 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG14 */
#define ADC12IV__ADC12IFG14_L            (0x0028)
#define ADC12IV__ADC12IFG15              (0x002a)        /* Interrupt Source: ADC12MEM15 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG15 */
#define ADC12IV__ADC12IFG15_L            (0x002a)
#define ADC12IV__ADC12IFG16              (0x002c)        /* Interrupt Source: ADC12MEM16 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG16 */
#define ADC12IV__ADC12IFG16_L            (0x002c)
#define ADC12IV__ADC12IFG17              (0x002e)        /* Interrupt Source: ADC12MEM17 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG17 */
#define ADC12IV__ADC12IFG17_L            (0x002e)
#define ADC12IV__ADC12IFG18              (0x0030)        /* Interrupt Source: ADC12MEM18 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG18 */
#define ADC12IV__ADC12IFG18_L            (0x0030)
#define ADC12IV__ADC12IFG19              (0x0032)        /* Interrupt Source: ADC12MEM19 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG19 */
#define ADC12IV__ADC12IFG19_L            (0x0032)
#define ADC12IV__ADC12IFG20              (0x0034)        /* Interrupt Source: ADC12MEM20 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG20 */
#define ADC12IV__ADC12IFG20_L            (0x0034)
#define ADC12IV__ADC12IFG21              (0x0036)        /* Interrupt Source: ADC12MEM21 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG21 */
#define ADC12IV__ADC12IFG21_L            (0x0036)
#define ADC12IV__ADC12IFG22              (0x0038)        /* Interrupt Source: ADC12MEM22 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG22 */
#define ADC12IV__ADC12IFG22_L            (0x0038)
#define ADC12IV__ADC12IFG23              (0x003a)        /* Interrupt Source: ADC12MEM23 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG23 */
#define ADC12IV__ADC12IFG23_L            (0x003a)
#define ADC12IV__ADC12IFG24              (0x003c)        /* Interrupt Source: ADC12MEM24 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG24 */
#define ADC12IV__ADC12IFG24_L            (0x003c)
#define ADC12IV__ADC12IFG25              (0x003e)        /* Interrupt Source: ADC12MEM25 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG25 */
#define ADC12IV__ADC12IFG25_L            (0x003e)
#define ADC12IV__ADC12IFG26              (0x0040)        /* Interrupt Source: ADC12MEM26 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG26 */
#define ADC12IV__ADC12IFG26_L            (0x0040)
#define ADC12IV__ADC12IFG27              (0x0042)        /* Interrupt Source: ADC12MEM27 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG27 */
#define ADC12IV__ADC12IFG27_L            (0x0042)
#define ADC12IV__ADC12IFG28              (0x0044)        /* Interrupt Source: ADC12MEM28 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG28 */
#define ADC12IV__ADC12IFG28_L            (0x0044)
#define ADC12IV__ADC12IFG29              (0x0046)        /* Interrupt Source: ADC12MEM29 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG29 */
#define ADC12IV__ADC12IFG29_L            (0x0046)
#define ADC12IV__ADC12IFG30              (0x0048)        /* Interrupt Source: ADC12MEM30 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG30 */
#define ADC12IV__ADC12IFG30_L            (0x0048)
#define ADC12IV__ADC12IFG31              (0x004a)        /* Interrupt Source: ADC12MEM31 interrupt flag, Interrupt Flag: 
                                                            ADC12IFG31 */
#define ADC12IV__ADC12IFG31_L            (0x004a)
#define ADC12IV__ADC12RDYIFG             (0x004c)        /* Interrupt Source: ADC12RDYIFG interrupt flag, Interrupt Flag: 
                                                            ADC12RDYIFG */
#define ADC12IV__ADC12RDYIFG_L           (0x004c)

/* ADC12MCTL Control Bits */
#define ADC12INCH                        (0x001f)        /* Input channel select */
#define ADC12INCH_L                      (0x001f)
#define ADC12INCH0                       (0x0001)        /* Input channel select */
#define ADC12INCH0_L                     (0x0001)
#define ADC12INCH1                       (0x0002)        /* Input channel select */
#define ADC12INCH1_L                     (0x0002)
#define ADC12INCH2                       (0x0004)        /* Input channel select */
#define ADC12INCH2_L                     (0x0004)
#define ADC12INCH3                       (0x0008)        /* Input channel select */
#define ADC12INCH3_L                     (0x0008)
#define ADC12INCH4                       (0x0010)        /* Input channel select */
#define ADC12INCH4_L                     (0x0010)
#define ADC12INCH_0                      (0x0000)        /* If ADC12DIF = 0: A0; If ADC12DIF = 1: Ain+ = A0, Ain- = A1 */
#define ADC12INCH_1                      (0x0001)        /* If ADC12DIF = 0: A1; If ADC12DIF = 1: Ain+ = A0, Ain- = A1 */
#define ADC12INCH_1_L                    (0x0001)
#define ADC12INCH_2                      (0x0002)        /* If ADC12DIF = 0: A2; If ADC12DIF = 1: Ain+ = A2, Ain- = A3 */
#define ADC12INCH_2_L                    (0x0002)
#define ADC12INCH_3                      (0x0003)        /* If ADC12DIF = 0: A3; If ADC12DIF = 1: Ain+ = A2, Ain- = A3 */
#define ADC12INCH_3_L                    (0x0003)
#define ADC12INCH_4                      (0x0004)        /* If ADC12DIF = 0: A4; If ADC12DIF = 1: Ain+ = A4, Ain- = A5 */
#define ADC12INCH_4_L                    (0x0004)
#define ADC12INCH_5                      (0x0005)        /* If ADC12DIF = 0: A5; If ADC12DIF = 1: Ain+ = A4, Ain- = A5 */
#define ADC12INCH_5_L                    (0x0005)
#define ADC12INCH_6                      (0x0006)        /* If ADC12DIF = 0: A6; If ADC12DIF = 1: Ain+ = A6, Ain- = A7 */
#define ADC12INCH_6_L                    (0x0006)
#define ADC12INCH_7                      (0x0007)        /* If ADC12DIF = 0: A7; If ADC12DIF = 1: Ain+ = A6, Ain- = A7 */
#define ADC12INCH_7_L                    (0x0007)
#define ADC12INCH_8                      (0x0008)        /* If ADC12DIF = 0: A8; If ADC12DIF = 1: Ain+ = A8, Ain- = A9 */
#define ADC12INCH_8_L                    (0x0008)
#define ADC12INCH_9                      (0x0009)        /* If ADC12DIF = 0: A9; If ADC12DIF = 1: Ain+ = A8, Ain- = A9 */
#define ADC12INCH_9_L                    (0x0009)
#define ADC12INCH_10                     (0x000a)        /* If ADC12DIF = 0: A10; If ADC12DIF = 1: Ain+ = A10, Ain- = A11 */
#define ADC12INCH_10_L                   (0x000a)
#define ADC12INCH_11                     (0x000b)        /* If ADC12DIF = 0: A11; If ADC12DIF = 1: Ain+ = A10, Ain- = A11 */
#define ADC12INCH_11_L                   (0x000b)
#define ADC12INCH_12                     (0x000c)        /* If ADC12DIF = 0: A12; If ADC12DIF = 1: Ain+ = A12, Ain- = A13 */
#define ADC12INCH_12_L                   (0x000c)
#define ADC12INCH_13                     (0x000d)        /* If ADC12DIF = 0: A13; If ADC12DIF = 1: Ain+ = A12, Ain- = A13 */
#define ADC12INCH_13_L                   (0x000d)
#define ADC12INCH_14                     (0x000e)        /* If ADC12DIF = 0: A14; If ADC12DIF = 1: Ain+ = A14, Ain- = A15 */
#define ADC12INCH_14_L                   (0x000e)
#define ADC12INCH_15                     (0x000f)        /* If ADC12DIF = 0: A15; If ADC12DIF = 1: Ain+ = A14, Ain- = A15 */
#define ADC12INCH_15_L                   (0x000f)
#define ADC12INCH_16                     (0x0010)        /* If ADC12DIF = 0: A16; If ADC12DIF = 1: Ain+ = A16, Ain- = A17 */
#define ADC12INCH_16_L                   (0x0010)
#define ADC12INCH_17                     (0x0011)        /* If ADC12DIF = 0: A17; If ADC12DIF = 1: Ain+ = A16, Ain- = A17 */
#define ADC12INCH_17_L                   (0x0011)
#define ADC12INCH_18                     (0x0012)        /* If ADC12DIF = 0: A18; If ADC12DIF = 1: Ain+ = A18, Ain- = A19 */
#define ADC12INCH_18_L                   (0x0012)
#define ADC12INCH_19                     (0x0013)        /* If ADC12DIF = 0: A19; If ADC12DIF = 1: Ain+ = A18, Ain- = A19 */
#define ADC12INCH_19_L                   (0x0013)
#define ADC12INCH_20                     (0x0014)        /* If ADC12DIF = 0: A20; If ADC12DIF = 1: Ain+ = A20, Ain- = A21 */
#define ADC12INCH_20_L                   (0x0014)
#define ADC12INCH_21                     (0x0015)        /* If ADC12DIF = 0: A21; If ADC12DIF = 1: Ain+ = A20, Ain- = A21 */
#define ADC12INCH_21_L                   (0x0015)
#define ADC12INCH_22                     (0x0016)        /* If ADC12DIF = 0: A22; If ADC12DIF = 1: Ain+ = A22, Ain- = A23 */
#define ADC12INCH_22_L                   (0x0016)
#define ADC12INCH_23                     (0x0017)        /* If ADC12DIF = 0: A23; If ADC12DIF = 1: Ain+ = A22, Ain- = A23 */
#define ADC12INCH_23_L                   (0x0017)
#define ADC12INCH_24                     (0x0018)        /* If ADC12DIF = 0: A24; If ADC12DIF = 1: Ain+ = A24, Ain- = A25 */
#define ADC12INCH_24_L                   (0x0018)
#define ADC12INCH_25                     (0x0019)        /* If ADC12DIF = 0: A25; If ADC12DIF = 1: Ain+ = A24, Ain- = A25 */
#define ADC12INCH_25_L                   (0x0019)
#define ADC12INCH_26                     (0x001a)        /* If ADC12DIF = 0: A26; If ADC12DIF = 1: Ain+ = A26, Ain- =A27 */
#define ADC12INCH_26_L                   (0x001a)
#define ADC12INCH_27                     (0x001b)        /* If ADC12DIF = 0: A27; If ADC12DIF = 1: Ain+ = A26, Ain- = A27 */
#define ADC12INCH_27_L                   (0x001b)
#define ADC12INCH_28                     (0x001c)        /* If ADC12DIF = 0: A28; If ADC12DIF = 1: Ain+ = A28, Ain- = A29 */
#define ADC12INCH_28_L                   (0x001c)
#define ADC12INCH_29                     (0x001d)        /* If ADC12DIF = 0: A29; If ADC12DIF = 1: Ain+ = A28, Ain- = A29 */
#define ADC12INCH_29_L                   (0x001d)
#define ADC12INCH_30                     (0x001e)        /* If ADC12DIF = 0: A30; If ADC12DIF = 1: Ain+ = A30, Ain- = A31 */
#define ADC12INCH_30_L                   (0x001e)
#define ADC12INCH_31                     (0x001f)        /* If ADC12DIF = 0: A31; If ADC12DIF = 1: Ain+ = A30, Ain- = A31 */
#define ADC12INCH_31_L                   (0x001f)
#define ADC12EOS                         (0x0080)        /* End of sequence */
#define ADC12EOS_L                       (0x0080)
#define ADC12EOS_0                       (0x0000)        /* Not end of sequence */
#define ADC12EOS_1                       (0x0080)        /* End of sequence */
#define ADC12EOS_1_L                     (0x0080)
#define ADC12VRSEL                       (0x0f00)        /* reference selection */
#define ADC12VRSEL_H                     (0x000f)
#define ADC12VRSEL0                      (0x0100)        /* reference selection */
#define ADC12VRSEL0_H                    (0x0001)
#define ADC12VRSEL1                      (0x0200)        /* reference selection */
#define ADC12VRSEL1_H                    (0x0002)
#define ADC12VRSEL2                      (0x0400)        /* reference selection */
#define ADC12VRSEL2_H                    (0x0004)
#define ADC12VRSEL3                      (0x0800)        /* reference selection */
#define ADC12VRSEL3_H                    (0x0008)
#define ADC12VRSEL_0                     (0x0000)        /* VR+ = AVCC, VR- = AVSS */
#define ADC12VRSEL_1                     (0x0100)        /* VR+ = VREF buffered, VR- = AVSS */
#define ADC12VRSEL_1_H                   (0x0001)
#define ADC12VRSEL_2                     (0x0200)        /* VR+ = VeREF-, VR- = AVSS */
#define ADC12VRSEL_2_H                   (0x0002)
#define ADC12VRSEL_3                     (0x0300)        /* VR+ = VeREF+ buffered, VR- = AVSS */
#define ADC12VRSEL_3_H                   (0x0003)
#define ADC12VRSEL_4                     (0x0400)        /* VR+ = VeREF+, VR- = AVSS */
#define ADC12VRSEL_4_H                   (0x0004)
#define ADC12VRSEL_5                     (0x0500)        /* VR+ = AVCC, VR- = VeREF+ buffered */
#define ADC12VRSEL_5_H                   (0x0005)
#define ADC12VRSEL_6                     (0x0600)        /* VR+ = AVCC, VR- = VeREF+ */
#define ADC12VRSEL_6_H                   (0x0006)
#define ADC12VRSEL_7                     (0x0700)        /* VR+ = VREF buffered, VR- = VeREF+ */
#define ADC12VRSEL_7_H                   (0x0007)
#define ADC12VRSEL_8                     (0x0800)        /* Reserved */
#define ADC12VRSEL_8_H                   (0x0008)
#define ADC12VRSEL_9                     (0x0900)        /* VR+ = AVCC, VR- = VREF buffered */
#define ADC12VRSEL_9_H                   (0x0009)
#define ADC12VRSEL_10                    (0x0a00)        /* Reserved */
#define ADC12VRSEL_10_H                  (0x000a)
#define ADC12VRSEL_11                    (0x0b00)        /* VR+ = VeREF+, VR- = VREF buffered */
#define ADC12VRSEL_11_H                  (0x000b)
#define ADC12VRSEL_12                    (0x0c00)        /* VR+ = AVCC, VR- = VeREF- */
#define ADC12VRSEL_12_H                  (0x000c)
#define ADC12VRSEL_13                    (0x0d00)        /* VR+ = VREF buffered, VR- = VeREF- */
#define ADC12VRSEL_13_H                  (0x000d)
#define ADC12VRSEL_14                    (0x0e00)        /* VR+ = VeREF+, VR- = VeREF- */
#define ADC12VRSEL_14_H                  (0x000e)
#define ADC12VRSEL_15                    (0x0f00)        /* VR+ = VeREF+ buffered, VR- = VeREF- */
#define ADC12VRSEL_15_H                  (0x000f)
#define ADC12DIF                         (0x2000)        /* Differential mode. */
#define ADC12DIF_H                       (0x0020)
#define ADC12DIF_0                       (0x0000)        /* Single-ended mode enabled */
#define ADC12DIF_1                       (0x2000)        /* Differential mode enabled */
#define ADC12DIF_1_H                     (0x0020)
#define ADC12WINC                        (0x4000)        /* Comparator window enable */
#define ADC12WINC_H                      (0x0040)
#define ADC12WINC_0                      (0x0000)        /* Comparator window disabled */
#define ADC12WINC_1                      (0x4000)        /* Comparator window enabled */
#define ADC12WINC_1_H                    (0x0040)

/* ADC12MEM Control Bits */
#define CONVERSION_RESULTS               (0xffff)        /* Conversion Results */
#define CONVERSION_RESULTS_L             (0x00ff)
#define CONVERSION_RESULTS_H             (0x00ff)
#define CONVERSION_RESULTS0              (0x0001)        /* Conversion Results */
#define CONVERSION_RESULTS0_L            (0x0001)
#define CONVERSION_RESULTS1              (0x0002)        /* Conversion Results */
#define CONVERSION_RESULTS1_L            (0x0002)
#define CONVERSION_RESULTS2              (0x0004)        /* Conversion Results */
#define CONVERSION_RESULTS2_L            (0x0004)
#define CONVERSION_RESULTS3              (0x0008)        /* Conversion Results */
#define CONVERSION_RESULTS3_L            (0x0008)
#define CONVERSION_RESULTS4              (0x0010)        /* Conversion Results */
#define CONVERSION_RESULTS4_L            (0x0010)
#define CONVERSION_RESULTS5              (0x0020)        /* Conversion Results */
#define CONVERSION_RESULTS5_L            (0x0020)
#define CONVERSION_RESULTS6              (0x0040)        /* Conversion Results */
#define CONVERSION_RESULTS6_L            (0x0040)
#define CONVERSION_RESULTS7              (0x0080)        /* Conversion Results */
#define CONVERSION_RESULTS7_L            (0x0080)
#define CONVERSION_RESULTS8              (0x0100)        /* Conversion Results */
#define CONVERSION_RESULTS8_H            (0x0001)
#define CONVERSION_RESULTS9              (0x0200)        /* Conversion Results */
#define CONVERSION_RESULTS9_H            (0x0002)
#define CONVERSION_RESULTS10             (0x0400)        /* Conversion Results */
#define CONVERSION_RESULTS10_H           (0x0004)
#define CONVERSION_RESULTS11             (0x0800)        /* Conversion Results */
#define CONVERSION_RESULTS11_H           (0x0008)
#define CONVERSION_RESULTS12             (0x1000)        /* Conversion Results */
#define CONVERSION_RESULTS12_H           (0x0010)
#define CONVERSION_RESULTS13             (0x2000)        /* Conversion Results */
#define CONVERSION_RESULTS13_H           (0x0020)
#define CONVERSION_RESULTS14             (0x4000)        /* Conversion Results */
#define CONVERSION_RESULTS14_H           (0x0040)
#define CONVERSION_RESULTS15             (0x8000)        /* Conversion Results */
#define CONVERSION_RESULTS15_H           (0x0080)


/*****************************************************************************
 AES256 Registers
*****************************************************************************/

#define __MSP430_HAS_AES256__                 /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_AES256__ 0x09C0
#define AES256_BASE            __MSP430_BASEADDRESS_AES256__

sfr_w(AESACTL0);                              /* AES Accelerator Control Register 0 */
sfr_b(AESACTL0_L);
sfr_b(AESACTL0_H);
sfr_w(AESACTL1);                              /* AES Accelerator Control Register 1 */
sfr_b(AESACTL1_L);
sfr_b(AESACTL1_H);
sfr_w(AESASTAT);                              /* AES Accelerator Status Register */
sfr_b(AESASTAT_L);
sfr_b(AESASTAT_H);
sfr_w(AESAKEY);                               /* AES Accelerator Key Register */
sfr_b(AESAKEY_L);
sfr_b(AESAKEY_H);
sfr_w(AESADIN);                               /* AES Accelerator Data In Register */
sfr_b(AESADIN_L);
sfr_b(AESADIN_H);
sfr_w(AESADOUT);                              /* AES Accelerator Data Out Register */
sfr_b(AESADOUT_L);
sfr_b(AESADOUT_H);
sfr_w(AESAXDIN);                              /* AES Accelerator XORed Data In Register */
sfr_b(AESAXDIN_L);
sfr_b(AESAXDIN_H);
sfr_w(AESAXIN);                               /* AES Accelerator XORed Data In Register */
sfr_b(AESAXIN_L);
sfr_b(AESAXIN_H);

/* AES256 Register Offsets */
#define OFS_AESACTL0                     (0x0000)
#define OFS_AESACTL0_L                   OFS_AESACTL0
#define OFS_AESACTL0_H                   OFS_AESACTL0+1
#define OFS_AESACTL1                     (0x0002)
#define OFS_AESACTL1_L                   OFS_AESACTL1
#define OFS_AESACTL1_H                   OFS_AESACTL1+1
#define OFS_AESASTAT                     (0x0004)
#define OFS_AESASTAT_L                   OFS_AESASTAT
#define OFS_AESASTAT_H                   OFS_AESASTAT+1
#define OFS_AESAKEY                      (0x0006)
#define OFS_AESAKEY_L                    OFS_AESAKEY
#define OFS_AESAKEY_H                    OFS_AESAKEY+1
#define OFS_AESADIN                      (0x0008)
#define OFS_AESADIN_L                    OFS_AESADIN
#define OFS_AESADIN_H                    OFS_AESADIN+1
#define OFS_AESADOUT                     (0x000A)
#define OFS_AESADOUT_L                   OFS_AESADOUT
#define OFS_AESADOUT_H                   OFS_AESADOUT+1
#define OFS_AESAXDIN                     (0x000C)
#define OFS_AESAXDIN_L                   OFS_AESAXDIN
#define OFS_AESAXDIN_H                   OFS_AESAXDIN+1
#define OFS_AESAXIN                      (0x000E)
#define OFS_AESAXIN_L                    OFS_AESAXIN
#define OFS_AESAXIN_H                    OFS_AESAXIN+1

/* AES256 Control Bits */

/* AESACTL0 Control Bits */
#define AESOP                            (0x0003)        /* AES operation */
#define AESOP_L                          (0x0003)
#define AESOP0                           (0x0001)        /* AES operation */
#define AESOP0_L                         (0x0001)
#define AESOP1                           (0x0002)        /* AES operation */
#define AESOP1_L                         (0x0002)
#define AESOP_0                          (0x0000)        /* Encryption */
#define AESOP_1                          (0x0001)        /* Decryption. The provided key is the same key used for 
                                                            encryption */
#define AESOP_1_L                        (0x0001)
#define AESOP_2                          (0x0002)        /* Generate first round key required for decryption */
#define AESOP_2_L                        (0x0002)
#define AESOP_3                          (0x0003)        /* Decryption. The provided key is the first round key required 
                                                            for decryption */
#define AESOP_3_L                        (0x0003)
#define AESKL                            (0x000c)        /* AES key length */
#define AESKL_L                          (0x000c)
#define AESKL0                           (0x0004)        /* AES key length */
#define AESKL0_L                         (0x0004)
#define AESKL1                           (0x0008)        /* AES key length */
#define AESKL1_L                         (0x0008)
#define AESKL_0                          (0x0000)        /* AES128. The key size is 128 bit */
#define AESKL_1                          (0x0004)        /* AES192. The key size is 192 bit. */
#define AESKL_1_L                        (0x0004)
#define AESKL_2                          (0x0008)        /* AES256. The key size is 256 bit */
#define AESKL_2_L                        (0x0008)
#define AESKL__128                       (0x0000)        /* AES128. The key size is 128 bit */
#define AESKL__192                       (0x0004)        /* AES192. The key size is 192 bit. */
#define AESKL__192_L                     (0x0004)
#define AESKL__256                       (0x0008)        /* AES256. The key size is 256 bit */
#define AESKL__256_L                     (0x0008)
#define AESCM                            (0x0060)        /* AES cipher mode select */
#define AESCM_L                          (0x0060)
#define AESCM0                           (0x0020)        /* AES cipher mode select */
#define AESCM0_L                         (0x0020)
#define AESCM1                           (0x0040)        /* AES cipher mode select */
#define AESCM1_L                         (0x0040)
#define AESCM_0                          (0x0000)        /* ECB */
#define AESCM_1                          (0x0020)        /* CBC */
#define AESCM_1_L                        (0x0020)
#define AESCM_2                          (0x0040)        /* OFB */
#define AESCM_2_L                        (0x0040)
#define AESCM_3                          (0x0060)        /* CFB */
#define AESCM_3_L                        (0x0060)
#define AESCM__ECB                       (0x0000)        /* ECB */
#define AESCM__CBC                       (0x0020)        /* CBC */
#define AESCM__CBC_L                     (0x0020)
#define AESCM__OFB                       (0x0040)        /* OFB */
#define AESCM__OFB_L                     (0x0040)
#define AESCM__CFB                       (0x0060)        /* CFB */
#define AESCM__CFB_L                     (0x0060)
#define AESSWRST                         (0x0080)        /* AES software reset */
#define AESSWRST_L                       (0x0080)
#define AESSWRST_0                       (0x0000)        /* No reset */
#define AESSWRST_1                       (0x0080)        /* Reset AES accelerator module */
#define AESSWRST_1_L                     (0x0080)
#define AESSWRST__RESET                  (0x0080)        /* Reset AES accelerator module */
#define AESSWRST__RESET_L                (0x0080)
#define AESRDYIFG                        (0x0100)        /* AES ready interrupt flag */
#define AESRDYIFG_H                      (0x0001)
#define AESRDYIFG_0                      (0x0000)        /* No interrupt pending */
#define AESRDYIFG_1                      (0x0100)        /* Interrupt pending */
#define AESRDYIFG_1_H                    (0x0001)
#define AESERRFG                         (0x0800)        /* AES error flag */
#define AESERRFG_H                       (0x0008)
#define AESERRFG_0                       (0x0000)        /* No error */
#define AESERRFG_1                       (0x0800)        /* Error occurred */
#define AESERRFG_1_H                     (0x0008)
#define AESRDYIE                         (0x1000)        /* AES ready interrupt enable */
#define AESRDYIE_H                       (0x0010)
#define AESRDYIE_0                       (0x0000)        /* Interrupt disabled */
#define AESRDYIE_1                       (0x1000)        /* Interrupt enabled */
#define AESRDYIE_1_H                     (0x0010)
#define AESRDYIE__DISABLE                (0x0000)        /* Interrupt disabled */
#define AESRDYIE__ENABLE                 (0x1000)        /* Interrupt enabled */
#define AESRDYIE__ENABLE_H               (0x0010)
#define AESCMEN                          (0x8000)        /* AES cipher mode enable */
#define AESCMEN_H                        (0x0080)
#define AESCMEN_0                        (0x0000)        /* No DMA triggers are generated */
#define AESCMEN_1                        (0x8000)        /* DMA ciphermode support operation is enabled and the 
                                                            corresponding DMA triggers are generated */
#define AESCMEN_1_H                      (0x0080)
#define AESCMEN__DISABLE                 (0x0000)        /* No DMA triggers are generated */
#define AESCMEN__ENABLE                  (0x8000)        /* DMA ciphermode support operation is enabled and the 
                                                            corresponding DMA triggers are generated */
#define AESCMEN__ENABLE_H                (0x0080)

/* AESACTL1 Control Bits */
#define AESBLKCNT                        (0x00ff)        /* Cipher Block Counter */
#define AESBLKCNT_L                      (0x00ff)
#define AESBLKCNT0                       (0x0001)        /* Cipher Block Counter */
#define AESBLKCNT0_L                     (0x0001)
#define AESBLKCNT1                       (0x0002)        /* Cipher Block Counter */
#define AESBLKCNT1_L                     (0x0002)
#define AESBLKCNT2                       (0x0004)        /* Cipher Block Counter */
#define AESBLKCNT2_L                     (0x0004)
#define AESBLKCNT3                       (0x0008)        /* Cipher Block Counter */
#define AESBLKCNT3_L                     (0x0008)
#define AESBLKCNT4                       (0x0010)        /* Cipher Block Counter */
#define AESBLKCNT4_L                     (0x0010)
#define AESBLKCNT5                       (0x0020)        /* Cipher Block Counter */
#define AESBLKCNT5_L                     (0x0020)
#define AESBLKCNT6                       (0x0040)        /* Cipher Block Counter */
#define AESBLKCNT6_L                     (0x0040)
#define AESBLKCNT7                       (0x0080)        /* Cipher Block Counter */
#define AESBLKCNT7_L                     (0x0080)

/* AESASTAT Control Bits */
#define AESBUSY                          (0x0001)        /* AES accelerator module busy */
#define AESBUSY_L                        (0x0001)
#define AESBUSY_0                        (0x0000)        /* Not busy */
#define AESBUSY_1                        (0x0001)        /* Busy */
#define AESBUSY_1_L                      (0x0001)
#define AESBUSY__IDLE                    (0x0000)        /* Not busy */
#define AESBUSY__BUSY                    (0x0001)        /* Busy */
#define AESBUSY__BUSY_L                  (0x0001)
#define AESKEYWR                         (0x0002)        /* All 16 bytes written to AESAKEY */
#define AESKEYWR_L                       (0x0002)
#define AESKEYWR_0                       (0x0000)        /* Not all bytes written */
#define AESKEYWR_1                       (0x0002)        /* All bytes written */
#define AESKEYWR_1_L                     (0x0002)
#define AESDINWR                         (0x0004)        /* All 16 bytes written to AESADIN, AESAXDIN or AESAXIN */
#define AESDINWR_L                       (0x0004)
#define AESDINWR_0                       (0x0000)        /* Not all bytes written */
#define AESDINWR_1                       (0x0004)        /* All bytes written */
#define AESDINWR_1_L                     (0x0004)
#define AESDOUTRD                        (0x0008)        /* All 16 bytes read from AESADOUT */
#define AESDOUTRD_L                      (0x0008)
#define AESDOUTRD_0                      (0x0000)        /* Not all bytes read */
#define AESDOUTRD_1                      (0x0008)        /* All bytes read */
#define AESDOUTRD_1_L                    (0x0008)
#define AESKEYCNT                        (0x00f0)        /* Bytes written via AESAKEY for AESKL=00, half-words written via
                                                            AESAKEY */
#define AESKEYCNT_L                      (0x00f0)
#define AESKEYCNT0                       (0x0010)        /* Bytes written via AESAKEY for AESKL=00, half-words written via
                                                            AESAKEY */
#define AESKEYCNT0_L                     (0x0010)
#define AESKEYCNT1                       (0x0020)        /* Bytes written via AESAKEY for AESKL=00, half-words written via
                                                            AESAKEY */
#define AESKEYCNT1_L                     (0x0020)
#define AESKEYCNT2                       (0x0040)        /* Bytes written via AESAKEY for AESKL=00, half-words written via
                                                            AESAKEY */
#define AESKEYCNT2_L                     (0x0040)
#define AESKEYCNT3                       (0x0080)        /* Bytes written via AESAKEY for AESKL=00, half-words written via
                                                            AESAKEY */
#define AESKEYCNT3_L                     (0x0080)
#define AESDINCNT                        (0x0f00)        /* Bytes written via AESADIN, AESAXDIN or AESAXIN */
#define AESDINCNT_H                      (0x000f)
#define AESDINCNT0                       (0x0100)        /* Bytes written via AESADIN, AESAXDIN or AESAXIN */
#define AESDINCNT0_H                     (0x0001)
#define AESDINCNT1                       (0x0200)        /* Bytes written via AESADIN, AESAXDIN or AESAXIN */
#define AESDINCNT1_H                     (0x0002)
#define AESDINCNT2                       (0x0400)        /* Bytes written via AESADIN, AESAXDIN or AESAXIN */
#define AESDINCNT2_H                     (0x0004)
#define AESDINCNT3                       (0x0800)        /* Bytes written via AESADIN, AESAXDIN or AESAXIN */
#define AESDINCNT3_H                     (0x0008)
#define AESDOUTCNT                       (0xf000)        /* Bytes read via AESADOUT */
#define AESDOUTCNT_H                     (0x00f0)
#define AESDOUTCNT0                      (0x1000)        /* Bytes read via AESADOUT */
#define AESDOUTCNT0_H                    (0x0010)
#define AESDOUTCNT1                      (0x2000)        /* Bytes read via AESADOUT */
#define AESDOUTCNT1_H                    (0x0020)
#define AESDOUTCNT2                      (0x4000)        /* Bytes read via AESADOUT */
#define AESDOUTCNT2_H                    (0x0040)
#define AESDOUTCNT3                      (0x8000)        /* Bytes read via AESADOUT */
#define AESDOUTCNT3_H                    (0x0080)

/* AESAKEY Control Bits */
#define AESKEY0                          (0x00ff)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY0_L                        (0x00ff)
#define AESKEY00                         (0x0001)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY00_L                       (0x0001)
#define AESKEY01                         (0x0002)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY01_L                       (0x0002)
#define AESKEY02                         (0x0004)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY02_L                       (0x0004)
#define AESKEY03                         (0x0008)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY03_L                       (0x0008)
#define AESKEY04                         (0x0010)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY04_L                       (0x0010)
#define AESKEY05                         (0x0020)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY05_L                       (0x0020)
#define AESKEY06                         (0x0040)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY06_L                       (0x0040)
#define AESKEY07                         (0x0080)        /* AES key byte n when AESAKEY is written as half-word */
#define AESKEY07_L                       (0x0080)
#define AESKEY1                          (0xff00)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY1_H                        (0x00ff)
#define AESKEY10                         (0x0100)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY10_H                       (0x0001)
#define AESKEY11                         (0x0200)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY11_H                       (0x0002)
#define AESKEY12                         (0x0400)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY12_H                       (0x0004)
#define AESKEY13                         (0x0800)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY13_H                       (0x0008)
#define AESKEY14                         (0x1000)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY14_H                       (0x0010)
#define AESKEY15                         (0x2000)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY15_H                       (0x0020)
#define AESKEY16                         (0x4000)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY16_H                       (0x0040)
#define AESKEY17                         (0x8000)        /* AES key byte n+1 when AESAKEY is written as half-word */
#define AESKEY17_H                       (0x0080)

/* AESADIN Control Bits */
#define AESDIN0                          (0x00ff)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN0_L                        (0x00ff)
#define AESDIN00                         (0x0001)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN00_L                       (0x0001)
#define AESDIN01                         (0x0002)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN01_L                       (0x0002)
#define AESDIN02                         (0x0004)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN02_L                       (0x0004)
#define AESDIN03                         (0x0008)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN03_L                       (0x0008)
#define AESDIN04                         (0x0010)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN04_L                       (0x0010)
#define AESDIN05                         (0x0020)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN05_L                       (0x0020)
#define AESDIN06                         (0x0040)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN06_L                       (0x0040)
#define AESDIN07                         (0x0080)        /* AES data in byte n when AESADIN is written as half-word */
#define AESDIN07_L                       (0x0080)
#define AESDIN1                          (0xff00)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN1_H                        (0x00ff)
#define AESDIN10                         (0x0100)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN10_H                       (0x0001)
#define AESDIN11                         (0x0200)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN11_H                       (0x0002)
#define AESDIN12                         (0x0400)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN12_H                       (0x0004)
#define AESDIN13                         (0x0800)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN13_H                       (0x0008)
#define AESDIN14                         (0x1000)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN14_H                       (0x0010)
#define AESDIN15                         (0x2000)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN15_H                       (0x0020)
#define AESDIN16                         (0x4000)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN16_H                       (0x0040)
#define AESDIN17                         (0x8000)        /* AES data in byte n+1 when AESADIN is written as half-word */
#define AESDIN17_H                       (0x0080)

/* AESADOUT Control Bits */
#define AESDOUT0                         (0x00ff)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT0_L                       (0x00ff)
#define AESDOUT00                        (0x0001)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT00_L                      (0x0001)
#define AESDOUT01                        (0x0002)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT01_L                      (0x0002)
#define AESDOUT02                        (0x0004)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT02_L                      (0x0004)
#define AESDOUT03                        (0x0008)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT03_L                      (0x0008)
#define AESDOUT04                        (0x0010)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT04_L                      (0x0010)
#define AESDOUT05                        (0x0020)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT05_L                      (0x0020)
#define AESDOUT06                        (0x0040)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT06_L                      (0x0040)
#define AESDOUT07                        (0x0080)        /* AES data out byte n when AESADOUT is read as half-word */
#define AESDOUT07_L                      (0x0080)
#define AESDOUT1                         (0xff00)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT1_H                       (0x00ff)
#define AESDOUT10                        (0x0100)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT10_H                      (0x0001)
#define AESDOUT11                        (0x0200)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT11_H                      (0x0002)
#define AESDOUT12                        (0x0400)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT12_H                      (0x0004)
#define AESDOUT13                        (0x0800)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT13_H                      (0x0008)
#define AESDOUT14                        (0x1000)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT14_H                      (0x0010)
#define AESDOUT15                        (0x2000)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT15_H                      (0x0020)
#define AESDOUT16                        (0x4000)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT16_H                      (0x0040)
#define AESDOUT17                        (0x8000)        /* AES data out byte n+1 when AESADOUT is read as half-word */
#define AESDOUT17_H                      (0x0080)

/* AESAXDIN Control Bits */
#define AESXDIN0                         (0x00ff)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN0_L                       (0x00ff)
#define AESXDIN00                        (0x0001)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN00_L                      (0x0001)
#define AESXDIN01                        (0x0002)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN01_L                      (0x0002)
#define AESXDIN02                        (0x0004)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN02_L                      (0x0004)
#define AESXDIN03                        (0x0008)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN03_L                      (0x0008)
#define AESXDIN04                        (0x0010)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN04_L                      (0x0010)
#define AESXDIN05                        (0x0020)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN05_L                      (0x0020)
#define AESXDIN06                        (0x0040)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN06_L                      (0x0040)
#define AESXDIN07                        (0x0080)        /* AES data in byte n when AESAXDIN is written as half-word */
#define AESXDIN07_L                      (0x0080)
#define AESXDIN1                         (0xff00)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN1_H                       (0x00ff)
#define AESXDIN10                        (0x0100)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN10_H                      (0x0001)
#define AESXDIN11                        (0x0200)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN11_H                      (0x0002)
#define AESXDIN12                        (0x0400)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN12_H                      (0x0004)
#define AESXDIN13                        (0x0800)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN13_H                      (0x0008)
#define AESXDIN14                        (0x1000)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN14_H                      (0x0010)
#define AESXDIN15                        (0x2000)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN15_H                      (0x0020)
#define AESXDIN16                        (0x4000)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN16_H                      (0x0040)
#define AESXDIN17                        (0x8000)        /* AES data in byte n+1 when AESAXDIN is written as half-word */
#define AESXDIN17_H                      (0x0080)

/* AESAXIN Control Bits */
#define AESXIN0                          (0x00ff)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN0_L                        (0x00ff)
#define AESXIN00                         (0x0001)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN00_L                       (0x0001)
#define AESXIN01                         (0x0002)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN01_L                       (0x0002)
#define AESXIN02                         (0x0004)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN02_L                       (0x0004)
#define AESXIN03                         (0x0008)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN03_L                       (0x0008)
#define AESXIN04                         (0x0010)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN04_L                       (0x0010)
#define AESXIN05                         (0x0020)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN05_L                       (0x0020)
#define AESXIN06                         (0x0040)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN06_L                       (0x0040)
#define AESXIN07                         (0x0080)        /* AES data in byte n when AESAXIN is written as half-word */
#define AESXIN07_L                       (0x0080)
#define AESXIN1                          (0xff00)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN1_H                        (0x00ff)
#define AESXIN10                         (0x0100)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN10_H                       (0x0001)
#define AESXIN11                         (0x0200)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN11_H                       (0x0002)
#define AESXIN12                         (0x0400)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN12_H                       (0x0004)
#define AESXIN13                         (0x0800)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN13_H                       (0x0008)
#define AESXIN14                         (0x1000)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN14_H                       (0x0010)
#define AESXIN15                         (0x2000)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN15_H                       (0x0020)
#define AESXIN16                         (0x4000)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN16_H                       (0x0040)
#define AESXIN17                         (0x8000)        /* AES data in byte n+1 when AESAXIN is written as half-word */
#define AESXIN17_H                       (0x0080)


/*****************************************************************************
 CAPTIO0 Registers
*****************************************************************************/

#define __MSP430_HAS_CAPTIO0__                /* Definition to show that module is available */
#ifndef __MSP430_HAS_CAPTIOx__
#define __MSP430_HAS_CAPTIOx__
#endif
#define __MSP430_BASEADDRESS_CAPTIO0__ 0x0430
#define CAPTIO0_BASE           __MSP430_BASEADDRESS_CAPTIO0__

sfr_w(CAPTIO0CTL);                            /* Capacitive Touch IO x Control Register */
sfr_b(CAPTIO0CTL_L);
sfr_b(CAPTIO0CTL_H);

/* CAPTIO0 Register Offsets */
#define OFS_CAPTIO0CTL                   (0x000E)
#define OFS_CAPTIO0CTL_L                 OFS_CAPTIO0CTL
#define OFS_CAPTIO0CTL_H                 OFS_CAPTIO0CTL+1

/* CAPTIO0 Control Bits */

/* CAPTIO0CTL Control Bits */
#define CAPTIOPISEL0                     (0x0002)        /* CAPTIOPISEL Bit 0 */
#define CAPTIOPISEL0_L                   (0x0002)
#define CAPTIOPISEL1                     (0x0004)        /* CAPTIOPISEL Bit 1 */
#define CAPTIOPISEL1_L                   (0x0004)
#define CAPTIOPISEL2                     (0x0008)        /* CAPTIOPISEL Bit 2 */
#define CAPTIOPISEL2_L                   (0x0008)
#define CAPTIOPISEL                      (0x000e)        /* Capacitive Touch IO pin select */
#define CAPTIOPISEL_L                    (0x000e)
#define CAPTIOPISEL_0                    (0x0000)        /* Px.0 */
#define CAPTIOPISEL_1                    (0x0002)        /* Px.1 */
#define CAPTIOPISEL_1_L                  (0x0002)
#define CAPTIOPISEL_2                    (0x0004)        /* Px.2 */
#define CAPTIOPISEL_2_L                  (0x0004)
#define CAPTIOPISEL_3                    (0x0006)        /* Px.3 */
#define CAPTIOPISEL_3_L                  (0x0006)
#define CAPTIOPISEL_4                    (0x0008)        /* Px.4 */
#define CAPTIOPISEL_4_L                  (0x0008)
#define CAPTIOPISEL_5                    (0x000a)        /* Px.5 */
#define CAPTIOPISEL_5_L                  (0x000a)
#define CAPTIOPISEL_6                    (0x000c)        /* Px.6 */
#define CAPTIOPISEL_6_L                  (0x000c)
#define CAPTIOPISEL_7                    (0x000e)        /* Px.7 */
#define CAPTIOPISEL_7_L                  (0x000e)
#define CAPTIOPOSEL0                     (0x0010)        /* CAPTIOPOSEL Bit 0 */
#define CAPTIOPOSEL0_L                   (0x0010)
#define CAPTIOPOSEL1                     (0x0020)        /* CAPTIOPOSEL Bit 1 */
#define CAPTIOPOSEL1_L                   (0x0020)
#define CAPTIOPOSEL2                     (0x0040)        /* CAPTIOPOSEL Bit 2 */
#define CAPTIOPOSEL2_L                   (0x0040)
#define CAPTIOPOSEL3                     (0x0080)        /* CAPTIOPOSEL Bit 3 */
#define CAPTIOPOSEL3_L                   (0x0080)
#define CAPTIOPOSEL                      (0x00f0)        /* Capacitive Touch IO port select */
#define CAPTIOPOSEL_L                    (0x00f0)
#define CAPTIOPOSEL_0                    (0x0000)        /* Px = PJ */
#define CAPTIOPOSEL_1                    (0x0010)        /* Px = P1 */
#define CAPTIOPOSEL_1_L                  (0x0010)
#define CAPTIOPOSEL_2                    (0x0020)        /* Px = P2 */
#define CAPTIOPOSEL_2_L                  (0x0020)
#define CAPTIOPOSEL_3                    (0x0030)        /* Px = P3 */
#define CAPTIOPOSEL_3_L                  (0x0030)
#define CAPTIOPOSEL_4                    (0x0040)        /* Px = P4 */
#define CAPTIOPOSEL_4_L                  (0x0040)
#define CAPTIOPOSEL_5                    (0x0050)        /* Px = P5 */
#define CAPTIOPOSEL_5_L                  (0x0050)
#define CAPTIOPOSEL_6                    (0x0060)        /* Px = P6 */
#define CAPTIOPOSEL_6_L                  (0x0060)
#define CAPTIOPOSEL_7                    (0x0070)        /* Px = P7 */
#define CAPTIOPOSEL_7_L                  (0x0070)
#define CAPTIOPOSEL_8                    (0x0080)        /* Px = P8 */
#define CAPTIOPOSEL_8_L                  (0x0080)
#define CAPTIOPOSEL_9                    (0x0090)        /* Px = P9 */
#define CAPTIOPOSEL_9_L                  (0x0090)
#define CAPTIOPOSEL_10                   (0x00a0)        /* Px = P10 */
#define CAPTIOPOSEL_10_L                 (0x00a0)
#define CAPTIOPOSEL_11                   (0x00b0)        /* Px = P11 */
#define CAPTIOPOSEL_11_L                 (0x00b0)
#define CAPTIOPOSEL_12                   (0x00c0)        /* Px = P12 */
#define CAPTIOPOSEL_12_L                 (0x00c0)
#define CAPTIOPOSEL_13                   (0x00d0)        /* Px = P13 */
#define CAPTIOPOSEL_13_L                 (0x00d0)
#define CAPTIOPOSEL_14                   (0x00e0)        /* Px = P14 */
#define CAPTIOPOSEL_14_L                 (0x00e0)
#define CAPTIOPOSEL_15                   (0x00f0)        /* Px = P15 */
#define CAPTIOPOSEL_15_L                 (0x00f0)
#define CAPTIOPOSEL__PJ                  (0x0000)        /* Px = PJ */
#define CAPTIOPOSEL__P1                  (0x0010)        /* Px = P1 */
#define CAPTIOPOSEL__P1_L                (0x0010)
#define CAPTIOPOSEL__P2                  (0x0020)        /* Px = P2 */
#define CAPTIOPOSEL__P2_L                (0x0020)
#define CAPTIOPOSEL__P3                  (0x0030)        /* Px = P3 */
#define CAPTIOPOSEL__P3_L                (0x0030)
#define CAPTIOPOSEL__P4                  (0x0040)        /* Px = P4 */
#define CAPTIOPOSEL__P4_L                (0x0040)
#define CAPTIOPOSEL__P5                  (0x0050)        /* Px = P5 */
#define CAPTIOPOSEL__P5_L                (0x0050)
#define CAPTIOPOSEL__P6                  (0x0060)        /* Px = P6 */
#define CAPTIOPOSEL__P6_L                (0x0060)
#define CAPTIOPOSEL__P7                  (0x0070)        /* Px = P7 */
#define CAPTIOPOSEL__P7_L                (0x0070)
#define CAPTIOPOSEL__P8                  (0x0080)        /* Px = P8 */
#define CAPTIOPOSEL__P8_L                (0x0080)
#define CAPTIOPOSEL__P9                  (0x0090)        /* Px = P9 */
#define CAPTIOPOSEL__P9_L                (0x0090)
#define CAPTIOPOSEL__P10                 (0x00a0)        /* Px = P10 */
#define CAPTIOPOSEL__P10_L               (0x00a0)
#define CAPTIOPOSEL__P11                 (0x00b0)        /* Px = P11 */
#define CAPTIOPOSEL__P11_L               (0x00b0)
#define CAPTIOPOSEL__P12                 (0x00c0)        /* Px = P12 */
#define CAPTIOPOSEL__P12_L               (0x00c0)
#define CAPTIOPOSEL__P13                 (0x00d0)        /* Px = P13 */
#define CAPTIOPOSEL__P13_L               (0x00d0)
#define CAPTIOPOSEL__P14                 (0x00e0)        /* Px = P14 */
#define CAPTIOPOSEL__P14_L               (0x00e0)
#define CAPTIOPOSEL__P15                 (0x00f0)        /* Px = P15 */
#define CAPTIOPOSEL__P15_L               (0x00f0)
#define CAPTIOEN                         (0x0100)        /* Capacitive Touch IO enable */
#define CAPTIOEN_H                       (0x0001)
#define CAPTIOEN_0                       (0x0000)        /* All Capacitive Touch IOs are disabled. Signal towards timers 
                                                            is 0. */
#define CAPTIOEN_1                       (0x0100)        /* Selected Capacitive Touch IO is enabled */
#define CAPTIOEN_1_H                     (0x0001)
#define CAPTIOEN__OFF                    (0x0000)        /* All Capacitive Touch IOs are disabled. Signal towards timers 
                                                            is 0. */
#define CAPTIOEN__ON                     (0x0100)        /* Selected Capacitive Touch IO is enabled */
#define CAPTIOEN__ON_H                   (0x0001)
#define CAPTIO                           (0x0200)        /* Capacitive Touch IO state */
#define CAPTIO_H                         (0x0002)
#define CAPTIO_0                         (0x0000)        /* Curent state 0 or Capacitive Touch IO is disabled */
#define CAPTIO_1                         (0x0200)        /* Current state 1 */
#define CAPTIO_1_H                       (0x0002)


/*****************************************************************************
 CAPTIO1 Registers
*****************************************************************************/

#define __MSP430_HAS_CAPTIO1__                /* Definition to show that module is available */
#ifndef __MSP430_HAS_CAPTIOx__
#define __MSP430_HAS_CAPTIOx__
#endif
#define __MSP430_BASEADDRESS_CAPTIO1__ 0x0470
#define CAPTIO1_BASE           __MSP430_BASEADDRESS_CAPTIO1__

sfr_w(CAPTIO1CTL);                            /* Capacitive Touch IO x Control Register */
sfr_b(CAPTIO1CTL_L);
sfr_b(CAPTIO1CTL_H);

/* CAPTIO1 Register Offsets */
#define OFS_CAPTIO1CTL                   (0x000E)
#define OFS_CAPTIO1CTL_L                 OFS_CAPTIO1CTL
#define OFS_CAPTIO1CTL_H                 OFS_CAPTIO1CTL+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 COMP_E Registers
*****************************************************************************/

#define __MSP430_HAS_COMP_E__                 /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_COMP_E__ 0x08C0
#define COMP_E_BASE            __MSP430_BASEADDRESS_COMP_E__

sfr_w(CECTL0);                                /* Comparator Control Register 0 */
sfr_b(CECTL0_L);
sfr_b(CECTL0_H);
sfr_w(CECTL1);                                /* Comparator Control Register 1 */
sfr_b(CECTL1_L);
sfr_b(CECTL1_H);
sfr_w(CECTL2);                                /* Comparator Control Register 2 */
sfr_b(CECTL2_L);
sfr_b(CECTL2_H);
sfr_w(CECTL3);                                /* Comparator Control Register 3 */
sfr_b(CECTL3_L);
sfr_b(CECTL3_H);
sfr_w(CEINT);                                 /* Comparator Interrupt Control Register */
sfr_b(CEINT_L);
sfr_b(CEINT_H);
sfr_w(CEIV);                                  /* Comparator Interrupt Vector Word Register */
sfr_b(CEIV_L);
sfr_b(CEIV_H);

/* COMP_E Register Offsets */
#define OFS_CECTL0                       (0x0000)
#define OFS_CECTL0_L                     OFS_CECTL0
#define OFS_CECTL0_H                     OFS_CECTL0+1
#define OFS_CECTL1                       (0x0002)
#define OFS_CECTL1_L                     OFS_CECTL1
#define OFS_CECTL1_H                     OFS_CECTL1+1
#define OFS_CECTL2                       (0x0004)
#define OFS_CECTL2_L                     OFS_CECTL2
#define OFS_CECTL2_H                     OFS_CECTL2+1
#define OFS_CECTL3                       (0x0006)
#define OFS_CECTL3_L                     OFS_CECTL3
#define OFS_CECTL3_H                     OFS_CECTL3+1
#define OFS_CEINT                        (0x000C)
#define OFS_CEINT_L                      OFS_CEINT
#define OFS_CEINT_H                      OFS_CEINT+1
#define OFS_CEIV                         (0x000E)
#define OFS_CEIV_L                       OFS_CEIV
#define OFS_CEIV_H                       OFS_CEIV+1

/* COMP_E Control Bits */

/* CECTL0 Control Bits */
#define CEIPSEL                          (0x000f)        /* Channel input selected for the V+ terminal */
#define CEIPSEL_L                        (0x000f)
#define CEIPSEL0                         (0x0001)        /* Channel input selected for the V+ terminal */
#define CEIPSEL0_L                       (0x0001)
#define CEIPSEL1                         (0x0002)        /* Channel input selected for the V+ terminal */
#define CEIPSEL1_L                       (0x0002)
#define CEIPSEL2                         (0x0004)        /* Channel input selected for the V+ terminal */
#define CEIPSEL2_L                       (0x0004)
#define CEIPSEL3                         (0x0008)        /* Channel input selected for the V+ terminal */
#define CEIPSEL3_L                       (0x0008)
#define CEIPSEL_0                        (0x0000)        /* Channel 0 selected */
#define CEIPSEL_1                        (0x0001)        /* Channel 1 selected */
#define CEIPSEL_1_L                      (0x0001)
#define CEIPSEL_2                        (0x0002)        /* Channel 2 selected */
#define CEIPSEL_2_L                      (0x0002)
#define CEIPSEL_3                        (0x0003)        /* Channel 3 selected */
#define CEIPSEL_3_L                      (0x0003)
#define CEIPSEL_4                        (0x0004)        /* Channel 4 selected */
#define CEIPSEL_4_L                      (0x0004)
#define CEIPSEL_5                        (0x0005)        /* Channel 5 selected */
#define CEIPSEL_5_L                      (0x0005)
#define CEIPSEL_6                        (0x0006)        /* Channel 6 selected */
#define CEIPSEL_6_L                      (0x0006)
#define CEIPSEL_7                        (0x0007)        /* Channel 7 selected */
#define CEIPSEL_7_L                      (0x0007)
#define CEIPSEL_8                        (0x0008)        /* Channel 8 selected */
#define CEIPSEL_8_L                      (0x0008)
#define CEIPSEL_9                        (0x0009)        /* Channel 9 selected */
#define CEIPSEL_9_L                      (0x0009)
#define CEIPSEL_10                       (0x000a)        /* Channel 10 selected */
#define CEIPSEL_10_L                     (0x000a)
#define CEIPSEL_11                       (0x000b)        /* Channel 11 selected */
#define CEIPSEL_11_L                     (0x000b)
#define CEIPSEL_12                       (0x000c)        /* Channel 12 selected */
#define CEIPSEL_12_L                     (0x000c)
#define CEIPSEL_13                       (0x000d)        /* Channel 13 selected */
#define CEIPSEL_13_L                     (0x000d)
#define CEIPSEL_14                       (0x000e)        /* Channel 14 selected */
#define CEIPSEL_14_L                     (0x000e)
#define CEIPSEL_15                       (0x000f)        /* Channel 15 selected */
#define CEIPSEL_15_L                     (0x000f)
#define CEIPEN                           (0x0080)        /* Channel input enable for the V+ terminal */
#define CEIPEN_L                         (0x0080)
#define CEIPEN_0                         (0x0000)        /* Selected analog input channel for V+ terminal is disabled */
#define CEIPEN_1                         (0x0080)        /* Selected analog input channel for V+ terminal is enabled */
#define CEIPEN_1_L                       (0x0080)
#define CEIPEN__DISABLE                  (0x0000)        /* Selected analog input channel for V+ terminal is disabled */
#define CEIPEN__ENABLE                   (0x0080)        /* Selected analog input channel for V+ terminal is enabled */
#define CEIPEN__ENABLE_L                 (0x0080)
#define CEIMSEL                          (0x0f00)        /* Channel input selected for the - terminal */
#define CEIMSEL_H                        (0x000f)
#define CEIMSEL0                         (0x0100)        /* Channel input selected for the - terminal */
#define CEIMSEL0_H                       (0x0001)
#define CEIMSEL1                         (0x0200)        /* Channel input selected for the - terminal */
#define CEIMSEL1_H                       (0x0002)
#define CEIMSEL2                         (0x0400)        /* Channel input selected for the - terminal */
#define CEIMSEL2_H                       (0x0004)
#define CEIMSEL3                         (0x0800)        /* Channel input selected for the - terminal */
#define CEIMSEL3_H                       (0x0008)
#define CEIMSEL_0                        (0x0000)        /* Channel 0 selected */
#define CEIMSEL_1                        (0x0100)        /* Channel 1 selected */
#define CEIMSEL_1_H                      (0x0001)
#define CEIMSEL_2                        (0x0200)        /* Channel 2 selected */
#define CEIMSEL_2_H                      (0x0002)
#define CEIMSEL_3                        (0x0300)        /* Channel 3 selected */
#define CEIMSEL_3_H                      (0x0003)
#define CEIMSEL_4                        (0x0400)        /* Channel 4 selected */
#define CEIMSEL_4_H                      (0x0004)
#define CEIMSEL_5                        (0x0500)        /* Channel 5 selected */
#define CEIMSEL_5_H                      (0x0005)
#define CEIMSEL_6                        (0x0600)        /* Channel 6 selected */
#define CEIMSEL_6_H                      (0x0006)
#define CEIMSEL_7                        (0x0700)        /* Channel 7 selected */
#define CEIMSEL_7_H                      (0x0007)
#define CEIMSEL_8                        (0x0800)        /* Channel 8 selected */
#define CEIMSEL_8_H                      (0x0008)
#define CEIMSEL_9                        (0x0900)        /* Channel 9 selected */
#define CEIMSEL_9_H                      (0x0009)
#define CEIMSEL_10                       (0x0a00)        /* Channel 10 selected */
#define CEIMSEL_10_H                     (0x000a)
#define CEIMSEL_11                       (0x0b00)        /* Channel 11 selected */
#define CEIMSEL_11_H                     (0x000b)
#define CEIMSEL_12                       (0x0c00)        /* Channel 12 selected */
#define CEIMSEL_12_H                     (0x000c)
#define CEIMSEL_13                       (0x0d00)        /* Channel 13 selected */
#define CEIMSEL_13_H                     (0x000d)
#define CEIMSEL_14                       (0x0e00)        /* Channel 14 selected */
#define CEIMSEL_14_H                     (0x000e)
#define CEIMSEL_15                       (0x0f00)        /* Channel 15 selected */
#define CEIMSEL_15_H                     (0x000f)
#define CEIMEN                           (0x8000)        /* Channel input enable for the - terminal */
#define CEIMEN_H                         (0x0080)
#define CEIMEN_0                         (0x0000)        /* Selected analog input channel for V- terminal is disabled */
#define CEIMEN_1                         (0x8000)        /* Selected analog input channel for V- terminal is enabled */
#define CEIMEN_1_H                       (0x0080)
#define CEIMEN__DISABLE                  (0x0000)        /* Selected analog input channel for V- terminal is disabled */
#define CEIMEN__ENABLE                   (0x8000)        /* Selected analog input channel for V- terminal is enabled */
#define CEIMEN__ENABLE_H                 (0x0080)

/* CECTL1 Control Bits */
#define CEOUT                            (0x0001)        /* Comparator output value */
#define CEOUT_L                          (0x0001)
#define CEOUTPOL                         (0x0002)        /* Comparator output polarity */
#define CEOUTPOL_L                       (0x0002)
#define CEOUTPOL_0                       (0x0000)        /* Noninverted */
#define CEOUTPOL_1                       (0x0002)        /* Inverted */
#define CEOUTPOL_1_L                     (0x0002)
#define CEF                              (0x0004)        /* Comparator output filter */
#define CEF_L                            (0x0004)
#define CEF_0                            (0x0000)        /* Comparator output is not filtered */
#define CEF_1                            (0x0004)        /* Comparator output is filtered */
#define CEF_1_L                          (0x0004)
#define CEIES                            (0x0008)        /* Interrupt edge select for CEIIFG and CEIFG */
#define CEIES_L                          (0x0008)
#define CEIES_0                          (0x0000)        /* Rising edge for CEIFG, falling edge for CEIIFG */
#define CEIES_1                          (0x0008)        /* Falling edge for CEIFG, rising edge for CEIIFG */
#define CEIES_1_L                        (0x0008)
#define CESHORT                          (0x0010)        /* Input short */
#define CESHORT_L                        (0x0010)
#define CESHORT_0                        (0x0000)        /* Inputs not shorted */
#define CESHORT_1                        (0x0010)        /* Inputs shorted */
#define CESHORT_1_L                      (0x0010)
#define CEEX                             (0x0020)        /* Exchange */
#define CEEX_L                           (0x0020)
#define CEFDLY                           (0x00c0)        /* Filter delay */
#define CEFDLY_L                         (0x00c0)
#define CEFDLY0                          (0x0040)        /* Filter delay */
#define CEFDLY0_L                        (0x0040)
#define CEFDLY1                          (0x0080)        /* Filter delay */
#define CEFDLY1_L                        (0x0080)
#define CEFDLY_0                         (0x0000)        /* Typical filter delay of TBD (450) ns */
#define CEFDLY_1                         (0x0040)        /* Typical filter delay of TBD (900) ns */
#define CEFDLY_1_L                       (0x0040)
#define CEFDLY_2                         (0x0080)        /* Typical filter delay of TBD (1800) ns */
#define CEFDLY_2_L                       (0x0080)
#define CEFDLY_3                         (0x00c0)        /* Typical filter delay of TBD (3600) ns */
#define CEFDLY_3_L                       (0x00c0)
#define CEPWRMD                          (0x0300)        /* Power Mode */
#define CEPWRMD_H                        (0x0003)
#define CEPWRMD0                         (0x0100)        /* Power Mode */
#define CEPWRMD0_H                       (0x0001)
#define CEPWRMD1                         (0x0200)        /* Power Mode */
#define CEPWRMD1_H                       (0x0002)
#define CEPWRMD_0                        (0x0000)        /* High-speed mode */
#define CEPWRMD_1                        (0x0100)        /* Normal mode */
#define CEPWRMD_1_H                      (0x0001)
#define CEPWRMD_2                        (0x0200)        /* Ultra-low power mode */
#define CEPWRMD_2_H                      (0x0002)
#define CEON                             (0x0400)        /* Comparator On */
#define CEON_H                           (0x0004)
#define CEON_0                           (0x0000)        /* Off */
#define CEON_1                           (0x0400)        /* On */
#define CEON_1_H                         (0x0004)
#define CEON__OFF                        (0x0000)        /* Off */
#define CEON__ON                         (0x0400)        /* On */
#define CEON__ON_H                       (0x0004)
#define CEMRVL                           (0x0800)        /* This bit is valid of CEMRVS is set to 1 */
#define CEMRVL_H                         (0x0008)
#define CEMRVL_0                         (0x0000)        /* VREF0 is selected if CERS = 00, 01, or 10 */
#define CEMRVL_1                         (0x0800)        /* VREF1 is selected if CERS = 00, 01, or 10 */
#define CEMRVL_1_H                       (0x0008)
#define CEMRVL__VREF0                    (0x0000)        /* VREF0 is selected if CERS = 00, 01, or 10 */
#define CEMRVL__VREF1                    (0x0800)        /* VREF1 is selected if CERS = 00, 01, or 10 */
#define CEMRVL__VREF1_H                  (0x0008)
#define CEMRVS                           (0x1000)        /* */
#define CEMRVS_H                         (0x0010)
#define CEMRVS_0                         (0x0000)        /* Comparator output state selects between VREF0 or VREF1 */
#define CEMRVS_1                         (0x1000)        /* CEMRVL selects between VREF0 or VREF1 */
#define CEMRVS_1_H                       (0x0010)

/* CECTL2 Control Bits */
#define CEREF0                           (0x001f)        /* Reference resistor tap 0 */
#define CEREF0_L                         (0x001f)
#define CEREF00                          (0x0001)        /* Reference resistor tap 0 */
#define CEREF00_L                        (0x0001)
#define CEREF01                          (0x0002)        /* Reference resistor tap 0 */
#define CEREF01_L                        (0x0002)
#define CEREF02                          (0x0004)        /* Reference resistor tap 0 */
#define CEREF02_L                        (0x0004)
#define CEREF03                          (0x0008)        /* Reference resistor tap 0 */
#define CEREF03_L                        (0x0008)
#define CEREF04                          (0x0010)        /* Reference resistor tap 0 */
#define CEREF04_L                        (0x0010)
#define CERSEL                           (0x0020)        /* Reference select */
#define CERSEL_L                         (0x0020)
#define CERSEL_0                         (0x0000)        /* When CEEX = 0, VREF is applied to the V+ terminal; When CEEX =
                                                            1, VREF is applied to the V- terminal */
#define CERSEL_1                         (0x0020)        /* When CEEX = 0, VREF is applied to the V- terminal; When CEEX =
                                                            1, VREF is applied to the V+ terminal */
#define CERSEL_1_L                       (0x0020)
#define CERS                             (0x00c0)        /* Reference source */
#define CERS_L                           (0x00c0)
#define CERS0                            (0x0040)        /* Reference source */
#define CERS0_L                          (0x0040)
#define CERS1                            (0x0080)        /* Reference source */
#define CERS1_L                          (0x0080)
#define CERS_0                           (0x0000)        /* No current is drawn by the reference circuitry */
#define CERS_1                           (0x0040)        /* VCC applied to the resistor ladder */
#define CERS_1_L                         (0x0040)
#define CERS_2                           (0x0080)        /* Shared reference voltage applied to the resistor ladder */
#define CERS_2_L                         (0x0080)
#define CERS_3                           (0x00c0)        /* Shared reference voltage supplied to V(CREF). Resistor ladder 
                                                            is off */
#define CERS_3_L                         (0x00c0)
#define CEREF1                           (0x1f00)        /* Reference resistor tap 1 */
#define CEREF1_H                         (0x001f)
#define CEREF10                          (0x0100)        /* Reference resistor tap 1 */
#define CEREF10_H                        (0x0001)
#define CEREF11                          (0x0200)        /* Reference resistor tap 1 */
#define CEREF11_H                        (0x0002)
#define CEREF12                          (0x0400)        /* Reference resistor tap 1 */
#define CEREF12_H                        (0x0004)
#define CEREF13                          (0x0800)        /* Reference resistor tap 1 */
#define CEREF13_H                        (0x0008)
#define CEREF14                          (0x1000)        /* Reference resistor tap 1 */
#define CEREF14_H                        (0x0010)
#define CEREFL                           (0x6000)        /* Reference voltage level */
#define CEREFL_H                         (0x0060)
#define CEREFL0                          (0x2000)        /* Reference voltage level */
#define CEREFL0_H                        (0x0020)
#define CEREFL1                          (0x4000)        /* Reference voltage level */
#define CEREFL1_H                        (0x0040)
#define CEREFL_0                         (0x0000)        /* Reference amplifier is disabled. No reference voltage is 
                                                            requested */
#define CEREFL_1                         (0x2000)        /* 1.2 V is selected as shared reference voltage input */
#define CEREFL_1_H                       (0x0020)
#define CEREFL_2                         (0x4000)        /* 2.0 V is selected as shared reference voltage input */
#define CEREFL_2_H                       (0x0040)
#define CEREFL_3                         (0x6000)        /* 2.5 V is selected as shared reference voltage input */
#define CEREFL_3_H                       (0x0060)
#define CEREFL__OFF                      (0x0000)        /* Reference amplifier is disabled. No reference voltage is 
                                                            requested */
#define CEREFL__1P2V                     (0x2000)        /* 1.2 V is selected as shared reference voltage input */
#define CEREFL__1P2V_H                   (0x0020)
#define CEREFL__2P0V                     (0x4000)        /* 2.0 V is selected as shared reference voltage input */
#define CEREFL__2P0V_H                   (0x0040)
#define CEREFL__2P5V                     (0x6000)        /* 2.5 V is selected as shared reference voltage input */
#define CEREFL__2P5V_H                   (0x0060)
#define CEREFACC                         (0x8000)        /* Reference accuracy */
#define CEREFACC_H                       (0x0080)
#define CEREFACC_0                       (0x0000)        /* Static mode */
#define CEREFACC_1                       (0x8000)        /* Clocked (low power, low accuracy) mode */
#define CEREFACC_1_H                     (0x0080)
#define CEREFACC__STATIC                 (0x0000)        /* Static mode */
#define CEREFACC__CLOCKED                (0x8000)        /* Clocked (low power, low accuracy) mode */
#define CEREFACC__CLOCKED_H              (0x0080)

/* CECTL3 Control Bits */
#define CEPD0                            (0x0001)        /* Port disable */
#define CEPD0_L                          (0x0001)
#define CEPD0_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD0_1                          (0x0001)        /* The input buffer is disabled */
#define CEPD0_1_L                        (0x0001)
#define CEPD1                            (0x0002)        /* Port disable */
#define CEPD1_L                          (0x0002)
#define CEPD1_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD1_1                          (0x0002)        /* The input buffer is disabled */
#define CEPD1_1_L                        (0x0002)
#define CEPD2                            (0x0004)        /* Port disable */
#define CEPD2_L                          (0x0004)
#define CEPD2_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD2_1                          (0x0004)        /* The input buffer is disabled */
#define CEPD2_1_L                        (0x0004)
#define CEPD3                            (0x0008)        /* Port disable */
#define CEPD3_L                          (0x0008)
#define CEPD3_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD3_1                          (0x0008)        /* The input buffer is disabled */
#define CEPD3_1_L                        (0x0008)
#define CEPD4                            (0x0010)        /* Port disable */
#define CEPD4_L                          (0x0010)
#define CEPD4_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD4_1                          (0x0010)        /* The input buffer is disabled */
#define CEPD4_1_L                        (0x0010)
#define CEPD5                            (0x0020)        /* Port disable */
#define CEPD5_L                          (0x0020)
#define CEPD5_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD5_1                          (0x0020)        /* The input buffer is disabled */
#define CEPD5_1_L                        (0x0020)
#define CEPD6                            (0x0040)        /* Port disable */
#define CEPD6_L                          (0x0040)
#define CEPD6_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD6_1                          (0x0040)        /* The input buffer is disabled */
#define CEPD6_1_L                        (0x0040)
#define CEPD7                            (0x0080)        /* Port disable */
#define CEPD7_L                          (0x0080)
#define CEPD7_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD7_1                          (0x0080)        /* The input buffer is disabled */
#define CEPD7_1_L                        (0x0080)
#define CEPD8                            (0x0100)        /* Port disable */
#define CEPD8_H                          (0x0001)
#define CEPD8_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD8_1                          (0x0100)        /* The input buffer is disabled */
#define CEPD8_1_H                        (0x0001)
#define CEPD9                            (0x0200)        /* Port disable */
#define CEPD9_H                          (0x0002)
#define CEPD9_0                          (0x0000)        /* The input buffer is enabled */
#define CEPD9_1                          (0x0200)        /* The input buffer is disabled */
#define CEPD9_1_H                        (0x0002)
#define CEPD10                           (0x0400)        /* Port disable */
#define CEPD10_H                         (0x0004)
#define CEPD10_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD10_1                         (0x0400)        /* The input buffer is disabled */
#define CEPD10_1_H                       (0x0004)
#define CEPD11                           (0x0800)        /* Port disable */
#define CEPD11_H                         (0x0008)
#define CEPD11_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD11_1                         (0x0800)        /* The input buffer is disabled */
#define CEPD11_1_H                       (0x0008)
#define CEPD12                           (0x1000)        /* Port disable */
#define CEPD12_H                         (0x0010)
#define CEPD12_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD12_1                         (0x1000)        /* The input buffer is disabled */
#define CEPD12_1_H                       (0x0010)
#define CEPD13                           (0x2000)        /* Port disable */
#define CEPD13_H                         (0x0020)
#define CEPD13_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD13_1                         (0x2000)        /* The input buffer is disabled */
#define CEPD13_1_H                       (0x0020)
#define CEPD14                           (0x4000)        /* Port disable */
#define CEPD14_H                         (0x0040)
#define CEPD14_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD14_1                         (0x4000)        /* The input buffer is disabled */
#define CEPD14_1_H                       (0x0040)
#define CEPD15                           (0x8000)        /* Port disable */
#define CEPD15_H                         (0x0080)
#define CEPD15_0                         (0x0000)        /* The input buffer is enabled */
#define CEPD15_1                         (0x8000)        /* The input buffer is disabled */
#define CEPD15_1_H                       (0x0080)

/* CEINT Control Bits */
#define CEIFG                            (0x0001)        /* Comparator output interrupt flag */
#define CEIFG_L                          (0x0001)
#define CEIFG_0                          (0x0000)        /* No interrupt pending */
#define CEIFG_1                          (0x0001)        /* Interrupt pending */
#define CEIFG_1_L                        (0x0001)
#define CEIIFG                           (0x0002)        /* Comparator output inverted interrupt flag */
#define CEIIFG_L                         (0x0002)
#define CEIIFG_0                         (0x0000)        /* No interrupt pending */
#define CEIIFG_1                         (0x0002)        /* Interrupt pending */
#define CEIIFG_1_L                       (0x0002)
#define CERDYIFG                         (0x0010)        /* Comparator ready interrupt flag */
#define CERDYIFG_L                       (0x0010)
#define CERDYIFG_0                       (0x0000)        /* No interrupt pending */
#define CERDYIFG_1                       (0x0010)        /* Interrupt pending */
#define CERDYIFG_1_L                     (0x0010)
#define CEIE                             (0x0100)        /* Comparator output interrupt enable */
#define CEIE_H                           (0x0001)
#define CEIE_0                           (0x0000)        /* Interrupt disabled */
#define CEIE_1                           (0x0100)        /* Interrupt enabled */
#define CEIE_1_H                         (0x0001)
#define CEIE__DISABLE                    (0x0000)        /* Interrupt disabled */
#define CEIE__ENABLE                     (0x0100)        /* Interrupt enabled */
#define CEIE__ENABLE_H                   (0x0001)
#define CEIIE                            (0x0200)        /* Comparator output interrupt enable inverted polarity */
#define CEIIE_H                          (0x0002)
#define CEIIE_0                          (0x0000)        /* Interrupt disabled */
#define CEIIE_1                          (0x0200)        /* Interrupt enabled */
#define CEIIE_1_H                        (0x0002)
#define CEIIE__DISABLE                   (0x0000)        /* Interrupt disabled */
#define CEIIE__ENABLE                    (0x0200)        /* Interrupt enabled */
#define CEIIE__ENABLE_H                  (0x0002)
#define CERDYIE                          (0x1000)        /* Comparator ready interrupt enable */
#define CERDYIE_H                        (0x0010)
#define CERDYIE_0                        (0x0000)        /* Interrupt disabled */
#define CERDYIE_1                        (0x1000)        /* Interrupt enabled */
#define CERDYIE_1_H                      (0x0010)
#define CERDYIE__DISABLE                 (0x0000)        /* Interrupt disabled */
#define CERDYIE__ENABLE                  (0x1000)        /* Interrupt enabled */
#define CERDYIE__ENABLE_H                (0x0010)

/* CEIV Control Bits */
#define CEIV0                            (0x0001)        /* Comparator interrupt vector word register */
#define CEIV0_L                          (0x0001)
#define CEIV1                            (0x0002)        /* Comparator interrupt vector word register */
#define CEIV1_L                          (0x0002)
#define CEIV2                            (0x0004)        /* Comparator interrupt vector word register */
#define CEIV2_L                          (0x0004)
#define CEIV3                            (0x0008)        /* Comparator interrupt vector word register */
#define CEIV3_L                          (0x0008)
#define CEIV4                            (0x0010)        /* Comparator interrupt vector word register */
#define CEIV4_L                          (0x0010)
#define CEIV5                            (0x0020)        /* Comparator interrupt vector word register */
#define CEIV5_L                          (0x0020)
#define CEIV6                            (0x0040)        /* Comparator interrupt vector word register */
#define CEIV6_L                          (0x0040)
#define CEIV7                            (0x0080)        /* Comparator interrupt vector word register */
#define CEIV7_L                          (0x0080)
#define CEIV8                            (0x0100)        /* Comparator interrupt vector word register */
#define CEIV8_H                          (0x0001)
#define CEIV9                            (0x0200)        /* Comparator interrupt vector word register */
#define CEIV9_H                          (0x0002)
#define CEIV10                           (0x0400)        /* Comparator interrupt vector word register */
#define CEIV10_H                         (0x0004)
#define CEIV11                           (0x0800)        /* Comparator interrupt vector word register */
#define CEIV11_H                         (0x0008)
#define CEIV12                           (0x1000)        /* Comparator interrupt vector word register */
#define CEIV12_H                         (0x0010)
#define CEIV13                           (0x2000)        /* Comparator interrupt vector word register */
#define CEIV13_H                         (0x0020)
#define CEIV14                           (0x4000)        /* Comparator interrupt vector word register */
#define CEIV14_H                         (0x0040)
#define CEIV15                           (0x8000)        /* Comparator interrupt vector word register */
#define CEIV15_H                         (0x0080)
#define CEIV_0                           (0x0000)        /* No interrupt pending */
#define CEIV_2                           (0x0002)        /* Interrupt Source: CEOUT interrupt; Interrupt Flag: CEIFG; 
                                                            Interrupt Priority: Highest */
#define CEIV_2_L                         (0x0002)
#define CEIV_4                           (0x0004)        /* Interrupt Source: CEOUT interrupt inverted polarity; Interrupt
                                                            Flag: CEIIFG */
#define CEIV_4_L                         (0x0004)
#define CEIV_10                          (0x000a)        /* Interrupt Source: Comparator ready interrupt; Interrupt Flag: 
                                                            CERDYIFG; Interrupt Priority: Lowest */
#define CEIV_10_L                        (0x000a)
#define CEIV__NONE                       (0x0000)        /* No interrupt pending */
#define CEIV__CEIFG                      (0x0002)        /* Interrupt Source: CEOUT interrupt; Interrupt Flag: CEIFG; 
                                                            Interrupt Priority: Highest */
#define CEIV__CEIFG_L                    (0x0002)
#define CEIV__CEIIFG                     (0x0004)        /* Interrupt Source: CEOUT interrupt inverted polarity; Interrupt
                                                            Flag: CEIIFG */
#define CEIV__CEIIFG_L                   (0x0004)
#define CEIV__CERDYIFG                   (0x000a)        /* Interrupt Source: Comparator ready interrupt; Interrupt Flag: 
                                                            CERDYIFG; Interrupt Priority: Lowest */
#define CEIV__CERDYIFG_L                 (0x000a)


/*****************************************************************************
 CRC Registers
*****************************************************************************/

#define __MSP430_HAS_CRC__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CRC__ 0x0150
#define CRC_BASE               __MSP430_BASEADDRESS_CRC__

sfr_w(CRCDI);                                 /* CRC Data In */
sfr_b(CRCDI_L);
sfr_b(CRCDI_H);
sfr_w(CRCDIRB);                               /* CRC Data In Reverse Byte */
sfr_b(CRCDIRB_L);
sfr_b(CRCDIRB_H);
sfr_w(CRCINIRES);                             /* CRC Initialization and Result */
sfr_b(CRCINIRES_L);
sfr_b(CRCINIRES_H);
sfr_w(CRCRESR);                               /* CRC Result Reverse */
sfr_b(CRCRESR_L);
sfr_b(CRCRESR_H);

/* CRC Register Offsets */
#define OFS_CRCDI                        (0x0000)
#define OFS_CRCDI_L                      OFS_CRCDI
#define OFS_CRCDI_H                      OFS_CRCDI+1
#define OFS_CRCDIRB                      (0x0002)
#define OFS_CRCDIRB_L                    OFS_CRCDIRB
#define OFS_CRCDIRB_H                    OFS_CRCDIRB+1
#define OFS_CRCINIRES                    (0x0004)
#define OFS_CRCINIRES_L                  OFS_CRCINIRES
#define OFS_CRCINIRES_H                  OFS_CRCINIRES+1
#define OFS_CRCRESR                      (0x0006)
#define OFS_CRCRESR_L                    OFS_CRCRESR
#define OFS_CRCRESR_H                    OFS_CRCRESR+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 CRC32 Registers
*****************************************************************************/

#define __MSP430_HAS_CRC32__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CRC32__ 0x0980
#define CRC32_BASE             __MSP430_BASEADDRESS_CRC32__

sfr_w(CRC32DIW0);                             /* CRC32 Data Input Word 0 */
sfr_b(CRC32DIW0_L);
sfr_b(CRC32DIW0_H);
sfr_w(CRC32DIW1);                             /* CRC32 Data Input Word 1 */
sfr_b(CRC32DIW1_L);
sfr_b(CRC32DIW1_H);
sfr_w(CRC32DIRBW1);                           /* CRC32 Data In Reverse Word 1 */
sfr_b(CRC32DIRBW1_L);
sfr_b(CRC32DIRBW1_H);
sfr_w(CRC32DIRBW0);                           /* CRC32 Data In Reverse Word 0 */
sfr_b(CRC32DIRBW0_L);
sfr_b(CRC32DIRBW0_H);
sfr_w(CRC32INIRESW0);                         /* CRC32 Initialization and Result Word 0 */
sfr_b(CRC32INIRESW0_L);
sfr_b(CRC32INIRESW0_H);
sfr_w(CRC32INIRESW1);                         /* CRC32 Initialization and Result Word 1 */
sfr_b(CRC32INIRESW1_L);
sfr_b(CRC32INIRESW1_H);
sfr_w(CRC32RESRW1);                           /* CRC32 Result Reverse Word 1 */
sfr_b(CRC32RESRW1_L);
sfr_b(CRC32RESRW1_H);
sfr_w(CRC32RESRW0);                           /* CRC32 Result Reverse Word 0 */
sfr_b(CRC32RESRW0_L);
sfr_b(CRC32RESRW0_H);
sfr_w(CRC16DIW0);                             /* CRC16 Data Input */
sfr_b(CRC16DIW0_L);
sfr_b(CRC16DIW0_H);
sfr_w(CRC16DIRBW0);                           /* CRC16 Data In Reverse */
sfr_b(CRC16DIRBW0_L);
sfr_b(CRC16DIRBW0_H);
sfr_w(CRC16INIRESW0);                         /* CRC16 Init and Result */
sfr_b(CRC16INIRESW0_L);
sfr_b(CRC16INIRESW0_H);
sfr_w(CRC16RESRW0);                           /* CRC16 Result Reverse */
sfr_b(CRC16RESRW0_L);
sfr_b(CRC16RESRW0_H);

/* CRC32 Register Offsets */
#define OFS_CRC32DIW0                    (0x0000)
#define OFS_CRC32DIW0_L                  OFS_CRC32DIW0
#define OFS_CRC32DIW0_H                  OFS_CRC32DIW0+1
#define OFS_CRC32DIW1                    (0x0002)
#define OFS_CRC32DIW1_L                  OFS_CRC32DIW1
#define OFS_CRC32DIW1_H                  OFS_CRC32DIW1+1
#define OFS_CRC32DIRBW1                  (0x0004)
#define OFS_CRC32DIRBW1_L                OFS_CRC32DIRBW1
#define OFS_CRC32DIRBW1_H                OFS_CRC32DIRBW1+1
#define OFS_CRC32DIRBW0                  (0x0006)
#define OFS_CRC32DIRBW0_L                OFS_CRC32DIRBW0
#define OFS_CRC32DIRBW0_H                OFS_CRC32DIRBW0+1
#define OFS_CRC32INIRESW0                (0x0008)
#define OFS_CRC32INIRESW0_L              OFS_CRC32INIRESW0
#define OFS_CRC32INIRESW0_H              OFS_CRC32INIRESW0+1
#define OFS_CRC32INIRESW1                (0x000A)
#define OFS_CRC32INIRESW1_L              OFS_CRC32INIRESW1
#define OFS_CRC32INIRESW1_H              OFS_CRC32INIRESW1+1
#define OFS_CRC32RESRW1                  (0x000C)
#define OFS_CRC32RESRW1_L                OFS_CRC32RESRW1
#define OFS_CRC32RESRW1_H                OFS_CRC32RESRW1+1
#define OFS_CRC32RESRW0                  (0x000E)
#define OFS_CRC32RESRW0_L                OFS_CRC32RESRW0
#define OFS_CRC32RESRW0_H                OFS_CRC32RESRW0+1
#define OFS_CRC16DIW0                    (0x0010)
#define OFS_CRC16DIW0_L                  OFS_CRC16DIW0
#define OFS_CRC16DIW0_H                  OFS_CRC16DIW0+1
#define OFS_CRC16DIRBW0                  (0x0016)
#define OFS_CRC16DIRBW0_L                OFS_CRC16DIRBW0
#define OFS_CRC16DIRBW0_H                OFS_CRC16DIRBW0+1
#define OFS_CRC16INIRESW0                (0x0018)
#define OFS_CRC16INIRESW0_L              OFS_CRC16INIRESW0
#define OFS_CRC16INIRESW0_H              OFS_CRC16INIRESW0+1
#define OFS_CRC16RESRW0                  (0x001E)
#define OFS_CRC16RESRW0_L                OFS_CRC16RESRW0
#define OFS_CRC16RESRW0_H                OFS_CRC16RESRW0+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 CS Registers
*****************************************************************************/

#define __MSP430_HAS_CS__                     /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_CS__ 0x0160
#define CS_BASE                __MSP430_BASEADDRESS_CS__

sfr_w(CSCTL0);                                /* Clock System Control 0 */
sfr_b(CSCTL0_L);
sfr_b(CSCTL0_H);
sfr_w(CSCTL1);                                /* Clock System Control 1 */
sfr_b(CSCTL1_L);
sfr_b(CSCTL1_H);
sfr_w(CSCTL2);                                /* Clock System Control 2 */
sfr_b(CSCTL2_L);
sfr_b(CSCTL2_H);
sfr_w(CSCTL3);                                /* Clock System Control 3 */
sfr_b(CSCTL3_L);
sfr_b(CSCTL3_H);
sfr_w(CSCTL4);                                /* Clock System Control 4 */
sfr_b(CSCTL4_L);
sfr_b(CSCTL4_H);
sfr_w(CSCTL5);                                /* Clock System Control 5 */
sfr_b(CSCTL5_L);
sfr_b(CSCTL5_H);
sfr_w(CSCTL6);                                /* Clock System Control 6 */
sfr_b(CSCTL6_L);
sfr_b(CSCTL6_H);

/* CS Register Offsets */
#define OFS_CSCTL0                       (0x0000)
#define OFS_CSCTL0_L                     OFS_CSCTL0
#define OFS_CSCTL0_H                     OFS_CSCTL0+1
#define OFS_CSCTL1                       (0x0002)
#define OFS_CSCTL1_L                     OFS_CSCTL1
#define OFS_CSCTL1_H                     OFS_CSCTL1+1
#define OFS_CSCTL2                       (0x0004)
#define OFS_CSCTL2_L                     OFS_CSCTL2
#define OFS_CSCTL2_H                     OFS_CSCTL2+1
#define OFS_CSCTL3                       (0x0006)
#define OFS_CSCTL3_L                     OFS_CSCTL3
#define OFS_CSCTL3_H                     OFS_CSCTL3+1
#define OFS_CSCTL4                       (0x0008)
#define OFS_CSCTL4_L                     OFS_CSCTL4
#define OFS_CSCTL4_H                     OFS_CSCTL4+1
#define OFS_CSCTL5                       (0x000A)
#define OFS_CSCTL5_L                     OFS_CSCTL5
#define OFS_CSCTL5_H                     OFS_CSCTL5+1
#define OFS_CSCTL6                       (0x000C)
#define OFS_CSCTL6_L                     OFS_CSCTL6
#define OFS_CSCTL6_H                     OFS_CSCTL6+1

/* CS Control Bits */

/* CSCTL0 Control Bits */
#define CSKEY                            (0xa500)        /* CSKEY password */
#define CSKEY_H                          (0x00a5)
#define CSKEY0                           (0x0100)        /* CSKEY password */
#define CSKEY0_H                         (0x0001)
#define CSKEY1                           (0x0200)        /* CSKEY password */
#define CSKEY1_H                         (0x0002)
#define CSKEY2                           (0x0400)        /* CSKEY password */
#define CSKEY2_H                         (0x0004)
#define CSKEY3                           (0x0800)        /* CSKEY password */
#define CSKEY3_H                         (0x0008)
#define CSKEY4                           (0x1000)        /* CSKEY password */
#define CSKEY4_H                         (0x0010)
#define CSKEY5                           (0x2000)        /* CSKEY password */
#define CSKEY5_H                         (0x0020)
#define CSKEY6                           (0x4000)        /* CSKEY password */
#define CSKEY6_H                         (0x0040)
#define CSKEY7                           (0x8000)        /* CSKEY password */
#define CSKEY7_H                         (0x0080)

/* CSCTL1 Control Bits */
#define DCOFSEL                          (0x000e)        /* DCO frequency select */
#define DCOFSEL_L                        (0x000e)
#define DCOFSEL0                         (0x0002)        /* DCO frequency select */
#define DCOFSEL0_L                       (0x0002)
#define DCOFSEL1                         (0x0004)        /* DCO frequency select */
#define DCOFSEL1_L                       (0x0004)
#define DCOFSEL2                         (0x0008)        /* DCO frequency select */
#define DCOFSEL2_L                       (0x0008)
#define DCOFSEL_0                        (0x0000)        /* If DCORSEL = 0: 1 MHz; If DCORSEL = 1: 1 MHz */
#define DCOFSEL_1                        (0x0002)        /* If DCORSEL = 0: 2.67 MHz; If DCORSEL = 1: 5.33 MHz */
#define DCOFSEL_1_L                      (0x0002)
#define DCOFSEL_2                        (0x0004)        /* If DCORSEL = 0: 3.5 MHz; If DCORSEL = 1: 7 MHz */
#define DCOFSEL_2_L                      (0x0004)
#define DCOFSEL_3                        (0x0006)        /* If DCORSEL = 0: 4 MHz; If DCORSEL = 1: 8 MHz */
#define DCOFSEL_3_L                      (0x0006)
#define DCOFSEL_4                        (0x0008)        /* If DCORSEL = 0: 5.33 MHz; If DCORSEL = 1: 16 MHz */
#define DCOFSEL_4_L                      (0x0008)
#define DCOFSEL_5                        (0x000a)        /* If DCORSEL = 0: 7 MHz; If DCORSEL = 1: 21 MHz */
#define DCOFSEL_5_L                      (0x000a)
#define DCOFSEL_6                        (0x000c)        /* If DCORSEL = 0: 8 MHz; If DCORSEL = 1: 24 MHz */
#define DCOFSEL_6_L                      (0x000c)
#define DCOFSEL_7                        (0x000e)        /* If DCORSEL = 0: Reserved. Defaults to 8. It is not recommended
                                                            to use this setting; If DCORSEL = 1: Reserved. Defaults to 24.
                                                            It is not recommended to use this setting */
#define DCOFSEL_7_L                      (0x000e)
#define DCORSEL                          (0x0040)        /* DCO range select */
#define DCORSEL_L                        (0x0040)

/* CSCTL2 Control Bits */
#define SELM                             (0x0007)        /* Selects the MCLK source */
#define SELM_L                           (0x0007)
#define SELM0                            (0x0001)        /* Selects the MCLK source */
#define SELM0_L                          (0x0001)
#define SELM1                            (0x0002)        /* Selects the MCLK source */
#define SELM1_L                          (0x0002)
#define SELM2                            (0x0004)        /* Selects the MCLK source */
#define SELM2_L                          (0x0004)
#define SELM_0                           (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK */
#define SELM_1                           (0x0001)        /* VLOCLK */
#define SELM_1_L                         (0x0001)
#define SELM_2                           (0x0002)        /* LFMODCLK */
#define SELM_2_L                         (0x0002)
#define SELM_3                           (0x0003)        /* DCOCLK */
#define SELM_3_L                         (0x0003)
#define SELM_4                           (0x0004)        /* MODCLK */
#define SELM_4_L                         (0x0004)
#define SELM_5                           (0x0005)        /* HFXTCLK when HFXT available, otherwise DCOCLK */
#define SELM_5_L                         (0x0005)
#define SELM__LFXTCLK                    (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK */
#define SELM__VLOCLK                     (0x0001)        /* VLOCLK */
#define SELM__VLOCLK_L                   (0x0001)
#define SELM__LFMODCLK                   (0x0002)        /* LFMODCLK */
#define SELM__LFMODCLK_L                 (0x0002)
#define SELM__DCOCLK                     (0x0003)        /* DCOCLK */
#define SELM__DCOCLK_L                   (0x0003)
#define SELM__MODCLK                     (0x0004)        /* MODCLK */
#define SELM__MODCLK_L                   (0x0004)
#define SELM__HFXTCLK                    (0x0005)        /* HFXTCLK when HFXT available, otherwise DCOCLK */
#define SELM__HFXTCLK_L                  (0x0005)
#define SELS                             (0x0070)        /* Selects the SMCLK source */
#define SELS_L                           (0x0070)
#define SELS0                            (0x0010)        /* Selects the SMCLK source */
#define SELS0_L                          (0x0010)
#define SELS1                            (0x0020)        /* Selects the SMCLK source */
#define SELS1_L                          (0x0020)
#define SELS2                            (0x0040)        /* Selects the SMCLK source */
#define SELS2_L                          (0x0040)
#define SELS_0                           (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK. */
#define SELS_1                           (0x0010)        /* VLOCLK */
#define SELS_1_L                         (0x0010)
#define SELS_2                           (0x0020)        /* LFMODCLK */
#define SELS_2_L                         (0x0020)
#define SELS_3                           (0x0030)        /* DCOCLK */
#define SELS_3_L                         (0x0030)
#define SELS_4                           (0x0040)        /* MODCLK */
#define SELS_4_L                         (0x0040)
#define SELS_5                           (0x0050)        /* HFXTCLK when HFXT available, otherwise DCOCLK. */
#define SELS_5_L                         (0x0050)
#define SELS__LFXTCLK                    (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK. */
#define SELS__VLOCLK                     (0x0010)        /* VLOCLK */
#define SELS__VLOCLK_L                   (0x0010)
#define SELS__LFMODCLK                   (0x0020)        /* LFMODCLK */
#define SELS__LFMODCLK_L                 (0x0020)
#define SELS__DCOCLK                     (0x0030)        /* DCOCLK */
#define SELS__DCOCLK_L                   (0x0030)
#define SELS__MODCLK                     (0x0040)        /* MODCLK */
#define SELS__MODCLK_L                   (0x0040)
#define SELS__HFXTCLK                    (0x0050)        /* HFXTCLK when HFXT available, otherwise DCOCLK. */
#define SELS__HFXTCLK_L                  (0x0050)
#define SELA                             (0x0700)        /* Selects the ACLK source */
#define SELA_H                           (0x0007)
#define SELA0                            (0x0100)        /* Selects the ACLK source */
#define SELA0_H                          (0x0001)
#define SELA1                            (0x0200)        /* Selects the ACLK source */
#define SELA1_H                          (0x0002)
#define SELA2                            (0x0400)        /* Selects the ACLK source */
#define SELA2_H                          (0x0004)
#define SELA_0                           (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK. */
#define SELA_1                           (0x0100)        /* VLOCLK */
#define SELA_1_H                         (0x0001)
#define SELA_2                           (0x0200)        /* LFMODCLK */
#define SELA_2_H                         (0x0002)
#define SELA__LFXTCLK                    (0x0000)        /* LFXTCLK when LFXT available, otherwise VLOCLK. */
#define SELA__VLOCLK                     (0x0100)        /* VLOCLK */
#define SELA__VLOCLK_H                   (0x0001)
#define SELA__LFMODCLK                   (0x0200)        /* LFMODCLK */
#define SELA__LFMODCLK_H                 (0x0002)

/* CSCTL3 Control Bits */
#define DIVM                             (0x0007)        /* MCLK source divider */
#define DIVM_L                           (0x0007)
#define DIVM0                            (0x0001)        /* MCLK source divider */
#define DIVM0_L                          (0x0001)
#define DIVM1                            (0x0002)        /* MCLK source divider */
#define DIVM1_L                          (0x0002)
#define DIVM2                            (0x0004)        /* MCLK source divider */
#define DIVM2_L                          (0x0004)
#define DIVM_0                           (0x0000)        /* /1 */
#define DIVM_1                           (0x0001)        /* /2 */
#define DIVM_1_L                         (0x0001)
#define DIVM_2                           (0x0002)        /* /4 */
#define DIVM_2_L                         (0x0002)
#define DIVM_3                           (0x0003)        /* /8 */
#define DIVM_3_L                         (0x0003)
#define DIVM_4                           (0x0004)        /* /16 */
#define DIVM_4_L                         (0x0004)
#define DIVM_5                           (0x0005)        /* /32 */
#define DIVM_5_L                         (0x0005)
#define DIVM__1                          (0x0000)        /* /1 */
#define DIVM__2                          (0x0001)        /* /2 */
#define DIVM__2_L                        (0x0001)
#define DIVM__4                          (0x0002)        /* /4 */
#define DIVM__4_L                        (0x0002)
#define DIVM__8                          (0x0003)        /* /8 */
#define DIVM__8_L                        (0x0003)
#define DIVM__16                         (0x0004)        /* /16 */
#define DIVM__16_L                       (0x0004)
#define DIVM__32                         (0x0005)        /* /32 */
#define DIVM__32_L                       (0x0005)
#define DIVS                             (0x0070)        /* SMCLK source divider */
#define DIVS_L                           (0x0070)
#define DIVS0                            (0x0010)        /* SMCLK source divider */
#define DIVS0_L                          (0x0010)
#define DIVS1                            (0x0020)        /* SMCLK source divider */
#define DIVS1_L                          (0x0020)
#define DIVS2                            (0x0040)        /* SMCLK source divider */
#define DIVS2_L                          (0x0040)
#define DIVS_0                           (0x0000)        /* /1 */
#define DIVS_1                           (0x0010)        /* /2 */
#define DIVS_1_L                         (0x0010)
#define DIVS_2                           (0x0020)        /* /4 */
#define DIVS_2_L                         (0x0020)
#define DIVS_3                           (0x0030)        /* /8 */
#define DIVS_3_L                         (0x0030)
#define DIVS_4                           (0x0040)        /* /16 */
#define DIVS_4_L                         (0x0040)
#define DIVS_5                           (0x0050)        /* /32 */
#define DIVS_5_L                         (0x0050)
#define DIVS__1                          (0x0000)        /* /1 */
#define DIVS__2                          (0x0010)        /* /2 */
#define DIVS__2_L                        (0x0010)
#define DIVS__4                          (0x0020)        /* /4 */
#define DIVS__4_L                        (0x0020)
#define DIVS__8                          (0x0030)        /* /8 */
#define DIVS__8_L                        (0x0030)
#define DIVS__16                         (0x0040)        /* /16 */
#define DIVS__16_L                       (0x0040)
#define DIVS__32                         (0x0050)        /* /32 */
#define DIVS__32_L                       (0x0050)
#define DIVA                             (0x0700)        /* ACLK source divider */
#define DIVA_H                           (0x0007)
#define DIVA0                            (0x0100)        /* ACLK source divider */
#define DIVA0_H                          (0x0001)
#define DIVA1                            (0x0200)        /* ACLK source divider */
#define DIVA1_H                          (0x0002)
#define DIVA2                            (0x0400)        /* ACLK source divider */
#define DIVA2_H                          (0x0004)
#define DIVA_0                           (0x0000)        /* /1 */
#define DIVA_1                           (0x0100)        /* /2 */
#define DIVA_1_H                         (0x0001)
#define DIVA_2                           (0x0200)        /* /4 */
#define DIVA_2_H                         (0x0002)
#define DIVA_3                           (0x0300)        /* /8 */
#define DIVA_3_H                         (0x0003)
#define DIVA_4                           (0x0400)        /* /16 */
#define DIVA_4_H                         (0x0004)
#define DIVA_5                           (0x0500)        /* /32 */
#define DIVA_5_H                         (0x0005)
#define DIVA__1                          (0x0000)        /* /1 */
#define DIVA__2                          (0x0100)        /* /2 */
#define DIVA__2_H                        (0x0001)
#define DIVA__4                          (0x0200)        /* /4 */
#define DIVA__4_H                        (0x0002)
#define DIVA__8                          (0x0300)        /* /8 */
#define DIVA__8_H                        (0x0003)
#define DIVA__16                         (0x0400)        /* /16 */
#define DIVA__16_H                       (0x0004)
#define DIVA__32                         (0x0500)        /* /32 */
#define DIVA__32_H                       (0x0005)

/* CSCTL4 Control Bits */
#define LFXTOFF                          (0x0001)        /* LFXT off */
#define LFXTOFF_L                        (0x0001)
#define LFXTOFF_0                        (0x0000)        /* LFXT is on if LFXT is selected via the port selection and LFXT
                                                            is not in bypass mode of operation */
#define LFXTOFF_1                        (0x0001)        /* LFXT is off if it is not used as a source for ACLK, MCLK, or 
                                                            SMCLK */
#define LFXTOFF_1_L                      (0x0001)
#define SMCLKOFF                         (0x0002)        /* SMCLK off */
#define SMCLKOFF_L                       (0x0002)
#define SMCLKOFF_0                       (0x0000)        /* SMCLK on */
#define SMCLKOFF_1                       (0x0002)        /* SMCLK off */
#define SMCLKOFF_1_L                     (0x0002)
#define VLOOFF                           (0x0008)        /* VLO off */
#define VLOOFF_L                         (0x0008)
#define VLOOFF_0                         (0x0000)        /* VLO is on */
#define VLOOFF_1                         (0x0008)        /* VLO is off if it is not used as a source for ACLK, MCLK, or 
                                                            SMCLK or if not used as a source for the RTC in LPM3.5 */
#define VLOOFF_1_L                       (0x0008)
#define LFXTBYPASS                       (0x0010)        /* LFXT bypass select */
#define LFXTBYPASS_L                     (0x0010)
#define LFXTBYPASS_0                     (0x0000)        /* LFXT sourced from external crystal */
#define LFXTBYPASS_1                     (0x0010)        /* LFXT sourced from external clock signal */
#define LFXTBYPASS_1_L                   (0x0010)
#define LFXTDRIVE                        (0x00c0)        /* LFXT oscillator current */
#define LFXTDRIVE_L                      (0x00c0)
#define LFXTDRIVE0                       (0x0040)        /* LFXT oscillator current */
#define LFXTDRIVE0_L                     (0x0040)
#define LFXTDRIVE1                       (0x0080)        /* LFXT oscillator current */
#define LFXTDRIVE1_L                     (0x0080)
#define LFXTDRIVE_0                      (0x0000)        /* Lowest drive strength and current consumption LFXT oscillator */
#define LFXTDRIVE_1                      (0x0040)        /* Increased drive strength LFXT oscillator */
#define LFXTDRIVE_1_L                    (0x0040)
#define LFXTDRIVE_2                      (0x0080)        /* Increased drive strength LFXT oscillator */
#define LFXTDRIVE_2_L                    (0x0080)
#define LFXTDRIVE_3                      (0x00c0)        /* Maximum drive strength and maximum current consumption LFXT 
                                                            oscillator */
#define LFXTDRIVE_3_L                    (0x00c0)
#define HFXTOFF                          (0x0100)        /* Turns off the HFXT oscillator */
#define HFXTOFF_H                        (0x0001)
#define HFXTOFF_0                        (0x0000)        /* HFXT is on if HFXT is selected via the port selection and HFXT
                                                            is not in bypass mode of operation */
#define HFXTOFF_1                        (0x0100)        /* HFXT is off if it is not used as a source for ACLK, MCLK, or 
                                                            SMCLK */
#define HFXTOFF_1_H                      (0x0001)
#define HFFREQ                           (0x0c00)        /* HFXT frequency selection */
#define HFFREQ_H                         (0x000c)
#define HFFREQ0                          (0x0400)        /* HFXT frequency selection */
#define HFFREQ0_H                        (0x0004)
#define HFFREQ1                          (0x0800)        /* HFXT frequency selection */
#define HFFREQ1_H                        (0x0008)
#define HFFREQ_0                         (0x0000)        /* 0 to 4 MHz */
#define HFFREQ_1                         (0x0400)        /* Greater than 4 MHz to 8 MHz */
#define HFFREQ_1_H                       (0x0004)
#define HFFREQ_2                         (0x0800)        /* Greater than 8 MHz to 16 MHz */
#define HFFREQ_2_H                       (0x0008)
#define HFFREQ_3                         (0x0c00)        /* Greater than 16 MHz to 24 MHz */
#define HFFREQ_3_H                       (0x000c)
#define HFXTBYPASS                       (0x1000)        /* HFXT bypass select */
#define HFXTBYPASS_H                     (0x0010)
#define HFXTBYPASS_0                     (0x0000)        /* HFXT sourced from external crystal */
#define HFXTBYPASS_1                     (0x1000)        /* HFXT sourced from external clock signal */
#define HFXTBYPASS_1_H                   (0x0010)
#define HFXTDRIVE                        (0xc000)        /* HFXT oscillator current */
#define HFXTDRIVE_H                      (0x00c0)
#define HFXTDRIVE0                       (0x4000)        /* HFXT oscillator current */
#define HFXTDRIVE0_H                     (0x0040)
#define HFXTDRIVE1                       (0x8000)        /* HFXT oscillator current */
#define HFXTDRIVE1_H                     (0x0080)
#define HFXTDRIVE_0                      (0x0000)        /* Lowest current consumption */
#define HFXTDRIVE_1                      (0x4000)        /* Increased drive strength HFXT oscillator */
#define HFXTDRIVE_1_H                    (0x0040)
#define HFXTDRIVE_2                      (0x8000)        /* Increased drive strength HFXT oscillator */
#define HFXTDRIVE_2_H                    (0x0080)
#define HFXTDRIVE_3                      (0xc000)        /* Maximum drive strength HFXT oscillator */
#define HFXTDRIVE_3_H                    (0x00c0)

/* CSCTL5 Control Bits */
#define LFXTOFFG                         (0x0001)        /* LFXT oscillator fault flag */
#define LFXTOFFG_L                       (0x0001)
#define LFXTOFFG_0                       (0x0000)        /* No fault condition occurred after the last reset */
#define LFXTOFFG_1                       (0x0001)        /* LFXT fault; an LFXT fault occurred after the last reset */
#define LFXTOFFG_1_L                     (0x0001)
#define HFXTOFFG                         (0x0002)        /* HFXT oscillator fault flag */
#define HFXTOFFG_L                       (0x0002)
#define HFXTOFFG_0                       (0x0000)        /* No fault condition occurred after the last reset */
#define HFXTOFFG_1                       (0x0002)        /* HFXT fault; an HFXT fault occurred after the last reset */
#define HFXTOFFG_1_L                     (0x0002)
#define ENSTFCNT1                        (0x0040)        /* Enable start counter for LFXT */
#define ENSTFCNT1_L                      (0x0040)
#define ENSTFCNT1_0                      (0x0000)        /* Startup fault counter disabled. Counter is cleared. */
#define ENSTFCNT1_1                      (0x0040)        /* Startup fault counter enabled */
#define ENSTFCNT1_1_L                    (0x0040)
#define ENSTFCNT1__DISABLE               (0x0000)        /* Startup fault counter disabled. Counter is cleared. */
#define ENSTFCNT1__ENABLE                (0x0040)        /* Startup fault counter enabled */
#define ENSTFCNT1__ENABLE_L              (0x0040)
#define ENSTFCNT2                        (0x0080)        /* Enable start counter for HFXT */
#define ENSTFCNT2_L                      (0x0080)
#define ENSTFCNT2_0                      (0x0000)        /* Startup fault counter disabled. Counter is cleared. */
#define ENSTFCNT2_1                      (0x0080)        /* Startup fault counter enabled */
#define ENSTFCNT2_1_L                    (0x0080)
#define ENSTFCNT2__DISABLE               (0x0000)        /* Startup fault counter disabled. Counter is cleared. */
#define ENSTFCNT2__ENABLE                (0x0080)        /* Startup fault counter enabled */
#define ENSTFCNT2__ENABLE_L              (0x0080)

/* CSCTL6 Control Bits */
#define ACLKREQEN                        (0x0001)        /* ACLK clock request enable */
#define ACLKREQEN_L                      (0x0001)
#define ACLKREQEN_0                      (0x0000)        /* ACLK conditional requests are disabled */
#define ACLKREQEN_1                      (0x0001)        /* ACLK conditional requests are enabled */
#define ACLKREQEN_1_L                    (0x0001)
#define ACLKREQEN__DISABLE               (0x0000)        /* ACLK conditional requests are disabled */
#define ACLKREQEN__ENABLE                (0x0001)        /* ACLK conditional requests are enabled */
#define ACLKREQEN__ENABLE_L              (0x0001)
#define MCLKREQEN                        (0x0002)        /* MCLK clock request enable */
#define MCLKREQEN_L                      (0x0002)
#define MCLKREQEN_0                      (0x0000)        /* MCLK conditional requests are disabled */
#define MCLKREQEN_1                      (0x0002)        /* MCLK conditional requests are enabled */
#define MCLKREQEN_1_L                    (0x0002)
#define MCLKREQEN__DISABLE               (0x0000)        /* MCLK conditional requests are disabled */
#define MCLKREQEN__ENABLE                (0x0002)        /* MCLK conditional requests are enabled */
#define MCLKREQEN__ENABLE_L              (0x0002)
#define SMCLKREQEN                       (0x0004)        /* SMCLK clock request enable */
#define SMCLKREQEN_L                     (0x0004)
#define SMCLKREQEN_0                     (0x0000)        /* SMCLK conditional requests are disabled */
#define SMCLKREQEN_1                     (0x0004)        /* SMCLK conditional requests are enabled */
#define SMCLKREQEN_1_L                   (0x0004)
#define SMCLKREQEN__DISABLE              (0x0000)        /* SMCLK conditional requests are disabled */
#define SMCLKREQEN__ENABLE               (0x0004)        /* SMCLK conditional requests are enabled */
#define SMCLKREQEN__ENABLE_L             (0x0004)
#define MODCLKREQEN                      (0x0008)        /* MODCLK clock request enable */
#define MODCLKREQEN_L                    (0x0008)
#define MODCLKREQEN_0                    (0x0000)        /* MODCLK conditional requests are disabled */
#define MODCLKREQEN_1                    (0x0008)        /* MODCLK conditional requests are enabled */
#define MODCLKREQEN_1_L                  (0x0008)
#define MODCLKREQEN__DISABLE             (0x0000)        /* MODCLK conditional requests are disabled */
#define MODCLKREQEN__ENABLE              (0x0008)        /* MODCLK conditional requests are enabled */
#define MODCLKREQEN__ENABLE_L            (0x0008)


/*****************************************************************************
 DIO Registers
*****************************************************************************/

#define __MSP430_HAS_DIO__ 9                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_DIO__ 0x0200
#define DIO_BASE               __MSP430_BASEADDRESS_DIO__
#define __MSP430_HAS_PORTA_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTA_R__ 0x200
#define PA_BASE                __MSP430_BASEADDRESS_PORTA_R__
#define __MSP430_HAS_PORTB_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTB_R__ 0x220
#define PB_BASE                __MSP430_BASEADDRESS_PORTB_R__
#define __MSP430_HAS_PORTC_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTC_R__ 0x240
#define PC_BASE                __MSP430_BASEADDRESS_PORTC_R__
#define __MSP430_HAS_PORTD_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTD_R__ 0x260
#define PD_BASE                __MSP430_BASEADDRESS_PORTD_R__
#define __MSP430_HAS_PORTE_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTE_R__ 0x280
#define PE_BASE                __MSP430_BASEADDRESS_PORTE_R__
#define __MSP430_HAS_PORTJ_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORTJ_R__ 0x320
#define PJ_BASE                __MSP430_BASEADDRESS_PORTJ_R__
#define __MSP430_HAS_PORT1_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT1_R__ 0x200
#define P1_BASE                __MSP430_BASEADDRESS_PORT1_R__
#define __MSP430_HAS_PORT2_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT2_R__ 0x200
#define P2_BASE                __MSP430_BASEADDRESS_PORT2_R__
#define __MSP430_HAS_PORT3_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT3_R__ 0x220
#define P3_BASE                __MSP430_BASEADDRESS_PORT3_R__
#define __MSP430_HAS_PORT4_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT4_R__ 0x220
#define P4_BASE                __MSP430_BASEADDRESS_PORT4_R__
#define __MSP430_HAS_PORT5_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT5_R__ 0x240
#define P5_BASE                __MSP430_BASEADDRESS_PORT5_R__
#define __MSP430_HAS_PORT6_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT6_R__ 0x240
#define P6_BASE                __MSP430_BASEADDRESS_PORT6_R__
#define __MSP430_HAS_PORT7_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT7_R__ 0x260
#define P7_BASE                __MSP430_BASEADDRESS_PORT7_R__
#define __MSP430_HAS_PORT8_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT8_R__ 0x260
#define P8_BASE                __MSP430_BASEADDRESS_PORT8_R__
#define __MSP430_HAS_PORT9_R__                /* Definition to show that port is available */
#define __MSP430_BASEADDRESS_PORT9_R__ 0x280
#define P9_BASE                __MSP430_BASEADDRESS_PORT9_R__
#define __MSP430_HAS_PASEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PASEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PBSEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PBSEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PCSEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PCSEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PDSEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PDSEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PESEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PESEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_PJSEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_PJSEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P1SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P2SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P1SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P2SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P4SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P3SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P3SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P4SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P5SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P6SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P5SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P6SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P7SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P8SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P7SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P8SEL1__                 /* Define for DriverLib */
#define __MSP430_HAS_P9SEL0__                 /* Define for DriverLib */
#define __MSP430_HAS_P9SEL1__                 /* Define for DriverLib */

sfr_w(PAIN);                                  /* Port A Input */
sfr_b(PAIN_L);
sfr_b(PAIN_H);
sfr_w(PAOUT);                                 /* Port A Output */
sfr_b(PAOUT_L);
sfr_b(PAOUT_H);
sfr_w(PADIR);                                 /* Port A Direction */
sfr_b(PADIR_L);
sfr_b(PADIR_H);
sfr_w(PAREN);                                 /* Port A Resistor Enable */
sfr_b(PAREN_L);
sfr_b(PAREN_H);
sfr_w(PASEL0);                                /* Port A Select 0 */
sfr_b(PASEL0_L);
sfr_b(PASEL0_H);
sfr_w(PASEL1);                                /* Port A Select 1 */
sfr_b(PASEL1_L);
sfr_b(PASEL1_H);
sfr_w(P1IV);                                  /* Port 1 Interrupt Vector Register */
sfr_b(P1IV_L);
sfr_b(P1IV_H);
sfr_w(PASELC);                                /* Port A Complement Select */
sfr_b(PASELC_L);
sfr_b(PASELC_H);
sfr_w(PAIES);                                 /* Port A Interrupt Edge Select */
sfr_b(PAIES_L);
sfr_b(PAIES_H);
sfr_w(PAIE);                                  /* Port A Interrupt Enable */
sfr_b(PAIE_L);
sfr_b(PAIE_H);
sfr_w(PAIFG);                                 /* Port A Interrupt Flag */
sfr_b(PAIFG_L);
sfr_b(PAIFG_H);
sfr_w(P2IV);                                  /* Port 2 Interrupt Vector Register */
sfr_b(P2IV_L);
sfr_b(P2IV_H);
sfr_w(PBIN);                                  /* Port B Input */
sfr_b(PBIN_L);
sfr_b(PBIN_H);
sfr_w(PBOUT);                                 /* Port B Output */
sfr_b(PBOUT_L);
sfr_b(PBOUT_H);
sfr_w(PBDIR);                                 /* Port B Direction */
sfr_b(PBDIR_L);
sfr_b(PBDIR_H);
sfr_w(PBREN);                                 /* Port B Resistor Enable */
sfr_b(PBREN_L);
sfr_b(PBREN_H);
sfr_w(PBSEL0);                                /* Port B Select 0 */
sfr_b(PBSEL0_L);
sfr_b(PBSEL0_H);
sfr_w(PBSEL1);                                /* Port B Select 1 */
sfr_b(PBSEL1_L);
sfr_b(PBSEL1_H);
sfr_w(P3IV);                                  /* Port 3 Interrupt Vector Register */
sfr_b(P3IV_L);
sfr_b(P3IV_H);
sfr_w(PBSELC);                                /* Port B Complement Select */
sfr_b(PBSELC_L);
sfr_b(PBSELC_H);
sfr_w(PBIES);                                 /* Port B Interrupt Edge Select */
sfr_b(PBIES_L);
sfr_b(PBIES_H);
sfr_w(PBIE);                                  /* Port B Interrupt Enable */
sfr_b(PBIE_L);
sfr_b(PBIE_H);
sfr_w(PBIFG);                                 /* Port B Interrupt Flag */
sfr_b(PBIFG_L);
sfr_b(PBIFG_H);
sfr_w(P4IV);                                  /* Port 4 Interrupt Vector Register */
sfr_b(P4IV_L);
sfr_b(P4IV_H);
sfr_w(PCIN);                                  /* Port C Input */
sfr_b(PCIN_L);
sfr_b(PCIN_H);
sfr_w(PCOUT);                                 /* Port C Output */
sfr_b(PCOUT_L);
sfr_b(PCOUT_H);
sfr_w(PCDIR);                                 /* Port C Direction */
sfr_b(PCDIR_L);
sfr_b(PCDIR_H);
sfr_w(PCREN);                                 /* Port C Resistor Enable */
sfr_b(PCREN_L);
sfr_b(PCREN_H);
sfr_w(PCSEL0);                                /* Port C Select 0 */
sfr_b(PCSEL0_L);
sfr_b(PCSEL0_H);
sfr_w(PCSEL1);                                /* Port C Select 1 */
sfr_b(PCSEL1_L);
sfr_b(PCSEL1_H);
sfr_w(P5IV);                                  /* Port 5 Interrupt Vector Register */
sfr_b(P5IV_L);
sfr_b(P5IV_H);
sfr_w(PCSELC);                                /* Port C Complement Select */
sfr_b(PCSELC_L);
sfr_b(PCSELC_H);
sfr_w(PCIES);                                 /* Port C Interrupt Edge Select */
sfr_b(PCIES_L);
sfr_b(PCIES_H);
sfr_w(PCIE);                                  /* Port C Interrupt Enable */
sfr_b(PCIE_L);
sfr_b(PCIE_H);
sfr_w(PCIFG);                                 /* Port C Interrupt Flag */
sfr_b(PCIFG_L);
sfr_b(PCIFG_H);
sfr_w(P6IV);                                  /* Port 6 Interrupt Vector Register */
sfr_b(P6IV_L);
sfr_b(P6IV_H);
sfr_w(PDIN);                                  /* Port D Input */
sfr_b(PDIN_L);
sfr_b(PDIN_H);
sfr_w(PDOUT);                                 /* Port D Output */
sfr_b(PDOUT_L);
sfr_b(PDOUT_H);
sfr_w(PDDIR);                                 /* Port D Direction */
sfr_b(PDDIR_L);
sfr_b(PDDIR_H);
sfr_w(PDREN);                                 /* Port D Resistor Enable */
sfr_b(PDREN_L);
sfr_b(PDREN_H);
sfr_w(PDSEL0);                                /* Port D Select 0 */
sfr_b(PDSEL0_L);
sfr_b(PDSEL0_H);
sfr_w(PDSEL1);                                /* Port D Select 1 */
sfr_b(PDSEL1_L);
sfr_b(PDSEL1_H);
sfr_w(P7IV);                                  /* Port 7 Interrupt Vector Register */
sfr_b(P7IV_L);
sfr_b(P7IV_H);
sfr_w(PDSELC);                                /* Port D Complement Select */
sfr_b(PDSELC_L);
sfr_b(PDSELC_H);
sfr_w(PDIES);                                 /* Port D Interrupt Edge Select */
sfr_b(PDIES_L);
sfr_b(PDIES_H);
sfr_w(PDIE);                                  /* Port D Interrupt Enable */
sfr_b(PDIE_L);
sfr_b(PDIE_H);
sfr_w(PDIFG);                                 /* Port D Interrupt Flag */
sfr_b(PDIFG_L);
sfr_b(PDIFG_H);
sfr_w(P8IV);                                  /* Port 8 Interrupt Vector Register */
sfr_b(P8IV_L);
sfr_b(P8IV_H);
sfr_w(PEIN);                                  /* Port E Input */
sfr_b(PEIN_L);
sfr_b(PEIN_H);
sfr_w(PEOUT);                                 /* Port E Output */
sfr_b(PEOUT_L);
sfr_b(PEOUT_H);
sfr_w(PEDIR);                                 /* Port E Direction */
sfr_b(PEDIR_L);
sfr_b(PEDIR_H);
sfr_w(PEREN);                                 /* Port E Resistor Enable */
sfr_b(PEREN_L);
sfr_b(PEREN_H);
sfr_w(PESEL0);                                /* Port E Select 0 */
sfr_b(PESEL0_L);
sfr_b(PESEL0_H);
sfr_w(PESEL1);                                /* Port E Select 1 */
sfr_b(PESEL1_L);
sfr_b(PESEL1_H);
sfr_w(P9IV);                                  /* Port 9 Interrupt Vector Register */
sfr_b(P9IV_L);
sfr_b(P9IV_H);
sfr_w(PESELC);                                /* Port E Complement Select */
sfr_b(PESELC_L);
sfr_b(PESELC_H);
sfr_w(PEIES);                                 /* Port E Interrupt Edge Select */
sfr_b(PEIES_L);
sfr_b(PEIES_H);
sfr_w(PEIE);                                  /* Port E Interrupt Enable */
sfr_b(PEIE_L);
sfr_b(PEIE_H);
sfr_w(PEIFG);                                 /* Port E Interrupt Flag */
sfr_b(PEIFG_L);
sfr_b(PEIFG_H);
sfr_w(PJIN);                                  /* Port J Input */
sfr_b(PJIN_L);
sfr_b(PJIN_H);
sfr_w(PJOUT);                                 /* Port J Output */
sfr_b(PJOUT_L);
sfr_b(PJOUT_H);
sfr_w(PJDIR);                                 /* Port J Direction */
sfr_b(PJDIR_L);
sfr_b(PJDIR_H);
sfr_w(PJREN);                                 /* Port J Resistor Enable */
sfr_b(PJREN_L);
sfr_b(PJREN_H);
sfr_w(PJSEL0);                                /* Port J Select 0 */
sfr_b(PJSEL0_L);
sfr_b(PJSEL0_H);
sfr_w(PJSEL1);                                /* Port J Select 1 */
sfr_b(PJSEL1_L);
sfr_b(PJSEL1_H);
sfr_w(PJSELC);                                /* Port J Complement Select */
sfr_b(PJSELC_L);
sfr_b(PJSELC_H);
sfr_b(P1IN);                                  /* Port 1 Input */

sfr_b(P2IN);                                  /* Port 2 Input */

sfr_b(P2OUT);                                 /* Port 2 Output */

sfr_b(P1OUT);                                 /* Port 1 Output */

sfr_b(P1DIR);                                 /* Port 1 Direction */

sfr_b(P2DIR);                                 /* Port 2 Direction */

sfr_b(P1REN);                                 /* Port 1 Resistor Enable */

sfr_b(P2REN);                                 /* Port 2 Resistor Enable */

sfr_b(P1SEL0);                                /* Port 1 Select 0 */

sfr_b(P2SEL0);                                /* Port 2 Select 0 */

sfr_b(P1SEL1);                                /* Port 1 Select 1 */

sfr_b(P2SEL1);                                /* Port 2 Select 1 */

sfr_b(P1SELC);                                /* Port 1 Complement Select */

sfr_b(P2SELC);                                /* Port 2 Complement Select */

sfr_b(P1IES);                                 /* Port 1 Interrupt Edge Select */

sfr_b(P2IES);                                 /* Port 2 Interrupt Edge Select */

sfr_b(P1IE);                                  /* Port 1 Interrupt Enable */

sfr_b(P2IE);                                  /* Port 2 Interrupt Enable */

sfr_b(P1IFG);                                 /* Port 1 Interrupt Flag */

sfr_b(P2IFG);                                 /* Port 2 Interrupt Flag */

sfr_b(P3IN);                                  /* Port 3 Input */

sfr_b(P4IN);                                  /* Port 4 Input */

sfr_b(P3OUT);                                 /* Port 3 Output */

sfr_b(P4OUT);                                 /* Port 4 Output */

sfr_b(P3DIR);                                 /* Port 3 Direction */

sfr_b(P4DIR);                                 /* Port 4 Direction */

sfr_b(P3REN);                                 /* Port 3 Resistor Enable */

sfr_b(P4REN);                                 /* Port 4 Resistor Enable */

sfr_b(P4SEL0);                                /* Port 4 Select 0 */

sfr_b(P3SEL0);                                /* Port 3 Select 0 */

sfr_b(P3SEL1);                                /* Port 3 Select 1 */

sfr_b(P4SEL1);                                /* Port 4 Select 1 */

sfr_b(P3SELC);                                /* Port 3 Complement Select */

sfr_b(P4SELC);                                /* Port 4 Complement Select */

sfr_b(P3IES);                                 /* Port 3 Interrupt Edge Select */

sfr_b(P4IES);                                 /* Port 4 Interrupt Edge Select */

sfr_b(P3IE);                                  /* Port 3 Interrupt Enable */

sfr_b(P4IE);                                  /* Port 4 Interrupt Enable */

sfr_b(P3IFG);                                 /* Port 3 Interrupt Flag */

sfr_b(P4IFG);                                 /* Port 4 Interrupt Flag */

sfr_b(P5IN);                                  /* Port 5 Input */

sfr_b(P6IN);                                  /* Port 6 Input */

sfr_b(P5OUT);                                 /* Port 5 Output */

sfr_b(P6OUT);                                 /* Port 6 Output */

sfr_b(P5DIR);                                 /* Port 5 Direction */

sfr_b(P6DIR);                                 /* Port 6 Direction */

sfr_b(P5REN);                                 /* Port 5 Resistor Enable */

sfr_b(P6REN);                                 /* Port 6 Resistor Enable */

sfr_b(P5SEL0);                                /* Port 5 Select 0 */

sfr_b(P6SEL0);                                /* Port 6 Select 0 */

sfr_b(P5SEL1);                                /* Port 5 Select 1 */

sfr_b(P6SEL1);                                /* Port 6 Select 1 */

sfr_b(P5SELC);                                /* Port 5 Complement Select */

sfr_b(P6SELC);                                /* Port 6 Complement Select */

sfr_b(P5IES);                                 /* Port 5 Interrupt Edge Select */

sfr_b(P6IES);                                 /* Port 6 Interrupt Edge Select */

sfr_b(P5IE);                                  /* Port 5 Interrupt Enable */

sfr_b(P6IE);                                  /* Port 6 Interrupt Enable */

sfr_b(P5IFG);                                 /* Port 5 Interrupt Flag */

sfr_b(P6IFG);                                 /* Port 6 Interrupt Flag */

sfr_b(P7IN);                                  /* Port 7 Input */

sfr_b(P8IN);                                  /* Port 8 Input */

sfr_b(P7OUT);                                 /* Port 7 Output */

sfr_b(P8OUT);                                 /* Port 8 Output */

sfr_b(P7DIR);                                 /* Port 7 Direction */

sfr_b(P8DIR);                                 /* Port 8 Direction */

sfr_b(P7REN);                                 /* Port 7 Resistor Enable */

sfr_b(P8REN);                                 /* Port 8 Resistor Enable */

sfr_b(P7SEL0);                                /* Port 7 Select 0 */

sfr_b(P8SEL0);                                /* Port 8 Select 0 */

sfr_b(P7SEL1);                                /* Port 7 Select 1 */

sfr_b(P8SEL1);                                /* Port 8 Select 1 */

sfr_b(P7SELC);                                /* Port 7 Complement Select */

sfr_b(P8SELC);                                /* Port 8 Complement Select */

sfr_b(P7IES);                                 /* Port 7 Interrupt Edge Select */

sfr_b(P8IES);                                 /* Port 8 Interrupt Edge Select */

sfr_b(P7IE);                                  /* Port 7 Interrupt Enable */

sfr_b(P8IE);                                  /* Port 8 Interrupt Enable */

sfr_b(P7IFG);                                 /* Port 7 Interrupt Flag */

sfr_b(P8IFG);                                 /* Port 8 Interrupt Flag */

sfr_b(P9IN);                                  /* Port 9 Input */

sfr_b(P9OUT);                                 /* Port 9 Output */

sfr_b(P9DIR);                                 /* Port 9 Direction */

sfr_b(P9REN);                                 /* Port 9 Resistor Enable */

sfr_b(P9SEL0);                                /* Port 9 Select 0 */

sfr_b(P9SEL1);                                /* Port 9 Select 1 */

sfr_b(P9SELC);                                /* Port 9 Complement Select */

sfr_b(P9IES);                                 /* Port 9 Interrupt Edge Select */

sfr_b(P9IE);                                  /* Port 9 Interrupt Enable */

sfr_b(P9IFG);                                 /* Port 9 Interrupt Flag */


/* DIO Register Offsets */
#define OFS_PAIN                         (0x0000)
#define OFS_PAIN_L                       OFS_PAIN
#define OFS_PAIN_H                       OFS_PAIN+1
#define OFS_PAOUT                        (0x0002)
#define OFS_PAOUT_L                      OFS_PAOUT
#define OFS_PAOUT_H                      OFS_PAOUT+1
#define OFS_PADIR                        (0x0004)
#define OFS_PADIR_L                      OFS_PADIR
#define OFS_PADIR_H                      OFS_PADIR+1
#define OFS_PAREN                        (0x0006)
#define OFS_PAREN_L                      OFS_PAREN
#define OFS_PAREN_H                      OFS_PAREN+1
#define OFS_PASEL0                       (0x000A)
#define OFS_PASEL0_L                     OFS_PASEL0
#define OFS_PASEL0_H                     OFS_PASEL0+1
#define OFS_PASEL1                       (0x000C)
#define OFS_PASEL1_L                     OFS_PASEL1
#define OFS_PASEL1_H                     OFS_PASEL1+1
#define OFS_P1IV                         (0x000E)
#define OFS_P1IV_L                       OFS_P1IV
#define OFS_P1IV_H                       OFS_P1IV+1
#define OFS_PASELC                       (0x0016)
#define OFS_PASELC_L                     OFS_PASELC
#define OFS_PASELC_H                     OFS_PASELC+1
#define OFS_PAIES                        (0x0018)
#define OFS_PAIES_L                      OFS_PAIES
#define OFS_PAIES_H                      OFS_PAIES+1
#define OFS_PAIE                         (0x001A)
#define OFS_PAIE_L                       OFS_PAIE
#define OFS_PAIE_H                       OFS_PAIE+1
#define OFS_PAIFG                        (0x001C)
#define OFS_PAIFG_L                      OFS_PAIFG
#define OFS_PAIFG_H                      OFS_PAIFG+1
#define OFS_P2IV                         (0x001E)
#define OFS_P2IV_L                       OFS_P2IV
#define OFS_P2IV_H                       OFS_P2IV+1
#define OFS_PBIN                         (0x0000)
#define OFS_PBIN_L                       OFS_PBIN
#define OFS_PBIN_H                       OFS_PBIN+1
#define OFS_PBOUT                        (0x0002)
#define OFS_PBOUT_L                      OFS_PBOUT
#define OFS_PBOUT_H                      OFS_PBOUT+1
#define OFS_PBDIR                        (0x0004)
#define OFS_PBDIR_L                      OFS_PBDIR
#define OFS_PBDIR_H                      OFS_PBDIR+1
#define OFS_PBREN                        (0x0006)
#define OFS_PBREN_L                      OFS_PBREN
#define OFS_PBREN_H                      OFS_PBREN+1
#define OFS_PBSEL0                       (0x000A)
#define OFS_PBSEL0_L                     OFS_PBSEL0
#define OFS_PBSEL0_H                     OFS_PBSEL0+1
#define OFS_PBSEL1                       (0x000C)
#define OFS_PBSEL1_L                     OFS_PBSEL1
#define OFS_PBSEL1_H                     OFS_PBSEL1+1
#define OFS_P3IV                         (0x000E)
#define OFS_P3IV_L                       OFS_P3IV
#define OFS_P3IV_H                       OFS_P3IV+1
#define OFS_PBSELC                       (0x0016)
#define OFS_PBSELC_L                     OFS_PBSELC
#define OFS_PBSELC_H                     OFS_PBSELC+1
#define OFS_PBIES                        (0x0018)
#define OFS_PBIES_L                      OFS_PBIES
#define OFS_PBIES_H                      OFS_PBIES+1
#define OFS_PBIE                         (0x001A)
#define OFS_PBIE_L                       OFS_PBIE
#define OFS_PBIE_H                       OFS_PBIE+1
#define OFS_PBIFG                        (0x001C)
#define OFS_PBIFG_L                      OFS_PBIFG
#define OFS_PBIFG_H                      OFS_PBIFG+1
#define OFS_P4IV                         (0x001E)
#define OFS_P4IV_L                       OFS_P4IV
#define OFS_P4IV_H                       OFS_P4IV+1
#define OFS_PCIN                         (0x0000)
#define OFS_PCIN_L                       OFS_PCIN
#define OFS_PCIN_H                       OFS_PCIN+1
#define OFS_PCOUT                        (0x0002)
#define OFS_PCOUT_L                      OFS_PCOUT
#define OFS_PCOUT_H                      OFS_PCOUT+1
#define OFS_PCDIR                        (0x0004)
#define OFS_PCDIR_L                      OFS_PCDIR
#define OFS_PCDIR_H                      OFS_PCDIR+1
#define OFS_PCREN                        (0x0006)
#define OFS_PCREN_L                      OFS_PCREN
#define OFS_PCREN_H                      OFS_PCREN+1
#define OFS_PCSEL0                       (0x000A)
#define OFS_PCSEL0_L                     OFS_PCSEL0
#define OFS_PCSEL0_H                     OFS_PCSEL0+1
#define OFS_PCSEL1                       (0x000C)
#define OFS_PCSEL1_L                     OFS_PCSEL1
#define OFS_PCSEL1_H                     OFS_PCSEL1+1
#define OFS_P5IV                         (0x000E)
#define OFS_P5IV_L                       OFS_P5IV
#define OFS_P5IV_H                       OFS_P5IV+1
#define OFS_PCSELC                       (0x0016)
#define OFS_PCSELC_L                     OFS_PCSELC
#define OFS_PCSELC_H                     OFS_PCSELC+1
#define OFS_PCIES                        (0x0018)
#define OFS_PCIES_L                      OFS_PCIES
#define OFS_PCIES_H                      OFS_PCIES+1
#define OFS_PCIE                         (0x001A)
#define OFS_PCIE_L                       OFS_PCIE
#define OFS_PCIE_H                       OFS_PCIE+1
#define OFS_PCIFG                        (0x001C)
#define OFS_PCIFG_L                      OFS_PCIFG
#define OFS_PCIFG_H                      OFS_PCIFG+1
#define OFS_P6IV                         (0x001E)
#define OFS_P6IV_L                       OFS_P6IV
#define OFS_P6IV_H                       OFS_P6IV+1
#define OFS_PDIN                         (0x0000)
#define OFS_PDIN_L                       OFS_PDIN
#define OFS_PDIN_H                       OFS_PDIN+1
#define OFS_PDOUT                        (0x0002)
#define OFS_PDOUT_L                      OFS_PDOUT
#define OFS_PDOUT_H                      OFS_PDOUT+1
#define OFS_PDDIR                        (0x0004)
#define OFS_PDDIR_L                      OFS_PDDIR
#define OFS_PDDIR_H                      OFS_PDDIR+1
#define OFS_PDREN                        (0x0006)
#define OFS_PDREN_L                      OFS_PDREN
#define OFS_PDREN_H                      OFS_PDREN+1
#define OFS_PDSEL0                       (0x000A)
#define OFS_PDSEL0_L                     OFS_PDSEL0
#define OFS_PDSEL0_H                     OFS_PDSEL0+1
#define OFS_PDSEL1                       (0x000C)
#define OFS_PDSEL1_L                     OFS_PDSEL1
#define OFS_PDSEL1_H                     OFS_PDSEL1+1
#define OFS_P7IV                         (0x000E)
#define OFS_P7IV_L                       OFS_P7IV
#define OFS_P7IV_H                       OFS_P7IV+1
#define OFS_PDSELC                       (0x0016)
#define OFS_PDSELC_L                     OFS_PDSELC
#define OFS_PDSELC_H                     OFS_PDSELC+1
#define OFS_PDIES                        (0x0018)
#define OFS_PDIES_L                      OFS_PDIES
#define OFS_PDIES_H                      OFS_PDIES+1
#define OFS_PDIE                         (0x001A)
#define OFS_PDIE_L                       OFS_PDIE
#define OFS_PDIE_H                       OFS_PDIE+1
#define OFS_PDIFG                        (0x001C)
#define OFS_PDIFG_L                      OFS_PDIFG
#define OFS_PDIFG_H                      OFS_PDIFG+1
#define OFS_P8IV                         (0x001E)
#define OFS_P8IV_L                       OFS_P8IV
#define OFS_P8IV_H                       OFS_P8IV+1
#define OFS_PEIN                         (0x0000)
#define OFS_PEIN_L                       OFS_PEIN
#define OFS_PEIN_H                       OFS_PEIN+1
#define OFS_PEOUT                        (0x0002)
#define OFS_PEOUT_L                      OFS_PEOUT
#define OFS_PEOUT_H                      OFS_PEOUT+1
#define OFS_PEDIR                        (0x0004)
#define OFS_PEDIR_L                      OFS_PEDIR
#define OFS_PEDIR_H                      OFS_PEDIR+1
#define OFS_PEREN                        (0x0006)
#define OFS_PEREN_L                      OFS_PEREN
#define OFS_PEREN_H                      OFS_PEREN+1
#define OFS_PESEL0                       (0x000A)
#define OFS_PESEL0_L                     OFS_PESEL0
#define OFS_PESEL0_H                     OFS_PESEL0+1
#define OFS_PESEL1                       (0x000C)
#define OFS_PESEL1_L                     OFS_PESEL1
#define OFS_PESEL1_H                     OFS_PESEL1+1
#define OFS_P9IV                         (0x000E)
#define OFS_P9IV_L                       OFS_P9IV
#define OFS_P9IV_H                       OFS_P9IV+1
#define OFS_PESELC                       (0x0016)
#define OFS_PESELC_L                     OFS_PESELC
#define OFS_PESELC_H                     OFS_PESELC+1
#define OFS_PEIES                        (0x0018)
#define OFS_PEIES_L                      OFS_PEIES
#define OFS_PEIES_H                      OFS_PEIES+1
#define OFS_PEIE                         (0x001A)
#define OFS_PEIE_L                       OFS_PEIE
#define OFS_PEIE_H                       OFS_PEIE+1
#define OFS_PEIFG                        (0x001C)
#define OFS_PEIFG_L                      OFS_PEIFG
#define OFS_PEIFG_H                      OFS_PEIFG+1
#define OFS_PJIN                         (0x0000)
#define OFS_PJIN_L                       OFS_PJIN
#define OFS_PJIN_H                       OFS_PJIN+1
#define OFS_PJOUT                        (0x0002)
#define OFS_PJOUT_L                      OFS_PJOUT
#define OFS_PJOUT_H                      OFS_PJOUT+1
#define OFS_PJDIR                        (0x0004)
#define OFS_PJDIR_L                      OFS_PJDIR
#define OFS_PJDIR_H                      OFS_PJDIR+1
#define OFS_PJREN                        (0x0006)
#define OFS_PJREN_L                      OFS_PJREN
#define OFS_PJREN_H                      OFS_PJREN+1
#define OFS_PJSEL0                       (0x000A)
#define OFS_PJSEL0_L                     OFS_PJSEL0
#define OFS_PJSEL0_H                     OFS_PJSEL0+1
#define OFS_PJSEL1                       (0x000C)
#define OFS_PJSEL1_L                     OFS_PJSEL1
#define OFS_PJSEL1_H                     OFS_PJSEL1+1
#define OFS_PJSELC                       (0x0016)
#define OFS_PJSELC_L                     OFS_PJSELC
#define OFS_PJSELC_H                     OFS_PJSELC+1
#define OFS_P1IN                         (0x0000)
#define OFS_P2IN                         (0x0001)
#define OFS_P2OUT                        (0x0003)
#define OFS_P1OUT                        (0x0002)
#define OFS_P1DIR                        (0x0004)
#define OFS_P2DIR                        (0x0005)
#define OFS_P1REN                        (0x0006)
#define OFS_P2REN                        (0x0007)
#define OFS_P1SEL0                       (0x000A)
#define OFS_P2SEL0                       (0x000B)
#define OFS_P1SEL1                       (0x000C)
#define OFS_P2SEL1                       (0x000D)
#define OFS_P1SELC                       (0x0016)
#define OFS_P2SELC                       (0x0017)
#define OFS_P1IES                        (0x0018)
#define OFS_P2IES                        (0x0019)
#define OFS_P1IE                         (0x001A)
#define OFS_P2IE                         (0x001B)
#define OFS_P1IFG                        (0x001C)
#define OFS_P2IFG                        (0x001D)
#define OFS_P3IN                         (0x0000)
#define OFS_P4IN                         (0x0001)
#define OFS_P3OUT                        (0x0002)
#define OFS_P4OUT                        (0x0003)
#define OFS_P3DIR                        (0x0004)
#define OFS_P4DIR                        (0x0005)
#define OFS_P3REN                        (0x0006)
#define OFS_P4REN                        (0x0007)
#define OFS_P4SEL0                       (0x000B)
#define OFS_P3SEL0                       (0x000A)
#define OFS_P3SEL1                       (0x000C)
#define OFS_P4SEL1                       (0x000D)
#define OFS_P3SELC                       (0x0016)
#define OFS_P4SELC                       (0x0017)
#define OFS_P3IES                        (0x0018)
#define OFS_P4IES                        (0x0019)
#define OFS_P3IE                         (0x001A)
#define OFS_P4IE                         (0x001B)
#define OFS_P3IFG                        (0x001C)
#define OFS_P4IFG                        (0x001D)
#define OFS_P5IN                         (0x0000)
#define OFS_P6IN                         (0x0001)
#define OFS_P5OUT                        (0x0002)
#define OFS_P6OUT                        (0x0003)
#define OFS_P5DIR                        (0x0004)
#define OFS_P6DIR                        (0x0005)
#define OFS_P5REN                        (0x0006)
#define OFS_P6REN                        (0x0007)
#define OFS_P5SEL0                       (0x000A)
#define OFS_P6SEL0                       (0x000B)
#define OFS_P5SEL1                       (0x000C)
#define OFS_P6SEL1                       (0x000D)
#define OFS_P5SELC                       (0x0016)
#define OFS_P6SELC                       (0x0017)
#define OFS_P5IES                        (0x0018)
#define OFS_P6IES                        (0x0019)
#define OFS_P5IE                         (0x001A)
#define OFS_P6IE                         (0x001B)
#define OFS_P5IFG                        (0x001C)
#define OFS_P6IFG                        (0x001D)
#define OFS_P7IN                         (0x0000)
#define OFS_P8IN                         (0x0001)
#define OFS_P7OUT                        (0x0002)
#define OFS_P8OUT                        (0x0003)
#define OFS_P7DIR                        (0x0004)
#define OFS_P8DIR                        (0x0005)
#define OFS_P7REN                        (0x0006)
#define OFS_P8REN                        (0x0007)
#define OFS_P7SEL0                       (0x000A)
#define OFS_P8SEL0                       (0x000B)
#define OFS_P7SEL1                       (0x000C)
#define OFS_P8SEL1                       (0x000D)
#define OFS_P7SELC                       (0x0016)
#define OFS_P8SELC                       (0x0017)
#define OFS_P7IES                        (0x0018)
#define OFS_P8IES                        (0x0019)
#define OFS_P7IE                         (0x001A)
#define OFS_P8IE                         (0x001B)
#define OFS_P7IFG                        (0x001C)
#define OFS_P8IFG                        (0x001D)
#define OFS_P9IN                         (0x0000)
#define OFS_P9OUT                        (0x0003)
#define OFS_P9DIR                        (0x0005)
#define OFS_P9REN                        (0x0007)
#define OFS_P9SEL0                       (0x000B)
#define OFS_P9SEL1                       (0x000D)
#define OFS_P9SELC                       (0x0017)
#define OFS_P9IES                        (0x0019)
#define OFS_P9IE                         (0x001B)
#define OFS_P9IFG                        (0x001D)

/* DIO Control Bits */

/* P1IV Control Bits */
#define P1IV0                            (0x0001)        /* Port 1 interrupt vector value */
#define P1IV0_L                          (0x0001)
#define P1IV1                            (0x0002)        /* Port 1 interrupt vector value */
#define P1IV1_L                          (0x0002)
#define P1IV2                            (0x0004)        /* Port 1 interrupt vector value */
#define P1IV2_L                          (0x0004)
#define P1IV3                            (0x0008)        /* Port 1 interrupt vector value */
#define P1IV3_L                          (0x0008)
#define P1IV4                            (0x0010)        /* Port 1 interrupt vector value */
#define P1IV4_L                          (0x0010)
#define P1IV_0                           (0x0000)        /* No interrupt pending */
#define P1IV_2                           (0x0002)        /* Interrupt Source: Port 1.0 interrupt; Interrupt Flag: P1IFG0; 
                                                            Interrupt Priority: Highest */
#define P1IV_2_L                         (0x0002)
#define P1IV_4                           (0x0004)        /* Interrupt Source: Port 1.1 interrupt; Interrupt Flag: P1IFG1 */
#define P1IV_4_L                         (0x0004)
#define P1IV_6                           (0x0006)        /* Interrupt Source: Port 1.2 interrupt; Interrupt Flag: P1IFG2 */
#define P1IV_6_L                         (0x0006)
#define P1IV_8                           (0x0008)        /* Interrupt Source: Port 1.3 interrupt; Interrupt Flag: P1IFG3 */
#define P1IV_8_L                         (0x0008)
#define P1IV_10                          (0x000a)        /* Interrupt Source: Port 1.4 interrupt; Interrupt Flag: P1IFG4 */
#define P1IV_10_L                        (0x000a)
#define P1IV_12                          (0x000c)        /* Interrupt Source: Port 1.5 interrupt; Interrupt Flag: P1IFG5 */
#define P1IV_12_L                        (0x000c)
#define P1IV_14                          (0x000e)        /* Interrupt Source: Port 1.6 interrupt; Interrupt Flag: P1IFG6 */
#define P1IV_14_L                        (0x000e)
#define P1IV_16                          (0x0010)        /* Interrupt Source: Port 1.7 interrupt; Interrupt Flag: P1IFG7; 
                                                            Interrupt Priority: Lowest */
#define P1IV_16_L                        (0x0010)
#define P1IV__NONE                       (0x0000)        /* No interrupt pending */
#define P1IV__P1IFG0                     (0x0002)        /* Interrupt Source: Port 1.0 interrupt; Interrupt Flag: P1IFG0; 
                                                            Interrupt Priority: Highest */
#define P1IV__P1IFG0_L                   (0x0002)
#define P1IV__P1IFG1                     (0x0004)        /* Interrupt Source: Port 1.1 interrupt; Interrupt Flag: P1IFG1 */
#define P1IV__P1IFG1_L                   (0x0004)
#define P1IV__P1IFG2                     (0x0006)        /* Interrupt Source: Port 1.2 interrupt; Interrupt Flag: P1IFG2 */
#define P1IV__P1IFG2_L                   (0x0006)
#define P1IV__P1IFG3                     (0x0008)        /* Interrupt Source: Port 1.3 interrupt; Interrupt Flag: P1IFG3 */
#define P1IV__P1IFG3_L                   (0x0008)
#define P1IV__P1IFG4                     (0x000a)        /* Interrupt Source: Port 1.4 interrupt; Interrupt Flag: P1IFG4 */
#define P1IV__P1IFG4_L                   (0x000a)
#define P1IV__P1IFG5                     (0x000c)        /* Interrupt Source: Port 1.5 interrupt; Interrupt Flag: P1IFG5 */
#define P1IV__P1IFG5_L                   (0x000c)
#define P1IV__P1IFG6                     (0x000e)        /* Interrupt Source: Port 1.6 interrupt; Interrupt Flag: P1IFG6 */
#define P1IV__P1IFG6_L                   (0x000e)
#define P1IV__P1IFG7                     (0x0010)        /* Interrupt Source: Port 1.7 interrupt; Interrupt Flag: P1IFG7; 
                                                            Interrupt Priority: Lowest */
#define P1IV__P1IFG7_L                   (0x0010)

/* P2IV Control Bits */
#define P2IV0                            (0x0001)        /* Port 2 interrupt vector value */
#define P2IV0_L                          (0x0001)
#define P2IV1                            (0x0002)        /* Port 2 interrupt vector value */
#define P2IV1_L                          (0x0002)
#define P2IV2                            (0x0004)        /* Port 2 interrupt vector value */
#define P2IV2_L                          (0x0004)
#define P2IV3                            (0x0008)        /* Port 2 interrupt vector value */
#define P2IV3_L                          (0x0008)
#define P2IV4                            (0x0010)        /* Port 2 interrupt vector value */
#define P2IV4_L                          (0x0010)
#define P2IV_0                           (0x0000)        /* No interrupt pending */
#define P2IV_2                           (0x0002)        /* Interrupt Source: Port 2.0 interrupt; Interrupt Flag: P2IFG0; 
                                                            Interrupt Priority: Highest */
#define P2IV_2_L                         (0x0002)
#define P2IV_4                           (0x0004)        /* Interrupt Source: Port 2.1 interrupt; Interrupt Flag: P2IFG1 */
#define P2IV_4_L                         (0x0004)
#define P2IV_6                           (0x0006)        /* Interrupt Source: Port 2.2 interrupt; Interrupt Flag: P2IFG2 */
#define P2IV_6_L                         (0x0006)
#define P2IV_8                           (0x0008)        /* Interrupt Source: Port 2.3 interrupt; Interrupt Flag: P2IFG3 */
#define P2IV_8_L                         (0x0008)
#define P2IV_10                          (0x000a)        /* Interrupt Source: Port 2.4 interrupt; Interrupt Flag: P2IFG4 */
#define P2IV_10_L                        (0x000a)
#define P2IV_12                          (0x000c)        /* Interrupt Source: Port 2.5 interrupt; Interrupt Flag: P2IFG5 */
#define P2IV_12_L                        (0x000c)
#define P2IV_14                          (0x000e)        /* Interrupt Source: Port 2.6 interrupt; Interrupt Flag: P2IFG6 */
#define P2IV_14_L                        (0x000e)
#define P2IV_16                          (0x0010)        /* Interrupt Source: Port 2.7 interrupt; Interrupt Flag: P2IFG7; 
                                                            Interrupt Priority: Lowest */
#define P2IV_16_L                        (0x0010)
#define P2IV__NONE                       (0x0000)        /* No interrupt pending */
#define P2IV__P2IFG0                     (0x0002)        /* Interrupt Source: Port 2.0 interrupt; Interrupt Flag: P2IFG0; 
                                                            Interrupt Priority: Highest */
#define P2IV__P2IFG0_L                   (0x0002)
#define P2IV__P2IFG1                     (0x0004)        /* Interrupt Source: Port 2.1 interrupt; Interrupt Flag: P2IFG1 */
#define P2IV__P2IFG1_L                   (0x0004)
#define P2IV__P2IFG2                     (0x0006)        /* Interrupt Source: Port 2.2 interrupt; Interrupt Flag: P2IFG2 */
#define P2IV__P2IFG2_L                   (0x0006)
#define P2IV__P2IFG3                     (0x0008)        /* Interrupt Source: Port 2.3 interrupt; Interrupt Flag: P2IFG3 */
#define P2IV__P2IFG3_L                   (0x0008)
#define P2IV__P2IFG4                     (0x000a)        /* Interrupt Source: Port 2.4 interrupt; Interrupt Flag: P2IFG4 */
#define P2IV__P2IFG4_L                   (0x000a)
#define P2IV__P2IFG5                     (0x000c)        /* Interrupt Source: Port 2.5 interrupt; Interrupt Flag: P2IFG5 */
#define P2IV__P2IFG5_L                   (0x000c)
#define P2IV__P2IFG6                     (0x000e)        /* Interrupt Source: Port 2.6 interrupt; Interrupt Flag: P2IFG6 */
#define P2IV__P2IFG6_L                   (0x000e)
#define P2IV__P2IFG7                     (0x0010)        /* Interrupt Source: Port 2.7 interrupt; Interrupt Flag: P2IFG7; 
                                                            Interrupt Priority: Lowest */
#define P2IV__P2IFG7_L                   (0x0010)

/* P3IV Control Bits */
#define P3IV0                            (0x0001)        /* Port 3 interrupt vector value */
#define P3IV0_L                          (0x0001)
#define P3IV1                            (0x0002)        /* Port 3 interrupt vector value */
#define P3IV1_L                          (0x0002)
#define P3IV2                            (0x0004)        /* Port 3 interrupt vector value */
#define P3IV2_L                          (0x0004)
#define P3IV3                            (0x0008)        /* Port 3 interrupt vector value */
#define P3IV3_L                          (0x0008)
#define P3IV4                            (0x0010)        /* Port 3 interrupt vector value */
#define P3IV4_L                          (0x0010)
#define P3IV_0                           (0x0000)        /* No interrupt pending */
#define P3IV_2                           (0x0002)        /* Interrupt Source: Port 3.0 interrupt; Interrupt Flag: P3IFG0; 
                                                            Interrupt Priority: Highest */
#define P3IV_2_L                         (0x0002)
#define P3IV_4                           (0x0004)        /* Interrupt Source: Port 3.1 interrupt; Interrupt Flag: P3IFG1 */
#define P3IV_4_L                         (0x0004)
#define P3IV_6                           (0x0006)        /* Interrupt Source: Port 3.2 interrupt; Interrupt Flag: P3IFG2 */
#define P3IV_6_L                         (0x0006)
#define P3IV_8                           (0x0008)        /* Interrupt Source: Port 3.3 interrupt; Interrupt Flag: P3IFG3 */
#define P3IV_8_L                         (0x0008)
#define P3IV_10                          (0x000a)        /* Interrupt Source: Port 3.4 interrupt; Interrupt Flag: P3IFG4 */
#define P3IV_10_L                        (0x000a)
#define P3IV_12                          (0x000c)        /* Interrupt Source: Port 3.5 interrupt; Interrupt Flag: P3IFG5 */
#define P3IV_12_L                        (0x000c)
#define P3IV_14                          (0x000e)        /* Interrupt Source: Port 3.6 interrupt; Interrupt Flag: P3IFG6 */
#define P3IV_14_L                        (0x000e)
#define P3IV_16                          (0x0010)        /* Interrupt Source: Port 3.7 interrupt; Interrupt Flag: P3IFG7; 
                                                            Interrupt Priority: Lowest */
#define P3IV_16_L                        (0x0010)
#define P3IV__NONE                       (0x0000)        /* No interrupt pending */
#define P3IV__P3IFG0                     (0x0002)        /* Interrupt Source: Port 3.0 interrupt; Interrupt Flag: P3IFG0; 
                                                            Interrupt Priority: Highest */
#define P3IV__P3IFG0_L                   (0x0002)
#define P3IV__P3IFG1                     (0x0004)        /* Interrupt Source: Port 3.1 interrupt; Interrupt Flag: P3IFG1 */
#define P3IV__P3IFG1_L                   (0x0004)
#define P3IV__P3IFG2                     (0x0006)        /* Interrupt Source: Port 3.2 interrupt; Interrupt Flag: P3IFG2 */
#define P3IV__P3IFG2_L                   (0x0006)
#define P3IV__P3IFG3                     (0x0008)        /* Interrupt Source: Port 3.3 interrupt; Interrupt Flag: P3IFG3 */
#define P3IV__P3IFG3_L                   (0x0008)
#define P3IV__P3IFG4                     (0x000a)        /* Interrupt Source: Port 3.4 interrupt; Interrupt Flag: P3IFG4 */
#define P3IV__P3IFG4_L                   (0x000a)
#define P3IV__P3IFG5                     (0x000c)        /* Interrupt Source: Port 3.5 interrupt; Interrupt Flag: P3IFG5 */
#define P3IV__P3IFG5_L                   (0x000c)
#define P3IV__P3IFG6                     (0x000e)        /* Interrupt Source: Port 3.6 interrupt; Interrupt Flag: P3IFG6 */
#define P3IV__P3IFG6_L                   (0x000e)
#define P3IV__P3IFG7                     (0x0010)        /* Interrupt Source: Port 3.7 interrupt; Interrupt Flag: P3IFG7; 
                                                            Interrupt Priority: Lowest */
#define P3IV__P3IFG7_L                   (0x0010)

/* P4IV Control Bits */
#define P4IV0                            (0x0001)        /* Port 4 interrupt vector value */
#define P4IV0_L                          (0x0001)
#define P4IV1                            (0x0002)        /* Port 4 interrupt vector value */
#define P4IV1_L                          (0x0002)
#define P4IV2                            (0x0004)        /* Port 4 interrupt vector value */
#define P4IV2_L                          (0x0004)
#define P4IV3                            (0x0008)        /* Port 4 interrupt vector value */
#define P4IV3_L                          (0x0008)
#define P4IV4                            (0x0010)        /* Port 4 interrupt vector value */
#define P4IV4_L                          (0x0010)
#define P4IV_0                           (0x0000)        /* No interrupt pending */
#define P4IV_2                           (0x0002)        /* Interrupt Source: Port 4.0 interrupt; Interrupt Flag: P4IFG0; 
                                                            Interrupt Priority: Highest */
#define P4IV_2_L                         (0x0002)
#define P4IV_4                           (0x0004)        /* Interrupt Source: Port 4.1 interrupt; Interrupt Flag: P4IFG1 */
#define P4IV_4_L                         (0x0004)
#define P4IV_6                           (0x0006)        /* Interrupt Source: Port 4.2 interrupt; Interrupt Flag: P4IFG2 */
#define P4IV_6_L                         (0x0006)
#define P4IV_8                           (0x0008)        /* Interrupt Source: Port 4.3 interrupt; Interrupt Flag: P4IFG3 */
#define P4IV_8_L                         (0x0008)
#define P4IV_10                          (0x000a)        /* Interrupt Source: Port 4.4 interrupt; Interrupt Flag: P4IFG4 */
#define P4IV_10_L                        (0x000a)
#define P4IV_12                          (0x000c)        /* Interrupt Source: Port 4.5 interrupt; Interrupt Flag: P4IFG5 */
#define P4IV_12_L                        (0x000c)
#define P4IV_14                          (0x000e)        /* Interrupt Source: Port 4.6 interrupt; Interrupt Flag: P4IFG6 */
#define P4IV_14_L                        (0x000e)
#define P4IV_16                          (0x0010)        /* Interrupt Source: Port 4.7 interrupt; Interrupt Flag: P4IFG7; 
                                                            Interrupt Priority: Lowest */
#define P4IV_16_L                        (0x0010)
#define P4IV__NONE                       (0x0000)        /* No interrupt pending */
#define P4IV__P4IFG0                     (0x0002)        /* Interrupt Source: Port 4.0 interrupt; Interrupt Flag: P4IFG0; 
                                                            Interrupt Priority: Highest */
#define P4IV__P4IFG0_L                   (0x0002)
#define P4IV__P4IFG1                     (0x0004)        /* Interrupt Source: Port 4.1 interrupt; Interrupt Flag: P4IFG1 */
#define P4IV__P4IFG1_L                   (0x0004)
#define P4IV__P4IFG2                     (0x0006)        /* Interrupt Source: Port 4.2 interrupt; Interrupt Flag: P4IFG2 */
#define P4IV__P4IFG2_L                   (0x0006)
#define P4IV__P4IFG3                     (0x0008)        /* Interrupt Source: Port 4.3 interrupt; Interrupt Flag: P4IFG3 */
#define P4IV__P4IFG3_L                   (0x0008)
#define P4IV__P4IFG4                     (0x000a)        /* Interrupt Source: Port 4.4 interrupt; Interrupt Flag: P4IFG4 */
#define P4IV__P4IFG4_L                   (0x000a)
#define P4IV__P4IFG5                     (0x000c)        /* Interrupt Source: Port 4.5 interrupt; Interrupt Flag: P4IFG5 */
#define P4IV__P4IFG5_L                   (0x000c)
#define P4IV__P4IFG6                     (0x000e)        /* Interrupt Source: Port 4.6 interrupt; Interrupt Flag: P4IFG6 */
#define P4IV__P4IFG6_L                   (0x000e)
#define P4IV__P4IFG7                     (0x0010)        /* Interrupt Source: Port 4.7 interrupt; Interrupt Flag: P4IFG7; 
                                                            Interrupt Priority: Lowest */
#define P4IV__P4IFG7_L                   (0x0010)

/* P5IV Control Bits */
#define P5IV0                            (0x0001)        /* Port 5 interrupt vector value */
#define P5IV0_L                          (0x0001)
#define P5IV1                            (0x0002)        /* Port 5 interrupt vector value */
#define P5IV1_L                          (0x0002)
#define P5IV2                            (0x0004)        /* Port 5 interrupt vector value */
#define P5IV2_L                          (0x0004)
#define P5IV3                            (0x0008)        /* Port 5 interrupt vector value */
#define P5IV3_L                          (0x0008)
#define P5IV4                            (0x0010)        /* Port 5 interrupt vector value */
#define P5IV4_L                          (0x0010)
#define P5IV_0                           (0x0000)        /* No interrupt pending */
#define P5IV_2                           (0x0002)        /* Interrupt Source: Port 5.0 interrupt; Interrupt Flag: P5IFG0; 
                                                            Interrupt Priority: Highest */
#define P5IV_2_L                         (0x0002)
#define P5IV_4                           (0x0004)        /* Interrupt Source: Port 5.1 interrupt; Interrupt Flag: P5IFG1 */
#define P5IV_4_L                         (0x0004)
#define P5IV_6                           (0x0006)        /* Interrupt Source: Port 5.2 interrupt; Interrupt Flag: P5IFG2 */
#define P5IV_6_L                         (0x0006)
#define P5IV_8                           (0x0008)        /* Interrupt Source: Port 5.3 interrupt; Interrupt Flag: P5IFG3 */
#define P5IV_8_L                         (0x0008)
#define P5IV_10                          (0x000a)        /* Interrupt Source: Port 5.4 interrupt; Interrupt Flag: P5IFG4 */
#define P5IV_10_L                        (0x000a)
#define P5IV_12                          (0x000c)        /* Interrupt Source: Port 5.5 interrupt; Interrupt Flag: P5IFG5 */
#define P5IV_12_L                        (0x000c)
#define P5IV_14                          (0x000e)        /* Interrupt Source: Port 5.6 interrupt; Interrupt Flag: P5IFG6 */
#define P5IV_14_L                        (0x000e)
#define P5IV_16                          (0x0010)        /* Interrupt Source: Port 5.7 interrupt; Interrupt Flag: P5IFG7; 
                                                            Interrupt Priority: Lowest */
#define P5IV_16_L                        (0x0010)
#define P5IV__NONE                       (0x0000)        /* No interrupt pending */
#define P5IV__P5IFG0                     (0x0002)        /* Interrupt Source: Port 5.0 interrupt; Interrupt Flag: P5IFG0; 
                                                            Interrupt Priority: Highest */
#define P5IV__P5IFG0_L                   (0x0002)
#define P5IV__P5IFG1                     (0x0004)        /* Interrupt Source: Port 5.1 interrupt; Interrupt Flag: P5IFG1 */
#define P5IV__P5IFG1_L                   (0x0004)
#define P5IV__P5IFG2                     (0x0006)        /* Interrupt Source: Port 5.2 interrupt; Interrupt Flag: P5IFG2 */
#define P5IV__P5IFG2_L                   (0x0006)
#define P5IV__P5IFG3                     (0x0008)        /* Interrupt Source: Port 5.3 interrupt; Interrupt Flag: P5IFG3 */
#define P5IV__P5IFG3_L                   (0x0008)
#define P5IV__P5IFG4                     (0x000a)        /* Interrupt Source: Port 5.4 interrupt; Interrupt Flag: P5IFG4 */
#define P5IV__P5IFG4_L                   (0x000a)
#define P5IV__P5IFG5                     (0x000c)        /* Interrupt Source: Port 5.5 interrupt; Interrupt Flag: P5IFG5 */
#define P5IV__P5IFG5_L                   (0x000c)
#define P5IV__P5IFG6                     (0x000e)        /* Interrupt Source: Port 5.6 interrupt; Interrupt Flag: P5IFG6 */
#define P5IV__P5IFG6_L                   (0x000e)
#define P5IV__P5IFG7                     (0x0010)        /* Interrupt Source: Port 5.7 interrupt; Interrupt Flag: P5IFG7; 
                                                            Interrupt Priority: Lowest */
#define P5IV__P5IFG7_L                   (0x0010)

/* P6IV Control Bits */
#define P6IV0                            (0x0001)        /* Port 6 interrupt vector value */
#define P6IV0_L                          (0x0001)
#define P6IV1                            (0x0002)        /* Port 6 interrupt vector value */
#define P6IV1_L                          (0x0002)
#define P6IV2                            (0x0004)        /* Port 6 interrupt vector value */
#define P6IV2_L                          (0x0004)
#define P6IV3                            (0x0008)        /* Port 6 interrupt vector value */
#define P6IV3_L                          (0x0008)
#define P6IV4                            (0x0010)        /* Port 6 interrupt vector value */
#define P6IV4_L                          (0x0010)
#define P6IV_0                           (0x0000)        /* No interrupt pending */
#define P6IV_2                           (0x0002)        /* Interrupt Source: Port 6.0 interrupt; Interrupt Flag: P6IFG0; 
                                                            Interrupt Priority: Highest */
#define P6IV_2_L                         (0x0002)
#define P6IV_4                           (0x0004)        /* Interrupt Source: Port 6.1 interrupt; Interrupt Flag: P6IFG1 */
#define P6IV_4_L                         (0x0004)
#define P6IV_6                           (0x0006)        /* Interrupt Source: Port 6.2 interrupt; Interrupt Flag: P6IFG2 */
#define P6IV_6_L                         (0x0006)
#define P6IV_8                           (0x0008)        /* Interrupt Source: Port 6.3 interrupt; Interrupt Flag: P6IFG3 */
#define P6IV_8_L                         (0x0008)
#define P6IV_10                          (0x000a)        /* Interrupt Source: Port 6.4 interrupt; Interrupt Flag: P6IFG4 */
#define P6IV_10_L                        (0x000a)
#define P6IV_12                          (0x000c)        /* Interrupt Source: Port 6.5 interrupt; Interrupt Flag: P6IFG5 */
#define P6IV_12_L                        (0x000c)
#define P6IV_14                          (0x000e)        /* Interrupt Source: Port 6.6 interrupt; Interrupt Flag: P6IFG6 */
#define P6IV_14_L                        (0x000e)
#define P6IV_16                          (0x0010)        /* Interrupt Source: Port 6.7 interrupt; Interrupt Flag: P6IFG7; 
                                                            Interrupt Priority: Lowest */
#define P6IV_16_L                        (0x0010)
#define P6IV__NONE                       (0x0000)        /* No interrupt pending */
#define P6IV__P6IFG0                     (0x0002)        /* Interrupt Source: Port 6.0 interrupt; Interrupt Flag: P6IFG0; 
                                                            Interrupt Priority: Highest */
#define P6IV__P6IFG0_L                   (0x0002)
#define P6IV__P6IFG1                     (0x0004)        /* Interrupt Source: Port 6.1 interrupt; Interrupt Flag: P6IFG1 */
#define P6IV__P6IFG1_L                   (0x0004)
#define P6IV__P6IFG2                     (0x0006)        /* Interrupt Source: Port 6.2 interrupt; Interrupt Flag: P6IFG2 */
#define P6IV__P6IFG2_L                   (0x0006)
#define P6IV__P6IFG3                     (0x0008)        /* Interrupt Source: Port 6.3 interrupt; Interrupt Flag: P6IFG3 */
#define P6IV__P6IFG3_L                   (0x0008)
#define P6IV__P6IFG4                     (0x000a)        /* Interrupt Source: Port 6.4 interrupt; Interrupt Flag: P6IFG4 */
#define P6IV__P6IFG4_L                   (0x000a)
#define P6IV__P6IFG5                     (0x000c)        /* Interrupt Source: Port 6.5 interrupt; Interrupt Flag: P6IFG5 */
#define P6IV__P6IFG5_L                   (0x000c)
#define P6IV__P6IFG6                     (0x000e)        /* Interrupt Source: Port 6.6 interrupt; Interrupt Flag: P6IFG6 */
#define P6IV__P6IFG6_L                   (0x000e)
#define P6IV__P6IFG7                     (0x0010)        /* Interrupt Source: Port 6.7 interrupt; Interrupt Flag: P6IFG7; 
                                                            Interrupt Priority: Lowest */
#define P6IV__P6IFG7_L                   (0x0010)

/* P7IV Control Bits */
#define P7IV0                            (0x0001)        /* Port 7 interrupt vector value */
#define P7IV0_L                          (0x0001)
#define P7IV1                            (0x0002)        /* Port 7 interrupt vector value */
#define P7IV1_L                          (0x0002)
#define P7IV2                            (0x0004)        /* Port 7 interrupt vector value */
#define P7IV2_L                          (0x0004)
#define P7IV3                            (0x0008)        /* Port 7 interrupt vector value */
#define P7IV3_L                          (0x0008)
#define P7IV4                            (0x0010)        /* Port 7 interrupt vector value */
#define P7IV4_L                          (0x0010)
#define P7IV_0                           (0x0000)        /* No interrupt pending */
#define P7IV_2                           (0x0002)        /* Interrupt Source: Port 7.0 interrupt; Interrupt Flag: P7IFG0; 
                                                            Interrupt Priority: Highest */
#define P7IV_2_L                         (0x0002)
#define P7IV_4                           (0x0004)        /* Interrupt Source: Port 7.1 interrupt; Interrupt Flag: P7IFG1 */
#define P7IV_4_L                         (0x0004)
#define P7IV_6                           (0x0006)        /* Interrupt Source: Port 7.2 interrupt; Interrupt Flag: P7IFG2 */
#define P7IV_6_L                         (0x0006)
#define P7IV_8                           (0x0008)        /* Interrupt Source: Port 7.3 interrupt; Interrupt Flag: P7IFG3 */
#define P7IV_8_L                         (0x0008)
#define P7IV_10                          (0x000a)        /* Interrupt Source: Port 7.4 interrupt; Interrupt Flag: P7IFG4 */
#define P7IV_10_L                        (0x000a)
#define P7IV_12                          (0x000c)        /* Interrupt Source: Port 7.5 interrupt; Interrupt Flag: P7IFG5 */
#define P7IV_12_L                        (0x000c)
#define P7IV_14                          (0x000e)        /* Interrupt Source: Port 7.6 interrupt; Interrupt Flag: P7IFG6 */
#define P7IV_14_L                        (0x000e)
#define P7IV_16                          (0x0010)        /* Interrupt Source: Port 7.7 interrupt; Interrupt Flag: P7IFG7; 
                                                            Interrupt Priority: Lowest */
#define P7IV_16_L                        (0x0010)
#define P7IV__NONE                       (0x0000)        /* No interrupt pending */
#define P7IV__P7IFG0                     (0x0002)        /* Interrupt Source: Port 7.0 interrupt; Interrupt Flag: P7IFG0; 
                                                            Interrupt Priority: Highest */
#define P7IV__P7IFG0_L                   (0x0002)
#define P7IV__P7IFG1                     (0x0004)        /* Interrupt Source: Port 7.1 interrupt; Interrupt Flag: P7IFG1 */
#define P7IV__P7IFG1_L                   (0x0004)
#define P7IV__P7IFG2                     (0x0006)        /* Interrupt Source: Port 7.2 interrupt; Interrupt Flag: P7IFG2 */
#define P7IV__P7IFG2_L                   (0x0006)
#define P7IV__P7IFG3                     (0x0008)        /* Interrupt Source: Port 7.3 interrupt; Interrupt Flag: P7IFG3 */
#define P7IV__P7IFG3_L                   (0x0008)
#define P7IV__P7IFG4                     (0x000a)        /* Interrupt Source: Port 7.4 interrupt; Interrupt Flag: P7IFG4 */
#define P7IV__P7IFG4_L                   (0x000a)
#define P7IV__P7IFG5                     (0x000c)        /* Interrupt Source: Port 7.5 interrupt; Interrupt Flag: P7IFG5 */
#define P7IV__P7IFG5_L                   (0x000c)
#define P7IV__P7IFG6                     (0x000e)        /* Interrupt Source: Port 7.6 interrupt; Interrupt Flag: P7IFG6 */
#define P7IV__P7IFG6_L                   (0x000e)
#define P7IV__P7IFG7                     (0x0010)        /* Interrupt Source: Port 7.7 interrupt; Interrupt Flag: P7IFG7; 
                                                            Interrupt Priority: Lowest */
#define P7IV__P7IFG7_L                   (0x0010)

/* P8IV Control Bits */
#define P8IV0                            (0x0001)        /* Port 8 interrupt vector value */
#define P8IV0_L                          (0x0001)
#define P8IV1                            (0x0002)        /* Port 8 interrupt vector value */
#define P8IV1_L                          (0x0002)
#define P8IV2                            (0x0004)        /* Port 8 interrupt vector value */
#define P8IV2_L                          (0x0004)
#define P8IV3                            (0x0008)        /* Port 8 interrupt vector value */
#define P8IV3_L                          (0x0008)
#define P8IV4                            (0x0010)        /* Port 8 interrupt vector value */
#define P8IV4_L                          (0x0010)
#define P8IV_0                           (0x0000)        /* No interrupt pending */
#define P8IV_2                           (0x0002)        /* Interrupt Source: Port 8.0 interrupt; Interrupt Flag: P8IFG0; 
                                                            Interrupt Priority: Highest */
#define P8IV_2_L                         (0x0002)
#define P8IV_4                           (0x0004)        /* Interrupt Source: Port 8.1 interrupt; Interrupt Flag: P8IFG1 */
#define P8IV_4_L                         (0x0004)
#define P8IV_6                           (0x0006)        /* Interrupt Source: Port 8.2 interrupt; Interrupt Flag: P8IFG2 */
#define P8IV_6_L                         (0x0006)
#define P8IV_8                           (0x0008)        /* Interrupt Source: Port 8.3 interrupt; Interrupt Flag: P8IFG3 */
#define P8IV_8_L                         (0x0008)
#define P8IV_10                          (0x000a)        /* Interrupt Source: Port 8.4 interrupt; Interrupt Flag: P8IFG4 */
#define P8IV_10_L                        (0x000a)
#define P8IV_12                          (0x000c)        /* Interrupt Source: Port 8.5 interrupt; Interrupt Flag: P8IFG5 */
#define P8IV_12_L                        (0x000c)
#define P8IV_14                          (0x000e)        /* Interrupt Source: Port 8.6 interrupt; Interrupt Flag: P8IFG6 */
#define P8IV_14_L                        (0x000e)
#define P8IV_16                          (0x0010)        /* Interrupt Source: Port 8.7 interrupt; Interrupt Flag: P8IFG7; 
                                                            Interrupt Priority: Lowest */
#define P8IV_16_L                        (0x0010)
#define P8IV__NONE                       (0x0000)        /* No interrupt pending */
#define P8IV__P8IFG0                     (0x0002)        /* Interrupt Source: Port 8.0 interrupt; Interrupt Flag: P8IFG0; 
                                                            Interrupt Priority: Highest */
#define P8IV__P8IFG0_L                   (0x0002)
#define P8IV__P8IFG1                     (0x0004)        /* Interrupt Source: Port 8.1 interrupt; Interrupt Flag: P8IFG1 */
#define P8IV__P8IFG1_L                   (0x0004)
#define P8IV__P8IFG2                     (0x0006)        /* Interrupt Source: Port 8.2 interrupt; Interrupt Flag: P8IFG2 */
#define P8IV__P8IFG2_L                   (0x0006)
#define P8IV__P8IFG3                     (0x0008)        /* Interrupt Source: Port 8.3 interrupt; Interrupt Flag: P8IFG3 */
#define P8IV__P8IFG3_L                   (0x0008)
#define P8IV__P8IFG4                     (0x000a)        /* Interrupt Source: Port 8.4 interrupt; Interrupt Flag: P8IFG4 */
#define P8IV__P8IFG4_L                   (0x000a)
#define P8IV__P8IFG5                     (0x000c)        /* Interrupt Source: Port 8.5 interrupt; Interrupt Flag: P8IFG5 */
#define P8IV__P8IFG5_L                   (0x000c)
#define P8IV__P8IFG6                     (0x000e)        /* Interrupt Source: Port 8.6 interrupt; Interrupt Flag: P8IFG6 */
#define P8IV__P8IFG6_L                   (0x000e)
#define P8IV__P8IFG7                     (0x0010)        /* Interrupt Source: Port 8.7 interrupt; Interrupt Flag: P8IFG7; 
                                                            Interrupt Priority: Lowest */
#define P8IV__P8IFG7_L                   (0x0010)

/* P9IV Control Bits */
#define P9IV0                            (0x0001)        /* Port 9 interrupt vector value */
#define P9IV0_L                          (0x0001)
#define P9IV1                            (0x0002)        /* Port 9 interrupt vector value */
#define P9IV1_L                          (0x0002)
#define P9IV2                            (0x0004)        /* Port 9 interrupt vector value */
#define P9IV2_L                          (0x0004)
#define P9IV3                            (0x0008)        /* Port 9 interrupt vector value */
#define P9IV3_L                          (0x0008)
#define P9IV4                            (0x0010)        /* Port 9 interrupt vector value */
#define P9IV4_L                          (0x0010)
#define P9IV_0                           (0x0000)        /* No interrupt pending */
#define P9IV_2                           (0x0002)        /* Interrupt Source: Port 9.0 interrupt; Interrupt Flag: P9IFG0; 
                                                            Interrupt Priority: Highest */
#define P9IV_2_L                         (0x0002)
#define P9IV_4                           (0x0004)        /* Interrupt Source: Port 9.1 interrupt; Interrupt Flag: P9IFG1 */
#define P9IV_4_L                         (0x0004)
#define P9IV_6                           (0x0006)        /* Interrupt Source: Port 9.2 interrupt; Interrupt Flag: P9IFG2 */
#define P9IV_6_L                         (0x0006)
#define P9IV_8                           (0x0008)        /* Interrupt Source: Port 9.3 interrupt; Interrupt Flag: P9IFG3 */
#define P9IV_8_L                         (0x0008)
#define P9IV_10                          (0x000a)        /* Interrupt Source: Port 9.4 interrupt; Interrupt Flag: P9IFG4 */
#define P9IV_10_L                        (0x000a)
#define P9IV_12                          (0x000c)        /* Interrupt Source: Port 9.5 interrupt; Interrupt Flag: P9IFG5 */
#define P9IV_12_L                        (0x000c)
#define P9IV_14                          (0x000e)        /* Interrupt Source: Port 9.6 interrupt; Interrupt Flag: P9IFG6 */
#define P9IV_14_L                        (0x000e)
#define P9IV_16                          (0x0010)        /* Interrupt Source: Port 9.7 interrupt; Interrupt Flag: P9IFG7; 
                                                            Interrupt Priority: Lowest */
#define P9IV_16_L                        (0x0010)
#define P9IV__NONE                       (0x0000)        /* No interrupt pending */
#define P9IV__P9IFG0                     (0x0002)        /* Interrupt Source: Port 9.0 interrupt; Interrupt Flag: P9IFG0; 
                                                            Interrupt Priority: Highest */
#define P9IV__P9IFG0_L                   (0x0002)
#define P9IV__P9IFG1                     (0x0004)        /* Interrupt Source: Port 9.1 interrupt; Interrupt Flag: P9IFG1 */
#define P9IV__P9IFG1_L                   (0x0004)
#define P9IV__P9IFG2                     (0x0006)        /* Interrupt Source: Port 9.2 interrupt; Interrupt Flag: P9IFG2 */
#define P9IV__P9IFG2_L                   (0x0006)
#define P9IV__P9IFG3                     (0x0008)        /* Interrupt Source: Port 9.3 interrupt; Interrupt Flag: P9IFG3 */
#define P9IV__P9IFG3_L                   (0x0008)
#define P9IV__P9IFG4                     (0x000a)        /* Interrupt Source: Port 9.4 interrupt; Interrupt Flag: P9IFG4 */
#define P9IV__P9IFG4_L                   (0x000a)
#define P9IV__P9IFG5                     (0x000c)        /* Interrupt Source: Port 9.5 interrupt; Interrupt Flag: P9IFG5 */
#define P9IV__P9IFG5_L                   (0x000c)
#define P9IV__P9IFG6                     (0x000e)        /* Interrupt Source: Port 9.6 interrupt; Interrupt Flag: P9IFG6 */
#define P9IV__P9IFG6_L                   (0x000e)
#define P9IV__P9IFG7                     (0x0010)        /* Interrupt Source: Port 9.7 interrupt; Interrupt Flag: P9IFG7; 
                                                            Interrupt Priority: Lowest */
#define P9IV__P9IFG7_L                   (0x0010)


/*****************************************************************************
 DMA Registers
*****************************************************************************/

#define __MSP430_HAS_DMA__ 6                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_DMA__ 0x0500
#define DMA_BASE               __MSP430_BASEADDRESS_DMA__

sfr_w(DMACTL0);                               /* DMA Control 0 */

sfr_w(DMACTL1);                               /* DMA Control 1 */

sfr_w(DMACTL2);                               /* DMA Control 2 */

sfr_w(DMACTL4);                               /* DMA Control 4 */

sfr_w(DMAIV);                                 /* DMA Interrupt Vector */

sfr_w(DMA0CTL);                               /* DMA Channel 0 Control */

sfr_a(DMA0SA);                                /* DMA Channel 0 Source Address */

sfr_a(DMA0DA);                                /* DMA Channel 0 Destination Address */

sfr_w(DMA0SZ);                                /* DMA Channel 0 Transfer Size */

sfr_w(DMA1CTL);                               /* DMA Channel 1 Control */

sfr_a(DMA1SA);                                /* DMA Channel 1 Source Address */

sfr_a(DMA1DA);                                /* DMA Channel 1 Destination Address */

sfr_w(DMA1SZ);                                /* DMA Channel 1 Transfer Size */

sfr_w(DMA2CTL);                               /* DMA Channel 2 Control */

sfr_a(DMA2SA);                                /* DMA Channel 2 Source Address */

sfr_a(DMA2DA);                                /* DMA Channel 2 Destination Address */

sfr_w(DMA2SZ);                                /* DMA Channel 2 Transfer Size */

sfr_w(DMA3CTL);                               /* DMA Channel 3 Control */

sfr_a(DMA3SA);                                /* DMA Channel 3 Source Address */

sfr_a(DMA3DA);                                /* DMA Channel 3 Destination Address */

sfr_w(DMA3SZ);                                /* DMA Channel 3 Transfer Size */

sfr_w(DMA4CTL);                               /* DMA Channel 4 Control */

sfr_a(DMA4SA);                                /* DMA Channel 4 Source Address */

sfr_a(DMA4DA);                                /* DMA Channel 4 Destination Address */

sfr_w(DMA4SZ);                                /* DMA Channel 4 Transfer Size */

sfr_w(DMA5CTL);                               /* DMA Channel 5 Control */

sfr_a(DMA5SA);                                /* DMA Channel 5 Source Address */

sfr_a(DMA5DA);                                /* DMA Channel 5 Destination Address */

sfr_w(DMA5SZ);                                /* DMA Channel 5 Transfer Size */


/* DMA Register Offsets */
#define OFS_DMACTL0                      (0x0000)
#define OFS_DMACTL1                      (0x0002)
#define OFS_DMACTL2                      (0x0004)
#define OFS_DMACTL4                      (0x0008)
#define OFS_DMAIV                        (0x000E)
#define OFS_DMA0CTL                      (0x0010)
#define OFS_DMA0SA                       (0x0012)
#define OFS_DMA0SA_L                     OFS_DMA0SA
#define OFS_DMA0SA_H                     OFS_DMA0SA+2
#define OFS_DMA0DA                       (0x0016)
#define OFS_DMA0DA_L                     OFS_DMA0DA
#define OFS_DMA0DA_H                     OFS_DMA0DA+2
#define OFS_DMA0SZ                       (0x001A)
#define OFS_DMA1CTL                      (0x0020)
#define OFS_DMA1SA                       (0x0022)
#define OFS_DMA1SA_L                     OFS_DMA1SA
#define OFS_DMA1SA_H                     OFS_DMA1SA+2
#define OFS_DMA1DA                       (0x0026)
#define OFS_DMA1DA_L                     OFS_DMA1DA
#define OFS_DMA1DA_H                     OFS_DMA1DA+2
#define OFS_DMA1SZ                       (0x002A)
#define OFS_DMA2CTL                      (0x0030)
#define OFS_DMA2SA                       (0x0032)
#define OFS_DMA2SA_L                     OFS_DMA2SA
#define OFS_DMA2SA_H                     OFS_DMA2SA+2
#define OFS_DMA2DA                       (0x0036)
#define OFS_DMA2DA_L                     OFS_DMA2DA
#define OFS_DMA2DA_H                     OFS_DMA2DA+2
#define OFS_DMA2SZ                       (0x003A)
#define OFS_DMA3CTL                      (0x0040)
#define OFS_DMA3SA                       (0x0042)
#define OFS_DMA3SA_L                     OFS_DMA3SA
#define OFS_DMA3SA_H                     OFS_DMA3SA+2
#define OFS_DMA3DA                       (0x0046)
#define OFS_DMA3DA_L                     OFS_DMA3DA
#define OFS_DMA3DA_H                     OFS_DMA3DA+2
#define OFS_DMA3SZ                       (0x004A)
#define OFS_DMA4CTL                      (0x0050)
#define OFS_DMA4SA                       (0x0052)
#define OFS_DMA4SA_L                     OFS_DMA4SA
#define OFS_DMA4SA_H                     OFS_DMA4SA+2
#define OFS_DMA4DA                       (0x0056)
#define OFS_DMA4DA_L                     OFS_DMA4DA
#define OFS_DMA4DA_H                     OFS_DMA4DA+2
#define OFS_DMA4SZ                       (0x005A)
#define OFS_DMA5CTL                      (0x0060)
#define OFS_DMA5SA                       (0x0062)
#define OFS_DMA5SA_L                     OFS_DMA5SA
#define OFS_DMA5SA_H                     OFS_DMA5SA+2
#define OFS_DMA5DA                       (0x0066)
#define OFS_DMA5DA_L                     OFS_DMA5DA
#define OFS_DMA5DA_H                     OFS_DMA5DA+2
#define OFS_DMA5SZ                       (0x006A)

/* DMA Control Bits */

/* DMACTL0 Control Bits */
#define DMA0TSEL                         (0x001f)        /* DMA trigger select */
#define DMA0TSEL0                        (0x0001)        /* DMA trigger select */
#define DMA0TSEL1                        (0x0002)        /* DMA trigger select */
#define DMA0TSEL2                        (0x0004)        /* DMA trigger select */
#define DMA0TSEL3                        (0x0008)        /* DMA trigger select */
#define DMA0TSEL4                        (0x0010)        /* DMA trigger select */
#define DMA0TSEL_0                       (0x0000)        /* DMA0TRIG0 */
#define DMA0TSEL_1                       (0x0001)        /* DMA0TRIG1 */
#define DMA0TSEL_2                       (0x0002)        /* DMA0TRIG2 */
#define DMA0TSEL_3                       (0x0003)        /* DMA0TRIG3 */
#define DMA0TSEL_4                       (0x0004)        /* DMA0TRIG4 */
#define DMA0TSEL_5                       (0x0005)        /* DMA0TRIG5 */
#define DMA0TSEL_6                       (0x0006)        /* DMA0TRIG6 */
#define DMA0TSEL_7                       (0x0007)        /* DMA0TRIG7 */
#define DMA0TSEL_8                       (0x0008)        /* DMA0TRIG8 */
#define DMA0TSEL_9                       (0x0009)        /* DMA0TRIG9 */
#define DMA0TSEL_10                      (0x000a)        /* DMA0TRIG10 */
#define DMA0TSEL_11                      (0x000b)        /* DMA0TRIG11 */
#define DMA0TSEL_12                      (0x000c)        /* DMA0TRIG12 */
#define DMA0TSEL_13                      (0x000d)        /* DMA0TRIG13 */
#define DMA0TSEL_14                      (0x000e)        /* DMA0TRIG14 */
#define DMA0TSEL_15                      (0x000f)        /* DMA0TRIG15 */
#define DMA0TSEL_16                      (0x0010)        /* DMA0TRIG16 */
#define DMA0TSEL_17                      (0x0011)        /* DMA0TRIG17 */
#define DMA0TSEL_18                      (0x0012)        /* DMA0TRIG18 */
#define DMA0TSEL_19                      (0x0013)        /* DMA0TRIG19 */
#define DMA0TSEL_20                      (0x0014)        /* DMA0TRIG20 */
#define DMA0TSEL_21                      (0x0015)        /* DMA0TRIG21 */
#define DMA0TSEL_22                      (0x0016)        /* DMA0TRIG22 */
#define DMA0TSEL_23                      (0x0017)        /* DMA0TRIG23 */
#define DMA0TSEL_24                      (0x0018)        /* DMA0TRIG24 */
#define DMA0TSEL_25                      (0x0019)        /* DMA0TRIG25 */
#define DMA0TSEL_26                      (0x001a)        /* DMA0TRIG26 */
#define DMA0TSEL_27                      (0x001b)        /* DMA0TRIG27 */
#define DMA0TSEL_28                      (0x001c)        /* DMA0TRIG28 */
#define DMA0TSEL_29                      (0x001d)        /* DMA0TRIG29 */
#define DMA0TSEL_30                      (0x001e)        /* DMA0TRIG30 */
#define DMA0TSEL_31                      (0x001f)        /* DMA0TRIG31 */
#define DMA0TSEL__DMAREQ                 DMA0TSEL_0
#define DMA0TSEL__TA0CCR0                DMA0TSEL_1
#define DMA0TSEL__TA0CCR2                DMA0TSEL_2
#define DMA0TSEL__TA1CCR0                DMA0TSEL_3
#define DMA0TSEL__TA1CCR2                DMA0TSEL_4
#define DMA0TSEL__TA2CCR0                DMA0TSEL_5
#define DMA0TSEL__TA3CCR0                DMA0TSEL_6
#define DMA0TSEL__TB0CCR0                DMA0TSEL_7
#define DMA0TSEL__TB0CCR2                DMA0TSEL_8
#define DMA0TSEL__TA4CCR0                DMA0TSEL_9
#define DMA0TSEL__AES_Trigger_0          DMA0TSEL_11
#define DMA0TSEL__AES_Trigger_1          DMA0TSEL_12
#define DMA0TSEL__AES_Trigger_2          DMA0TSEL_13
#define DMA0TSEL__UCA0RXIFG              DMA0TSEL_14
#define DMA0TSEL__UCA0TXIFG              DMA0TSEL_15
#define DMA0TSEL__UCA1RXIFG              DMA0TSEL_16
#define DMA0TSEL__UCA1TXIFG              DMA0TSEL_17
#define DMA0TSEL__UCB0RXIFG              DMA0TSEL_18
#define DMA0TSEL__UCB0RXIFG0             DMA0TSEL_18
#define DMA0TSEL__UCB0TXIFG              DMA0TSEL_19
#define DMA0TSEL__UCB0TXIFG0             DMA0TSEL_19
#define DMA0TSEL__UCB0RXIFG1             DMA0TSEL_20
#define DMA0TSEL__UCB0TXIFG1             DMA0TSEL_21
#define DMA0TSEL__UCB0RXIFG2             DMA0TSEL_22
#define DMA0TSEL__UCB0TXIFG2             DMA0TSEL_23
#define DMA0TSEL__UCB0RXIFG3             DMA0TSEL_24
#define DMA0TSEL__UCB0TXIFG3             DMA0TSEL_25
#define DMA0TSEL__ADC12IFG               DMA0TSEL_26
#define DMA0TSEL__LEA                    DMA0TSEL_27
#define DMA0TSEL__MPY                    DMA0TSEL_29
#define DMA0TSEL__DMA2IFG                DMA0TSEL_30
#define DMA0TSEL__DMAE0                  DMA0TSEL_31
#define DMA0TSEL__DMA0TRIG0              (0x0000)        /* DMA0TRIG0 */
#define DMA0TSEL__DMA0TRIG1              (0x0001)        /* DMA0TRIG1 */
#define DMA0TSEL__DMA0TRIG2              (0x0002)        /* DMA0TRIG2 */
#define DMA0TSEL__DMA0TRIG3              (0x0003)        /* DMA0TRIG3 */
#define DMA0TSEL__DMA0TRIG4              (0x0004)        /* DMA0TRIG4 */
#define DMA0TSEL__DMA0TRIG5              (0x0005)        /* DMA0TRIG5 */
#define DMA0TSEL__DMA0TRIG6              (0x0006)        /* DMA0TRIG6 */
#define DMA0TSEL__DMA0TRIG7              (0x0007)        /* DMA0TRIG7 */
#define DMA0TSEL__DMA0TRIG8              (0x0008)        /* DMA0TRIG8 */
#define DMA0TSEL__DMA0TRIG9              (0x0009)        /* DMA0TRIG9 */
#define DMA0TSEL__DMA0TRIG10             (0x000a)        /* DMA0TRIG10 */
#define DMA0TSEL__DMA0TRIG11             (0x000b)        /* DMA0TRIG11 */
#define DMA0TSEL__DMA0TRIG12             (0x000c)        /* DMA0TRIG12 */
#define DMA0TSEL__DMA0TRIG13             (0x000d)        /* DMA0TRIG13 */
#define DMA0TSEL__DMA0TRIG14             (0x000e)        /* DMA0TRIG14 */
#define DMA0TSEL__DMA0TRIG15             (0x000f)        /* DMA0TRIG15 */
#define DMA0TSEL__DMA0TRIG16             (0x0010)        /* DMA0TRIG16 */
#define DMA0TSEL__DMA0TRIG17             (0x0011)        /* DMA0TRIG17 */
#define DMA0TSEL__DMA0TRIG18             (0x0012)        /* DMA0TRIG18 */
#define DMA0TSEL__DMA0TRIG19             (0x0013)        /* DMA0TRIG19 */
#define DMA0TSEL__DMA0TRIG20             (0x0014)        /* DMA0TRIG20 */
#define DMA0TSEL__DMA0TRIG21             (0x0015)        /* DMA0TRIG21 */
#define DMA0TSEL__DMA0TRIG22             (0x0016)        /* DMA0TRIG22 */
#define DMA0TSEL__DMA0TRIG23             (0x0017)        /* DMA0TRIG23 */
#define DMA0TSEL__DMA0TRIG24             (0x0018)        /* DMA0TRIG24 */
#define DMA0TSEL__DMA0TRIG25             (0x0019)        /* DMA0TRIG25 */
#define DMA0TSEL__DMA0TRIG26             (0x001a)        /* DMA0TRIG26 */
#define DMA0TSEL__DMA0TRIG27             (0x001b)        /* DMA0TRIG27 */
#define DMA0TSEL__DMA0TRIG28             (0x001c)        /* DMA0TRIG28 */
#define DMA0TSEL__DMA0TRIG29             (0x001d)        /* DMA0TRIG29 */
#define DMA0TSEL__DMA0TRIG30             (0x001e)        /* DMA0TRIG30 */
#define DMA0TSEL__DMA0TRIG31             (0x001f)        /* DMA0TRIG31 */
#define DMA1TSEL                         (0x1f00)        /* DMA trigger select */
#define DMA1TSEL0                        (0x0100)        /* DMA trigger select */
#define DMA1TSEL1                        (0x0200)        /* DMA trigger select */
#define DMA1TSEL2                        (0x0400)        /* DMA trigger select */
#define DMA1TSEL3                        (0x0800)        /* DMA trigger select */
#define DMA1TSEL4                        (0x1000)        /* DMA trigger select */
#define DMA1TSEL_0                       (0x0000)        /* DMA1TRIG0 */
#define DMA1TSEL_1                       (0x0100)        /* DMA1TRIG1 */
#define DMA1TSEL_2                       (0x0200)        /* DMA1TRIG2 */
#define DMA1TSEL_3                       (0x0300)        /* DMA1TRIG3 */
#define DMA1TSEL_4                       (0x0400)        /* DMA1TRIG4 */
#define DMA1TSEL_5                       (0x0500)        /* DMA1TRIG5 */
#define DMA1TSEL_6                       (0x0600)        /* DMA1TRIG6 */
#define DMA1TSEL_7                       (0x0700)        /* DMA1TRIG7 */
#define DMA1TSEL_8                       (0x0800)        /* DMA1TRIG8 */
#define DMA1TSEL_9                       (0x0900)        /* DMA1TRIG9 */
#define DMA1TSEL_10                      (0x0a00)        /* DMA1TRIG10 */
#define DMA1TSEL_11                      (0x0b00)        /* DMA1TRIG11 */
#define DMA1TSEL_12                      (0x0c00)        /* DMA1TRIG12 */
#define DMA1TSEL_13                      (0x0d00)        /* DMA1TRIG13 */
#define DMA1TSEL_14                      (0x0e00)        /* DMA1TRIG14 */
#define DMA1TSEL_15                      (0x0f00)        /* DMA1TRIG15 */
#define DMA1TSEL_16                      (0x1000)        /* DMA1TRIG16 */
#define DMA1TSEL_17                      (0x1100)        /* DMA1TRIG17 */
#define DMA1TSEL_18                      (0x1200)        /* DMA1TRIG18 */
#define DMA1TSEL_19                      (0x1300)        /* DMA1TRIG19 */
#define DMA1TSEL_20                      (0x1400)        /* DMA1TRIG20 */
#define DMA1TSEL_21                      (0x1500)        /* DMA1TRIG21 */
#define DMA1TSEL_22                      (0x1600)        /* DMA1TRIG22 */
#define DMA1TSEL_23                      (0x1700)        /* DMA1TRIG23 */
#define DMA1TSEL_24                      (0x1800)        /* DMA1TRIG24 */
#define DMA1TSEL_25                      (0x1900)        /* DMA1TRIG25 */
#define DMA1TSEL_26                      (0x1a00)        /* DMA1TRIG26 */
#define DMA1TSEL_27                      (0x1b00)        /* DMA1TRIG27 */
#define DMA1TSEL_28                      (0x1c00)        /* DMA1TRIG28 */
#define DMA1TSEL_29                      (0x1d00)        /* DMA1TRIG29 */
#define DMA1TSEL_30                      (0x1e00)        /* DMA1TRIG30 */
#define DMA1TSEL_31                      (0x1f00)        /* DMA1TRIG31 */
#define DMA1TSEL__DMAREQ                 DMA1TSEL_0
#define DMA1TSEL__TA0CCR0                DMA1TSEL_1
#define DMA1TSEL__TA0CCR2                DMA1TSEL_2
#define DMA1TSEL__TA1CCR0                DMA1TSEL_3
#define DMA1TSEL__TA1CCR2                DMA1TSEL_4
#define DMA1TSEL__TA2CCR0                DMA1TSEL_5
#define DMA1TSEL__TA3CCR0                DMA1TSEL_6
#define DMA1TSEL__TB0CCR0                DMA1TSEL_7
#define DMA1TSEL__TB0CCR2                DMA1TSEL_8
#define DMA1TSEL__TA4CCR0                DMA1TSEL_9
#define DMA1TSEL__AES_Trigger_0          DMA1TSEL_11
#define DMA1TSEL__AES_Trigger_1          DMA1TSEL_12
#define DMA1TSEL__AES_Trigger_2          DMA1TSEL_13
#define DMA1TSEL__UCA0RXIFG              DMA1TSEL_14
#define DMA1TSEL__UCA0TXIFG              DMA1TSEL_15
#define DMA1TSEL__UCA1RXIFG              DMA1TSEL_16
#define DMA1TSEL__UCA1TXIFG              DMA1TSEL_17
#define DMA1TSEL__UCB0RXIFG              DMA1TSEL_18
#define DMA1TSEL__UCB0RXIFG0             DMA1TSEL_18
#define DMA1TSEL__UCB0TXIFG              DMA1TSEL_19
#define DMA1TSEL__UCB0TXIFG0             DMA1TSEL_19
#define DMA1TSEL__UCB0RXIFG1             DMA1TSEL_20
#define DMA1TSEL__UCB0TXIFG1             DMA1TSEL_21
#define DMA1TSEL__UCB0RXIFG2             DMA1TSEL_22
#define DMA1TSEL__UCB0TXIFG2             DMA1TSEL_23
#define DMA1TSEL__UCB0RXIFG3             DMA1TSEL_24
#define DMA1TSEL__UCB0TXIFG3             DMA1TSEL_25
#define DMA1TSEL__ADC12IFG               DMA1TSEL_26
#define DMA1TSEL__LEA                    DMA1TSEL_27
#define DMA1TSEL__MPY                    DMA1TSEL_29
#define DMA1TSEL__DMA0IFG                DMA1TSEL_30
#define DMA1TSEL__DMAE0                  DMA1TSEL_31
#define DMA1TSEL__DMA1TRIG0              (0x0000)        /* DMA1TRIG0 */
#define DMA1TSEL__DMA1TRIG1              (0x0100)        /* DMA1TRIG1 */
#define DMA1TSEL__DMA1TRIG2              (0x0200)        /* DMA1TRIG2 */
#define DMA1TSEL__DMA1TRIG3              (0x0300)        /* DMA1TRIG3 */
#define DMA1TSEL__DMA1TRIG4              (0x0400)        /* DMA1TRIG4 */
#define DMA1TSEL__DMA1TRIG5              (0x0500)        /* DMA1TRIG5 */
#define DMA1TSEL__DMA1TRIG6              (0x0600)        /* DMA1TRIG6 */
#define DMA1TSEL__DMA1TRIG7              (0x0700)        /* DMA1TRIG7 */
#define DMA1TSEL__DMA1TRIG8              (0x0800)        /* DMA1TRIG8 */
#define DMA1TSEL__DMA1TRIG9              (0x0900)        /* DMA1TRIG9 */
#define DMA1TSEL__DMA1TRIG10             (0x0a00)        /* DMA1TRIG10 */
#define DMA1TSEL__DMA1TRIG11             (0x0b00)        /* DMA1TRIG11 */
#define DMA1TSEL__DMA1TRIG12             (0x0c00)        /* DMA1TRIG12 */
#define DMA1TSEL__DMA1TRIG13             (0x0d00)        /* DMA1TRIG13 */
#define DMA1TSEL__DMA1TRIG14             (0x0e00)        /* DMA1TRIG14 */
#define DMA1TSEL__DMA1TRIG15             (0x0f00)        /* DMA1TRIG15 */
#define DMA1TSEL__DMA1TRIG16             (0x1000)        /* DMA1TRIG16 */
#define DMA1TSEL__DMA1TRIG17             (0x1100)        /* DMA1TRIG17 */
#define DMA1TSEL__DMA1TRIG18             (0x1200)        /* DMA1TRIG18 */
#define DMA1TSEL__DMA1TRIG19             (0x1300)        /* DMA1TRIG19 */
#define DMA1TSEL__DMA1TRIG20             (0x1400)        /* DMA1TRIG20 */
#define DMA1TSEL__DMA1TRIG21             (0x1500)        /* DMA1TRIG21 */
#define DMA1TSEL__DMA1TRIG22             (0x1600)        /* DMA1TRIG22 */
#define DMA1TSEL__DMA1TRIG23             (0x1700)        /* DMA1TRIG23 */
#define DMA1TSEL__DMA1TRIG24             (0x1800)        /* DMA1TRIG24 */
#define DMA1TSEL__DMA1TRIG25             (0x1900)        /* DMA1TRIG25 */
#define DMA1TSEL__DMA1TRIG26             (0x1a00)        /* DMA1TRIG26 */
#define DMA1TSEL__DMA1TRIG27             (0x1b00)        /* DMA1TRIG27 */
#define DMA1TSEL__DMA1TRIG28             (0x1c00)        /* DMA1TRIG28 */
#define DMA1TSEL__DMA1TRIG29             (0x1d00)        /* DMA1TRIG29 */
#define DMA1TSEL__DMA1TRIG30             (0x1e00)        /* DMA1TRIG30 */
#define DMA1TSEL__DMA1TRIG31             (0x1f00)        /* DMA1TRIG31 */

/* DMACTL1 Control Bits */
#define DMA2TSEL                         (0x001f)        /* DMA trigger select */
#define DMA2TSEL0                        (0x0001)        /* DMA trigger select */
#define DMA2TSEL1                        (0x0002)        /* DMA trigger select */
#define DMA2TSEL2                        (0x0004)        /* DMA trigger select */
#define DMA2TSEL3                        (0x0008)        /* DMA trigger select */
#define DMA2TSEL4                        (0x0010)        /* DMA trigger select */
#define DMA2TSEL_0                       (0x0000)        /* DMA2TRIG0 */
#define DMA2TSEL_1                       (0x0001)        /* DMA2TRIG1 */
#define DMA2TSEL_2                       (0x0002)        /* DMA2TRIG2 */
#define DMA2TSEL_3                       (0x0003)        /* DMA2TRIG3 */
#define DMA2TSEL_4                       (0x0004)        /* DMA2TRIG4 */
#define DMA2TSEL_5                       (0x0005)        /* DMA2TRIG5 */
#define DMA2TSEL_6                       (0x0006)        /* DMA2TRIG6 */
#define DMA2TSEL_7                       (0x0007)        /* DMA2TRIG7 */
#define DMA2TSEL_8                       (0x0008)        /* DMA2TRIG8 */
#define DMA2TSEL_9                       (0x0009)        /* DMA2TRIG9 */
#define DMA2TSEL_10                      (0x000a)        /* DMA2TRIG10 */
#define DMA2TSEL_11                      (0x000b)        /* DMA2TRIG11 */
#define DMA2TSEL_12                      (0x000c)        /* DMA2TRIG12 */
#define DMA2TSEL_13                      (0x000d)        /* DMA2TRIG13 */
#define DMA2TSEL_14                      (0x000e)        /* DMA2TRIG14 */
#define DMA2TSEL_15                      (0x000f)        /* DMA2TRIG15 */
#define DMA2TSEL_16                      (0x0010)        /* DMA2TRIG16 */
#define DMA2TSEL_17                      (0x0011)        /* DMA2TRIG17 */
#define DMA2TSEL_18                      (0x0012)        /* DMA2TRIG18 */
#define DMA2TSEL_19                      (0x0013)        /* DMA2TRIG19 */
#define DMA2TSEL_20                      (0x0014)        /* DMA2TRIG20 */
#define DMA2TSEL_21                      (0x0015)        /* DMA2TRIG21 */
#define DMA2TSEL_22                      (0x0016)        /* DMA2TRIG22 */
#define DMA2TSEL_23                      (0x0017)        /* DMA2TRIG23 */
#define DMA2TSEL_24                      (0x0018)        /* DMA2TRIG24 */
#define DMA2TSEL_25                      (0x0019)        /* DMA2TRIG25 */
#define DMA2TSEL_26                      (0x001a)        /* DMA2TRIG26 */
#define DMA2TSEL_27                      (0x001b)        /* DMA2TRIG27 */
#define DMA2TSEL_28                      (0x001c)        /* DMA2TRIG28 */
#define DMA2TSEL_29                      (0x001d)        /* DMA2TRIG29 */
#define DMA2TSEL_30                      (0x001e)        /* DMA2TRIG30 */
#define DMA2TSEL_31                      (0x001f)        /* DMA2TRIG31 */
#define DMA2TSEL__DMAREQ                 DMA2TSEL_0
#define DMA2TSEL__TA0CCR0                DMA2TSEL_1
#define DMA2TSEL__TA0CCR2                DMA2TSEL_2
#define DMA2TSEL__TA1CCR0                DMA2TSEL_3
#define DMA2TSEL__TA1CCR2                DMA2TSEL_4
#define DMA2TSEL__TA2CCR0                DMA2TSEL_5
#define DMA2TSEL__TA3CCR0                DMA2TSEL_6
#define DMA2TSEL__TB0CCR0                DMA2TSEL_7
#define DMA2TSEL__TB0CCR2                DMA2TSEL_8
#define DMA2TSEL__TA4CCR0                DMA2TSEL_9
#define DMA2TSEL__AES_Trigger_0          DMA2TSEL_11
#define DMA2TSEL__AES_Trigger_1          DMA2TSEL_12
#define DMA2TSEL__AES_Trigger_2          DMA2TSEL_13
#define DMA2TSEL__UCA0RXIFG              DMA2TSEL_14
#define DMA2TSEL__UCA0TXIFG              DMA2TSEL_15
#define DMA2TSEL__UCA1RXIFG              DMA2TSEL_16
#define DMA2TSEL__UCA1TXIFG              DMA2TSEL_17
#define DMA2TSEL__UCB0RXIFG              DMA2TSEL_18
#define DMA2TSEL__UCB0RXIFG0             DMA2TSEL_18
#define DMA2TSEL__UCB0TXIFG              DMA2TSEL_19
#define DMA2TSEL__UCB0TXIFG0             DMA2TSEL_19
#define DMA2TSEL__UCB0RXIFG1             DMA2TSEL_20
#define DMA2TSEL__UCB0TXIFG1             DMA2TSEL_21
#define DMA2TSEL__UCB0RXIFG2             DMA2TSEL_22
#define DMA2TSEL__UCB0TXIFG2             DMA2TSEL_23
#define DMA2TSEL__UCB0RXIFG3             DMA2TSEL_24
#define DMA2TSEL__UCB0TXIFG3             DMA2TSEL_25
#define DMA2TSEL__ADC12IFG               DMA2TSEL_26
#define DMA2TSEL__LEA                    DMA2TSEL_27
#define DMA2TSEL__MPY                    DMA2TSEL_29
#define DMA2TSEL__DMA1IFG                DMA2TSEL_30
#define DMA2TSEL__DMAE0                  DMA2TSEL_31
#define DMA2TSEL__DMA2TRIG0              (0x0000)        /* DMA2TRIG0 */
#define DMA2TSEL__DMA2TRIG1              (0x0001)        /* DMA2TRIG1 */
#define DMA2TSEL__DMA2TRIG2              (0x0002)        /* DMA2TRIG2 */
#define DMA2TSEL__DMA2TRIG3              (0x0003)        /* DMA2TRIG3 */
#define DMA2TSEL__DMA2TRIG4              (0x0004)        /* DMA2TRIG4 */
#define DMA2TSEL__DMA2TRIG5              (0x0005)        /* DMA2TRIG5 */
#define DMA2TSEL__DMA2TRIG6              (0x0006)        /* DMA2TRIG6 */
#define DMA2TSEL__DMA2TRIG7              (0x0007)        /* DMA2TRIG7 */
#define DMA2TSEL__DMA2TRIG8              (0x0008)        /* DMA2TRIG8 */
#define DMA2TSEL__DMA2TRIG9              (0x0009)        /* DMA2TRIG9 */
#define DMA2TSEL__DMA2TRIG10             (0x000a)        /* DMA2TRIG10 */
#define DMA2TSEL__DMA2TRIG11             (0x000b)        /* DMA2TRIG11 */
#define DMA2TSEL__DMA2TRIG12             (0x000c)        /* DMA2TRIG12 */
#define DMA2TSEL__DMA2TRIG13             (0x000d)        /* DMA2TRIG13 */
#define DMA2TSEL__DMA2TRIG14             (0x000e)        /* DMA2TRIG14 */
#define DMA2TSEL__DMA2TRIG15             (0x000f)        /* DMA2TRIG15 */
#define DMA2TSEL__DMA2TRIG16             (0x0010)        /* DMA2TRIG16 */
#define DMA2TSEL__DMA2TRIG17             (0x0011)        /* DMA2TRIG17 */
#define DMA2TSEL__DMA2TRIG18             (0x0012)        /* DMA2TRIG18 */
#define DMA2TSEL__DMA2TRIG19             (0x0013)        /* DMA2TRIG19 */
#define DMA2TSEL__DMA2TRIG20             (0x0014)        /* DMA2TRIG20 */
#define DMA2TSEL__DMA2TRIG21             (0x0015)        /* DMA2TRIG21 */
#define DMA2TSEL__DMA2TRIG22             (0x0016)        /* DMA2TRIG22 */
#define DMA2TSEL__DMA2TRIG23             (0x0017)        /* DMA2TRIG23 */
#define DMA2TSEL__DMA2TRIG24             (0x0018)        /* DMA2TRIG24 */
#define DMA2TSEL__DMA2TRIG25             (0x0019)        /* DMA2TRIG25 */
#define DMA2TSEL__DMA2TRIG26             (0x001a)        /* DMA2TRIG26 */
#define DMA2TSEL__DMA2TRIG27             (0x001b)        /* DMA2TRIG27 */
#define DMA2TSEL__DMA2TRIG28             (0x001c)        /* DMA2TRIG28 */
#define DMA2TSEL__DMA2TRIG29             (0x001d)        /* DMA2TRIG29 */
#define DMA2TSEL__DMA2TRIG30             (0x001e)        /* DMA2TRIG30 */
#define DMA2TSEL__DMA2TRIG31             (0x001f)        /* DMA2TRIG31 */
#define DMA3TSEL                         (0x1f00)        /* DMA trigger select */
#define DMA3TSEL0                        (0x0100)        /* DMA trigger select */
#define DMA3TSEL1                        (0x0200)        /* DMA trigger select */
#define DMA3TSEL2                        (0x0400)        /* DMA trigger select */
#define DMA3TSEL3                        (0x0800)        /* DMA trigger select */
#define DMA3TSEL4                        (0x1000)        /* DMA trigger select */
#define DMA3TSEL_0                       (0x0000)        /* DMA3TRIG0 */
#define DMA3TSEL_1                       (0x0100)        /* DMA3TRIG1 */
#define DMA3TSEL_2                       (0x0200)        /* DMA3TRIG2 */
#define DMA3TSEL_3                       (0x0300)        /* DMA3TRIG3 */
#define DMA3TSEL_4                       (0x0400)        /* DMA3TRIG4 */
#define DMA3TSEL_5                       (0x0500)        /* DMA3TRIG5 */
#define DMA3TSEL_6                       (0x0600)        /* DMA3TRIG6 */
#define DMA3TSEL_7                       (0x0700)        /* DMA3TRIG7 */
#define DMA3TSEL_8                       (0x0800)        /* DMA3TRIG8 */
#define DMA3TSEL_9                       (0x0900)        /* DMA3TRIG9 */
#define DMA3TSEL_10                      (0x0a00)        /* DMA3TRIG10 */
#define DMA3TSEL_11                      (0x0b00)        /* DMA3TRIG11 */
#define DMA3TSEL_12                      (0x0c00)        /* DMA3TRIG12 */
#define DMA3TSEL_13                      (0x0d00)        /* DMA3TRIG13 */
#define DMA3TSEL_14                      (0x0e00)        /* DMA3TRIG14 */
#define DMA3TSEL_15                      (0x0f00)        /* DMA3TRIG15 */
#define DMA3TSEL_16                      (0x1000)        /* DMA3TRIG16 */
#define DMA3TSEL_17                      (0x1100)        /* DMA3TRIG17 */
#define DMA3TSEL_18                      (0x1200)        /* DMA3TRIG18 */
#define DMA3TSEL_19                      (0x1300)        /* DMA3TRIG19 */
#define DMA3TSEL_20                      (0x1400)        /* DMA3TRIG20 */
#define DMA3TSEL_21                      (0x1500)        /* DMA3TRIG21 */
#define DMA3TSEL_22                      (0x1600)        /* DMA3TRIG22 */
#define DMA3TSEL_23                      (0x1700)        /* DMA3TRIG23 */
#define DMA3TSEL_24                      (0x1800)        /* DMA3TRIG24 */
#define DMA3TSEL_25                      (0x1900)        /* DMA3TRIG25 */
#define DMA3TSEL_26                      (0x1a00)        /* DMA3TRIG26 */
#define DMA3TSEL_27                      (0x1b00)        /* DMA3TRIG27 */
#define DMA3TSEL_28                      (0x1c00)        /* DMA3TRIG28 */
#define DMA3TSEL_29                      (0x1d00)        /* DMA3TRIG29 */
#define DMA3TSEL_30                      (0x1e00)        /* DMA3TRIG30 */
#define DMA3TSEL_31                      (0x1f00)        /* DMA3TRIG31 */
#define DMA3TSEL__DMAREQ                 DMA3TSEL_0
#define DMA3TSEL__TA0CCR0                DMA3TSEL_1
#define DMA3TSEL__TA0CCR2                DMA3TSEL_2
#define DMA3TSEL__TA1CCR0                DMA3TSEL_3
#define DMA3TSEL__TA1CCR2                DMA3TSEL_4
#define DMA3TSEL__TA2CCR0                DMA3TSEL_5
#define DMA3TSEL__TA3CCR0                DMA3TSEL_6
#define DMA3TSEL__TB0CCR0                DMA3TSEL_7
#define DMA3TSEL__TB0CCR2                DMA3TSEL_8
#define DMA3TSEL__TA4CCR0                DMA3TSEL_9
#define DMA3TSEL__AES_Trigger_0          DMA3TSEL_11
#define DMA3TSEL__AES_Trigger_1          DMA3TSEL_12
#define DMA3TSEL__AES_Trigger_2          DMA3TSEL_13
#define DMA3TSEL__UCA2RXIFG              DMA3TSEL_14
#define DMA3TSEL__UCA2TXIFG              DMA3TSEL_15
#define DMA3TSEL__UCA3RXIFG              DMA3TSEL_16
#define DMA3TSEL__UCA3TXIFG              DMA3TSEL_17
#define DMA3TSEL__UCB1RXIFG              DMA3TSEL_18
#define DMA3TSEL__UCB1RXIFG0             DMA3TSEL_18
#define DMA3TSEL__UCB1TXIFG              DMA3TSEL_19
#define DMA3TSEL__UCB1TXIFG0             DMA3TSEL_19
#define DMA3TSEL__UCB1RXIFG1             DMA3TSEL_20
#define DMA3TSEL__UCB1TXIFG1             DMA3TSEL_21
#define DMA3TSEL__UCB1RXIFG2             DMA3TSEL_22
#define DMA3TSEL__UCB1TXIFG2             DMA3TSEL_23
#define DMA3TSEL__UCB1RXIFG3             DMA3TSEL_24
#define DMA3TSEL__UCB1TXIFG3             DMA3TSEL_25
#define DMA3TSEL__ADC12IFG               DMA3TSEL_26
#define DMA3TSEL__LEA                    DMA3TSEL_27
#define DMA3TSEL__MPY                    DMA3TSEL_29
#define DMA3TSEL__DMA5IFG                DMA3TSEL_30
#define DMA3TSEL__DMAE0                  DMA3TSEL_31
#define DMA3TSEL__DMA3TRIG0              (0x0000)        /* DMA3TRIG0 */
#define DMA3TSEL__DMA3TRIG1              (0x0100)        /* DMA3TRIG1 */
#define DMA3TSEL__DMA3TRIG2              (0x0200)        /* DMA3TRIG2 */
#define DMA3TSEL__DMA3TRIG3              (0x0300)        /* DMA3TRIG3 */
#define DMA3TSEL__DMA3TRIG4              (0x0400)        /* DMA3TRIG4 */
#define DMA3TSEL__DMA3TRIG5              (0x0500)        /* DMA3TRIG5 */
#define DMA3TSEL__DMA3TRIG6              (0x0600)        /* DMA3TRIG6 */
#define DMA3TSEL__DMA3TRIG7              (0x0700)        /* DMA3TRIG7 */
#define DMA3TSEL__DMA3TRIG8              (0x0800)        /* DMA3TRIG8 */
#define DMA3TSEL__DMA3TRIG9              (0x0900)        /* DMA3TRIG9 */
#define DMA3TSEL__DMA3TRIG10             (0x0a00)        /* DMA3TRIG10 */
#define DMA3TSEL__DMA3TRIG11             (0x0b00)        /* DMA3TRIG11 */
#define DMA3TSEL__DMA3TRIG12             (0x0c00)        /* DMA3TRIG12 */
#define DMA3TSEL__DMA3TRIG13             (0x0d00)        /* DMA3TRIG13 */
#define DMA3TSEL__DMA3TRIG14             (0x0e00)        /* DMA3TRIG14 */
#define DMA3TSEL__DMA3TRIG15             (0x0f00)        /* DMA3TRIG15 */
#define DMA3TSEL__DMA3TRIG16             (0x1000)        /* DMA3TRIG16 */
#define DMA3TSEL__DMA3TRIG17             (0x1100)        /* DMA3TRIG17 */
#define DMA3TSEL__DMA3TRIG18             (0x1200)        /* DMA3TRIG18 */
#define DMA3TSEL__DMA3TRIG19             (0x1300)        /* DMA3TRIG19 */
#define DMA3TSEL__DMA3TRIG20             (0x1400)        /* DMA3TRIG20 */
#define DMA3TSEL__DMA3TRIG21             (0x1500)        /* DMA3TRIG21 */
#define DMA3TSEL__DMA3TRIG22             (0x1600)        /* DMA3TRIG22 */
#define DMA3TSEL__DMA3TRIG23             (0x1700)        /* DMA3TRIG23 */
#define DMA3TSEL__DMA3TRIG24             (0x1800)        /* DMA3TRIG24 */
#define DMA3TSEL__DMA3TRIG25             (0x1900)        /* DMA3TRIG25 */
#define DMA3TSEL__DMA3TRIG26             (0x1a00)        /* DMA3TRIG26 */
#define DMA3TSEL__DMA3TRIG27             (0x1b00)        /* DMA3TRIG27 */
#define DMA3TSEL__DMA3TRIG28             (0x1c00)        /* DMA3TRIG28 */
#define DMA3TSEL__DMA3TRIG29             (0x1d00)        /* DMA3TRIG29 */
#define DMA3TSEL__DMA3TRIG30             (0x1e00)        /* DMA3TRIG30 */
#define DMA3TSEL__DMA3TRIG31             (0x1f00)        /* DMA3TRIG31 */

/* DMACTL2 Control Bits */
#define DMA4TSEL                         (0x001f)        /* DMA trigger select */
#define DMA4TSEL0                        (0x0001)        /* DMA trigger select */
#define DMA4TSEL1                        (0x0002)        /* DMA trigger select */
#define DMA4TSEL2                        (0x0004)        /* DMA trigger select */
#define DMA4TSEL3                        (0x0008)        /* DMA trigger select */
#define DMA4TSEL4                        (0x0010)        /* DMA trigger select */
#define DMA4TSEL_0                       (0x0000)        /* DMA4TRIG0 */
#define DMA4TSEL_1                       (0x0001)        /* DMA4TRIG1 */
#define DMA4TSEL_2                       (0x0002)        /* DMA4TRIG2 */
#define DMA4TSEL_3                       (0x0003)        /* DMA4TRIG3 */
#define DMA4TSEL_4                       (0x0004)        /* DMA4TRIG4 */
#define DMA4TSEL_5                       (0x0005)        /* DMA4TRIG5 */
#define DMA4TSEL_6                       (0x0006)        /* DMA4TRIG6 */
#define DMA4TSEL_7                       (0x0007)        /* DMA4TRIG7 */
#define DMA4TSEL_8                       (0x0008)        /* DMA4TRIG8 */
#define DMA4TSEL_9                       (0x0009)        /* DMA4TRIG9 */
#define DMA4TSEL_10                      (0x000a)        /* DMA4TRIG10 */
#define DMA4TSEL_11                      (0x000b)        /* DMA4TRIG11 */
#define DMA4TSEL_12                      (0x000c)        /* DMA4TRIG12 */
#define DMA4TSEL_13                      (0x000d)        /* DMA4TRIG13 */
#define DMA4TSEL_14                      (0x000e)        /* DMA4TRIG14 */
#define DMA4TSEL_15                      (0x000f)        /* DMA4TRIG15 */
#define DMA4TSEL_16                      (0x0010)        /* DMA4TRIG16 */
#define DMA4TSEL_17                      (0x0011)        /* DMA4TRIG17 */
#define DMA4TSEL_18                      (0x0012)        /* DMA4TRIG18 */
#define DMA4TSEL_19                      (0x0013)        /* DMA4TRIG19 */
#define DMA4TSEL_20                      (0x0014)        /* DMA4TRIG20 */
#define DMA4TSEL_21                      (0x0015)        /* DMA4TRIG21 */
#define DMA4TSEL_22                      (0x0016)        /* DMA4TRIG22 */
#define DMA4TSEL_23                      (0x0017)        /* DMA4TRIG23 */
#define DMA4TSEL_24                      (0x0018)        /* DMA4TRIG24 */
#define DMA4TSEL_25                      (0x0019)        /* DMA4TRIG25 */
#define DMA4TSEL_26                      (0x001a)        /* DMA4TRIG26 */
#define DMA4TSEL_27                      (0x001b)        /* DMA4TRIG27 */
#define DMA4TSEL_28                      (0x001c)        /* DMA4TRIG28 */
#define DMA4TSEL_29                      (0x001d)        /* DMA4TRIG29 */
#define DMA4TSEL_30                      (0x001e)        /* DMA4TRIG30 */
#define DMA4TSEL_31                      (0x001f)        /* DMA4TRIG31 */
#define DMA4TSEL__DMAREQ                 DMA4TSEL_0
#define DMA4TSEL__TA0CCR0                DMA4TSEL_1
#define DMA4TSEL__TA0CCR2                DMA4TSEL_2
#define DMA4TSEL__TA1CCR0                DMA4TSEL_3
#define DMA4TSEL__TA1CCR2                DMA4TSEL_4
#define DMA4TSEL__TA2CCR0                DMA4TSEL_5
#define DMA4TSEL__TA3CCR0                DMA4TSEL_6
#define DMA4TSEL__TB0CCR0                DMA4TSEL_7
#define DMA4TSEL__TB0CCR2                DMA4TSEL_8
#define DMA4TSEL__TA4CCR0                DMA4TSEL_9
#define DMA4TSEL__AES_Trigger_0          DMA4TSEL_11
#define DMA4TSEL__AES_Trigger_1          DMA4TSEL_12
#define DMA4TSEL__AES_Trigger_2          DMA4TSEL_13
#define DMA4TSEL__UCA2RXIFG              DMA4TSEL_14
#define DMA4TSEL__UCA2TXIFG              DMA4TSEL_15
#define DMA4TSEL__UCA3RXIFG              DMA4TSEL_16
#define DMA4TSEL__UCA3TXIFG              DMA4TSEL_17
#define DMA4TSEL__UCB1RXIFG              DMA4TSEL_18
#define DMA4TSEL__UCB1RXIFG0             DMA4TSEL_18
#define DMA4TSEL__UCB1TXIFG              DMA4TSEL_19
#define DMA4TSEL__UCB1TXIFG0             DMA4TSEL_19
#define DMA4TSEL__UCB1RXIFG1             DMA4TSEL_20
#define DMA4TSEL__UCB1TXIFG1             DMA4TSEL_21
#define DMA4TSEL__UCB1RXIFG2             DMA4TSEL_22
#define DMA4TSEL__UCB1TXIFG2             DMA4TSEL_23
#define DMA4TSEL__UCB1RXIFG3             DMA4TSEL_24
#define DMA4TSEL__UCB1TXIFG3             DMA4TSEL_25
#define DMA4TSEL__ADC12IFG               DMA4TSEL_26
#define DMA4TSEL__LEA                    DMA4TSEL_27
#define DMA4TSEL__MPY                    DMA4TSEL_29
#define DMA4TSEL__DMA3IFG                DMA4TSEL_30
#define DMA4TSEL__DMAE0                  DMA4TSEL_31
#define DMA4TSEL__DMA4TRIG0              (0x0000)        /* DMA4TRIG0 */
#define DMA4TSEL__DMA4TRIG1              (0x0001)        /* DMA4TRIG1 */
#define DMA4TSEL__DMA4TRIG2              (0x0002)        /* DMA4TRIG2 */
#define DMA4TSEL__DMA4TRIG3              (0x0003)        /* DMA4TRIG3 */
#define DMA4TSEL__DMA4TRIG4              (0x0004)        /* DMA4TRIG4 */
#define DMA4TSEL__DMA4TRIG5              (0x0005)        /* DMA4TRIG5 */
#define DMA4TSEL__DMA4TRIG6              (0x0006)        /* DMA4TRIG6 */
#define DMA4TSEL__DMA4TRIG7              (0x0007)        /* DMA4TRIG7 */
#define DMA4TSEL__DMA4TRIG8              (0x0008)        /* DMA4TRIG8 */
#define DMA4TSEL__DMA4TRIG9              (0x0009)        /* DMA4TRIG9 */
#define DMA4TSEL__DMA4TRIG10             (0x000a)        /* DMA4TRIG10 */
#define DMA4TSEL__DMA4TRIG11             (0x000b)        /* DMA4TRIG11 */
#define DMA4TSEL__DMA4TRIG12             (0x000c)        /* DMA4TRIG12 */
#define DMA4TSEL__DMA4TRIG13             (0x000d)        /* DMA4TRIG13 */
#define DMA4TSEL__DMA4TRIG14             (0x000e)        /* DMA4TRIG14 */
#define DMA4TSEL__DMA4TRIG15             (0x000f)        /* DMA4TRIG15 */
#define DMA4TSEL__DMA4TRIG16             (0x0010)        /* DMA4TRIG16 */
#define DMA4TSEL__DMA4TRIG17             (0x0011)        /* DMA4TRIG17 */
#define DMA4TSEL__DMA4TRIG18             (0x0012)        /* DMA4TRIG18 */
#define DMA4TSEL__DMA4TRIG19             (0x0013)        /* DMA4TRIG19 */
#define DMA4TSEL__DMA4TRIG20             (0x0014)        /* DMA4TRIG20 */
#define DMA4TSEL__DMA4TRIG21             (0x0015)        /* DMA4TRIG21 */
#define DMA4TSEL__DMA4TRIG22             (0x0016)        /* DMA4TRIG22 */
#define DMA4TSEL__DMA4TRIG23             (0x0017)        /* DMA4TRIG23 */
#define DMA4TSEL__DMA4TRIG24             (0x0018)        /* DMA4TRIG24 */
#define DMA4TSEL__DMA4TRIG25             (0x0019)        /* DMA4TRIG25 */
#define DMA4TSEL__DMA4TRIG26             (0x001a)        /* DMA4TRIG26 */
#define DMA4TSEL__DMA4TRIG27             (0x001b)        /* DMA4TRIG27 */
#define DMA4TSEL__DMA4TRIG28             (0x001c)        /* DMA4TRIG28 */
#define DMA4TSEL__DMA4TRIG29             (0x001d)        /* DMA4TRIG29 */
#define DMA4TSEL__DMA4TRIG30             (0x001e)        /* DMA4TRIG30 */
#define DMA4TSEL__DMA4TRIG31             (0x001f)        /* DMA4TRIG31 */
#define DMA5TSEL                         (0x1f00)        /* DMA trigger select */
#define DMA5TSEL0                        (0x0100)        /* DMA trigger select */
#define DMA5TSEL1                        (0x0200)        /* DMA trigger select */
#define DMA5TSEL2                        (0x0400)        /* DMA trigger select */
#define DMA5TSEL3                        (0x0800)        /* DMA trigger select */
#define DMA5TSEL4                        (0x1000)        /* DMA trigger select */
#define DMA5TSEL_0                       (0x0000)        /* DMA5TRIG0 */
#define DMA5TSEL_1                       (0x0100)        /* DMA5TRIG1 */
#define DMA5TSEL_2                       (0x0200)        /* DMA5TRIG2 */
#define DMA5TSEL_3                       (0x0300)        /* DMA5TRIG3 */
#define DMA5TSEL_4                       (0x0400)        /* DMA5TRIG4 */
#define DMA5TSEL_5                       (0x0500)        /* DMA5TRIG5 */
#define DMA5TSEL_6                       (0x0600)        /* DMA5TRIG6 */
#define DMA5TSEL_7                       (0x0700)        /* DMA5TRIG7 */
#define DMA5TSEL_8                       (0x0800)        /* DMA5TRIG8 */
#define DMA5TSEL_9                       (0x0900)        /* DMA5TRIG9 */
#define DMA5TSEL_10                      (0x0a00)        /* DMA5TRIG10 */
#define DMA5TSEL_11                      (0x0b00)        /* DMA5TRIG11 */
#define DMA5TSEL_12                      (0x0c00)        /* DMA5TRIG12 */
#define DMA5TSEL_13                      (0x0d00)        /* DMA5TRIG13 */
#define DMA5TSEL_14                      (0x0e00)        /* DMA5TRIG14 */
#define DMA5TSEL_15                      (0x0f00)        /* DMA5TRIG15 */
#define DMA5TSEL_16                      (0x1000)        /* DMA5TRIG16 */
#define DMA5TSEL_17                      (0x1100)        /* DMA5TRIG17 */
#define DMA5TSEL_18                      (0x1200)        /* DMA5TRIG18 */
#define DMA5TSEL_19                      (0x1300)        /* DMA5TRIG19 */
#define DMA5TSEL_20                      (0x1400)        /* DMA5TRIG20 */
#define DMA5TSEL_21                      (0x1500)        /* DMA5TRIG21 */
#define DMA5TSEL_22                      (0x1600)        /* DMA5TRIG22 */
#define DMA5TSEL_23                      (0x1700)        /* DMA5TRIG23 */
#define DMA5TSEL_24                      (0x1800)        /* DMA5TRIG24 */
#define DMA5TSEL_25                      (0x1900)        /* DMA5TRIG25 */
#define DMA5TSEL_26                      (0x1a00)        /* DMA5TRIG26 */
#define DMA5TSEL_27                      (0x1b00)        /* DMA5TRIG27 */
#define DMA5TSEL_28                      (0x1c00)        /* DMA5TRIG28 */
#define DMA5TSEL_29                      (0x1d00)        /* DMA5TRIG29 */
#define DMA5TSEL_30                      (0x1e00)        /* DMA5TRIG30 */
#define DMA5TSEL_31                      (0x1f00)        /* DMA5TRIG31 */
#define DMA5TSEL__DMAREQ                 DMA5TSEL_0
#define DMA5TSEL__TA0CCR0                DMA5TSEL_1
#define DMA5TSEL__TA0CCR2                DMA5TSEL_2
#define DMA5TSEL__TA1CCR0                DMA5TSEL_3
#define DMA5TSEL__TA1CCR2                DMA5TSEL_4
#define DMA5TSEL__TA2CCR0                DMA5TSEL_5
#define DMA5TSEL__TA3CCR0                DMA5TSEL_6
#define DMA5TSEL__TB0CCR0                DMA5TSEL_7
#define DMA5TSEL__TB0CCR2                DMA5TSEL_8
#define DMA5TSEL__TA4CCR0                DMA5TSEL_9
#define DMA5TSEL__AES_Trigger_0          DMA5TSEL_11
#define DMA5TSEL__AES_Trigger_1          DMA5TSEL_12
#define DMA5TSEL__AES_Trigger_2          DMA5TSEL_13
#define DMA5TSEL__UCA2RXIFG              DMA5TSEL_14
#define DMA5TSEL__UCA2TXIFG              DMA5TSEL_15
#define DMA5TSEL__UCA3RXIFG              DMA5TSEL_16
#define DMA5TSEL__UCA3TXIFG              DMA5TSEL_17
#define DMA5TSEL__UCB1RXIFG              DMA5TSEL_18
#define DMA5TSEL__UCB1RXIFG0             DMA5TSEL_18
#define DMA5TSEL__UCB1TXIFG              DMA5TSEL_19
#define DMA5TSEL__UCB1TXIFG0             DMA5TSEL_19
#define DMA5TSEL__UCB1RXIFG1             DMA5TSEL_20
#define DMA5TSEL__UCB1TXIFG1             DMA5TSEL_21
#define DMA5TSEL__UCB1RXIFG2             DMA5TSEL_22
#define DMA5TSEL__UCB1TXIFG2             DMA5TSEL_23
#define DMA5TSEL__UCB1RXIFG3             DMA5TSEL_24
#define DMA5TSEL__UCB1TXIFG3             DMA5TSEL_25
#define DMA5TSEL__ADC12IFG               DMA5TSEL_26
#define DMA5TSEL__LEA                    DMA5TSEL_27
#define DMA5TSEL__MPY                    DMA5TSEL_29
#define DMA5TSEL__DMA4IFG                DMA5TSEL_30
#define DMA5TSEL__DMAE0                  DMA5TSEL_31
#define DMA5TSEL__DMA5TRIG0              (0x0000)        /* DMA5TRIG0 */
#define DMA5TSEL__DMA5TRIG1              (0x0100)        /* DMA5TRIG1 */
#define DMA5TSEL__DMA5TRIG2              (0x0200)        /* DMA5TRIG2 */
#define DMA5TSEL__DMA5TRIG3              (0x0300)        /* DMA5TRIG3 */
#define DMA5TSEL__DMA5TRIG4              (0x0400)        /* DMA5TRIG4 */
#define DMA5TSEL__DMA5TRIG5              (0x0500)        /* DMA5TRIG5 */
#define DMA5TSEL__DMA5TRIG6              (0x0600)        /* DMA5TRIG6 */
#define DMA5TSEL__DMA5TRIG7              (0x0700)        /* DMA5TRIG7 */
#define DMA5TSEL__DMA5TRIG8              (0x0800)        /* DMA5TRIG8 */
#define DMA5TSEL__DMA5TRIG9              (0x0900)        /* DMA5TRIG9 */
#define DMA5TSEL__DMA5TRIG10             (0x0a00)        /* DMA5TRIG10 */
#define DMA5TSEL__DMA5TRIG11             (0x0b00)        /* DMA5TRIG11 */
#define DMA5TSEL__DMA5TRIG12             (0x0c00)        /* DMA5TRIG12 */
#define DMA5TSEL__DMA5TRIG13             (0x0d00)        /* DMA5TRIG13 */
#define DMA5TSEL__DMA5TRIG14             (0x0e00)        /* DMA5TRIG14 */
#define DMA5TSEL__DMA5TRIG15             (0x0f00)        /* DMA5TRIG15 */
#define DMA5TSEL__DMA5TRIG16             (0x1000)        /* DMA5TRIG16 */
#define DMA5TSEL__DMA5TRIG17             (0x1100)        /* DMA5TRIG17 */
#define DMA5TSEL__DMA5TRIG18             (0x1200)        /* DMA5TRIG18 */
#define DMA5TSEL__DMA5TRIG19             (0x1300)        /* DMA5TRIG19 */
#define DMA5TSEL__DMA5TRIG20             (0x1400)        /* DMA5TRIG20 */
#define DMA5TSEL__DMA5TRIG21             (0x1500)        /* DMA5TRIG21 */
#define DMA5TSEL__DMA5TRIG22             (0x1600)        /* DMA5TRIG22 */
#define DMA5TSEL__DMA5TRIG23             (0x1700)        /* DMA5TRIG23 */
#define DMA5TSEL__DMA5TRIG24             (0x1800)        /* DMA5TRIG24 */
#define DMA5TSEL__DMA5TRIG25             (0x1900)        /* DMA5TRIG25 */
#define DMA5TSEL__DMA5TRIG26             (0x1a00)        /* DMA5TRIG26 */
#define DMA5TSEL__DMA5TRIG27             (0x1b00)        /* DMA5TRIG27 */
#define DMA5TSEL__DMA5TRIG28             (0x1c00)        /* DMA5TRIG28 */
#define DMA5TSEL__DMA5TRIG29             (0x1d00)        /* DMA5TRIG29 */
#define DMA5TSEL__DMA5TRIG30             (0x1e00)        /* DMA5TRIG30 */
#define DMA5TSEL__DMA5TRIG31             (0x1f00)        /* DMA5TRIG31 */

/* DMACTL4 Control Bits */
#define ENNMI                            (0x0001)        /* Enable NMI */
#define ENNMI_0                          (0x0000)        /* NMI does not interrupt DMA transfer */
#define ENNMI_1                          (0x0001)        /* NMI interrupts a DMA transfer */
#define ROUNDROBIN                       (0x0002)        /* Round robin */
#define ROUNDROBIN_0                     (0x0000)        /* DMA channel priority is DMA0-DMA1-DMA2 - ... - DMA7 */
#define ROUNDROBIN_1                     (0x0002)        /* DMA channel priority changes with each transfer */
#define DMARMWDIS                        (0x0004)        /* Read-modify-write disable */
#define DMARMWDIS_0                      (0x0000)        /* DMA transfers can occur during read-modify-write CPU 
                                                            operations */
#define DMARMWDIS_1                      (0x0004)        /* DMA transfers inhibited during read-modify-write CPU 
                                                            operations */

/* DMAIV Control Bits */
#define DMAIV0                           (0x0001)        /* DMA interrupt vector value */
#define DMAIV1                           (0x0002)        /* DMA interrupt vector value */
#define DMAIV2                           (0x0004)        /* DMA interrupt vector value */
#define DMAIV3                           (0x0008)        /* DMA interrupt vector value */
#define DMAIV4                           (0x0010)        /* DMA interrupt vector value */
#define DMAIV5                           (0x0020)        /* DMA interrupt vector value */
#define DMAIV6                           (0x0040)        /* DMA interrupt vector value */
#define DMAIV7                           (0x0080)        /* DMA interrupt vector value */
#define DMAIV8                           (0x0100)        /* DMA interrupt vector value */
#define DMAIV9                           (0x0200)        /* DMA interrupt vector value */
#define DMAIV10                          (0x0400)        /* DMA interrupt vector value */
#define DMAIV11                          (0x0800)        /* DMA interrupt vector value */
#define DMAIV12                          (0x1000)        /* DMA interrupt vector value */
#define DMAIV13                          (0x2000)        /* DMA interrupt vector value */
#define DMAIV14                          (0x4000)        /* DMA interrupt vector value */
#define DMAIV15                          (0x8000)        /* DMA interrupt vector value */
#define DMAIV_0                          (0x0000)        /* No interrupt pending */
#define DMAIV_2                          (0x0002)        /* Interrupt Source: DMA channel 0; Interrupt Flag: DMA0IFG; 
                                                            Interrupt Priority: Highest */
#define DMAIV_4                          (0x0004)        /* Interrupt Source: DMA channel 1; Interrupt Flag: DMA1IFG */
#define DMAIV_6                          (0x0006)        /* Interrupt Source: DMA channel 2; Interrupt Flag: DMA2IFG */
#define DMAIV_8                          (0x0008)        /* Interrupt Source: DMA channel 3; Interrupt Flag: DMA3IFG */
#define DMAIV_10                         (0x000a)        /* Interrupt Source: DMA channel 4; Interrupt Flag: DMA4IFG */
#define DMAIV_12                         (0x000c)        /* Interrupt Source: DMA channel 5; Interrupt Flag: DMA5IFG */
#define DMAIV_14                         (0x000e)        /* Interrupt Source: DMA channel 6; Interrupt Flag: DMA6IFG */
#define DMAIV_16                         (0x0010)        /* Interrupt Source: DMA channel 7; Interrupt Flag: DMA7IFG; 
                                                            Interrupt Priority: Lowest */
#define DMAIV__NONE                      (0x0000)        /* No interrupt pending */
#define DMAIV__DMA0IFG                   (0x0002)        /* Interrupt Source: DMA channel 0; Interrupt Flag: DMA0IFG; 
                                                            Interrupt Priority: Highest */
#define DMAIV__DMA1IFG                   (0x0004)        /* Interrupt Source: DMA channel 1; Interrupt Flag: DMA1IFG */
#define DMAIV__DMA2IFG                   (0x0006)        /* Interrupt Source: DMA channel 2; Interrupt Flag: DMA2IFG */
#define DMAIV__DMA3IFG                   (0x0008)        /* Interrupt Source: DMA channel 3; Interrupt Flag: DMA3IFG */
#define DMAIV__DMA4IFG                   (0x000a)        /* Interrupt Source: DMA channel 4; Interrupt Flag: DMA4IFG */
#define DMAIV__DMA5IFG                   (0x000c)        /* Interrupt Source: DMA channel 5; Interrupt Flag: DMA5IFG */
#define DMAIV__DMA6IFG                   (0x000e)        /* Interrupt Source: DMA channel 6; Interrupt Flag: DMA6IFG */
#define DMAIV__DMA7IFG                   (0x0010)        /* Interrupt Source: DMA channel 7; Interrupt Flag: DMA7IFG; 
                                                            Interrupt Priority: Lowest */

/* DMA0CTL Control Bits */
#define DMAREQ                           (0x0001)        /* DMA request */
#define DMAREQ_0                         (0x0000)        /* No DMA start */
#define DMAREQ_1                         (0x0001)        /* Start DMA */
#define DMAABORT                         (0x0002)        /* DMA abort */
#define DMAABORT_0                       (0x0000)        /* DMA transfer not interrupted */
#define DMAABORT_1                       (0x0002)        /* DMA transfer interrupted by NMI */
#define DMAIE                            (0x0004)        /* DMA interrupt enable */
#define DMAIE_0                          (0x0000)        /* Disabled */
#define DMAIE_1                          (0x0004)        /* Enabled */
#define DMAIE__DISABLE                   (0x0000)        /* Disabled */
#define DMAIE__ENABLE                    (0x0004)        /* Enabled */
#define DMAIFG                           (0x0008)        /* DMA interrupt flag */
#define DMAIFG_0                         (0x0000)        /* No interrupt pending */
#define DMAIFG_1                         (0x0008)        /* Interrupt pending */
#define DMAEN                            (0x0010)        /* DMA enable */
#define DMAEN_0                          (0x0000)        /* Disabled */
#define DMAEN_1                          (0x0010)        /* Enabled */
#define DMAEN__DISABLE                   (0x0000)        /* Disabled */
#define DMAEN__ENABLE                    (0x0010)        /* Enabled */
#define DMALEVEL                         (0x0020)        /* DMA level */
#define DMALEVEL_0                       (0x0000)        /* Edge sensitive (rising edge) */
#define DMALEVEL_1                       (0x0020)        /* Level sensitive (high level) */
#define DMALEVEL__EDGE                   (0x0000)        /* Edge sensitive (rising edge) */
#define DMALEVEL__LEVEL                  (0x0020)        /* Level sensitive (high level) */
#define DMASRCBYTE                       (0x0040)        /* DMA source byte */
#define DMASRCBYTE_0                     (0x0000)        /* Word */
#define DMASRCBYTE_1                     (0x0040)        /* Byte */
#define DMASRCBYTE__WORD                 (0x0000)        /* Word */
#define DMASRCBYTE__BYTE                 (0x0040)        /* Byte */
#define DMADSTBYTE                       (0x0080)        /* DMA destination byte */
#define DMADSTBYTE_0                     (0x0000)        /* Word */
#define DMADSTBYTE_1                     (0x0080)        /* Byte */
#define DMADSTBYTE__WORD                 (0x0000)        /* Word */
#define DMADSTBYTE__BYTE                 (0x0080)        /* Byte */
#define DMASRCINCR                       (0x0300)        /* DMA source increment */
#define DMASRCINCR0                      (0x0100)        /* DMA source increment */
#define DMASRCINCR1                      (0x0200)        /* DMA source increment */
#define DMASRCINCR_0                     (0x0000)        /* Source address is unchanged */
#define DMASRCINCR_1                     (0x0100)        /* Source address is unchanged */
#define DMASRCINCR_2                     (0x0200)        /* Source address is decremented */
#define DMASRCINCR_3                     (0x0300)        /* Source address is incremented */
#define DMADSTINCR                       (0x0c00)        /* DMA destination increment */
#define DMADSTINCR0                      (0x0400)        /* DMA destination increment */
#define DMADSTINCR1                      (0x0800)        /* DMA destination increment */
#define DMADSTINCR_0                     (0x0000)        /* Destination address is unchanged */
#define DMADSTINCR_1                     (0x0400)        /* Destination address is unchanged */
#define DMADSTINCR_2                     (0x0800)        /* Destination address is decremented */
#define DMADSTINCR_3                     (0x0c00)        /* Destination address is incremented */
#define DMADT                            (0x7000)        /* DMA transfer mode */
#define DMADT0                           (0x1000)        /* DMA transfer mode */
#define DMADT1                           (0x2000)        /* DMA transfer mode */
#define DMADT2                           (0x4000)        /* DMA transfer mode */
#define DMADT_0                          (0x0000)        /* Single transfer */
#define DMADT_1                          (0x1000)        /* Block transfer */
#define DMADT_2                          (0x2000)        /* Burst-block transfer */
#define DMADT_3                          (0x3000)        /* Burst-block transfer */
#define DMADT_4                          (0x4000)        /* Repeated single transfer */
#define DMADT_5                          (0x5000)        /* Repeated block transfer */
#define DMADT_6                          (0x6000)        /* Repeated burst-block transfer */
#define DMADT_7                          (0x7000)        /* Repeated burst-block transfer */


/*****************************************************************************
 FRCTL_A Registers
*****************************************************************************/

#define __MSP430_HAS_FRCTL_A__                /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_FRCTL_A__ 0x0140
#define FRCTL_A_BASE           __MSP430_BASEADDRESS_FRCTL_A__

sfr_w(FRCTL0);                                /* FRAM Controller A Control Register 0 */
sfr_b(FRCTL0_L);
sfr_b(FRCTL0_H);
sfr_w(GCCTL0);                                /* General Control Register 0 */
sfr_b(GCCTL0_L);
sfr_b(GCCTL0_H);
sfr_w(GCCTL1);                                /* General Control Register 1 */
sfr_b(GCCTL1_L);
sfr_b(GCCTL1_H);

/* FRCTL_A Register Offsets */
#define OFS_FRCTL0                       (0x0000)
#define OFS_FRCTL0_L                     OFS_FRCTL0
#define OFS_FRCTL0_H                     OFS_FRCTL0+1
#define OFS_GCCTL0                       (0x0004)
#define OFS_GCCTL0_L                     OFS_GCCTL0
#define OFS_GCCTL0_H                     OFS_GCCTL0+1
#define OFS_GCCTL1                       (0x0006)
#define OFS_GCCTL1_L                     OFS_GCCTL1
#define OFS_GCCTL1_H                     OFS_GCCTL1+1

/* FRCTL_A Control Bits */

/* FRCTL0 Control Bits */
#define NWAITS                           (0x00f0)        /* Wait state numbers */
#define NWAITS_L                         (0x00f0)
#define NWAITS0                          (0x0010)        /* Wait state numbers */
#define NWAITS0_L                        (0x0010)
#define NWAITS1                          (0x0020)        /* Wait state numbers */
#define NWAITS1_L                        (0x0020)
#define NWAITS2                          (0x0040)        /* Wait state numbers */
#define NWAITS2_L                        (0x0040)
#define NWAITS3                          (0x0080)        /* Wait state numbers */
#define NWAITS3_L                        (0x0080)
#define NWAITS_0                         (0x0000)        /* FRAM wait states: 0 */
#define NWAITS_1                         (0x0010)        /* FRAM wait states: 1 */
#define NWAITS_1_L                       (0x0010)
#define NWAITS_2                         (0x0020)        /* FRAM wait states: 2 */
#define NWAITS_2_L                       (0x0020)
#define NWAITS_3                         (0x0030)        /* FRAM wait states: 3 */
#define NWAITS_3_L                       (0x0030)
#define NWAITS_4                         (0x0040)        /* FRAM wait states: 4 */
#define NWAITS_4_L                       (0x0040)
#define NWAITS_5                         (0x0050)        /* FRAM wait states: 5 */
#define NWAITS_5_L                       (0x0050)
#define NWAITS_6                         (0x0060)        /* FRAM wait states: 6 */
#define NWAITS_6_L                       (0x0060)
#define NWAITS_7                         (0x0070)        /* FRAM wait states: 7 */
#define NWAITS_7_L                       (0x0070)
#define NWAITS_8                         (0x0080)        /* FRAM wait states: 8 */
#define NWAITS_8_L                       (0x0080)
#define NWAITS_9                         (0x0090)        /* FRAM wait states: 9 */
#define NWAITS_9_L                       (0x0090)
#define NWAITS_10                        (0x00a0)        /* FRAM wait states: 10 */
#define NWAITS_10_L                      (0x00a0)
#define NWAITS_11                        (0x00b0)        /* FRAM wait states: 11 */
#define NWAITS_11_L                      (0x00b0)
#define NWAITS_12                        (0x00c0)        /* FRAM wait states: 12 */
#define NWAITS_12_L                      (0x00c0)
#define NWAITS_13                        (0x00d0)        /* FRAM wait states: 13 */
#define NWAITS_13_L                      (0x00d0)
#define NWAITS_14                        (0x00e0)        /* FRAM wait states: 14 */
#define NWAITS_14_L                      (0x00e0)
#define NWAITS_15                        (0x00f0)        /* FRAM wait states: 15 */
#define NWAITS_15_L                      (0x00f0)
#define FRCTLPW                          (0xa500)        /* FRCTLPW password */
#define FRCTLPW_H                        (0x00a5)
#define FRCTLPW0                         (0x0100)        /* FRCTLPW password */
#define FRCTLPW0_H                       (0x0001)
#define FRCTLPW1                         (0x0200)        /* FRCTLPW password */
#define FRCTLPW1_H                       (0x0002)
#define FRCTLPW2                         (0x0400)        /* FRCTLPW password */
#define FRCTLPW2_H                       (0x0004)
#define FRCTLPW3                         (0x0800)        /* FRCTLPW password */
#define FRCTLPW3_H                       (0x0008)
#define FRCTLPW4                         (0x1000)        /* FRCTLPW password */
#define FRCTLPW4_H                       (0x0010)
#define FRCTLPW5                         (0x2000)        /* FRCTLPW password */
#define FRCTLPW5_H                       (0x0020)
#define FRCTLPW6                         (0x4000)        /* FRCTLPW password */
#define FRCTLPW6_H                       (0x0040)
#define FRCTLPW7                         (0x8000)        /* FRCTLPW password */
#define FRCTLPW7_H                       (0x0080)
#define FRPW                             (0x9600)        /* Read value while locked */
#define FRPW_H                           (0x0096)
#define FWPW                             (0xa500)        /* Must be written as A5h or a PUC is generated on word write. 
                                                            After a correct password is written and register access is 
                                                            enabled, a wrong password write in byte mode disables the 
                                                            access and no PUC is generated. */
#define FWPW_H                           (0x00a5)
#define AUTO                             (0x0008)        /* Enable automatic Wait State Mode */
#define AUTO_L                           (0x0008)
#define AUTO_0                           (0x0000)        /* User Wait State Mode. The NWAITS[3:0] is used for the FRAM 
                                                            wait state. */
#define AUTO_1                           (0x0008)        /* Auto mode. The NWAITS[3:0] is ignored. Wait states are 
                                                            generated automatically by the internal FRAM controller state 
                                                            machine. */
#define AUTO_1_L                         (0x0008)
#define WPROT                            (0x0001)        /* Write Protection Enable */
#define WPROT_L                          (0x0001)
#define WPROT_0                          (0x0000)        /* Disable Write Protection. Write to FRAM memory is allowed. */
#define WPROT_1                          (0x0001)        /* Enable Write Protection. Write to FRAM memory is not allowed. 
                                                            In case a write access is attempted, the WPIFG (Write 
                                                            Protection Flag) bit will be set. */
#define WPROT_1_L                        (0x0001)

/* GCCTL0 Control Bits */
#define UBDRSTEN                         (0x0080)        /* Enable Power Up Clear (PUC) reset for the uncorrectable bit 
                                                            error detection flag (UBDIFG) */
#define UBDRSTEN_L                       (0x0080)
#define UBDRSTEN_0                       (0x0000)        /* PUC not initiated on uncorrectable bit error detection flag. */
#define UBDRSTEN_1                       (0x0080)        /* PUC initiated on uncorrectable bit error detection flag. 
                                                            Generates vector in SYSRSTIV. Clear the UBDIE bit. */
#define UBDRSTEN_1_L                     (0x0080)
#define UBDIE                            (0x0040)        /* Enable NMI event for the uncorrectable bit error detection 
                                                            flag (UBDIFG) */
#define UBDIE_L                          (0x0040)
#define UBDIE_0                          (0x0000)        /* Disable NMI for the uncorrectable bit error detection flag 
                                                            (UBDIFG). */
#define UBDIE_1                          (0x0040)        /* Enable NMI for the uncorrectable bit error detection flag 
                                                            (UBDIFG). Generates vector in SYSSNIV. Clear the UBDRSTEN bit. */
#define UBDIE_1_L                        (0x0040)
#define CBDIE                            (0x0020)        /* Enable NMI event for the correctable bit error detection flag 
                                                            (CBDIFG) */
#define CBDIE_L                          (0x0020)
#define CBDIE_0                          (0x0000)        /* Disable NMI for the correctable bit error detection flag 
                                                            (CBDIFG). */
#define CBDIE_1                          (0x0020)        /* Disable NMI for the correctable bit error detection flag 
                                                            (CBDIFG). Generates vector in SYSSNIV. */
#define CBDIE_1_L                        (0x0020)
#define WPIE                             (0x0010)        /* Enable NMI event for the Write Protection Detection flag 
                                                            (WPIFG) */
#define WPIE_L                           (0x0010)
#define WPIE_0                           (0x0000)        /* Disable NMI for the Write Protection Detection flag (WPIFG). */
#define WPIE_1                           (0x0010)        /* Enable NMI for the Write Protection Detection flag (WPIFG). 
                                                            Generates vector in SYSSNIV. */
#define WPIE_1_L                         (0x0010)
#define ACCTEIE                          (0x0008)        /* Enable NMI event for the Access time error flag (ACCTEIFG) */
#define ACCTEIE_L                        (0x0008)
#define ACCTEIE_0                        (0x0000)        /* Disable NMI for the Access time error flag (ACCTEIFG). */
#define ACCTEIE_1                        (0x0008)        /* Enable NMI for the Access time error flag (ACCTEIFG). 
                                                            Generates vector in SYSSNIV. */
#define ACCTEIE_1_L                      (0x0008)
#define FRPWR                            (0x0004)        /* FRAM Memory Power Control Request */
#define FRPWR_L                          (0x0004)
#define FRPWR_0                          (0x0000)        /* Enable INACTIVE mode. */
#define FRPWR_1                          (0x0004)        /* Enable ACTIVE mode. */
#define FRPWR_1_L                        (0x0004)

/* GCCTL1 Control Bits */
#define WPIFG                            (0x0010)        /* Write Protection Detection flag */
#define WPIFG_L                          (0x0010)
#define WPIFG_0                          (0x0000)        /* No interrupt pending. */
#define WPIFG_1                          (0x0010)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV when it is the highest pending interrupt. */
#define WPIFG_1_L                        (0x0010)
#define ACCTEIFG                         (0x0008)        /* Access time error flag */
#define ACCTEIFG_L                       (0x0008)
#define ACCTEIFG_0                       (0x0000)        /* No interrupt pending. */
#define ACCTEIFG_1                       (0x0008)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV when it is the highest pending interrupt. */
#define ACCTEIFG_1_L                     (0x0008)
#define UBDIFG                           (0x0004)        /* FRAM uncorrectable bit error detection flag */
#define UBDIFG_L                         (0x0004)
#define UBDIFG_0                         (0x0000)        /* No interrupt pending. */
#define UBDIFG_1                         (0x0004)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV when it is the highest pending interrupt. */
#define UBDIFG_1_L                       (0x0004)
#define CBDIFG                           (0x0002)        /* FRAM correctable bit error detection flag */
#define CBDIFG_L                         (0x0002)
#define CBDIFG_0                         (0x0000)        /* No interrupt is pending */
#define CBDIFG_1                         (0x0002)        /* Interrupt pending. Can be cleared by writing '0' or by reading
                                                            SYSSNIV if it is the highest pending interrupt. */
#define CBDIFG_1_L                       (0x0002)


/*****************************************************************************
 HSPLL Registers
*****************************************************************************/

#define __MSP430_HAS_HSPLL__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_HSPLL__ 0x0EE0
#define HSPLL_BASE             __MSP430_BASEADDRESS_HSPLL__

sfr_w(HSPLLIIDX);                             /* Interrupt Index Register */
sfr_b(HSPLLIIDX_L);
sfr_b(HSPLLIIDX_H);
sfr_w(HSPLLMIS);                              /* Masked Interrupt Status Register. */
sfr_b(HSPLLMIS_L);
sfr_b(HSPLLMIS_H);
sfr_w(HSPLLRIS);                              /* Raw Interrupt Status Register */
sfr_b(HSPLLRIS_L);
sfr_b(HSPLLRIS_H);
sfr_w(HSPLLIMSC);                             /* Interrupt Mask Register */
sfr_b(HSPLLIMSC_L);
sfr_b(HSPLLIMSC_H);
sfr_w(HSPLLICR);                              /* Interrupt Flag Clear Register. */
sfr_b(HSPLLICR_L);
sfr_b(HSPLLICR_H);
sfr_w(HSPLLISR);                              /* Interrupt Flag Set Register. */
sfr_b(HSPLLISR_L);
sfr_b(HSPLLISR_H);
sfr_w(HSPLLDESCLO);                           /* HSPLL Descriptor Register L. */
sfr_b(HSPLLDESCLO_L);
sfr_b(HSPLLDESCLO_H);
sfr_w(HSPLLDESCHI);                           /* HSPLL Descriptor Register H. */
sfr_b(HSPLLDESCHI_L);
sfr_b(HSPLLDESCHI_H);
sfr_w(HSPLLCTL);                              /* HSPLL Control Register */
sfr_b(HSPLLCTL_L);
sfr_b(HSPLLCTL_H);
sfr_w(HSPLLUSSXTLCTL);                        /* USSXT Control Register */
sfr_b(HSPLLUSSXTLCTL_L);
sfr_b(HSPLLUSSXTLCTL_H);

/* HSPLL Register Offsets */
#define OFS_HSPLLIIDX                    (0x0000)
#define OFS_HSPLLIIDX_L                  OFS_HSPLLIIDX
#define OFS_HSPLLIIDX_H                  OFS_HSPLLIIDX+1
#define OFS_HSPLLMIS                     (0x0002)
#define OFS_HSPLLMIS_L                   OFS_HSPLLMIS
#define OFS_HSPLLMIS_H                   OFS_HSPLLMIS+1
#define OFS_HSPLLRIS                     (0x0004)
#define OFS_HSPLLRIS_L                   OFS_HSPLLRIS
#define OFS_HSPLLRIS_H                   OFS_HSPLLRIS+1
#define OFS_HSPLLIMSC                    (0x0006)
#define OFS_HSPLLIMSC_L                  OFS_HSPLLIMSC
#define OFS_HSPLLIMSC_H                  OFS_HSPLLIMSC+1
#define OFS_HSPLLICR                     (0x0008)
#define OFS_HSPLLICR_L                   OFS_HSPLLICR
#define OFS_HSPLLICR_H                   OFS_HSPLLICR+1
#define OFS_HSPLLISR                     (0x000A)
#define OFS_HSPLLISR_L                   OFS_HSPLLISR
#define OFS_HSPLLISR_H                   OFS_HSPLLISR+1
#define OFS_HSPLLDESCLO                  (0x000C)
#define OFS_HSPLLDESCLO_L                OFS_HSPLLDESCLO
#define OFS_HSPLLDESCLO_H                OFS_HSPLLDESCLO+1
#define OFS_HSPLLDESCHI                  (0x000E)
#define OFS_HSPLLDESCHI_L                OFS_HSPLLDESCHI
#define OFS_HSPLLDESCHI_H                OFS_HSPLLDESCHI+1
#define OFS_HSPLLCTL                     (0x0010)
#define OFS_HSPLLCTL_L                   OFS_HSPLLCTL
#define OFS_HSPLLCTL_H                   OFS_HSPLLCTL+1
#define OFS_HSPLLUSSXTLCTL               (0x0012)
#define OFS_HSPLLUSSXTLCTL_L             OFS_HSPLLUSSXTLCTL
#define OFS_HSPLLUSSXTLCTL_H             OFS_HSPLLUSSXTLCTL+1

/* HSPLL Control Bits */

/* HSPLLIIDX Control Bits */
#define IIDX                             (0xfffe)        /* HSPLL Interrupt Vector Value */
#define IIDX_L                           (0x00fe)
#define IIDX_H                           (0x00ff)
#define IIDX0                            (0x0002)        /* HSPLL Interrupt Vector Value */
#define IIDX0_L                          (0x0002)
#define IIDX1                            (0x0004)        /* HSPLL Interrupt Vector Value */
#define IIDX1_L                          (0x0004)
#define IIDX2                            (0x0008)        /* HSPLL Interrupt Vector Value */
#define IIDX2_L                          (0x0008)
#define IIDX3                            (0x0010)        /* HSPLL Interrupt Vector Value */
#define IIDX3_L                          (0x0010)
#define IIDX4                            (0x0020)        /* HSPLL Interrupt Vector Value */
#define IIDX4_L                          (0x0020)
#define IIDX5                            (0x0040)        /* HSPLL Interrupt Vector Value */
#define IIDX5_L                          (0x0040)
#define IIDX6                            (0x0080)        /* HSPLL Interrupt Vector Value */
#define IIDX6_L                          (0x0080)
#define IIDX7                            (0x0100)        /* HSPLL Interrupt Vector Value */
#define IIDX7_H                          (0x0001)
#define IIDX8                            (0x0200)        /* HSPLL Interrupt Vector Value */
#define IIDX8_H                          (0x0002)
#define IIDX9                            (0x0400)        /* HSPLL Interrupt Vector Value */
#define IIDX9_H                          (0x0004)
#define IIDX10                           (0x0800)        /* HSPLL Interrupt Vector Value */
#define IIDX10_H                         (0x0008)
#define IIDX11                           (0x1000)        /* HSPLL Interrupt Vector Value */
#define IIDX11_H                         (0x0010)
#define IIDX12                           (0x2000)        /* HSPLL Interrupt Vector Value */
#define IIDX12_H                         (0x0020)
#define IIDX13                           (0x4000)        /* HSPLL Interrupt Vector Value */
#define IIDX13_H                         (0x0040)
#define IIDX14                           (0x8000)        /* HSPLL Interrupt Vector Value */
#define IIDX14_H                         (0x0080)
#define IIDX_0                           (0x0000)        /* No Interrupt pending */
#define IIDX_1                           (0x0002)        /* Interrupt Source: PLLUNLOCK; Interrupt Priority: Highest */
#define IIDX_1_L                         (0x0002)
#define IIDX_2                           (0x0004)        /* Reserved; Interrupt Priority: Lowest */
#define IIDX_2_L                         (0x0004)

/* HSPLLMIS Control Bits */
#define PLLUNLOCK                        (0x0001)        /* HSPLL Unlock Masked Interrupt Status bit */
#define PLLUNLOCK_L                      (0x0001)
#define PLLUNLOCK_0                      (0x0000)        /* No interrupt pending */
#define PLLUNLOCK_1                      (0x0001)        /* Interrupt pending */
#define PLLUNLOCK_1_L                    (0x0001)

/* HSPLLDESCLO Control Bits */
#define MINREV                           (0x000f)        /* Minor Revision */
#define MINREV_L                         (0x000f)
#define MINREV0                          (0x0001)        /* Minor Revision */
#define MINREV0_L                        (0x0001)
#define MINREV1                          (0x0002)        /* Minor Revision */
#define MINREV1_L                        (0x0002)
#define MINREV2                          (0x0004)        /* Minor Revision */
#define MINREV2_L                        (0x0004)
#define MINREV3                          (0x0008)        /* Minor Revision */
#define MINREV3_L                        (0x0008)
#define INSTNUM                          (0x0f00)        /* Instance Number within the device. */
#define INSTNUM_H                        (0x000f)
#define INSTNUM0                         (0x0100)        /* Instance Number within the device. */
#define INSTNUM0_H                       (0x0001)
#define INSTNUM1                         (0x0200)        /* Instance Number within the device. */
#define INSTNUM1_H                       (0x0002)
#define INSTNUM2                         (0x0400)        /* Instance Number within the device. */
#define INSTNUM2_H                       (0x0004)
#define INSTNUM3                         (0x0800)        /* Instance Number within the device. */
#define INSTNUM3_H                       (0x0008)
#define MAJREV                           (0x00f0)        /* Major Revision */
#define MAJREV_L                         (0x00f0)
#define MAJREV0                          (0x0010)        /* Major Revision */
#define MAJREV0_L                        (0x0010)
#define MAJREV1                          (0x0020)        /* Major Revision */
#define MAJREV1_L                        (0x0020)
#define MAJREV2                          (0x0040)        /* Major Revision */
#define MAJREV2_L                        (0x0040)
#define MAJREV3                          (0x0080)        /* Major Revision */
#define MAJREV3_L                        (0x0080)
#define FEATUREVER                       (0xf000)        /* Feature Set for the module */
#define FEATUREVER_H                     (0x00f0)
#define FEATUREVER0                      (0x1000)        /* Feature Set for the module */
#define FEATUREVER0_H                    (0x0010)
#define FEATUREVER1                      (0x2000)        /* Feature Set for the module */
#define FEATUREVER1_H                    (0x0020)
#define FEATUREVER2                      (0x4000)        /* Feature Set for the module */
#define FEATUREVER2_H                    (0x0040)
#define FEATUREVER3                      (0x8000)        /* Feature Set for the module */
#define FEATUREVER3_H                    (0x0080)

/* HSPLLDESCHI Control Bits */
#define MODULEID                         (0xffff)        /* Module Identifier. */
#define MODULEID_L                       (0x00ff)
#define MODULEID_H                       (0x00ff)
#define MODULEID0                        (0x0001)        /* Module Identifier. */
#define MODULEID0_L                      (0x0001)
#define MODULEID1                        (0x0002)        /* Module Identifier. */
#define MODULEID1_L                      (0x0002)
#define MODULEID2                        (0x0004)        /* Module Identifier. */
#define MODULEID2_L                      (0x0004)
#define MODULEID3                        (0x0008)        /* Module Identifier. */
#define MODULEID3_L                      (0x0008)
#define MODULEID4                        (0x0010)        /* Module Identifier. */
#define MODULEID4_L                      (0x0010)
#define MODULEID5                        (0x0020)        /* Module Identifier. */
#define MODULEID5_L                      (0x0020)
#define MODULEID6                        (0x0040)        /* Module Identifier. */
#define MODULEID6_L                      (0x0040)
#define MODULEID7                        (0x0080)        /* Module Identifier. */
#define MODULEID7_L                      (0x0080)
#define MODULEID8                        (0x0100)        /* Module Identifier. */
#define MODULEID8_H                      (0x0001)
#define MODULEID9                        (0x0200)        /* Module Identifier. */
#define MODULEID9_H                      (0x0002)
#define MODULEID10                       (0x0400)        /* Module Identifier. */
#define MODULEID10_H                     (0x0004)
#define MODULEID11                       (0x0800)        /* Module Identifier. */
#define MODULEID11_H                     (0x0008)
#define MODULEID12                       (0x1000)        /* Module Identifier. */
#define MODULEID12_H                     (0x0010)
#define MODULEID13                       (0x2000)        /* Module Identifier. */
#define MODULEID13_H                     (0x0020)
#define MODULEID14                       (0x4000)        /* Module Identifier. */
#define MODULEID14_H                     (0x0040)
#define MODULEID15                       (0x8000)        /* Module Identifier. */
#define MODULEID15_H                     (0x0080)

/* HSPLLCTL Control Bits */
#define PLLM                             (0xfc00)        /* PLL Multiplier */
#define PLLM_H                           (0x00fc)
#define PLLM0                            (0x0400)        /* PLL Multiplier */
#define PLLM0_H                          (0x0004)
#define PLLM1                            (0x0800)        /* PLL Multiplier */
#define PLLM1_H                          (0x0008)
#define PLLM2                            (0x1000)        /* PLL Multiplier */
#define PLLM2_H                          (0x0010)
#define PLLM3                            (0x2000)        /* PLL Multiplier */
#define PLLM3_H                          (0x0020)
#define PLLM4                            (0x4000)        /* PLL Multiplier */
#define PLLM4_H                          (0x0040)
#define PLLM5                            (0x8000)        /* PLL Multiplier */
#define PLLM5_H                          (0x0080)
#define PLLM_16                          (0x4000)        /* */
#define PLLM_16_H                        (0x0040)
#define PLLM_17                          (0x4400)        /* */
#define PLLM_17_H                        (0x0044)
#define PLLM_18                          (0x4800)        /* */
#define PLLM_18_H                        (0x0048)
#define PLLM_19                          (0x4c00)        /* */
#define PLLM_19_H                        (0x004c)
#define PLLM_20                          (0x5000)        /* */
#define PLLM_20_H                        (0x0050)
#define PLLM_21                          (0x5400)        /* */
#define PLLM_21_H                        (0x0054)
#define PLLM_22                          (0x5800)        /* */
#define PLLM_22_H                        (0x0058)
#define PLLM_23                          (0x5c00)        /* */
#define PLLM_23_H                        (0x005c)
#define PLLM_24                          (0x6000)        /* */
#define PLLM_24_H                        (0x0060)
#define PLLM_25                          (0x6400)        /* */
#define PLLM_25_H                        (0x0064)
#define PLLM_26                          (0x6800)        /* */
#define PLLM_26_H                        (0x0068)
#define PLLM_27                          (0x6c00)        /* */
#define PLLM_27_H                        (0x006c)
#define PLLM_28                          (0x7000)        /* */
#define PLLM_28_H                        (0x0070)
#define PLLM_29                          (0x7400)        /* */
#define PLLM_29_H                        (0x0074)
#define PLLM_30                          (0x7800)        /* */
#define PLLM_30_H                        (0x0078)
#define PLLM_31                          (0x7c00)        /* */
#define PLLM_31_H                        (0x007c)
#define PLLM_32                          (0x8000)        /* */
#define PLLM_32_H                        (0x0080)
#define PLLM_33                          (0x8400)        /* */
#define PLLM_33_H                        (0x0084)
#define PLLM_34                          (0x8800)        /* */
#define PLLM_34_H                        (0x0088)
#define PLLM_35                          (0x8c00)        /* */
#define PLLM_35_H                        (0x008c)
#define PLLM_36                          (0x9000)        /* */
#define PLLM_36_H                        (0x0090)
#define PLLM_37                          (0x9400)        /* */
#define PLLM_37_H                        (0x0094)
#define PLLM_38                          (0x9800)        /* */
#define PLLM_38_H                        (0x0098)
#define PLLM_39                          (0x9c00)        /* */
#define PLLM_39_H                        (0x009c)
#define PLL_LOCK                         (0x0001)        /* PLL Lock Status */
#define PLL_LOCK_L                       (0x0001)
#define PLL_LOCK_0                       (0x0000)        /* PLL is not running or not locked */
#define PLL_LOCK_1                       (0x0001)        /* PLL is locked */
#define PLL_LOCK_1_L                     (0x0001)
#define PLLINFREQ                        (0x0100)        /* PLL Input Frequency Selection. */
#define PLLINFREQ_H                      (0x0001)
#define PLLINFREQ_0                      (0x0000)        /* Input frequency is equal to 6MHz or lower than 6MHz */
#define PLLINFREQ_1                      (0x0100)        /* Input frequency is higher than 6MHz */
#define PLLINFREQ_1_H                    (0x0001)

/* HSPLLUSSXTLCTL Control Bits */
#define USSXTEN                          (0x0001)        /* USSXT Enable. */
#define USSXTEN_L                        (0x0001)
#define USSXTEN_0                        (0x0000)        /* Disable USSXT Oscillator */
#define USSXTEN_1                        (0x0001)        /* Enable USSXT Oscillator */
#define USSXTEN_1_L                      (0x0001)
#define XTOUTOFF                         (0x0100)        /* USSXT Buffered Output OFF */
#define XTOUTOFF_H                       (0x0001)
#define XTOUTOFF_0                       (0x0000)        /* Enable USSXT buffered output */
#define XTOUTOFF_1                       (0x0100)        /* Disable USSXT buffered output. Default. */
#define XTOUTOFF_1_H                     (0x0001)
#define OSCTYPE                          (0x0200)        /* Reserved */
#define OSCTYPE_H                        (0x0002)
#define OSCTYPE_0                        (0x0000)        /* Gating Counter Length: 4096. It is recommended to use this 
                                                            configuration for crystal resonators.  Note: the counter 
                                                            counts the oscillator clock, so total time can be calculated 
                                                            as Time = 4096 x 1/Oscillator Clock Frequency. */
#define OSCTYPE_1                        (0x0200)        /* Gating Counter Length: 512. It is recommended to use this 
                                                            configuration for ceramic resonators. Note: the counter counts
                                                            the oscillator clock, so total time can be calculated as Time 
                                                            = 512x 1/Oscillator Clock Frequency. */
#define OSCTYPE_1_H                      (0x0002)
#define OSCTYPE__XTAL                    (0x0000)        /* Gating Counter Length: 4096. It is recommended to use this 
                                                            configuration for crystal resonators.  Note: the counter 
                                                            counts the oscillator clock, so total time can be calculated 
                                                            as Time = 4096 x 1/Oscillator Clock Frequency. */
#define OSCTYPE__CERAMIC                 (0x0200)        /* Gating Counter Length: 512. It is recommended to use this 
                                                            configuration for ceramic resonators. Note: the counter counts
                                                            the oscillator clock, so total time can be calculated as Time 
                                                            = 512x 1/Oscillator Clock Frequency. */
#define OSCTYPE__CERAMIC_H               (0x0002)
#define OSCSTATE                         (0x0002)        /* Oscillator Status Bit. */
#define OSCSTATE_L                       (0x0002)
#define OSCSTATE_0                       (0x0000)        /* Oscillator is either not enabled or in the middle of start-up 
                                                            transition. */
#define OSCSTATE_1                       (0x0002)        /* Oscillator has started but is not stable yet. Wait for 
                                                            sufficient time for stabilization. */
#define OSCSTATE_1_L                     (0x0002)


/*****************************************************************************
 LCD_C Registers
*****************************************************************************/

#define __MSP430_HAS_LCD_C__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_LCD_C__ 0x0A00
#define LCD_C_BASE             __MSP430_BASEADDRESS_LCD_C__

sfr_w(LCDCCTL0);                              /* LCD_C control 0 */
sfr_b(LCDCCTL0_L);
sfr_b(LCDCCTL0_H);
sfr_w(LCDCCTL1);                              /* LCD_C control 1 */
sfr_b(LCDCCTL1_L);
sfr_b(LCDCCTL1_H);
sfr_w(LCDCBLKCTL);                            /* LCD_C blinking control */
sfr_b(LCDCBLKCTL_L);
sfr_b(LCDCBLKCTL_H);
sfr_w(LCDCMEMCTL);                            /* LCD_C memory control */
sfr_b(LCDCMEMCTL_L);
sfr_b(LCDCMEMCTL_H);
sfr_w(LCDCVCTL);                              /* LCD_C Voltage Control Register */
sfr_b(LCDCVCTL_L);
sfr_b(LCDCVCTL_H);
sfr_w(LCDCPCTL0);                             /* LCD_C port control 0 */
sfr_b(LCDCPCTL0_L);
sfr_b(LCDCPCTL0_H);
sfr_w(LCDCPCTL1);                             /* LCD_C port control 1 */
sfr_b(LCDCPCTL1_L);
sfr_b(LCDCPCTL1_H);
sfr_w(LCDCPCTL2);                             /* LCD_C port control 2 (256 segments) */
sfr_b(LCDCPCTL2_L);
sfr_b(LCDCPCTL2_H);
sfr_w(LCDCPCTL3);                             /* LCD_C port control 3 (384 segments) */
sfr_b(LCDCPCTL3_L);
sfr_b(LCDCPCTL3_H);
sfr_w(LCDCCPCTL);                             /* LCD_C charge pump control */
sfr_b(LCDCCPCTL_L);
sfr_b(LCDCCPCTL_H);
sfr_w(LCDCIV);                                /* LCD_C interrupt vector */
sfr_b(LCDCIV_L);
sfr_b(LCDCIV_H);
sfr_b(LCDM1);                                 /* LCD memory 1 */

sfr_b(LCDM2);                                 /* LCD memory 2 */

sfr_b(LCDM3);                                 /* LCD memory 3 */

sfr_b(LCDM4);                                 /* LCD memory 4 */

sfr_b(LCDM5);                                 /* LCD memory 5 */

sfr_b(LCDM6);                                 /* LCD memory 6 */

sfr_b(LCDM7);                                 /* LCD memory 7 */

sfr_b(LCDM8);                                 /* LCD memory 8 */

sfr_b(LCDM9);                                 /* LCD memory 9 */

sfr_b(LCDM10);                                /* LCD memory 10 */

sfr_b(LCDM11);                                /* LCD memory 11 */

sfr_b(LCDM12);                                /* LCD memory 12 */

sfr_b(LCDM13);                                /* LCD memory 13 */

sfr_b(LCDM14);                                /* LCD memory 14 */

sfr_b(LCDM15);                                /* LCD memory 15 */

sfr_b(LCDM16);                                /* LCD memory 16 */

sfr_b(LCDM17);                                /* LCD memory 17 */

sfr_b(LCDM18);                                /* LCD memory 18 */

sfr_b(LCDM19);                                /* LCD memory 19 */

sfr_b(LCDM20);                                /* LCD memory 20 */

sfr_b(LCDM21);                                /* LCD memory 21 */

sfr_b(LCDM22);                                /* LCD memory 22 */

sfr_b(LCDM23);                                /* LCD memory 23 */

sfr_b(LCDM24);                                /* LCD memory 24 */

sfr_b(LCDM25);                                /* LCD memory 25 */

sfr_b(LCDM26);                                /* LCD memory 26 */

sfr_b(LCDM27);                                /* LCD memory 27 */

sfr_b(LCDM28);                                /* LCD memory 28 */

sfr_b(LCDM29);                                /* LCD memory 29 */

sfr_b(LCDM30);                                /* LCD memory 30 */

sfr_b(LCDM31);                                /* LCD memory 31 */

sfr_b(LCDM32);                                /* LCD memory 32 */

sfr_b(LCDM33_LCDBM1);                         /* LCD memory 33 / LCD blinking memory 1 */

sfr_b(LCDM34_LCDBM2);                         /* LCD memory 34 / LCD blinking memory 2 */

sfr_b(LCDM35_LCDBM3);                         /* LCD memory 35 / LCD blinking memory 3 */

sfr_b(LCDM36_LCDBM4);                         /* LCD memory 36 / LCD blinking memory 4 */

sfr_b(LCDM37_LCDBM5);                         /* LCD memory 37 / LCD blinking memory 5 */

sfr_b(LCDM38_LCDBM6);                         /* LCD memory 38 / LCD blinking memory 6 */

sfr_b(LCDM39_LCDBM7);                         /* LCD memory 39 / LCD blinking memory 7 */

sfr_b(LCDM40_LCDBM8);                         /* LCD memory 40 / LCD blinking memory 8 */

sfr_b(LCDM41_LCDBM9);                         /* LCD memory 41 / LCD blinking memory 9 */

sfr_b(LCDM42_LCDBM10);                        /* LCD memory 42 / LCD blinking memory 10 */

sfr_b(LCDM43_LCDBM11);                        /* LCD memory 43 / LCD blinking memory 11 */

sfr_b(LCDM44_LCDBM12);                        /* LCD memory 44 / LCD blinking memory 11 */

sfr_b(LCDM45_LCDBM13);                        /* LCD memory 45 / LCD blinking memory 13 */

sfr_b(LCDM46_LCDBM14);                        /* LCD memory 46 / LCD blinking memory 14 */

sfr_b(LCDM47_LCDBM15);                        /* LCD memory 47 / LCD blinking memory 15 */

sfr_b(LCDM48_LCDBM16);                        /* LCD memory 48 / LCD blinking memory 16 */

sfr_b(LCDM49_LCDBM17);                        /* LCD memory 49 / LCD blinking memory 17 */

sfr_b(LCDM50_LCDBM18);                        /* LCD memory 50 / LCD blinking memory 18 */

sfr_b(LCDM51_LCDBM19);                        /* LCD memory 51 / LCD blinking memory 19 */

sfr_b(LCDM52_LCDBM20);                        /* LCD memory 52 / LCD blinking memory 20 */


/* LCD_C Register Offsets */
#define OFS_LCDCCTL0                     (0x0000)
#define OFS_LCDCCTL0_L                   OFS_LCDCCTL0
#define OFS_LCDCCTL0_H                   OFS_LCDCCTL0+1
#define OFS_LCDCCTL1                     (0x0002)
#define OFS_LCDCCTL1_L                   OFS_LCDCCTL1
#define OFS_LCDCCTL1_H                   OFS_LCDCCTL1+1
#define OFS_LCDCBLKCTL                   (0x0004)
#define OFS_LCDCBLKCTL_L                 OFS_LCDCBLKCTL
#define OFS_LCDCBLKCTL_H                 OFS_LCDCBLKCTL+1
#define OFS_LCDCMEMCTL                   (0x0006)
#define OFS_LCDCMEMCTL_L                 OFS_LCDCMEMCTL
#define OFS_LCDCMEMCTL_H                 OFS_LCDCMEMCTL+1
#define OFS_LCDCVCTL                     (0x0008)
#define OFS_LCDCVCTL_L                   OFS_LCDCVCTL
#define OFS_LCDCVCTL_H                   OFS_LCDCVCTL+1
#define OFS_LCDCPCTL0                    (0x000A)
#define OFS_LCDCPCTL0_L                  OFS_LCDCPCTL0
#define OFS_LCDCPCTL0_H                  OFS_LCDCPCTL0+1
#define OFS_LCDCPCTL1                    (0x000C)
#define OFS_LCDCPCTL1_L                  OFS_LCDCPCTL1
#define OFS_LCDCPCTL1_H                  OFS_LCDCPCTL1+1
#define OFS_LCDCPCTL2                    (0x000E)
#define OFS_LCDCPCTL2_L                  OFS_LCDCPCTL2
#define OFS_LCDCPCTL2_H                  OFS_LCDCPCTL2+1
#define OFS_LCDCPCTL3                    (0x0010)
#define OFS_LCDCPCTL3_L                  OFS_LCDCPCTL3
#define OFS_LCDCPCTL3_H                  OFS_LCDCPCTL3+1
#define OFS_LCDCCPCTL                    (0x0012)
#define OFS_LCDCCPCTL_L                  OFS_LCDCCPCTL
#define OFS_LCDCCPCTL_H                  OFS_LCDCCPCTL+1
#define OFS_LCDCIV                       (0x001E)
#define OFS_LCDCIV_L                     OFS_LCDCIV
#define OFS_LCDCIV_H                     OFS_LCDCIV+1
#define OFS_LCDM1                        (0x0020)
#define OFS_LCDM2                        (0x0021)
#define OFS_LCDM3                        (0x0022)
#define OFS_LCDM4                        (0x0023)
#define OFS_LCDM5                        (0x0024)
#define OFS_LCDM6                        (0x0025)
#define OFS_LCDM7                        (0x0026)
#define OFS_LCDM8                        (0x0027)
#define OFS_LCDM9                        (0x0028)
#define OFS_LCDM10                       (0x0029)
#define OFS_LCDM11                       (0x002A)
#define OFS_LCDM12                       (0x002B)
#define OFS_LCDM13                       (0x002C)
#define OFS_LCDM14                       (0x002D)
#define OFS_LCDM15                       (0x002E)
#define OFS_LCDM16                       (0x002F)
#define OFS_LCDM17                       (0x0030)
#define OFS_LCDM18                       (0x0031)
#define OFS_LCDM19                       (0x0032)
#define OFS_LCDM20                       (0x0033)
#define OFS_LCDM21                       (0x0034)
#define OFS_LCDM22                       (0x0035)
#define OFS_LCDM23                       (0x0036)
#define OFS_LCDM24                       (0x0037)
#define OFS_LCDM25                       (0x0038)
#define OFS_LCDM26                       (0x0039)
#define OFS_LCDM27                       (0x003A)
#define OFS_LCDM28                       (0x003B)
#define OFS_LCDM29                       (0x003C)
#define OFS_LCDM30                       (0x003D)
#define OFS_LCDM31                       (0x003E)
#define OFS_LCDM32                       (0x003F)
#define OFS_LCDM33_LCDBM1                (0x0040)
#define OFS_LCDM34_LCDBM2                (0x0041)
#define OFS_LCDM35_LCDBM3                (0x0042)
#define OFS_LCDM36_LCDBM4                (0x0043)
#define OFS_LCDM37_LCDBM5                (0x0044)
#define OFS_LCDM38_LCDBM6                (0x0045)
#define OFS_LCDM39_LCDBM7                (0x0046)
#define OFS_LCDM40_LCDBM8                (0x0047)
#define OFS_LCDM41_LCDBM9                (0x0048)
#define OFS_LCDM42_LCDBM10               (0x0049)
#define OFS_LCDM43_LCDBM11               (0x004A)
#define OFS_LCDM44_LCDBM12               (0x004B)
#define OFS_LCDM45_LCDBM13               (0x004C)
#define OFS_LCDM46_LCDBM14               (0x004D)
#define OFS_LCDM47_LCDBM15               (0x004E)
#define OFS_LCDM48_LCDBM16               (0x004F)
#define OFS_LCDM49_LCDBM17               (0x0050)
#define OFS_LCDM50_LCDBM18               (0x0051)
#define OFS_LCDM51_LCDBM19               (0x0052)
#define OFS_LCDM52_LCDBM20               (0x0053)

/* LCD_C Control Bits */

/* LCDCCTL0 Control Bits */
#define LCDON                            (0x0001)        /* LCD on */
#define LCDON_L                          (0x0001)
#define LCDON_0                          (0x0000)        /* LCD_C module off */
#define LCDON_1                          (0x0001)        /* LCD_C module on */
#define LCDON_1_L                        (0x0001)
#define LCDON__OFF                       (0x0000)        /* LCD_C module off */
#define LCDON__ON                        (0x0001)        /* LCD_C module on */
#define LCDON__ON_L                      (0x0001)
#define LCDLP                            (0x0002)        /* LCD low-power waveform */
#define LCDLP_L                          (0x0002)
#define LCDLP_0                          (0x0000)        /* Standard LCD waveforms on segment and common lines selected */
#define LCDLP_1                          (0x0002)        /* Low-power LCD waveforms on segment and common lines selected */
#define LCDLP_1_L                        (0x0002)
#define LCDSON                           (0x0004)        /* LCD segments on */
#define LCDSON_L                         (0x0004)
#define LCDSON_0                         (0x0000)        /* All LCD segments are off */
#define LCDSON_1                         (0x0004)        /* All LCD segments are enabled and on or off according to their 
                                                            corresponding memory location */
#define LCDSON_1_L                       (0x0004)
#define LCDSON__OFF                      (0x0000)        /* All LCD segments are off */
#define LCDSON__ON                       (0x0004)        /* All LCD segments are enabled and on or off according to their 
                                                            corresponding memory location */
#define LCDSON__ON_L                     (0x0004)
#define LCDMX                            (0x0038)        /* LCD mux rate */
#define LCDMX_L                          (0x0038)
#define LCDMX0                           (0x0008)        /* LCD mux rate */
#define LCDMX0_L                         (0x0008)
#define LCDMX1                           (0x0010)        /* LCD mux rate */
#define LCDMX1_L                         (0x0010)
#define LCDMX2                           (0x0020)        /* LCD mux rate */
#define LCDMX2_L                         (0x0020)
#define LCDMX_0                          (0x0000)        /* Static */
#define LCDMX_1                          (0x0008)        /* 2-mux */
#define LCDMX_1_L                        (0x0008)
#define LCDMX_2                          (0x0010)        /* 3-mux */
#define LCDMX_2_L                        (0x0010)
#define LCDMX_3                          (0x0018)        /* 4-mux */
#define LCDMX_3_L                        (0x0018)
#define LCDMX_4                          (0x0020)        /* 5-mux */
#define LCDMX_4_L                        (0x0020)
#define LCDMX_5                          (0x0028)        /* 6-mux */
#define LCDMX_5_L                        (0x0028)
#define LCDMX_6                          (0x0030)        /* 7-mux */
#define LCDMX_6_L                        (0x0030)
#define LCDMX_7                          (0x0038)        /* 8-mux */
#define LCDMX_7_L                        (0x0038)
#define LCDMX__STATIC                    (0x0000)        /* Static */
#define LCDMX__2MUX                      (0x0008)        /* 2-mux */
#define LCDMX__2MUX_L                    (0x0008)
#define LCDMX__3MUX                      (0x0010)        /* 3-mux */
#define LCDMX__3MUX_L                    (0x0010)
#define LCDMX__4MUX                      (0x0018)        /* 4-mux */
#define LCDMX__4MUX_L                    (0x0018)
#define LCDMX__5MUX                      (0x0020)        /* 5-mux */
#define LCDMX__5MUX_L                    (0x0020)
#define LCDMX__6MUX                      (0x0028)        /* 6-mux */
#define LCDMX__6MUX_L                    (0x0028)
#define LCDMX__7MUX                      (0x0030)        /* 7-mux */
#define LCDMX__7MUX_L                    (0x0030)
#define LCDMX__8MUX                      (0x0038)        /* 8-mux */
#define LCDMX__8MUX_L                    (0x0038)
#define LCDSSEL                          (0x0080)        /* Clock source select for LCD and blinking frequency */
#define LCDSSEL_L                        (0x0080)
#define LCDSSEL_0                        (0x0000)        /* ACLK (30 kHz to 40 kHz) */
#define LCDSSEL_1                        (0x0080)        /* VLOCLK */
#define LCDSSEL_1_L                      (0x0080)
#define LCDSSEL__ACLK                    (0x0000)        /* ACLK (30 kHz to 40 kHz) */
#define LCDSSEL__VLOCLK                  (0x0080)        /* VLOCLK */
#define LCDSSEL__VLOCLK_L                (0x0080)
#define LCDPRE                           (0x0700)        /* LCD frequency pre-scaler */
#define LCDPRE_H                         (0x0007)
#define LCDPRE0                          (0x0100)        /* LCD frequency pre-scaler */
#define LCDPRE0_H                        (0x0001)
#define LCDPRE1                          (0x0200)        /* LCD frequency pre-scaler */
#define LCDPRE1_H                        (0x0002)
#define LCDPRE2                          (0x0400)        /* LCD frequency pre-scaler */
#define LCDPRE2_H                        (0x0004)
#define LCDPRE_0                         (0x0000)        /* Divide by 1 */
#define LCDPRE_1                         (0x0100)        /* Divide by 2 */
#define LCDPRE_1_H                       (0x0001)
#define LCDPRE_2                         (0x0200)        /* Divide by 4 */
#define LCDPRE_2_H                       (0x0002)
#define LCDPRE_3                         (0x0300)        /* Divide by 8 */
#define LCDPRE_3_H                       (0x0003)
#define LCDPRE_4                         (0x0400)        /* Divide by 16 */
#define LCDPRE_4_H                       (0x0004)
#define LCDPRE_5                         (0x0500)        /* Divide by 32 */
#define LCDPRE_5_H                       (0x0005)
#define LCDPRE__1                        (0x0000)        /* Divide by 1 */
#define LCDPRE__2                        (0x0100)        /* Divide by 2 */
#define LCDPRE__2_H                      (0x0001)
#define LCDPRE__4                        (0x0200)        /* Divide by 4 */
#define LCDPRE__4_H                      (0x0002)
#define LCDPRE__8                        (0x0300)        /* Divide by 8 */
#define LCDPRE__8_H                      (0x0003)
#define LCDPRE__16                       (0x0400)        /* Divide by 16 */
#define LCDPRE__16_H                     (0x0004)
#define LCDPRE__32                       (0x0500)        /* Divide by 32 */
#define LCDPRE__32_H                     (0x0005)
#define LCDDIV                           (0xf800)        /* LCD frequency divider */
#define LCDDIV_H                         (0x00f8)
#define LCDDIV0                          (0x0800)        /* LCD frequency divider */
#define LCDDIV0_H                        (0x0008)
#define LCDDIV1                          (0x1000)        /* LCD frequency divider */
#define LCDDIV1_H                        (0x0010)
#define LCDDIV2                          (0x2000)        /* LCD frequency divider */
#define LCDDIV2_H                        (0x0020)
#define LCDDIV3                          (0x4000)        /* LCD frequency divider */
#define LCDDIV3_H                        (0x0040)
#define LCDDIV4                          (0x8000)        /* LCD frequency divider */
#define LCDDIV4_H                        (0x0080)
#define LCDDIV_0                         (0x0000)        /* Divide by 1 */
#define LCDDIV_1                         (0x0800)        /* Divide by 2 */
#define LCDDIV_1_H                       (0x0008)
#define LCDDIV_2                         (0x1000)        /* Divide by 3 */
#define LCDDIV_2_H                       (0x0010)
#define LCDDIV_3                         (0x1800)        /* Divide by 4 */
#define LCDDIV_3_H                       (0x0018)
#define LCDDIV_4                         (0x2000)        /* Divide by 5 */
#define LCDDIV_4_H                       (0x0020)
#define LCDDIV_5                         (0x2800)        /* Divide by 6 */
#define LCDDIV_5_H                       (0x0028)
#define LCDDIV_6                         (0x3000)        /* Divide by 7 */
#define LCDDIV_6_H                       (0x0030)
#define LCDDIV_7                         (0x3800)        /* Divide by 8 */
#define LCDDIV_7_H                       (0x0038)
#define LCDDIV_8                         (0x4000)        /* Divide by 9 */
#define LCDDIV_8_H                       (0x0040)
#define LCDDIV_9                         (0x4800)        /* Divide by 10 */
#define LCDDIV_9_H                       (0x0048)
#define LCDDIV_10                        (0x5000)        /* Divide by 11 */
#define LCDDIV_10_H                      (0x0050)
#define LCDDIV_11                        (0x5800)        /* Divide by 12 */
#define LCDDIV_11_H                      (0x0058)
#define LCDDIV_12                        (0x6000)        /* Divide by 13 */
#define LCDDIV_12_H                      (0x0060)
#define LCDDIV_13                        (0x6800)        /* Divide by 14 */
#define LCDDIV_13_H                      (0x0068)
#define LCDDIV_14                        (0x7000)        /* Divide by 15 */
#define LCDDIV_14_H                      (0x0070)
#define LCDDIV_15                        (0x7800)        /* Divide by 16 */
#define LCDDIV_15_H                      (0x0078)
#define LCDDIV_16                        (0x8000)        /* Divide by 17 */
#define LCDDIV_16_H                      (0x0080)
#define LCDDIV_17                        (0x8800)        /* Divide by 18 */
#define LCDDIV_17_H                      (0x0088)
#define LCDDIV_18                        (0x9000)        /* Divide by 19 */
#define LCDDIV_18_H                      (0x0090)
#define LCDDIV_19                        (0x9800)        /* Divide by 20 */
#define LCDDIV_19_H                      (0x0098)
#define LCDDIV_20                        (0xa000)        /* Divide by 21 */
#define LCDDIV_20_H                      (0x00a0)
#define LCDDIV_21                        (0xa800)        /* Divide by 22 */
#define LCDDIV_21_H                      (0x00a8)
#define LCDDIV_22                        (0xb000)        /* Divide by 23 */
#define LCDDIV_22_H                      (0x00b0)
#define LCDDIV_23                        (0xb800)        /* Divide by 24 */
#define LCDDIV_23_H                      (0x00b8)
#define LCDDIV_24                        (0xc000)        /* Divide by 25 */
#define LCDDIV_24_H                      (0x00c0)
#define LCDDIV_25                        (0xc800)        /* Divide by 26 */
#define LCDDIV_25_H                      (0x00c8)
#define LCDDIV_26                        (0xd000)        /* Divide by 27 */
#define LCDDIV_26_H                      (0x00d0)
#define LCDDIV_27                        (0xd800)        /* Divide by 28 */
#define LCDDIV_27_H                      (0x00d8)
#define LCDDIV_28                        (0xe000)        /* Divide by 29 */
#define LCDDIV_28_H                      (0x00e0)
#define LCDDIV_29                        (0xe800)        /* Divide by 30 */
#define LCDDIV_29_H                      (0x00e8)
#define LCDDIV_30                        (0xf000)        /* Divide by 31 */
#define LCDDIV_30_H                      (0x00f0)
#define LCDDIV_31                        (0xf800)        /* Divide by 32 */
#define LCDDIV_31_H                      (0x00f8)
#define LCDDIV__1                        (0x0000)        /* Divide by 1 */
#define LCDDIV__2                        (0x0800)        /* Divide by 2 */
#define LCDDIV__2_H                      (0x0008)
#define LCDDIV__3                        (0x1000)        /* Divide by 3 */
#define LCDDIV__3_H                      (0x0010)
#define LCDDIV__4                        (0x1800)        /* Divide by 4 */
#define LCDDIV__4_H                      (0x0018)
#define LCDDIV__5                        (0x2000)        /* Divide by 5 */
#define LCDDIV__5_H                      (0x0020)
#define LCDDIV__6                        (0x2800)        /* Divide by 6 */
#define LCDDIV__6_H                      (0x0028)
#define LCDDIV__7                        (0x3000)        /* Divide by 7 */
#define LCDDIV__7_H                      (0x0030)
#define LCDDIV__8                        (0x3800)        /* Divide by 8 */
#define LCDDIV__8_H                      (0x0038)
#define LCDDIV__9                        (0x4000)        /* Divide by 9 */
#define LCDDIV__9_H                      (0x0040)
#define LCDDIV__10                       (0x4800)        /* Divide by 10 */
#define LCDDIV__10_H                     (0x0048)
#define LCDDIV__11                       (0x5000)        /* Divide by 11 */
#define LCDDIV__11_H                     (0x0050)
#define LCDDIV__12                       (0x5800)        /* Divide by 12 */
#define LCDDIV__12_H                     (0x0058)
#define LCDDIV__13                       (0x6000)        /* Divide by 13 */
#define LCDDIV__13_H                     (0x0060)
#define LCDDIV__14                       (0x6800)        /* Divide by 14 */
#define LCDDIV__14_H                     (0x0068)
#define LCDDIV__15                       (0x7000)        /* Divide by 15 */
#define LCDDIV__15_H                     (0x0070)
#define LCDDIV__16                       (0x7800)        /* Divide by 16 */
#define LCDDIV__16_H                     (0x0078)
#define LCDDIV__17                       (0x8000)        /* Divide by 17 */
#define LCDDIV__17_H                     (0x0080)
#define LCDDIV__18                       (0x8800)        /* Divide by 18 */
#define LCDDIV__18_H                     (0x0088)
#define LCDDIV__19                       (0x9000)        /* Divide by 19 */
#define LCDDIV__19_H                     (0x0090)
#define LCDDIV__20                       (0x9800)        /* Divide by 20 */
#define LCDDIV__20_H                     (0x0098)
#define LCDDIV__21                       (0xa000)        /* Divide by 21 */
#define LCDDIV__21_H                     (0x00a0)
#define LCDDIV__22                       (0xa800)        /* Divide by 22 */
#define LCDDIV__22_H                     (0x00a8)
#define LCDDIV__23                       (0xb000)        /* Divide by 23 */
#define LCDDIV__23_H                     (0x00b0)
#define LCDDIV__24                       (0xb800)        /* Divide by 24 */
#define LCDDIV__24_H                     (0x00b8)
#define LCDDIV__25                       (0xc000)        /* Divide by 25 */
#define LCDDIV__25_H                     (0x00c0)
#define LCDDIV__26                       (0xc800)        /* Divide by 26 */
#define LCDDIV__26_H                     (0x00c8)
#define LCDDIV__27                       (0xd000)        /* Divide by 27 */
#define LCDDIV__27_H                     (0x00d0)
#define LCDDIV__28                       (0xd800)        /* Divide by 28 */
#define LCDDIV__28_H                     (0x00d8)
#define LCDDIV__29                       (0xe000)        /* Divide by 29 */
#define LCDDIV__29_H                     (0x00e0)
#define LCDDIV__30                       (0xe800)        /* Divide by 30 */
#define LCDDIV__30_H                     (0x00e8)
#define LCDDIV__31                       (0xf000)        /* Divide by 31 */
#define LCDDIV__31_H                     (0x00f0)
#define LCDDIV__32                       (0xf800)        /* Divide by 32 */
#define LCDDIV__32_H                     (0x00f8)

/* LCDCCTL1 Control Bits */
#define LCDFRMIFG                        (0x0001)        /* LCD frame interrupt flag */
#define LCDFRMIFG_L                      (0x0001)
#define LCDFRMIFG_0                      (0x0000)        /* No interrupt pending */
#define LCDFRMIFG_1                      (0x0001)        /* Interrupt pending */
#define LCDFRMIFG_1_L                    (0x0001)
#define LCDBLKOFFIFG                     (0x0002)        /* LCD blinking interrupt flag, segments switched off */
#define LCDBLKOFFIFG_L                   (0x0002)
#define LCDBLKOFFIFG_0                   (0x0000)        /* No interrupt pending */
#define LCDBLKOFFIFG_1                   (0x0002)        /* Interrupt pending */
#define LCDBLKOFFIFG_1_L                 (0x0002)
#define LCDBLKONIFG                      (0x0004)        /* LCD blinking interrupt flag, segments switched on */
#define LCDBLKONIFG_L                    (0x0004)
#define LCDBLKONIFG_0                    (0x0000)        /* No interrupt pending */
#define LCDBLKONIFG_1                    (0x0004)        /* Interrupt pending */
#define LCDBLKONIFG_1_L                  (0x0004)
#define LCDNOCAPIFG                      (0x0008)        /* No capacitance connected interrupt flag */
#define LCDNOCAPIFG_L                    (0x0008)
#define LCDNOCAPIFG_0                    (0x0000)        /* No interrupt pending */
#define LCDNOCAPIFG_1                    (0x0008)        /* Interrupt pending */
#define LCDNOCAPIFG_1_L                  (0x0008)
#define LCDFRMIE                         (0x0100)        /* LCD frame interrupt enable */
#define LCDFRMIE_H                       (0x0001)
#define LCDFRMIE_0                       (0x0000)        /* Interrupt disabled */
#define LCDFRMIE_1                       (0x0100)        /* Interrupt enabled */
#define LCDFRMIE_1_H                     (0x0001)
#define LCDBLKOFFIE                      (0x0200)        /* LCD blinking interrupt enable, segments switched off */
#define LCDBLKOFFIE_H                    (0x0002)
#define LCDBLKOFFIE_0                    (0x0000)        /* Interrupt disabled */
#define LCDBLKOFFIE_1                    (0x0200)        /* Interrupt enabled */
#define LCDBLKOFFIE_1_H                  (0x0002)
#define LCDBLKONIE                       (0x0400)        /* LCD blinking interrupt enable, segments switched on */
#define LCDBLKONIE_H                     (0x0004)
#define LCDBLKONIE_0                     (0x0000)        /* Interrupt disabled */
#define LCDBLKONIE_1                     (0x0400)        /* Interrupt enabled */
#define LCDBLKONIE_1_H                   (0x0004)
#define LCDNOCAPIE                       (0x0800)        /* No capacitance connected interrupt enable */
#define LCDNOCAPIE_H                     (0x0008)
#define LCDNOCAPIE_0                     (0x0000)        /* Interrupt disabled */
#define LCDNOCAPIE_1                     (0x0800)        /* Interrupt enabled */
#define LCDNOCAPIE_1_H                   (0x0008)

/* LCDCBLKCTL Control Bits */
#define LCDBLKMOD                        (0x0003)        /* Blinking mode */
#define LCDBLKMOD_L                      (0x0003)
#define LCDBLKMOD0                       (0x0001)        /* Blinking mode */
#define LCDBLKMOD0_L                     (0x0001)
#define LCDBLKMOD1                       (0x0002)        /* Blinking mode */
#define LCDBLKMOD1_L                     (0x0002)
#define LCDBLKMOD_0                      (0x0000)        /* Blinking disabled */
#define LCDBLKMOD_1                      (0x0001)        /* Blinking of individual segments as enabled in blinking memory 
                                                            register LCDBMx. In mux mode >5 blinking is disabled. */
#define LCDBLKMOD_1_L                    (0x0001)
#define LCDBLKMOD_2                      (0x0002)        /* Blinking of all segments */
#define LCDBLKMOD_2_L                    (0x0002)
#define LCDBLKMOD_3                      (0x0003)        /* Switching between display contents as stored in LCDMx and 
                                                            LCDBMx memory registers. In mux mode >5 blinking is disabled. */
#define LCDBLKMOD_3_L                    (0x0003)
#define LCDBLKPRE                        (0x001c)        /* Clock pre-scaler for blinking frequency */
#define LCDBLKPRE_L                      (0x001c)
#define LCDBLKPRE0                       (0x0004)        /* Clock pre-scaler for blinking frequency */
#define LCDBLKPRE0_L                     (0x0004)
#define LCDBLKPRE1                       (0x0008)        /* Clock pre-scaler for blinking frequency */
#define LCDBLKPRE1_L                     (0x0008)
#define LCDBLKPRE2                       (0x0010)        /* Clock pre-scaler for blinking frequency */
#define LCDBLKPRE2_L                     (0x0010)
#define LCDBLKPRE_0                      (0x0000)        /* Divide by 512 */
#define LCDBLKPRE_1                      (0x0004)        /* Divide by 1024 */
#define LCDBLKPRE_1_L                    (0x0004)
#define LCDBLKPRE_2                      (0x0008)        /* Divide by 2048 */
#define LCDBLKPRE_2_L                    (0x0008)
#define LCDBLKPRE_3                      (0x000c)        /* Divide by 4096 */
#define LCDBLKPRE_3_L                    (0x000c)
#define LCDBLKPRE_4                      (0x0010)        /* Divide by 8162 */
#define LCDBLKPRE_4_L                    (0x0010)
#define LCDBLKPRE_5                      (0x0014)        /* Divide by 16384 */
#define LCDBLKPRE_5_L                    (0x0014)
#define LCDBLKPRE_6                      (0x0018)        /* Divide by 32768 */
#define LCDBLKPRE_6_L                    (0x0018)
#define LCDBLKPRE_7                      (0x001c)        /* Divide by 65536 */
#define LCDBLKPRE_7_L                    (0x001c)
#define LCDBLKPRE__512                   (0x0000)        /* Divide by 512 */
#define LCDBLKPRE__1024                  (0x0004)        /* Divide by 1024 */
#define LCDBLKPRE__1024_L                (0x0004)
#define LCDBLKPRE__2048                  (0x0008)        /* Divide by 2048 */
#define LCDBLKPRE__2048_L                (0x0008)
#define LCDBLKPRE__4096                  (0x000c)        /* Divide by 4096 */
#define LCDBLKPRE__4096_L                (0x000c)
#define LCDBLKPRE__8162                  (0x0010)        /* Divide by 8162 */
#define LCDBLKPRE__8162_L                (0x0010)
#define LCDBLKPRE__16384                 (0x0014)        /* Divide by 16384 */
#define LCDBLKPRE__16384_L               (0x0014)
#define LCDBLKPRE__32768                 (0x0018)        /* Divide by 32768 */
#define LCDBLKPRE__32768_L               (0x0018)
#define LCDBLKPRE__65536                 (0x001c)        /* Divide by 65536 */
#define LCDBLKPRE__65536_L               (0x001c)
#define LCDBLKDIV                        (0x00e0)        /* Clock divider for blinking frequency */
#define LCDBLKDIV_L                      (0x00e0)
#define LCDBLKDIV0                       (0x0020)        /* Clock divider for blinking frequency */
#define LCDBLKDIV0_L                     (0x0020)
#define LCDBLKDIV1                       (0x0040)        /* Clock divider for blinking frequency */
#define LCDBLKDIV1_L                     (0x0040)
#define LCDBLKDIV2                       (0x0080)        /* Clock divider for blinking frequency */
#define LCDBLKDIV2_L                     (0x0080)
#define LCDBLKDIV_0                      (0x0000)        /* Divide by 1 */
#define LCDBLKDIV_1                      (0x0020)        /* Divide by 2 */
#define LCDBLKDIV_1_L                    (0x0020)
#define LCDBLKDIV_2                      (0x0040)        /* Divide by 3 */
#define LCDBLKDIV_2_L                    (0x0040)
#define LCDBLKDIV_3                      (0x0060)        /* Divide by 4 */
#define LCDBLKDIV_3_L                    (0x0060)
#define LCDBLKDIV_4                      (0x0080)        /* Divide by 5 */
#define LCDBLKDIV_4_L                    (0x0080)
#define LCDBLKDIV_5                      (0x00a0)        /* Divide by 6 */
#define LCDBLKDIV_5_L                    (0x00a0)
#define LCDBLKDIV_6                      (0x00c0)        /* Divide by 7 */
#define LCDBLKDIV_6_L                    (0x00c0)
#define LCDBLKDIV_7                      (0x00e0)        /* Divide by 8 */
#define LCDBLKDIV_7_L                    (0x00e0)
#define LCDBLKDIV__1                     (0x0000)        /* Divide by 1 */
#define LCDBLKDIV__2                     (0x0020)        /* Divide by 2 */
#define LCDBLKDIV__2_L                   (0x0020)
#define LCDBLKDIV__3                     (0x0040)        /* Divide by 3 */
#define LCDBLKDIV__3_L                   (0x0040)
#define LCDBLKDIV__4                     (0x0060)        /* Divide by 4 */
#define LCDBLKDIV__4_L                   (0x0060)
#define LCDBLKDIV__5                     (0x0080)        /* Divide by 5 */
#define LCDBLKDIV__5_L                   (0x0080)
#define LCDBLKDIV__6                     (0x00a0)        /* Divide by 6 */
#define LCDBLKDIV__6_L                   (0x00a0)
#define LCDBLKDIV__7                     (0x00c0)        /* Divide by 7 */
#define LCDBLKDIV__7_L                   (0x00c0)
#define LCDBLKDIV__8                     (0x00e0)        /* Divide by 8 */
#define LCDBLKDIV__8_L                   (0x00e0)

/* LCDCMEMCTL Control Bits */
#define LCDDISP                          (0x0001)        /* Select LCD memory registers for display */
#define LCDDISP_L                        (0x0001)
#define LCDDISP_0                        (0x0000)        /* Display content of LCD memory registers LCDM */
#define LCDDISP_1                        (0x0001)        /* Display content of LCD blinking memory registers LCDBM */
#define LCDDISP_1_L                      (0x0001)
#define LCDCLRM                          (0x0002)        /* Clear LCD memory */
#define LCDCLRM_L                        (0x0002)
#define LCDCLRM_0                        (0x0000)        /* Contents of LCD memory registers LCDMx remain unchanged */
#define LCDCLRM_1                        (0x0002)        /* Clear content of all LCD memory registers LCDM */
#define LCDCLRM_1_L                      (0x0002)
#define LCDCLRBM                         (0x0004)        /* Clear LCD blinking memory */
#define LCDCLRBM_L                       (0x0004)
#define LCDCLRBM_0                       (0x0000)        /* Contents of blinking memory registers LCDBM remain unchanged */
#define LCDCLRBM_1                       (0x0004)        /* Clear content of all blinking memory registers LCDBM */
#define LCDCLRBM_1_L                     (0x0004)

/* LCDCVCTL Control Bits */
#define LCD2B                            (0x0001)        /* Bias select */
#define LCD2B_L                          (0x0001)
#define LCD2B_0                          (0x0000)        /* 1/3 bias */
#define LCD2B_1                          (0x0001)        /* 1/2 bias */
#define LCD2B_1_L                        (0x0001)
#define VLCDREF                          (0x0006)        /* Charge pump reference select */
#define VLCDREF_L                        (0x0006)
#define VLCDREF0                         (0x0002)        /* Charge pump reference select */
#define VLCDREF0_L                       (0x0002)
#define VLCDREF1                         (0x0004)        /* Charge pump reference select */
#define VLCDREF1_L                       (0x0004)
#define VLCDREF_0                        (0x0000)        /* Internal reference voltage */
#define VLCDREF_1                        (0x0002)        /* External reference voltage */
#define VLCDREF_1_L                      (0x0002)
#define VLCDREF_2                        (0x0004)        /* Internal reference voltage switched to external pin LCDREF/R13 */
#define VLCDREF_2_L                      (0x0004)
#define VLCDREF_3                        (0x0006)        /* Reserved (defaults to external reference voltage) */
#define VLCDREF_3_L                      (0x0006)
#define LCDCPEN                          (0x0008)        /* Charge pump enable */
#define LCDCPEN_L                        (0x0008)
#define LCDCPEN_0                        (0x0000)        /* Charge pump disabled */
#define LCDCPEN_1                        (0x0008)        /* Charge pump enabled when VLCD is generated internally (VLCDEXT
                                                            = 0) and VLCD > 0 or VLCDREF > 0 */
#define LCDCPEN_1_L                      (0x0008)
#define VLCDEXT                          (0x0010)        /* VLCD source select */
#define VLCDEXT_L                        (0x0010)
#define VLCDEXT_0                        (0x0000)        /* VLCD is generated internally */
#define VLCDEXT_1                        (0x0010)        /* VLCD is sourced externally */
#define VLCDEXT_1_L                      (0x0010)
#define LCDEXTBIAS                       (0x0020)        /* V2 to V4 voltage select */
#define LCDEXTBIAS_L                     (0x0020)
#define LCDEXTBIAS_0                     (0x0000)        /* V2 to V4 are generated internally */
#define LCDEXTBIAS_1                     (0x0020)        /* V2 to V4 are sourced externally and the internal bias 
                                                            generator is switched off */
#define LCDEXTBIAS_1_L                   (0x0020)
#define R03EXT                           (0x0040)        /* V5 voltage select */
#define R03EXT_L                         (0x0040)
#define R03EXT_0                         (0x0000)        /* V5 is VSS */
#define R03EXT_1                         (0x0040)        /* V5 is sourced from the R03 pin */
#define R03EXT_1_L                       (0x0040)
#define R03EXT__VSS                      (0x0000)        /* V5 is VSS */
#define R03EXT__R03                      (0x0040)        /* V5 is sourced from the R03 pin */
#define R03EXT__R03_L                    (0x0040)
#define LCDREXT                          (0x0080)        /* V2 to V4 voltage on external Rx3 pins */
#define LCDREXT_L                        (0x0080)
#define LCDREXT_0                        (0x0000)        /* Internally generated V2 to V4 are not switched to pins 
                                                            (LCDEXTBIAS = 0) */
#define LCDREXT_1                        (0x0080)        /* Internally generated V2 to V4 are switched to pins (LCDEXTBIAS
                                                            = 0) */
#define LCDREXT_1_L                      (0x0080)
#define VLCD                             (0x1e00)        /* Charge pump voltage select */
#define VLCD_H                           (0x001e)
#define VLCD0                            (0x0200)        /* Charge pump voltage select */
#define VLCD0_H                          (0x0002)
#define VLCD1                            (0x0400)        /* Charge pump voltage select */
#define VLCD1_H                          (0x0004)
#define VLCD2                            (0x0800)        /* Charge pump voltage select */
#define VLCD2_H                          (0x0008)
#define VLCD3                            (0x1000)        /* Charge pump voltage select */
#define VLCD3_H                          (0x0010)
#define VLCD_0                           (0x0000)        /* Charge pump disabled */
#define VLCD_1                           (0x0200)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V; If VLCDREF = 01 or 11: 
                                                            VLCD = 2.17 * VREF */
#define VLCD_1_H                         (0x0002)
#define VLCD_2                           (0x0400)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_2_H                         (0x0004)
#define VLCD_3                           (0x0600)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_3_H                         (0x0006)
#define VLCD_4                           (0x0800)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_4_H                         (0x0008)
#define VLCD_5                           (0x0a00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_5_H                         (0x000a)
#define VLCD_6                           (0x0c00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_6_H                         (0x000c)
#define VLCD_7                           (0x0e00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_7_H                         (0x000e)
#define VLCD_8                           (0x1000)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_8_H                         (0x0010)
#define VLCD_9                           (0x1200)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_9_H                         (0x0012)
#define VLCD_10                          (0x1400)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_10_H                        (0x0014)
#define VLCD_11                          (0x1600)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_11_H                        (0x0016)
#define VLCD_12                          (0x1800)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_12_H                        (0x0018)
#define VLCD_13                          (0x1a00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_13_H                        (0x001a)
#define VLCD_14                          (0x1c00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD_14_H                        (0x001c)
#define VLCD_15                          (0x1e00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (15  1) * 0.06 V = 3.44
                                                            V; If VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (15  1) * 0.05 
                                                            * VREF = 2.87 * VREF */
#define VLCD_15_H                        (0x001e)
#define VLCD__DISABLED                   (0x0000)        /* Charge pump disabled */
#define VLCD__2_60                       (0x0200)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V; If VLCDREF = 01 or 11: 
                                                            VLCD = 2.17 * VREF */
#define VLCD__2_60_H                     (0x0002)
#define VLCD__2_66                       (0x0400)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_66_H                     (0x0004)
#define VLCD__2_72                       (0x0600)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_72_H                     (0x0006)
#define VLCD__2_78                       (0x0800)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_78_H                     (0x0008)
#define VLCD__2_84                       (0x0a00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_84_H                     (0x000a)
#define VLCD__2_90                       (0x0c00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_90_H                     (0x000c)
#define VLCD__2_96                       (0x0e00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__2_96_H                     (0x000e)
#define VLCD__3_02                       (0x1000)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_02_H                     (0x0010)
#define VLCD__3_08                       (0x1200)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_08_H                     (0x0012)
#define VLCD__3_14                       (0x1400)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_14_H                     (0x0014)
#define VLCD__3_20                       (0x1600)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_20_H                     (0x0016)
#define VLCD__3_26                       (0x1800)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_26_H                     (0x0018)
#define VLCD__3_32                       (0x1a00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_32_H                     (0x001a)
#define VLCD__3_38                       (0x1c00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (VLCD  1) * 0.06 V; If 
                                                            VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (VLCD  1) * 0.05 * 
                                                            VREF */
#define VLCD__3_38_H                     (0x001c)
#define VLCD__3_44                       (0x1e00)        /* If VLCDREF = 00 or 10: VLCD = 2.60 V + (15  1) * 0.06 V = 3.44
                                                            V; If VLCDREF = 01 or 11: VLCD = 2.17 * VREF + (15  1) * 0.05 
                                                            * VREF = 2.87 * VREF */
#define VLCD__3_44_H                     (0x001e)

/* LCDCPCTL0 Control Bits */
#define LCDS0                            (0x0001)        /* LCD segment line 0 enable */
#define LCDS0_L                          (0x0001)
#define LCDS0_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS0_1                          (0x0001)        /* Pins are LCD functions */
#define LCDS0_1_L                        (0x0001)
#define LCDS1                            (0x0002)        /* LCD segment line 1 enable */
#define LCDS1_L                          (0x0002)
#define LCDS1_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS1_1                          (0x0002)        /* Pins are LCD functions */
#define LCDS1_1_L                        (0x0002)
#define LCDS2                            (0x0004)        /* LCD segment line 2 enable */
#define LCDS2_L                          (0x0004)
#define LCDS2_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS2_1                          (0x0004)        /* Pins are LCD functions */
#define LCDS2_1_L                        (0x0004)
#define LCDS3                            (0x0008)        /* LCD segment line 3 enable */
#define LCDS3_L                          (0x0008)
#define LCDS3_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS3_1                          (0x0008)        /* Pins are LCD functions */
#define LCDS3_1_L                        (0x0008)
#define LCDS4                            (0x0010)        /* LCD segment line 4 enable */
#define LCDS4_L                          (0x0010)
#define LCDS4_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS4_1                          (0x0010)        /* Pins are LCD functions */
#define LCDS4_1_L                        (0x0010)
#define LCDS5                            (0x0020)        /* LCD segment line 5 enable */
#define LCDS5_L                          (0x0020)
#define LCDS5_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS5_1                          (0x0020)        /* Pins are LCD functions */
#define LCDS5_1_L                        (0x0020)
#define LCDS6                            (0x0040)        /* LCD segment line 6 enable */
#define LCDS6_L                          (0x0040)
#define LCDS6_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS6_1                          (0x0040)        /* Pins are LCD functions */
#define LCDS6_1_L                        (0x0040)
#define LCDS7                            (0x0080)        /* LCD segment line 7 enable */
#define LCDS7_L                          (0x0080)
#define LCDS7_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS7_1                          (0x0080)        /* Pins are LCD functions */
#define LCDS7_1_L                        (0x0080)
#define LCDS8                            (0x0100)        /* LCD segment line 8 enable */
#define LCDS8_H                          (0x0001)
#define LCDS8_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS8_1                          (0x0100)        /* Pins are LCD functions */
#define LCDS8_1_H                        (0x0001)
#define LCDS9                            (0x0200)        /* LCD segment line 9 enable */
#define LCDS9_H                          (0x0002)
#define LCDS9_0                          (0x0000)        /* Multiplexed pins are port functions */
#define LCDS9_1                          (0x0200)        /* Pins are LCD functions */
#define LCDS9_1_H                        (0x0002)
#define LCDS10                           (0x0400)        /* LCD segment line 10 enable */
#define LCDS10_H                         (0x0004)
#define LCDS10_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS10_1                         (0x0400)        /* Pins are LCD functions */
#define LCDS10_1_H                       (0x0004)
#define LCDS11                           (0x0800)        /* LCD segment line 11 enable */
#define LCDS11_H                         (0x0008)
#define LCDS11_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS11_1                         (0x0800)        /* Pins are LCD functions */
#define LCDS11_1_H                       (0x0008)
#define LCDS12                           (0x1000)        /* LCD segment line 12 enable */
#define LCDS12_H                         (0x0010)
#define LCDS12_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS12_1                         (0x1000)        /* Pins are LCD functions */
#define LCDS12_1_H                       (0x0010)
#define LCDS13                           (0x2000)        /* LCD segment line 13 enable */
#define LCDS13_H                         (0x0020)
#define LCDS13_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS13_1                         (0x2000)        /* Pins are LCD functions */
#define LCDS13_1_H                       (0x0020)
#define LCDS14                           (0x4000)        /* LCD segment line 14 enable */
#define LCDS14_H                         (0x0040)
#define LCDS14_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS14_1                         (0x4000)        /* Pins are LCD functions */
#define LCDS14_1_H                       (0x0040)
#define LCDS15                           (0x8000)        /* LCD segment line 15 enable */
#define LCDS15_H                         (0x0080)
#define LCDS15_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS15_1                         (0x8000)        /* Pins are LCD functions */
#define LCDS15_1_H                       (0x0080)

/* LCDCPCTL1 Control Bits */
#define LCDS16                           (0x0001)        /* LCD segment line 16 enable */
#define LCDS16_L                         (0x0001)
#define LCDS16_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS16_1                         (0x0001)        /* Pins are LCD functions */
#define LCDS16_1_L                       (0x0001)
#define LCDS17                           (0x0002)        /* LCD segment line 17 enable */
#define LCDS17_L                         (0x0002)
#define LCDS17_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS17_1                         (0x0002)        /* Pins are LCD functions */
#define LCDS17_1_L                       (0x0002)
#define LCDS18                           (0x0004)        /* LCD segment line 18 enable */
#define LCDS18_L                         (0x0004)
#define LCDS18_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS18_1                         (0x0004)        /* Pins are LCD functions */
#define LCDS18_1_L                       (0x0004)
#define LCDS19                           (0x0008)        /* LCD segment line 19 enable */
#define LCDS19_L                         (0x0008)
#define LCDS19_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS19_1                         (0x0008)        /* Pins are LCD functions */
#define LCDS19_1_L                       (0x0008)
#define LCDS20                           (0x0010)        /* LCD segment line 20 enable */
#define LCDS20_L                         (0x0010)
#define LCDS20_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS20_1                         (0x0010)        /* Pins are LCD functions */
#define LCDS20_1_L                       (0x0010)
#define LCDS21                           (0x0020)        /* LCD segment line 21 enable */
#define LCDS21_L                         (0x0020)
#define LCDS21_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS21_1                         (0x0020)        /* Pins are LCD functions */
#define LCDS21_1_L                       (0x0020)
#define LCDS22                           (0x0040)        /* LCD segment line 22 enable */
#define LCDS22_L                         (0x0040)
#define LCDS22_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS22_1                         (0x0040)        /* Pins are LCD functions */
#define LCDS22_1_L                       (0x0040)
#define LCDS23                           (0x0080)        /* LCD segment line 23 enable */
#define LCDS23_L                         (0x0080)
#define LCDS23_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS23_1                         (0x0080)        /* Pins are LCD functions */
#define LCDS23_1_L                       (0x0080)
#define LCDS24                           (0x0100)        /* LCD segment line 24 enable */
#define LCDS24_H                         (0x0001)
#define LCDS24_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS24_1                         (0x0100)        /* Pins are LCD functions */
#define LCDS24_1_H                       (0x0001)
#define LCDS25                           (0x0200)        /* LCD segment line 25 enable */
#define LCDS25_H                         (0x0002)
#define LCDS25_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS25_1                         (0x0200)        /* Pins are LCD functions */
#define LCDS25_1_H                       (0x0002)
#define LCDS26                           (0x0400)        /* LCD segment line 26 enable */
#define LCDS26_H                         (0x0004)
#define LCDS26_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS26_1                         (0x0400)        /* Pins are LCD functions */
#define LCDS26_1_H                       (0x0004)
#define LCDS27                           (0x0800)        /* LCD segment line 27 enable */
#define LCDS27_H                         (0x0008)
#define LCDS27_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS27_1                         (0x0800)        /* Pins are LCD functions */
#define LCDS27_1_H                       (0x0008)
#define LCDS28                           (0x1000)        /* LCD segment line 28 enable */
#define LCDS28_H                         (0x0010)
#define LCDS28_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS28_1                         (0x1000)        /* Pins are LCD functions */
#define LCDS28_1_H                       (0x0010)
#define LCDS29                           (0x2000)        /* LCD segment line 29 enable */
#define LCDS29_H                         (0x0020)
#define LCDS29_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS29_1                         (0x2000)        /* Pins are LCD functions */
#define LCDS29_1_H                       (0x0020)
#define LCDS30                           (0x4000)        /* LCD segment line 30 enable */
#define LCDS30_H                         (0x0040)
#define LCDS30_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS30_1                         (0x4000)        /* Pins are LCD functions */
#define LCDS30_1_H                       (0x0040)
#define LCDS31                           (0x8000)        /* LCD segment line 31 enable */
#define LCDS31_H                         (0x0080)
#define LCDS31_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS31_1                         (0x8000)        /* Pins are LCD functions */
#define LCDS31_1_H                       (0x0080)

/* LCDCPCTL2 Control Bits */
#define LCDS32                           (0x0001)        /* LCD segment line 32 enable */
#define LCDS32_L                         (0x0001)
#define LCDS32_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS32_1                         (0x0001)        /* Pins are LCD functions */
#define LCDS32_1_L                       (0x0001)
#define LCDS33                           (0x0002)        /* LCD segment line 33 enable */
#define LCDS33_L                         (0x0002)
#define LCDS33_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS33_1                         (0x0002)        /* Pins are LCD functions */
#define LCDS33_1_L                       (0x0002)
#define LCDS34                           (0x0004)        /* LCD segment line 34 enable */
#define LCDS34_L                         (0x0004)
#define LCDS34_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS34_1                         (0x0004)        /* Pins are LCD functions */
#define LCDS34_1_L                       (0x0004)
#define LCDS35                           (0x0008)        /* LCD segment line 35 enable */
#define LCDS35_L                         (0x0008)
#define LCDS35_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS35_1                         (0x0008)        /* Pins are LCD functions */
#define LCDS35_1_L                       (0x0008)
#define LCDS36                           (0x0010)        /* LCD segment line 36 enable */
#define LCDS36_L                         (0x0010)
#define LCDS36_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS36_1                         (0x0010)        /* Pins are LCD functions */
#define LCDS36_1_L                       (0x0010)
#define LCDS37                           (0x0020)        /* LCD segment line 37 enable */
#define LCDS37_L                         (0x0020)
#define LCDS37_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS37_1                         (0x0020)        /* Pins are LCD functions */
#define LCDS37_1_L                       (0x0020)
#define LCDS38                           (0x0040)        /* LCD segment line 38 enable */
#define LCDS38_L                         (0x0040)
#define LCDS38_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS38_1                         (0x0040)        /* Pins are LCD functions */
#define LCDS38_1_L                       (0x0040)
#define LCDS39                           (0x0080)        /* LCD segment line 39 enable */
#define LCDS39_L                         (0x0080)
#define LCDS39_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS39_1                         (0x0080)        /* Pins are LCD functions */
#define LCDS39_1_L                       (0x0080)
#define LCDS40                           (0x0100)        /* LCD segment line 40 enable */
#define LCDS40_H                         (0x0001)
#define LCDS40_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS40_1                         (0x0100)        /* Pins are LCD functions */
#define LCDS40_1_H                       (0x0001)
#define LCDS41                           (0x0200)        /* LCD segment line 41 enable */
#define LCDS41_H                         (0x0002)
#define LCDS41_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS41_1                         (0x0200)        /* Pins are LCD functions */
#define LCDS41_1_H                       (0x0002)
#define LCDS42                           (0x0400)        /* LCD segment line 42 enable */
#define LCDS42_H                         (0x0004)
#define LCDS42_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS42_1                         (0x0400)        /* Pins are LCD functions */
#define LCDS42_1_H                       (0x0004)
#define LCDS43                           (0x0800)        /* LCD segment line 43 enable */
#define LCDS43_H                         (0x0008)
#define LCDS43_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS43_1                         (0x0800)        /* Pins are LCD functions */
#define LCDS43_1_H                       (0x0008)
#define LCDS44                           (0x1000)        /* LCD segment line 44 enable */
#define LCDS44_H                         (0x0010)
#define LCDS44_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS44_1                         (0x1000)        /* Pins are LCD functions */
#define LCDS44_1_H                       (0x0010)
#define LCDS45                           (0x2000)        /* LCD segment line 45 enable */
#define LCDS45_H                         (0x0020)
#define LCDS45_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS45_1                         (0x2000)        /* Pins are LCD functions */
#define LCDS45_1_H                       (0x0020)
#define LCDS46                           (0x4000)        /* LCD segment line 46 enable */
#define LCDS46_H                         (0x0040)
#define LCDS46_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS46_1                         (0x4000)        /* Pins are LCD functions */
#define LCDS46_1_H                       (0x0040)
#define LCDS47                           (0x8000)        /* LCD segment line 47 enable */
#define LCDS47_H                         (0x0080)
#define LCDS47_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS47_1                         (0x8000)        /* Pins are LCD functions */
#define LCDS47_1_H                       (0x0080)

/* LCDCPCTL3 Control Bits */
#define LCDS48                           (0x0001)        /* LCD segment line 48 enable */
#define LCDS48_L                         (0x0001)
#define LCDS48_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS48_1                         (0x0001)        /* Pins are LCD functions */
#define LCDS48_1_L                       (0x0001)
#define LCDS49                           (0x0002)        /* LCD segment line 49 enable */
#define LCDS49_L                         (0x0002)
#define LCDS49_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS49_1                         (0x0002)        /* Pins are LCD functions */
#define LCDS49_1_L                       (0x0002)
#define LCDS50                           (0x0004)        /* LCD segment line 50 enable */
#define LCDS50_L                         (0x0004)
#define LCDS50_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS50_1                         (0x0004)        /* Pins are LCD functions */
#define LCDS50_1_L                       (0x0004)
#define LCDS51                           (0x0008)        /* LCD segment line 51 enable */
#define LCDS51_L                         (0x0008)
#define LCDS51_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS51_1                         (0x0008)        /* Pins are LCD functions */
#define LCDS51_1_L                       (0x0008)
#define LCDS52                           (0x0010)        /* LCD segment line 52 enable */
#define LCDS52_L                         (0x0010)
#define LCDS52_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS52_1                         (0x0010)        /* Pins are LCD functions */
#define LCDS52_1_L                       (0x0010)
#define LCDS53                           (0x0020)        /* LCD segment line 53 enable */
#define LCDS53_L                         (0x0020)
#define LCDS53_0                         (0x0000)        /* Multiplexed pins are port functions */
#define LCDS53_1                         (0x0020)        /* Pins are LCD functions */
#define LCDS53_1_L                       (0x0020)

/* LCDCCPCTL Control Bits */
#define LCDCPDIS                         (0x00ff)        /* LCD charge pump disable */
#define LCDCPDIS_L                       (0x00ff)
#define LCDCPDIS0                        (0x0001)        /* LCD charge pump disable */
#define LCDCPDIS0_L                      (0x0001)
#define LCDCPDIS1                        (0x0002)        /* LCD charge pump disable */
#define LCDCPDIS1_L                      (0x0002)
#define LCDCPDIS2                        (0x0004)        /* LCD charge pump disable */
#define LCDCPDIS2_L                      (0x0004)
#define LCDCPDIS3                        (0x0008)        /* LCD charge pump disable */
#define LCDCPDIS3_L                      (0x0008)
#define LCDCPDIS4                        (0x0010)        /* LCD charge pump disable */
#define LCDCPDIS4_L                      (0x0010)
#define LCDCPDIS5                        (0x0020)        /* LCD charge pump disable */
#define LCDCPDIS5_L                      (0x0020)
#define LCDCPDIS6                        (0x0040)        /* LCD charge pump disable */
#define LCDCPDIS6_L                      (0x0040)
#define LCDCPDIS7                        (0x0080)        /* LCD charge pump disable */
#define LCDCPDIS7_L                      (0x0080)
#define LCDCPCLKSYNC                     (0x8000)        /* LCD charge pump clock synchronization */
#define LCDCPCLKSYNC_H                   (0x0080)
#define LCDCPCLKSYNC_0                   (0x0000)        /* Synchronization disabled */
#define LCDCPCLKSYNC_1                   (0x8000)        /* Synchronization enabled */
#define LCDCPCLKSYNC_1_H                 (0x0080)

/* LCDCIV Control Bits */
#define LCDCIV0                          (0x0001)        /* LCD_C interrupt vector value */
#define LCDCIV0_L                        (0x0001)
#define LCDCIV1                          (0x0002)        /* LCD_C interrupt vector value */
#define LCDCIV1_L                        (0x0002)
#define LCDCIV2                          (0x0004)        /* LCD_C interrupt vector value */
#define LCDCIV2_L                        (0x0004)
#define LCDCIV3                          (0x0008)        /* LCD_C interrupt vector value */
#define LCDCIV3_L                        (0x0008)
#define LCDCIV4                          (0x0010)        /* LCD_C interrupt vector value */
#define LCDCIV4_L                        (0x0010)
#define LCDCIV5                          (0x0020)        /* LCD_C interrupt vector value */
#define LCDCIV5_L                        (0x0020)
#define LCDCIV6                          (0x0040)        /* LCD_C interrupt vector value */
#define LCDCIV6_L                        (0x0040)
#define LCDCIV7                          (0x0080)        /* LCD_C interrupt vector value */
#define LCDCIV7_L                        (0x0080)
#define LCDCIV8                          (0x0100)        /* LCD_C interrupt vector value */
#define LCDCIV8_H                        (0x0001)
#define LCDCIV9                          (0x0200)        /* LCD_C interrupt vector value */
#define LCDCIV9_H                        (0x0002)
#define LCDCIV10                         (0x0400)        /* LCD_C interrupt vector value */
#define LCDCIV10_H                       (0x0004)
#define LCDCIV11                         (0x0800)        /* LCD_C interrupt vector value */
#define LCDCIV11_H                       (0x0008)
#define LCDCIV12                         (0x1000)        /* LCD_C interrupt vector value */
#define LCDCIV12_H                       (0x0010)
#define LCDCIV13                         (0x2000)        /* LCD_C interrupt vector value */
#define LCDCIV13_H                       (0x0020)
#define LCDCIV14                         (0x4000)        /* LCD_C interrupt vector value */
#define LCDCIV14_H                       (0x0040)
#define LCDCIV15                         (0x8000)        /* LCD_C interrupt vector value */
#define LCDCIV15_H                       (0x0080)
#define LCDCIV_0                         (0x0000)        /* No interrupt pending */
#define LCDCIV_2                         (0x0002)        /* Interrupt Source: No capacitor connected; Interrupt Flag: 
                                                            LCDNOCAPIFG; Interrupt Priority: Highest */
#define LCDCIV_2_L                       (0x0002)
#define LCDCIV_4                         (0x0004)        /* Interrupt Source: Blink, segments off; Interrupt Flag: 
                                                            LCDBLKOFFIFG */
#define LCDCIV_4_L                       (0x0004)
#define LCDCIV_6                         (0x0006)        /* Interrupt Source: Blink, segments on; Interrupt Flag: 
                                                            LCDBLKONIFG */
#define LCDCIV_6_L                       (0x0006)
#define LCDCIV_8                         (0x0008)        /* Interrupt Source: Frame interrupt; Interrupt Flag: LCDFRMIFG; 
                                                            Interrupt Priority: Lowest */
#define LCDCIV_8_L                       (0x0008)
#define LCDCIV__NONE                     (0x0000)        /* No interrupt pending */
#define LCDCIV__LCDNOCAPIFG              (0x0002)        /* Interrupt Source: No capacitor connected; Interrupt Flag: 
                                                            LCDNOCAPIFG; Interrupt Priority: Highest */
#define LCDCIV__LCDNOCAPIFG_L            (0x0002)
#define LCDCIV__LCDBLKOFFIFG             (0x0004)        /* Interrupt Source: Blink, segments off; Interrupt Flag: 
                                                            LCDBLKOFFIFG */
#define LCDCIV__LCDBLKOFFIFG_L           (0x0004)
#define LCDCIV__LCDBLKONIFG              (0x0006)        /* Interrupt Source: Blink, segments on; Interrupt Flag: 
                                                            LCDBLKONIFG */
#define LCDCIV__LCDBLKONIFG_L            (0x0006)
#define LCDCIV__LCDFRMIFG                (0x0008)        /* Interrupt Source: Frame interrupt; Interrupt Flag: LCDFRMIFG; 
                                                            Interrupt Priority: Lowest */
#define LCDCIV__LCDFRMIFG_L              (0x0008)


/*****************************************************************************
 LEA Registers
*****************************************************************************/

#define __MSP430_HAS_LEA__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_LEA__ 0x0A80
#define LEA_BASE               __MSP430_BASEADDRESS_LEA__

sfr_l(LEACAP);                                /* LEA Capability Register */
sfr_w(LEACAPL);
sfr_w(LEACAPH);
sfr_l(LEACNF0);                               /* Configuration Register 0 */
sfr_w(LEACNF0L);
sfr_w(LEACNF0H);
sfr_l(LEACNF1);                               /* Configuration Register 1 */
sfr_w(LEACNF1L);
sfr_w(LEACNF1H);
sfr_l(LEACNF2);                               /* Configuration Register 2 */
sfr_w(LEACNF2L);
sfr_w(LEACNF2H);
sfr_l(LEAMB);                                 /* Memory Bottom Register */
sfr_w(LEAMBL);
sfr_w(LEAMBH);
sfr_l(LEAMT);                                 /* Memory Top Register */
sfr_w(LEAMTL);
sfr_w(LEAMTH);
sfr_l(LEACMA);                                /* Code Memory Access Register */
sfr_w(LEACMAL);
sfr_w(LEACMAH);
sfr_l(LEACMCTL);                              /* Code Memory Control Register */
sfr_w(LEACMCTLL);
sfr_w(LEACMCTLH);
sfr_l(LEACMDSTAT);                            /* LEA Command Status Register */
sfr_w(LEACMDSTATL);
sfr_w(LEACMDSTATH);
sfr_l(LEAS1STAT);                             /* LEA Source 1 Status Register */
sfr_w(LEAS1STATL);
sfr_w(LEAS1STATH);
sfr_l(LEAS0STAT);                             /* LEA Source 0 Status Register */
sfr_w(LEAS0STATL);
sfr_w(LEAS0STATH);
sfr_l(LEADSTSTAT);                            /* LEA Result Status Register */
sfr_w(LEADSTSTATL);
sfr_w(LEADSTSTATH);
sfr_l(LEAPMCTL);                              /* PM Control Register */
sfr_w(LEAPMCTLL);
sfr_w(LEAPMCTLH);
sfr_l(LEAPMDST);                              /* PM Result Register */
sfr_w(LEAPMDSTL);
sfr_w(LEAPMDSTH);
sfr_l(LEAPMS1);                               /* PM Source 1 Register */
sfr_w(LEAPMS1L);
sfr_w(LEAPMS1H);
sfr_l(LEAPMS0);                               /* PM Source 0 Register */
sfr_w(LEAPMS0L);
sfr_w(LEAPMS0H);
sfr_l(LEAPMCB);                               /* PM Command Buffer Register */
sfr_w(LEAPMCBL);
sfr_w(LEAPMCBH);
sfr_l(LEAIFGSET);                             /* Interrupt Flag and Set Register */
sfr_w(LEAIFGSETL);
sfr_w(LEAIFGSETH);
sfr_l(LEAIE);                                 /* Interrupt Enable Register */
sfr_w(LEAIEL);
sfr_w(LEAIEH);
sfr_l(LEAIFG);                                /* Interrupt Flag and Clear Register */
sfr_w(LEAIFGL);
sfr_w(LEAIFGH);
sfr_l(LEAIV);                                 /* Interrupt Vector Register */
sfr_w(LEAIVL);
sfr_w(LEAIVH);

/* LEA Register Offsets */
#define OFS_LEACAP                       (0x0000)
#define OFS_LEACAP_L                     OFS_LEACAP
#define OFS_LEACAP_H                     OFS_LEACAP+2
#define OFS_LEACNF0                      (0x0004)
#define OFS_LEACNF0_L                    OFS_LEACNF0
#define OFS_LEACNF0_H                    OFS_LEACNF0+2
#define OFS_LEACNF1                      (0x0008)
#define OFS_LEACNF1_L                    OFS_LEACNF1
#define OFS_LEACNF1_H                    OFS_LEACNF1+2
#define OFS_LEACNF2                      (0x000C)
#define OFS_LEACNF2_L                    OFS_LEACNF2
#define OFS_LEACNF2_H                    OFS_LEACNF2+2
#define OFS_LEAMB                        (0x0010)
#define OFS_LEAMB_L                      OFS_LEAMB
#define OFS_LEAMB_H                      OFS_LEAMB+2
#define OFS_LEAMT                        (0x0014)
#define OFS_LEAMT_L                      OFS_LEAMT
#define OFS_LEAMT_H                      OFS_LEAMT+2
#define OFS_LEACMA                       (0x0018)
#define OFS_LEACMA_L                     OFS_LEACMA
#define OFS_LEACMA_H                     OFS_LEACMA+2
#define OFS_LEACMCTL                     (0x001C)
#define OFS_LEACMCTL_L                   OFS_LEACMCTL
#define OFS_LEACMCTL_H                   OFS_LEACMCTL+2
#define OFS_LEACMDSTAT                   (0x0028)
#define OFS_LEACMDSTAT_L                 OFS_LEACMDSTAT
#define OFS_LEACMDSTAT_H                 OFS_LEACMDSTAT+2
#define OFS_LEAS1STAT                    (0x002C)
#define OFS_LEAS1STAT_L                  OFS_LEAS1STAT
#define OFS_LEAS1STAT_H                  OFS_LEAS1STAT+2
#define OFS_LEAS0STAT                    (0x0030)
#define OFS_LEAS0STAT_L                  OFS_LEAS0STAT
#define OFS_LEAS0STAT_H                  OFS_LEAS0STAT+2
#define OFS_LEADSTSTAT                   (0x0034)
#define OFS_LEADSTSTAT_L                 OFS_LEADSTSTAT
#define OFS_LEADSTSTAT_H                 OFS_LEADSTSTAT+2
#define OFS_LEAPMCTL                     (0x0040)
#define OFS_LEAPMCTL_L                   OFS_LEAPMCTL
#define OFS_LEAPMCTL_H                   OFS_LEAPMCTL+2
#define OFS_LEAPMDST                     (0x0044)
#define OFS_LEAPMDST_L                   OFS_LEAPMDST
#define OFS_LEAPMDST_H                   OFS_LEAPMDST+2
#define OFS_LEAPMS1                      (0x0048)
#define OFS_LEAPMS1_L                    OFS_LEAPMS1
#define OFS_LEAPMS1_H                    OFS_LEAPMS1+2
#define OFS_LEAPMS0                      (0x004C)
#define OFS_LEAPMS0_L                    OFS_LEAPMS0
#define OFS_LEAPMS0_H                    OFS_LEAPMS0+2
#define OFS_LEAPMCB                      (0x0050)
#define OFS_LEAPMCB_L                    OFS_LEAPMCB
#define OFS_LEAPMCB_H                    OFS_LEAPMCB+2
#define OFS_LEAIFGSET                    (0x0070)
#define OFS_LEAIFGSET_L                  OFS_LEAIFGSET
#define OFS_LEAIFGSET_H                  OFS_LEAIFGSET+2
#define OFS_LEAIE                        (0x0074)
#define OFS_LEAIE_L                      OFS_LEAIE
#define OFS_LEAIE_H                      OFS_LEAIE+2
#define OFS_LEAIFG                       (0x0078)
#define OFS_LEAIFG_L                     OFS_LEAIFG
#define OFS_LEAIFG_H                     OFS_LEAIFG+2
#define OFS_LEAIV                        (0x007C)
#define OFS_LEAIV_L                      OFS_LEAIV
#define OFS_LEAIV_H                      OFS_LEAIV+2

/* LEA Control Bits */

/* LEACAP Control Bits */
#define LEAMSIZ                          (0x0000000f)    /* */
#define LEAMSIZ0                         (0x00000001)    /* */
#define LEAMSIZ1                         (0x00000002)    /* */
#define LEAMSIZ2                         (0x00000004)    /* */
#define LEAMSIZ3                         (0x00000008)    /* */
#define LEAMSIZ_0                        (0x00000000)    /* no code RAM */
#define LEAMSIZ_1                        (0x00000001)    /* 1KB Code RAM */

/* LEACNF0 Control Bits */
#define LEASWRST                         (0x00000001)    /* */
#define LEAFTHOLD                        (0x00000002)    /* */
#define LEAFTHOLD_0                      (0x00000000)    /* LEA transfers continue on faults/NMIs */
#define LEAFTHOLD_1                      (0x00000002)    /* LEA transfers enter HOLD on faults/NMIs */
#define LEALPR                           (0x00000100)    /* */
#define LEALPR_0                         (0x00000000)    /* LEA command execution stops in deep low power modes */
#define LEALPR_1                         (0x00000100)    /* LEA command execution continues in deep low power modes */
#define LEAILPM                          (0x00000400)    /* */
#define LEAILPM_0                        (0x00000000)    /* Interrupt of LEA is suppressed in LPM mode until AM is entered
                                                            then the LEA interrupt is triggered as well */
#define LEAILPM_1                        (0x00000400)    /* Interrupt of LEA is always triggered on completion of an LEA 
                                                            command */
#define LEAILB                           (0x00000800)    /* */
#define LEATIMFLTE                       (0x00002000)    /* */
#define LEATIMFLT_0                      (0x00000000)    /* LEA module timer timeout will not cause a fault indication */
#define LEATIMFLTE_1                     (0x00002000)    /* LEA module timer timeout will cause a fault indication. LEA 
                                                            stops operation and enters "Ready-state". */
#define LEACFLT                          (0x00004000)    /* */
#define LEACFLT_0                        (0x00000000)    /* LEAHPCFLT is disabled */
#define LEACFLT_1                        (0x00004000)    /* LEAHPCFLT is enabled */
#define LEAMEMFLTE                       (0x00008000)    /* */
#define LEAMEMFLTE_0                     (0x00000000)    /* LEA memory faults are disabled */
#define LEAMEMFLTE_1                     (0x00008000)    /* LEA memory faults are enabled */
#define LEADONES                         (0x00010000)    /* */
#define LEAFREES                         (0x00020000)    /* */
#define LEATIMFLTS                       (0x00200000)    /* */
#define LEACFLTS                         (0x00400000)    /* */
#define LEACFLTS_0                       (0x00000000)    /* No command fault occurred since this bit was cleared */
#define LEACFLTS_1                       (0x00400000)    /* At least one command fault occurred since this bit was cleared */
#define LEAMEMFLTS                       (0x00800000)    /* */
#define LEAMEMFLTS_0                     (0x00000000)    /* No memory fault occurred since this bit was cleared */
#define LEAMEMFLTS_1                     (0x00800000)    /* At least one memory fault since this bit was cleared */
#define LEATRST                          (0x01000000)    /* */
#define LEATEN                           (0x02000000)    /* */
#define LEATISEL0                        (0x10000000)    /* LEATISEL Bit 0 */
#define LEATISEL1                        (0x20000000)    /* LEATISEL Bit 1 */
#define LEATISEL2                        (0x40000000)    /* LEATISEL Bit 2 */
#define LEATISEL3                        (0x80000000)    /* LEATISEL Bit 3 */
#define LEATISEL                         (0xf0000000)    /* */
#define LEATISEL_0                       (0x00000000)    /* Timeout period: 128 x t#sub#CLK#/sub# (16 us at 8 MHz); 
                                                            Interval period: 256 x t#sub#CLK#/sub# (32 us at 8 MHz) */
#define LEATISEL_1                       (0x10000000)    /* Timeout period: 256 x t#sub#CLK#/sub# (32 us at 8 MHz); 
                                                            Interval period: 512 x t#sub#CLK#/sub# (64 us at 8 MHz) */
#define LEATISEL_2                       (0x20000000)    /* Timeout period: 512 x t#sub#CLK#/sub# (64 us at 8 MHz); 
                                                            Interval period: 1024 x t#sub#CLK#/sub# (128 us at 8 MHz) */
#define LEATISEL_3                       (0x30000000)    /* Timeout period: 1024 x t#sub#CLK#/sub# (128 us at 8 MHz); 
                                                            Interval period: 2048 x t#sub#CLK#/sub# (256 us at 8 MHz) */
#define LEATISEL_4                       (0x40000000)    /* Timeout period: 2048 x t#sub#CLK#/sub# (256 us at 8 MHz); 
                                                            Interval period: 4096 x t#sub#CLK#/sub# (512 us at 8 MHz) */
#define LEATISEL_5                       (0x50000000)    /* Timeout period: 4096 x t#sub#CLK#/sub# (512 us at 8 MHz); 
                                                            Interval period: 8192 x t#sub#CLK#/sub# (1ms at 8 MHz) */
#define LEATISEL_6                       (0x60000000)    /* Timeout period: 8192 x t#sub#CLK#/sub# (1 ms at 8 MHz); 
                                                            Interval period: 16384 x t#sub#CLK#/sub# (2 ms at 8 MHz) */
#define LEATISEL_7                       (0x70000000)    /* Timeout period: 16384 x t#sub#CLK#/sub# (2 ms at 8 MHz); 
                                                            Interval period: 32768 x t#sub#CLK#/sub# (4 ms at 8 MHz) */
#define LEATISEL_8                       (0x80000000)    /* Timeout period: 32768 x t#sub#CLK#/sub# (4ms at 8 MHz); 
                                                            Interval period: 65536 x t#sub#CLK#/sub# (8 ms at 8 MHz) */
#define LEATISEL_9                       (0x90000000)    /* Timeout period: 65536 x t#sub#CLK#/sub# (8 ms at 8 MHz); 
                                                            Interval period: 131072 x t#sub#CLK#/sub# (16 ms at 8 MHz) */
#define LEATISEL_10                      (0xa0000000)    /* Timeout period: 131072 x t#sub#CLK#/sub# (16 ms at 8 MHz); 
                                                            Interval period: 262144 x t#sub#CLK#/sub# (32 ms at 8 MHz) */
#define LEATISEL_11                      (0xb0000000)    /* Timeout period: 524288 x t#sub#CLK#/sub# (65 ms at 8 MHz); 
                                                            Interval period: 1048576 x t#sub#CLK#/sub# (131 ms at 8 MHz) */
#define LEATISEL_12                      (0xc0000000)    /* Timeout period: 1048576 x t#sub#CLK#/sub# (131 ms at 8 MHz); 
                                                            Interval period: 2097152 x t#sub#CLK#/sub# (262 ms at 8 MHz) */
#define LEATISEL_13                      (0xd0000000)    /* Timeout period: 2097152 x t#sub#CLK#/sub# (262 ms at 8 MHz); 
                                                            Interval period: 4194304 x t#sub#CLK#/sub# (524 ms at 8 MHz) */
#define LEATISEL_14                      (0xe0000000)    /* Timeout period: 4194304 x t#sub#CLK#/sub# (524 ms at 8 MHz); 
                                                            Interval period: 8388608 x t#sub#CLK#/sub# (1.05 s at 8 MHz) */
#define LEATISEL_15                      (0xf0000000)    /* Timeout period: 8388608 x t#sub#CLK#/sub# (1.05 s at 8 MHz); 
                                                            Interval period: 16777216 x t#sub#CLK#/sub# (2.1 s at 8 MHz) */

/* LEACNF1 Control Bits */
#define LEABUSY                          (0x00000001)    /* */
#define LEABUSY_0                        (0x00000000)    /* LEA is in Ready can accept new commands */
#define LEABUSY_1                        (0x00000001)    /* LEA is busy right now and cannot accept any commands */
#define LEABUSY__READY                   (0x00000000)    /* LEA is in Ready can accept new commands */
#define LEABUSY__BUSY                    (0x00000001)    /* LEA is busy right now and cannot accept any commands */
#define LEAMODE                          (0x000000f0)    /* */
#define LEAMODE0                         (0x00000010)    /* */
#define LEAMODE1                         (0x00000020)    /* */
#define LEAMODE2                         (0x00000040)    /* */
#define LEAMODE3                         (0x00000080)    /* */
#define LEAMODE_0                        (0x00000000)    /* Off (implicit) */
#define LEAMODE_1                        (0x00000010)    /* Ready */
#define LEAMODE_2                        (0x00000020)    /* RunS (SUSPEND) */
#define LEAMODE_3                        (0x00000030)    /* RunR (RESUME) */
#define LEAMODE_4                        (0x00000040)    /* RunA (regular command operation ) */
#define LEAMODE_5                        (0x00000050)    /* Notify */
#define LEAMODE_6                        (0x00000060)    /* Sleep */
#define LEAMODE_7                        (0x00000070)    /* RunL */
#define LEAMODE__OFF                     (0x00000000)    /* Off (implicit) */
#define LEAMODE__READY                   (0x00000010)    /* Ready */
#define LEAMODE__RUNS                    (0x00000020)    /* RunS (SUSPEND) */
#define LEAMODE__RUNR                    (0x00000030)    /* RunR (RESUME) */
#define LEAMODE__RUNA                    (0x00000040)    /* RunA (regular command operation ) */
#define LEAMODE__NOTIFY                  (0x00000050)    /* Notify */
#define LEAMODE__SLEEP                   (0x00000060)    /* Sleep */
#define LEAMODE__RUNL                    (0x00000070)    /* RunL */
#define LEAPWST                          (0x00000f00)    /* */
#define LEAPWST0                         (0x00000100)    /* */
#define LEAPWST1                         (0x00000200)    /* */
#define LEAPWST2                         (0x00000400)    /* */
#define LEAPWST3                         (0x00000800)    /* */
#define LEAASST                          (0x0000f000)    /* */
#define LEAASST0                         (0x00001000)    /* */
#define LEAASST1                         (0x00002000)    /* */
#define LEAASST2                         (0x00004000)    /* */
#define LEAASST3                         (0x00008000)    /* */
#define LEADONEC                         (0x00010000)    /* */
#define LEAFREEC                         (0x00020000)    /* */
#define LEATIMFLTC                       (0x00200000)    /* */
#define LEACFLTC                         (0x00400000)    /* LEA command fault */
#define LEACFLTC_0                       (0x00000000)    /* No command fault occurred since this bit was cleared */
#define LEACFLTC_1                       (0x00400000)    /* At least one command fault occurred since this bit was cleared */
#define LEAMEMFLTC                       (0x00800000)    /* */
#define LEAMEMFLTC_0                     (0x00000000)    /* No memory fault occurred since this bit was cleared */
#define LEAMEMFLTC_1                     (0x00800000)    /* At least one memory fault since this bit was cleared */
#define LEARDSTAT                        (0x0f000000)    /* */
#define LEARDSTAT0                       (0x01000000)    /* */
#define LEARDSTAT1                       (0x02000000)    /* */
#define LEARDSTAT2                       (0x04000000)    /* */
#define LEARDSTAT3                       (0x08000000)    /* */
#define LEAWRSTAT                        (0xf0000000)    /* */
#define LEAWRSTAT0                       (0x10000000)    /* */
#define LEAWRSTAT1                       (0x20000000)    /* */
#define LEAWRSTAT2                       (0x40000000)    /* */
#define LEAWRSTAT3                       (0x80000000)    /* */

/* LEACNF2 Control Bits */
#define LEASPTR                          (0x0000ffff)    /* */
#define LEASPTR0                         (0x00000001)    /* */
#define LEASPTR1                         (0x00000002)    /* */
#define LEASPTR2                         (0x00000004)    /* */
#define LEASPTR3                         (0x00000008)    /* */
#define LEASPTR4                         (0x00000010)    /* */
#define LEASPTR5                         (0x00000020)    /* */
#define LEASPTR6                         (0x00000040)    /* */
#define LEASPTR7                         (0x00000080)    /* */
#define LEASPTR8                         (0x00000100)    /* */
#define LEASPTR9                         (0x00000200)    /* */
#define LEASPTR10                        (0x00000400)    /* */
#define LEASPTR11                        (0x00000800)    /* */
#define LEASPTR12                        (0x00001000)    /* */
#define LEASPTR13                        (0x00002000)    /* */
#define LEASPTR14                        (0x00004000)    /* */
#define LEASPTR15                        (0x00008000)    /* */

/* LEAMB Control Bits */
#define LEAMB0                           (0x00000001)    /* */
#define LEAMB1                           (0x00000002)    /* */
#define LEAMB2                           (0x00000004)    /* */
#define LEAMB3                           (0x00000008)    /* */
#define LEAMB4                           (0x00000010)    /* */
#define LEAMB5                           (0x00000020)    /* */
#define LEAMB6                           (0x00000040)    /* */
#define LEAMB7                           (0x00000080)    /* */
#define LEAMB8                           (0x00000100)    /* */
#define LEAMB9                           (0x00000200)    /* */
#define LEAMB10                          (0x00000400)    /* */
#define LEAMB11                          (0x00000800)    /* */
#define LEAMB12                          (0x00001000)    /* */
#define LEAMB13                          (0x00002000)    /* */
#define LEAMB14                          (0x00004000)    /* */
#define LEAMB15                          (0x00008000)    /* */

/* LEAMT Control Bits */
#define LEAMT0                           (0x00000001)    /* */
#define LEAMT1                           (0x00000002)    /* */
#define LEAMT2                           (0x00000004)    /* */
#define LEAMT3                           (0x00000008)    /* */
#define LEAMT4                           (0x00000010)    /* */
#define LEAMT5                           (0x00000020)    /* */
#define LEAMT6                           (0x00000040)    /* */
#define LEAMT7                           (0x00000080)    /* */
#define LEAMT8                           (0x00000100)    /* */
#define LEAMT9                           (0x00000200)    /* */
#define LEAMT10                          (0x00000400)    /* */
#define LEAMT11                          (0x00000800)    /* */
#define LEAMT12                          (0x00001000)    /* */
#define LEAMT13                          (0x00002000)    /* */
#define LEAMT14                          (0x00004000)    /* */
#define LEAMT15                          (0x00008000)    /* */

/* LEACMA Control Bits */
#define LEACMDP                          (0xffffffff)    /* */
#define LEACMDP0                         (0x00000001)    /* */
#define LEACMDP1                         (0x00000002)    /* */
#define LEACMDP2                         (0x00000004)    /* */
#define LEACMDP3                         (0x00000008)    /* */
#define LEACMDP4                         (0x00000010)    /* */
#define LEACMDP5                         (0x00000020)    /* */
#define LEACMDP6                         (0x00000040)    /* */
#define LEACMDP7                         (0x00000080)    /* */
#define LEACMDP8                         (0x00000100)    /* */
#define LEACMDP9                         (0x00000200)    /* */
#define LEACMDP10                        (0x00000400)    /* */
#define LEACMDP11                        (0x00000800)    /* */
#define LEACMDP12                        (0x00001000)    /* */
#define LEACMDP13                        (0x00002000)    /* */
#define LEACMDP14                        (0x00004000)    /* */
#define LEACMDP15                        (0x00008000)    /* */
#define LEACMDP16                        (0x00010000)    /* */
#define LEACMDP17                        (0x00020000)    /* */
#define LEACMDP18                        (0x00040000)    /* */
#define LEACMDP19                        (0x00080000)    /* */
#define LEACMDP20                        (0x00100000)    /* */
#define LEACMDP21                        (0x00200000)    /* */
#define LEACMDP22                        (0x00400000)    /* */
#define LEACMDP23                        (0x00800000)    /* */
#define LEACMDP24                        (0x01000000)    /* */
#define LEACMDP25                        (0x02000000)    /* */
#define LEACMDP26                        (0x04000000)    /* */
#define LEACMDP27                        (0x08000000)    /* */
#define LEACMDP28                        (0x10000000)    /* */
#define LEACMDP29                        (0x20000000)    /* */
#define LEACMDP30                        (0x40000000)    /* */
#define LEACMDP31                        (0x80000000)    /* */

/* LEACMCTL Control Bits */
#define LEACMAE                          (0x00000001)    /* */
#define LEACMAE_0                        (0x00000000)    /* Code memory access disabled. Accesses to LEA code memory are 
                                                            not possible. LEA does accept commands for execution. Reads to
                                                            LEA code memory will return zeroes and writes are ignored. */
#define LEACMAE_1                        (0x00000001)    /* Code memory access enabled. Accesses to LEA code memory are 
                                                            possible. LEA does not accept commands during this mode 
                                                            (command is ignored). Coprocessor interface accesses by the 
                                                            CPU cause a Coprocessor not available indication. */
#define LEAINC                           (0x00000004)    /* */
#define LEADEC                           (0x00000008)    /* */
#define LEACROFF                         (0x00000030)    /* */
#define LEACROFF0                        (0x00000010)    /* */
#define LEACROFF1                        (0x00000020)    /* */
#define LEACROFF_0                       (0x00000000)    /* Contents of LEA code RAM are retained in LPM3/LPM4. */
#define LEACROFF_1                       (0x00000010)    /* Turns off the LEA code RAM in LPM3/LPM4, re-activates it on 
                                                            wake-up. All data of the code RAM is lost after wakeup from 
                                                            LPM3/LPM4. See the device specific data sheet for presence and
                                                            size of Code RAM. */
#define LEACROFF_2                       (0x00000020)    /* Turns off the code RAM entering LPM3/LPM4, the code RAM sector
                                                            remains off after wake-up. All data of the code RAM is lost. 
                                                            See the device-specific data sheet for presence and size of 
                                                            Code RAM. */
#define LEACROFF_3                       (0x00000030)    /* Reserved (Future: Turns off the code RAM immediately. All data
                                                            of the Code RAM is lost. See the device-specific data sheet 
                                                            for presence and size of Code RAM.) */
#define LEACRACTION                      (0x00000040)    /* Code RAM action */
#define LEACMAP                          (0xffff0000)    /* */
#define LEACMAP0                         (0x00010000)    /* */
#define LEACMAP1                         (0x00020000)    /* */
#define LEACMAP2                         (0x00040000)    /* */
#define LEACMAP3                         (0x00080000)    /* */
#define LEACMAP4                         (0x00100000)    /* */
#define LEACMAP5                         (0x00200000)    /* */
#define LEACMAP6                         (0x00400000)    /* */
#define LEACMAP7                         (0x00800000)    /* */
#define LEACMAP8                         (0x01000000)    /* */
#define LEACMAP9                         (0x02000000)    /* */
#define LEACMAP10                        (0x04000000)    /* */
#define LEACMAP11                        (0x08000000)    /* */
#define LEACMAP12                        (0x10000000)    /* */
#define LEACMAP13                        (0x20000000)    /* */
#define LEACMAP14                        (0x40000000)    /* */
#define LEACMAP15                        (0x80000000)    /* */

/* LEACMDSTAT Control Bits */
#define LEAITFLG                         (0x00000003)    /* */
#define LEAITFLG0                        (0x00000001)    /* */
#define LEAITFLG1                        (0x00000002)    /* */
#define LEAITFLG_0                       (0x00000000)    /* LEA command without any further indication */
#define LEAITFLG_1                       (0x00000001)    /* LEA command with explicit result update */
#define LEAITFLG_2                       (0x00000002)    /* LEA command with interrupt upon completion */
#define LEAITFLG_3                       (0x00000003)    /* LEA command with interrupt and explicit result update */
#define LEACMD                           (0x000003fc)    /* */
#define LEACMD0                          (0x00000004)    /* */
#define LEACMD1                          (0x00000008)    /* */
#define LEACMD2                          (0x00000010)    /* */
#define LEACMD3                          (0x00000020)    /* */
#define LEACMD4                          (0x00000040)    /* */
#define LEACMD5                          (0x00000080)    /* */
#define LEACMD6                          (0x00000100)    /* */
#define LEACMD7                          (0x00000200)    /* */
#define LEACMD_0                         (0x00000000)    /* Suspends ongoing action an enters Ready */
#define LEACMD_2                         (0x00000008)    /* Resumes an previously suspended command execution */
#define LEACMD_4                         (0x00000010)    /* Complex FFT on 16 bit fractional numbers fix scaling */
#define LEACMD_6                         (0x00000018)    /* Real FIR on 16 bit fractional numbers */
#define LEACMD_8                         (0x00000020)    /* Real vector polynomial calculations 16 args all fractional */
#define LEACMD_10                        (0x00000028)    /* Real FFT-extension on 16 bit fractional numbers */
#define LEACMD_12                        (0x00000030)    /* Real vector polynomial calculations 32 bit args all fractional */
#define LEACMD_13                        (0x00000034)    /* Real row oriented matrix multiply */
#define LEACMD_15                        (0x0000003c)    /* Real matrix multiply 16 with 16 to 16 bit fractional */
#define LEACMD_16                        (0x00000040)    /* Real point wise matrix add of 16 and 16 to 16 bit number 
                                                            vector */
#define LEACMD_17                        (0x00000044)    /* Real maximum value and position of 16 bit matrices */
#define LEACMD_18                        (0x00000048)    /* Real minimum value and position of 16 bit matrices */
#define LEACMD_19                        (0x0000004c)    /* Real second order biquad using DF1 with 16 bit fractional */
#define LEACMD_21                        (0x00000054)    /* Real matrix MAC short with 16Bt to 16B fract */
#define LEACMD_22                        (0x00000058)    /* Split 16B vector even to even words */
#define LEACMD_23                        (0x0000005c)    /* Split 16Bt vector even to odd words */
#define LEACMD_24                        (0x00000060)    /* Split 16B vector odd to even words */
#define LEACMD_25                        (0x00000064)    /* Split 16B vector odd to odd words */
#define LEACMD_26                        (0x00000068)    /* Complex Dot Product */
#define LEACMD_27                        (0x0000006c)    /* Complex conjugate Dot Product */
#define LEACMD_28                        (0x00000070)    /* Real point wise matrix Subtraction of 16 and 16 to 16 bit */
#define LEACMD_29                        (0x00000074)    /* Real point wise matrix multiply 32 with 32 to 32 bit 
                                                            fractional */
#define LEACMD_30                        (0x00000078)    /* Complex point wise matrix multiply complex with complex */
#define LEACMD_31                        (0x0000007c)    /* Real point wise matrix add of 32 and 32 to 32 bit number */
#define LEACMD_32                        (0x00000080)    /* List move 32 to 32 bit */
#define LEACMD_33                        (0x00000084)    /* Complex bit reversal for 16 bit fractional numbers even */
#define LEACMD_34                        (0x00000088)    /* Complex bit reversal for 16 bit fractional Numbers odd */
#define LEACMD_36                        (0x00000090)    /* Real second order biquad using DF2 with 16 bit fractional, 
                                                            extended to include bias and intermediate state min/max */
#define LEACMD_39                        (0x0000009c)    /* Complex FFT on 32B bit fractional numbers, fix scaling */
#define LEACMD_41                        (0x000000a4)    /* Real FFT-extension on 32 bit fractional numbers */
#define LEACMD_43                        (0x000000ac)    /* Complex bit reversal for 32 bit fractional numbers even */
#define LEACMD_45                        (0x000000b4)    /* Complex bit reversal for 16 bit fractional numbers odd */
#define LEACMD_47                        (0x000000bc)    /* Scalar Polynomial for math on 32bit fractional */
#define LEACMD_48                        (0x000000c0)    /* Complex FFT on 16B bit fractional numbers with auto scaling 
                                                            for enhanced accuracy */
#define LEACMD_50                        (0x000000c8)    /* Real FIR on 32 bit fractional numbers */
#define LEACMD_52                        (0x000000d0)    /* Real block MAC on 32B fractional numbers */
#define LEACMD_53                        (0x000000d4)    /* Real point wise matrix Subtraction of 32 and 32 to 32 bit */
#define LEACMD_54                        (0x000000d8)    /* Real maximum value and position of signed 32B matrices */
#define LEACMD_55                        (0x000000dc)    /* Real minimum value and position of signed 32B matrices */
#define LEACMD_56                        (0x000000e0)    /* Complex FIR on 16B fractional numbers */
#define LEACMD_58                        (0x000000e8)    /* Real maximum value and position of unsigned 16B matrices */
#define LEACMD_59                        (0x000000ec)    /* Real minimum value and position of unsigned 32B matrices */
#define LEACMD_64                        (0x00000100)    /* Real Matrix MAC on 16B fractional */
#define LEACMD_65                        (0x00000104)    /* Vector maximum on 16B signed numbers */
#define LEACMD_66                        (0x00000108)    /* Vector minimum on 16B signed numbers */
#define LEACMD_67                        (0x0000010c)    /* Vector maximum on 16B unsigned numbers */
#define LEACMD_68                        (0x00000110)    /* Vector minimum on 16B unsigned numbers */
#define LEACMD_69                        (0x00000114)    /* Matrix maximum on 32B unsigned numbers */
#define LEACMD_70                        (0x00000118)    /* Matrix minimum on 32B unsigned numbers */
#define LEACMD_71                        (0x0000011c)    /* Real second order biquad using DF2 with 16 bit fractional */
#define LEACMD_73                        (0x00000124)    /* Complex FIR on 32B fractional numbers */
#define LEACMD_75                        (0x0000012c)    /* Split Function on 32B Vectors/Matrices */
#define LEACMD_76                        (0x00000130)    /* In-place symmetrical window on 16B fractional numbers */
#define LEACMD_77                        (0x00000134)    /* Vector MAC at three points, real 16-bit with 32-bit result */
#define LEACMD_78                        (0x00000138)    /* Scaled vector multiply and accumulate (MAC) */
#define LEACMD_79                        (0x0000013c)    /* Scaled FIR, 16-bit real fractional numbers */
#define LEACMD__SUSPEND                  (0x00000000)    /* Suspends ongoing action an enters Ready */
#define LEACMD__RESUME                   (0x00000008)    /* Resumes an previously suspended command execution */
#define LEACMD__FFTCOMPLEXFIXEDSCALING   (0x00000010)    /* Complex FFT on 16 bit fractional numbers fix scaling */
#define LEACMD__FIR                      (0x00000018)    /* Real FIR on 16 bit fractional numbers */
#define LEACMD__POLYNOMIAL               (0x00000020)    /* Real vector polynomial calculations 16 args all fractional */
#define LEACMD__FFT                      (0x00000028)    /* Real FFT-extension on 16 bit fractional numbers */
#define LEACMD__POLYNOMIALLONG           (0x00000030)    /* Real vector polynomial calculations 32 bit args all fractional */
#define LEACMD__MPYMATRIXROW             (0x00000034)    /* Real row oriented matrix multiply */
#define LEACMD__MPYMATRIX                (0x0000003c)    /* Real matrix multiply 16 with 16 to 16 bit fractional */
#define LEACMD__ADDMATRIX                (0x00000040)    /* Real point wise matrix add of 16 and 16 to 16 bit number 
                                                            vector */
#define LEACMD__MAXMATRIX                (0x00000044)    /* Real maximum value and position of 16 bit matrices */
#define LEACMD__MINMATRIX                (0x00000048)    /* Real minimum value and position of 16 bit matrices */
#define LEACMD__IIRBQ1                   (0x0000004c)    /* Real second order biquad using DF1 with 16 bit fractional */
#define LEACMD__MAC                      (0x00000054)    /* Real matrix MAC short with 16Bt to 16B fract */
#define LEACMD__DEINTERLEAVEEVENEVEN     (0x00000058)    /* Split 16B vector even to even words */
#define LEACMD__DEINTERLEAVEEVENODD      (0x0000005c)    /* Split 16Bt vector even to odd words */
#define LEACMD__DEINTERLEAVEODDEVEN      (0x00000060)    /* Split 16B vector odd to even words */
#define LEACMD__DEINTERLEAVEODDODD       (0x00000064)    /* Split 16B vector odd to odd words */
#define LEACMD__MACCOMPLEXMATRIX         (0x00000068)    /* Complex Dot Product */
#define LEACMD__MACCOMPLEXCONJUGATEMATRIX (0x0000006c)    /* Complex conjugate Dot Product */
#define LEACMD__SUBMATRIX                (0x00000070)    /* Real point wise matrix Subtraction of 16 and 16 to 16 bit */
#define LEACMD__MPYLONGMATRIX            (0x00000074)    /* Real point wise matrix multiply 32 with 32 to 32 bit 
                                                            fractional */
#define LEACMD__MPYCOMPLEXMATRIX         (0x00000078)    /* Complex point wise matrix multiply complex with complex */
#define LEACMD__ADDLONGMATRIX            (0x0000007c)    /* Real point wise matrix add of 32 and 32 to 32 bit number */
#define LEACMD__MOVELONGLIST             (0x00000080)    /* List move 32 to 32 bit */
#define LEACMD__BITREVERSECOMPLEXEVEN    (0x00000084)    /* Complex bit reversal for 16 bit fractional numbers even */
#define LEACMD__BITREVERSECOMPLEXODD     (0x00000088)    /* Complex bit reversal for 16 bit fractional Numbers odd */
#define LEACMD__IIRBQ2EXTENDED           (0x00000090)    /* Real second order biquad using DF2 with 16 bit fractional, 
                                                            extended to include bias and intermediate state min/max */
#define LEACMD__FFTCOMPLEXLONG           (0x0000009c)    /* Complex FFT on 32B bit fractional numbers, fix scaling */
#define LEACMD__FFTLONG                  (0x000000a4)    /* Real FFT-extension on 32 bit fractional numbers */
#define LEACMD__BITREVERSECOMPLEXLONGEVEN (0x000000ac)    /* Complex bit reversal for 32 bit fractional numbers even */
#define LEACMD__BITREVERSECOMPLEXLONGODD (0x000000b4)    /* Complex bit reversal for 16 bit fractional numbers odd */
#define LEACMD__POLYNOMIALSCALAR         (0x000000bc)    /* Scalar Polynomial for math on 32bit fractional */
#define LEACMD__FFTCOMPLEXAUTOSCALING    (0x000000c0)    /* Complex FFT on 16B bit fractional numbers with auto scaling 
                                                            for enhanced accuracy */
#define LEACMD__FIRLONG                  (0x000000c8)    /* Real FIR on 32 bit fractional numbers */
#define LEACMD__MACLONGMATRIX            (0x000000d0)    /* Real block MAC on 32B fractional numbers */
#define LEACMD__SUBLONGMATRIX            (0x000000d4)    /* Real point wise matrix Subtraction of 32 and 32 to 32 bit */
#define LEACMD__MAXLONGMATRIX            (0x000000d8)    /* Real maximum value and position of signed 32B matrices */
#define LEACMD__MINLONGMATRIX            (0x000000dc)    /* Real minimum value and position of signed 32B matrices */
#define LEACMD__FIRCOMPLEX               (0x000000e0)    /* Complex FIR on 16B fractional numbers */
#define LEACMD__MAXUNSIGNEDMATRIX        (0x000000e8)    /* Real maximum value and position of unsigned 16B matrices */
#define LEACMD__MINUNSIGNEDMATRIX        (0x000000ec)    /* Real minimum value and position of unsigned 32B matrices */
#define LEACMD__MACMATRIX                (0x00000100)    /* Real Matrix MAC on 16B fractional */
#define LEACMD__MAX                      (0x00000104)    /* Vector maximum on 16B signed numbers */
#define LEACMD__MIN                      (0x00000108)    /* Vector minimum on 16B signed numbers */
#define LEACMD__MAXUNSIGNED              (0x0000010c)    /* Vector maximum on 16B unsigned numbers */
#define LEACMD__MINUNSIGNED              (0x00000110)    /* Vector minimum on 16B unsigned numbers */
#define LEACMD__MAXUNSIGNEDLONGMATRIX    (0x00000114)    /* Matrix maximum on 32B unsigned numbers */
#define LEACMD__MINUNSIGNEDLONGMATRIX    (0x00000118)    /* Matrix minimum on 32B unsigned numbers */
#define LEACMD__IIRBQ2                   (0x0000011c)    /* Real second order biquad using DF2 with 16 bit fractional */
#define LEACMD__FIRCOMPLEXLONG           (0x00000124)    /* Complex FIR on 32B fractional numbers */
#define LEACMD__DEINTERLEAVELONG         (0x0000012c)    /* Split Function on 32B Vectors/Matrices */
#define LEACMD__WINDOW                   (0x00000130)    /* In-place symmetrical window on 16B fractional numbers */
#define LEACMD__MAC3                     (0x00000134)    /* Vector MAC at three points, real 16-bit with 32-bit result */
#define LEACMD__SCALEDMAC                (0x00000138)    /* Scaled vector multiply and accumulate (MAC) */
#define LEACMD__SCALEDFIR                (0x0000013c)    /* Scaled FIR, 16-bit real fractional numbers */

/* LEAS1STAT Control Bits */
#define LEAS1VAL                         (0xffffffff)    /* */
#define LEAS1VAL0                        (0x00000001)    /* */
#define LEAS1VAL1                        (0x00000002)    /* */
#define LEAS1VAL2                        (0x00000004)    /* */
#define LEAS1VAL3                        (0x00000008)    /* */
#define LEAS1VAL4                        (0x00000010)    /* */
#define LEAS1VAL5                        (0x00000020)    /* */
#define LEAS1VAL6                        (0x00000040)    /* */
#define LEAS1VAL7                        (0x00000080)    /* */
#define LEAS1VAL8                        (0x00000100)    /* */
#define LEAS1VAL9                        (0x00000200)    /* */
#define LEAS1VAL10                       (0x00000400)    /* */
#define LEAS1VAL11                       (0x00000800)    /* */
#define LEAS1VAL12                       (0x00001000)    /* */
#define LEAS1VAL13                       (0x00002000)    /* */
#define LEAS1VAL14                       (0x00004000)    /* */
#define LEAS1VAL15                       (0x00008000)    /* */
#define LEAS1VAL16                       (0x00010000)    /* */
#define LEAS1VAL17                       (0x00020000)    /* */
#define LEAS1VAL18                       (0x00040000)    /* */
#define LEAS1VAL19                       (0x00080000)    /* */
#define LEAS1VAL20                       (0x00100000)    /* */
#define LEAS1VAL21                       (0x00200000)    /* */
#define LEAS1VAL22                       (0x00400000)    /* */
#define LEAS1VAL23                       (0x00800000)    /* */
#define LEAS1VAL24                       (0x01000000)    /* */
#define LEAS1VAL25                       (0x02000000)    /* */
#define LEAS1VAL26                       (0x04000000)    /* */
#define LEAS1VAL27                       (0x08000000)    /* */
#define LEAS1VAL28                       (0x10000000)    /* */
#define LEAS1VAL29                       (0x20000000)    /* */
#define LEAS1VAL30                       (0x40000000)    /* */
#define LEAS1VAL31                       (0x80000000)    /* */

/* LEAS0STAT Control Bits */
#define LEAS0VAL                         (0xffffffff)    /* */
#define LEAS0VAL0                        (0x00000001)    /* */
#define LEAS0VAL1                        (0x00000002)    /* */
#define LEAS0VAL2                        (0x00000004)    /* */
#define LEAS0VAL3                        (0x00000008)    /* */
#define LEAS0VAL4                        (0x00000010)    /* */
#define LEAS0VAL5                        (0x00000020)    /* */
#define LEAS0VAL6                        (0x00000040)    /* */
#define LEAS0VAL7                        (0x00000080)    /* */
#define LEAS0VAL8                        (0x00000100)    /* */
#define LEAS0VAL9                        (0x00000200)    /* */
#define LEAS0VAL10                       (0x00000400)    /* */
#define LEAS0VAL11                       (0x00000800)    /* */
#define LEAS0VAL12                       (0x00001000)    /* */
#define LEAS0VAL13                       (0x00002000)    /* */
#define LEAS0VAL14                       (0x00004000)    /* */
#define LEAS0VAL15                       (0x00008000)    /* */
#define LEAS0VAL16                       (0x00010000)    /* */
#define LEAS0VAL17                       (0x00020000)    /* */
#define LEAS0VAL18                       (0x00040000)    /* */
#define LEAS0VAL19                       (0x00080000)    /* */
#define LEAS0VAL20                       (0x00100000)    /* */
#define LEAS0VAL21                       (0x00200000)    /* */
#define LEAS0VAL22                       (0x00400000)    /* */
#define LEAS0VAL23                       (0x00800000)    /* */
#define LEAS0VAL24                       (0x01000000)    /* */
#define LEAS0VAL25                       (0x02000000)    /* */
#define LEAS0VAL26                       (0x04000000)    /* */
#define LEAS0VAL27                       (0x08000000)    /* */
#define LEAS0VAL28                       (0x10000000)    /* */
#define LEAS0VAL29                       (0x20000000)    /* */
#define LEAS0VAL30                       (0x40000000)    /* */
#define LEAS0VAL31                       (0x80000000)    /* */

/* LEAPMCTL Control Bits */
#define LEACMDEN                         (0x00000001)    /* Command enable */
#define LEACMDEN_0                       (0x00000000)    /* Command triggering by writing to LEAPMCB is disabled */
#define LEACMDEN_1                       (0x00000001)    /* Command triggering by writing to LEAPMCB is enabled */
#define LEATRG                           (0x00000080)    /* Command trigger */

/* LEAPMCB Control Bits */
#define LEACTX                           (0xfff00000)    /* */
#define LEACTX0                          (0x00100000)    /* */
#define LEACTX1                          (0x00200000)    /* */
#define LEACTX2                          (0x00400000)    /* */
#define LEACTX3                          (0x00800000)    /* */
#define LEACTX4                          (0x01000000)    /* */
#define LEACTX5                          (0x02000000)    /* */
#define LEACTX6                          (0x04000000)    /* */
#define LEACTX7                          (0x08000000)    /* */
#define LEACTX8                          (0x10000000)    /* */
#define LEACTX9                          (0x20000000)    /* */
#define LEACTX10                         (0x40000000)    /* */
#define LEACTX11                         (0x80000000)    /* */

/* LEAIFGSET Control Bits */
#define LEACOVLIS                        (0x00000001)    /* */
#define LEACOVLIS_0                      (0x00000000)    /* No interrupt pending */
#define LEACOVLIS_1                      (0x00000001)    /* Interrupt pending */
#define LEATIS                           (0x00000002)    /* */
#define LEATIS_0                         (0x00000000)    /* No interrupt pending */
#define LEATIS_1                         (0x00000002)    /* Interrupt pending */
#define LEAOORIS                         (0x00000004)    /* */
#define LEAOORIS_0                       (0x00000000)    /* No interrupt pending */
#define LEAOORIS_1                       (0x00000004)    /* Interrupt pending */
#define LEASDIIS                         (0x00000008)    /* */
#define LEASDIIS_0                       (0x00000000)    /* No interrupt pending */
#define LEASDIIS_1                       (0x00000008)    /* Interrupt pending */
#define LEAPMCMDIS                       (0x00000010)    /* */
#define LEAPMCMDIS_0                     (0x00000000)    /* No interrupt pending */
#define LEAPMCMDIS_1                     (0x00000010)    /* Interrupt pending */

/* LEAIE Control Bits */
#define LEACOVLIE                        (0x00000001)    /* */
#define LEACOVLIE_0                      (0x00000000)    /* Interrupt disabled */
#define LEACOVLIE_1                      (0x00000001)    /* Interrupt enabled */
#define LEATIE                           (0x00000002)    /* */
#define LEATIE_0                         (0x00000000)    /* Interrupt disabled */
#define LEATIE_1                         (0x00000002)    /* Interrupt enabled */
#define LEAOORIE                         (0x00000004)    /* */
#define LEAOORIE_0                       (0x00000000)    /* Interrupt disabled */
#define LEAOORIE_1                       (0x00000004)    /* Interrupt enabled */
#define LEASDIIE                         (0x00000008)    /* */
#define LEASDIIE_0                       (0x00000000)    /* Interrupt disabled */
#define LEASDIIE_1                       (0x00000008)    /* Interrupt enabled */
#define LEAPMCMDIE                       (0x00000010)    /* */
#define LEAPMCMDIE_0                     (0x00000000)    /* Interrupt disabled */
#define LEAPMCMDIE_1                     (0x00000010)    /* Interrupt enabled */

/* LEAIFG Control Bits */
#define LEACOVLIFG                       (0x00000001)    /* */
#define LEACOVLIFG_0                     (0x00000000)    /* No interrupt pending */
#define LEACOVLIFG_1                     (0x00000001)    /* Interrupt pending */
#define LEATIFG                          (0x00000002)    /* */
#define LEATIFG_0                        (0x00000000)    /* No interrupt pending */
#define LEATIFG_1                        (0x00000002)    /* Interrupt pending */
#define LEAOORIFG                        (0x00000004)    /* */
#define LEAOORIFG_0                      (0x00000000)    /* No interrupt pending */
#define LEAOORIFG_1                      (0x00000004)    /* Interrupt pending */
#define LEASDIIFG                        (0x00000008)    /* */
#define LEASDIIFG_0                      (0x00000000)    /* No interrupt pending */
#define LEASDIIFG_1                      (0x00000008)    /* Interrupt pending */
#define LEAPMCMDIFG                      (0x00000010)    /* */
#define LEAPMCMDIFG_0                    (0x00000000)    /* No interrupt pending */
#define LEAPMCMDIFG_1                    (0x00000010)    /* Interrupt pending */

/* LEAIV Control Bits */
#define LEAIV0                           (0x00000001)    /* */
#define LEAIV1                           (0x00000002)    /* */
#define LEAIV2                           (0x00000004)    /* */
#define LEAIV3                           (0x00000008)    /* */
#define LEAIV4                           (0x00000010)    /* */
#define LEAIV5                           (0x00000020)    /* */
#define LEAIV6                           (0x00000040)    /* */
#define LEAIV7                           (0x00000080)    /* */
#define LEAIV_0                          (0x00000000)    /* No interrupt pending */
#define LEAIV_2                          (0x00000002)    /* LEA command overflow */
#define LEAIV_4                          (0x00000004)    /* LEA timer interrupt */
#define LEAIV_6                          (0x00000006)    /* LEA out of range interrupt */
#define LEAIV_8                          (0x00000008)    /* LEA scalar data inconsistency */
#define LEAIV_10                         (0x0000000a)    /* PMCMD complete interrupt */
#define LEAIV__NONE                      (0x00000000)    /* No interrupt pending */
#define LEAIV__COVLIFG                   (0x00000002)    /* LEA command overflow */
#define LEAIV__TIFG                      (0x00000004)    /* LEA timer interrupt */
#define LEAIV__OORIFG                    (0x00000006)    /* LEA out of range interrupt */
#define LEAIV__SDIIFG                    (0x00000008)    /* LEA scalar data inconsistency */
#define LEAIV__PMCMDIFG                  (0x0000000a)    /* PMCMD complete interrupt */


/*****************************************************************************
 MPU Registers
*****************************************************************************/

#define __MSP430_HAS_MPU__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_MPU__ 0x05A0
#define MPU_BASE               __MSP430_BASEADDRESS_MPU__

sfr_w(MPUCTL0);                               /* Memory Protection Unit Control 0 */
sfr_b(MPUCTL0_L);
sfr_b(MPUCTL0_H);
sfr_w(MPUCTL1);                               /* Memory Protection Unit Control 1 */
sfr_b(MPUCTL1_L);
sfr_b(MPUCTL1_H);
sfr_w(MPUSEGB2);                              /* Memory Protection Unit Segmentation Border 2 Register */
sfr_b(MPUSEGB2_L);
sfr_b(MPUSEGB2_H);
sfr_w(MPUSEGB1);                              /* Memory Protection Unit Segmentation Border 1 Register */
sfr_b(MPUSEGB1_L);
sfr_b(MPUSEGB1_H);
sfr_w(MPUSAM);                                /* Memory Protection Unit Segmentation Access Management Register */
sfr_b(MPUSAM_L);
sfr_b(MPUSAM_H);
sfr_w(MPUIPC0);                               /* Memory Protection Unit IP Control 0 Register */
sfr_b(MPUIPC0_L);
sfr_b(MPUIPC0_H);
sfr_w(MPUIPSEGB2);                            /* Memory Protection Unit IP Encapsulation Segment Border 2 
                                                            Register */
sfr_b(MPUIPSEGB2_L);
sfr_b(MPUIPSEGB2_H);
sfr_w(MPUIPSEGB1);                            /* Memory Protection Unit IP Encapsulation Segment Border 1 
                                                            Register */
sfr_b(MPUIPSEGB1_L);
sfr_b(MPUIPSEGB1_H);

/* MPU Register Offsets */
#define OFS_MPUCTL0                      (0x0000)
#define OFS_MPUCTL0_L                    OFS_MPUCTL0
#define OFS_MPUCTL0_H                    OFS_MPUCTL0+1
#define OFS_MPUCTL1                      (0x0002)
#define OFS_MPUCTL1_L                    OFS_MPUCTL1
#define OFS_MPUCTL1_H                    OFS_MPUCTL1+1
#define OFS_MPUSEGB2                     (0x0004)
#define OFS_MPUSEGB2_L                   OFS_MPUSEGB2
#define OFS_MPUSEGB2_H                   OFS_MPUSEGB2+1
#define OFS_MPUSEGB1                     (0x0006)
#define OFS_MPUSEGB1_L                   OFS_MPUSEGB1
#define OFS_MPUSEGB1_H                   OFS_MPUSEGB1+1
#define OFS_MPUSAM                       (0x0008)
#define OFS_MPUSAM_L                     OFS_MPUSAM
#define OFS_MPUSAM_H                     OFS_MPUSAM+1
#define OFS_MPUIPC0                      (0x000A)
#define OFS_MPUIPC0_L                    OFS_MPUIPC0
#define OFS_MPUIPC0_H                    OFS_MPUIPC0+1
#define OFS_MPUIPSEGB2                   (0x000C)
#define OFS_MPUIPSEGB2_L                 OFS_MPUIPSEGB2
#define OFS_MPUIPSEGB2_H                 OFS_MPUIPSEGB2+1
#define OFS_MPUIPSEGB1                   (0x000E)
#define OFS_MPUIPSEGB1_L                 OFS_MPUIPSEGB1
#define OFS_MPUIPSEGB1_H                 OFS_MPUIPSEGB1+1

/* MPU Control Bits */

/* MPUCTL0 Control Bits */
#define MPUENA                           (0x0001)        /* MPU Enable */
#define MPUENA_L                         (0x0001)
#define MPUENA_0                         (0x0000)        /* Disabled */
#define MPUENA_1                         (0x0001)        /* Enabled */
#define MPUENA_1_L                       (0x0001)
#define MPUENA__DISABLE                  (0x0000)        /* Disabled */
#define MPUENA__ENABLE                   (0x0001)        /* Enabled */
#define MPUENA__ENABLE_L                 (0x0001)
#define MPULOCK                          (0x0002)        /* MPU Lock */
#define MPULOCK_L                        (0x0002)
#define MPULOCK_0                        (0x0000)        /* Open */
#define MPULOCK_1                        (0x0002)        /* Locked */
#define MPULOCK_1_L                      (0x0002)
#define MPULOCK__OPEN                    (0x0000)        /* Open */
#define MPULOCK__LOCK                    (0x0002)        /* Locked */
#define MPULOCK__LOCK_L                  (0x0002)
#define MPUSEGIE                         (0x0010)        /* Enable NMI Event if a Segment violation */
#define MPUSEGIE_L                       (0x0010)
#define MPUSEGIE_0                       (0x0000)        /* Segment violation interrupt disabled */
#define MPUSEGIE_1                       (0x0010)        /* Segment violation interrupt enabled */
#define MPUSEGIE_1_L                     (0x0010)
#define MPUSEGIE__DISABLE                (0x0000)        /* Segment violation interrupt disabled */
#define MPUSEGIE__ENABLE                 (0x0010)        /* Segment violation interrupt enabled */
#define MPUSEGIE__ENABLE_L               (0x0010)
#define MPUPW                            (0xa500)        /* MPU Password */
#define MPUPW_H                          (0x00a5)
#define MPUPW0                           (0x0100)        /* MPU Password */
#define MPUPW0_H                         (0x0001)
#define MPUPW1                           (0x0200)        /* MPU Password */
#define MPUPW1_H                         (0x0002)
#define MPUPW2                           (0x0400)        /* MPU Password */
#define MPUPW2_H                         (0x0004)
#define MPUPW3                           (0x0800)        /* MPU Password */
#define MPUPW3_H                         (0x0008)
#define MPUPW4                           (0x1000)        /* MPU Password */
#define MPUPW4_H                         (0x0010)
#define MPUPW5                           (0x2000)        /* MPU Password */
#define MPUPW5_H                         (0x0020)
#define MPUPW6                           (0x4000)        /* MPU Password */
#define MPUPW6_H                         (0x0040)
#define MPUPW7                           (0x8000)        /* MPU Password */
#define MPUPW7_H                         (0x0080)

/* MPUCTL1 Control Bits */
#define MPUSEG1IFG                       (0x0001)        /* Main Memory Segment 1 Violation Interrupt Flag */
#define MPUSEG1IFG_L                     (0x0001)
#define MPUSEG1IFG_0                     (0x0000)        /* No interrupt pending */
#define MPUSEG1IFG_1                     (0x0001)        /* Interrupt pending */
#define MPUSEG1IFG_1_L                   (0x0001)
#define MPUSEG2IFG                       (0x0002)        /* Main Memory Segment 2 Violation Interrupt Flag */
#define MPUSEG2IFG_L                     (0x0002)
#define MPUSEG2IFG_0                     (0x0000)        /* No interrupt pending */
#define MPUSEG2IFG_1                     (0x0002)        /* Interrupt pending */
#define MPUSEG2IFG_1_L                   (0x0002)
#define MPUSEG3IFG                       (0x0004)        /* Main Memory Segment 3 Violation Interrupt Flag */
#define MPUSEG3IFG_L                     (0x0004)
#define MPUSEGIIFG                       (0x0008)        /* User Information Memory Violation Interrupt Flag */
#define MPUSEGIIFG_L                     (0x0008)
#define MPUSEGIIFG_0                     (0x0000)        /* No interrupt pending */
#define MPUSEGIIFG_1                     (0x0008)        /* Interrupt pending */
#define MPUSEGIIFG_1_L                   (0x0008)
#define MPUSEGIPIFG                      (0x0010)        /* IP Encapsulation Access Violation Interrupt Flag */
#define MPUSEGIPIFG_L                    (0x0010)

/* MPUSAM Control Bits */
#define MPUSEG1RE                        (0x0001)        /* MPU Main Memory Segment 1 Read Enable */
#define MPUSEG1RE_L                      (0x0001)
#define MPUSEG1RE_0                      (0x0000)        /* Read on Main Memory Segment 1 causes a violation if MPUSEG1WE 
                                                            = MPUSEG1XE = 0 */
#define MPUSEG1RE_1                      (0x0001)        /* Read on Main Memory Segment 1 is allowed */
#define MPUSEG1RE_1_L                    (0x0001)
#define MPUSEG1RE__DISABLE               (0x0000)        /* Read on Main Memory Segment 1 causes a violation if MPUSEG1WE 
                                                            = MPUSEG1XE = 0 */
#define MPUSEG1RE__ENABLE                (0x0001)        /* Read on Main Memory Segment 1 is allowed */
#define MPUSEG1RE__ENABLE_L              (0x0001)
#define MPUSEG1WE                        (0x0002)        /* MPU Main Memory Segment 1 Write Enable */
#define MPUSEG1WE_L                      (0x0002)
#define MPUSEG1WE_0                      (0x0000)        /* Write on Main Memory Segment 1 causes a violation */
#define MPUSEG1WE_1                      (0x0002)        /* Write on Main Memory Segment 1 is allowed */
#define MPUSEG1WE_1_L                    (0x0002)
#define MPUSEG1WE__DISABLE               (0x0000)        /* Write on Main Memory Segment 1 causes a violation */
#define MPUSEG1WE__ENABLE                (0x0002)        /* Write on Main Memory Segment 1 is allowed */
#define MPUSEG1WE__ENABLE_L              (0x0002)
#define MPUSEG1XE                        (0x0004)        /* MPU Main Memory Segment 1 Execute Enable */
#define MPUSEG1XE_L                      (0x0004)
#define MPUSEG1XE_0                      (0x0000)        /* Execute code on Main Memory Segment 1 causes a violation */
#define MPUSEG1XE_1                      (0x0004)        /* Execute code on Main Memory Segment 1 is allowed */
#define MPUSEG1XE_1_L                    (0x0004)
#define MPUSEG1XE__DISABLE               (0x0000)        /* Execute code on Main Memory Segment 1 causes a violation */
#define MPUSEG1XE__ENABLE                (0x0004)        /* Execute code on Main Memory Segment 1 is allowed */
#define MPUSEG1XE__ENABLE_L              (0x0004)
#define MPUSEG1VS                        (0x0008)        /* MPU Main Memory Segment 1 Violation Select */
#define MPUSEG1VS_L                      (0x0008)
#define MPUSEG1VS_0                      (0x0000)        /* Violation in Main Memory Segment 1 asserts the MPUSEG1IFG bit 
                                                            and executes a SNMI if enabled by MPUSEGIE = 1 */
#define MPUSEG1VS_1                      (0x0008)        /* Violation in Main Memory Segment 1 asserts the MPUSEG1IFG bit 
                                                            and executes a PUC */
#define MPUSEG1VS_1_L                    (0x0008)
#define MPUSEG2RE                        (0x0010)        /* MPU Main Memory Segment 2 Read Enable */
#define MPUSEG2RE_L                      (0x0010)
#define MPUSEG2RE_0                      (0x0000)        /* Read on Main Memory Segment 2 causes a violation if MPUSEG2WE 
                                                            = MPUSEG2XE = 0 */
#define MPUSEG2RE_1                      (0x0010)        /* Read on Main Memory Segment 2 is allowed */
#define MPUSEG2RE_1_L                    (0x0010)
#define MPUSEG2RE__DISABLE               (0x0000)        /* Read on Main Memory Segment 2 causes a violation if MPUSEG2WE 
                                                            = MPUSEG2XE = 0 */
#define MPUSEG2RE__ENABLE                (0x0010)        /* Read on Main Memory Segment 2 is allowed */
#define MPUSEG2RE__ENABLE_L              (0x0010)
#define MPUSEG2WE                        (0x0020)        /* MPU Main Memory Segment 2 Write Enable */
#define MPUSEG2WE_L                      (0x0020)
#define MPUSEG2WE_0                      (0x0000)        /* Write on Main Memory Segment 2 causes a violation */
#define MPUSEG2WE_1                      (0x0020)        /* Write on Main Memory Segment 2 is allowed */
#define MPUSEG2WE_1_L                    (0x0020)
#define MPUSEG2WE__DISABLE               (0x0000)        /* Write on Main Memory Segment 2 causes a violation */
#define MPUSEG2WE__ENABLE                (0x0020)        /* Write on Main Memory Segment 2 is allowed */
#define MPUSEG2WE__ENABLE_L              (0x0020)
#define MPUSEG2XE                        (0x0040)        /* MPU Main Memory Segment 2 Execute Enable */
#define MPUSEG2XE_L                      (0x0040)
#define MPUSEG2XE_0                      (0x0000)        /* Execute code on Main Memory Segment 2 causes a violation */
#define MPUSEG2XE_1                      (0x0040)        /* Execute code on Main Memory Segment 2 is allowed */
#define MPUSEG2XE_1_L                    (0x0040)
#define MPUSEG2XE__DISABLE               (0x0000)        /* Execute code on Main Memory Segment 2 causes a violation */
#define MPUSEG2XE__ENABLE                (0x0040)        /* Execute code on Main Memory Segment 2 is allowed */
#define MPUSEG2XE__ENABLE_L              (0x0040)
#define MPUSEG2VS                        (0x0080)        /* MPU Main Memory Segment 2 Violation Select */
#define MPUSEG2VS_L                      (0x0080)
#define MPUSEG2VS_0                      (0x0000)        /* Violation in Main Memory Segment 2 asserts the MPUSEG2IFG bit 
                                                            and executes a SNMI if enabled by MPUSEGIE = 1 */
#define MPUSEG2VS_1                      (0x0080)        /* Violation in Main Memory Segment 2 asserts the MPUSEG2IFG bit 
                                                            and executes a PUC */
#define MPUSEG2VS_1_L                    (0x0080)
#define MPUSEG3RE                        (0x0100)        /* MPU Main Memory Segment 3 Read Enable */
#define MPUSEG3RE_H                      (0x0001)
#define MPUSEG3RE_0                      (0x0000)        /* Read on Main Memory Segment 3 causes a violation if MPUSEG3WE 
                                                            = MPUSEG3XE = 0 */
#define MPUSEG3RE_1                      (0x0100)        /* Read on Main Memory Segment 3 is allowed */
#define MPUSEG3RE_1_H                    (0x0001)
#define MPUSEG3RE__DISABLE               (0x0000)        /* Read on Main Memory Segment 3 causes a violation if MPUSEG3WE 
                                                            = MPUSEG3XE = 0 */
#define MPUSEG3RE__ENABLE                (0x0100)        /* Read on Main Memory Segment 3 is allowed */
#define MPUSEG3RE__ENABLE_H              (0x0001)
#define MPUSEG3WE                        (0x0200)        /* MPU Main Memory Segment 3 Write Enable */
#define MPUSEG3WE_H                      (0x0002)
#define MPUSEG3WE_0                      (0x0000)        /* Write on Main Memory Segment 3 causes a violation */
#define MPUSEG3WE_1                      (0x0200)        /* Write on Main Memory Segment 3 is allowed */
#define MPUSEG3WE_1_H                    (0x0002)
#define MPUSEG3WE__DISABLE               (0x0000)        /* Write on Main Memory Segment 3 causes a violation */
#define MPUSEG3WE__ENABLE                (0x0200)        /* Write on Main Memory Segment 3 is allowed */
#define MPUSEG3WE__ENABLE_H              (0x0002)
#define MPUSEG3XE                        (0x0400)        /* MPU Main Memory Segment 3 Execute Enable */
#define MPUSEG3XE_H                      (0x0004)
#define MPUSEG3XE_0                      (0x0000)        /* Execute code on Main Memory Segment 3 causes a violation */
#define MPUSEG3XE_1                      (0x0400)        /* Execute code on Main Memory Segment 3 is allowed */
#define MPUSEG3XE_1_H                    (0x0004)
#define MPUSEG3XE__DISABLE               (0x0000)        /* Execute code on Main Memory Segment 3 causes a violation */
#define MPUSEG3XE__ENABLE                (0x0400)        /* Execute code on Main Memory Segment 3 is allowed */
#define MPUSEG3XE__ENABLE_H              (0x0004)
#define MPUSEG3VS                        (0x0800)        /* MPU Main Memory Segment 3 Violation Select */
#define MPUSEG3VS_H                      (0x0008)
#define MPUSEG3VS_0                      (0x0000)        /* Violation in Main Memory Segment 3 asserts the MPUSEG3IFG bit 
                                                            and executes a SNMI if enabled by MPUSEGIE = 1 */
#define MPUSEG3VS_1                      (0x0800)        /* Violation in Main Memory Segment 3 asserts the MPUSEG3IFG bit 
                                                            and executes a PUC */
#define MPUSEG3VS_1_H                    (0x0008)
#define MPUSEGIRE                        (0x1000)        /* MPU User Information Memory Segment Read Enable */
#define MPUSEGIRE_H                      (0x0010)
#define MPUSEGIRE_0                      (0x0000)        /* Read on User Information Memory causes a violation if 
                                                            MPUSEGIWE=MPUSEGIXE=0 */
#define MPUSEGIRE_1                      (0x1000)        /* Read on User Information Memory is allowed */
#define MPUSEGIRE_1_H                    (0x0010)
#define MPUSEGIRE__DISABLE               (0x0000)        /* Read on User Information Memory causes a violation if 
                                                            MPUSEGIWE=MPUSEGIXE=0 */
#define MPUSEGIRE__ENABLE                (0x1000)        /* Read on User Information Memory is allowed */
#define MPUSEGIRE__ENABLE_H              (0x0010)
#define MPUSEGIWE                        (0x2000)        /* MPU User Information Memory Segment Write Enable. */
#define MPUSEGIWE_H                      (0x0020)
#define MPUSEGIWE_0                      (0x0000)        /* Write on User Information Memory causes a violation */
#define MPUSEGIWE_1                      (0x2000)        /* Write on User Information Memory is allowed */
#define MPUSEGIWE_1_H                    (0x0020)
#define MPUSEGIWE__DISABLE               (0x0000)        /* Write on User Information Memory causes a violation */
#define MPUSEGIWE__ENABLE                (0x2000)        /* Write on User Information Memory is allowed */
#define MPUSEGIWE__ENABLE_H              (0x0020)
#define MPUSEGIXE                        (0x4000)        /* MPU User Information Memory Segment Execute Enable */
#define MPUSEGIXE_H                      (0x0040)
#define MPUSEGIXE_0                      (0x0000)        /* Execute code on User Information Memory causes a violation */
#define MPUSEGIXE_1                      (0x4000)        /* Execute code on User Information Memory is allowed */
#define MPUSEGIXE_1_H                    (0x0040)
#define MPUSEGIXE__DISABLE               (0x0000)        /* Execute code on User Information Memory causes a violation */
#define MPUSEGIXE__ENABLE                (0x4000)        /* Execute code on User Information Memory is allowed */
#define MPUSEGIXE__ENABLE_H              (0x0040)
#define MPUSEGIVS                        (0x8000)        /* MPU User Information Memory Segment Violation Select */
#define MPUSEGIVS_H                      (0x0080)
#define MPUSEGIVS_0                      (0x0000)        /* Violation in User Information Memory asserts the MPUSEGIIFG 
                                                            bit and executes a SNMI if enabled by MPUSEGIE =1 */
#define MPUSEGIVS_1                      (0x8000)        /* Violation in User Information Memory asserts the MPUSEGIIFG 
                                                            bit and executes a PUC */
#define MPUSEGIVS_1_H                    (0x0080)

/* MPUIPC0 Control Bits */
#define MPUIPVS                          (0x0020)        /* MPU IP Encapsulation segment Violation Select */
#define MPUIPVS_L                        (0x0020)
#define MPUIPVS_0                        (0x0000)        /* Violation in Main Memory Segment 1 asserts the MPUSEGPIFG bit 
                                                            and executes a SNMI if enabled by MPUSEGIE = 1 */
#define MPUIPVS_1                        (0x0020)        /* Violation in Main Memory Segment 1 asserts the MPUSEGPIFG bit 
                                                            and executes a PUC */
#define MPUIPVS_1_L                      (0x0020)
#define MPUIPENA                         (0x0040)        /* MPU IP Encapsulation Enable */
#define MPUIPENA_L                       (0x0040)
#define MPUIPENA_0                       (0x0000)        /* Disabled */
#define MPUIPENA_1                       (0x0040)        /* Enabled */
#define MPUIPENA_1_L                     (0x0040)
#define MPUIPENA__DISABLE                (0x0000)        /* Disabled */
#define MPUIPENA__ENABLE                 (0x0040)        /* Enabled */
#define MPUIPENA__ENABLE_L               (0x0040)
#define MPUIPLOCK                        (0x0080)        /* MPU IP Encapsulation Lock */
#define MPUIPLOCK_L                      (0x0080)
#define MPUIPLOCK_0                      (0x0000)        /* Open */
#define MPUIPLOCK_1                      (0x0080)        /* Locked */
#define MPUIPLOCK_1_L                    (0x0080)
#define MPUIPLOCK__OPEN                  (0x0000)        /* Open */
#define MPUIPLOCK__LOCK                  (0x0080)        /* Locked */
#define MPUIPLOCK__LOCK_L                (0x0080)


/*****************************************************************************
 MPY32 Registers
*****************************************************************************/

#define __MSP430_HAS_MPY32__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_MPY32__ 0x04C0
#define MPY32_BASE             __MSP430_BASEADDRESS_MPY32__

sfr_w(MPY);                                   /* 16-bit operand one  multiply */
sfr_b(MPY_L);
sfr_b(MPY_H);
sfr_w(MPYS);                                  /* 16-bit operand one  signed multiply */
sfr_b(MPYS_L);
sfr_b(MPYS_H);
sfr_w(MAC);                                   /* 16-bit operand one  multiply accumulate */
sfr_b(MAC_L);
sfr_b(MAC_H);
sfr_w(MACS);                                  /* 16-bit operand one  signed multiply accumulate */
sfr_b(MACS_L);
sfr_b(MACS_H);
sfr_w(OP2);                                   /* 16-bit operand two */
sfr_b(OP2_L);
sfr_b(OP2_H);
sfr_w(RESLO);                                 /* 16x16-bit result low word */
sfr_b(RESLO_L);
sfr_b(RESLO_H);
sfr_w(RESHI);                                 /* 16x16-bit result high word */
sfr_b(RESHI_L);
sfr_b(RESHI_H);
sfr_w(SUMEXT);                                /* 16x16-bit sum extension register */
sfr_b(SUMEXT_L);
sfr_b(SUMEXT_H);
sfr_w(MPY32L);                                /* 32-bit operand 1  multiply  low word */
sfr_b(MPY32L_L);
sfr_b(MPY32L_H);
sfr_w(MPY32H);                                /* 32-bit operand 1  multiply  high word */
sfr_b(MPY32H_L);
sfr_b(MPY32H_H);
sfr_w(MPYS32L);                               /* 32-bit operand 1  signed multiply  low word */
sfr_b(MPYS32L_L);
sfr_b(MPYS32L_H);
sfr_w(MPYS32H);                               /* 32-bit operand 1  signed multiply  high word */
sfr_b(MPYS32H_L);
sfr_b(MPYS32H_H);
sfr_w(MAC32L);                                /* 32-bit operand 1  multiply accumulate  low word */
sfr_b(MAC32L_L);
sfr_b(MAC32L_H);
sfr_w(MAC32H);                                /* 32-bit operand 1  multiply accumulate  high word */
sfr_b(MAC32H_L);
sfr_b(MAC32H_H);
sfr_w(MACS32L);                               /* 32-bit operand 1  signed multiply accumulate  low word */
sfr_b(MACS32L_L);
sfr_b(MACS32L_H);
sfr_w(MACS32H);                               /* 32-bit operand 1  signed multiply accumulate  high word */
sfr_b(MACS32H_L);
sfr_b(MACS32H_H);
sfr_w(OP2L);                                  /* 32-bit operand 2  low word */
sfr_b(OP2L_L);
sfr_b(OP2L_H);
sfr_w(OP2H);                                  /* 32-bit operand 2  high word */
sfr_b(OP2H_L);
sfr_b(OP2H_H);
sfr_w(RES0);                                  /* 32x32-bit result 0  least significant word */
sfr_b(RES0_L);
sfr_b(RES0_H);
sfr_w(RES1);                                  /* 32x32-bit result 1 */
sfr_b(RES1_L);
sfr_b(RES1_H);
sfr_w(RES2);                                  /* 32x32-bit result 2 */
sfr_b(RES2_L);
sfr_b(RES2_H);
sfr_w(RES3);                                  /* 32x32-bit result 3  most significant word */
sfr_b(RES3_L);
sfr_b(RES3_H);
sfr_w(MPY32CTL0);                             /* MPY32 control register 0 */
sfr_b(MPY32CTL0_L);
sfr_b(MPY32CTL0_H);

/* MPY32 Register Offsets */
#define OFS_MPY                          (0x0000)
#define OFS_MPY_L                        OFS_MPY
#define OFS_MPY_H                        OFS_MPY+1
#define OFS_MPYS                         (0x0002)
#define OFS_MPYS_L                       OFS_MPYS
#define OFS_MPYS_H                       OFS_MPYS+1
#define OFS_MAC                          (0x0004)
#define OFS_MAC_L                        OFS_MAC
#define OFS_MAC_H                        OFS_MAC+1
#define OFS_MACS                         (0x0006)
#define OFS_MACS_L                       OFS_MACS
#define OFS_MACS_H                       OFS_MACS+1
#define OFS_OP2                          (0x0008)
#define OFS_OP2_L                        OFS_OP2
#define OFS_OP2_H                        OFS_OP2+1
#define OFS_RESLO                        (0x000A)
#define OFS_RESLO_L                      OFS_RESLO
#define OFS_RESLO_H                      OFS_RESLO+1
#define OFS_RESHI                        (0x000C)
#define OFS_RESHI_L                      OFS_RESHI
#define OFS_RESHI_H                      OFS_RESHI+1
#define OFS_SUMEXT                       (0x000E)
#define OFS_SUMEXT_L                     OFS_SUMEXT
#define OFS_SUMEXT_H                     OFS_SUMEXT+1
#define OFS_MPY32L                       (0x0010)
#define OFS_MPY32L_L                     OFS_MPY32L
#define OFS_MPY32L_H                     OFS_MPY32L+1
#define OFS_MPY32H                       (0x0012)
#define OFS_MPY32H_L                     OFS_MPY32H
#define OFS_MPY32H_H                     OFS_MPY32H+1
#define OFS_MPYS32L                      (0x0014)
#define OFS_MPYS32L_L                    OFS_MPYS32L
#define OFS_MPYS32L_H                    OFS_MPYS32L+1
#define OFS_MPYS32H                      (0x0016)
#define OFS_MPYS32H_L                    OFS_MPYS32H
#define OFS_MPYS32H_H                    OFS_MPYS32H+1
#define OFS_MAC32L                       (0x0018)
#define OFS_MAC32L_L                     OFS_MAC32L
#define OFS_MAC32L_H                     OFS_MAC32L+1
#define OFS_MAC32H                       (0x001A)
#define OFS_MAC32H_L                     OFS_MAC32H
#define OFS_MAC32H_H                     OFS_MAC32H+1
#define OFS_MACS32L                      (0x001C)
#define OFS_MACS32L_L                    OFS_MACS32L
#define OFS_MACS32L_H                    OFS_MACS32L+1
#define OFS_MACS32H                      (0x001E)
#define OFS_MACS32H_L                    OFS_MACS32H
#define OFS_MACS32H_H                    OFS_MACS32H+1
#define OFS_OP2L                         (0x0020)
#define OFS_OP2L_L                       OFS_OP2L
#define OFS_OP2L_H                       OFS_OP2L+1
#define OFS_OP2H                         (0x0022)
#define OFS_OP2H_L                       OFS_OP2H
#define OFS_OP2H_H                       OFS_OP2H+1
#define OFS_RES0                         (0x0024)
#define OFS_RES0_L                       OFS_RES0
#define OFS_RES0_H                       OFS_RES0+1
#define OFS_RES1                         (0x0026)
#define OFS_RES1_L                       OFS_RES1
#define OFS_RES1_H                       OFS_RES1+1
#define OFS_RES2                         (0x0028)
#define OFS_RES2_L                       OFS_RES2
#define OFS_RES2_H                       OFS_RES2+1
#define OFS_RES3                         (0x002A)
#define OFS_RES3_L                       OFS_RES3
#define OFS_RES3_H                       OFS_RES3+1
#define OFS_MPY32CTL0                    (0x002C)
#define OFS_MPY32CTL0_L                  OFS_MPY32CTL0
#define OFS_MPY32CTL0_H                  OFS_MPY32CTL0+1

/* MPY32 Control Bits */

/* MACS32H Control Bits */
#define MACS32H0                         (0x0100)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H0_H                       (0x0001)
#define MACS32H1                         (0x0200)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H1_H                       (0x0002)
#define MACS32H2                         (0x0400)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H2_H                       (0x0004)
#define MACS32H3                         (0x0800)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H3_H                       (0x0008)
#define MACS32H4                         (0x1000)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H4_H                       (0x0010)
#define MACS32H5                         (0x2000)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H5_H                       (0x0020)
#define MACS32H6                         (0x4000)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H6_H                       (0x0040)
#define MACS32H7                         (0x8000)        /* 32-bit operand 1  signed multiply accumulate  high word */
#define MACS32H7_H                       (0x0080)

/* MPY32CTL0 Control Bits */
#define MPYDLY32                         (0x0200)        /* Delayed write mode. */
#define MPYDLY32_H                       (0x0002)
#define MPYDLY32_0                       (0x0000)        /* Writes are delayed until 64-bit result (RES0 to RES3) is 
                                                            available. */
#define MPYDLY32_1                       (0x0200)        /* Writes are delayed until 32-bit result (RES0 to RES1) is 
                                                            available. 8 MPYDLYWRTEN */
#define MPYDLY32_1_H                     (0x0002)
#define MPYDLYWRTEN                      (0x0100)        /* Delayed write enable. */
#define MPYDLYWRTEN_H                    (0x0001)
#define MPYDLYWRTEN_0                    (0x0000)        /* Writes are not delayed. */
#define MPYDLYWRTEN_1                    (0x0100)        /* Writes are delayed. */
#define MPYDLYWRTEN_1_H                  (0x0001)
#define MPYOP2_32                        (0x0080)        /* Multiplier bit width of operand 2 */
#define MPYOP2_32_L                      (0x0080)
#define MPYOP2_32_0                      (0x0000)        /* 16 bits. */
#define MPYOP2_32_1                      (0x0080)        /* 32 bits. */
#define MPYOP2_32_1_L                    (0x0080)
#define MPYOP2_32__16                    (0x0000)        /* 16 bits. */
#define MPYOP2_32__32                    (0x0080)        /* 32 bits. */
#define MPYOP2_32__32_L                  (0x0080)
#define MPYOP1_32                        (0x0040)        /* Multiplier bit width of operand 1 */
#define MPYOP1_32_L                      (0x0040)
#define MPYOP1_32_0                      (0x0000)        /* 16 bits. */
#define MPYOP1_32_1                      (0x0040)        /* 32 bits. */
#define MPYOP1_32_1_L                    (0x0040)
#define MPYOP1_32__16                    (0x0000)        /* 16 bits. */
#define MPYOP1_32__32                    (0x0040)        /* 32 bits. */
#define MPYOP1_32__32_L                  (0x0040)
#define MPYM                             (0x0030)        /* Multiplier mode */
#define MPYM_L                           (0x0030)
#define MPYM0                            (0x0010)        /* Multiplier mode */
#define MPYM0_L                          (0x0010)
#define MPYM1                            (0x0020)        /* Multiplier mode */
#define MPYM1_L                          (0x0020)
#define MPYM_0                           (0x0000)        /* MPY  Multiply */
#define MPYM_1                           (0x0010)        /* MPYS  Signed multiply */
#define MPYM_1_L                         (0x0010)
#define MPYM_2                           (0x0020)        /* MAC  Multiply accumulate */
#define MPYM_2_L                         (0x0020)
#define MPYM_3                           (0x0030)        /* MACS  Signed multiply accumulate */
#define MPYM_3_L                         (0x0030)
#define MPYM__MPY                        (0x0000)        /* MPY  Multiply */
#define MPYM__MPYS                       (0x0010)        /* MPYS  Signed multiply */
#define MPYM__MPYS_L                     (0x0010)
#define MPYM__MAC                        (0x0020)        /* MAC  Multiply accumulate */
#define MPYM__MAC_L                      (0x0020)
#define MPYM__MACS                       (0x0030)        /* MACS  Signed multiply accumulate */
#define MPYM__MACS_L                     (0x0030)
#define MPYSAT                           (0x0008)        /* Saturation mode */
#define MPYSAT_L                         (0x0008)
#define MPYSAT_0                         (0x0000)        /* Saturation mode disabled. */
#define MPYSAT_1                         (0x0008)        /* Saturation mode enabled. */
#define MPYSAT_1_L                       (0x0008)
#define MPYSAT__DISABLE                  (0x0000)        /* Saturation mode disabled. */
#define MPYSAT__ENABLE                   (0x0008)        /* Saturation mode enabled. */
#define MPYSAT__ENABLE_L                 (0x0008)
#define MPYFRAC                          (0x0004)        /* Fractional mode. */
#define MPYFRAC_L                        (0x0004)
#define MPYFRAC_0                        (0x0000)        /* Fractional mode disabled. */
#define MPYFRAC_1                        (0x0004)        /* Fractional mode enabled. */
#define MPYFRAC_1_L                      (0x0004)
#define MPYFRAC__DISABLE                 (0x0000)        /* Fractional mode disabled. */
#define MPYFRAC__ENABLE                  (0x0004)        /* Fractional mode enabled. */
#define MPYFRAC__ENABLE_L                (0x0004)
#define MPYC                             (0x0001)        /* Carry of the multiplier */
#define MPYC_L                           (0x0001)
#define MPYC_0                           (0x0000)        /* No carry for result. */
#define MPYC_1                           (0x0001)        /* Result has a carry. */
#define MPYC_1_L                         (0x0001)


/*****************************************************************************
 MTIF Registers
*****************************************************************************/

#define __MSP430_HAS_MTIF__                   /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_MTIF__ 0x0F00
#define MTIF_BASE              __MSP430_BASEADDRESS_MTIF__

sfr_w(MTIFPGCNF);                             /* Pulse Generator Configuration Register */
sfr_b(MTIFPGCNF_L);
sfr_b(MTIFPGCNF_H);
sfr_w(MTIFPGKVAL);                            /* Pulse Generator Value Register */
sfr_b(MTIFPGKVAL_L);
sfr_b(MTIFPGKVAL_H);
sfr_w(MTIFPGCTL);                             /* Pulse Generator Control Register */
sfr_b(MTIFPGCTL_L);
sfr_b(MTIFPGCTL_H);
sfr_w(MTIFPGSR);                              /* Pulse Generator Status Register */
sfr_b(MTIFPGSR_L);
sfr_b(MTIFPGSR_H);
sfr_w(MTIFPCCNF);                             /* Pulse Counter Configuration Register */
sfr_b(MTIFPCCNF_L);
sfr_b(MTIFPCCNF_H);
sfr_w(MTIFPCR);                               /* Pulse Counter Value Register */
sfr_b(MTIFPCR_L);
sfr_b(MTIFPCR_H);
sfr_w(MTIFPCCTL);                             /* Pulse Counter Control Register */
sfr_b(MTIFPCCTL_L);
sfr_b(MTIFPCCTL_H);
sfr_w(MTIFPCSR);                              /* Pulse Counter Status Register */
sfr_b(MTIFPCSR_L);
sfr_b(MTIFPCSR_H);
sfr_w(MTIFTPCTL);                             /* Measurement Test Port Control Register */
sfr_b(MTIFTPCTL_L);
sfr_b(MTIFTPCTL_H);

/* MTIF Register Offsets */
#define OFS_MTIFPGCNF                    (0x0000)
#define OFS_MTIFPGCNF_L                  OFS_MTIFPGCNF
#define OFS_MTIFPGCNF_H                  OFS_MTIFPGCNF+1
#define OFS_MTIFPGKVAL                   (0x0002)
#define OFS_MTIFPGKVAL_L                 OFS_MTIFPGKVAL
#define OFS_MTIFPGKVAL_H                 OFS_MTIFPGKVAL+1
#define OFS_MTIFPGCTL                    (0x0004)
#define OFS_MTIFPGCTL_L                  OFS_MTIFPGCTL
#define OFS_MTIFPGCTL_H                  OFS_MTIFPGCTL+1
#define OFS_MTIFPGSR                     (0x0006)
#define OFS_MTIFPGSR_L                   OFS_MTIFPGSR
#define OFS_MTIFPGSR_H                   OFS_MTIFPGSR+1
#define OFS_MTIFPCCNF                    (0x0008)
#define OFS_MTIFPCCNF_L                  OFS_MTIFPCCNF
#define OFS_MTIFPCCNF_H                  OFS_MTIFPCCNF+1
#define OFS_MTIFPCR                      (0x000A)
#define OFS_MTIFPCR_L                    OFS_MTIFPCR
#define OFS_MTIFPCR_H                    OFS_MTIFPCR+1
#define OFS_MTIFPCCTL                    (0x000C)
#define OFS_MTIFPCCTL_L                  OFS_MTIFPCCTL
#define OFS_MTIFPCCTL_H                  OFS_MTIFPCCTL+1
#define OFS_MTIFPCSR                     (0x000E)
#define OFS_MTIFPCSR_L                   OFS_MTIFPCSR
#define OFS_MTIFPCSR_H                   OFS_MTIFPCSR+1
#define OFS_MTIFTPCTL                    (0x0010)
#define OFS_MTIFTPCTL_L                  OFS_MTIFTPCTL
#define OFS_MTIFTPCTL_H                  OFS_MTIFTPCTL+1

/* MTIF Control Bits */

/* MTIFPGCNF Control Bits */
#define PGPW                             (0x5a00)        /* */
#define PGPW_H                           (0x005a)
#define PGPW0                            (0x0100)        /* */
#define PGPW0_H                          (0x0001)
#define PGPW1                            (0x0200)        /* */
#define PGPW1_H                          (0x0002)
#define PGPW2                            (0x0400)        /* */
#define PGPW2_H                          (0x0004)
#define PGPW3                            (0x0800)        /* */
#define PGPW3_H                          (0x0008)
#define PGPW4                            (0x1000)        /* */
#define PGPW4_H                          (0x0010)
#define PGPW5                            (0x2000)        /* */
#define PGPW5_H                          (0x0020)
#define PGPW6                            (0x4000)        /* */
#define PGPW6_H                          (0x0040)
#define PGPW7                            (0x8000)        /* */
#define PGPW7_H                          (0x0080)
#define PGPW_R                           (0x6900)        /* Read value while locked */
#define PGPW_R_H                         (0x0069)
#define PGFS                             (0x0070)        /* */
#define PGFS_L                           (0x0070)
#define PGFS0                            (0x0010)        /* */
#define PGFS0_L                          (0x0010)
#define PGFS1                            (0x0020)        /* */
#define PGFS1_L                          (0x0020)
#define PGFS2                            (0x0040)        /* */
#define PGFS2_L                          (0x0040)
#define PGFS_0                           (0x0000)        /* Pulse grid frequency is set to 8 Hz (nominal) */
#define PGFS_1                           (0x0010)        /* Pulse grid frequency is set to 16 Hz (nominal) */
#define PGFS_1_L                         (0x0010)
#define PGFS_2                           (0x0020)        /* Pulse grid frequency is set to 32 Hz (nominal) */
#define PGFS_2_L                         (0x0020)
#define PGFS_3                           (0x0030)        /* Pulse grid frequency is set to 64 Hz (nominal) */
#define PGFS_3_L                         (0x0030)
#define PGFS_4                           (0x0040)        /* Pulse grid frequency is set to 128 Hz (nominal) */
#define PGFS_4_L                         (0x0040)
#define PGFS_5                           (0x0050)        /* Pulse grid frequency is set to 256 Hz (nominal) */
#define PGFS_5_L                         (0x0050)
#define PGFS_6                           (0x0060)        /* Pulse grid frequency is set to 512 Hz (nominal) */
#define PGFS_6_L                         (0x0060)
#define PGFS_7                           (0x0070)        /* Pulse grid frequency is set to 1024 Hz (nominal) default */
#define PGFS_7_L                         (0x0070)
#define PGCLR                            (0x0004)        /* */
#define PGCLR_L                          (0x0004)
#define PGEN                             (0x0001)        /* */
#define PGEN_L                           (0x0001)

/* MTIFPGKVAL Control Bits */
#define KVAL                             (0x007f)        /* */
#define KVAL_L                           (0x007f)
#define KVAL0                            (0x0001)        /* */
#define KVAL0_L                          (0x0001)
#define KVAL1                            (0x0002)        /* */
#define KVAL1_L                          (0x0002)
#define KVAL2                            (0x0004)        /* */
#define KVAL2_L                          (0x0004)
#define KVAL3                            (0x0008)        /* */
#define KVAL3_L                          (0x0008)
#define KVAL4                            (0x0010)        /* */
#define KVAL4_L                          (0x0010)
#define KVAL5                            (0x0020)        /* */
#define KVAL5_L                          (0x0020)
#define KVAL6                            (0x0040)        /* */
#define KVAL6_L                          (0x0040)

/* MTIFPGCTL Control Bits */
#define PKUR                             (0x0001)        /* */
#define PKUR_L                           (0x0001)
#define PGUR                             (0x0002)        /* */
#define PGUR_L                           (0x0002)

/* MTIFPGSR Control Bits */
#define PKUA                             (0x0001)        /* */
#define PKUA_L                           (0x0001)
#define PGUA                             (0x0002)        /* */
#define PGUA_L                           (0x0002)

/* MTIFPCCNF Control Bits */
#define PCPW                             (0xa500)        /* */
#define PCPW_H                           (0x00a5)
#define PCPW0                            (0x0100)        /* */
#define PCPW0_H                          (0x0001)
#define PCPW1                            (0x0200)        /* */
#define PCPW1_H                          (0x0002)
#define PCPW2                            (0x0400)        /* */
#define PCPW2_H                          (0x0004)
#define PCPW3                            (0x0800)        /* */
#define PCPW3_H                          (0x0008)
#define PCPW4                            (0x1000)        /* */
#define PCPW4_H                          (0x0010)
#define PCPW5                            (0x2000)        /* */
#define PCPW5_H                          (0x0020)
#define PCPW6                            (0x4000)        /* */
#define PCPW6_H                          (0x0040)
#define PCPW7                            (0x8000)        /* */
#define PCPW7_H                          (0x0080)
#define PCPW_R                           (0x9600)        /* Read value while locked */
#define PCPW_R_H                         (0x0096)
#define PCEN                             (0x0001)        /* */
#define PCEN_L                           (0x0001)
#define PCCLR                            (0x0004)        /* */
#define PCCLR_L                          (0x0004)

/* MTIFPCR Control Bits */
#define PCR                              (0xffff)        /* */
#define PCR_L                            (0x00ff)
#define PCR_H                            (0x00ff)
#define PCR0                             (0x0001)        /* */
#define PCR0_L                           (0x0001)
#define PCR1                             (0x0002)        /* */
#define PCR1_L                           (0x0002)
#define PCR2                             (0x0004)        /* */
#define PCR2_L                           (0x0004)
#define PCR3                             (0x0008)        /* */
#define PCR3_L                           (0x0008)
#define PCR4                             (0x0010)        /* */
#define PCR4_L                           (0x0010)
#define PCR5                             (0x0020)        /* */
#define PCR5_L                           (0x0020)
#define PCR6                             (0x0040)        /* */
#define PCR6_L                           (0x0040)
#define PCR7                             (0x0080)        /* */
#define PCR7_L                           (0x0080)
#define PCR8                             (0x0100)        /* */
#define PCR8_H                           (0x0001)
#define PCR9                             (0x0200)        /* */
#define PCR9_H                           (0x0002)
#define PCR10                            (0x0400)        /* */
#define PCR10_H                          (0x0004)
#define PCR11                            (0x0800)        /* */
#define PCR11_H                          (0x0008)
#define PCR12                            (0x1000)        /* */
#define PCR12_H                          (0x0010)
#define PCR13                            (0x2000)        /* */
#define PCR13_H                          (0x0020)
#define PCR14                            (0x4000)        /* */
#define PCR14_H                          (0x0040)
#define PCR15                            (0x8000)        /* */
#define PCR15_H                          (0x0080)

/* MTIFPCCTL Control Bits */
#define PCRR                             (0x0001)        /* */
#define PCRR_L                           (0x0001)

/* MTIFPCSR Control Bits */
#define PCOFL                            (0x0002)        /* */
#define PCOFL_L                          (0x0002)
#define PCRA                             (0x0001)        /* */
#define PCRA_L                           (0x0001)

/* MTIFTPCTL Control Bits */
#define TPPW                             (0xc300)        /* */
#define TPPW_H                           (0x00c3)
#define TPPW0                            (0x0100)        /* */
#define TPPW0_H                          (0x0001)
#define TPPW1                            (0x0200)        /* */
#define TPPW1_H                          (0x0002)
#define TPPW2                            (0x0400)        /* */
#define TPPW2_H                          (0x0004)
#define TPPW3                            (0x0800)        /* */
#define TPPW3_H                          (0x0008)
#define TPPW4                            (0x1000)        /* */
#define TPPW4_H                          (0x0010)
#define TPPW5                            (0x2000)        /* */
#define TPPW5_H                          (0x0020)
#define TPPW6                            (0x4000)        /* */
#define TPPW6_H                          (0x0040)
#define TPPW7                            (0x8000)        /* */
#define TPPW7_H                          (0x0080)
#define TPPW_R                           (0x0f00)        /* Read value while locked */
#define TPPW_R_H                         (0x000f)
#define TPISEL                           (0x0004)        /* */
#define TPISEL_L                         (0x0004)
#define TPISEL_0                         (0x0000)        /* The pulse generator is used as input */
#define TPISEL_1                         (0x0004)        /* The test port input terminal is selected as input */
#define TPISEL_1_L                       (0x0004)
#define TPIE                             (0x0002)        /* */
#define TPIE_L                           (0x0002)
#define TPOE                             (0x0001)        /* */
#define TPOE_L                           (0x0001)
#define ACTIVATE                         (0x0008)        /* */
#define ACTIVATE_L                       (0x0008)
#define ACTIVATE_0                       (0x0000)        /* The test port output is enabled solely by TPOE (enabled if 
                                                            TPOE=1) */
#define ACTIVATE_1                       (0x0008)        /* The testport output requires both TPOE to be high and the MTPE
                                                            pin to be high to be enabled */
#define ACTIVATE_1_L                     (0x0008)


/*****************************************************************************
 PMM Registers
*****************************************************************************/

#define __MSP430_HAS_PMM__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_PMM__ 0x0120
#define PMM_BASE               __MSP430_BASEADDRESS_PMM__

sfr_w(PMMCTL0);                               /* PMM control register 0 */
sfr_b(PMMCTL0_L);
sfr_b(PMMCTL0_H);
sfr_w(PMMIFG);                                /* PMM interrupt flag register */
sfr_b(PMMIFG_L);
sfr_b(PMMIFG_H);
sfr_w(PM5CTL0);                               /* Power mode 5 control register 0 */
sfr_b(PM5CTL0_L);
sfr_b(PM5CTL0_H);

/* PMM Register Offsets */
#define OFS_PMMCTL0                      (0x0000)
#define OFS_PMMCTL0_L                    OFS_PMMCTL0
#define OFS_PMMCTL0_H                    OFS_PMMCTL0+1
#define OFS_PMMIFG                       (0x000A)
#define OFS_PMMIFG_L                     OFS_PMMIFG
#define OFS_PMMIFG_H                     OFS_PMMIFG+1
#define OFS_PM5CTL0                      (0x0010)
#define OFS_PM5CTL0_L                    OFS_PM5CTL0
#define OFS_PM5CTL0_H                    OFS_PM5CTL0+1

/* PMM Control Bits */

/* PMMCTL0 Control Bits */
#define PMMSWBOR                         (0x0004)        /* Software brownout reset. */
#define PMMSWBOR_L                       (0x0004)
#define PMMSWBOR_0                       (0x0000)        /* Normal operation */
#define PMMSWBOR_1                       (0x0004)        /* Set to 1 to trigger a BOR */
#define PMMSWBOR_1_L                     (0x0004)
#define PMMSWPOR                         (0x0008)        /* Software POR. */
#define PMMSWPOR_L                       (0x0008)
#define PMMSWPOR_0                       (0x0000)        /* Normal operation */
#define PMMSWPOR_1                       (0x0008)        /* Set to 1 to trigger a POR */
#define PMMSWPOR_1_L                     (0x0008)
#define PMMREGOFF                        (0x0010)        /* Regulator off */
#define PMMREGOFF_L                      (0x0010)
#define PMMREGOFF_0                      (0x0000)        /* Regulator remains on when going into LPM3 or LPM4 */
#define PMMREGOFF_1                      (0x0010)        /* Regulator is turned off when going to LPM3 or LPM4. System 
                                                            enters LPM3.5 or LPM4.5, respectively. */
#define PMMREGOFF_1_L                    (0x0010)
#define SVSHE                            (0x0040)        /* High-side SVS enable. */
#define SVSHE_L                          (0x0040)
#define SVSHE_0                          (0x0000)        /* High-side SVS (SVSH) is disabled in LPM2, LPM3, LPM4, LPM3.5, 
                                                            and LPM4.5. SVSH is always enabled in active mode, LPM0, and 
                                                            LPM1. */
#define SVSHE_1                          (0x0040)        /* SVSH is always enabled. */
#define SVSHE_1_L                        (0x0040)
#define PMMPW                            (0xa500)        /* PMM password. */
#define PMMPW_H                          (0x00a5)
#define PMMPW0                           (0x0100)        /* PMM password. */
#define PMMPW0_H                         (0x0001)
#define PMMPW1                           (0x0200)        /* PMM password. */
#define PMMPW1_H                         (0x0002)
#define PMMPW2                           (0x0400)        /* PMM password. */
#define PMMPW2_H                         (0x0004)
#define PMMPW3                           (0x0800)        /* PMM password. */
#define PMMPW3_H                         (0x0008)
#define PMMPW4                           (0x1000)        /* PMM password. */
#define PMMPW4_H                         (0x0010)
#define PMMPW5                           (0x2000)        /* PMM password. */
#define PMMPW5_H                         (0x0020)
#define PMMPW6                           (0x4000)        /* PMM password. */
#define PMMPW6_H                         (0x0040)
#define PMMPW7                           (0x8000)        /* PMM password. */
#define PMMPW7_H                         (0x0080)

/* PMMIFG Control Bits */
#define PMMBORIFG                        (0x0100)        /* PMM software brownout reset interrupt flag. */
#define PMMBORIFG_H                      (0x0001)
#define PMMBORIFG_0                      (0x0000)        /* Reset not due to PMMSWBOR */
#define PMMBORIFG_1                      (0x0100)        /* Reset due to PMMSWBOR */
#define PMMBORIFG_1_H                    (0x0001)
#define PMMRSTIFG                        (0x0200)        /* PMM reset pin interrupt flag. */
#define PMMRSTIFG_H                      (0x0002)
#define PMMRSTIFG_0                      (0x0000)        /* Reset not due to reset pin */
#define PMMRSTIFG_1                      (0x0200)        /* Reset due to reset pin */
#define PMMRSTIFG_1_H                    (0x0002)
#define PMMPORIFG                        (0x0400)        /* PMM software POR interrupt flag. */
#define PMMPORIFG_H                      (0x0004)
#define PMMPORIFG_0                      (0x0000)        /* Reset not due to PMMSWPOR */
#define PMMPORIFG_1                      (0x0400)        /* Reset due to PMMSWPOR */
#define PMMPORIFG_1_H                    (0x0004)
#define SVSHIFG                          (0x2000)        /* High-side SVS interrupt flag. */
#define SVSHIFG_H                        (0x0020)
#define SVSHIFG_0                        (0x0000)        /* Reset not due to SVSH */
#define SVSHIFG_1                        (0x2000)        /* Reset due to SVSH */
#define SVSHIFG_1_H                      (0x0020)
#define PMMLPM5IFG                       (0x8000)        /* LPMx.5 flag. */
#define PMMLPM5IFG_H                     (0x0080)
#define PMMLPM5IFG_0                     (0x0000)        /* Reset not due to wake-up from LPMx.5 */
#define PMMLPM5IFG_1                     (0x8000)        /* Reset due to wake-up from LPMx.5 */
#define PMMLPM5IFG_1_H                   (0x0080)

/* PM5CTL0 Control Bits */
#define LOCKLPM5                         (0x0001)        /* LPMx.5 Lock Bit */
#define LOCKLPM5_L                       (0x0001)
#define LOCKLPM5_0                       (0x0000)        /* LPMx.5 configuration is not locked and defaults to its reset 
                                                            condition. */
#define LOCKLPM5_1                       (0x0001)        /* LPMx.5 configuration remains locked. Pin state is held during 
                                                            LPMx.5 entry and exit. */
#define LOCKLPM5_1_L                     (0x0001)


/*****************************************************************************
 RAMCTL Registers
*****************************************************************************/

#define __MSP430_HAS_RAMCTL__                 /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_RAMCTL__ 0x0158
#define RAMCTL_BASE            __MSP430_BASEADDRESS_RAMCTL__
#define __MSP430_HAS_RAMCTL_CONFIG__ 2          /* Definition to show the Module config */

sfr_w(RCCTL0);                                /* RAM Controller Control 0 */
sfr_b(RCCTL0_L);
sfr_b(RCCTL0_H);
sfr_w(RCCTL1);                                /* RAM Controller Control 1 */
sfr_b(RCCTL1_L);
sfr_b(RCCTL1_H);

/* RAMCTL Register Offsets */
#define OFS_RCCTL0                       (0x0000)
#define OFS_RCCTL0_L                     OFS_RCCTL0
#define OFS_RCCTL0_H                     OFS_RCCTL0+1
#define OFS_RCCTL1                       (0x0002)
#define OFS_RCCTL1_L                     OFS_RCCTL1
#define OFS_RCCTL1_H                     OFS_RCCTL1+1

/* RAMCTL Control Bits */

/* RCCTL0 Control Bits */
#define RCRS0OFF0                        (0x0001)        /* RCRS0OFF Bit 0 */
#define RCRS0OFF0_L                      (0x0001)
#define RCRS0OFF1                        (0x0002)        /* RCRS0OFF Bit 1 */
#define RCRS0OFF1_L                      (0x0002)
#define RCRS0OFF                         (0x0003)        /* RAM controller RAM sector 0 off */
#define RCRS0OFF_L                       (0x0003)
#define RCRS0OFF_0                       (0x0000)        /* Contents of this RAM sector are retained in LPM3 and LPM4. */
#define RCRS0OFF_1                       (0x0001)        /* Turns off this RAM sector in LPM3 and LPM4, re-activates it on
                                                            wake-up. All data of this RAM sector is lost after wakeup from
                                                            LPM3 and LPM4. See the device-specific data sheet to find the 
                                                            number of available sectors, the address range, and the size 
                                                            of each RAM sector. */
#define RCRS0OFF_1_L                     (0x0001)
#define RCRS0OFF_2                       (0x0002)        /* Turns off this RAM sector entering LPM3 and LPM4, the RAM 
                                                            sector remains off after wake-up. All data of this RAM sector 
                                                            is lost. See the devicespecific data sheet to find the number 
                                                            of available sectors, the address range, and the size of each 
                                                            RAM sector. */
#define RCRS0OFF_2_L                     (0x0002)
#define RCKEY                            (0x5a00)        /* */
#define RCKEY_H                          (0x005a)
#define RCKEY0                           (0x0100)        /* */
#define RCKEY0_H                         (0x0001)
#define RCKEY1                           (0x0200)        /* */
#define RCKEY1_H                         (0x0002)
#define RCKEY2                           (0x0400)        /* */
#define RCKEY2_H                         (0x0004)
#define RCKEY3                           (0x0800)        /* */
#define RCKEY3_H                         (0x0008)
#define RCKEY4                           (0x1000)        /* */
#define RCKEY4_H                         (0x0010)
#define RCKEY5                           (0x2000)        /* */
#define RCKEY5_H                         (0x0020)
#define RCKEY6                           (0x4000)        /* */
#define RCKEY6_H                         (0x0040)
#define RCKEY7                           (0x8000)        /* */
#define RCKEY7_H                         (0x0080)
#define RCRS1OFF0                        (0x0004)        /* RCRS1OFF Bit 0 */
#define RCRS1OFF0_L                      (0x0004)
#define RCRS1OFF1                        (0x0008)        /* RCRS1OFF Bit 1 */
#define RCRS1OFF1_L                      (0x0008)
#define RCRS1OFF                         (0x000c)        /* RAM controller RAM sector 1 off */
#define RCRS1OFF_L                       (0x000c)
#define RCRS3OFF0                        (0x0040)        /* RCRS3OFF Bit 0 */
#define RCRS3OFF0_L                      (0x0040)
#define RCRS3OFF1                        (0x0080)        /* RCRS3OFF Bit 1 */
#define RCRS3OFF1_L                      (0x0080)
#define RCRS3OFF                         (0x00c0)        /* RAM controller RAM sector 3 off */
#define RCRS3OFF_L                       (0x00c0)
#define RCRS2OFF0                        (0x0010)        /* RCRS2OFF Bit 0 */
#define RCRS2OFF0_L                      (0x0010)
#define RCRS2OFF1                        (0x0020)        /* RCRS2OFF Bit 1 */
#define RCRS2OFF1_L                      (0x0020)
#define RCRS2OFF                         (0x0030)        /* RAM controller RAM sector 2 off */
#define RCRS2OFF_L                       (0x0030)

/* RCCTL1 Control Bits */
#define DACCESSIE                        (0x0100)        /* DACCESS Bus Error NMI enable */
#define DACCESSIE_H                      (0x0001)
#define DACCESSIE_0                      (0x0000)        /* Disable NMI for DACCESS Interrupt */
#define DACCESSIE_1                      (0x0100)        /* Enable NMI for DACCESS Interrupt */
#define DACCESSIE_1_H                    (0x0001)
#define DACCESSIFG                       (0x0001)        /* DACCESS Interrupt Flag */
#define DACCESSIFG_L                     (0x0001)
#define DACCESSIFG_0                     (0x0000)        /* DACCESS Interrupt is not pending */
#define DACCESSIFG_1                     (0x0001)        /* DACCESS Interrupt is pending. */
#define DACCESSIFG_1_L                   (0x0001)


/*****************************************************************************
 REF_A Registers
*****************************************************************************/

#define __MSP430_HAS_REF_A__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_REF_A__ 0x01B0
#define REF_A_BASE             __MSP430_BASEADDRESS_REF_A__

sfr_w(REFCTL0);                               /* REF Control Register 0 */
sfr_b(REFCTL0_L);
sfr_b(REFCTL0_H);

/* REF_A Register Offsets */
#define OFS_REFCTL0                      (0x0000)
#define OFS_REFCTL0_L                    OFS_REFCTL0
#define OFS_REFCTL0_H                    OFS_REFCTL0+1

/* REF_A Control Bits */

/* REFCTL0 Control Bits */
#define REFON                            (0x0001)        /* Reference enable */
#define REFON_L                          (0x0001)
#define REFON_0                          (0x0000)        /* Disables reference if no other reference requests are pending */
#define REFON_1                          (0x0001)        /* Enables reference in static mode */
#define REFON_1_L                        (0x0001)
#define REFOUT                           (0x0002)        /* Reference output buffer */
#define REFOUT_L                         (0x0002)
#define REFOUT_0                         (0x0000)        /* Reference output not available externally */
#define REFOUT_1                         (0x0002)        /* Reference output available externally. If ADC14REFBURST = 0, 
                                                            output is available continuously. If ADC14REFBURST = 1, output
                                                            is available only during an ADC14 conversion. */
#define REFOUT_1_L                       (0x0002)
#define REFTCOFF                         (0x0008)        /* Temperature sensor disabled */
#define REFTCOFF_L                       (0x0008)
#define REFTCOFF_0                       (0x0000)        /* Temperature sensor enabled */
#define REFTCOFF_1                       (0x0008)        /* Temperature sensor disabled to save power */
#define REFTCOFF_1_L                     (0x0008)
#define REFVSEL                          (0x0030)        /* Reference voltage level select */
#define REFVSEL_L                        (0x0030)
#define REFVSEL0                         (0x0010)        /* Reference voltage level select */
#define REFVSEL0_L                       (0x0010)
#define REFVSEL1                         (0x0020)        /* Reference voltage level select */
#define REFVSEL1_L                       (0x0020)
#define REFVSEL_0                        (0x0000)        /* 1.2 V available when reference requested or REFON = 1 */
#define REFVSEL_1                        (0x0010)        /* 2.0 V available when reference requested or REFON = 1 */
#define REFVSEL_1_L                      (0x0010)
#define REFVSEL_2                        (0x0020)        /* 2.5 V available when reference requested or REFON = 1 */
#define REFVSEL_2_L                      (0x0020)
#define REFVSEL_3                        (0x0030)        /* 2.5 V available when reference requested or REFON = 1 */
#define REFVSEL_3_L                      (0x0030)
#define REFGENOT                         (0x0040)        /* Reference generator one-time trigger */
#define REFGENOT_L                       (0x0040)
#define REFGENOT_0                       (0x0000)        /* No trigger */
#define REFGENOT_1                       (0x0040)        /* Generation of the reference voltage is started by writing 1 or
                                                            by a hardware trigger */
#define REFGENOT_1_L                     (0x0040)
#define REFBGOT                          (0x0080)        /* Bandgap and bandgap buffer one-time trigger */
#define REFBGOT_L                        (0x0080)
#define REFBGOT_0                        (0x0000)        /* No trigger */
#define REFBGOT_1                        (0x0080)        /* Generation of the bandgap voltage is started by writing 1 or 
                                                            by a hardware trigger */
#define REFBGOT_1_L                      (0x0080)
#define REFGENACT                        (0x0100)        /* Reference generator active */
#define REFGENACT_H                      (0x0001)
#define REFGENACT_0                      (0x0000)        /* Reference generator not active */
#define REFGENACT_1                      (0x0100)        /* Reference generator active */
#define REFGENACT_1_H                    (0x0001)
#define REFBGACT                         (0x0200)        /* Reference bandgap active */
#define REFBGACT_H                       (0x0002)
#define REFBGACT_0                       (0x0000)        /* Reference bandgap buffer not active */
#define REFBGACT_1                       (0x0200)        /* Reference bandgap buffer active */
#define REFBGACT_1_H                     (0x0002)
#define REFGENBUSY                       (0x0400)        /* Reference generator busy */
#define REFGENBUSY_H                     (0x0004)
#define REFGENBUSY_0                     (0x0000)        /* Reference generator not busy */
#define REFGENBUSY_1                     (0x0400)        /* Reference generator busy */
#define REFGENBUSY_1_H                   (0x0004)
#define BGMODE                           (0x0800)        /* Bandgap mode */
#define BGMODE_H                         (0x0008)
#define BGMODE_0                         (0x0000)        /* Static mode */
#define BGMODE_1                         (0x0800)        /* Sampled mode */
#define BGMODE_1_H                       (0x0008)
#define REFGENRDY                        (0x1000)        /* Variable reference voltage ready status */
#define REFGENRDY_H                      (0x0010)
#define REFGENRDY_0                      (0x0000)        /* Reference voltage output is not ready to be used */
#define REFGENRDY_1                      (0x1000)        /* Reference voltage output is ready to be used */
#define REFGENRDY_1_H                    (0x0010)
#define REFBGRDY                         (0x2000)        /* Buffered bandgap voltage ready status */
#define REFBGRDY_H                       (0x0020)
#define REFBGRDY_0                       (0x0000)        /* Buffered bandgap voltage is not ready to be used */
#define REFBGRDY_1                       (0x2000)        /* Buffered bandgap voltage is ready to be used */
#define REFBGRDY_1_H                     (0x0020)


/*****************************************************************************
 RTC_C Registers
*****************************************************************************/

#define __MSP430_HAS_RTC_C__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_RTC_C__ 0x04A0
#define RTC_C_BASE             __MSP430_BASEADDRESS_RTC_C__

sfr_w(RTCCTL0);                               /* RTCCTL0 Register */
sfr_b(RTCCTL0_L);
sfr_b(RTCCTL0_H);
sfr_w(RTCCTL13);                              /* RTCCTL13 Register */
sfr_b(RTCCTL13_L);
sfr_b(RTCCTL13_H);
sfr_w(RTCOCAL);                               /* RTCOCAL Register */
sfr_b(RTCOCAL_L);
sfr_b(RTCOCAL_H);
sfr_w(RTCTCMP);                               /* RTCTCMP Register */
sfr_b(RTCTCMP_L);
sfr_b(RTCTCMP_H);
sfr_w(RTCPS0CTL);                             /* Real-Time Clock Prescale Timer 0 Control Register */
sfr_b(RTCPS0CTL_L);
sfr_b(RTCPS0CTL_H);
sfr_w(RTCPS1CTL);                             /* Real-Time Clock Prescale Timer 1 Control Register */
sfr_b(RTCPS1CTL_L);
sfr_b(RTCPS1CTL_H);
sfr_w(RTCPS);                                 /* Real-Time Clock Prescale Timer Counter Register */
sfr_b(RTCPS_L);
sfr_b(RTCPS_H);
sfr_w(RTCIV);                                 /* Real-Time Clock Interrupt Vector Register */
sfr_b(RTCIV_L);
sfr_b(RTCIV_H);
sfr_w(RTCTIM0);                               /* RTCTIM0 Register  Hexadecimal Format */
sfr_b(RTCTIM0_L);
sfr_b(RTCTIM0_H);
sfr_w(RTCCNT12);                              /* Real-Time Clock Counter 1 and 2  Register  Counter Mode */
sfr_b(RTCCNT12_L);
sfr_b(RTCCNT12_H);
sfr_w(RTCTIM1);                               /* Real-Time Clock Hour, Day of Week */
sfr_b(RTCTIM1_L);
sfr_b(RTCTIM1_H);
sfr_w(RTCCNT34);                              /* Real-Time Clock Counter 3 and 4  Register  Counter Mode */
sfr_b(RTCCNT34_L);
sfr_b(RTCCNT34_H);
sfr_w(RTCDATE);                               /* RTCDATE - Hexadecimal Format */
sfr_b(RTCDATE_L);
sfr_b(RTCDATE_H);
sfr_w(RTCYEAR);                               /* RTCYEAR Register  Hexadecimal Format */
sfr_b(RTCYEAR_L);
sfr_b(RTCYEAR_H);
sfr_w(RTCAMINHR);                             /* RTCMINHR - Hexadecimal Format */
sfr_b(RTCAMINHR_L);
sfr_b(RTCAMINHR_H);
sfr_w(RTCADOWDAY);                            /* RTCADOWDAY - Hexadecimal Format */
sfr_b(RTCADOWDAY_L);
sfr_b(RTCADOWDAY_H);
sfr_w(BIN2BCD);                               /* Binary-to-BCD Conversion Register */
sfr_b(BIN2BCD_L);
sfr_b(BIN2BCD_H);
sfr_w(BCD2BIN);                               /* BCD-to-Binary Conversion Register */
sfr_b(BCD2BIN_L);
sfr_b(BCD2BIN_H);
sfr_b(RT0PS);                                 /* Prescale timer 0 counter value */

sfr_b(RT1PS);                                 /* Prescale timer 1 counter value */

sfr_b(RTCCNT1);                               /* The RTCCNT1 register is the count of RTCCNT1 */

sfr_b(RTCCNT2);                               /* The RTCCNT2 register is the count of RTCCNT2 */

sfr_b(RTCCNT3);                               /* The RTCCNT3 register is the count of RTCCNT3 */

sfr_b(RTCCNT4);                               /* The RTCCNT4 register is the count of RTCCNT4 */


/* RTC_C Register Offsets */
#define OFS_RTCCTL0                      (0x0000)
#define OFS_RTCCTL0_L                    OFS_RTCCTL0
#define OFS_RTCCTL0_H                    OFS_RTCCTL0+1
#define OFS_RTCCTL13                     (0x0002)
#define OFS_RTCCTL13_L                   OFS_RTCCTL13
#define OFS_RTCCTL13_H                   OFS_RTCCTL13+1
#define OFS_RTCOCAL                      (0x0004)
#define OFS_RTCOCAL_L                    OFS_RTCOCAL
#define OFS_RTCOCAL_H                    OFS_RTCOCAL+1
#define OFS_RTCTCMP                      (0x0006)
#define OFS_RTCTCMP_L                    OFS_RTCTCMP
#define OFS_RTCTCMP_H                    OFS_RTCTCMP+1
#define OFS_RTCPS0CTL                    (0x0008)
#define OFS_RTCPS0CTL_L                  OFS_RTCPS0CTL
#define OFS_RTCPS0CTL_H                  OFS_RTCPS0CTL+1
#define OFS_RTCPS1CTL                    (0x000A)
#define OFS_RTCPS1CTL_L                  OFS_RTCPS1CTL
#define OFS_RTCPS1CTL_H                  OFS_RTCPS1CTL+1
#define OFS_RTCPS                        (0x000C)
#define OFS_RTCPS_L                      OFS_RTCPS
#define OFS_RTCPS_H                      OFS_RTCPS+1
#define OFS_RTCIV                        (0x000E)
#define OFS_RTCIV_L                      OFS_RTCIV
#define OFS_RTCIV_H                      OFS_RTCIV+1
#define OFS_RTCTIM0                      (0x0010)
#define OFS_RTCTIM0_L                    OFS_RTCTIM0
#define OFS_RTCTIM0_H                    OFS_RTCTIM0+1
#define OFS_RTCCNT12                     (0x0010)
#define OFS_RTCCNT12_L                   OFS_RTCCNT12
#define OFS_RTCCNT12_H                   OFS_RTCCNT12+1
#define OFS_RTCTIM1                      (0x0012)
#define OFS_RTCTIM1_L                    OFS_RTCTIM1
#define OFS_RTCTIM1_H                    OFS_RTCTIM1+1
#define OFS_RTCCNT34                     (0x0012)
#define OFS_RTCCNT34_L                   OFS_RTCCNT34
#define OFS_RTCCNT34_H                   OFS_RTCCNT34+1
#define OFS_RTCDATE                      (0x0014)
#define OFS_RTCDATE_L                    OFS_RTCDATE
#define OFS_RTCDATE_H                    OFS_RTCDATE+1
#define OFS_RTCYEAR                      (0x0016)
#define OFS_RTCYEAR_L                    OFS_RTCYEAR
#define OFS_RTCYEAR_H                    OFS_RTCYEAR+1
#define OFS_RTCAMINHR                    (0x0018)
#define OFS_RTCAMINHR_L                  OFS_RTCAMINHR
#define OFS_RTCAMINHR_H                  OFS_RTCAMINHR+1
#define OFS_RTCADOWDAY                   (0x001A)
#define OFS_RTCADOWDAY_L                 OFS_RTCADOWDAY
#define OFS_RTCADOWDAY_H                 OFS_RTCADOWDAY+1
#define OFS_BIN2BCD                      (0x001C)
#define OFS_BIN2BCD_L                    OFS_BIN2BCD
#define OFS_BIN2BCD_H                    OFS_BIN2BCD+1
#define OFS_BCD2BIN                      (0x001E)
#define OFS_BCD2BIN_L                    OFS_BCD2BIN
#define OFS_BCD2BIN_H                    OFS_BCD2BIN+1
#define OFS_RT0PS                        (0x000C)
#define OFS_RT1PS                        (0x000D)
#define OFS_RTCCNT1                      (0x0010)
#define OFS_RTCCNT2                      (0x0011)
#define OFS_RTCCNT3                      (0x0012)
#define OFS_RTCCNT4                      (0x0013)

/* RTC_C Control Bits */

/* RTCCTL0 Control Bits */
#define RTCRDYIFG                        (0x0001)        /* Real-time clock ready interrupt flag */
#define RTCRDYIFG_L                      (0x0001)
#define RTCAIFG                          (0x0002)        /* Real-time clock alarm interrupt flag */
#define RTCAIFG_L                        (0x0002)
#define RTCTEVIFG                        (0x0004)        /* Real-time clock time event interrupt flag */
#define RTCTEVIFG_L                      (0x0004)
#define RTCOFIFG                         (0x0008)        /* 32-kHz crystal oscillator fault interrupt flag */
#define RTCOFIFG_L                       (0x0008)
#define RTCRDYIE                         (0x0010)        /* Real-time clock ready interrupt enable */
#define RTCRDYIE_L                       (0x0010)
#define RTCAIE                           (0x0020)        /* Real-time clock alarm interrupt enable */
#define RTCAIE_L                         (0x0020)
#define RTCTEVIE                         (0x0040)        /* Real-time clock time event interrupt enable */
#define RTCTEVIE_L                       (0x0040)
#define RTCOFIE                          (0x0080)        /* 32-kHz crystal oscillator fault interrupt enable */
#define RTCOFIE_L                        (0x0080)
#define RTCKEY                           (0xa500)        /* Real-time clock key */
#define RTCKEY_H                         (0x00a5)
#define RTCKEY0                          (0x0100)        /* Real-time clock key */
#define RTCKEY0_H                        (0x0001)
#define RTCKEY1                          (0x0200)        /* Real-time clock key */
#define RTCKEY1_H                        (0x0002)
#define RTCKEY2                          (0x0400)        /* Real-time clock key */
#define RTCKEY2_H                        (0x0004)
#define RTCKEY3                          (0x0800)        /* Real-time clock key */
#define RTCKEY3_H                        (0x0008)
#define RTCKEY4                          (0x1000)        /* Real-time clock key */
#define RTCKEY4_H                        (0x0010)
#define RTCKEY5                          (0x2000)        /* Real-time clock key */
#define RTCKEY5_H                        (0x0020)
#define RTCKEY6                          (0x4000)        /* Real-time clock key */
#define RTCKEY6_H                        (0x0040)
#define RTCKEY7                          (0x8000)        /* Real-time clock key */
#define RTCKEY7_H                        (0x0080)

/* RTCCTL13 Control Bits */
#define RTCTEV                           (0x0003)        /* Real-time clock time event */
#define RTCTEV_L                         (0x0003)
#define RTCTEV0                          (0x0001)        /* Real-time clock time event */
#define RTCTEV0_L                        (0x0001)
#define RTCTEV1                          (0x0002)        /* Real-time clock time event */
#define RTCTEV1_L                        (0x0002)
#define RTCTEV_0                         (0x0000)        /* Minute changed */
#define RTCTEV_1                         (0x0001)        /* Hour changed */
#define RTCTEV_1_L                       (0x0001)
#define RTCTEV_2                         (0x0002)        /* Every day at midnight (00:00) */
#define RTCTEV_2_L                       (0x0002)
#define RTCTEV_3                         (0x0003)        /* Every day at noon (12:00) */
#define RTCTEV_3_L                       (0x0003)
#define RTCTEV__MIN                      (0x0000)        /* Minute changed */
#define RTCTEV__HOUR                     (0x0001)        /* Hour changed */
#define RTCTEV__HOUR_L                   (0x0001)
#define RTCTEV__0000                     (0x0002)        /* Every day at midnight (00:00) */
#define RTCTEV__0000_L                   (0x0002)
#define RTCTEV__1200                     (0x0003)        /* Every day at noon (12:00) */
#define RTCTEV__1200_L                   (0x0003)
#define RTCSSEL                          (0x000c)        /* Real-time clock source select */
#define RTCSSEL_L                        (0x000c)
#define RTCSSEL0                         (0x0004)        /* Real-time clock source select */
#define RTCSSEL0_L                       (0x0004)
#define RTCSSEL1                         (0x0008)        /* Real-time clock source select */
#define RTCSSEL1_L                       (0x0008)
#define RTCSSEL_0                        (0x0000)        /* 32-kHz crystal oscillator clock */
#define RTCSSEL_1                        (0x0004)        /* 32-kHz crystal oscillator clock */
#define RTCSSEL_1_L                      (0x0004)
#define RTCSSEL_2                        (0x0008)        /* Output from RT1PS */
#define RTCSSEL_2_L                      (0x0008)
#define RTCSSEL_3                        (0x000c)        /* Output from RT1PS */
#define RTCSSEL_3_L                      (0x000c)
#define RTCSSEL__LFXT                    (0x0000)        /* 32-kHz crystal oscillator clock */
#define RTCSSEL__RT1PS                   (0x0008)        /* Output from RT1PS */
#define RTCSSEL__RT1PS_L                 (0x0008)
#define RTCRDY                           (0x0010)        /* Real-time clock ready */
#define RTCRDY_L                         (0x0010)
#define RTCRDY_0                         (0x0000)        /* RTC time values in transition */
#define RTCRDY_1                         (0x0010)        /* RTC time values safe for reading. This bit indicates when the 
                                                            real-time clock time values are safe for reading. */
#define RTCRDY_1_L                       (0x0010)
#define RTCMODE                          (0x0020)        /* */
#define RTCMODE_L                        (0x0020)
#define RTCMODE_1                        (0x0020)        /* Calendar mode. Always reads a value of 1. */
#define RTCMODE_1_L                      (0x0020)
#define RTCHOLD                          (0x0040)        /* Real-time clock hold */
#define RTCHOLD_L                        (0x0040)
#define RTCHOLD_0                        (0x0000)        /* Real-time clock is operational */
#define RTCHOLD_1                        (0x0040)        /* When set, the calendar is stopped as well as the prescale 
                                                            counters, RT0PS and RT1PS are don't care */
#define RTCHOLD_1_L                      (0x0040)
#define RTCBCD                           (0x0080)        /* Real-time clock BCD select */
#define RTCBCD_L                         (0x0080)
#define RTCBCD_0                         (0x0000)        /* Binary (hexadecimal) code selected */
#define RTCBCD_1                         (0x0080)        /* Binary coded decimal (BCD) code selected */
#define RTCBCD_1_L                       (0x0080)
#define RTCBCD__HEX                      (0x0000)        /* Binary (hexadecimal) code selected */
#define RTCBCD__BCD                      (0x0080)        /* Binary coded decimal (BCD) code selected */
#define RTCBCD__BCD_L                    (0x0080)
#define RTCCALF                          (0x0300)        /* Real-time clock calibration frequency */
#define RTCCALF_H                        (0x0003)
#define RTCCALF0                         (0x0100)        /* Real-time clock calibration frequency */
#define RTCCALF0_H                       (0x0001)
#define RTCCALF1                         (0x0200)        /* Real-time clock calibration frequency */
#define RTCCALF1_H                       (0x0002)
#define RTCCALF_0                        (0x0000)        /* No frequency output to RTCCLK pin */
#define RTCCALF_1                        (0x0100)        /* 512 Hz */
#define RTCCALF_1_H                      (0x0001)
#define RTCCALF_2                        (0x0200)        /* 256 Hz */
#define RTCCALF_2_H                      (0x0002)
#define RTCCALF_3                        (0x0300)        /* 1 Hz */
#define RTCCALF_3_H                      (0x0003)
#define RTCCALF__NONE                    (0x0000)        /* No frequency output to RTCCLK pin */
#define RTCCALF__512                     (0x0100)        /* 512 Hz */
#define RTCCALF__512_H                   (0x0001)
#define RTCCALF__256                     (0x0200)        /* 256 Hz */
#define RTCCALF__256_H                   (0x0002)
#define RTCCALF__1                       (0x0300)        /* 1 Hz */
#define RTCCALF__1_H                     (0x0003)

/* RTCOCAL Control Bits */
#define RTCOCAL0                         (0x0001)        /* Real-time clock offset error calibration */
#define RTCOCAL0_L                       (0x0001)
#define RTCOCAL1                         (0x0002)        /* Real-time clock offset error calibration */
#define RTCOCAL1_L                       (0x0002)
#define RTCOCAL2                         (0x0004)        /* Real-time clock offset error calibration */
#define RTCOCAL2_L                       (0x0004)
#define RTCOCAL3                         (0x0008)        /* Real-time clock offset error calibration */
#define RTCOCAL3_L                       (0x0008)
#define RTCOCAL4                         (0x0010)        /* Real-time clock offset error calibration */
#define RTCOCAL4_L                       (0x0010)
#define RTCOCAL5                         (0x0020)        /* Real-time clock offset error calibration */
#define RTCOCAL5_L                       (0x0020)
#define RTCOCAL6                         (0x0040)        /* Real-time clock offset error calibration */
#define RTCOCAL6_L                       (0x0040)
#define RTCOCAL7                         (0x0080)        /* Real-time clock offset error calibration */
#define RTCOCAL7_L                       (0x0080)
#define RTCOCALS                         (0x8000)        /* Real-time clock offset error calibration sign */
#define RTCOCALS_H                       (0x0080)
#define RTCOCALS_0                       (0x0000)        /* Down calibration. Frequency adjusted down. */
#define RTCOCALS_1                       (0x8000)        /* Up calibration. Frequency adjusted up. */
#define RTCOCALS_1_H                     (0x0080)
#define RTCOCALS__DOWN                   (0x0000)        /* Down calibration. Frequency adjusted down. */
#define RTCOCALS__UP                     (0x8000)        /* Up calibration. Frequency adjusted up. */
#define RTCOCALS__UP_H                   (0x0080)

/* RTCTCMP Control Bits */
#define RTCTCMP0                         (0x0001)        /* Real-time clock temperature compensation */
#define RTCTCMP0_L                       (0x0001)
#define RTCTCMP1                         (0x0002)        /* Real-time clock temperature compensation */
#define RTCTCMP1_L                       (0x0002)
#define RTCTCMP2                         (0x0004)        /* Real-time clock temperature compensation */
#define RTCTCMP2_L                       (0x0004)
#define RTCTCMP3                         (0x0008)        /* Real-time clock temperature compensation */
#define RTCTCMP3_L                       (0x0008)
#define RTCTCMP4                         (0x0010)        /* Real-time clock temperature compensation */
#define RTCTCMP4_L                       (0x0010)
#define RTCTCMP5                         (0x0020)        /* Real-time clock temperature compensation */
#define RTCTCMP5_L                       (0x0020)
#define RTCTCMP6                         (0x0040)        /* Real-time clock temperature compensation */
#define RTCTCMP6_L                       (0x0040)
#define RTCTCMP7                         (0x0080)        /* Real-time clock temperature compensation */
#define RTCTCMP7_L                       (0x0080)
#define RTCTCOK                          (0x2000)        /* Real-time clock temperature compensation write OK */
#define RTCTCOK_H                        (0x0020)
#define RTCTCOK_0                        (0x0000)        /* Write to RTCTCMPx is unsuccessful */
#define RTCTCOK_1                        (0x2000)        /* Write to RTCTCMPx is successful */
#define RTCTCOK_1_H                      (0x0020)
#define RTCTCRDY                         (0x4000)        /* Real-time clock temperature compensation ready */
#define RTCTCRDY_H                       (0x0040)
#define RTCTCMPS                         (0x8000)        /* Real-time clock temperature compensation sign */
#define RTCTCMPS_H                       (0x0080)
#define RTCTCMPS_0                       (0x0000)        /* Down calibration. Frequency adjusted down */
#define RTCTCMPS_1                       (0x8000)        /* Up calibration. Frequency adjusted up */
#define RTCTCMPS_1_H                     (0x0080)
#define RTCTCMPS__DOWN                   (0x0000)        /* Down calibration. Frequency adjusted down */
#define RTCTCMPS__UP                     (0x8000)        /* Up calibration. Frequency adjusted up */
#define RTCTCMPS__UP_H                   (0x0080)

/* RTCPS0CTL Control Bits */
#define RT0PSIFG                         (0x0001)        /* Prescale timer 0 interrupt flag */
#define RT0PSIFG_L                       (0x0001)
#define RT0PSIFG_0                       (0x0000)        /* No time event occurred */
#define RT0PSIFG_1                       (0x0001)        /* Time event occurred */
#define RT0PSIFG_1_L                     (0x0001)
#define RT0PSIE                          (0x0002)        /* Prescale timer 0 interrupt enable */
#define RT0PSIE_L                        (0x0002)
#define RT0PSIE_0                        (0x0000)        /* Interrupt not enabled */
#define RT0PSIE_1                        (0x0002)        /* Interrupt enabled */
#define RT0PSIE_1_L                      (0x0002)
#define RT0PSIE__DISABLE                 (0x0000)        /* Interrupt not enabled */
#define RT0PSIE__ENABLE                  (0x0002)        /* Interrupt enabled */
#define RT0PSIE__ENABLE_L                (0x0002)
#define RT0IP                            (0x001c)        /* Prescale timer 0 interrupt interval */
#define RT0IP_L                          (0x001c)
#define RT0IP0                           (0x0004)        /* Prescale timer 0 interrupt interval */
#define RT0IP0_L                         (0x0004)
#define RT0IP1                           (0x0008)        /* Prescale timer 0 interrupt interval */
#define RT0IP1_L                         (0x0008)
#define RT0IP2                           (0x0010)        /* Prescale timer 0 interrupt interval */
#define RT0IP2_L                         (0x0010)
#define RT0IP_0                          (0x0000)        /* Divide by 2 */
#define RT0IP_1                          (0x0004)        /* Divide by 4 */
#define RT0IP_1_L                        (0x0004)
#define RT0IP_2                          (0x0008)        /* Divide by 8 */
#define RT0IP_2_L                        (0x0008)
#define RT0IP_3                          (0x000c)        /* Divide by 16 */
#define RT0IP_3_L                        (0x000c)
#define RT0IP_4                          (0x0010)        /* Divide by 32 */
#define RT0IP_4_L                        (0x0010)
#define RT0IP_5                          (0x0014)        /* Divide by 64 */
#define RT0IP_5_L                        (0x0014)
#define RT0IP_6                          (0x0018)        /* Divide by 128 */
#define RT0IP_6_L                        (0x0018)
#define RT0IP_7                          (0x001c)        /* Divide by 256 */
#define RT0IP_7_L                        (0x001c)
#define RT0IP__2                         (0x0000)        /* Divide by 2 */
#define RT0IP__4                         (0x0004)        /* Divide by 4 */
#define RT0IP__4_L                       (0x0004)
#define RT0IP__8                         (0x0008)        /* Divide by 8 */
#define RT0IP__8_L                       (0x0008)
#define RT0IP__16                        (0x000c)        /* Divide by 16 */
#define RT0IP__16_L                      (0x000c)
#define RT0IP__32                        (0x0010)        /* Divide by 32 */
#define RT0IP__32_L                      (0x0010)
#define RT0IP__64                        (0x0014)        /* Divide by 64 */
#define RT0IP__64_L                      (0x0014)
#define RT0IP__128                       (0x0018)        /* Divide by 128 */
#define RT0IP__128_L                     (0x0018)
#define RT0IP__256                       (0x001c)        /* Divide by 256 */
#define RT0IP__256_L                     (0x001c)
#define RT0PSHOLD                        (0x0100)        /* Prescale timer 0 hold */
#define RT0PSHOLD_H                      (0x0001)
#define RT0PSHOLD_0                      (0x0000)        /* RT0PS is operational */
#define RT0PSHOLD_1                      (0x0100)        /* RT0PS is held */
#define RT0PSHOLD_1_H                    (0x0001)
#define RT0PSDIV                         (0x3800)        /* Prescale timer 0 clock divide */
#define RT0PSDIV_H                       (0x0038)
#define RT0PSDIV0                        (0x0800)        /* Prescale timer 0 clock divide */
#define RT0PSDIV0_H                      (0x0008)
#define RT0PSDIV1                        (0x1000)        /* Prescale timer 0 clock divide */
#define RT0PSDIV1_H                      (0x0010)
#define RT0PSDIV2                        (0x2000)        /* Prescale timer 0 clock divide */
#define RT0PSDIV2_H                      (0x0020)
#define RT0PSDIV_0                       (0x0000)        /* Divide by 2 */
#define RT0PSDIV_1                       (0x0800)        /* Divide by 4 */
#define RT0PSDIV_1_H                     (0x0008)
#define RT0PSDIV_2                       (0x1000)        /* Divide by 8 */
#define RT0PSDIV_2_H                     (0x0010)
#define RT0PSDIV_3                       (0x1800)        /* Divide by 16 */
#define RT0PSDIV_3_H                     (0x0018)
#define RT0PSDIV_4                       (0x2000)        /* Divide by 32 */
#define RT0PSDIV_4_H                     (0x0020)
#define RT0PSDIV_5                       (0x2800)        /* Divide by 64 */
#define RT0PSDIV_5_H                     (0x0028)
#define RT0PSDIV_6                       (0x3000)        /* Divide by 128 */
#define RT0PSDIV_6_H                     (0x0030)
#define RT0PSDIV_7                       (0x3800)        /* Divide by 256 */
#define RT0PSDIV_7_H                     (0x0038)
#define RT0PSDIV__2                      (0x0000)        /* Divide by 2 */
#define RT0PSDIV__4                      (0x0800)        /* Divide by 4 */
#define RT0PSDIV__4_H                    (0x0008)
#define RT0PSDIV__8                      (0x1000)        /* Divide by 8 */
#define RT0PSDIV__8_H                    (0x0010)
#define RT0PSDIV__16                     (0x1800)        /* Divide by 16 */
#define RT0PSDIV__16_H                   (0x0018)
#define RT0PSDIV__32                     (0x2000)        /* Divide by 32 */
#define RT0PSDIV__32_H                   (0x0020)
#define RT0PSDIV__64                     (0x2800)        /* Divide by 64 */
#define RT0PSDIV__64_H                   (0x0028)
#define RT0PSDIV__128                    (0x3000)        /* Divide by 128 */
#define RT0PSDIV__128_H                  (0x0030)
#define RT0PSDIV__256                    (0x3800)        /* Divide by 256 */
#define RT0PSDIV__256_H                  (0x0038)

/* RTCPS1CTL Control Bits */
#define RT1PSIFG                         (0x0001)        /* Prescale timer 1 interrupt flag */
#define RT1PSIFG_L                       (0x0001)
#define RT1PSIFG_0                       (0x0000)        /* No time event occurred */
#define RT1PSIFG_1                       (0x0001)        /* Time event occurred */
#define RT1PSIFG_1_L                     (0x0001)
#define RT1PSIE                          (0x0002)        /* Prescale timer 1 interrupt enable */
#define RT1PSIE_L                        (0x0002)
#define RT1PSIE_0                        (0x0000)        /* Interrupt not enabled */
#define RT1PSIE_1                        (0x0002)        /* Interrupt enabled (LPM3/LPM3.5 wake-up enabled) */
#define RT1PSIE_1_L                      (0x0002)
#define RT1PSIE__DISABLE                 (0x0000)        /* Interrupt not enabled */
#define RT1PSIE__ENABLE                  (0x0002)        /* Interrupt enabled (LPM3/LPM3.5 wake-up enabled) */
#define RT1PSIE__ENABLE_L                (0x0002)
#define RT1IP                            (0x001c)        /* Prescale timer 1 interrupt interval */
#define RT1IP_L                          (0x001c)
#define RT1IP0                           (0x0004)        /* Prescale timer 1 interrupt interval */
#define RT1IP0_L                         (0x0004)
#define RT1IP1                           (0x0008)        /* Prescale timer 1 interrupt interval */
#define RT1IP1_L                         (0x0008)
#define RT1IP2                           (0x0010)        /* Prescale timer 1 interrupt interval */
#define RT1IP2_L                         (0x0010)
#define RT1IP_0                          (0x0000)        /* Divide by 2 */
#define RT1IP_1                          (0x0004)        /* Divide by 4 */
#define RT1IP_1_L                        (0x0004)
#define RT1IP_2                          (0x0008)        /* Divide by 8 */
#define RT1IP_2_L                        (0x0008)
#define RT1IP_3                          (0x000c)        /* Divide by 16 */
#define RT1IP_3_L                        (0x000c)
#define RT1IP_4                          (0x0010)        /* Divide by 32 */
#define RT1IP_4_L                        (0x0010)
#define RT1IP_5                          (0x0014)        /* Divide by 64 */
#define RT1IP_5_L                        (0x0014)
#define RT1IP_6                          (0x0018)        /* Divide by 128 */
#define RT1IP_6_L                        (0x0018)
#define RT1IP_7                          (0x001c)        /* Divide by 256 */
#define RT1IP_7_L                        (0x001c)
#define RT1IP__2                         (0x0000)        /* Divide by 2 */
#define RT1IP__4                         (0x0004)        /* Divide by 4 */
#define RT1IP__4_L                       (0x0004)
#define RT1IP__8                         (0x0008)        /* Divide by 8 */
#define RT1IP__8_L                       (0x0008)
#define RT1IP__16                        (0x000c)        /* Divide by 16 */
#define RT1IP__16_L                      (0x000c)
#define RT1IP__32                        (0x0010)        /* Divide by 32 */
#define RT1IP__32_L                      (0x0010)
#define RT1IP__64                        (0x0014)        /* Divide by 64 */
#define RT1IP__64_L                      (0x0014)
#define RT1IP__128                       (0x0018)        /* Divide by 128 */
#define RT1IP__128_L                     (0x0018)
#define RT1IP__256                       (0x001c)        /* Divide by 256 */
#define RT1IP__256_L                     (0x001c)
#define RT1PSHOLD                        (0x0100)        /* Prescale timer 1 hold */
#define RT1PSHOLD_H                      (0x0001)
#define RT1PSHOLD_0                      (0x0000)        /* RT1PS is operational */
#define RT1PSHOLD_1                      (0x0100)        /* RT1PS is held */
#define RT1PSHOLD_1_H                    (0x0001)
#define RT1PSDIV                         (0x3800)        /* Prescale timer 1 clock divide */
#define RT1PSDIV_H                       (0x0038)
#define RT1PSDIV0                        (0x0800)        /* Prescale timer 1 clock divide */
#define RT1PSDIV0_H                      (0x0008)
#define RT1PSDIV1                        (0x1000)        /* Prescale timer 1 clock divide */
#define RT1PSDIV1_H                      (0x0010)
#define RT1PSDIV2                        (0x2000)        /* Prescale timer 1 clock divide */
#define RT1PSDIV2_H                      (0x0020)
#define RT1PSDIV_0                       (0x0000)        /* Divide by 2 */
#define RT1PSDIV_1                       (0x0800)        /* Divide by 4 */
#define RT1PSDIV_1_H                     (0x0008)
#define RT1PSDIV_2                       (0x1000)        /* Divide by 8 */
#define RT1PSDIV_2_H                     (0x0010)
#define RT1PSDIV_3                       (0x1800)        /* Divide by 16 */
#define RT1PSDIV_3_H                     (0x0018)
#define RT1PSDIV_4                       (0x2000)        /* Divide by 32 */
#define RT1PSDIV_4_H                     (0x0020)
#define RT1PSDIV_5                       (0x2800)        /* Divide by 64 */
#define RT1PSDIV_5_H                     (0x0028)
#define RT1PSDIV_6                       (0x3000)        /* Divide by 128 */
#define RT1PSDIV_6_H                     (0x0030)
#define RT1PSDIV_7                       (0x3800)        /* Divide by 256 */
#define RT1PSDIV_7_H                     (0x0038)
#define RT1PSDIV__2                      (0x0000)        /* Divide by 2 */
#define RT1PSDIV__4                      (0x0800)        /* Divide by 4 */
#define RT1PSDIV__4_H                    (0x0008)
#define RT1PSDIV__8                      (0x1000)        /* Divide by 8 */
#define RT1PSDIV__8_H                    (0x0010)
#define RT1PSDIV__16                     (0x1800)        /* Divide by 16 */
#define RT1PSDIV__16_H                   (0x0018)
#define RT1PSDIV__32                     (0x2000)        /* Divide by 32 */
#define RT1PSDIV__32_H                   (0x0020)
#define RT1PSDIV__64                     (0x2800)        /* Divide by 64 */
#define RT1PSDIV__64_H                   (0x0028)
#define RT1PSDIV__128                    (0x3000)        /* Divide by 128 */
#define RT1PSDIV__128_H                  (0x0030)
#define RT1PSDIV__256                    (0x3800)        /* Divide by 256 */
#define RT1PSDIV__256_H                  (0x0038)
#define RT1SSEL                          (0xc000)        /* Prescale timer 1 clock source select */
#define RT1SSEL_H                        (0x00c0)
#define RT1SSEL0                         (0x4000)        /* Prescale timer 1 clock source select */
#define RT1SSEL0_H                       (0x0040)
#define RT1SSEL1                         (0x8000)        /* Prescale timer 1 clock source select */
#define RT1SSEL1_H                       (0x0080)
#define RT1SSEL_0                        (0x0000)        /* 32-kHz crystal oscillator clock */
#define RT1SSEL_1                        (0x4000)        /* 32-kHz crystal oscillator clock */
#define RT1SSEL_1_H                      (0x0040)
#define RT1SSEL_2                        (0x8000)        /* Output from RT0PS */
#define RT1SSEL_2_H                      (0x0080)
#define RT1SSEL_3                        (0xc000)        /* Output from RT0PS */
#define RT1SSEL_3_H                      (0x00c0)
#define RT1SSEL__RT0PS                   (0x8000)        /* Output from RT0PS */
#define RT1SSEL__RT0PS_H                 (0x0080)

/* RTCIV Control Bits */
#define RTCIV0                           (0x0001)        /* Real-time clock interrupt vector value */
#define RTCIV0_L                         (0x0001)
#define RTCIV1                           (0x0002)        /* Real-time clock interrupt vector value */
#define RTCIV1_L                         (0x0002)
#define RTCIV2                           (0x0004)        /* Real-time clock interrupt vector value */
#define RTCIV2_L                         (0x0004)
#define RTCIV3                           (0x0008)        /* Real-time clock interrupt vector value */
#define RTCIV3_L                         (0x0008)
#define RTCIV4                           (0x0010)        /* Real-time clock interrupt vector value */
#define RTCIV4_L                         (0x0010)
#define RTCIV5                           (0x0020)        /* Real-time clock interrupt vector value */
#define RTCIV5_L                         (0x0020)
#define RTCIV6                           (0x0040)        /* Real-time clock interrupt vector value */
#define RTCIV6_L                         (0x0040)
#define RTCIV7                           (0x0080)        /* Real-time clock interrupt vector value */
#define RTCIV7_L                         (0x0080)
#define RTCIV8                           (0x0100)        /* Real-time clock interrupt vector value */
#define RTCIV8_H                         (0x0001)
#define RTCIV9                           (0x0200)        /* Real-time clock interrupt vector value */
#define RTCIV9_H                         (0x0002)
#define RTCIV10                          (0x0400)        /* Real-time clock interrupt vector value */
#define RTCIV10_H                        (0x0004)
#define RTCIV11                          (0x0800)        /* Real-time clock interrupt vector value */
#define RTCIV11_H                        (0x0008)
#define RTCIV12                          (0x1000)        /* Real-time clock interrupt vector value */
#define RTCIV12_H                        (0x0010)
#define RTCIV13                          (0x2000)        /* Real-time clock interrupt vector value */
#define RTCIV13_H                        (0x0020)
#define RTCIV14                          (0x4000)        /* Real-time clock interrupt vector value */
#define RTCIV14_H                        (0x0040)
#define RTCIV15                          (0x8000)        /* Real-time clock interrupt vector value */
#define RTCIV15_H                        (0x0080)
#define RTCIV_0                          (0x0000)        /* No interrupt pending */
#define RTCIV_2                          (0x0002)        /* Interrupt Source: RTC oscillator failure; Interrupt Flag: 
                                                            RTCOFIFG; Interrupt Priority: Highest */
#define RTCIV_2_L                        (0x0002)
#define RTCIV_4                          (0x0004)        /* Interrupt Source: RTC ready; Interrupt Flag: RTCRDYIFG */
#define RTCIV_4_L                        (0x0004)
#define RTCIV_6                          (0x0006)        /* Interrupt Source: RTC interval timer; Interrupt Flag: 
                                                            RTCTEVIFG */
#define RTCIV_6_L                        (0x0006)
#define RTCIV_8                          (0x0008)        /* Interrupt Source: RTC user alarm; Interrupt Flag: RTCAIFG */
#define RTCIV_8_L                        (0x0008)
#define RTCIV_10                         (0x000a)        /* Interrupt Source: RTC prescaler 0; Interrupt Flag: RT0PSIFG */
#define RTCIV_10_L                       (0x000a)
#define RTCIV_12                         (0x000c)        /* Interrupt Source: RTC prescaler 1; Interrupt Flag: RT1PSIFG */
#define RTCIV_12_L                       (0x000c)
#define RTCIV__NONE                      (0x0000)        /* No interrupt pending */
#define RTCIV__RTCOFIFG                  (0x0002)        /* Interrupt Source: RTC oscillator failure; Interrupt Flag: 
                                                            RTCOFIFG; Interrupt Priority: Highest */
#define RTCIV__RTCOFIFG_L                (0x0002)
#define RTCIV__RTCRDYIFG                 (0x0004)        /* Interrupt Source: RTC ready; Interrupt Flag: RTCRDYIFG */
#define RTCIV__RTCRDYIFG_L               (0x0004)
#define RTCIV__RTCTEVIFG                 (0x0006)        /* Interrupt Source: RTC interval timer; Interrupt Flag: 
                                                            RTCTEVIFG */
#define RTCIV__RTCTEVIFG_L               (0x0006)
#define RTCIV__RTCAIFG                   (0x0008)        /* Interrupt Source: RTC user alarm; Interrupt Flag: RTCAIFG */
#define RTCIV__RTCAIFG_L                 (0x0008)
#define RTCIV__RT0PSIFG                  (0x000a)        /* Interrupt Source: RTC prescaler 0; Interrupt Flag: RT0PSIFG */
#define RTCIV__RT0PSIFG_L                (0x000a)
#define RTCIV__RT1PSIFG                  (0x000c)        /* Interrupt Source: RTC prescaler 1; Interrupt Flag: RT1PSIFG */
#define RTCIV__RT1PSIFG_L                (0x000c)

/* RTCTIM0 Control Bits */
#define SECONDS                          (0x003f)        /* Seconds (0 to 59) */
#define SECONDS_L                        (0x003f)
#define SECONDS0                         (0x0001)        /* Seconds (0 to 59) */
#define SECONDS0_L                       (0x0001)
#define SECONDS1                         (0x0002)        /* Seconds (0 to 59) */
#define SECONDS1_L                       (0x0002)
#define SECONDS2                         (0x0004)        /* Seconds (0 to 59) */
#define SECONDS2_L                       (0x0004)
#define SECONDS3                         (0x0008)        /* Seconds (0 to 59) */
#define SECONDS3_L                       (0x0008)
#define SECONDS4                         (0x0010)        /* Seconds (0 to 59) */
#define SECONDS4_L                       (0x0010)
#define SECONDS5                         (0x0020)        /* Seconds (0 to 59) */
#define SECONDS5_L                       (0x0020)
#define MINUTES                          (0x3f00)        /* Minutes (0 to 59) */
#define MINUTES_H                        (0x003f)
#define MINUTES0                         (0x0100)        /* Minutes (0 to 59) */
#define MINUTES0_H                       (0x0001)
#define MINUTES1                         (0x0200)        /* Minutes (0 to 59) */
#define MINUTES1_H                       (0x0002)
#define MINUTES2                         (0x0400)        /* Minutes (0 to 59) */
#define MINUTES2_H                       (0x0004)
#define MINUTES3                         (0x0800)        /* Minutes (0 to 59) */
#define MINUTES3_H                       (0x0008)
#define MINUTES4                         (0x1000)        /* Minutes (0 to 59) */
#define MINUTES4_H                       (0x0010)
#define MINUTES5                         (0x2000)        /* Minutes (0 to 59) */
#define MINUTES5_H                       (0x0020)

/* RTCTIM0_BCD Control Bits */
#define SECONDSLOWDIGIT                  (0x000f)        /* Seconds  low digit (0 to 9) */
#define SECONDSLOWDIGIT_L                (0x000f)
#define SECONDSLOWDIGIT0                 (0x0001)        /* Seconds  low digit (0 to 9) */
#define SECONDSLOWDIGIT0_L               (0x0001)
#define SECONDSLOWDIGIT1                 (0x0002)        /* Seconds  low digit (0 to 9) */
#define SECONDSLOWDIGIT1_L               (0x0002)
#define SECONDSLOWDIGIT2                 (0x0004)        /* Seconds  low digit (0 to 9) */
#define SECONDSLOWDIGIT2_L               (0x0004)
#define SECONDSLOWDIGIT3                 (0x0008)        /* Seconds  low digit (0 to 9) */
#define SECONDSLOWDIGIT3_L               (0x0008)
#define SECONDSHIGHDIGIT                 (0x0070)        /* Seconds  high digit (0 to 5) */
#define SECONDSHIGHDIGIT_L               (0x0070)
#define SECONDSHIGHDIGIT0                (0x0010)        /* Seconds  high digit (0 to 5) */
#define SECONDSHIGHDIGIT0_L              (0x0010)
#define SECONDSHIGHDIGIT1                (0x0020)        /* Seconds  high digit (0 to 5) */
#define SECONDSHIGHDIGIT1_L              (0x0020)
#define SECONDSHIGHDIGIT2                (0x0040)        /* Seconds  high digit (0 to 5) */
#define SECONDSHIGHDIGIT2_L              (0x0040)
#define MINUTESLOWDIGIT                  (0x0f00)        /* Minutes  low digit (0 to 9) */
#define MINUTESLOWDIGIT_H                (0x000f)
#define MINUTESLOWDIGIT0                 (0x0100)        /* Minutes  low digit (0 to 9) */
#define MINUTESLOWDIGIT0_H               (0x0001)
#define MINUTESLOWDIGIT1                 (0x0200)        /* Minutes  low digit (0 to 9) */
#define MINUTESLOWDIGIT1_H               (0x0002)
#define MINUTESLOWDIGIT2                 (0x0400)        /* Minutes  low digit (0 to 9) */
#define MINUTESLOWDIGIT2_H               (0x0004)
#define MINUTESLOWDIGIT3                 (0x0800)        /* Minutes  low digit (0 to 9) */
#define MINUTESLOWDIGIT3_H               (0x0008)
#define MINUTESHIGHDIGIT                 (0x7000)        /* Minutes  high digit (0 to 5) */
#define MINUTESHIGHDIGIT_H               (0x0070)
#define MINUTESHIGHDIGIT0                (0x1000)        /* Minutes  high digit (0 to 5) */
#define MINUTESHIGHDIGIT0_H              (0x0010)
#define MINUTESHIGHDIGIT1                (0x2000)        /* Minutes  high digit (0 to 5) */
#define MINUTESHIGHDIGIT1_H              (0x0020)
#define MINUTESHIGHDIGIT2                (0x4000)        /* Minutes  high digit (0 to 5) */
#define MINUTESHIGHDIGIT2_H              (0x0040)

/* RTCTIM1 Control Bits */
#define HOURS                            (0x001f)        /* Hours (0 to 23) */
#define HOURS_L                          (0x001f)
#define HOURS0                           (0x0001)        /* Hours (0 to 23) */
#define HOURS0_L                         (0x0001)
#define HOURS1                           (0x0002)        /* Hours (0 to 23) */
#define HOURS1_L                         (0x0002)
#define HOURS2                           (0x0004)        /* Hours (0 to 23) */
#define HOURS2_L                         (0x0004)
#define HOURS3                           (0x0008)        /* Hours (0 to 23) */
#define HOURS3_L                         (0x0008)
#define HOURS4                           (0x0010)        /* Hours (0 to 23) */
#define HOURS4_L                         (0x0010)
#define DAYOFWEEK                        (0x0700)        /* Day of week (0 to 6) */
#define DAYOFWEEK_H                      (0x0007)
#define DAYOFWEEK0                       (0x0100)        /* Day of week (0 to 6) */
#define DAYOFWEEK0_H                     (0x0001)
#define DAYOFWEEK1                       (0x0200)        /* Day of week (0 to 6) */
#define DAYOFWEEK1_H                     (0x0002)
#define DAYOFWEEK2                       (0x0400)        /* Day of week (0 to 6) */
#define DAYOFWEEK2_H                     (0x0004)

/* RTCTIM1_BCD Control Bits */
#define HOURSLOWDIGIT                    (0x000f)        /* Hours  low digit (0 to 9) */
#define HOURSLOWDIGIT_L                  (0x000f)
#define HOURSLOWDIGIT0                   (0x0001)        /* Hours  low digit (0 to 9) */
#define HOURSLOWDIGIT0_L                 (0x0001)
#define HOURSLOWDIGIT1                   (0x0002)        /* Hours  low digit (0 to 9) */
#define HOURSLOWDIGIT1_L                 (0x0002)
#define HOURSLOWDIGIT2                   (0x0004)        /* Hours  low digit (0 to 9) */
#define HOURSLOWDIGIT2_L                 (0x0004)
#define HOURSLOWDIGIT3                   (0x0008)        /* Hours  low digit (0 to 9) */
#define HOURSLOWDIGIT3_L                 (0x0008)
#define HOURSHIGHDIGIT                   (0x0030)        /* Hours  high digit (0 to 2) */
#define HOURSHIGHDIGIT_L                 (0x0030)
#define HOURSHIGHDIGIT0                  (0x0010)        /* Hours  high digit (0 to 2) */
#define HOURSHIGHDIGIT0_L                (0x0010)
#define HOURSHIGHDIGIT1                  (0x0020)        /* Hours  high digit (0 to 2) */
#define HOURSHIGHDIGIT1_L                (0x0020)

/* RTCDATE Control Bits */
#define DAY                              (0x001f)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY_L                            (0x001f)
#define DAY0                             (0x0001)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY0_L                           (0x0001)
#define DAY1                             (0x0002)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY1_L                           (0x0002)
#define DAY2                             (0x0004)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY2_L                           (0x0004)
#define DAY3                             (0x0008)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY3_L                           (0x0008)
#define DAY4                             (0x0010)        /* Day of month (1 to 28, 29, 30, 31) */
#define DAY4_L                           (0x0010)
#define MONTH                            (0x0f00)        /* Month (1 to 12) */
#define MONTH_H                          (0x000f)
#define MONTH0                           (0x0100)        /* Month (1 to 12) */
#define MONTH0_H                         (0x0001)
#define MONTH1                           (0x0200)        /* Month (1 to 12) */
#define MONTH1_H                         (0x0002)
#define MONTH2                           (0x0400)        /* Month (1 to 12) */
#define MONTH2_H                         (0x0004)
#define MONTH3                           (0x0800)        /* Month (1 to 12) */
#define MONTH3_H                         (0x0008)

/* RTCDATE_BCD Control Bits */
#define DAYLOWDIGIT                      (0x000f)        /* Day of month  low digit (0 to 9) */
#define DAYLOWDIGIT_L                    (0x000f)
#define DAYLOWDIGIT0                     (0x0001)        /* Day of month  low digit (0 to 9) */
#define DAYLOWDIGIT0_L                   (0x0001)
#define DAYLOWDIGIT1                     (0x0002)        /* Day of month  low digit (0 to 9) */
#define DAYLOWDIGIT1_L                   (0x0002)
#define DAYLOWDIGIT2                     (0x0004)        /* Day of month  low digit (0 to 9) */
#define DAYLOWDIGIT2_L                   (0x0004)
#define DAYLOWDIGIT3                     (0x0008)        /* Day of month  low digit (0 to 9) */
#define DAYLOWDIGIT3_L                   (0x0008)
#define DAYHIGHDIGIT                     (0x0030)        /* Day of month  high digit (0 to 3) */
#define DAYHIGHDIGIT_L                   (0x0030)
#define DAYHIGHDIGIT0                    (0x0010)        /* Day of month  high digit (0 to 3) */
#define DAYHIGHDIGIT0_L                  (0x0010)
#define DAYHIGHDIGIT1                    (0x0020)        /* Day of month  high digit (0 to 3) */
#define DAYHIGHDIGIT1_L                  (0x0020)
#define MONTHLOWDIGIT                    (0x0f00)        /* Month  low digit (0 to 9) */
#define MONTHLOWDIGIT_H                  (0x000f)
#define MONTHLOWDIGIT0                   (0x0100)        /* Month  low digit (0 to 9) */
#define MONTHLOWDIGIT0_H                 (0x0001)
#define MONTHLOWDIGIT1                   (0x0200)        /* Month  low digit (0 to 9) */
#define MONTHLOWDIGIT1_H                 (0x0002)
#define MONTHLOWDIGIT2                   (0x0400)        /* Month  low digit (0 to 9) */
#define MONTHLOWDIGIT2_H                 (0x0004)
#define MONTHLOWDIGIT3                   (0x0800)        /* Month  low digit (0 to 9) */
#define MONTHLOWDIGIT3_H                 (0x0008)
#define MONTHHIGHDIGIT                   (0x1000)        /* Month  high digit (0 or 1) */
#define MONTHHIGHDIGIT_H                 (0x0010)

/* RTCYEAR Control Bits */
#define YEARLOWBYTE                      (0x00ff)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE_L                    (0x00ff)
#define YEARLOWBYTE0                     (0x0001)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE0_L                   (0x0001)
#define YEARLOWBYTE1                     (0x0002)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE1_L                   (0x0002)
#define YEARLOWBYTE2                     (0x0004)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE2_L                   (0x0004)
#define YEARLOWBYTE3                     (0x0008)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE3_L                   (0x0008)
#define YEARLOWBYTE4                     (0x0010)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE4_L                   (0x0010)
#define YEARLOWBYTE5                     (0x0020)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE5_L                   (0x0020)
#define YEARLOWBYTE6                     (0x0040)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE6_L                   (0x0040)
#define YEARLOWBYTE7                     (0x0080)        /* Year  low byte. Valid values for Year are 0 to 4095. */
#define YEARLOWBYTE7_L                   (0x0080)
#define YEARHIGHBYTE                     (0x0f00)        /* Year  high byte. Valid values for Year are 0 to 4095. */
#define YEARHIGHBYTE_H                   (0x000f)
#define YEARHIGHBYTE0                    (0x0100)        /* Year  high byte. Valid values for Year are 0 to 4095. */
#define YEARHIGHBYTE0_H                  (0x0001)
#define YEARHIGHBYTE1                    (0x0200)        /* Year  high byte. Valid values for Year are 0 to 4095. */
#define YEARHIGHBYTE1_H                  (0x0002)
#define YEARHIGHBYTE2                    (0x0400)        /* Year  high byte. Valid values for Year are 0 to 4095. */
#define YEARHIGHBYTE2_H                  (0x0004)
#define YEARHIGHBYTE3                    (0x0800)        /* Year  high byte. Valid values for Year are 0 to 4095. */
#define YEARHIGHBYTE3_H                  (0x0008)

/* RTCYEAR_BCD Control Bits */
#define YEAR                             (0x000f)        /* Year  lowest digit (0 to 9) */
#define YEAR_L                           (0x000f)
#define YEAR0                            (0x0001)        /* Year  lowest digit (0 to 9) */
#define YEAR0_L                          (0x0001)
#define YEAR1                            (0x0002)        /* Year  lowest digit (0 to 9) */
#define YEAR1_L                          (0x0002)
#define YEAR2                            (0x0004)        /* Year  lowest digit (0 to 9) */
#define YEAR2_L                          (0x0004)
#define YEAR3                            (0x0008)        /* Year  lowest digit (0 to 9) */
#define YEAR3_L                          (0x0008)
#define DECADE                           (0x00f0)        /* Decade (0 to 9) */
#define DECADE_L                         (0x00f0)
#define DECADE0                          (0x0010)        /* Decade (0 to 9) */
#define DECADE0_L                        (0x0010)
#define DECADE1                          (0x0020)        /* Decade (0 to 9) */
#define DECADE1_L                        (0x0020)
#define DECADE2                          (0x0040)        /* Decade (0 to 9) */
#define DECADE2_L                        (0x0040)
#define DECADE3                          (0x0080)        /* Decade (0 to 9) */
#define DECADE3_L                        (0x0080)
#define CENTURYLOWDIGIT                  (0x0f00)        /* Century  low digit (0 to 9) */
#define CENTURYLOWDIGIT_H                (0x000f)
#define CENTURYLOWDIGIT0                 (0x0100)        /* Century  low digit (0 to 9) */
#define CENTURYLOWDIGIT0_H               (0x0001)
#define CENTURYLOWDIGIT1                 (0x0200)        /* Century  low digit (0 to 9) */
#define CENTURYLOWDIGIT1_H               (0x0002)
#define CENTURYLOWDIGIT2                 (0x0400)        /* Century  low digit (0 to 9) */
#define CENTURYLOWDIGIT2_H               (0x0004)
#define CENTURYLOWDIGIT3                 (0x0800)        /* Century  low digit (0 to 9) */
#define CENTURYLOWDIGIT3_H               (0x0008)
#define CENTURYHIGHDIGIT                 (0x7000)        /* Century  high digit (0 to 4) */
#define CENTURYHIGHDIGIT_H               (0x0070)
#define CENTURYHIGHDIGIT0                (0x1000)        /* Century  high digit (0 to 4) */
#define CENTURYHIGHDIGIT0_H              (0x0010)
#define CENTURYHIGHDIGIT1                (0x2000)        /* Century  high digit (0 to 4) */
#define CENTURYHIGHDIGIT1_H              (0x0020)
#define CENTURYHIGHDIGIT2                (0x4000)        /* Century  high digit (0 to 4) */
#define CENTURYHIGHDIGIT2_H              (0x0040)

/* RTCAMINHR Control Bits */
#define MIN                              (0x003f)        /* Minutes (0 to 59) */
#define MIN_L                            (0x003f)
#define MIN0                             (0x0001)        /* Minutes (0 to 59) */
#define MIN0_L                           (0x0001)
#define MIN1                             (0x0002)        /* Minutes (0 to 59) */
#define MIN1_L                           (0x0002)
#define MIN2                             (0x0004)        /* Minutes (0 to 59) */
#define MIN2_L                           (0x0004)
#define MIN3                             (0x0008)        /* Minutes (0 to 59) */
#define MIN3_L                           (0x0008)
#define MIN4                             (0x0010)        /* Minutes (0 to 59) */
#define MIN4_L                           (0x0010)
#define MIN5                             (0x0020)        /* Minutes (0 to 59) */
#define MIN5_L                           (0x0020)
#define MINAE                            (0x0080)        /* Alarm enable */
#define MINAE_L                          (0x0080)
#define HOUR                             (0x1f00)        /* Hours (0 to 23) */
#define HOUR_H                           (0x001f)
#define HOUR0                            (0x0100)        /* Hours (0 to 23) */
#define HOUR0_H                          (0x0001)
#define HOUR1                            (0x0200)        /* Hours (0 to 23) */
#define HOUR1_H                          (0x0002)
#define HOUR2                            (0x0400)        /* Hours (0 to 23) */
#define HOUR2_H                          (0x0004)
#define HOUR3                            (0x0800)        /* Hours (0 to 23) */
#define HOUR3_H                          (0x0008)
#define HOUR4                            (0x1000)        /* Hours (0 to 23) */
#define HOUR4_H                          (0x0010)
#define HOURAE                           (0x8000)        /* Alarm enable */
#define HOURAE_H                         (0x0080)

/* RTCADOWDAY Control Bits */
#define DOW                              (0x0007)        /* Day of week (0 to 6) */
#define DOW_L                            (0x0007)
#define DOW0                             (0x0001)        /* Day of week (0 to 6) */
#define DOW0_L                           (0x0001)
#define DOW1                             (0x0002)        /* Day of week (0 to 6) */
#define DOW1_L                           (0x0002)
#define DOW2                             (0x0004)        /* Day of week (0 to 6) */
#define DOW2_L                           (0x0004)
#define DOWAE                            (0x0080)        /* Alarm enable */
#define DOWAE_L                          (0x0080)
#define DAYAE                            (0x8000)        /* Alarm enable */
#define DAYAE_H                          (0x0080)

/* RTCADOWDAY_BCD Control Bits */
#define DAY_LD                           (0x0f00)        /* Day of month  low digit (0 to 9) */
#define DAY_LD_H                         (0x000f)
#define DAY_LD0                          (0x0100)        /* Day of month  low digit (0 to 9) */
#define DAY_LD0_H                        (0x0001)
#define DAY_LD1                          (0x0200)        /* Day of month  low digit (0 to 9) */
#define DAY_LD1_H                        (0x0002)
#define DAY_LD2                          (0x0400)        /* Day of month  low digit (0 to 9) */
#define DAY_LD2_H                        (0x0004)
#define DAY_LD3                          (0x0800)        /* Day of month  low digit (0 to 9) */
#define DAY_LD3_H                        (0x0008)
#define DAY_HD                           (0x3000)        /* Day of month  high digit (0 to 3) */
#define DAY_HD_H                         (0x0030)
#define DAY_HD0                          (0x1000)        /* Day of month  high digit (0 to 3) */
#define DAY_HD0_H                        (0x0010)
#define DAY_HD1                          (0x2000)        /* Day of month  high digit (0 to 3) */
#define DAY_HD1_H                        (0x0020)


/*****************************************************************************
 SAPH Registers
*****************************************************************************/

#define __MSP430_HAS_SAPH__                   /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SAPH__ 0x0E00
#define SAPH_BASE              __MSP430_BASEADDRESS_SAPH__

sfr_w(SAPHIIDX);                              /* Interrupt Index */
sfr_b(SAPHIIDX_L);
sfr_b(SAPHIIDX_H);
sfr_w(SAPHMIS);                               /* Masked Interrupt Satus */
sfr_b(SAPHMIS_L);
sfr_b(SAPHMIS_H);
sfr_w(SAPHRIS);                               /* Raw Interrupt Status */
sfr_b(SAPHRIS_L);
sfr_b(SAPHRIS_H);
sfr_w(SAPHIMSC);                              /* Interrupt Mask */
sfr_b(SAPHIMSC_L);
sfr_b(SAPHIMSC_H);
sfr_w(SAPHICR);                               /* Interrupt Clear */
sfr_b(SAPHICR_L);
sfr_b(SAPHICR_H);
sfr_w(SAPHISR);                               /* Interrupt Set */
sfr_b(SAPHISR_L);
sfr_b(SAPHISR_H);
sfr_w(SAPHDESCLO);                            /* Module-Descriptor Low Word */
sfr_b(SAPHDESCLO_L);
sfr_b(SAPHDESCLO_H);
sfr_w(SAPHDESCHI);                            /* Module-Descriptor High Word */
sfr_b(SAPHDESCHI_L);
sfr_b(SAPHDESCHI_H);
sfr_w(SAPHKEY);                               /* Key */
sfr_b(SAPHKEY_L);
sfr_b(SAPHKEY_H);
sfr_w(SAPHOCTL0);                             /* Physical Interface Output Control #0 */
sfr_b(SAPHOCTL0_L);
sfr_b(SAPHOCTL0_H);
sfr_w(SAPHOCTL1);                             /* Physical Interface Output Control #1 */
sfr_b(SAPHOCTL1_L);
sfr_b(SAPHOCTL1_H);
sfr_w(SAPHOSEL);                              /* Physical Interface Output Function Select */
sfr_b(SAPHOSEL_L);
sfr_b(SAPHOSEL_H);
sfr_w(SAPHCH0PUT);                            /* Channel 0 Pull UpTrim Register */
sfr_b(SAPHCH0PUT_L);
sfr_b(SAPHCH0PUT_H);
sfr_w(SAPHCH0PDT);                            /* Channel 0 Pull DownTrim Register */
sfr_b(SAPHCH0PDT_L);
sfr_b(SAPHCH0PDT_H);
sfr_w(SAPHCH0TT);                             /* Channel 0 Termination Trim */
sfr_b(SAPHCH0TT_L);
sfr_b(SAPHCH0TT_H);
sfr_w(SAPHCH1PUT);                            /* Channel 1 Pull UpTrim */
sfr_b(SAPHCH1PUT_L);
sfr_b(SAPHCH1PUT_H);
sfr_w(SAPHCH1PDT);                            /* Channel 1 Pull DownTrim */
sfr_b(SAPHCH1PDT_L);
sfr_b(SAPHCH1PDT_H);
sfr_w(SAPHCH1TT);                             /* Channel 1 Termination Trim */
sfr_b(SAPHCH1TT_L);
sfr_b(SAPHCH1TT_H);
sfr_w(SAPHMCNF);                              /* Mode Configuration Register */
sfr_b(SAPHMCNF_L);
sfr_b(SAPHMCNF_H);
sfr_w(SAPHTACTL);                             /* Trim Access Control */
sfr_b(SAPHTACTL_L);
sfr_b(SAPHTACTL_H);
sfr_w(SAPHICTL0);                             /* Physical Interface Input Control #0 */
sfr_b(SAPHICTL0_L);
sfr_b(SAPHICTL0_H);
sfr_w(SAPHBCTL);                              /* Bias Control */
sfr_b(SAPHBCTL_L);
sfr_b(SAPHBCTL_H);
sfr_w(SAPHPGC);                               /* PPG Count */
sfr_b(SAPHPGC_L);
sfr_b(SAPHPGC_H);
sfr_w(SAPHPGLPER);                            /* Pulse Generator Low Period */
sfr_b(SAPHPGLPER_L);
sfr_b(SAPHPGLPER_H);
sfr_w(SAPHPGHPER);                            /* Pulse Generator High Period */
sfr_b(SAPHPGHPER_L);
sfr_b(SAPHPGHPER_H);
sfr_w(SAPHPGCTL);                             /* PPG Control */
sfr_b(SAPHPGCTL_L);
sfr_b(SAPHPGCTL_H);
sfr_w(SAPHPPGTRIG);                           /* PPG Software Trigger */
sfr_b(SAPHPPGTRIG_L);
sfr_b(SAPHPPGTRIG_H);
sfr_w(SAPHASCTL0);                            /* A-SEQ control register 0 */
sfr_b(SAPHASCTL0_L);
sfr_b(SAPHASCTL0_H);
sfr_w(SAPHASCTL1);                            /* A-SEQ control register 1 */
sfr_b(SAPHASCTL1_L);
sfr_b(SAPHASCTL1_H);
sfr_b(SAPHASQTRIG);                           /* ASQ Software Trigger */

sfr_w(SAPHAPOL);                              /* ASQ ping output polarity */
sfr_b(SAPHAPOL_L);
sfr_b(SAPHAPOL_H);
sfr_w(SAPHAPLEV);                             /* ASQ ping pause level */
sfr_b(SAPHAPLEV_L);
sfr_b(SAPHAPLEV_H);
sfr_w(SAPHAPHIZ);                             /* ASQ ping pause impedance */
sfr_b(SAPHAPHIZ_L);
sfr_b(SAPHAPHIZ_H);
sfr_w(SAPHATM_A);                             /* A-SEQ start to 1st ping */
sfr_b(SAPHATM_A_L);
sfr_b(SAPHATM_A_H);
sfr_w(SAPHATM_B);                             /* ASQ start to ADC arm */
sfr_b(SAPHATM_B_L);
sfr_b(SAPHATM_B_H);
sfr_w(SAPHATM_C);                             /* Count for the TIMEMARK C Event */
sfr_b(SAPHATM_C_L);
sfr_b(SAPHATM_C_H);
sfr_w(SAPHATM_D);                             /* ASQ start to ADC trig */
sfr_b(SAPHATM_D_L);
sfr_b(SAPHATM_D_H);
sfr_w(SAPHATM_E);                             /* ASQ start to restart */
sfr_b(SAPHATM_E_L);
sfr_b(SAPHATM_E_H);
sfr_w(SAPHATM_F);                             /* ASQ start to timeout */
sfr_b(SAPHATM_F_L);
sfr_b(SAPHATM_F_H);
sfr_w(SAPHTBCTL);                             /* Time Base Control */
sfr_b(SAPHTBCTL_L);
sfr_b(SAPHTBCTL_H);
sfr_w(SAPHATIMLO);                            /* Acquisition Timer Low Part */
sfr_b(SAPHATIMLO_L);
sfr_b(SAPHATIMLO_H);
sfr_w(SAPHATIMHI);                            /* Acquisition Timer High Part */
sfr_b(SAPHATIMHI_L);
sfr_b(SAPHATIMHI_H);

/* SAPH Register Offsets */
#define OFS_SAPHIIDX                     (0x0000)
#define OFS_SAPHIIDX_L                   OFS_SAPHIIDX
#define OFS_SAPHIIDX_H                   OFS_SAPHIIDX+1
#define OFS_SAPHMIS                      (0x0002)
#define OFS_SAPHMIS_L                    OFS_SAPHMIS
#define OFS_SAPHMIS_H                    OFS_SAPHMIS+1
#define OFS_SAPHRIS                      (0x0004)
#define OFS_SAPHRIS_L                    OFS_SAPHRIS
#define OFS_SAPHRIS_H                    OFS_SAPHRIS+1
#define OFS_SAPHIMSC                     (0x0006)
#define OFS_SAPHIMSC_L                   OFS_SAPHIMSC
#define OFS_SAPHIMSC_H                   OFS_SAPHIMSC+1
#define OFS_SAPHICR                      (0x0008)
#define OFS_SAPHICR_L                    OFS_SAPHICR
#define OFS_SAPHICR_H                    OFS_SAPHICR+1
#define OFS_SAPHISR                      (0x000A)
#define OFS_SAPHISR_L                    OFS_SAPHISR
#define OFS_SAPHISR_H                    OFS_SAPHISR+1
#define OFS_SAPHDESCLO                   (0x000C)
#define OFS_SAPHDESCLO_L                 OFS_SAPHDESCLO
#define OFS_SAPHDESCLO_H                 OFS_SAPHDESCLO+1
#define OFS_SAPHDESCHI                   (0x000E)
#define OFS_SAPHDESCHI_L                 OFS_SAPHDESCHI
#define OFS_SAPHDESCHI_H                 OFS_SAPHDESCHI+1
#define OFS_SAPHKEY                      (0x0010)
#define OFS_SAPHKEY_L                    OFS_SAPHKEY
#define OFS_SAPHKEY_H                    OFS_SAPHKEY+1
#define OFS_SAPHOCTL0                    (0x0012)
#define OFS_SAPHOCTL0_L                  OFS_SAPHOCTL0
#define OFS_SAPHOCTL0_H                  OFS_SAPHOCTL0+1
#define OFS_SAPHOCTL1                    (0x0014)
#define OFS_SAPHOCTL1_L                  OFS_SAPHOCTL1
#define OFS_SAPHOCTL1_H                  OFS_SAPHOCTL1+1
#define OFS_SAPHOSEL                     (0x0016)
#define OFS_SAPHOSEL_L                   OFS_SAPHOSEL
#define OFS_SAPHOSEL_H                   OFS_SAPHOSEL+1
#define OFS_SAPHCH0PUT                   (0x0020)
#define OFS_SAPHCH0PUT_L                 OFS_SAPHCH0PUT
#define OFS_SAPHCH0PUT_H                 OFS_SAPHCH0PUT+1
#define OFS_SAPHCH0PDT                   (0x0022)
#define OFS_SAPHCH0PDT_L                 OFS_SAPHCH0PDT
#define OFS_SAPHCH0PDT_H                 OFS_SAPHCH0PDT+1
#define OFS_SAPHCH0TT                    (0x0024)
#define OFS_SAPHCH0TT_L                  OFS_SAPHCH0TT
#define OFS_SAPHCH0TT_H                  OFS_SAPHCH0TT+1
#define OFS_SAPHCH1PUT                   (0x0026)
#define OFS_SAPHCH1PUT_L                 OFS_SAPHCH1PUT
#define OFS_SAPHCH1PUT_H                 OFS_SAPHCH1PUT+1
#define OFS_SAPHCH1PDT                   (0x0028)
#define OFS_SAPHCH1PDT_L                 OFS_SAPHCH1PDT
#define OFS_SAPHCH1PDT_H                 OFS_SAPHCH1PDT+1
#define OFS_SAPHCH1TT                    (0x002A)
#define OFS_SAPHCH1TT_L                  OFS_SAPHCH1TT
#define OFS_SAPHCH1TT_H                  OFS_SAPHCH1TT+1
#define OFS_SAPHMCNF                     (0x002C)
#define OFS_SAPHMCNF_L                   OFS_SAPHMCNF
#define OFS_SAPHMCNF_H                   OFS_SAPHMCNF+1
#define OFS_SAPHTACTL                    (0x002E)
#define OFS_SAPHTACTL_L                  OFS_SAPHTACTL
#define OFS_SAPHTACTL_H                  OFS_SAPHTACTL+1
#define OFS_SAPHICTL0                    (0x0030)
#define OFS_SAPHICTL0_L                  OFS_SAPHICTL0
#define OFS_SAPHICTL0_H                  OFS_SAPHICTL0+1
#define OFS_SAPHBCTL                     (0x0034)
#define OFS_SAPHBCTL_L                   OFS_SAPHBCTL
#define OFS_SAPHBCTL_H                   OFS_SAPHBCTL+1
#define OFS_SAPHPGC                      (0x0040)
#define OFS_SAPHPGC_L                    OFS_SAPHPGC
#define OFS_SAPHPGC_H                    OFS_SAPHPGC+1
#define OFS_SAPHPGLPER                   (0x0042)
#define OFS_SAPHPGLPER_L                 OFS_SAPHPGLPER
#define OFS_SAPHPGLPER_H                 OFS_SAPHPGLPER+1
#define OFS_SAPHPGHPER                   (0x0044)
#define OFS_SAPHPGHPER_L                 OFS_SAPHPGHPER
#define OFS_SAPHPGHPER_H                 OFS_SAPHPGHPER+1
#define OFS_SAPHPGCTL                    (0x0046)
#define OFS_SAPHPGCTL_L                  OFS_SAPHPGCTL
#define OFS_SAPHPGCTL_H                  OFS_SAPHPGCTL+1
#define OFS_SAPHPPGTRIG                  (0x0048)
#define OFS_SAPHPPGTRIG_L                OFS_SAPHPPGTRIG
#define OFS_SAPHPPGTRIG_H                OFS_SAPHPPGTRIG+1
#define OFS_SAPHASCTL0                   (0x0060)
#define OFS_SAPHASCTL0_L                 OFS_SAPHASCTL0
#define OFS_SAPHASCTL0_H                 OFS_SAPHASCTL0+1
#define OFS_SAPHASCTL1                   (0x0062)
#define OFS_SAPHASCTL1_L                 OFS_SAPHASCTL1
#define OFS_SAPHASCTL1_H                 OFS_SAPHASCTL1+1
#define OFS_SAPHASQTRIG                  (0x0064)
#define OFS_SAPHAPOL                     (0x0066)
#define OFS_SAPHAPOL_L                   OFS_SAPHAPOL
#define OFS_SAPHAPOL_H                   OFS_SAPHAPOL+1
#define OFS_SAPHAPLEV                    (0x0068)
#define OFS_SAPHAPLEV_L                  OFS_SAPHAPLEV
#define OFS_SAPHAPLEV_H                  OFS_SAPHAPLEV+1
#define OFS_SAPHAPHIZ                    (0x006A)
#define OFS_SAPHAPHIZ_L                  OFS_SAPHAPHIZ
#define OFS_SAPHAPHIZ_H                  OFS_SAPHAPHIZ+1
#define OFS_SAPHATM_A                    (0x006E)
#define OFS_SAPHATM_A_L                  OFS_SAPHATM_A
#define OFS_SAPHATM_A_H                  OFS_SAPHATM_A+1
#define OFS_SAPHATM_B                    (0x0070)
#define OFS_SAPHATM_B_L                  OFS_SAPHATM_B
#define OFS_SAPHATM_B_H                  OFS_SAPHATM_B+1
#define OFS_SAPHATM_C                    (0x0072)
#define OFS_SAPHATM_C_L                  OFS_SAPHATM_C
#define OFS_SAPHATM_C_H                  OFS_SAPHATM_C+1
#define OFS_SAPHATM_D                    (0x0074)
#define OFS_SAPHATM_D_L                  OFS_SAPHATM_D
#define OFS_SAPHATM_D_H                  OFS_SAPHATM_D+1
#define OFS_SAPHATM_E                    (0x0076)
#define OFS_SAPHATM_E_L                  OFS_SAPHATM_E
#define OFS_SAPHATM_E_H                  OFS_SAPHATM_E+1
#define OFS_SAPHATM_F                    (0x0078)
#define OFS_SAPHATM_F_L                  OFS_SAPHATM_F
#define OFS_SAPHATM_F_H                  OFS_SAPHATM_F+1
#define OFS_SAPHTBCTL                    (0x007A)
#define OFS_SAPHTBCTL_L                  OFS_SAPHTBCTL
#define OFS_SAPHTBCTL_H                  OFS_SAPHTBCTL+1
#define OFS_SAPHATIMLO                   (0x007C)
#define OFS_SAPHATIMLO_L                 OFS_SAPHATIMLO
#define OFS_SAPHATIMLO_H                 OFS_SAPHATIMLO+1
#define OFS_SAPHATIMHI                   (0x007E)
#define OFS_SAPHATIMHI_L                 OFS_SAPHATIMHI
#define OFS_SAPHATIMHI_H                 OFS_SAPHATIMHI+1

/* SAPH Control Bits */

/* SAPHIIDX Control Bits */
#define IIDX_3                           (0x0006)        /* The interrupt occurs when ASQ completes all of the 
                                                            measurements programmed in ASCTL0.PNGCNT. For example, when 
                                                            ASCTL0.PNGCNT = 3, total four measurements are performed. The 
                                                            interrupt indicates that all of the four measurements have 
                                                            been completed.  Note: After the ASQ is triggered, if the 
                                                            current measurement is interrupted by entering debug halt mode
                                                            (UUPS.RIS.STPBYDB = 1), the SEQDN interrupt is also reported. */
#define IIDX_3_L                         (0x0006)
#define IIDX_4                           (0x0008)        /* The interrupt occurs when the PPG completes pulse generation. */
#define IIDX_4_L                         (0x0008)
#define IIDX__NONE                       (0x0000)        /* no interrupts pending */
#define IIDX__DATAERR                    (0x0002)        /* This interrupt indicates that either WINHI interrupt or WINLO 
                                                            interrupt has occurred in SDHS. */
#define IIDX__DATAERR_L                  (0x0002)
#define IIDX__TMFTO                      (0x0004)        /* This interrupt is valid when ASQ is activcve (auto mode). The 
                                                            interrupt indicates that the time counter in ASQ has reached 
                                                            to TIMEMARK_F (timeout). */
#define IIDX__TMFTO_L                    (0x0004)
#define IIDX__SEQDN                      (0x0006)        /* The interrupt occurs when ASQ completes all of the 
                                                            measurements programmed in ASCTL0.PNGCNT. For example, when 
                                                            ASCTL0.PNGCNT = 3, total four measurements are performed. The 
                                                            interrupt indicates that all of the four measurements have 
                                                            been completed.  Note: After the ASQ is triggered, if the 
                                                            current measurement is interrupted by entering debug halt mode
                                                            (UUPS.RIS.STPBYDB = 1), the SEQDN interrupt is also reported. */
#define IIDX__SEQDN_L                    (0x0006)
#define IIDX__PNGDN                      (0x0008)        /* The interrupt occurs when the PPG completes pulse generation. */
#define IIDX__PNGDN_L                    (0x0008)

/* SAPHMIS Control Bits */
#define DATAERR                          (0x0001)        /* */
#define DATAERR_L                        (0x0001)
#define TMFTO                            (0x0002)        /* */
#define TMFTO_L                          (0x0002)
#define SEQDN                            (0x0004)        /* */
#define SEQDN_L                          (0x0004)
#define PNGDN                            (0x0008)        /* */
#define PNGDN_L                          (0x0008)

/* SAPHKEY Control Bits */
#define KEY                              (0x454b)        /* KEYID Key and ID */
#define KEY_L                            (0x004b)
#define KEY_H                            (0x0045)
#define KEY0                             (0x0001)        /* KEYID Key and ID */
#define KEY0_L                           (0x0001)
#define KEY1                             (0x0002)        /* KEYID Key and ID */
#define KEY1_L                           (0x0002)
#define KEY2                             (0x0004)        /* KEYID Key and ID */
#define KEY2_L                           (0x0004)
#define KEY3                             (0x0008)        /* KEYID Key and ID */
#define KEY3_L                           (0x0008)
#define KEY4                             (0x0010)        /* KEYID Key and ID */
#define KEY4_L                           (0x0010)
#define KEY5                             (0x0020)        /* KEYID Key and ID */
#define KEY5_L                           (0x0020)
#define KEY6                             (0x0040)        /* KEYID Key and ID */
#define KEY6_L                           (0x0040)
#define KEY7                             (0x0080)        /* KEYID Key and ID */
#define KEY7_L                           (0x0080)
#define KEY8                             (0x0100)        /* KEYID Key and ID */
#define KEY8_H                           (0x0001)
#define KEY9                             (0x0200)        /* KEYID Key and ID */
#define KEY9_H                           (0x0002)
#define KEY10                            (0x0400)        /* KEYID Key and ID */
#define KEY10_H                          (0x0004)
#define KEY11                            (0x0800)        /* KEYID Key and ID */
#define KEY11_H                          (0x0008)
#define KEY12                            (0x1000)        /* KEYID Key and ID */
#define KEY12_H                          (0x0010)
#define KEY13                            (0x2000)        /* KEYID Key and ID */
#define KEY13_H                          (0x0020)
#define KEY14                            (0x4000)        /* KEYID Key and ID */
#define KEY14_H                          (0x0040)
#define KEY15                            (0x8000)        /* KEYID Key and ID */
#define KEY15_H                          (0x0080)

/* SAPHOCTL0 Control Bits */
#define CH0OE                            (0x0001)        /* */
#define CH0OE_L                          (0x0001)
#define CH0OE_0                          (0x0000)        /* Ch0 Output is HiZ */
#define CH0OE_1                          (0x0001)        /* CH0 Output is driving */
#define CH0OE_1_L                        (0x0001)
#define CH1OE                            (0x0002)        /* */
#define CH1OE_L                          (0x0002)
#define CH1OE_0                          (0x0000)        /* Ch1 Output is HiZ */
#define CH1OE_1                          (0x0002)        /* CH1 Output is driving */
#define CH1OE_1_L                        (0x0002)
#define CH0OUT                           (0x0100)        /* */
#define CH0OUT_H                         (0x0001)
#define CH0OUT_0                         (0x0000)        /* Ch0 is set to low signal */
#define CH0OUT_1                         (0x0100)        /* Ch0 is set to high signal */
#define CH0OUT_1_H                       (0x0001)
#define CH1OUT                           (0x0200)        /* */
#define CH1OUT_H                         (0x0002)
#define CH1OUT_0                         (0x0000)        /* Ch1 is set to low signal */
#define CH1OUT_1                         (0x0200)        /* Ch1 is set to high signal */
#define CH1OUT_1_H                       (0x0002)

/* SAPHOCTL1 Control Bits */
#define CH0TERM                          (0x0001)        /* */
#define CH0TERM_L                        (0x0001)
#define CH0TERM_0                        (0x0000)        /* CH0 Output is defined by CH0OUT and CH0OE */
#define CH0TERM_1                        (0x0001)        /* CH0 Output is set low with termination strength */
#define CH0TERM_1_L                      (0x0001)
#define CH1TERM                          (0x0002)        /* */
#define CH1TERM_L                        (0x0002)
#define CH1TERM_0                        (0x0000)        /* CH1 Output is defined by CH1OUT and CH1OE */
#define CH1TERM_1                        (0x0002)        /* CH1 Output is set low with termination strength */
#define CH1TERM_1_L                      (0x0002)
#define CH0FP                            (0x0100)        /* */
#define CH0FP_H                          (0x0001)
#define CH0FP_0                          (0x0000)        /* Ch0 Output is set to normal strength */
#define CH0FP_1                          (0x0100)        /* Ch0 Output is set to maximum strength */
#define CH0FP_1_H                        (0x0001)
#define CH1FP                            (0x0200)        /* */
#define CH1FP_H                          (0x0002)
#define CH1FP_0                          (0x0000)        /* Ch1 Output is set to normal strength */
#define CH1FP_1                          (0x0200)        /* Ch1 Output is set to maximum strength */
#define CH1FP_1_H                        (0x0002)

/* SAPHOSEL Control Bits */
#define PCH0SEL                          (0x0003)        /* */
#define PCH0SEL_L                        (0x0003)
#define PCH0SEL0                         (0x0001)        /* */
#define PCH0SEL0_L                       (0x0001)
#define PCH0SEL1                         (0x0002)        /* */
#define PCH0SEL1_L                       (0x0002)
#define PCH0SEL_0                        (0x0000)        /* CH0_OUT is used as a GPO pin. It is controlled by OCTL0.CH0OUT
                                                            and OCTL0.CH0OE. */
#define PCH0SEL_1                        (0x0001)        /* CH0_OUT is driven by the PPG. */
#define PCH0SEL_1_L                      (0x0001)
#define PCH0SEL_2                        (0x0002)        /* CH0_OUT is driven by the PPG as differential output along with
                                                            CH1_OUT. (CH0_OUT and CH1_OUT are alwasy opposite polarity) */
#define PCH0SEL_2_L                      (0x0002)
#define PCH0SEL_3                        (0x0003)        /* CH0_OUT is used as a GPO pin. It is controlled by OCTL0.CH0OUT
                                                            and OCTL0.CH0OE. */
#define PCH0SEL_3_L                      (0x0003)
#define PCH0SEL__GPIO                    (0x0000)        /* CH0_OUT is used as a GPO pin. It is controlled by OCTL0.CH0OUT
                                                            and OCTL0.CH0OE. */
#define PCH0SEL__PPGSE                   (0x0001)        /* CH0_OUT is driven by the PPG. */
#define PCH0SEL__PPGSE_L                 (0x0001)
#define PCH1SEL                          (0x000c)        /* */
#define PCH1SEL_L                        (0x000c)
#define PCH1SEL0                         (0x0004)        /* */
#define PCH1SEL0_L                       (0x0004)
#define PCH1SEL1                         (0x0008)        /* */
#define PCH1SEL1_L                       (0x0008)
#define PCH1SEL_0                        (0x0000)        /* CH1_OUT is used as a GPO pin. It is controlled by OCTL0.CH1OUT
                                                            and OCTL0.CH1OE. */
#define PCH1SEL_1                        (0x0004)        /* CH1_OUT is driven by the PPG. */
#define PCH1SEL_1_L                      (0x0004)
#define PCH1SEL_2                        (0x0008)        /* CH1_OUT is driven by the PPG as differential output along with
                                                            CH0_OUT. (CH0_OUT and CH1_OUT are alwasy opposite polarity) */
#define PCH1SEL_2_L                      (0x0008)
#define PCH1SEL_3                        (0x000c)        /* CH1_OUT is used as a GPO pin. It is controlled by OCTL0.CH1OUT
                                                            and OCTL0.CH1OE. */
#define PCH1SEL_3_L                      (0x000c)
#define PCH1SEL__GPIO                    (0x0000)        /* CH1_OUT is used as a GPO pin. It is controlled by OCTL0.CH1OUT
                                                            and OCTL0.CH1OE. */
#define PCH1SEL__PPGSE                   (0x0004)        /* CH1_OUT is driven by the PPG. */
#define PCH1SEL__PPGSE_L                 (0x0004)

/* SAPHCH0PUT Control Bits */
#define CH0PUT                           (0x000f)        /* */
#define CH0PUT_L                         (0x000f)
#define CH0PUT0                          (0x0001)        /* */
#define CH0PUT0_L                        (0x0001)
#define CH0PUT1                          (0x0002)        /* */
#define CH0PUT1_L                        (0x0002)
#define CH0PUT2                          (0x0004)        /* */
#define CH0PUT2_L                        (0x0004)
#define CH0PUT3                          (0x0008)        /* */
#define CH0PUT3_L                        (0x0008)

/* SAPHCH0PDT Control Bits */
#define CH0PDT                           (0x000f)        /* */
#define CH0PDT_L                         (0x000f)
#define CH0PDT0                          (0x0001)        /* */
#define CH0PDT0_L                        (0x0001)
#define CH0PDT1                          (0x0002)        /* */
#define CH0PDT1_L                        (0x0002)
#define CH0PDT2                          (0x0004)        /* */
#define CH0PDT2_L                        (0x0004)
#define CH0PDT3                          (0x0008)        /* */
#define CH0PDT3_L                        (0x0008)

/* SAPHCH0TT Control Bits */
#define CH0TT                            (0x000f)        /* */
#define CH0TT_L                          (0x000f)
#define CH0TT0                           (0x0001)        /* */
#define CH0TT0_L                         (0x0001)
#define CH0TT1                           (0x0002)        /* */
#define CH0TT1_L                         (0x0002)
#define CH0TT2                           (0x0004)        /* */
#define CH0TT2_L                         (0x0004)
#define CH0TT3                           (0x0008)        /* */
#define CH0TT3_L                         (0x0008)

/* SAPHCH1PUT Control Bits */
#define CH1PUT                           (0x000f)        /* */
#define CH1PUT_L                         (0x000f)
#define CH1PUT0                          (0x0001)        /* */
#define CH1PUT0_L                        (0x0001)
#define CH1PUT1                          (0x0002)        /* */
#define CH1PUT1_L                        (0x0002)
#define CH1PUT2                          (0x0004)        /* */
#define CH1PUT2_L                        (0x0004)
#define CH1PUT3                          (0x0008)        /* */
#define CH1PUT3_L                        (0x0008)

/* SAPHCH1PDT Control Bits */
#define CH1PDT                           (0x000f)        /* */
#define CH1PDT_L                         (0x000f)
#define CH1PDT0                          (0x0001)        /* */
#define CH1PDT0_L                        (0x0001)
#define CH1PDT1                          (0x0002)        /* */
#define CH1PDT1_L                        (0x0002)
#define CH1PDT2                          (0x0004)        /* */
#define CH1PDT2_L                        (0x0004)
#define CH1PDT3                          (0x0008)        /* */
#define CH1PDT3_L                        (0x0008)

/* SAPHCH1TT Control Bits */
#define CH1TT                            (0x000f)        /* */
#define CH1TT_L                          (0x000f)
#define CH1TT0                           (0x0001)        /* */
#define CH1TT0_L                         (0x0001)
#define CH1TT1                           (0x0002)        /* */
#define CH1TT1_L                         (0x0002)
#define CH1TT2                           (0x0004)        /* */
#define CH1TT2_L                         (0x0004)
#define CH1TT3                           (0x0008)        /* */
#define CH1TT3_L                         (0x0008)

/* SAPHMCNF Control Bits */
#define LPBE                             (0x0800)        /* */
#define LPBE_H                           (0x0008)
#define LPBE_0                           (0x0000)        /* For manual bias mode and regular ASQ bias mode. In this 
                                                            configuration the user controls by the ASQBSW has full control
                                                            over the TxBias and RxBias switches. */
#define LPBE_1                           (0x0800)        /* Low power bias mode. In this mode the ASQ uses the CHxEBSW and
                                                            PGABSW as auxiliary values to achieve faster channel setting 
                                                            on reactive input loads. The ASQ has full controls over the 
                                                            bias switch multiplexer. */
#define LPBE_1_H                         (0x0008)
#define RSV1                             (0x0600)        /* */
#define RSV1_H                           (0x0006)
#define RSV10                            (0x0200)        /* */
#define RSV10_H                          (0x0002)
#define RSV11                            (0x0400)        /* */
#define RSV11_H                          (0x0004)
#define CPEO                             (0x0100)        /* */
#define CPEO_H                           (0x0001)
#define CPEO_0                           (0x0000)        /* Charge pump is turned on by SDHS and ASQ related requests 
                                                            only. */
#define CPEO_1                           (0x0100)        /* Charge pump is turned on regardless of SDHS and ASQ related 
                                                            charge pump requests. */
#define CPEO_1_H                         (0x0001)
#define RSV0                             (0x000c)        /* */
#define RSV0_L                           (0x000c)
#define RSV00                            (0x0004)        /* */
#define RSV00_L                          (0x0004)
#define RSV01                            (0x0008)        /* */
#define RSV01_L                          (0x0008)
#define BIMP                             (0x0003)        /* */
#define BIMP_L                           (0x0003)
#define BIMP0                            (0x0001)        /* */
#define BIMP0_L                          (0x0001)
#define BIMP1                            (0x0002)        /* */
#define BIMP1_L                          (0x0002)
#define BIMP_0                           (0x0000)        /* 200 Ohms buffer impedance for RxBias and TxBias */
#define BIMP_1                           (0x0001)        /* 600 Ohms buffer impedance for RxBias and TxBias */
#define BIMP_1_L                         (0x0001)
#define BIMP_2                           (0x0002)        /* 1200 Ohms buffer impedance for RxBias and TxBias (default) */
#define BIMP_2_L                         (0x0002)
#define BIMP_3                           (0x0003)        /* 2800 Ohms buffer impedance for RxBias and TxBias */
#define BIMP_3_L                         (0x0003)

/* SAPHTACTL Control Bits */
#define UNLOCK                           (0x0001)        /* */
#define UNLOCK_L                         (0x0001)

/* SAPHICTL0 Control Bits */
#define MUXSEL                           (0x000f)        /* */
#define MUXSEL_L                         (0x000f)
#define MUXSEL0                          (0x0001)        /* */
#define MUXSEL0_L                        (0x0001)
#define MUXSEL1                          (0x0002)        /* */
#define MUXSEL1_L                        (0x0002)
#define MUXSEL2                          (0x0004)        /* */
#define MUXSEL2_L                        (0x0004)
#define MUXSEL3                          (0x0008)        /* */
#define MUXSEL3_L                        (0x0008)
#define MUXSEL_0                         (0x0000)        /* Channel 0 is selected for input */
#define MUXSEL_1                         (0x0001)        /* Channel 1 is selected for input */
#define MUXSEL_1_L                       (0x0001)
#define MUXSEL_2                         (0x0002)        /* reserved for future channels */
#define MUXSEL_2_L                       (0x0002)
#define MUXSEL_3                         (0x0003)        /* reserved for future channels */
#define MUXSEL_3_L                       (0x0003)
#define MUXSEL_4                         (0x0004)        /* reserved for future channels */
#define MUXSEL_4_L                       (0x0004)
#define MUXSEL_5                         (0x0005)        /* reserved for future channels */
#define MUXSEL_5_L                       (0x0005)
#define MUXSEL_6                         (0x0006)        /* reserved for future channels */
#define MUXSEL_6_L                       (0x0006)
#define MUXSEL_7                         (0x0007)        /* reserved for future channels */
#define MUXSEL_7_L                       (0x0007)
#define MUXSEL_8                         (0x0008)        /* no channel is selected */
#define MUXSEL_8_L                       (0x0008)
#define MUXSEL_9                         (0x0009)        /* no channel is selected */
#define MUXSEL_9_L                       (0x0009)
#define MUXSEL_10                        (0x000a)        /* no channel is selected */
#define MUXSEL_10_L                      (0x000a)
#define MUXSEL_11                        (0x000b)        /* no channel is selected */
#define MUXSEL_11_L                      (0x000b)
#define MUXSEL_12                        (0x000c)        /* no channel is selected */
#define MUXSEL_12_L                      (0x000c)
#define MUXSEL_13                        (0x000d)        /* no channel is selected */
#define MUXSEL_13_L                      (0x000d)
#define MUXSEL_14                        (0x000e)        /* no channel is selected */
#define MUXSEL_14_L                      (0x000e)
#define MUXSEL_15                        (0x000f)        /* no channel is selected */
#define MUXSEL_15_L                      (0x000f)
#define MUXSEL__CH0IN                    (0x0000)        /* Channel 0 is selected for input */
#define MUXSEL__CH1IN                    (0x0001)        /* Channel 1 is selected for input */
#define MUXSEL__CH1IN_L                  (0x0001)
#define DUMEN                            (0x0080)        /* */
#define DUMEN_L                          (0x0080)
#define DUMEN_0                          (0x0000)        /* PGA dummy input load is Hi-Z. */
#define DUMEN_1                          (0x0080)        /* PGA dummy input load matches the PGA input impedance. */
#define DUMEN_1_L                        (0x0080)
#define MUXCTL                           (0x0010)        /* */
#define MUXCTL_L                         (0x0010)
#define MUXCTL_0                         (0x0000)        /* The input multiplexer is controlled by ICTL0.MUXSEL (register 
                                                            mode) */
#define MUXCTL_1                         (0x0010)        /* The input multiplexer is controlled by ASQ (auto mode) */
#define MUXCTL_1_L                       (0x0010)

/* SAPHBCTL Control Bits */
#define ASQBSC                           (0x0001)        /* */
#define ASQBSC_L                         (0x0001)
#define ASQBSC_0                         (0x0000)        /* Bias switches are controlled by BCTL.CH0EBSW, BCTL.CH1EBSW, 
                                                            BCTL.PGABSW bits (register mode). */
#define ASQBSC_1                         (0x0001)        /* Bias switches are controlled by ASQ (auto mode) */
#define ASQBSC_1_L                       (0x0001)
#define PGABSW                           (0x0002)        /* */
#define PGABSW_L                         (0x0002)
#define PGABSW_0                         (0x0000)        /* Rx bias switch is open. */
#define PGABSW_1                         (0x0002)        /* Rx bias switch is closed (enabled). */
#define PGABSW_1_L                       (0x0002)
#define EXCBIAS                          (0x0030)        /* */
#define EXCBIAS_L                        (0x0030)
#define EXCBIAS0                         (0x0010)        /* */
#define EXCBIAS0_L                       (0x0010)
#define EXCBIAS1                         (0x0020)        /* */
#define EXCBIAS1_L                       (0x0020)
#define EXCBIAS_0                        (0x0000)        /* 0.2V nominal */
#define EXCBIAS_1                        (0x0010)        /* 0.3V nominal */
#define EXCBIAS_1_L                      (0x0010)
#define EXCBIAS_2                        (0x0020)        /* 0.4V nominal */
#define EXCBIAS_2_L                      (0x0020)
#define EXCBIAS_3                        (0x0030)        /* 0.6V nominal */
#define EXCBIAS_3_L                      (0x0030)
#define PGABIAS                          (0x00c0)        /* */
#define PGABIAS_L                        (0x00c0)
#define PGABIAS0                         (0x0040)        /* */
#define PGABIAS0_L                       (0x0040)
#define PGABIAS1                         (0x0080)        /* */
#define PGABIAS1_L                       (0x0080)
#define PGABIAS_0                        (0x0000)        /* 0.75V nominal */
#define PGABIAS_1                        (0x0040)        /* 0.8V nominal */
#define PGABIAS_1_L                      (0x0040)
#define PGABIAS_2                        (0x0080)        /* 0.9V nominal */
#define PGABIAS_2_L                      (0x0080)
#define PGABIAS_3                        (0x00c0)        /* 0.95V nominal */
#define PGABIAS_3_L                      (0x00c0)
#define CH0EBSW                          (0x0100)        /* */
#define CH0EBSW_H                        (0x0001)
#define CH0EBSW_0                        (0x0000)        /* Tx bias switch to CH0 is open. */
#define CH0EBSW_1                        (0x0100)        /* Tx bias switch to CH0 is closed (enabled). */
#define CH0EBSW_1_H                      (0x0001)
#define CH1EBSW                          (0x0200)        /* */
#define CH1EBSW_H                        (0x0002)
#define CH1EBSW_0                        (0x0000)        /* Tx bias switch to CH1 is open. */
#define CH1EBSW_1                        (0x0200)        /* Tx bias switch to CH1 is closed (enabled). */
#define CH1EBSW_1_H                      (0x0002)
#define CPDA                             (0x0008)        /* */
#define CPDA_L                           (0x0008)
#define CPDA_0                           (0x0000)        /* Turn off the charge pump during data acquisition. */
#define CPDA_1                           (0x0008)        /* Keep charge pump enabled during data acquisition. */
#define CPDA_1_L                         (0x0008)
#define LILC                             (0x0004)        /* */
#define LILC_L                           (0x0004)
#define LILC_0                           (0x0000)        /* LICL is disabled. */
#define LILC_1                           (0x0004)        /* LICL is enabled. */
#define LILC_1_L                         (0x0004)

/* SAPHPGC Control Bits */
#define EPULS                            (0x007f)        /* */
#define EPULS_L                          (0x007f)
#define EPULS0                           (0x0001)        /* */
#define EPULS0_L                         (0x0001)
#define EPULS1                           (0x0002)        /* */
#define EPULS1_L                         (0x0002)
#define EPULS2                           (0x0004)        /* */
#define EPULS2_L                         (0x0004)
#define EPULS3                           (0x0008)        /* */
#define EPULS3_L                         (0x0008)
#define EPULS4                           (0x0010)        /* */
#define EPULS4_L                         (0x0010)
#define EPULS5                           (0x0020)        /* */
#define EPULS5_L                         (0x0020)
#define EPULS6                           (0x0040)        /* */
#define EPULS6_L                         (0x0040)
#define SPULS                            (0x0f00)        /* */
#define SPULS_H                          (0x000f)
#define SPULS0                           (0x0100)        /* */
#define SPULS0_H                         (0x0001)
#define SPULS1                           (0x0200)        /* */
#define SPULS1_H                         (0x0002)
#define SPULS2                           (0x0400)        /* */
#define SPULS2_H                         (0x0004)
#define SPULS3                           (0x0800)        /* */
#define SPULS3_H                         (0x0008)
#define PPOL                             (0x2000)        /* */
#define PPOL_H                           (0x0020)
#define PPOL_0                           (0x0000)        /* The excitation begins with logical high phase. The stop 
                                                            begines with logical low phase. */
#define PPOL_1                           (0x2000)        /* The excitation begins with logical low phase. The stop begines
                                                            with logical high phase. */
#define PPOL_1_H                         (0x0020)
#define PLEV                             (0x4000)        /* */
#define PLEV_H                           (0x0040)
#define PLEV_0                           (0x0000)        /* PPG output is low during inactive */
#define PLEV_1                           (0x4000)        /* PPG output is high during inactive */
#define PLEV_1_H                         (0x0040)
#define PHIZ                             (0x8000)        /* */
#define PHIZ_H                           (0x0080)
#define PHIZ_0                           (0x0000)        /* PPG output during inactive is determined by PGC.PLEV bit. */
#define PHIZ_1                           (0x8000)        /* PPG output is in Hi-Z during inactive regardless of PGC.PLEV 
                                                            bit. */
#define PHIZ_1_H                         (0x0080)

/* SAPHPGLPER Control Bits */
#define LPER                             (0x00ff)        /* */
#define LPER_L                           (0x00ff)
#define LPER0                            (0x0001)        /* */
#define LPER0_L                          (0x0001)
#define LPER1                            (0x0002)        /* */
#define LPER1_L                          (0x0002)
#define LPER2                            (0x0004)        /* */
#define LPER2_L                          (0x0004)
#define LPER3                            (0x0008)        /* */
#define LPER3_L                          (0x0008)
#define LPER4                            (0x0010)        /* */
#define LPER4_L                          (0x0010)
#define LPER5                            (0x0020)        /* */
#define LPER5_L                          (0x0020)
#define LPER6                            (0x0040)        /* */
#define LPER6_L                          (0x0040)
#define LPER7                            (0x0080)        /* */
#define LPER7_L                          (0x0080)

/* SAPHPGHPER Control Bits */
#define HPER                             (0x00ff)        /* */
#define HPER_L                           (0x00ff)
#define HPER0                            (0x0001)        /* */
#define HPER0_L                          (0x0001)
#define HPER1                            (0x0002)        /* */
#define HPER1_L                          (0x0002)
#define HPER2                            (0x0004)        /* */
#define HPER2_L                          (0x0004)
#define HPER3                            (0x0008)        /* */
#define HPER3_L                          (0x0008)
#define HPER4                            (0x0010)        /* */
#define HPER4_L                          (0x0010)
#define HPER5                            (0x0020)        /* */
#define HPER5_L                          (0x0020)
#define HPER6                            (0x0040)        /* */
#define HPER6_L                          (0x0040)
#define HPER7                            (0x0080)        /* */
#define HPER7_L                          (0x0080)

/* SAPHPGCTL Control Bits */
#define PGSEL                            (0x0001)        /* */
#define PGSEL_L                          (0x0001)
#define PGSEL_0                          (0x0000)        /* PPG output channel is selected by PGCTL.PPGCHSEL bit (register
                                                            mode). */
#define PGSEL_1                          (0x0001)        /* PPG output channel is selected by ASQ (auto mode). */
#define PGSEL_1_L                        (0x0001)
#define PPGCHSEL                         (0x0002)        /* */
#define PPGCHSEL_L                       (0x0002)
#define PPGCHSEL_0                       (0x0000)        /* CH0 is selected */
#define PPGCHSEL_1                       (0x0002)        /* CH1 is selected */
#define PPGCHSEL_1_L                     (0x0002)
#define TRSEL                            (0x0030)        /* */
#define TRSEL_L                          (0x0030)
#define TRSEL0                           (0x0010)        /* */
#define TRSEL0_L                         (0x0010)
#define TRSEL1                           (0x0020)        /* */
#define TRSEL1_L                         (0x0020)
#define TRSEL_0                          (0x0000)        /* Writing 1 to PPGTRIG.PPGTRIG to trigger the PPG (start pulse 
                                                            generation). */
#define TRSEL_1                          (0x0010)        /* PPG trigger is controlled by the ASQ. */
#define TRSEL_1_L                        (0x0010)
#define TRSEL_2                          (0x0020)        /* Ext. Signal (See device specific datasheet) */
#define TRSEL_2_L                        (0x0020)
#define TRSEL_3                          (0x0030)        /* Ext. Signal (See device specific datasheet) */
#define TRSEL_3_L                        (0x0030)
#define PPGEN                            (0x0200)        /* */
#define PPGEN_H                          (0x0002)
#define PPGEN_0                          (0x0000)        /* PPG trigger is disabled. */
#define PPGEN_1                          (0x0200)        /* PPG trigger is enabled. */
#define PPGEN_1_H                        (0x0002)
#define TONE                             (0x4000)        /* */
#define TONE_H                           (0x0040)
#define TONE_0                           (0x0000)        /* Test tone generation is disabled.  Note: This bit is 
                                                            automatically cleared when writing '1' to PGCTL.STOP, and it 
                                                            stops test tone generation immediately. */
#define TONE_1                           (0x0000)        /* Test tone generation is enabled. */
#define TONE__DISABLE                    (0x0000)        /* Test tone generation is disabled.  Note: This bit is 
                                                            automatically cleared when writing '1' to PGCTL.STOP, and it 
                                                            stops test tone generation immediately. */
#define TONE__ENABLE                     (0x0000)        /* Test tone generation is enabled. */
#define PPGSTOP                          (0x8000)        /* */
#define PPGSTOP_H                        (0x0080)
#define PSCEN                            (0x2000)        /* */
#define PSCEN_H                          (0x0020)
#define PSCEN_0                          (0x0000)        /* Prescaler is disabled. PPG clock = PLL output clock. */
#define PSCEN_1                          (0x2000)        /* Prescaler by four is enabled. PPG clock = 1/4 of the PLL 
                                                            output clock. */
#define PSCEN_1_H                        (0x0020)
#define PSCEN__DISABLE                   (0x0000)        /* Prescaler is disabled. PPG clock = PLL output clock. */
#define PSCEN__ENABLE                    (0x2000)        /* Prescaler by four is enabled. PPG clock = 1/4 of the PLL 
                                                            output clock. */
#define PSCEN__ENABLE_H                  (0x0020)

/* SAPHPPGTRIG Control Bits */
#define PPGTRIG                          (0x0001)        /* */
#define PPGTRIG_L                        (0x0001)

/* SAPHASCTL0 Control Bits */
#define PNGCNT                           (0x0003)        /* */
#define PNGCNT_L                         (0x0003)
#define PNGCNT0                          (0x0001)        /* */
#define PNGCNT0_L                        (0x0001)
#define PNGCNT1                          (0x0002)        /* */
#define PNGCNT1_L                        (0x0002)
#define ASQCHSEL                         (0x0010)        /* */
#define ASQCHSEL_L                       (0x0010)
#define ASQCHSEL_0                       (0x0000)        /* CH0 is selected to start with.  If ASCTL0.PNGCNT = 3 and 
                                                            ASCTL1.CHTOG =1, then the channel selection would be CH0 -> 
                                                            CH1 -> CH0 -> CH1. If ASCTL0.PNGCNT = 3 and ASCTL1.CHTOG =0, 
                                                            then the channel selection would be CH0 -> CH0 -> CH0 -> CH0. */
#define ASQCHSEL_1                       (0x0010)        /* CH1 is selected to start with.  If ASCTL0.PNGCNT = 3 and 
                                                            ASCTL1.CHTOG =0, then the channel selection would be CH1 -> 
                                                            CH1 -> CH1 -> CH1. If ASCTL0.PNGCNT = 3 and ASCTL1.CHTOG =1, 
                                                            then the channel selection would be CH1 -> CH0 -> CH1 -> CH0. */
#define ASQCHSEL_1_L                     (0x0010)
#define ASQSTOP                          (0x0080)        /* */
#define ASQSTOP_L                        (0x0080)
#define ASQTEN                           (0x0200)        /* */
#define ASQTEN_H                         (0x0002)
#define ASQEN_0                          (0x0000)        /* ASQ trigger is disabled. */
#define ASQEN_1                          (0x0200)        /* ASQ trigger is enabled. */
#define ASQEN_1_H                        (0x0002)
#define TRIGSEL                          (0x0c00)        /* */
#define TRIGSEL_H                        (0x000c)
#define TRIGSEL0                         (0x0400)        /* */
#define TRIGSEL0_H                       (0x0004)
#define TRIGSEL1                         (0x0800)        /* */
#define TRIGSEL1_H                       (0x0008)
#define TRIGSEL_0                        (0x0000)        /* Writing '1' to ASQTRIG.ASQTRIG */
#define TRIGSEL_1                        (0x0400)        /* The PSQ is selected to start the ASQ. */
#define TRIGSEL_1_H                      (0x0004)
#define TRIGSEL_2                        (0x0800)        /* Ext. Signal (See device specific datasheet) */
#define TRIGSEL_2_H                      (0x0008)
#define TRIGSEL_3                        (0x0c00)        /* Ext. Signal (See device specific datasheet) */
#define TRIGSEL_3_H                      (0x000c)
#define TRIGSEL__SWTRIG                  (0x0000)        /* Writing '1' to ASQTRIG.ASQTRIG */
#define TRIGSEL__PSQ                     (0x0400)        /* The PSQ is selected to start the ASQ. */
#define TRIGSEL__PSQ_H                   (0x0004)
#define TRIGSEL__TIMER                   (0x0800)        /* Ext. Signal (See device specific datasheet) */
#define TRIGSEL__TIMER_H                 (0x0008)
#define ERABRT                           (0x2000)        /* */
#define ERABRT_H                         (0x0020)
#define ERABRT_0                         (0x0000)        /* Continue the measurements until completion regardless of the 
                                                            DATAERR interrupt. */
#define ERABRT_1                         (0x2000)        /* Stop the ASQ upon the DATAERR interrupt. */
#define ERABRT_1_H                       (0x0020)

/* SAPHASCTL1 Control Bits */
#define CHTOG                            (0x0001)        /* */
#define CHTOG_L                          (0x0001)
#define CHTOG_0                          (0x0000)        /* Channel toggle is disabled. */
#define CHTOG_1                          (0x0001)        /* Channel toggle is enabled at each PNGDN interrupt. */
#define CHTOG_1_L                        (0x0001)
#define CHACT                            (0x0010)        /* */
#define CHACT_L                          (0x0010)
#define EARLYRB                          (0x0080)        /* */
#define EARLYRB_L                        (0x0080)
#define EARLYRB_0                        (0x0000)        /* Rx bias is applied to the Rx channel by the TIMEMARK C */
#define EARLYRB_1                        (0x0080)        /* Rx bias is applied to the Rx channel by the TIMEMARK A */
#define EARLYRB_1_L                      (0x0080)
#define ESOFF                            (0x0100)        /* */
#define ESOFF_H                          (0x0001)
#define ESOFF_0                          (0x0000)        /* OFF request is disabled. The ASQ does not send a request about
                                                            USS power mode to the PSQ. */
#define ESOFF_1                          (0x0100)        /* OFF request is generated after sequence */
#define ESOFF_1_H                        (0x0001)
#define STDBY                            (0x0400)        /* */
#define STDBY_H                          (0x0004)
#define STDBY_0                          (0x0000)        /* The ASQ sends a power down request to the PSQ (Power 
                                                            Sequencer) when the OFF request is received. */
#define STDBY_1                          (0x0400)        /* The ASQ sends a standby request to the PSQ (Power Sequencer) 
                                                            when the OFF request is received. */
#define STDBY_1_H                        (0x0004)
#define STDBY__PWROFF                    (0x0000)        /* The ASQ sends a power down request to the PSQ (Power 
                                                            Sequencer) when the OFF request is received. */
#define STDBY__STDBY                     (0x0400)        /* The ASQ sends a standby request to the PSQ (Power Sequencer) 
                                                            when the OFF request is received. */
#define STDBY__STDBY_H                   (0x0004)
#define CHOWN                            (0x0800)        /* */
#define CHOWN_H                          (0x0008)
#define CHOWN_0                          (0x0000)        /* Tx channel and Rx channel are not the same (This is the 
                                                            typical configuration). */
#define CHOWN_1                          (0x0800)        /* Tx channel and Rx channel are identical. */
#define CHOWN_1_H                        (0x0008)

/* SAPHASQTRIG Control Bits */
#define ASQTRIG                          (0x0001)        /* */
#define ASQTRIG_L                        (0x0001)

/* SAPHAPOL Control Bits */
#define PCPOL                            (0x000f)        /* */
#define PCPOL_L                          (0x000f)
#define PCPOL0                           (0x0001)        /* */
#define PCPOL0_L                         (0x0001)
#define PCPOL1                           (0x0002)        /* */
#define PCPOL1_L                         (0x0002)
#define PCPOL2                           (0x0004)        /* */
#define PCPOL2_L                         (0x0004)
#define PCPOL3                           (0x0008)        /* */
#define PCPOL3_L                         (0x0008)

/* SAPHAPLEV Control Bits */
#define PCPLEV                           (0x000f)        /* */
#define PCPLEV_L                         (0x000f)
#define PCPLEV0                          (0x0001)        /* */
#define PCPLEV0_L                        (0x0001)
#define PCPLEV1                          (0x0002)        /* */
#define PCPLEV1_L                        (0x0002)
#define PCPLEV2                          (0x0004)        /* */
#define PCPLEV2_L                        (0x0004)
#define PCPLEV3                          (0x0008)        /* */
#define PCPLEV3_L                        (0x0008)

/* SAPHAPHIZ Control Bits */
#define PCPHIZ                           (0x000f)        /* */
#define PCPHIZ_L                         (0x000f)
#define PCPHIZ0                          (0x0001)        /* */
#define PCPHIZ0_L                        (0x0001)
#define PCPHIZ1                          (0x0002)        /* */
#define PCPHIZ1_L                        (0x0002)
#define PCPHIZ2                          (0x0004)        /* */
#define PCPHIZ2_L                        (0x0004)
#define PCPHIZ3                          (0x0008)        /* */
#define PCPHIZ3_L                        (0x0008)

/* SAPHATM_A Control Bits */
#define TIMEMARK_A                       (0xffff)        /* */
#define TIMEMARK_A_L                     (0x00ff)
#define TIMEMARK_A_H                     (0x00ff)
#define TIMEMARK_A0                      (0x0001)        /* */
#define TIMEMARK_A0_L                    (0x0001)
#define TIMEMARK_A1                      (0x0002)        /* */
#define TIMEMARK_A1_L                    (0x0002)
#define TIMEMARK_A2                      (0x0004)        /* */
#define TIMEMARK_A2_L                    (0x0004)
#define TIMEMARK_A3                      (0x0008)        /* */
#define TIMEMARK_A3_L                    (0x0008)
#define TIMEMARK_A4                      (0x0010)        /* */
#define TIMEMARK_A4_L                    (0x0010)
#define TIMEMARK_A5                      (0x0020)        /* */
#define TIMEMARK_A5_L                    (0x0020)
#define TIMEMARK_A6                      (0x0040)        /* */
#define TIMEMARK_A6_L                    (0x0040)
#define TIMEMARK_A7                      (0x0080)        /* */
#define TIMEMARK_A7_L                    (0x0080)
#define TIMEMARK_A8                      (0x0100)        /* */
#define TIMEMARK_A8_H                    (0x0001)
#define TIMEMARK_A9                      (0x0200)        /* */
#define TIMEMARK_A9_H                    (0x0002)
#define TIMEMARK_A10                     (0x0400)        /* */
#define TIMEMARK_A10_H                   (0x0004)
#define TIMEMARK_A11                     (0x0800)        /* */
#define TIMEMARK_A11_H                   (0x0008)
#define TIMEMARK_A12                     (0x1000)        /* */
#define TIMEMARK_A12_H                   (0x0010)
#define TIMEMARK_A13                     (0x2000)        /* */
#define TIMEMARK_A13_H                   (0x0020)
#define TIMEMARK_A14                     (0x4000)        /* */
#define TIMEMARK_A14_H                   (0x0040)
#define TIMEMARK_A15                     (0x8000)        /* */
#define TIMEMARK_A15_H                   (0x0080)

/* SAPHATM_B Control Bits */
#define TIMEMARK_B                       (0xffff)        /* */
#define TIMEMARK_B_L                     (0x00ff)
#define TIMEMARK_B_H                     (0x00ff)
#define TIMEMARK_B0                      (0x0001)        /* */
#define TIMEMARK_B0_L                    (0x0001)
#define TIMEMARK_B1                      (0x0002)        /* */
#define TIMEMARK_B1_L                    (0x0002)
#define TIMEMARK_B2                      (0x0004)        /* */
#define TIMEMARK_B2_L                    (0x0004)
#define TIMEMARK_B3                      (0x0008)        /* */
#define TIMEMARK_B3_L                    (0x0008)
#define TIMEMARK_B4                      (0x0010)        /* */
#define TIMEMARK_B4_L                    (0x0010)
#define TIMEMARK_B5                      (0x0020)        /* */
#define TIMEMARK_B5_L                    (0x0020)
#define TIMEMARK_B6                      (0x0040)        /* */
#define TIMEMARK_B6_L                    (0x0040)
#define TIMEMARK_B7                      (0x0080)        /* */
#define TIMEMARK_B7_L                    (0x0080)
#define TIMEMARK_B8                      (0x0100)        /* */
#define TIMEMARK_B8_H                    (0x0001)
#define TIMEMARK_B9                      (0x0200)        /* */
#define TIMEMARK_B9_H                    (0x0002)
#define TIMEMARK_B10                     (0x0400)        /* */
#define TIMEMARK_B10_H                   (0x0004)
#define TIMEMARK_B11                     (0x0800)        /* */
#define TIMEMARK_B11_H                   (0x0008)
#define TIMEMARK_B12                     (0x1000)        /* */
#define TIMEMARK_B12_H                   (0x0010)
#define TIMEMARK_B13                     (0x2000)        /* */
#define TIMEMARK_B13_H                   (0x0020)
#define TIMEMARK_B14                     (0x4000)        /* */
#define TIMEMARK_B14_H                   (0x0040)
#define TIMEMARK_B15                     (0x8000)        /* */
#define TIMEMARK_B15_H                   (0x0080)

/* SAPHATM_C Control Bits */
#define TIMEMARK_C                       (0xffff)        /* */
#define TIMEMARK_C_L                     (0x00ff)
#define TIMEMARK_C_H                     (0x00ff)
#define TIMEMARK_C0                      (0x0001)        /* */
#define TIMEMARK_C0_L                    (0x0001)
#define TIMEMARK_C1                      (0x0002)        /* */
#define TIMEMARK_C1_L                    (0x0002)
#define TIMEMARK_C2                      (0x0004)        /* */
#define TIMEMARK_C2_L                    (0x0004)
#define TIMEMARK_C3                      (0x0008)        /* */
#define TIMEMARK_C3_L                    (0x0008)
#define TIMEMARK_C4                      (0x0010)        /* */
#define TIMEMARK_C4_L                    (0x0010)
#define TIMEMARK_C5                      (0x0020)        /* */
#define TIMEMARK_C5_L                    (0x0020)
#define TIMEMARK_C6                      (0x0040)        /* */
#define TIMEMARK_C6_L                    (0x0040)
#define TIMEMARK_C7                      (0x0080)        /* */
#define TIMEMARK_C7_L                    (0x0080)
#define TIMEMARK_C8                      (0x0100)        /* */
#define TIMEMARK_C8_H                    (0x0001)
#define TIMEMARK_C9                      (0x0200)        /* */
#define TIMEMARK_C9_H                    (0x0002)
#define TIMEMARK_C10                     (0x0400)        /* */
#define TIMEMARK_C10_H                   (0x0004)
#define TIMEMARK_C11                     (0x0800)        /* */
#define TIMEMARK_C11_H                   (0x0008)
#define TIMEMARK_C12                     (0x1000)        /* */
#define TIMEMARK_C12_H                   (0x0010)
#define TIMEMARK_C13                     (0x2000)        /* */
#define TIMEMARK_C13_H                   (0x0020)
#define TIMEMARK_C14                     (0x4000)        /* */
#define TIMEMARK_C14_H                   (0x0040)
#define TIMEMARK_C15                     (0x8000)        /* */
#define TIMEMARK_C15_H                   (0x0080)

/* SAPHATM_D Control Bits */
#define TIMEMARK_D                       (0xffff)        /* */
#define TIMEMARK_D_L                     (0x00ff)
#define TIMEMARK_D_H                     (0x00ff)
#define TIMEMARK_D0                      (0x0001)        /* */
#define TIMEMARK_D0_L                    (0x0001)
#define TIMEMARK_D1                      (0x0002)        /* */
#define TIMEMARK_D1_L                    (0x0002)
#define TIMEMARK_D2                      (0x0004)        /* */
#define TIMEMARK_D2_L                    (0x0004)
#define TIMEMARK_D3                      (0x0008)        /* */
#define TIMEMARK_D3_L                    (0x0008)
#define TIMEMARK_D4                      (0x0010)        /* */
#define TIMEMARK_D4_L                    (0x0010)
#define TIMEMARK_D5                      (0x0020)        /* */
#define TIMEMARK_D5_L                    (0x0020)
#define TIMEMARK_D6                      (0x0040)        /* */
#define TIMEMARK_D6_L                    (0x0040)
#define TIMEMARK_D7                      (0x0080)        /* */
#define TIMEMARK_D7_L                    (0x0080)
#define TIMEMARK_D8                      (0x0100)        /* */
#define TIMEMARK_D8_H                    (0x0001)
#define TIMEMARK_D9                      (0x0200)        /* */
#define TIMEMARK_D9_H                    (0x0002)
#define TIMEMARK_D10                     (0x0400)        /* */
#define TIMEMARK_D10_H                   (0x0004)
#define TIMEMARK_D11                     (0x0800)        /* */
#define TIMEMARK_D11_H                   (0x0008)
#define TIMEMARK_D12                     (0x1000)        /* */
#define TIMEMARK_D12_H                   (0x0010)
#define TIMEMARK_D13                     (0x2000)        /* */
#define TIMEMARK_D13_H                   (0x0020)
#define TIMEMARK_D14                     (0x4000)        /* */
#define TIMEMARK_D14_H                   (0x0040)
#define TIMEMARK_D15                     (0x8000)        /* */
#define TIMEMARK_D15_H                   (0x0080)

/* SAPHATM_E Control Bits */
#define TIMEMARK_E                       (0xffff)        /* */
#define TIMEMARK_E_L                     (0x00ff)
#define TIMEMARK_E_H                     (0x00ff)
#define TIMEMARK_E0                      (0x0001)        /* */
#define TIMEMARK_E0_L                    (0x0001)
#define TIMEMARK_E1                      (0x0002)        /* */
#define TIMEMARK_E1_L                    (0x0002)
#define TIMEMARK_E2                      (0x0004)        /* */
#define TIMEMARK_E2_L                    (0x0004)
#define TIMEMARK_E3                      (0x0008)        /* */
#define TIMEMARK_E3_L                    (0x0008)
#define TIMEMARK_E4                      (0x0010)        /* */
#define TIMEMARK_E4_L                    (0x0010)
#define TIMEMARK_E5                      (0x0020)        /* */
#define TIMEMARK_E5_L                    (0x0020)
#define TIMEMARK_E6                      (0x0040)        /* */
#define TIMEMARK_E6_L                    (0x0040)
#define TIMEMARK_E7                      (0x0080)        /* */
#define TIMEMARK_E7_L                    (0x0080)
#define TIMEMARK_E8                      (0x0100)        /* */
#define TIMEMARK_E8_H                    (0x0001)
#define TIMEMARK_E9                      (0x0200)        /* */
#define TIMEMARK_E9_H                    (0x0002)
#define TIMEMARK_E10                     (0x0400)        /* */
#define TIMEMARK_E10_H                   (0x0004)
#define TIMEMARK_E11                     (0x0800)        /* */
#define TIMEMARK_E11_H                   (0x0008)
#define TIMEMARK_E12                     (0x1000)        /* */
#define TIMEMARK_E12_H                   (0x0010)
#define TIMEMARK_E13                     (0x2000)        /* */
#define TIMEMARK_E13_H                   (0x0020)
#define TIMEMARK_E14                     (0x4000)        /* */
#define TIMEMARK_E14_H                   (0x0040)
#define TIMEMARK_E15                     (0x8000)        /* */
#define TIMEMARK_E15_H                   (0x0080)

/* SAPHATM_F Control Bits */
#define TIMEMARK_F                       (0xffff)        /* */
#define TIMEMARK_F_L                     (0x00ff)
#define TIMEMARK_F_H                     (0x00ff)
#define TIMEMARK_F0                      (0x0001)        /* */
#define TIMEMARK_F0_L                    (0x0001)
#define TIMEMARK_F1                      (0x0002)        /* */
#define TIMEMARK_F1_L                    (0x0002)
#define TIMEMARK_F2                      (0x0004)        /* */
#define TIMEMARK_F2_L                    (0x0004)
#define TIMEMARK_F3                      (0x0008)        /* */
#define TIMEMARK_F3_L                    (0x0008)
#define TIMEMARK_F4                      (0x0010)        /* */
#define TIMEMARK_F4_L                    (0x0010)
#define TIMEMARK_F5                      (0x0020)        /* */
#define TIMEMARK_F5_L                    (0x0020)
#define TIMEMARK_F6                      (0x0040)        /* */
#define TIMEMARK_F6_L                    (0x0040)
#define TIMEMARK_F7                      (0x0080)        /* */
#define TIMEMARK_F7_L                    (0x0080)
#define TIMEMARK_F8                      (0x0100)        /* */
#define TIMEMARK_F8_H                    (0x0001)
#define TIMEMARK_F9                      (0x0200)        /* */
#define TIMEMARK_F9_H                    (0x0002)
#define TIMEMARK_F10                     (0x0400)        /* */
#define TIMEMARK_F10_H                   (0x0004)
#define TIMEMARK_F11                     (0x0800)        /* */
#define TIMEMARK_F11_H                   (0x0008)
#define TIMEMARK_F12                     (0x1000)        /* */
#define TIMEMARK_F12_H                   (0x0010)
#define TIMEMARK_F13                     (0x2000)        /* */
#define TIMEMARK_F13_H                   (0x0020)
#define TIMEMARK_F14                     (0x4000)        /* */
#define TIMEMARK_F14_H                   (0x0040)
#define TIMEMARK_F15                     (0x8000)        /* */
#define TIMEMARK_F15_H                   (0x0080)

/* SAPHTBCTL Control Bits */
#define TCLR                             (0x0001)        /* */
#define TCLR_L                           (0x0001)
#define TSTART                           (0x0002)        /* */
#define TSTART_L                         (0x0002)
#define TSTOP                            (0x0004)        /* */
#define TSTOP_L                          (0x0004)
#define PSSV                             (0x00f0)        /* */
#define PSSV_L                           (0x00f0)
#define PSSV0                            (0x0010)        /* */
#define PSSV0_L                          (0x0010)
#define PSSV1                            (0x0020)        /* */
#define PSSV1_L                          (0x0020)
#define PSSV2                            (0x0040)        /* */
#define PSSV2_L                          (0x0040)
#define PSSV3                            (0x0080)        /* */
#define PSSV3_L                          (0x0080)

/* SAPHATIMLO Control Bits */
#define ATIMLO                           (0xffff)        /* */
#define ATIMLO_L                         (0x00ff)
#define ATIMLO_H                         (0x00ff)
#define ATIMLO0                          (0x0001)        /* */
#define ATIMLO0_L                        (0x0001)
#define ATIMLO1                          (0x0002)        /* */
#define ATIMLO1_L                        (0x0002)
#define ATIMLO2                          (0x0004)        /* */
#define ATIMLO2_L                        (0x0004)
#define ATIMLO3                          (0x0008)        /* */
#define ATIMLO3_L                        (0x0008)
#define ATIMLO4                          (0x0010)        /* */
#define ATIMLO4_L                        (0x0010)
#define ATIMLO5                          (0x0020)        /* */
#define ATIMLO5_L                        (0x0020)
#define ATIMLO6                          (0x0040)        /* */
#define ATIMLO6_L                        (0x0040)
#define ATIMLO7                          (0x0080)        /* */
#define ATIMLO7_L                        (0x0080)
#define ATIMLO8                          (0x0100)        /* */
#define ATIMLO8_H                        (0x0001)
#define ATIMLO9                          (0x0200)        /* */
#define ATIMLO9_H                        (0x0002)
#define ATIMLO10                         (0x0400)        /* */
#define ATIMLO10_H                       (0x0004)
#define ATIMLO11                         (0x0800)        /* */
#define ATIMLO11_H                       (0x0008)
#define ATIMLO12                         (0x1000)        /* */
#define ATIMLO12_H                       (0x0010)
#define ATIMLO13                         (0x2000)        /* */
#define ATIMLO13_H                       (0x0020)
#define ATIMLO14                         (0x4000)        /* */
#define ATIMLO14_H                       (0x0040)
#define ATIMLO15                         (0x8000)        /* */
#define ATIMLO15_H                       (0x0080)

/* SAPHATIMHI Control Bits */
#define ATIMHI                           (0x000f)        /* */
#define ATIMHI_L                         (0x000f)
#define ATIMHI0                          (0x0001)        /* */
#define ATIMHI0_L                        (0x0001)
#define ATIMHI1                          (0x0002)        /* */
#define ATIMHI1_L                        (0x0002)
#define ATIMHI2                          (0x0004)        /* */
#define ATIMHI2_L                        (0x0004)
#define ATIMHI3                          (0x0008)        /* */
#define ATIMHI3_L                        (0x0008)


/*****************************************************************************
 SDHS Registers
*****************************************************************************/

#define __MSP430_HAS_SDHS__                   /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SDHS__ 0x0E80
#define SDHS_BASE              __MSP430_BASEADDRESS_SDHS__

sfr_w(SDHSIIDX);                              /* Interrupt Index Register */
sfr_b(SDHSIIDX_L);
sfr_b(SDHSIIDX_H);
sfr_w(SDHSMIS);                               /* Masked Interrupt Status and Clear Register */
sfr_b(SDHSMIS_L);
sfr_b(SDHSMIS_H);
sfr_w(SDHSRIS);                               /* Raw Interrupt Status Register */
sfr_b(SDHSRIS_L);
sfr_b(SDHSRIS_H);
sfr_w(SDHSIMSC);                              /* Interrupt Mask Register */
sfr_b(SDHSIMSC_L);
sfr_b(SDHSIMSC_H);
sfr_w(SDHSICR);                               /* Interrupt Clear Register. */
sfr_b(SDHSICR_L);
sfr_b(SDHSICR_H);
sfr_w(SDHSISR);                               /* Interrupt Set Register. */
sfr_b(SDHSISR_L);
sfr_b(SDHSISR_H);
sfr_w(SDHSDESCLO);                            /* SDHS Descriptor Register L. */
sfr_b(SDHSDESCLO_L);
sfr_b(SDHSDESCLO_H);
sfr_w(SDHSDESCHI);                            /* SDHS Descriptor Register H. */
sfr_b(SDHSDESCHI_L);
sfr_b(SDHSDESCHI_H);
sfr_w(SDHSCTL0);                              /* SDHS Control Register 0 */
sfr_b(SDHSCTL0_L);
sfr_b(SDHSCTL0_H);
sfr_w(SDHSCTL1);                              /* SDHS Control Register 1 */
sfr_b(SDHSCTL1_L);
sfr_b(SDHSCTL1_H);
sfr_w(SDHSCTL2);                              /* SDHS Control Register 2 */
sfr_b(SDHSCTL2_L);
sfr_b(SDHSCTL2_H);
sfr_w(SDHSCTL3);                              /* SDHS Control Register 3 */
sfr_b(SDHSCTL3_L);
sfr_b(SDHSCTL3_H);
sfr_w(SDHSCTL4);                              /* SDHS Control Register 4 */
sfr_b(SDHSCTL4_L);
sfr_b(SDHSCTL4_H);
sfr_w(SDHSCTL5);                              /* SDHS Control Register 5 */
sfr_b(SDHSCTL5_L);
sfr_b(SDHSCTL5_H);
sfr_w(SDHSCTL6);                              /* SDHS Control Register 6 */
sfr_b(SDHSCTL6_L);
sfr_b(SDHSCTL6_H);
sfr_w(SDHSCTL7);                              /* SDHS Control Register 7 */
sfr_b(SDHSCTL7_L);
sfr_b(SDHSCTL7_H);
sfr_w(SDHSDT);                                /* SDHS Data Converstion Register */
sfr_b(SDHSDT_L);
sfr_b(SDHSDT_H);
sfr_w(SDHSWINHITH);                           /* SDHS Window Comparator High Threshold Register. */
sfr_b(SDHSWINHITH_L);
sfr_b(SDHSWINHITH_H);
sfr_w(SDHSWINLOTH);                           /* SDHS Window Comparator Low Threshold Register. */
sfr_b(SDHSWINLOTH_L);
sfr_b(SDHSWINLOTH_H);
sfr_w(SDHSDTCDA);                             /* DTC destination address register */
sfr_b(SDHSDTCDA_L);
sfr_b(SDHSDTCDA_H);

/* SDHS Register Offsets */
#define OFS_SDHSIIDX                     (0x0000)
#define OFS_SDHSIIDX_L                   OFS_SDHSIIDX
#define OFS_SDHSIIDX_H                   OFS_SDHSIIDX+1
#define OFS_SDHSMIS                      (0x0002)
#define OFS_SDHSMIS_L                    OFS_SDHSMIS
#define OFS_SDHSMIS_H                    OFS_SDHSMIS+1
#define OFS_SDHSRIS                      (0x0004)
#define OFS_SDHSRIS_L                    OFS_SDHSRIS
#define OFS_SDHSRIS_H                    OFS_SDHSRIS+1
#define OFS_SDHSIMSC                     (0x0006)
#define OFS_SDHSIMSC_L                   OFS_SDHSIMSC
#define OFS_SDHSIMSC_H                   OFS_SDHSIMSC+1
#define OFS_SDHSICR                      (0x0008)
#define OFS_SDHSICR_L                    OFS_SDHSICR
#define OFS_SDHSICR_H                    OFS_SDHSICR+1
#define OFS_SDHSISR                      (0x000A)
#define OFS_SDHSISR_L                    OFS_SDHSISR
#define OFS_SDHSISR_H                    OFS_SDHSISR+1
#define OFS_SDHSDESCLO                   (0x000C)
#define OFS_SDHSDESCLO_L                 OFS_SDHSDESCLO
#define OFS_SDHSDESCLO_H                 OFS_SDHSDESCLO+1
#define OFS_SDHSDESCHI                   (0x000E)
#define OFS_SDHSDESCHI_L                 OFS_SDHSDESCHI
#define OFS_SDHSDESCHI_H                 OFS_SDHSDESCHI+1
#define OFS_SDHSCTL0                     (0x0010)
#define OFS_SDHSCTL0_L                   OFS_SDHSCTL0
#define OFS_SDHSCTL0_H                   OFS_SDHSCTL0+1
#define OFS_SDHSCTL1                     (0x0012)
#define OFS_SDHSCTL1_L                   OFS_SDHSCTL1
#define OFS_SDHSCTL1_H                   OFS_SDHSCTL1+1
#define OFS_SDHSCTL2                     (0x0014)
#define OFS_SDHSCTL2_L                   OFS_SDHSCTL2
#define OFS_SDHSCTL2_H                   OFS_SDHSCTL2+1
#define OFS_SDHSCTL3                     (0x0016)
#define OFS_SDHSCTL3_L                   OFS_SDHSCTL3
#define OFS_SDHSCTL3_H                   OFS_SDHSCTL3+1
#define OFS_SDHSCTL4                     (0x0018)
#define OFS_SDHSCTL4_L                   OFS_SDHSCTL4
#define OFS_SDHSCTL4_H                   OFS_SDHSCTL4+1
#define OFS_SDHSCTL5                     (0x001A)
#define OFS_SDHSCTL5_L                   OFS_SDHSCTL5
#define OFS_SDHSCTL5_H                   OFS_SDHSCTL5+1
#define OFS_SDHSCTL6                     (0x001C)
#define OFS_SDHSCTL6_L                   OFS_SDHSCTL6
#define OFS_SDHSCTL6_H                   OFS_SDHSCTL6+1
#define OFS_SDHSCTL7                     (0x001E)
#define OFS_SDHSCTL7_L                   OFS_SDHSCTL7
#define OFS_SDHSCTL7_H                   OFS_SDHSCTL7+1
#define OFS_SDHSDT                       (0x0022)
#define OFS_SDHSDT_L                     OFS_SDHSDT
#define OFS_SDHSDT_H                     OFS_SDHSDT+1
#define OFS_SDHSWINHITH                  (0x0024)
#define OFS_SDHSWINHITH_L                OFS_SDHSWINHITH
#define OFS_SDHSWINHITH_H                OFS_SDHSWINHITH+1
#define OFS_SDHSWINLOTH                  (0x0026)
#define OFS_SDHSWINLOTH_L                OFS_SDHSWINLOTH
#define OFS_SDHSWINLOTH_H                OFS_SDHSWINLOTH+1
#define OFS_SDHSDTCDA                    (0x0028)
#define OFS_SDHSDTCDA_L                  OFS_SDHSDTCDA
#define OFS_SDHSDTCDA_H                  OFS_SDHSDTCDA+1

/* SDHS Control Bits */

/* SDHSIIDX Control Bits */
#define IIDX_5                           (0x000a)        /* Interrupt Source: RIS.WINHI */
#define IIDX_5_L                         (0x000a)
#define IIDX_6                           (0x000c)        /* Interrupt Source: RIS.WINLO */
#define IIDX_6_L                         (0x000c)
#define IIDX_7                           (0x000e)        /* Reserved; Interrupt */
#define IIDX_7_L                         (0x000e)
#define IIDX_8                           (0x0010)        /* Reserved; Interrupt Priority: Lowest */
#define IIDX_8_L                         (0x0010)

/* SDHSMIS Control Bits */
#define DTRDY                            (0x0008)        /* SDHS Data Ready Masked Interrupt Status bit. */
#define DTRDY_L                          (0x0008)
#define DTRDY_0                          (0x0000)        /* No interrupt pending */
#define DTRDY_1                          (0x0008)        /* Interrupt pending */
#define DTRDY_1_L                        (0x0008)
#define SSTRG                            (0x0004)        /* SDHS Start Conversion Trigger Masked Interrupt Status bit. */
#define SSTRG_L                          (0x0004)
#define SSTRG_0                          (0x0000)        /* No interrupt pending */
#define SSTRG_1                          (0x0004)        /* Interrupt pending */
#define SSTRG_1_L                        (0x0004)
#define OVF                              (0x0001)        /* SDHS Data Overflow Masked Interrupt Status bit. */
#define OVF_L                            (0x0001)
#define OVF_0                            (0x0000)        /* No interrupt pending */
#define OVF_1                            (0x0001)        /* Interrupt pending */
#define OVF_1_L                          (0x0001)
#define ACQDONE                          (0x0002)        /* Acquisition Done Masked Interrupt Status bit. */
#define ACQDONE_L                        (0x0002)
#define ACQDONE_0                        (0x0000)        /* No interrupt pending */
#define ACQDONE_1                        (0x0002)        /* Interrupt pending */
#define ACQDONE_1_L                      (0x0002)
#define WINHI                            (0x0010)        /* SDHS Window High Masked Interrupt Status bit. */
#define WINHI_L                          (0x0010)
#define WINHI_0                          (0x0000)        /* No interrupt pending */
#define WINHI_1                          (0x0010)        /* Interrupt pending */
#define WINHI_1_L                        (0x0010)
#define WINLO                            (0x0020)        /* SDHS Window Low Masked Interrupt Status and Clear bit. */
#define WINLO_L                          (0x0020)
#define WINLO_0                          (0x0000)        /* No interrupt pending */
#define WINLO_1                          (0x0020)        /* Interrupt pending */
#define WINLO_1_L                        (0x0020)

/* SDHSRIS Control Bits */
#define ISTOP                            (0x8000)        /* Incomplete Stop Status bit. */
#define ISTOP_H                          (0x0080)
#define ISTOP_0                          (0x0000)        /* No ISTOP event */
#define ISTOP_1                          (0x8000)        /* Conversion has been interrupted and stopped before completing 
                                                            the number of samples defined in CTL2.SAMPSZ. */
#define ISTOP_1_H                        (0x0080)

/* SDHSCTL0 Control Bits */
#define DALGN                            (0x0080)        /* Data alignment */
#define DALGN_L                          (0x0080)
#define DALGN_0                          (0x0000)        /* Right-aligned. */
#define DALGN_1                          (0x0080)        /* Left-aligned. */
#define DALGN_1_L                        (0x0080)
#define DFMSEL                           (0x0300)        /* Data format */
#define DFMSEL_H                         (0x0003)
#define DFMSEL0                          (0x0100)        /* Data format */
#define DFMSEL0_H                        (0x0001)
#define DFMSEL1                          (0x0200)        /* Data format */
#define DFMSEL1_H                        (0x0002)
#define DFMSEL_0                         (0x0000)        /* 2's complement */
#define DFMSEL_1                         (0x0100)        /* Offset binary */
#define DFMSEL_1_H                       (0x0001)
#define DFMSEL_2                         (0x0200)        /* Reserved (defaults to 0, 2s complement) */
#define DFMSEL_2_H                       (0x0002)
#define DFMSEL_3                         (0x0300)        /* Reserved (defaults to 0, 2s complement) */
#define DFMSEL_3_H                       (0x0003)
#define INTDLY                           (0x000e)        /* */
#define INTDLY_L                         (0x000e)
#define INTDLY0                          (0x0002)        /* */
#define INTDLY0_L                        (0x0002)
#define INTDLY1                          (0x0004)        /* */
#define INTDLY1_L                        (0x0004)
#define INTDLY2                          (0x0008)        /* */
#define INTDLY2_L                        (0x0008)
#define INTDLY_0                         (0x0000)        /* No dealy */
#define INTDLY_1                         (0x0002)        /* 1 sample delay, 2nd sample is the first interrupt */
#define INTDLY_1_L                       (0x0002)
#define INTDLY_2                         (0x0004)        /* 2 samples delay, 3rd sample is the first interrupt */
#define INTDLY_2_L                       (0x0004)
#define INTDLY_3                         (0x0006)        /* 3 samples delay, 4rd sample is the first interrupt */
#define INTDLY_3_L                       (0x0006)
#define INTDLY_4                         (0x0008)        /* 4 samples delay, 5th sample is the first interrupt */
#define INTDLY_4_L                       (0x0008)
#define INTDLY_5                         (0x000a)        /* 5 samples delay, 6th sample is the first interrupt */
#define INTDLY_5_L                       (0x000a)
#define INTDLY_6                         (0x000c)        /* 6 samples delay, 7th sample is the first interrupt */
#define INTDLY_6_L                       (0x000c)
#define INTDLY_7                         (0x000e)        /* 7 samples delay, 8th sample is the first interrupt */
#define INTDLY_7_L                       (0x000e)
#define AUTOSSDIS                        (0x0001)        /* SDHS Auto Sample Start Disable */
#define AUTOSSDIS_L                      (0x0001)
#define AUTOSSDIS_0                      (0x0000)        /* Auto Sample start enabled. SDHS is powered up when the 
                                                            SHDS_PWR_UP applied, then data conversion is automatically 
                                                            started once the SDHS is fully powered up. */
#define AUTOSSDIS_1                      (0x0001)        /* Auto Sample start disabled.  (This configuration must be used 
                                                            when the ASQ controls the measurement sequences) - SHDS_PWR_UP
                                                            signal to turns on the SDHS - CONVERSION_START signal to start
                                                            data convesion */
#define AUTOSSDIS_1_L                    (0x0001)
#define TRGSRC                           (0x8000)        /* SDHS trigger source select. */
#define TRGSRC_H                         (0x0080)
#define TRGSRC_0                         (0x0000)        /* Register control mode:  - CTL4.SDHSON is the source of the 
                                                            SHDS_PWR_UP/DOWN signal - CTL5.SSTART is the source of the 
                                                            CONVERSION_START/STOP signal */
#define TRGSRC_1                         (0x8000)        /* ASQ control mode: The SDHS is controlled by the ASQ. - 
                                                            ASQ_ACQARM signal from the ASQ is the source of the 
                                                            SHDS_PWR_UP/DOWN signal - ASQ_ACQTRIG signal from the ASQ is 
                                                            the source of the CONVERSION_START/STOP signal */
#define TRGSRC_1_H                       (0x0080)
#define OBR                              (0x0c00)        /* Output Bit Resolution */
#define OBR_H                            (0x000c)
#define OBR0                             (0x0400)        /* Output Bit Resolution */
#define OBR0_H                           (0x0004)
#define OBR1                             (0x0800)        /* Output Bit Resolution */
#define OBR1_H                           (0x0008)
#define OBR_0                            (0x0000)        /* 12-bit */
#define OBR_1                            (0x0400)        /* 13-bit */
#define OBR_1_H                          (0x0004)
#define OBR_2                            (0x0800)        /* 14-bit */
#define OBR_2_H                          (0x0008)
#define OBR_3                            (0x0c00)        /* Reserved (default: 12-bit) */
#define OBR_3_H                          (0x000c)
#define SHIFT                            (0x3000)        /* MSB Shift */
#define SHIFT_H                          (0x0030)
#define SHIFT0                           (0x1000)        /* MSB Shift */
#define SHIFT0_H                         (0x0010)
#define SHIFT1                           (0x2000)        /* MSB Shift */
#define SHIFT1_H                         (0x0020)
#define SHIFT_0                          (0x0000)        /* No Shift, MSB. */
#define SHIFT_1                          (0x1000)        /* MSB - 1 (Shift left by 1 from filter out). If OBR = 2, then 
                                                            this configuration is invalid. No shift is performed. */
#define SHIFT_1_H                        (0x0010)
#define SHIFT_2                          (0x2000)        /* MSB -2 (Shift left by 2 from filter out). If OBR = 1, then 
                                                            this configuration is invalid. No shift is performed. */
#define SHIFT_2_H                        (0x0020)
#define SHIFT_3                          (0x3000)        /* Reserved (No shift) */
#define SHIFT_3_H                        (0x0030)

/* SDHSCTL1 Control Bits */
#define OSR                              (0x000f)        /* Over Sampling Rate. */
#define OSR_L                            (0x000f)
#define OSR0                             (0x0001)        /* Over Sampling Rate. */
#define OSR0_L                           (0x0001)
#define OSR1                             (0x0002)        /* Over Sampling Rate. */
#define OSR1_L                           (0x0002)
#define OSR2                             (0x0004)        /* Over Sampling Rate. */
#define OSR2_L                           (0x0004)
#define OSR3                             (0x0008)        /* Over Sampling Rate. */
#define OSR3_L                           (0x0008)
#define OSR_0                            (0x0000)        /* 10 */
#define OSR_1                            (0x0001)        /* 20 */
#define OSR_1_L                          (0x0001)
#define OSR_2                            (0x0002)        /* 40 */
#define OSR_2_L                          (0x0002)
#define OSR_3                            (0x0003)        /* 80 */
#define OSR_3_L                          (0x0003)
#define OSR_4                            (0x0004)        /* 160 */
#define OSR_4_L                          (0x0004)

/* SDHSCTL2 Control Bits */
#define SMPCTLOFF                        (0x0400)        /* Disable sampling size counting. */
#define SMPCTLOFF_H                      (0x0004)
#define SMPCTLOFF_0                      (0x0000)        /* Total sampling size is determined by SMPSZ bits. The SDHS 
                                                            automatically stops data conversion. */
#define SMPCTLOFF_1                      (0x0400)        /* SMPSZ bits are ignored. Conversion does not stop until the 
                                                            trigger source selected by TRGSRC bits is deasserted. */
#define SMPCTLOFF_1_H                    (0x0004)
#define SMPSZ                            (0x03ff)        /* Total Sample Size. */
#define SMPSZ_L                          (0x00ff)
#define SMPSZ_H                          (0x0003)
#define SMPSZ0                           (0x0001)        /* Total Sample Size. */
#define SMPSZ0_L                         (0x0001)
#define SMPSZ1                           (0x0002)        /* Total Sample Size. */
#define SMPSZ1_L                         (0x0002)
#define SMPSZ2                           (0x0004)        /* Total Sample Size. */
#define SMPSZ2_L                         (0x0004)
#define SMPSZ3                           (0x0008)        /* Total Sample Size. */
#define SMPSZ3_L                         (0x0008)
#define SMPSZ4                           (0x0010)        /* Total Sample Size. */
#define SMPSZ4_L                         (0x0010)
#define SMPSZ5                           (0x0020)        /* Total Sample Size. */
#define SMPSZ5_L                         (0x0020)
#define SMPSZ6                           (0x0040)        /* Total Sample Size. */
#define SMPSZ6_L                         (0x0040)
#define SMPSZ7                           (0x0080)        /* Total Sample Size. */
#define SMPSZ7_L                         (0x0080)
#define SMPSZ8                           (0x0100)        /* Total Sample Size. */
#define SMPSZ8_H                         (0x0001)
#define SMPSZ9                           (0x0200)        /* Total Sample Size. */
#define SMPSZ9_H                         (0x0002)
#define DTCOFF                           (0x8000)        /* Data Transfer Controller (DTC) Off */
#define DTCOFF_H                         (0x0080)
#define DTCOFF_0                         (0x0000)        /* DTC enabled. The DTC automatically transfers the data from the
                                                            SDHSDT register to the address specified in the DTCDA 
                                                            register. */
#define DTCOFF_1                         (0x8000)        /* DTC disabled. The data in the SDHSDT register must be read by 
                                                            CPU, otherwise the overflow interrupt flag (RIS.OVF) will 
                                                            eventually be asserted. */
#define DTCOFF_1_H                       (0x0080)
#define WINCMPEN                         (0x4000)        /* Window Comparator Enable */
#define WINCMPEN_H                       (0x0040)
#define WINCMPEN_0                       (0x0000)        /* Window Comparator is disabled */
#define WINCMPEN_1                       (0x4000)        /* Window Comparator is enabled */
#define WINCMPEN_1_H                     (0x0040)

/* SDHSCTL3 Control Bits */
#define TRIGEN                           (0x0001)        /* SDHS Trigger Enable bit */
#define TRIGEN_L                         (0x0001)
#define TRIGEN_0                         (0x0000)        /* SDHS Trigger is disabled. Once this bit is de-asserted, CTL0, 
                                                            CTL1, CTL2, CTL7,WINHITH, WINLOTH, and DTCDA registers are 
                                                            unlocked (allowed to be modified). */
#define TRIGEN_1                         (0x0001)        /* SDHS Trigger is enabled. Once this bit is asserted, CTL0,  
                                                            CTL1, CTL2, CTL7,WINHITH, WINLOTH, and DTCDA registers are 
                                                            locked (not allowed to be modified). */
#define TRIGEN_1_L                       (0x0001)

/* SDHSCTL4 Control Bits */
#define SDHSON                           (0x0001)        /* SDHS Power-up */
#define SDHSON_L                         (0x0001)
#define SDHSON_0                         (0x0000)        /* Power down the SDHS module */
#define SDHSON_1                         (0x0001)        /* Power on the SDHS module */
#define SDHSON_1_L                       (0x0001)

/* SDHSCTL5 Control Bits */
#define SSTART                           (0x0001)        /* Start of conversion. */
#define SSTART_L                         (0x0001)
#define SSTART_0                         (0x0000)        /* Stop conversion */
#define SSTART_1                         (0x0001)        /* Start conversion */
#define SSTART_1_L                       (0x0001)
#define SDHS_LOCK                        (0x0100)        /* Start of conversion. */
#define SDHS_LOCK_H                      (0x0001)
#define SDHS_LOCK_0                      (0x0000)        /* CTL3 register is unlocked. */
#define SDHS_LOCK_1                      (0x0100)        /* CTL3 register is locked as well as  CTL0,  CTL1, CTL2, 
                                                            CTL7,WINHITH, WINLOTH, and DTCDA registers. Only read is 
                                                            allowed. */
#define SDHS_LOCK_1_H                    (0x0001)

/* SDHSCTL6 Control Bits */
#define PGA_GAIN                         (0x003f)        /* PGA Gain Control bits */
#define PGA_GAIN_L                       (0x003f)
#define PGA_GAIN0                        (0x0001)        /* PGA Gain Control bits */
#define PGA_GAIN0_L                      (0x0001)
#define PGA_GAIN1                        (0x0002)        /* PGA Gain Control bits */
#define PGA_GAIN1_L                      (0x0002)
#define PGA_GAIN2                        (0x0004)        /* PGA Gain Control bits */
#define PGA_GAIN2_L                      (0x0004)
#define PGA_GAIN3                        (0x0008)        /* PGA Gain Control bits */
#define PGA_GAIN3_L                      (0x0008)
#define PGA_GAIN4                        (0x0010)        /* PGA Gain Control bits */
#define PGA_GAIN4_L                      (0x0010)
#define PGA_GAIN5                        (0x0020)        /* PGA Gain Control bits */
#define PGA_GAIN5_L                      (0x0020)

/* SDHSCTL7 Control Bits */
#define MODOPTI                          (0x001f)        /* SDHS Modulator Optimization bits. */
#define MODOPTI_L                        (0x001f)
#define MODOPTI0                         (0x0001)        /* SDHS Modulator Optimization bits. */
#define MODOPTI0_L                       (0x0001)
#define MODOPTI1                         (0x0002)        /* SDHS Modulator Optimization bits. */
#define MODOPTI1_L                       (0x0002)
#define MODOPTI2                         (0x0004)        /* SDHS Modulator Optimization bits. */
#define MODOPTI2_L                       (0x0004)
#define MODOPTI3                         (0x0008)        /* SDHS Modulator Optimization bits. */
#define MODOPTI3_L                       (0x0008)
#define MODOPTI4                         (0x0010)        /* SDHS Modulator Optimization bits. */
#define MODOPTI4_L                       (0x0010)

/* SDHSWINHITH Control Bits */
#define WINHITH                          (0xffff)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH_L                        (0x00ff)
#define WINHITH_H                        (0x00ff)
#define WINHITH0                         (0x0001)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH0_L                       (0x0001)
#define WINHITH1                         (0x0002)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH1_L                       (0x0002)
#define WINHITH2                         (0x0004)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH2_L                       (0x0004)
#define WINHITH3                         (0x0008)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH3_L                       (0x0008)
#define WINHITH4                         (0x0010)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH4_L                       (0x0010)
#define WINHITH5                         (0x0020)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH5_L                       (0x0020)
#define WINHITH6                         (0x0040)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH6_L                       (0x0040)
#define WINHITH7                         (0x0080)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH7_L                       (0x0080)
#define WINHITH8                         (0x0100)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH8_H                       (0x0001)
#define WINHITH9                         (0x0200)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH9_H                       (0x0002)
#define WINHITH10                        (0x0400)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH10_H                      (0x0004)
#define WINHITH11                        (0x0800)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH11_H                      (0x0008)
#define WINHITH12                        (0x1000)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH12_H                      (0x0010)
#define WINHITH13                        (0x2000)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH13_H                      (0x0020)
#define WINHITH14                        (0x4000)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH14_H                      (0x0040)
#define WINHITH15                        (0x8000)        /* SDHS Window Comparator High Threshold Register. */
#define WINHITH15_H                      (0x0080)

/* SDHSWINLOTH Control Bits */
#define WINLOTH                          (0xffff)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH_L                        (0x00ff)
#define WINLOTH_H                        (0x00ff)
#define WINLOTH0                         (0x0001)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH0_L                       (0x0001)
#define WINLOTH1                         (0x0002)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH1_L                       (0x0002)
#define WINLOTH2                         (0x0004)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH2_L                       (0x0004)
#define WINLOTH3                         (0x0008)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH3_L                       (0x0008)
#define WINLOTH4                         (0x0010)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH4_L                       (0x0010)
#define WINLOTH5                         (0x0020)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH5_L                       (0x0020)
#define WINLOTH6                         (0x0040)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH6_L                       (0x0040)
#define WINLOTH7                         (0x0080)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH7_L                       (0x0080)
#define WINLOTH8                         (0x0100)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH8_H                       (0x0001)
#define WINLOTH9                         (0x0200)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH9_H                       (0x0002)
#define WINLOTH10                        (0x0400)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH10_H                      (0x0004)
#define WINLOTH11                        (0x0800)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH11_H                      (0x0008)
#define WINLOTH12                        (0x1000)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH12_H                      (0x0010)
#define WINLOTH13                        (0x2000)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH13_H                      (0x0020)
#define WINLOTH14                        (0x4000)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH14_H                      (0x0040)
#define WINLOTH15                        (0x8000)        /* SDHS Window Comparator Low Threshold Register. */
#define WINLOTH15_H                      (0x0080)

/* SDHSDTCDA Control Bits */
#define DTCDA                            (0x7fff)        /* DTC destination address. */
#define DTCDA_L                          (0x00ff)
#define DTCDA_H                          (0x007f)
#define DTCDA0                           (0x0001)        /* DTC destination address. */
#define DTCDA0_L                         (0x0001)
#define DTCDA1                           (0x0002)        /* DTC destination address. */
#define DTCDA1_L                         (0x0002)
#define DTCDA2                           (0x0004)        /* DTC destination address. */
#define DTCDA2_L                         (0x0004)
#define DTCDA3                           (0x0008)        /* DTC destination address. */
#define DTCDA3_L                         (0x0008)
#define DTCDA4                           (0x0010)        /* DTC destination address. */
#define DTCDA4_L                         (0x0010)
#define DTCDA5                           (0x0020)        /* DTC destination address. */
#define DTCDA5_L                         (0x0020)
#define DTCDA6                           (0x0040)        /* DTC destination address. */
#define DTCDA6_L                         (0x0040)
#define DTCDA7                           (0x0080)        /* DTC destination address. */
#define DTCDA7_L                         (0x0080)
#define DTCDA8                           (0x0100)        /* DTC destination address. */
#define DTCDA8_H                         (0x0001)
#define DTCDA9                           (0x0200)        /* DTC destination address. */
#define DTCDA9_H                         (0x0002)
#define DTCDA10                          (0x0400)        /* DTC destination address. */
#define DTCDA10_H                        (0x0004)
#define DTCDA11                          (0x0800)        /* DTC destination address. */
#define DTCDA11_H                        (0x0008)
#define DTCDA12                          (0x1000)        /* DTC destination address. */
#define DTCDA12_H                        (0x0010)
#define DTCDA13                          (0x2000)        /* DTC destination address. */
#define DTCDA13_H                        (0x0020)
#define DTCDA14                          (0x4000)        /* DTC destination address. */
#define DTCDA14_H                        (0x0040)


/*****************************************************************************
 SFR Registers
*****************************************************************************/

#define __MSP430_HAS_SFR__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SFR__ 0x0100
#define SFR_BASE               __MSP430_BASEADDRESS_SFR__

sfr_w(SFRIE1);                                /* Interrupt Enable */
sfr_b(SFRIE1_L);
sfr_b(SFRIE1_H);
sfr_w(SFRIFG1);                               /* Interrupt Flag */
sfr_b(SFRIFG1_L);
sfr_b(SFRIFG1_H);
sfr_w(SFRRPCR);                               /* Reset Pin Control */
sfr_b(SFRRPCR_L);
sfr_b(SFRRPCR_H);

/* SFR Register Offsets */
#define OFS_SFRIE1                       (0x0000)
#define OFS_SFRIE1_L                     OFS_SFRIE1
#define OFS_SFRIE1_H                     OFS_SFRIE1+1
#define OFS_SFRIFG1                      (0x0002)
#define OFS_SFRIFG1_L                    OFS_SFRIFG1
#define OFS_SFRIFG1_H                    OFS_SFRIFG1+1
#define OFS_SFRRPCR                      (0x0004)
#define OFS_SFRRPCR_L                    OFS_SFRRPCR
#define OFS_SFRRPCR_H                    OFS_SFRRPCR+1

/* SFR Control Bits */

/* SFRIE1 Control Bits */
#define WDTIE                            (0x0001)        /* Watchdog timer interrupt enable */
#define WDTIE_L                          (0x0001)
#define WDTIE_0                          (0x0000)        /* Interrupts disabled */
#define WDTIE_1                          (0x0001)        /* Interrupts enabled */
#define WDTIE_1_L                        (0x0001)
#define WDTIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define WDTIE__ENABLE                    (0x0001)        /* Interrupts enabled */
#define WDTIE__ENABLE_L                  (0x0001)
#define OFIE                             (0x0002)        /* Oscillator fault interrupt enable */
#define OFIE_L                           (0x0002)
#define OFIE_0                           (0x0000)        /* Interrupts disabled */
#define OFIE_1                           (0x0002)        /* Interrupts enabled */
#define OFIE_1_L                         (0x0002)
#define OFIE__DISABLE                    (0x0000)        /* Interrupts disabled */
#define OFIE__ENABLE                     (0x0002)        /* Interrupts enabled */
#define OFIE__ENABLE_L                   (0x0002)
#define VMAIE                            (0x0008)        /* Vacant memory access interrupt enable */
#define VMAIE_L                          (0x0008)
#define VMAIE_0                          (0x0000)        /* Interrupts disabled */
#define VMAIE_1                          (0x0008)        /* Interrupts enabled */
#define VMAIE_1_L                        (0x0008)
#define VMAIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define VMAIE__ENABLE                    (0x0008)        /* Interrupts enabled */
#define VMAIE__ENABLE_L                  (0x0008)
#define NMIIE                            (0x0010)        /* NMI pin interrupt enable */
#define NMIIE_L                          (0x0010)
#define NMIIE_0                          (0x0000)        /* Interrupts disabled */
#define NMIIE_1                          (0x0010)        /* Interrupts enabled */
#define NMIIE_1_L                        (0x0010)
#define NMIIE__DISABLE                   (0x0000)        /* Interrupts disabled */
#define NMIIE__ENABLE                    (0x0010)        /* Interrupts enabled */
#define NMIIE__ENABLE_L                  (0x0010)
#define JMBINIE                          (0x0040)        /* JTAG mailbox input interrupt enable */
#define JMBINIE_L                        (0x0040)
#define JMBINIE_0                        (0x0000)        /* Interrupts disabled */
#define JMBINIE_1                        (0x0040)        /* Interrupts enabled */
#define JMBINIE_1_L                      (0x0040)
#define JMBINIE__DISABLE                 (0x0000)        /* Interrupts disabled */
#define JMBINIE__ENABLE                  (0x0040)        /* Interrupts enabled */
#define JMBINIE__ENABLE_L                (0x0040)
#define JMBOUTIE                         (0x0080)        /* JTAG mailbox output interrupt enable */
#define JMBOUTIE_L                       (0x0080)
#define JMBOUTIE_0                       (0x0000)        /* Interrupts disabled */
#define JMBOUTIE_1                       (0x0080)        /* Interrupts enabled */
#define JMBOUTIE_1_L                     (0x0080)
#define JMBOUTIE__DISABLE                (0x0000)        /* Interrupts disabled */
#define JMBOUTIE__ENABLE                 (0x0080)        /* Interrupts enabled */
#define JMBOUTIE__ENABLE_L               (0x0080)

/* SFRIFG1 Control Bits */
#define OFIFG                            (0x0002)        /* Oscillator fault interrupt flag */
#define OFIFG_L                          (0x0002)
#define OFIFG_0                          (0x0000)        /* No interrupt pending */
#define OFIFG_1                          (0x0002)        /* Interrupt pending */
#define OFIFG_1_L                        (0x0002)
#define VMAIFG                           (0x0008)        /* Vacant memory access interrupt flag */
#define VMAIFG_L                         (0x0008)
#define VMAIFG_0                         (0x0000)        /* No interrupt pending */
#define VMAIFG_1                         (0x0008)        /* Interrupt pending */
#define VMAIFG_1_L                       (0x0008)
#define NMIIFG                           (0x0010)        /* NMI pin interrupt flag */
#define NMIIFG_L                         (0x0010)
#define NMIIFG_0                         (0x0000)        /* No interrupt pending */
#define NMIIFG_1                         (0x0010)        /* Interrupt pending */
#define NMIIFG_1_L                       (0x0010)
#define WDTIFG                           (0x0001)        /* Watchdog timer interrupt flag */
#define WDTIFG_L                         (0x0001)
#define WDTIFG_0                         (0x0000)        /* No interrupt pending */
#define WDTIFG_1                         (0x0001)        /* Interrupt pending */
#define WDTIFG_1_L                       (0x0001)
#define JMBINIFG                         (0x0040)        /* JTAG mailbox input interrupt flag */
#define JMBINIFG_L                       (0x0040)
#define JMBINIFG_0                       (0x0000)        /* No interrupt pending. When in 16-bit mode (JMBMODE = 0), this 
                                                            bit is cleared automatically when JMBI0 is read by the CPU. 
                                                            When in 32-bit mode (JMBMODE = 1), this bit is cleared 
                                                            automatically when both JMBI0 and JMBI1 have been read by the 
                                                            CPU. This bit is also cleared when the associated vector in 
                                                            SYSUNIV has been read */
#define JMBINIFG_1                       (0x0040)        /* Interrupt pending. A message is waiting in the JMBIN 
                                                            registers. In 16-bit mode (JMBMODE = 0) when JMBI0 has been 
                                                            written by the JTAG module. In 32-bit mode (JMBMODE = 1) when 
                                                            JMBI0 and JMBI1 have been written by the JTAG module. */
#define JMBINIFG_1_L                     (0x0040)
#define JMBOUTIFG                        (0x0080)        /* JTAG mailbox output interrupt flag */
#define JMBOUTIFG_L                      (0x0080)
#define JMBOUTIFG_0                      (0x0000)        /* No interrupt pending. When in 16-bit mode (JMBMODE = 0), this 
                                                            bit is cleared automatically when JMBO0 has been written with 
                                                            a new message to the JTAG module by the CPU. When in 32-bit 
                                                            mode (JMBMODE = 1), this bit is cleared automatically when 
                                                            both JMBO0 and JMBO1 have been written with new messages to 
                                                            the JTAG module by the CPU. This bit is also cleared when the 
                                                            associated vector in SYSUNIV has been read. */
#define JMBOUTIFG_1                      (0x0080)        /* Interrupt pending. JMBO registers are ready for new messages. 
                                                            In 16-bit mode (JMBMODE = 0), JMBO0 has been received by the 
                                                            JTAG module and is ready for a new message from the CPU. In 
                                                            32-bit mode (JMBMODE = 1), JMBO0 and JMBO1 have been received 
                                                            by the JTAG module and are ready for new messages from the 
                                                            CPU. */
#define JMBOUTIFG_1_L                    (0x0080)

/* SFRRPCR Control Bits */
#define SYSNMI                           (0x0001)        /* NMI select */
#define SYSNMI_L                         (0x0001)
#define SYSNMI_0                         (0x0000)        /* Reset function */
#define SYSNMI_1                         (0x0001)        /* NMI function */
#define SYSNMI_1_L                       (0x0001)
#define SYSNMI__RESET                    (0x0000)        /* Reset function */
#define SYSNMI__NMI                      (0x0001)        /* NMI function */
#define SYSNMI__NMI_L                    (0x0001)
#define SYSNMIIES                        (0x0002)        /* NMI edge select */
#define SYSNMIIES_L                      (0x0002)
#define SYSNMIIES_0                      (0x0000)        /* NMI on rising edge */
#define SYSNMIIES_1                      (0x0002)        /* NMI on falling edge */
#define SYSNMIIES_1_L                    (0x0002)
#define SYSNMIIES__RISING                (0x0000)        /* NMI on rising edge */
#define SYSNMIIES__FALLING               (0x0002)        /* NMI on falling edge */
#define SYSNMIIES__FALLING_L             (0x0002)
#define SYSRSTUP                         (0x0004)        /* Reset resistor pin pullup or pulldown */
#define SYSRSTUP_L                       (0x0004)
#define SYSRSTUP_0                       (0x0000)        /* Pulldown is selected */
#define SYSRSTUP_1                       (0x0004)        /* Pullup is selected */
#define SYSRSTUP_1_L                     (0x0004)
#define SYSRSTUP__PULLDOWN               (0x0000)        /* Pulldown is selected */
#define SYSRSTUP__PULLUP                 (0x0004)        /* Pullup is selected */
#define SYSRSTUP__PULLUP_L               (0x0004)
#define SYSRSTRE                         (0x0008)        /* Reset pin resistor enable */
#define SYSRSTRE_L                       (0x0008)
#define SYSRSTRE_0                       (0x0000)        /* Pullup or pulldown resistor at the RST/NMI pin is disabled */
#define SYSRSTRE_1                       (0x0008)        /* Pullup or pulldown resistor at the RST/NMI pin is enabled */
#define SYSRSTRE_1_L                     (0x0008)
#define SYSRSTRE__DISABLE                (0x0000)        /* Pullup or pulldown resistor at the RST/NMI pin is disabled */
#define SYSRSTRE__ENABLE                 (0x0008)        /* Pullup or pulldown resistor at the RST/NMI pin is enabled */
#define SYSRSTRE__ENABLE_L               (0x0008)


/*****************************************************************************
 SYS Registers
*****************************************************************************/

#define __MSP430_HAS_SYS__                    /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_SYS__ 0x0180
#define SYS_BASE               __MSP430_BASEADDRESS_SYS__

sfr_w(SYSCTL);                                /* System Control */
sfr_b(SYSCTL_L);
sfr_b(SYSCTL_H);
sfr_w(SYSJMBC);                               /* JTAG Mailbox Control */
sfr_b(SYSJMBC_L);
sfr_b(SYSJMBC_H);
sfr_w(SYSJMBI0);                              /* JTAG Mailbox Input */
sfr_b(SYSJMBI0_L);
sfr_b(SYSJMBI0_H);
sfr_w(SYSJMBI1);                              /* JTAG Mailbox Input */
sfr_b(SYSJMBI1_L);
sfr_b(SYSJMBI1_H);
sfr_w(SYSJMBO0);                              /* JTAG Mailbox Output */
sfr_b(SYSJMBO0_L);
sfr_b(SYSJMBO0_H);
sfr_w(SYSJMBO1);                              /* JTAG Mailbox Output */
sfr_b(SYSJMBO1_L);
sfr_b(SYSJMBO1_H);
sfr_w(SYSUNIV);                               /* User NMI Vector Generator */
sfr_b(SYSUNIV_L);
sfr_b(SYSUNIV_H);
sfr_w(SYSSNIV);                               /* System NMI Vector Generator */
sfr_b(SYSSNIV_L);
sfr_b(SYSSNIV_H);
sfr_w(SYSRSTIV);                              /* Reset Vector Generator */
sfr_b(SYSRSTIV_L);
sfr_b(SYSRSTIV_H);

/* SYS Register Offsets */
#define OFS_SYSCTL                       (0x0000)
#define OFS_SYSCTL_L                     OFS_SYSCTL
#define OFS_SYSCTL_H                     OFS_SYSCTL+1
#define OFS_SYSJMBC                      (0x0006)
#define OFS_SYSJMBC_L                    OFS_SYSJMBC
#define OFS_SYSJMBC_H                    OFS_SYSJMBC+1
#define OFS_SYSJMBI0                     (0x0008)
#define OFS_SYSJMBI0_L                   OFS_SYSJMBI0
#define OFS_SYSJMBI0_H                   OFS_SYSJMBI0+1
#define OFS_SYSJMBI1                     (0x000A)
#define OFS_SYSJMBI1_L                   OFS_SYSJMBI1
#define OFS_SYSJMBI1_H                   OFS_SYSJMBI1+1
#define OFS_SYSJMBO0                     (0x000C)
#define OFS_SYSJMBO0_L                   OFS_SYSJMBO0
#define OFS_SYSJMBO0_H                   OFS_SYSJMBO0+1
#define OFS_SYSJMBO1                     (0x000E)
#define OFS_SYSJMBO1_L                   OFS_SYSJMBO1
#define OFS_SYSJMBO1_H                   OFS_SYSJMBO1+1
#define OFS_SYSUNIV                      (0x001A)
#define OFS_SYSUNIV_L                    OFS_SYSUNIV
#define OFS_SYSUNIV_H                    OFS_SYSUNIV+1
#define OFS_SYSSNIV                      (0x001C)
#define OFS_SYSSNIV_L                    OFS_SYSSNIV
#define OFS_SYSSNIV_H                    OFS_SYSSNIV+1
#define OFS_SYSRSTIV                     (0x001E)
#define OFS_SYSRSTIV_L                   OFS_SYSRSTIV
#define OFS_SYSRSTIV_H                   OFS_SYSRSTIV+1

/* SYS Control Bits */

/* SYSCTL Control Bits */
#define SYSRIVECT                        (0x0001)        /* RAM-based interrupt vectors */
#define SYSRIVECT_L                      (0x0001)
#define SYSRIVECT_0                      (0x0000)        /* Interrupt vectors generated with end address TOP of lower 64K 
                                                            FRAM FFFFh */
#define SYSRIVECT_1                      (0x0001)        /* Interrupt vectors generated with end address TOP of RAM, when 
                                                            RAM available */
#define SYSRIVECT_1_L                    (0x0001)
#define SYSRIVECT__FRAM                  (0x0000)        /* Interrupt vectors generated with end address TOP of lower 64K 
                                                            FRAM FFFFh */
#define SYSRIVECT__RAM                   (0x0001)        /* Interrupt vectors generated with end address TOP of RAM, when 
                                                            RAM available */
#define SYSRIVECT__RAM_L                 (0x0001)
#define SYSPMMPE                         (0x0004)        /* PMM access protect */
#define SYSPMMPE_L                       (0x0004)
#define SYSPMMPE_0                       (0x0000)        /* Access from anywhere in memory */
#define SYSPMMPE_1                       (0x0004)        /* Access only from the BSL segments */
#define SYSPMMPE_1_L                     (0x0004)
#define SYSBSLIND                        (0x0010)        /* BSL entry indication */
#define SYSBSLIND_L                      (0x0010)
#define SYSBSLIND_0                      (0x0000)        /* No BSL entry sequence detected */
#define SYSBSLIND_1                      (0x0010)        /* BSL entry sequence detected */
#define SYSBSLIND_1_L                    (0x0010)
#define SYSJTAGPIN                       (0x0020)        /* Dedicated JTAG pins enable */
#define SYSJTAGPIN_L                     (0x0020)
#define SYSJTAGPIN_0                     (0x0000)        /* Shared JTAG pins (JTAG mode selectable using SBW sequence) */
#define SYSJTAGPIN_1                     (0x0020)        /* Dedicated JTAG pins (explicit 4-wire JTAG mode selection) */
#define SYSJTAGPIN_1_L                   (0x0020)
#define SYSJTAGPIN__SHARED               (0x0000)        /* Shared JTAG pins (JTAG mode selectable using SBW sequence) */
#define SYSJTAGPIN__DEDICATED            (0x0020)        /* Dedicated JTAG pins (explicit 4-wire JTAG mode selection) */
#define SYSJTAGPIN__DEDICATED_L          (0x0020)

/* SYSJMBC Control Bits */
#define JMBIN0FG                         (0x0001)        /* Incoming JTAG Mailbox 0 flag */
#define JMBIN0FG_L                       (0x0001)
#define JMBIN0FG_0                       (0x0000)        /* JMBI0 has no new data */
#define JMBIN0FG_1                       (0x0001)        /* JMBI0 has new data available */
#define JMBIN0FG_1_L                     (0x0001)
#define JMBIN1FG                         (0x0002)        /* Incoming JTAG Mailbox 1 flag */
#define JMBIN1FG_L                       (0x0002)
#define JMBIN1FG_0                       (0x0000)        /* JMBI1 has no new data */
#define JMBIN1FG_1                       (0x0002)        /* JMBI1 has new data available */
#define JMBIN1FG_1_L                     (0x0002)
#define JMBOUT0FG                        (0x0004)        /* Outgoing JTAG Mailbox 0 flag */
#define JMBOUT0FG_L                      (0x0004)
#define JMBOUT0FG_0                      (0x0000)        /* JMBO0 is not ready to receive new data */
#define JMBOUT0FG_1                      (0x0004)        /* JMBO0 is ready to receive new data */
#define JMBOUT0FG_1_L                    (0x0004)
#define JMBOUT1FG                        (0x0008)        /* Outgoing JTAG Mailbox 1 flag */
#define JMBOUT1FG_L                      (0x0008)
#define JMBOUT1FG_0                      (0x0000)        /* JMBO1 is not ready to receive new data */
#define JMBOUT1FG_1                      (0x0008)        /* JMBO1 is ready to receive new data */
#define JMBOUT1FG_1_L                    (0x0008)
#define JMBMODE                          (0x0010)        /* Operation mode of JMB */
#define JMBMODE_L                        (0x0010)
#define JMBMODE_0                        (0x0000)        /* 16-bit transfers using JMBO0 and JMBI0 only */
#define JMBMODE_1                        (0x0010)        /* 32-bit transfers using JMBO0 with JMBO1 and JMBI0 with JMBI1 */
#define JMBMODE_1_L                      (0x0010)
#define JMBMODE__16BIT                   (0x0000)        /* 16-bit transfers using JMBO0 and JMBI0 only */
#define JMBMODE__32BIT                   (0x0010)        /* 32-bit transfers using JMBO0 with JMBO1 and JMBI0 with JMBI1 */
#define JMBMODE__32BIT_L                 (0x0010)
#define JMBCLR0OFF                       (0x0040)        /* Incoming JTAG Mailbox 0 flag auto-clear disable */
#define JMBCLR0OFF_L                     (0x0040)
#define JMBCLR0OFF_0                     (0x0000)        /* JMBIN0FG cleared on read of JMB0IN register */
#define JMBCLR0OFF_1                     (0x0040)        /* JMBIN0FG cleared by software */
#define JMBCLR0OFF_1_L                   (0x0040)
#define JMBCLR1OFF                       (0x0080)        /* Incoming JTAG Mailbox 1 flag auto-clear disable */
#define JMBCLR1OFF_L                     (0x0080)
#define JMBCLR1OFF_0                     (0x0000)        /* JMBIN1FG cleared on read of JMB1IN register */
#define JMBCLR1OFF_1                     (0x0080)        /* JMBIN1FG cleared by software */
#define JMBCLR1OFF_1_L                   (0x0080)

/* SYSJMBI Control Bits */
#define MSGLO                            (0x00ff)        /* JTAG mailbox incoming message low byte */
#define MSGLO_L                          (0x00ff)
#define MSGLO0                           (0x0001)        /* JTAG mailbox incoming message low byte */
#define MSGLO0_L                         (0x0001)
#define MSGLO1                           (0x0002)        /* JTAG mailbox incoming message low byte */
#define MSGLO1_L                         (0x0002)
#define MSGLO2                           (0x0004)        /* JTAG mailbox incoming message low byte */
#define MSGLO2_L                         (0x0004)
#define MSGLO3                           (0x0008)        /* JTAG mailbox incoming message low byte */
#define MSGLO3_L                         (0x0008)
#define MSGLO4                           (0x0010)        /* JTAG mailbox incoming message low byte */
#define MSGLO4_L                         (0x0010)
#define MSGLO5                           (0x0020)        /* JTAG mailbox incoming message low byte */
#define MSGLO5_L                         (0x0020)
#define MSGLO6                           (0x0040)        /* JTAG mailbox incoming message low byte */
#define MSGLO6_L                         (0x0040)
#define MSGLO7                           (0x0080)        /* JTAG mailbox incoming message low byte */
#define MSGLO7_L                         (0x0080)
#define MSGHI                            (0xff00)        /* JTAG mailbox incoming message high byte */
#define MSGHI_H                          (0x00ff)
#define MSGHI0                           (0x0100)        /* JTAG mailbox incoming message high byte */
#define MSGHI0_H                         (0x0001)
#define MSGHI1                           (0x0200)        /* JTAG mailbox incoming message high byte */
#define MSGHI1_H                         (0x0002)
#define MSGHI2                           (0x0400)        /* JTAG mailbox incoming message high byte */
#define MSGHI2_H                         (0x0004)
#define MSGHI3                           (0x0800)        /* JTAG mailbox incoming message high byte */
#define MSGHI3_H                         (0x0008)
#define MSGHI4                           (0x1000)        /* JTAG mailbox incoming message high byte */
#define MSGHI4_H                         (0x0010)
#define MSGHI5                           (0x2000)        /* JTAG mailbox incoming message high byte */
#define MSGHI5_H                         (0x0020)
#define MSGHI6                           (0x4000)        /* JTAG mailbox incoming message high byte */
#define MSGHI6_H                         (0x0040)
#define MSGHI7                           (0x8000)        /* JTAG mailbox incoming message high byte */
#define MSGHI7_H                         (0x0080)

/* SYSUNIV Control Bits */
#define SYSUNIV0                         (0x0001)        /* User NMI vector */
#define SYSUNIV0_L                       (0x0001)
#define SYSUNIV1                         (0x0002)        /* User NMI vector */
#define SYSUNIV1_L                       (0x0002)
#define SYSUNIV2                         (0x0004)        /* User NMI vector */
#define SYSUNIV2_L                       (0x0004)
#define SYSUNIV3                         (0x0008)        /* User NMI vector */
#define SYSUNIV3_L                       (0x0008)
#define SYSUNIV4                         (0x0010)        /* User NMI vector */
#define SYSUNIV4_L                       (0x0010)
#define SYSUNIV5                         (0x0020)        /* User NMI vector */
#define SYSUNIV5_L                       (0x0020)
#define SYSUNIV6                         (0x0040)        /* User NMI vector */
#define SYSUNIV6_L                       (0x0040)
#define SYSUNIV7                         (0x0080)        /* User NMI vector */
#define SYSUNIV7_L                       (0x0080)
#define SYSUNIV8                         (0x0100)        /* User NMI vector */
#define SYSUNIV8_H                       (0x0001)
#define SYSUNIV9                         (0x0200)        /* User NMI vector */
#define SYSUNIV9_H                       (0x0002)
#define SYSUNIV10                        (0x0400)        /* User NMI vector */
#define SYSUNIV10_H                      (0x0004)
#define SYSUNIV11                        (0x0800)        /* User NMI vector */
#define SYSUNIV11_H                      (0x0008)
#define SYSUNIV12                        (0x1000)        /* User NMI vector */
#define SYSUNIV12_H                      (0x0010)
#define SYSUNIV13                        (0x2000)        /* User NMI vector */
#define SYSUNIV13_H                      (0x0020)
#define SYSUNIV14                        (0x4000)        /* User NMI vector */
#define SYSUNIV14_H                      (0x0040)
#define SYSUNIV15                        (0x8000)        /* User NMI vector */
#define SYSUNIV15_H                      (0x0080)
#define SYSUNIV_0                        (0x0000)        /* No interrupt pending */
#define SYSUNIV_2                        (0x0002)        /* NMIIFG NMI pin */
#define SYSUNIV_2_L                      (0x0002)
#define SYSUNIV_4                        (0x0004)        /* OFIFG oscillator fault */
#define SYSUNIV_4_L                      (0x0004)
#define SYSUNIV_6                        (0x0006)        /* DACCESSIFG */
#define SYSUNIV_6_L                      (0x0006)
#define SYSUNIV__NONE                    (0x0000)        /* No interrupt pending */
#define SYSUNIV__NMIIFG                  (0x0002)        /* NMIIFG NMI pin */
#define SYSUNIV__NMIIFG_L                (0x0002)
#define SYSUNIV__OFIFG                   (0x0004)        /* OFIFG oscillator fault */
#define SYSUNIV__OFIFG_L                 (0x0004)
#define SYSUNIV__DACCESSIFG              (0x0006)        /* DACCESSIFG */
#define SYSUNIV__DACCESSIFG_L            (0x0006)

/* SYSSNIV Control Bits */
#define SYSSNIV0                         (0x0001)        /* System NMI vector */
#define SYSSNIV0_L                       (0x0001)
#define SYSSNIV1                         (0x0002)        /* System NMI vector */
#define SYSSNIV1_L                       (0x0002)
#define SYSSNIV2                         (0x0004)        /* System NMI vector */
#define SYSSNIV2_L                       (0x0004)
#define SYSSNIV3                         (0x0008)        /* System NMI vector */
#define SYSSNIV3_L                       (0x0008)
#define SYSSNIV4                         (0x0010)        /* System NMI vector */
#define SYSSNIV4_L                       (0x0010)
#define SYSSNIV5                         (0x0020)        /* System NMI vector */
#define SYSSNIV5_L                       (0x0020)
#define SYSSNIV6                         (0x0040)        /* System NMI vector */
#define SYSSNIV6_L                       (0x0040)
#define SYSSNIV7                         (0x0080)        /* System NMI vector */
#define SYSSNIV7_L                       (0x0080)
#define SYSSNIV8                         (0x0100)        /* System NMI vector */
#define SYSSNIV8_H                       (0x0001)
#define SYSSNIV9                         (0x0200)        /* System NMI vector */
#define SYSSNIV9_H                       (0x0002)
#define SYSSNIV10                        (0x0400)        /* System NMI vector */
#define SYSSNIV10_H                      (0x0004)
#define SYSSNIV11                        (0x0800)        /* System NMI vector */
#define SYSSNIV11_H                      (0x0008)
#define SYSSNIV12                        (0x1000)        /* System NMI vector */
#define SYSSNIV12_H                      (0x0010)
#define SYSSNIV13                        (0x2000)        /* System NMI vector */
#define SYSSNIV13_H                      (0x0020)
#define SYSSNIV14                        (0x4000)        /* System NMI vector */
#define SYSSNIV14_H                      (0x0040)
#define SYSSNIV15                        (0x8000)        /* System NMI vector */
#define SYSSNIV15_H                      (0x0080)
#define SYSSNIV_0                        (0x0000)        /* No interrupt pending */
#define SYSSNIV_2                        (0x0002)        /* Reserved */
#define SYSSNIV_2_L                      (0x0002)
#define SYSSNIV_4                        (0x0004)        /* Uncorrectable FRAM bit error detection */
#define SYSSNIV_4_L                      (0x0004)
#define SYSSNIV_6                        (0x0006)        /* FRAM Access Time Error */
#define SYSSNIV_6_L                      (0x0006)
#define SYSSNIV_8                        (0x0008)        /* MPUSEGPIFG encapsulated IP memory segment violation */
#define SYSSNIV_8_L                      (0x0008)
#define SYSSNIV_10                       (0x000a)        /* Reserved */
#define SYSSNIV_10_L                     (0x000a)
#define SYSSNIV_12                       (0x000c)        /* MPUSEG1IFG segment 1 memory violation */
#define SYSSNIV_12_L                     (0x000c)
#define SYSSNIV_14                       (0x000e)        /* MPUSEG2IFG segment 2 memory violation */
#define SYSSNIV_14_L                     (0x000e)
#define SYSSNIV_16                       (0x0010)        /* MPUSEG3IFG segment 3 memory violation */
#define SYSSNIV_16_L                     (0x0010)
#define SYSSNIV_18                       (0x0012)        /* VMAIFG Vacant memory access */
#define SYSSNIV_18_L                     (0x0012)
#define SYSSNIV_20                       (0x0014)        /* JMBINIFG JTAG mailbox input */
#define SYSSNIV_20_L                     (0x0014)
#define SYSSNIV_22                       (0x0016)        /* JMBOUTIFG JTAG mailbox output */
#define SYSSNIV_22_L                     (0x0016)
#define SYSSNIV_24                       (0x0018)        /* Correctable FRAM bit error detection */
#define SYSSNIV_24_L                     (0x0018)
#define SYSSNIV_26                       (0x001a)        /* FRAM write protection detection */
#define SYSSNIV_26_L                     (0x001a)
#define SYSSNIV_28                       (0x001c)        /* LEA time-out fault */
#define SYSSNIV_28_L                     (0x001c)
#define SYSSNIV_30                       (0x001e)        /* LEA command fault */
#define SYSSNIV_30_L                     (0x001e)
#define SYSSNIV__NONE                    (0x0000)        /* No interrupt pending */
#define SYSSNIV__UBDIFG                  (0x0004)        /* Uncorrectable FRAM bit error detection */
#define SYSSNIV__UBDIFG_L                (0x0004)
#define SYSSNIV__ACCTEIFG                (0x0006)        /* FRAM Access Time Error */
#define SYSSNIV__ACCTEIFG_L              (0x0006)
#define SYSSNIV__MPUSEGPIFG              (0x0008)        /* MPUSEGPIFG encapsulated IP memory segment violation */
#define SYSSNIV__MPUSEGPIFG_L            (0x0008)
#define SYSSNIV__MPUSEG1IFG              (0x000c)        /* MPUSEG1IFG segment 1 memory violation */
#define SYSSNIV__MPUSEG1IFG_L            (0x000c)
#define SYSSNIV__MPUSEG2IFG              (0x000e)        /* MPUSEG2IFG segment 2 memory violation */
#define SYSSNIV__MPUSEG2IFG_L            (0x000e)
#define SYSSNIV__MPUSEG3IFG              (0x0010)        /* MPUSEG3IFG segment 3 memory violation */
#define SYSSNIV__MPUSEG3IFG_L            (0x0010)
#define SYSSNIV__VMAIFG                  (0x0012)        /* VMAIFG Vacant memory access */
#define SYSSNIV__VMAIFG_L                (0x0012)
#define SYSSNIV__JMBINIFG                (0x0014)        /* JMBINIFG JTAG mailbox input */
#define SYSSNIV__JMBINIFG_L              (0x0014)
#define SYSSNIV__JMBOUTIFG               (0x0016)        /* JMBOUTIFG JTAG mailbox output */
#define SYSSNIV__JMBOUTIFG_L             (0x0016)
#define SYSSNIV__CBDIFG                  (0x0018)        /* Correctable FRAM bit error detection */
#define SYSSNIV__CBDIFG_L                (0x0018)
#define SYSSNIV__WPROT                   (0x001a)        /* FRAM write protection detection */
#define SYSSNIV__WPROT_L                 (0x001a)
#define SYSSNIV__LEATO                   (0x001c)        /* LEA time-out fault */
#define SYSSNIV__LEATO_L                 (0x001c)
#define SYSSNIV__LEACMD                  (0x001e)        /* LEA command fault */
#define SYSSNIV__LEACMD_L                (0x001e)

/* SYSRSTIV Control Bits */
#define SYSRSTIV0                        (0x0001)        /* Reset interrupt vector */
#define SYSRSTIV0_L                      (0x0001)
#define SYSRSTIV1                        (0x0002)        /* Reset interrupt vector */
#define SYSRSTIV1_L                      (0x0002)
#define SYSRSTIV2                        (0x0004)        /* Reset interrupt vector */
#define SYSRSTIV2_L                      (0x0004)
#define SYSRSTIV3                        (0x0008)        /* Reset interrupt vector */
#define SYSRSTIV3_L                      (0x0008)
#define SYSRSTIV4                        (0x0010)        /* Reset interrupt vector */
#define SYSRSTIV4_L                      (0x0010)
#define SYSRSTIV5                        (0x0020)        /* Reset interrupt vector */
#define SYSRSTIV5_L                      (0x0020)
#define SYSRSTIV6                        (0x0040)        /* Reset interrupt vector */
#define SYSRSTIV6_L                      (0x0040)
#define SYSRSTIV7                        (0x0080)        /* Reset interrupt vector */
#define SYSRSTIV7_L                      (0x0080)
#define SYSRSTIV8                        (0x0100)        /* Reset interrupt vector */
#define SYSRSTIV8_H                      (0x0001)
#define SYSRSTIV9                        (0x0200)        /* Reset interrupt vector */
#define SYSRSTIV9_H                      (0x0002)
#define SYSRSTIV10                       (0x0400)        /* Reset interrupt vector */
#define SYSRSTIV10_H                     (0x0004)
#define SYSRSTIV11                       (0x0800)        /* Reset interrupt vector */
#define SYSRSTIV11_H                     (0x0008)
#define SYSRSTIV12                       (0x1000)        /* Reset interrupt vector */
#define SYSRSTIV12_H                     (0x0010)
#define SYSRSTIV13                       (0x2000)        /* Reset interrupt vector */
#define SYSRSTIV13_H                     (0x0020)
#define SYSRSTIV14                       (0x4000)        /* Reset interrupt vector */
#define SYSRSTIV14_H                     (0x0040)
#define SYSRSTIV15                       (0x8000)        /* Reset interrupt vector */
#define SYSRSTIV15_H                     (0x0080)
#define SYSRSTIV_0                       (0x0000)        /* No interrupt pending */
#define SYSRSTIV_2                       (0x0002)        /* Brownout */
#define SYSRSTIV_2_L                     (0x0002)
#define SYSRSTIV_4                       (0x0004)        /* RSTIFG RST/NMI */
#define SYSRSTIV_4_L                     (0x0004)
#define SYSRSTIV_6                       (0x0006)        /* PMMSWBOR software BOR */
#define SYSRSTIV_6_L                     (0x0006)
#define SYSRSTIV_8                       (0x0008)        /* LPMx.5 wakeup */
#define SYSRSTIV_8_L                     (0x0008)
#define SYSRSTIV_10                      (0x000a)        /* Security violation */
#define SYSRSTIV_10_L                    (0x000a)
#define SYSRSTIV_12                      (0x000c)        /* Reserved */
#define SYSRSTIV_12_L                    (0x000c)
#define SYSRSTIV_14                      (0x000e)        /* SVSHIFG SVSH event */
#define SYSRSTIV_14_L                    (0x000e)
#define SYSRSTIV_16                      (0x0010)        /* Reserved */
#define SYSRSTIV_16_L                    (0x0010)
#define SYSRSTIV_18                      (0x0012)        /* Reserved */
#define SYSRSTIV_18_L                    (0x0012)
#define SYSRSTIV_20                      (0x0014)        /* PMMSWPOR software POR */
#define SYSRSTIV_20_L                    (0x0014)
#define SYSRSTIV_22                      (0x0016)        /* WDTIFG watchdog timeout */
#define SYSRSTIV_22_L                    (0x0016)
#define SYSRSTIV_24                      (0x0018)        /* WDTPW watchdog password violation */
#define SYSRSTIV_24_L                    (0x0018)
#define SYSRSTIV_26                      (0x001a)        /* FRCTLPW password violation */
#define SYSRSTIV_26_L                    (0x001a)
#define SYSRSTIV_28                      (0x001c)        /* Uncorrectable FRAM bit error detection */
#define SYSRSTIV_28_L                    (0x001c)
#define SYSRSTIV_30                      (0x001e)        /* Peripheral area fetch */
#define SYSRSTIV_30_L                    (0x001e)
#define SYSRSTIV_32                      (0x0020)        /* PMM password violation */
#define SYSRSTIV_32_L                    (0x0020)
#define SYSRSTIV_34                      (0x0022)        /* MPU password violation */
#define SYSRSTIV_34_L                    (0x0022)
#define SYSRSTIV_36                      (0x0024)        /* CS password violation */
#define SYSRSTIV_36_L                    (0x0024)
#define SYSRSTIV_38                      (0x0026)        /* MPUSEGPIFG encapsulated IP memory segment violation */
#define SYSRSTIV_38_L                    (0x0026)
#define SYSRSTIV_40                      (0x0028)        /* Reserved */
#define SYSRSTIV_40_L                    (0x0028)
#define SYSRSTIV_42                      (0x002a)        /* MPUSEG1IFG segment 1 memory violation */
#define SYSRSTIV_42_L                    (0x002a)
#define SYSRSTIV_44                      (0x002c)        /* MPUSEG2IFG segment 2 memory violation */
#define SYSRSTIV_44_L                    (0x002c)
#define SYSRSTIV_46                      (0x002e)        /* MPUSEG3IFG segment 3 memory violation */
#define SYSRSTIV_46_L                    (0x002e)
#define SYSRSTIV__NONE                   (0x0000)        /* No interrupt pending */
#define SYSRSTIV__BOR                    (0x0002)        /* Brownout */
#define SYSRSTIV__BOR_L                  (0x0002)
#define SYSRSTIV__RSTNMI                 (0x0004)        /* RSTIFG RST/NMI */
#define SYSRSTIV__RSTNMI_L               (0x0004)
#define SYSRSTIV__PMMSWBOR               (0x0006)        /* PMMSWBOR software BOR */
#define SYSRSTIV__PMMSWBOR_L             (0x0006)
#define SYSRSTIV__LPM5WU                 (0x0008)        /* LPMx.5 wakeup */
#define SYSRSTIV__LPM5WU_L               (0x0008)
#define SYSRSTIV__SECYV                  (0x000a)        /* Security violation */
#define SYSRSTIV__SECYV_L                (0x000a)
#define SYSRSTIV__SVSHIFG                (0x000e)        /* SVSHIFG SVSH event */
#define SYSRSTIV__SVSHIFG_L              (0x000e)
#define SYSRSTIV__PMMSWPOR               (0x0014)        /* PMMSWPOR software POR */
#define SYSRSTIV__PMMSWPOR_L             (0x0014)
#define SYSRSTIV__WDTIFG                 (0x0016)        /* WDTIFG watchdog timeout */
#define SYSRSTIV__WDTIFG_L               (0x0016)
#define SYSRSTIV__WDTPW                  (0x0018)        /* WDTPW watchdog password violation */
#define SYSRSTIV__WDTPW_L                (0x0018)
#define SYSRSTIV__FRCTLPW                (0x001a)        /* FRCTLPW password violation */
#define SYSRSTIV__FRCTLPW_L              (0x001a)
#define SYSRSTIV__UBDIFG                 (0x001c)        /* Uncorrectable FRAM bit error detection */
#define SYSRSTIV__UBDIFG_L               (0x001c)
#define SYSRSTIV__PERF                   (0x001e)        /* Peripheral area fetch */
#define SYSRSTIV__PERF_L                 (0x001e)
#define SYSRSTIV__PMMPW                  (0x0020)        /* PMM password violation */
#define SYSRSTIV__PMMPW_L                (0x0020)
#define SYSRSTIV__MPUPW                  (0x0022)        /* MPU password violation */
#define SYSRSTIV__MPUPW_L                (0x0022)
#define SYSRSTIV__CSPW                   (0x0024)        /* CS password violation */
#define SYSRSTIV__CSPW_L                 (0x0024)
#define SYSRSTIV__MPUSEGPIFG             (0x0026)        /* MPUSEGPIFG encapsulated IP memory segment violation */
#define SYSRSTIV__MPUSEGPIFG_L           (0x0026)
#define SYSRSTIV__MPUSEG1IFG             (0x002a)        /* MPUSEG1IFG segment 1 memory violation */
#define SYSRSTIV__MPUSEG1IFG_L           (0x002a)
#define SYSRSTIV__MPUSEG2IFG             (0x002c)        /* MPUSEG2IFG segment 2 memory violation */
#define SYSRSTIV__MPUSEG2IFG_L           (0x002c)
#define SYSRSTIV__MPUSEG3IFG             (0x002e)        /* MPUSEG3IFG segment 3 memory violation */
#define SYSRSTIV__MPUSEG3IFG_L           (0x002e)


/*****************************************************************************
 TA0 Registers
*****************************************************************************/

#define __MSP430_HAS_TA0__ 3                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TAx__
#define __MSP430_HAS_TAx__
#endif
#define __MSP430_BASEADDRESS_TA0__ 0x0340
#define TA0_BASE               __MSP430_BASEADDRESS_TA0__

sfr_w(TA0CTL);                                /* TimerAx Control Register */
sfr_b(TA0CTL_L);
sfr_b(TA0CTL_H);
sfr_w(TA0CCTL0);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA0CCTL0_L);
sfr_b(TA0CCTL0_H);
sfr_w(TA0CCTL1);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA0CCTL1_L);
sfr_b(TA0CCTL1_H);
sfr_w(TA0CCTL2);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA0CCTL2_L);
sfr_b(TA0CCTL2_H);
sfr_w(TA0R);                                  /* TimerA register */
sfr_b(TA0R_L);
sfr_b(TA0R_H);
sfr_w(TA0CCR0);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA0CCR0_L);
sfr_b(TA0CCR0_H);
sfr_w(TA0CCR1);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA0CCR1_L);
sfr_b(TA0CCR1_H);
sfr_w(TA0CCR2);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA0CCR2_L);
sfr_b(TA0CCR2_H);
sfr_w(TA0EX0);                                /* TimerAx Expansion 0 Register */
sfr_b(TA0EX0_L);
sfr_b(TA0EX0_H);
sfr_w(TA0IV);                                 /* TimerAx Interrupt Vector Register */
sfr_b(TA0IV_L);
sfr_b(TA0IV_H);

/* TA0 Register Offsets */
#define OFS_TA0CTL                       (0x0000)
#define OFS_TA0CTL_L                     OFS_TA0CTL
#define OFS_TA0CTL_H                     OFS_TA0CTL+1
#define OFS_TA0CCTL0                     (0x0002)
#define OFS_TA0CCTL0_L                   OFS_TA0CCTL0
#define OFS_TA0CCTL0_H                   OFS_TA0CCTL0+1
#define OFS_TA0CCTL1                     (0x0004)
#define OFS_TA0CCTL1_L                   OFS_TA0CCTL1
#define OFS_TA0CCTL1_H                   OFS_TA0CCTL1+1
#define OFS_TA0CCTL2                     (0x0006)
#define OFS_TA0CCTL2_L                   OFS_TA0CCTL2
#define OFS_TA0CCTL2_H                   OFS_TA0CCTL2+1
#define OFS_TA0R                         (0x0010)
#define OFS_TA0R_L                       OFS_TA0R
#define OFS_TA0R_H                       OFS_TA0R+1
#define OFS_TA0CCR0                      (0x0012)
#define OFS_TA0CCR0_L                    OFS_TA0CCR0
#define OFS_TA0CCR0_H                    OFS_TA0CCR0+1
#define OFS_TA0CCR1                      (0x0014)
#define OFS_TA0CCR1_L                    OFS_TA0CCR1
#define OFS_TA0CCR1_H                    OFS_TA0CCR1+1
#define OFS_TA0CCR2                      (0x0016)
#define OFS_TA0CCR2_L                    OFS_TA0CCR2
#define OFS_TA0CCR2_H                    OFS_TA0CCR2+1
#define OFS_TA0EX0                       (0x0020)
#define OFS_TA0EX0_L                     OFS_TA0EX0
#define OFS_TA0EX0_H                     OFS_TA0EX0+1
#define OFS_TA0IV                        (0x002E)
#define OFS_TA0IV_L                      OFS_TA0IV
#define OFS_TA0IV_H                      OFS_TA0IV+1

/* TA0 Control Bits */

/* TA0CTL Control Bits */
#define TAIFG                            (0x0001)        /* TimerA interrupt flag */
#define TAIFG_L                          (0x0001)
#define TAIFG_0                          (0x0000)        /* No interrupt pending */
#define TAIFG_1                          (0x0001)        /* Interrupt pending */
#define TAIFG_1_L                        (0x0001)
#define TAIE                             (0x0002)        /* TimerA interrupt enable */
#define TAIE_L                           (0x0002)
#define TAIE_0                           (0x0000)        /* Interrupt disabled */
#define TAIE_1                           (0x0002)        /* Interrupt enabled */
#define TAIE_1_L                         (0x0002)
#define TACLR                            (0x0004)        /* TimerA clear */
#define TACLR_L                          (0x0004)
#define MC                               (0x0030)        /* Mode control */
#define MC_L                             (0x0030)
#define MC0                              (0x0010)        /* Mode control */
#define MC0_L                            (0x0010)
#define MC1                              (0x0020)        /* Mode control */
#define MC1_L                            (0x0020)
#define MC_0                             (0x0000)        /* Stop mode: Timer is halted */
#define MC_1                             (0x0010)        /* Up mode: Timer counts up to TAxCCR0 */
#define MC_1_L                           (0x0010)
#define MC_2                             (0x0020)        /* Continuous mode: Timer counts up to 0FFFFh */
#define MC_2_L                           (0x0020)
#define MC_3                             (0x0030)        /* Up/down mode: Timer counts up to TAxCCR0 then down to 0000h */
#define MC_3_L                           (0x0030)
#define MC__STOP                         (0x0000)        /* Stop mode: Timer is halted */
#define MC__UP                           (0x0010)        /* Up mode: Timer counts up to TAxCCR0 */
#define MC__UP_L                         (0x0010)
#define MC__CONTINUOUS                   (0x0020)        /* Continuous mode: Timer counts up to 0FFFFh */
#define MC__CONTINUOUS_L                 (0x0020)
#define MC__UPDOWN                       (0x0030)        /* Up/down mode: Timer counts up to TAxCCR0 then down to 0000h */
#define MC__UPDOWN_L                     (0x0030)
#define ID                               (0x00c0)        /* Input divider */
#define ID_L                             (0x00c0)
#define ID0                              (0x0040)        /* Input divider */
#define ID0_L                            (0x0040)
#define ID1                              (0x0080)        /* Input divider */
#define ID1_L                            (0x0080)
#define ID_0                             (0x0000)        /* /1 */
#define ID_1                             (0x0040)        /* /2 */
#define ID_1_L                           (0x0040)
#define ID_2                             (0x0080)        /* /4 */
#define ID_2_L                           (0x0080)
#define ID_3                             (0x00c0)        /* /8 */
#define ID_3_L                           (0x00c0)
#define ID__1                            (0x0000)        /* /1 */
#define ID__2                            (0x0040)        /* /2 */
#define ID__2_L                          (0x0040)
#define ID__4                            (0x0080)        /* /4 */
#define ID__4_L                          (0x0080)
#define ID__8                            (0x00c0)        /* /8 */
#define ID__8_L                          (0x00c0)
#define TASSEL                           (0x0300)        /* TimerA clock source select */
#define TASSEL_H                         (0x0003)
#define TASSEL0                          (0x0100)        /* TimerA clock source select */
#define TASSEL0_H                        (0x0001)
#define TASSEL1                          (0x0200)        /* TimerA clock source select */
#define TASSEL1_H                        (0x0002)
#define TASSEL_0                         (0x0000)        /* TAxCLK */
#define TASSEL_1                         (0x0100)        /* ACLK */
#define TASSEL_1_H                       (0x0001)
#define TASSEL_2                         (0x0200)        /* SMCLK */
#define TASSEL_2_H                       (0x0002)
#define TASSEL_3                         (0x0300)        /* INCLK */
#define TASSEL_3_H                       (0x0003)
#define TASSEL__TACLK                    (0x0000)        /* TAxCLK */
#define TASSEL__ACLK                     (0x0100)        /* ACLK */
#define TASSEL__ACLK_H                   (0x0001)
#define TASSEL__SMCLK                    (0x0200)        /* SMCLK */
#define TASSEL__SMCLK_H                  (0x0002)
#define TASSEL__INCLK                    (0x0300)        /* INCLK */
#define TASSEL__INCLK_H                  (0x0003)

/* TA0CCTL Control Bits */
#define CCIFG                            (0x0001)        /* Capture/compare interrupt flag */
#define CCIFG_L                          (0x0001)
#define CCIFG_0                          (0x0000)        /* No interrupt pending */
#define CCIFG_1                          (0x0001)        /* Interrupt pending */
#define CCIFG_1_L                        (0x0001)
#define COV                              (0x0002)        /* Capture overflow */
#define COV_L                            (0x0002)
#define COV_0                            (0x0000)        /* No capture overflow occurred */
#define COV_1                            (0x0002)        /* Capture overflow occurred */
#define COV_1_L                          (0x0002)
#define OUT                              (0x0004)        /* Output */
#define OUT_L                            (0x0004)
#define OUT_0                            (0x0000)        /* Output low */
#define OUT_1                            (0x0004)        /* Output high */
#define OUT_1_L                          (0x0004)
#define OUT__LOW                         (0x0000)        /* Output low */
#define OUT__HIGH                        (0x0004)        /* Output high */
#define OUT__HIGH_L                      (0x0004)
#define CCI                              (0x0008)        /* Capture/compare input */
#define CCI_L                            (0x0008)
#define CCIE                             (0x0010)        /* Capture/compare interrupt enable */
#define CCIE_L                           (0x0010)
#define CCIE_0                           (0x0000)        /* Interrupt disabled */
#define CCIE_1                           (0x0010)        /* Interrupt enabled */
#define CCIE_1_L                         (0x0010)
#define OUTMOD                           (0x00e0)        /* Output mode */
#define OUTMOD_L                         (0x00e0)
#define OUTMOD0                          (0x0020)        /* Output mode */
#define OUTMOD0_L                        (0x0020)
#define OUTMOD1                          (0x0040)        /* Output mode */
#define OUTMOD1_L                        (0x0040)
#define OUTMOD2                          (0x0080)        /* Output mode */
#define OUTMOD2_L                        (0x0080)
#define OUTMOD_0                         (0x0000)        /* OUT bit value */
#define OUTMOD_1                         (0x0020)        /* Set */
#define OUTMOD_1_L                       (0x0020)
#define OUTMOD_2                         (0x0040)        /* Toggle/reset */
#define OUTMOD_2_L                       (0x0040)
#define OUTMOD_3                         (0x0060)        /* Set/reset */
#define OUTMOD_3_L                       (0x0060)
#define OUTMOD_4                         (0x0080)        /* Toggle */
#define OUTMOD_4_L                       (0x0080)
#define OUTMOD_5                         (0x00a0)        /* Reset */
#define OUTMOD_5_L                       (0x00a0)
#define OUTMOD_6                         (0x00c0)        /* Toggle/set */
#define OUTMOD_6_L                       (0x00c0)
#define OUTMOD_7                         (0x00e0)        /* Reset/set */
#define OUTMOD_7_L                       (0x00e0)
#define CAP                              (0x0100)        /* Capture mode */
#define CAP_H                            (0x0001)
#define CAP_0                            (0x0000)        /* Compare mode */
#define CAP_1                            (0x0100)        /* Capture mode */
#define CAP_1_H                          (0x0001)
#define CAP__COMPARE                     (0x0000)        /* Compare mode */
#define CAP__CAPTURE                     (0x0100)        /* Capture mode */
#define CAP__CAPTURE_H                   (0x0001)
#define SCCI                             (0x0400)        /* Synchronized capture/compare input */
#define SCCI_H                           (0x0004)
#define SCS                              (0x0800)        /* Synchronize capture source */
#define SCS_H                            (0x0008)
#define SCS_0                            (0x0000)        /* Asynchronous capture */
#define SCS_1                            (0x0800)        /* Synchronous capture */
#define SCS_1_H                          (0x0008)
#define SCS__ASYNC                       (0x0000)        /* Asynchronous capture */
#define SCS__SYNC                        (0x0800)        /* Synchronous capture */
#define SCS__SYNC_H                      (0x0008)
#define CCIS                             (0x3000)        /* Capture/compare input select */
#define CCIS_H                           (0x0030)
#define CCIS0                            (0x1000)        /* Capture/compare input select */
#define CCIS0_H                          (0x0010)
#define CCIS1                            (0x2000)        /* Capture/compare input select */
#define CCIS1_H                          (0x0020)
#define CCIS_0                           (0x0000)        /* CCIxA */
#define CCIS_1                           (0x1000)        /* CCIxB */
#define CCIS_1_H                         (0x0010)
#define CCIS_2                           (0x2000)        /* GND */
#define CCIS_2_H                         (0x0020)
#define CCIS_3                           (0x3000)        /* VCC */
#define CCIS_3_H                         (0x0030)
#define CCIS__CCIA                       (0x0000)        /* CCIxA */
#define CCIS__CCIB                       (0x1000)        /* CCIxB */
#define CCIS__CCIB_H                     (0x0010)
#define CCIS__GND                        (0x2000)        /* GND */
#define CCIS__GND_H                      (0x0020)
#define CCIS__VCC                        (0x3000)        /* VCC */
#define CCIS__VCC_H                      (0x0030)
#define CM                               (0xc000)        /* Capture mode */
#define CM_H                             (0x00c0)
#define CM0                              (0x4000)        /* Capture mode */
#define CM0_H                            (0x0040)
#define CM1                              (0x8000)        /* Capture mode */
#define CM1_H                            (0x0080)
#define CM_0                             (0x0000)        /* No capture */
#define CM_1                             (0x4000)        /* Capture on rising edge */
#define CM_1_H                           (0x0040)
#define CM_2                             (0x8000)        /* Capture on falling edge */
#define CM_2_H                           (0x0080)
#define CM_3                             (0xc000)        /* Capture on both rising and falling edges */
#define CM_3_H                           (0x00c0)
#define CM__NONE                         (0x0000)        /* No capture */
#define CM__RISING                       (0x4000)        /* Capture on rising edge */
#define CM__RISING_H                     (0x0040)
#define CM__FALLING                      (0x8000)        /* Capture on falling edge */
#define CM__FALLING_H                    (0x0080)
#define CM__BOTH                         (0xc000)        /* Capture on both rising and falling edges */
#define CM__BOTH_H                       (0x00c0)

/* TA0EX0 Control Bits */
#define TAIDEX                           (0x0007)        /* Input divider expansion */
#define TAIDEX_L                         (0x0007)
#define TAIDEX0                          (0x0001)        /* Input divider expansion */
#define TAIDEX0_L                        (0x0001)
#define TAIDEX1                          (0x0002)        /* Input divider expansion */
#define TAIDEX1_L                        (0x0002)
#define TAIDEX2                          (0x0004)        /* Input divider expansion */
#define TAIDEX2_L                        (0x0004)
#define TAIDEX_0                         (0x0000)        /* Divide by 1 */
#define TAIDEX_1                         (0x0001)        /* Divide by 2 */
#define TAIDEX_1_L                       (0x0001)
#define TAIDEX_2                         (0x0002)        /* Divide by 3 */
#define TAIDEX_2_L                       (0x0002)
#define TAIDEX_3                         (0x0003)        /* Divide by 4 */
#define TAIDEX_3_L                       (0x0003)
#define TAIDEX_4                         (0x0004)        /* Divide by 5 */
#define TAIDEX_4_L                       (0x0004)
#define TAIDEX_5                         (0x0005)        /* Divide by 6 */
#define TAIDEX_5_L                       (0x0005)
#define TAIDEX_6                         (0x0006)        /* Divide by 7 */
#define TAIDEX_6_L                       (0x0006)
#define TAIDEX_7                         (0x0007)        /* Divide by 8 */
#define TAIDEX_7_L                       (0x0007)
#define TAIDEX__1                        (0x0000)        /* Divide by 1 */
#define TAIDEX__2                        (0x0001)        /* Divide by 2 */
#define TAIDEX__2_L                      (0x0001)
#define TAIDEX__3                        (0x0002)        /* Divide by 3 */
#define TAIDEX__3_L                      (0x0002)
#define TAIDEX__4                        (0x0003)        /* Divide by 4 */
#define TAIDEX__4_L                      (0x0003)
#define TAIDEX__5                        (0x0004)        /* Divide by 5 */
#define TAIDEX__5_L                      (0x0004)
#define TAIDEX__6                        (0x0005)        /* Divide by 6 */
#define TAIDEX__6_L                      (0x0005)
#define TAIDEX__7                        (0x0006)        /* Divide by 7 */
#define TAIDEX__7_L                      (0x0006)
#define TAIDEX__8                        (0x0007)        /* Divide by 8 */
#define TAIDEX__8_L                      (0x0007)

/* TA0IV Control Bits */
#define TAIV                             (0xffff)        /* TimerA interrupt vector value */
#define TAIV_L                           (0x00ff)
#define TAIV_H                           (0x00ff)
#define TAIV0                            (0x0001)        /* TimerA interrupt vector value */
#define TAIV0_L                          (0x0001)
#define TAIV1                            (0x0002)        /* TimerA interrupt vector value */
#define TAIV1_L                          (0x0002)
#define TAIV2                            (0x0004)        /* TimerA interrupt vector value */
#define TAIV2_L                          (0x0004)
#define TAIV3                            (0x0008)        /* TimerA interrupt vector value */
#define TAIV3_L                          (0x0008)
#define TAIV4                            (0x0010)        /* TimerA interrupt vector value */
#define TAIV4_L                          (0x0010)
#define TAIV5                            (0x0020)        /* TimerA interrupt vector value */
#define TAIV5_L                          (0x0020)
#define TAIV6                            (0x0040)        /* TimerA interrupt vector value */
#define TAIV6_L                          (0x0040)
#define TAIV7                            (0x0080)        /* TimerA interrupt vector value */
#define TAIV7_L                          (0x0080)
#define TAIV8                            (0x0100)        /* TimerA interrupt vector value */
#define TAIV8_H                          (0x0001)
#define TAIV9                            (0x0200)        /* TimerA interrupt vector value */
#define TAIV9_H                          (0x0002)
#define TAIV10                           (0x0400)        /* TimerA interrupt vector value */
#define TAIV10_H                         (0x0004)
#define TAIV11                           (0x0800)        /* TimerA interrupt vector value */
#define TAIV11_H                         (0x0008)
#define TAIV12                           (0x1000)        /* TimerA interrupt vector value */
#define TAIV12_H                         (0x0010)
#define TAIV13                           (0x2000)        /* TimerA interrupt vector value */
#define TAIV13_H                         (0x0020)
#define TAIV14                           (0x4000)        /* TimerA interrupt vector value */
#define TAIV14_H                         (0x0040)
#define TAIV15                           (0x8000)        /* TimerA interrupt vector value */
#define TAIV15_H                         (0x0080)
#define TAIV_0                           (0x0000)        /* No interrupt pending */
#define TAIV_2                           (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TAxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TAIV_2_L                         (0x0002)
#define TAIV_4                           (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TAxCCR2 
                                                            CCIFG */
#define TAIV_4_L                         (0x0004)
#define TAIV_6                           (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TAxCCR3 
                                                            CCIFG */
#define TAIV_6_L                         (0x0006)
#define TAIV_8                           (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TAxCCR4 
                                                            CCIFG */
#define TAIV_8_L                         (0x0008)
#define TAIV_10                          (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TAxCCR5 
                                                            CCIFG */
#define TAIV_10_L                        (0x000a)
#define TAIV_12                          (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TAxCCR6 
                                                            CCIFG */
#define TAIV_12_L                        (0x000c)
#define TAIV_14                          (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TAxCTL 
                                                            TAIFG; Interrupt Priority: Lowest */
#define TAIV_14_L                        (0x000e)
#define TAIV__NONE                       (0x0000)        /* No interrupt pending */
#define TAIV__TACCR1                     (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TAxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TAIV__TACCR1_L                   (0x0002)
#define TAIV__TACCR2                     (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TAxCCR2 
                                                            CCIFG */
#define TAIV__TACCR2_L                   (0x0004)
#define TAIV__TACCR3                     (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TAxCCR3 
                                                            CCIFG */
#define TAIV__TACCR3_L                   (0x0006)
#define TAIV__TACCR4                     (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TAxCCR4 
                                                            CCIFG */
#define TAIV__TACCR4_L                   (0x0008)
#define TAIV__TACCR5                     (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TAxCCR5 
                                                            CCIFG */
#define TAIV__TACCR5_L                   (0x000a)
#define TAIV__TACCR6                     (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TAxCCR6 
                                                            CCIFG */
#define TAIV__TACCR6_L                   (0x000c)
#define TAIV__TAIFG                      (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TAxCTL 
                                                            TAIFG; Interrupt Priority: Lowest */
#define TAIV__TAIFG_L                    (0x000e)


/*****************************************************************************
 TA1 Registers
*****************************************************************************/

#define __MSP430_HAS_TA1__ 3                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TAx__
#define __MSP430_HAS_TAx__
#endif
#define __MSP430_BASEADDRESS_TA1__ 0x0380
#define TA1_BASE               __MSP430_BASEADDRESS_TA1__

sfr_w(TA1CTL);                                /* TimerAx Control Register */
sfr_b(TA1CTL_L);
sfr_b(TA1CTL_H);
sfr_w(TA1CCTL0);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA1CCTL0_L);
sfr_b(TA1CCTL0_H);
sfr_w(TA1CCTL1);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA1CCTL1_L);
sfr_b(TA1CCTL1_H);
sfr_w(TA1CCTL2);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA1CCTL2_L);
sfr_b(TA1CCTL2_H);
sfr_w(TA1R);                                  /* TimerA register */
sfr_b(TA1R_L);
sfr_b(TA1R_H);
sfr_w(TA1CCR0);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA1CCR0_L);
sfr_b(TA1CCR0_H);
sfr_w(TA1CCR1);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA1CCR1_L);
sfr_b(TA1CCR1_H);
sfr_w(TA1CCR2);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA1CCR2_L);
sfr_b(TA1CCR2_H);
sfr_w(TA1EX0);                                /* TimerAx Expansion 0 Register */
sfr_b(TA1EX0_L);
sfr_b(TA1EX0_H);
sfr_w(TA1IV);                                 /* TimerAx Interrupt Vector Register */
sfr_b(TA1IV_L);
sfr_b(TA1IV_H);

/* TA1 Register Offsets */
#define OFS_TA1CTL                       (0x0000)
#define OFS_TA1CTL_L                     OFS_TA1CTL
#define OFS_TA1CTL_H                     OFS_TA1CTL+1
#define OFS_TA1CCTL0                     (0x0002)
#define OFS_TA1CCTL0_L                   OFS_TA1CCTL0
#define OFS_TA1CCTL0_H                   OFS_TA1CCTL0+1
#define OFS_TA1CCTL1                     (0x0004)
#define OFS_TA1CCTL1_L                   OFS_TA1CCTL1
#define OFS_TA1CCTL1_H                   OFS_TA1CCTL1+1
#define OFS_TA1CCTL2                     (0x0006)
#define OFS_TA1CCTL2_L                   OFS_TA1CCTL2
#define OFS_TA1CCTL2_H                   OFS_TA1CCTL2+1
#define OFS_TA1R                         (0x0010)
#define OFS_TA1R_L                       OFS_TA1R
#define OFS_TA1R_H                       OFS_TA1R+1
#define OFS_TA1CCR0                      (0x0012)
#define OFS_TA1CCR0_L                    OFS_TA1CCR0
#define OFS_TA1CCR0_H                    OFS_TA1CCR0+1
#define OFS_TA1CCR1                      (0x0014)
#define OFS_TA1CCR1_L                    OFS_TA1CCR1
#define OFS_TA1CCR1_H                    OFS_TA1CCR1+1
#define OFS_TA1CCR2                      (0x0016)
#define OFS_TA1CCR2_L                    OFS_TA1CCR2
#define OFS_TA1CCR2_H                    OFS_TA1CCR2+1
#define OFS_TA1EX0                       (0x0020)
#define OFS_TA1EX0_L                     OFS_TA1EX0
#define OFS_TA1EX0_H                     OFS_TA1EX0+1
#define OFS_TA1IV                        (0x002E)
#define OFS_TA1IV_L                      OFS_TA1IV
#define OFS_TA1IV_H                      OFS_TA1IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 TA2 Registers
*****************************************************************************/

#define __MSP430_HAS_TA2__ 2                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TAx__
#define __MSP430_HAS_TAx__
#endif
#define __MSP430_BASEADDRESS_TA2__ 0x0400
#define TA2_BASE               __MSP430_BASEADDRESS_TA2__

sfr_w(TA2CTL);                                /* TimerAx Control Register */
sfr_b(TA2CTL_L);
sfr_b(TA2CTL_H);
sfr_w(TA2CCTL0);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA2CCTL0_L);
sfr_b(TA2CCTL0_H);
sfr_w(TA2CCTL1);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA2CCTL1_L);
sfr_b(TA2CCTL1_H);
sfr_w(TA2R);                                  /* TimerA register */
sfr_b(TA2R_L);
sfr_b(TA2R_H);
sfr_w(TA2CCR0);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA2CCR0_L);
sfr_b(TA2CCR0_H);
sfr_w(TA2CCR1);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA2CCR1_L);
sfr_b(TA2CCR1_H);
sfr_w(TA2EX0);                                /* TimerAx Expansion 0 Register */
sfr_b(TA2EX0_L);
sfr_b(TA2EX0_H);
sfr_w(TA2IV);                                 /* TimerAx Interrupt Vector Register */
sfr_b(TA2IV_L);
sfr_b(TA2IV_H);

/* TA2 Register Offsets */
#define OFS_TA2CTL                       (0x0000)
#define OFS_TA2CTL_L                     OFS_TA2CTL
#define OFS_TA2CTL_H                     OFS_TA2CTL+1
#define OFS_TA2CCTL0                     (0x0002)
#define OFS_TA2CCTL0_L                   OFS_TA2CCTL0
#define OFS_TA2CCTL0_H                   OFS_TA2CCTL0+1
#define OFS_TA2CCTL1                     (0x0004)
#define OFS_TA2CCTL1_L                   OFS_TA2CCTL1
#define OFS_TA2CCTL1_H                   OFS_TA2CCTL1+1
#define OFS_TA2R                         (0x0010)
#define OFS_TA2R_L                       OFS_TA2R
#define OFS_TA2R_H                       OFS_TA2R+1
#define OFS_TA2CCR0                      (0x0012)
#define OFS_TA2CCR0_L                    OFS_TA2CCR0
#define OFS_TA2CCR0_H                    OFS_TA2CCR0+1
#define OFS_TA2CCR1                      (0x0014)
#define OFS_TA2CCR1_L                    OFS_TA2CCR1
#define OFS_TA2CCR1_H                    OFS_TA2CCR1+1
#define OFS_TA2EX0                       (0x0020)
#define OFS_TA2EX0_L                     OFS_TA2EX0
#define OFS_TA2EX0_H                     OFS_TA2EX0+1
#define OFS_TA2IV                        (0x002E)
#define OFS_TA2IV_L                      OFS_TA2IV
#define OFS_TA2IV_H                      OFS_TA2IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 TA3 Registers
*****************************************************************************/

#define __MSP430_HAS_TA3__ 2                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TAx__
#define __MSP430_HAS_TAx__
#endif
#define __MSP430_BASEADDRESS_TA3__ 0x0440
#define TA3_BASE               __MSP430_BASEADDRESS_TA3__

sfr_w(TA3CTL);                                /* TimerAx Control Register */
sfr_b(TA3CTL_L);
sfr_b(TA3CTL_H);
sfr_w(TA3CCTL0);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA3CCTL0_L);
sfr_b(TA3CCTL0_H);
sfr_w(TA3CCTL1);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA3CCTL1_L);
sfr_b(TA3CCTL1_H);
sfr_w(TA3R);                                  /* TimerA register */
sfr_b(TA3R_L);
sfr_b(TA3R_H);
sfr_w(TA3CCR0);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA3CCR0_L);
sfr_b(TA3CCR0_H);
sfr_w(TA3CCR1);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA3CCR1_L);
sfr_b(TA3CCR1_H);
sfr_w(TA3EX0);                                /* TimerAx Expansion 0 Register */
sfr_b(TA3EX0_L);
sfr_b(TA3EX0_H);
sfr_w(TA3IV);                                 /* TimerAx Interrupt Vector Register */
sfr_b(TA3IV_L);
sfr_b(TA3IV_H);

/* TA3 Register Offsets */
#define OFS_TA3CTL                       (0x0000)
#define OFS_TA3CTL_L                     OFS_TA3CTL
#define OFS_TA3CTL_H                     OFS_TA3CTL+1
#define OFS_TA3CCTL0                     (0x0002)
#define OFS_TA3CCTL0_L                   OFS_TA3CCTL0
#define OFS_TA3CCTL0_H                   OFS_TA3CCTL0+1
#define OFS_TA3CCTL1                     (0x0004)
#define OFS_TA3CCTL1_L                   OFS_TA3CCTL1
#define OFS_TA3CCTL1_H                   OFS_TA3CCTL1+1
#define OFS_TA3R                         (0x0010)
#define OFS_TA3R_L                       OFS_TA3R
#define OFS_TA3R_H                       OFS_TA3R+1
#define OFS_TA3CCR0                      (0x0012)
#define OFS_TA3CCR0_L                    OFS_TA3CCR0
#define OFS_TA3CCR0_H                    OFS_TA3CCR0+1
#define OFS_TA3CCR1                      (0x0014)
#define OFS_TA3CCR1_L                    OFS_TA3CCR1
#define OFS_TA3CCR1_H                    OFS_TA3CCR1+1
#define OFS_TA3EX0                       (0x0020)
#define OFS_TA3EX0_L                     OFS_TA3EX0
#define OFS_TA3EX0_H                     OFS_TA3EX0+1
#define OFS_TA3IV                        (0x002E)
#define OFS_TA3IV_L                      OFS_TA3IV
#define OFS_TA3IV_H                      OFS_TA3IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 TA4 Registers
*****************************************************************************/

#define __MSP430_HAS_TA4__ 2                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TAx__
#define __MSP430_HAS_TAx__
#endif
#define __MSP430_BASEADDRESS_TA4__ 0x07C0
#define TA4_BASE               __MSP430_BASEADDRESS_TA4__

sfr_w(TA4CTL);                                /* TimerAx Control Register */
sfr_b(TA4CTL_L);
sfr_b(TA4CTL_H);
sfr_w(TA4CCTL0);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA4CCTL0_L);
sfr_b(TA4CCTL0_H);
sfr_w(TA4CCTL1);                              /* Timer_A Capture/Compare Control Register */
sfr_b(TA4CCTL1_L);
sfr_b(TA4CCTL1_H);
sfr_w(TA4R);                                  /* TimerA register */
sfr_b(TA4R_L);
sfr_b(TA4R_H);
sfr_w(TA4CCR0);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA4CCR0_L);
sfr_b(TA4CCR0_H);
sfr_w(TA4CCR1);                               /* Timer_A Capture/Compare  Register */
sfr_b(TA4CCR1_L);
sfr_b(TA4CCR1_H);
sfr_w(TA4EX0);                                /* TimerAx Expansion 0 Register */
sfr_b(TA4EX0_L);
sfr_b(TA4EX0_H);
sfr_w(TA4IV);                                 /* TimerAx Interrupt Vector Register */
sfr_b(TA4IV_L);
sfr_b(TA4IV_H);

/* TA4 Register Offsets */
#define OFS_TA4CTL                       (0x0000)
#define OFS_TA4CTL_L                     OFS_TA4CTL
#define OFS_TA4CTL_H                     OFS_TA4CTL+1
#define OFS_TA4CCTL0                     (0x0002)
#define OFS_TA4CCTL0_L                   OFS_TA4CCTL0
#define OFS_TA4CCTL0_H                   OFS_TA4CCTL0+1
#define OFS_TA4CCTL1                     (0x0004)
#define OFS_TA4CCTL1_L                   OFS_TA4CCTL1
#define OFS_TA4CCTL1_H                   OFS_TA4CCTL1+1
#define OFS_TA4R                         (0x0010)
#define OFS_TA4R_L                       OFS_TA4R
#define OFS_TA4R_H                       OFS_TA4R+1
#define OFS_TA4CCR0                      (0x0012)
#define OFS_TA4CCR0_L                    OFS_TA4CCR0
#define OFS_TA4CCR0_H                    OFS_TA4CCR0+1
#define OFS_TA4CCR1                      (0x0014)
#define OFS_TA4CCR1_L                    OFS_TA4CCR1
#define OFS_TA4CCR1_H                    OFS_TA4CCR1+1
#define OFS_TA4EX0                       (0x0020)
#define OFS_TA4EX0_L                     OFS_TA4EX0
#define OFS_TA4EX0_H                     OFS_TA4EX0+1
#define OFS_TA4IV                        (0x002E)
#define OFS_TA4IV_L                      OFS_TA4IV
#define OFS_TA4IV_H                      OFS_TA4IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 TB0 Registers
*****************************************************************************/

#define __MSP430_HAS_TB0__ 7                  /* Definition to show that module is available */
#ifndef __MSP430_HAS_TBx__
#define __MSP430_HAS_TBx__
#endif
#define __MSP430_BASEADDRESS_TB0__ 0x03C0
#define TB0_BASE               __MSP430_BASEADDRESS_TB0__

sfr_w(TB0CTL);                                /* Timer_B Control Register */
sfr_b(TB0CTL_L);
sfr_b(TB0CTL_H);
sfr_w(TB0CCTL0);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL0_L);
sfr_b(TB0CCTL0_H);
sfr_w(TB0CCTL1);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL1_L);
sfr_b(TB0CCTL1_H);
sfr_w(TB0CCTL2);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL2_L);
sfr_b(TB0CCTL2_H);
sfr_w(TB0CCTL3);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL3_L);
sfr_b(TB0CCTL3_H);
sfr_w(TB0CCTL4);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL4_L);
sfr_b(TB0CCTL4_H);
sfr_w(TB0CCTL5);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL5_L);
sfr_b(TB0CCTL5_H);
sfr_w(TB0CCTL6);                              /* Timer_B Capture/Compare Control Register */
sfr_b(TB0CCTL6_L);
sfr_b(TB0CCTL6_H);
sfr_w(TB0R);                                  /* Timer_B count register */
sfr_b(TB0R_L);
sfr_b(TB0R_H);
sfr_w(TB0CCR0);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR0_L);
sfr_b(TB0CCR0_H);
sfr_w(TB0CCR1);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR1_L);
sfr_b(TB0CCR1_H);
sfr_w(TB0CCR2);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR2_L);
sfr_b(TB0CCR2_H);
sfr_w(TB0CCR3);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR3_L);
sfr_b(TB0CCR3_H);
sfr_w(TB0CCR4);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR4_L);
sfr_b(TB0CCR4_H);
sfr_w(TB0CCR5);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR5_L);
sfr_b(TB0CCR5_H);
sfr_w(TB0CCR6);                               /* Timer_B Capture/Compare  Register */
sfr_b(TB0CCR6_L);
sfr_b(TB0CCR6_H);
sfr_w(TB0EX0);                                /* Timer_Bx Expansion Register 0 */
sfr_b(TB0EX0_L);
sfr_b(TB0EX0_H);
sfr_w(TB0IV);                                 /* Timer_Bx Interrupt Vector Register */
sfr_b(TB0IV_L);
sfr_b(TB0IV_H);

/* TB0 Register Offsets */
#define OFS_TB0CTL                       (0x0000)
#define OFS_TB0CTL_L                     OFS_TB0CTL
#define OFS_TB0CTL_H                     OFS_TB0CTL+1
#define OFS_TB0CCTL0                     (0x0002)
#define OFS_TB0CCTL0_L                   OFS_TB0CCTL0
#define OFS_TB0CCTL0_H                   OFS_TB0CCTL0+1
#define OFS_TB0CCTL1                     (0x0004)
#define OFS_TB0CCTL1_L                   OFS_TB0CCTL1
#define OFS_TB0CCTL1_H                   OFS_TB0CCTL1+1
#define OFS_TB0CCTL2                     (0x0006)
#define OFS_TB0CCTL2_L                   OFS_TB0CCTL2
#define OFS_TB0CCTL2_H                   OFS_TB0CCTL2+1
#define OFS_TB0CCTL3                     (0x0008)
#define OFS_TB0CCTL3_L                   OFS_TB0CCTL3
#define OFS_TB0CCTL3_H                   OFS_TB0CCTL3+1
#define OFS_TB0CCTL4                     (0x000A)
#define OFS_TB0CCTL4_L                   OFS_TB0CCTL4
#define OFS_TB0CCTL4_H                   OFS_TB0CCTL4+1
#define OFS_TB0CCTL5                     (0x000C)
#define OFS_TB0CCTL5_L                   OFS_TB0CCTL5
#define OFS_TB0CCTL5_H                   OFS_TB0CCTL5+1
#define OFS_TB0CCTL6                     (0x000E)
#define OFS_TB0CCTL6_L                   OFS_TB0CCTL6
#define OFS_TB0CCTL6_H                   OFS_TB0CCTL6+1
#define OFS_TB0R                         (0x0010)
#define OFS_TB0R_L                       OFS_TB0R
#define OFS_TB0R_H                       OFS_TB0R+1
#define OFS_TB0CCR0                      (0x0012)
#define OFS_TB0CCR0_L                    OFS_TB0CCR0
#define OFS_TB0CCR0_H                    OFS_TB0CCR0+1
#define OFS_TB0CCR1                      (0x0014)
#define OFS_TB0CCR1_L                    OFS_TB0CCR1
#define OFS_TB0CCR1_H                    OFS_TB0CCR1+1
#define OFS_TB0CCR2                      (0x0016)
#define OFS_TB0CCR2_L                    OFS_TB0CCR2
#define OFS_TB0CCR2_H                    OFS_TB0CCR2+1
#define OFS_TB0CCR3                      (0x0018)
#define OFS_TB0CCR3_L                    OFS_TB0CCR3
#define OFS_TB0CCR3_H                    OFS_TB0CCR3+1
#define OFS_TB0CCR4                      (0x001A)
#define OFS_TB0CCR4_L                    OFS_TB0CCR4
#define OFS_TB0CCR4_H                    OFS_TB0CCR4+1
#define OFS_TB0CCR5                      (0x001C)
#define OFS_TB0CCR5_L                    OFS_TB0CCR5
#define OFS_TB0CCR5_H                    OFS_TB0CCR5+1
#define OFS_TB0CCR6                      (0x001E)
#define OFS_TB0CCR6_L                    OFS_TB0CCR6
#define OFS_TB0CCR6_H                    OFS_TB0CCR6+1
#define OFS_TB0EX0                       (0x0020)
#define OFS_TB0EX0_L                     OFS_TB0EX0
#define OFS_TB0EX0_H                     OFS_TB0EX0+1
#define OFS_TB0IV                        (0x002E)
#define OFS_TB0IV_L                      OFS_TB0IV
#define OFS_TB0IV_H                      OFS_TB0IV+1

/* TB0 Control Bits */

/* TB0CTL Control Bits */
#define TBIFG                            (0x0001)        /* TimerB interrupt flag */
#define TBIFG_L                          (0x0001)
#define TBIFG_0                          (0x0000)        /* No interrupt pending */
#define TBIFG_1                          (0x0001)        /* Interrupt pending */
#define TBIFG_1_L                        (0x0001)
#define TBIE                             (0x0002)        /* TimerB interrupt enable */
#define TBIE_L                           (0x0002)
#define TBIE_0                           (0x0000)        /* Interrupt disabled */
#define TBIE_1                           (0x0002)        /* Interrupt enabled */
#define TBIE_1_L                         (0x0002)
#define TBCLR                            (0x0004)        /* TimerB clear */
#define TBCLR_L                          (0x0004)
#define TBSSEL                           (0x0300)        /* TimerB clock source select */
#define TBSSEL_H                         (0x0003)
#define TBSSEL0                          (0x0100)        /* TimerB clock source select */
#define TBSSEL0_H                        (0x0001)
#define TBSSEL1                          (0x0200)        /* TimerB clock source select */
#define TBSSEL1_H                        (0x0002)
#define TBSSEL_0                         (0x0000)        /* TBxCLK */
#define TBSSEL_1                         (0x0100)        /* ACLK */
#define TBSSEL_1_H                       (0x0001)
#define TBSSEL_2                         (0x0200)        /* SMCLK */
#define TBSSEL_2_H                       (0x0002)
#define TBSSEL_3                         (0x0300)        /* INCLK */
#define TBSSEL_3_H                       (0x0003)
#define TBSSEL__TBCLK                    (0x0000)        /* TBxCLK */
#define TBSSEL__ACLK                     (0x0100)        /* ACLK */
#define TBSSEL__ACLK_H                   (0x0001)
#define TBSSEL__SMCLK                    (0x0200)        /* SMCLK */
#define TBSSEL__SMCLK_H                  (0x0002)
#define TBSSEL__INCLK                    (0x0300)        /* INCLK */
#define TBSSEL__INCLK_H                  (0x0003)
#define CNTL                             (0x1800)        /* Counter length */
#define CNTL_H                           (0x0018)
#define CNTL0                            (0x0800)        /* Counter length */
#define CNTL0_H                          (0x0008)
#define CNTL1                            (0x1000)        /* Counter length */
#define CNTL1_H                          (0x0010)
#define CNTL_0                           (0x0000)        /* 16-bit, TBxR(max) = 0FFFFh */
#define CNTL_1                           (0x0800)        /* 12-bit, TBxR(max) = 0FFFh */
#define CNTL_1_H                         (0x0008)
#define CNTL_2                           (0x1000)        /* 10-bit, TBxR(max) = 03FFh */
#define CNTL_2_H                         (0x0010)
#define CNTL_3                           (0x1800)        /* 8-bit, TBxR(max) = 0FFh */
#define CNTL_3_H                         (0x0018)
#define CNTL__16                         (0x0000)        /* 16-bit, TBxR(max) = 0FFFFh */
#define CNTL__12                         (0x0800)        /* 12-bit, TBxR(max) = 0FFFh */
#define CNTL__12_H                       (0x0008)
#define CNTL__10                         (0x1000)        /* 10-bit, TBxR(max) = 03FFh */
#define CNTL__10_H                       (0x0010)
#define CNTL__8                          (0x1800)        /* 8-bit, TBxR(max) = 0FFh */
#define CNTL__8_H                        (0x0018)
#define TBCLGRP                          (0x6000)        /* TBxCLn group */
#define TBCLGRP_H                        (0x0060)
#define TBCLGRP0                         (0x2000)        /* TBxCLn group */
#define TBCLGRP0_H                       (0x0020)
#define TBCLGRP1                         (0x4000)        /* TBxCLn group */
#define TBCLGRP1_H                       (0x0040)
#define TBCLGRP_0                        (0x0000)        /* Each TBxCLn latch loads independently */
#define TBCLGRP_1                        (0x2000)        /* TBxCL1+TBxCL2 (TBxCCR1 CLLD bits control the update); 
                                                            TBxCL3+TBxCL4 (TBxCCR3 CLLD bits control the update); 
                                                            TBxCL5+TBxCL6 (TBxCCR5 CLLD bits control the update); TBxCL0 
                                                            independent */
#define TBCLGRP_1_H                      (0x0020)
#define TBCLGRP_2                        (0x4000)        /* TBxCL1+TBxCL2+TBxCL3 (TBxCCR1 CLLD bits control the update); 
                                                            TBxCL4+TBxCL5+TBxCL6 (TBxCCR4 CLLD bits control the update); 
                                                            TBxCL0 independent */
#define TBCLGRP_2_H                      (0x0040)
#define TBCLGRP_3                        (0x6000)        /* TBxCL0+TBxCL1+TBxCL2+TBxCL3+TBxCL4+TBxCL5+TBxCL6 (TBxCCR1 CLLD
                                                            bits control the update) */
#define TBCLGRP_3_H                      (0x0060)

/* TB0CCTL Control Bits */
#define CLLD                             (0x0600)        /* Compare latch load */
#define CLLD_H                           (0x0006)
#define CLLD0                            (0x0200)        /* Compare latch load */
#define CLLD0_H                          (0x0002)
#define CLLD1                            (0x0400)        /* Compare latch load */
#define CLLD1_H                          (0x0004)
#define CLLD_0                           (0x0000)        /* TBxCLn loads on write to TBxCCRn */
#define CLLD_1                           (0x0200)        /* TBxCLn loads when TBxR counts to 0 */
#define CLLD_1_H                         (0x0002)
#define CLLD_2                           (0x0400)        /* TBxCLn loads when TBxR counts to 0 (up or continuous mode). 
                                                            TBxCLn loads when TBxR counts to TBxCL0 or to 0 (up/down 
                                                            mode). */
#define CLLD_2_H                         (0x0004)
#define CLLD_3                           (0x0600)        /* TBxCLn loads when TBxR counts to TBxCLn */
#define CLLD_3_H                         (0x0006)

/* TB0EX0 Control Bits */
#define TBIDEX                           (0x0007)        /* Input divider expansion */
#define TBIDEX_L                         (0x0007)
#define TBIDEX0                          (0x0001)        /* Input divider expansion */
#define TBIDEX0_L                        (0x0001)
#define TBIDEX1                          (0x0002)        /* Input divider expansion */
#define TBIDEX1_L                        (0x0002)
#define TBIDEX2                          (0x0004)        /* Input divider expansion */
#define TBIDEX2_L                        (0x0004)
#define TBIDEX_0                         (0x0000)        /* Divide by 1 */
#define TBIDEX_1                         (0x0001)        /* Divide by 2 */
#define TBIDEX_1_L                       (0x0001)
#define TBIDEX_2                         (0x0002)        /* Divide by 3 */
#define TBIDEX_2_L                       (0x0002)
#define TBIDEX_3                         (0x0003)        /* Divide by 4 */
#define TBIDEX_3_L                       (0x0003)
#define TBIDEX_4                         (0x0004)        /* Divide by 5 */
#define TBIDEX_4_L                       (0x0004)
#define TBIDEX_5                         (0x0005)        /* Divide by 6 */
#define TBIDEX_5_L                       (0x0005)
#define TBIDEX_6                         (0x0006)        /* Divide by 7 */
#define TBIDEX_6_L                       (0x0006)
#define TBIDEX_7                         (0x0007)        /* Divide by 8 */
#define TBIDEX_7_L                       (0x0007)
#define TBIDEX__1                        (0x0000)        /* Divide by 1 */
#define TBIDEX__2                        (0x0001)        /* Divide by 2 */
#define TBIDEX__2_L                      (0x0001)
#define TBIDEX__3                        (0x0002)        /* Divide by 3 */
#define TBIDEX__3_L                      (0x0002)
#define TBIDEX__4                        (0x0003)        /* Divide by 4 */
#define TBIDEX__4_L                      (0x0003)
#define TBIDEX__5                        (0x0004)        /* Divide by 5 */
#define TBIDEX__5_L                      (0x0004)
#define TBIDEX__6                        (0x0005)        /* Divide by 6 */
#define TBIDEX__6_L                      (0x0005)
#define TBIDEX__7                        (0x0006)        /* Divide by 7 */
#define TBIDEX__7_L                      (0x0006)
#define TBIDEX__8                        (0x0007)        /* Divide by 8 */
#define TBIDEX__8_L                      (0x0007)

/* TB0IV Control Bits */
#define TBIV                             (0xffff)        /* Timer_B interrupt vector value */
#define TBIV_L                           (0x00ff)
#define TBIV_H                           (0x00ff)
#define TBIV0                            (0x0001)        /* Timer_B interrupt vector value */
#define TBIV0_L                          (0x0001)
#define TBIV1                            (0x0002)        /* Timer_B interrupt vector value */
#define TBIV1_L                          (0x0002)
#define TBIV2                            (0x0004)        /* Timer_B interrupt vector value */
#define TBIV2_L                          (0x0004)
#define TBIV3                            (0x0008)        /* Timer_B interrupt vector value */
#define TBIV3_L                          (0x0008)
#define TBIV4                            (0x0010)        /* Timer_B interrupt vector value */
#define TBIV4_L                          (0x0010)
#define TBIV5                            (0x0020)        /* Timer_B interrupt vector value */
#define TBIV5_L                          (0x0020)
#define TBIV6                            (0x0040)        /* Timer_B interrupt vector value */
#define TBIV6_L                          (0x0040)
#define TBIV7                            (0x0080)        /* Timer_B interrupt vector value */
#define TBIV7_L                          (0x0080)
#define TBIV8                            (0x0100)        /* Timer_B interrupt vector value */
#define TBIV8_H                          (0x0001)
#define TBIV9                            (0x0200)        /* Timer_B interrupt vector value */
#define TBIV9_H                          (0x0002)
#define TBIV10                           (0x0400)        /* Timer_B interrupt vector value */
#define TBIV10_H                         (0x0004)
#define TBIV11                           (0x0800)        /* Timer_B interrupt vector value */
#define TBIV11_H                         (0x0008)
#define TBIV12                           (0x1000)        /* Timer_B interrupt vector value */
#define TBIV12_H                         (0x0010)
#define TBIV13                           (0x2000)        /* Timer_B interrupt vector value */
#define TBIV13_H                         (0x0020)
#define TBIV14                           (0x4000)        /* Timer_B interrupt vector value */
#define TBIV14_H                         (0x0040)
#define TBIV15                           (0x8000)        /* Timer_B interrupt vector value */
#define TBIV15_H                         (0x0080)
#define TBIV_0                           (0x0000)        /* No interrupt pending */
#define TBIV_2                           (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TBxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TBIV_2_L                         (0x0002)
#define TBIV_4                           (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TBxCCR2 
                                                            CCIFG */
#define TBIV_4_L                         (0x0004)
#define TBIV_6                           (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TBxCCR3 
                                                            CCIFG */
#define TBIV_6_L                         (0x0006)
#define TBIV_8                           (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TBxCCR4 
                                                            CCIFG */
#define TBIV_8_L                         (0x0008)
#define TBIV_10                          (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TBxCCR5 
                                                            CCIFG */
#define TBIV_10_L                        (0x000a)
#define TBIV_12                          (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TBxCCR6 
                                                            CCIFG */
#define TBIV_12_L                        (0x000c)
#define TBIV_14                          (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TBxCTL 
                                                            TBIFG; Interrupt Priority: Lowest */
#define TBIV_14_L                        (0x000e)
#define TBIV__NONE                       (0x0000)        /* No interrupt pending */
#define TBIV__TBCCR1                     (0x0002)        /* Interrupt Source: Capture/compare 1; Interrupt Flag: TBxCCR1 
                                                            CCIFG; Interrupt Priority: Highest */
#define TBIV__TBCCR1_L                   (0x0002)
#define TBIV__TBCCR2                     (0x0004)        /* Interrupt Source: Capture/compare 2; Interrupt Flag: TBxCCR2 
                                                            CCIFG */
#define TBIV__TBCCR2_L                   (0x0004)
#define TBIV__TBCCR3                     (0x0006)        /* Interrupt Source: Capture/compare 3; Interrupt Flag: TBxCCR3 
                                                            CCIFG */
#define TBIV__TBCCR3_L                   (0x0006)
#define TBIV__TBCCR4                     (0x0008)        /* Interrupt Source: Capture/compare 4; Interrupt Flag: TBxCCR4 
                                                            CCIFG */
#define TBIV__TBCCR4_L                   (0x0008)
#define TBIV__TBCCR5                     (0x000a)        /* Interrupt Source: Capture/compare 5; Interrupt Flag: TBxCCR5 
                                                            CCIFG */
#define TBIV__TBCCR5_L                   (0x000a)
#define TBIV__TBCCR6                     (0x000c)        /* Interrupt Source: Capture/compare 6; Interrupt Flag: TBxCCR6 
                                                            CCIFG */
#define TBIV__TBCCR6_L                   (0x000c)
#define TBIV__TBIFG                      (0x000e)        /* Interrupt Source: Timer overflow; Interrupt Flag: TBxCTL 
                                                            TBIFG; Interrupt Priority: Lowest */
#define TBIV__TBIFG_L                    (0x000e)


/*****************************************************************************
 UUPS Registers
*****************************************************************************/

#define __MSP430_HAS_UUPS__                   /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_UUPS__ 0x0EC0
#define UUPS_BASE              __MSP430_BASEADDRESS_UUPS__

sfr_w(UUPSIIDX);                              /* Interrupt Index Register */
sfr_b(UUPSIIDX_L);
sfr_b(UUPSIIDX_H);
sfr_w(UUPSMIS);                               /* Masked Interrupt Status Register */
sfr_b(UUPSMIS_L);
sfr_b(UUPSMIS_H);
sfr_w(UUPSRIS);                               /* Raw Interrupt Status Register */
sfr_b(UUPSRIS_L);
sfr_b(UUPSRIS_H);
sfr_w(UUPSIMSC);                              /* Interrupt Mask Register */
sfr_b(UUPSIMSC_L);
sfr_b(UUPSIMSC_H);
sfr_w(UUPSICR);                               /* Interrupt Clear Register. */
sfr_b(UUPSICR_L);
sfr_b(UUPSICR_H);
sfr_w(UUPSISR);                               /* Interrupt Flag Set Register. */
sfr_b(UUPSISR_L);
sfr_b(UUPSISR_H);
sfr_w(UUPSDESCLO);                            /* UUPS Descriptor Register L. */
sfr_b(UUPSDESCLO_L);
sfr_b(UUPSDESCLO_H);
sfr_w(UUPSDESCHI);                            /* UUPS Descriptor Register H. */
sfr_b(UUPSDESCHI_L);
sfr_b(UUPSDESCHI_H);
sfr_w(UUPSCTL);                               /* UUPS Control */
sfr_b(UUPSCTL_L);
sfr_b(UUPSCTL_H);

/* UUPS Register Offsets */
#define OFS_UUPSIIDX                     (0x0000)
#define OFS_UUPSIIDX_L                   OFS_UUPSIIDX
#define OFS_UUPSIIDX_H                   OFS_UUPSIIDX+1
#define OFS_UUPSMIS                      (0x0002)
#define OFS_UUPSMIS_L                    OFS_UUPSMIS
#define OFS_UUPSMIS_H                    OFS_UUPSMIS+1
#define OFS_UUPSRIS                      (0x0004)
#define OFS_UUPSRIS_L                    OFS_UUPSRIS
#define OFS_UUPSRIS_H                    OFS_UUPSRIS+1
#define OFS_UUPSIMSC                     (0x0006)
#define OFS_UUPSIMSC_L                   OFS_UUPSIMSC
#define OFS_UUPSIMSC_H                   OFS_UUPSIMSC+1
#define OFS_UUPSICR                      (0x0008)
#define OFS_UUPSICR_L                    OFS_UUPSICR
#define OFS_UUPSICR_H                    OFS_UUPSICR+1
#define OFS_UUPSISR                      (0x000A)
#define OFS_UUPSISR_L                    OFS_UUPSISR
#define OFS_UUPSISR_H                    OFS_UUPSISR+1
#define OFS_UUPSDESCLO                   (0x000C)
#define OFS_UUPSDESCLO_L                 OFS_UUPSDESCLO
#define OFS_UUPSDESCLO_H                 OFS_UUPSDESCLO+1
#define OFS_UUPSDESCHI                   (0x000E)
#define OFS_UUPSDESCHI_L                 OFS_UUPSDESCHI
#define OFS_UUPSDESCHI_H                 OFS_UUPSDESCHI+1
#define OFS_UUPSCTL                      (0x0010)
#define OFS_UUPSCTL_L                    OFS_UUPSCTL
#define OFS_UUPSCTL_H                    OFS_UUPSCTL+1

/* UUPS Control Bits */

/* UUPSMIS Control Bits */
#define PTMOUT                           (0x0001)        /* UUPS Power Up Time Out Masked Interrupt Status bit. */
#define PTMOUT_L                         (0x0001)
#define PTMOUT_0                         (0x0000)        /* No interrupt pending */
#define PTMOUT_1                         (0x0001)        /* Interrupt pending */
#define PTMOUT_1_L                       (0x0001)
#define PREQIG                           (0x0002)        /* UUPS Power Request Ignore Masked Interrupt Status bit. */
#define PREQIG_L                         (0x0002)
#define PREQIG_0                         (0x0000)        /* No interrupt pending */
#define PREQIG_1                         (0x0002)        /* Interrupt pending */
#define PREQIG_1_L                       (0x0002)
#define STPBYDB                          (0x0004)        /* USS has been interrupted by debug mode Masked Interrupt Status
                                                            bit. */
#define STPBYDB_L                        (0x0004)
#define STPBYDB_0                        (0x0000)        /* No interrupt pending */
#define STPBYDB_1                        (0x0004)        /* Interrupt pending */
#define STPBYDB_1_L                      (0x0004)

/* UUPSCTL Control Bits */
#define USSPWRUP                         (0x0100)        /* Turn on USS Power and  PLL */
#define USSPWRUP_H                       (0x0001)
#define USSPWRUP_0                       (0x0000)        /* No action */
#define USSPWRUP_1                       (0x0100)        /* Power up the USS module and generate the PSQ_START to the ASQ 
                                                            if CTL.ASQEN = 1. Note: This bit becomes invalid in debug 
                                                            mode. */
#define USSPWRUP_1_H                     (0x0001)
#define ASQEN                            (0x0800)        /* Power Ready Output Event Select */
#define ASQEN_H                          (0x0008)
#define LDORDY                           (0x0001)        /* USS LDO is ready */
#define LDORDY_L                         (0x0001)
#define LDORDY_0                         (0x0000)        /* USS LDO is powered down or in transition mode */
#define LDORDY_1                         (0x0001)        /* USS LDO is powered on */
#define LDORDY_1_L                       (0x0001)
#define LBHDEL                           (0x3000)        /* Reserved_2 */
#define LBHDEL_H                         (0x0030)
#define LBHDEL0                          (0x1000)        /* Reserved_2 */
#define LBHDEL0_H                        (0x0010)
#define LBHDEL1                          (0x2000)        /* Reserved_2 */
#define LBHDEL1_H                        (0x0020)
#define LBHDEL_0                         (0x0000)        /* no additional delay */
#define LBHDEL_1                         (0x1000)        /* additional hold off delay of ~100us (512 REFCLKs) */
#define LBHDEL_1_H                       (0x0010)
#define LBHDEL_2                         (0x2000)        /* additional hold off delay of ~200us (1024 REFCLKs) */
#define LBHDEL_2_H                       (0x0020)
#define LBHDEL_3                         (0x3000)        /* additional hold off delay of ~300us (1536 REFCLKs) */
#define LBHDEL_3_H                       (0x0030)
#define USSPWRDN                         (0x4000)        /* USS Power Down */
#define USSPWRDN_H                       (0x0040)
#define USSPWRDN_0                       (0x0000)        /* No action */
#define USSPWRDN_1                       (0x4000)        /* Stop the current measurement and power off the USS module. */
#define USSPWRDN_1_H                     (0x0040)
#define USSPWRUPSEL                      (0x0600)        /* USS Power Up trigger source select. */
#define USSPWRUPSEL_H                    (0x0006)
#define USSPWRUPSEL0                     (0x0200)        /* USS Power Up trigger source select. */
#define USSPWRUPSEL0_H                   (0x0002)
#define USSPWRUPSEL1                     (0x0400)        /* USS Power Up trigger source select. */
#define USSPWRUPSEL1_H                   (0x0004)
#define USSPWRUPSEL_0                    (0x0000)        /* CTL.USSPWRUP bit */
#define USSPWRUPSEL_1                    (0x0200)        /* Ext. trigger (see the device specific datasheet) */
#define USSPWRUPSEL_1_H                  (0x0002)
#define USSPWRUPSEL_2                    (0x0400)        /* Ext. trigger (see the device-specific data sheet) */
#define USSPWRUPSEL_2_H                  (0x0004)
#define USSPWRUPSEL_3                    (0x0600)        /* Ext. trigger (see the device-specific data sheet) */
#define USSPWRUPSEL_3_H                  (0x0006)
#define USSSTOP                          (0x8000)        /* USS Measurement Stop */
#define USSSTOP_H                        (0x0080)
#define USSSTOP_0                        (0x0000)        /* No action */
#define USSSTOP_1                        (0x8000)        /* Stop the current measurement. */
#define USSSTOP_1_H                      (0x0080)
#define UPSTATE                          (0x0006)        /* USS Power Up trigger source select. */
#define UPSTATE_L                        (0x0006)
#define UPSTATE0                         (0x0002)        /* USS Power Up trigger source select. */
#define UPSTATE0_L                       (0x0002)
#define UPSTATE1                         (0x0004)        /* USS Power Up trigger source select. */
#define UPSTATE1_L                       (0x0004)
#define UPSTATE_0                        (0x0000)        /* USS is in OFF mode */
#define UPSTATE_1                        (0x0002)        /* USS is in STANDBY mode */
#define UPSTATE_1_L                      (0x0002)
#define UPSTATE_2                        (0x0004)        /* USS power mode is in transition. */
#define UPSTATE_2_L                      (0x0004)
#define UPSTATE_3                        (0x0006)        /* USS is in READY mode */
#define UPSTATE_3_L                      (0x0006)
#define USS_BUSY                         (0x0008)        /* USS Busy bit. */
#define USS_BUSY_L                       (0x0008)
#define USS_BUSY_0                       (0x0000)        /* The USS module is not busy. */
#define USS_BUSY_1                       (0x0008)        /* The USS module is busy. */
#define USS_BUSY_1_L                     (0x0008)
#define USSSWRST                         (0x0080)        /* */
#define USSSWRST_L                       (0x0080)
#define USSSWRST_0                       (0x0000)        /* Disabled. USS (and sub modules) reset released for operation */
#define USSSWRST_1                       (0x0080)        /* Enabled. USS (and sub modules) logic held in reset state */
#define USSSWRST_1_L                     (0x0080)


/*****************************************************************************
 WDT_A Registers
*****************************************************************************/

#define __MSP430_HAS_WDT_A__                  /* Definition to show that module is available */
#define __MSP430_BASEADDRESS_WDT_A__ 0x015C
#define WDT_A_BASE             __MSP430_BASEADDRESS_WDT_A__

sfr_w(WDTCTL);                                /* Watchdog Timer Control Register */
sfr_b(WDTCTL_L);
sfr_b(WDTCTL_H);

/* WDT_A Register Offsets */
#define OFS_WDTCTL                       (0x0000)
#define OFS_WDTCTL_L                     OFS_WDTCTL
#define OFS_WDTCTL_H                     OFS_WDTCTL+1

/* WDT_A Control Bits */

/* WDTCTL Control Bits */
#define WDTIS                            (0x0007)        /* Watchdog timer interval select */
#define WDTIS_L                          (0x0007)
#define WDTIS0                           (0x0001)        /* Watchdog timer interval select */
#define WDTIS0_L                         (0x0001)
#define WDTIS1                           (0x0002)        /* Watchdog timer interval select */
#define WDTIS1_L                         (0x0002)
#define WDTIS2                           (0x0004)        /* Watchdog timer interval select */
#define WDTIS2_L                         (0x0004)
#define WDTIS_0                          (0x0000)        /* Watchdog clock source / (2^(31)) (18:12:16 at 32.768 kHz) */
#define WDTIS_1                          (0x0001)        /* Watchdog clock source /(2^(27)) (01:08:16 at 32.768 kHz) */
#define WDTIS_1_L                        (0x0001)
#define WDTIS_2                          (0x0002)        /* Watchdog clock source /(2^(23)) (00:04:16 at 32.768 kHz) */
#define WDTIS_2_L                        (0x0002)
#define WDTIS_3                          (0x0003)        /* Watchdog clock source /(2^(19)) (00:00:16 at 32.768 kHz) */
#define WDTIS_3_L                        (0x0003)
#define WDTIS_4                          (0x0004)        /* Watchdog clock source /(2^(15)) (1 s at 32.768 kHz) */
#define WDTIS_4_L                        (0x0004)
#define WDTIS_5                          (0x0005)        /* Watchdog clock source / (2^(13)) (250 ms at 32.768 kHz) */
#define WDTIS_5_L                        (0x0005)
#define WDTIS_6                          (0x0006)        /* Watchdog clock source / (2^(9)) (15.625 ms at 32.768 kHz) */
#define WDTIS_6_L                        (0x0006)
#define WDTIS_7                          (0x0007)        /* Watchdog clock source / (2^(6)) (1.95 ms at 32.768 kHz) */
#define WDTIS_7_L                        (0x0007)
#define WDTIS__2G                        (0x0000)        /* Watchdog clock source / (2^(31)) (18:12:16 at 32.768 kHz) */
#define WDTIS__128M                      (0x0001)        /* Watchdog clock source /(2^(27)) (01:08:16 at 32.768 kHz) */
#define WDTIS__128M_L                    (0x0001)
#define WDTIS__8192K                     (0x0002)        /* Watchdog clock source /(2^(23)) (00:04:16 at 32.768 kHz) */
#define WDTIS__8192K_L                   (0x0002)
#define WDTIS__512K                      (0x0003)        /* Watchdog clock source /(2^(19)) (00:00:16 at 32.768 kHz) */
#define WDTIS__512K_L                    (0x0003)
#define WDTIS__32K                       (0x0004)        /* Watchdog clock source /(2^(15)) (1 s at 32.768 kHz) */
#define WDTIS__32K_L                     (0x0004)
#define WDTIS__8192                      (0x0005)        /* Watchdog clock source / (2^(13)) (250 ms at 32.768 kHz) */
#define WDTIS__8192_L                    (0x0005)
#define WDTIS__512                       (0x0006)        /* Watchdog clock source / (2^(9)) (15.625 ms at 32.768 kHz) */
#define WDTIS__512_L                     (0x0006)
#define WDTIS__64                        (0x0007)        /* Watchdog clock source / (2^(6)) (1.95 ms at 32.768 kHz) */
#define WDTIS__64_L                      (0x0007)
#define WDTCNTCL                         (0x0008)        /* Watchdog timer counter clear */
#define WDTCNTCL_L                       (0x0008)
#define WDTCNTCL_0                       (0x0000)        /* No action */
#define WDTCNTCL_1                       (0x0008)        /* WDTCNT = 0000h */
#define WDTCNTCL_1_L                     (0x0008)
#define WDTTMSEL                         (0x0010)        /* Watchdog timer mode select */
#define WDTTMSEL_L                       (0x0010)
#define WDTTMSEL_0                       (0x0000)        /* Watchdog mode */
#define WDTTMSEL_1                       (0x0010)        /* Interval timer mode */
#define WDTTMSEL_1_L                     (0x0010)
#define WDTSSEL                          (0x0060)        /* Watchdog timer clock source select */
#define WDTSSEL_L                        (0x0060)
#define WDTSSEL0                         (0x0020)        /* Watchdog timer clock source select */
#define WDTSSEL0_L                       (0x0020)
#define WDTSSEL1                         (0x0040)        /* Watchdog timer clock source select */
#define WDTSSEL1_L                       (0x0040)
#define WDTSSEL_0                        (0x0000)        /* SMCLK */
#define WDTSSEL_1                        (0x0020)        /* ACLK */
#define WDTSSEL_1_L                      (0x0020)
#define WDTSSEL_2                        (0x0040)        /* VLOCLK */
#define WDTSSEL_2_L                      (0x0040)
#define WDTSSEL_3                        (0x0060)        /* BCLK */
#define WDTSSEL_3_L                      (0x0060)
#define WDTSSEL__SMCLK                   (0x0000)        /* SMCLK */
#define WDTSSEL__ACLK                    (0x0020)        /* ACLK */
#define WDTSSEL__ACLK_L                  (0x0020)
#define WDTSSEL__VLOCLK                  (0x0040)        /* VLOCLK */
#define WDTSSEL__VLOCLK_L                (0x0040)
#define WDTSSEL__BCLK                    (0x0060)        /* BCLK */
#define WDTSSEL__BCLK_L                  (0x0060)
#define WDTHOLD                          (0x0080)        /* Watchdog timer hold */
#define WDTHOLD_L                        (0x0080)
#define WDTHOLD_0                        (0x0000)        /* Watchdog timer is not stopped */
#define WDTHOLD_1                        (0x0080)        /* Watchdog timer is stopped */
#define WDTHOLD_1_L                      (0x0080)
#define WDTHOLD__UNHOLD                  (0x0000)        /* Watchdog timer is not stopped */
#define WDTHOLD__HOLD                    (0x0080)        /* Watchdog timer is stopped */
#define WDTHOLD__HOLD_L                  (0x0080)
#define WDTPW                            (0x5a00)        /* Watchdog timer password */
#define WDTPW_H                          (0x005a)
#define WDTPW0                           (0x0100)        /* Watchdog timer password */
#define WDTPW0_H                         (0x0001)
#define WDTPW1                           (0x0200)        /* Watchdog timer password */
#define WDTPW1_H                         (0x0002)
#define WDTPW2                           (0x0400)        /* Watchdog timer password */
#define WDTPW2_H                         (0x0004)
#define WDTPW3                           (0x0800)        /* Watchdog timer password */
#define WDTPW3_H                         (0x0008)
#define WDTPW4                           (0x1000)        /* Watchdog timer password */
#define WDTPW4_H                         (0x0010)
#define WDTPW5                           (0x2000)        /* Watchdog timer password */
#define WDTPW5_H                         (0x0020)
#define WDTPW6                           (0x4000)        /* Watchdog timer password */
#define WDTPW6_H                         (0x0040)
#define WDTPW7                           (0x8000)        /* Watchdog timer password */
#define WDTPW7_H                         (0x0080)


/*****************************************************************************
 eUSCI_A0 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_A0__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Ax__
#define __MSP430_HAS_EUSCI_Ax__
#endif
#define __MSP430_BASEADDRESS_EUSCI_A0__ 0x05C0
#define EUSCI_A0_BASE          __MSP430_BASEADDRESS_EUSCI_A0__

sfr_w(UCA0CTLW0);                             /* eUSCI_Ax Control Word Register 0 */
sfr_b(UCA0CTLW0_L);
sfr_b(UCA0CTLW0_H);
sfr_w(UCA0CTLW1);                             /* eUSCI_Ax Control Word Register 1 */
sfr_b(UCA0CTLW1_L);
sfr_b(UCA0CTLW1_H);
sfr_w(UCA0BRW);                               /* eUSCI_Ax Baud Rate Control Word Register */
sfr_b(UCA0BRW_L);
sfr_b(UCA0BRW_H);
sfr_w(UCA0MCTLW);                             /* eUSCI_Ax Modulation Control Word Register */
sfr_b(UCA0MCTLW_L);
sfr_b(UCA0MCTLW_H);
sfr_w(UCA0STATW);                             /* eUSCI_Ax Status Register */
sfr_b(UCA0STATW_L);
sfr_b(UCA0STATW_H);
sfr_w(UCA0RXBUF);                             /* eUSCI_Ax Receive Buffer Register */
sfr_b(UCA0RXBUF_L);
sfr_b(UCA0RXBUF_H);
sfr_w(UCA0TXBUF);                             /* eUSCI_Ax Transmit Buffer Register */
sfr_b(UCA0TXBUF_L);
sfr_b(UCA0TXBUF_H);
sfr_w(UCA0ABCTL);                             /* eUSCI_Ax Auto Baud Rate Control Register */
sfr_b(UCA0ABCTL_L);
sfr_b(UCA0ABCTL_H);
sfr_w(UCA0IRCTL);                             /* eUSCI_Ax IrDA Control Word Register */
sfr_b(UCA0IRCTL_L);
sfr_b(UCA0IRCTL_H);
sfr_w(UCA0IE);                                /* eUSCI_Ax Interrupt Enable Register */
sfr_b(UCA0IE_L);
sfr_b(UCA0IE_H);
sfr_w(UCA0IFG);                               /* eUSCI_Ax Interrupt Flag Register */
sfr_b(UCA0IFG_L);
sfr_b(UCA0IFG_H);
sfr_w(UCA0IV);                                /* eUSCI_Ax Interrupt Vector Register */
sfr_b(UCA0IV_L);
sfr_b(UCA0IV_H);

/* eUSCI_A0 Register Offsets */
#define OFS_UCA0CTLW0                    (0x0000)
#define OFS_UCA0CTLW0_L                  OFS_UCA0CTLW0
#define OFS_UCA0CTLW0_H                  OFS_UCA0CTLW0+1
#define OFS_UCA0CTLW1                    (0x0002)
#define OFS_UCA0CTLW1_L                  OFS_UCA0CTLW1
#define OFS_UCA0CTLW1_H                  OFS_UCA0CTLW1+1
#define OFS_UCA0BRW                      (0x0006)
#define OFS_UCA0BRW_L                    OFS_UCA0BRW
#define OFS_UCA0BRW_H                    OFS_UCA0BRW+1
#define OFS_UCA0MCTLW                    (0x0008)
#define OFS_UCA0MCTLW_L                  OFS_UCA0MCTLW
#define OFS_UCA0MCTLW_H                  OFS_UCA0MCTLW+1
#define OFS_UCA0STATW                    (0x000A)
#define OFS_UCA0STATW_L                  OFS_UCA0STATW
#define OFS_UCA0STATW_H                  OFS_UCA0STATW+1
#define OFS_UCA0RXBUF                    (0x000C)
#define OFS_UCA0RXBUF_L                  OFS_UCA0RXBUF
#define OFS_UCA0RXBUF_H                  OFS_UCA0RXBUF+1
#define OFS_UCA0TXBUF                    (0x000E)
#define OFS_UCA0TXBUF_L                  OFS_UCA0TXBUF
#define OFS_UCA0TXBUF_H                  OFS_UCA0TXBUF+1
#define OFS_UCA0ABCTL                    (0x0010)
#define OFS_UCA0ABCTL_L                  OFS_UCA0ABCTL
#define OFS_UCA0ABCTL_H                  OFS_UCA0ABCTL+1
#define OFS_UCA0IRCTL                    (0x0012)
#define OFS_UCA0IRCTL_L                  OFS_UCA0IRCTL
#define OFS_UCA0IRCTL_H                  OFS_UCA0IRCTL+1
#define OFS_UCA0IE                       (0x001A)
#define OFS_UCA0IE_L                     OFS_UCA0IE
#define OFS_UCA0IE_H                     OFS_UCA0IE+1
#define OFS_UCA0IFG                      (0x001C)
#define OFS_UCA0IFG_L                    OFS_UCA0IFG
#define OFS_UCA0IFG_H                    OFS_UCA0IFG+1
#define OFS_UCA0IV                       (0x001E)
#define OFS_UCA0IV_L                     OFS_UCA0IV
#define OFS_UCA0IV_H                     OFS_UCA0IV+1

/* eUSCI_A0 Control Bits */

/* UCA0CTLW0 Control Bits */
#define UCSWRST                          (0x0001)        /* Software reset enable */
#define UCSWRST_L                        (0x0001)
#define UCSWRST_0                        (0x0000)        /* Disabled. eUSCI_A reset released for operation */
#define UCSWRST_1                        (0x0001)        /* Enabled. eUSCI_A logic held in reset state */
#define UCSWRST_1_L                      (0x0001)
#define UCSWRST__DISABLE                 (0x0000)        /* Disabled. eUSCI_A reset released for operation */
#define UCSWRST__ENABLE                  (0x0001)        /* Enabled. eUSCI_A logic held in reset state */
#define UCSWRST__ENABLE_L                (0x0001)
#define UCTXBRK                          (0x0002)        /* Transmit break */
#define UCTXBRK_L                        (0x0002)
#define UCTXBRK_0                        (0x0000)        /* Next frame transmitted is not a break */
#define UCTXBRK_1                        (0x0002)        /* Next frame transmitted is a break or a break/synch */
#define UCTXBRK_1_L                      (0x0002)
#define UCTXADDR                         (0x0004)        /* Transmit address */
#define UCTXADDR_L                       (0x0004)
#define UCTXADDR_0                       (0x0000)        /* Next frame transmitted is data */
#define UCTXADDR_1                       (0x0004)        /* Next frame transmitted is an address */
#define UCTXADDR_1_L                     (0x0004)
#define UCDORM                           (0x0008)        /* Dormant */
#define UCDORM_L                         (0x0008)
#define UCDORM_0                         (0x0000)        /* Not dormant. All received characters set UCRXIFG. */
#define UCDORM_1                         (0x0008)        /* Dormant. Only characters that are preceded by an idle-line or 
                                                            with address bit set UCRXIFG. In UART mode with automatic 
                                                            baud-rate detection, only the combination of a break and synch
                                                            field sets UCRXIFG. */
#define UCDORM_1_L                       (0x0008)
#define UCBRKIE                          (0x0010)        /* Receive break character interrupt enable */
#define UCBRKIE_L                        (0x0010)
#define UCBRKIE_0                        (0x0000)        /* Received break characters do not set UCRXIFG */
#define UCBRKIE_1                        (0x0010)        /* Received break characters set UCRXIFG */
#define UCBRKIE_1_L                      (0x0010)
#define UCRXEIE                          (0x0020)        /* Receive erroneous-character interrupt enable */
#define UCRXEIE_L                        (0x0020)
#define UCRXEIE_0                        (0x0000)        /* Erroneous characters rejected and UCRXIFG is not set */
#define UCRXEIE_1                        (0x0020)        /* Erroneous characters received set UCRXIFG */
#define UCRXEIE_1_L                      (0x0020)
#define UCSSEL                           (0x00c0)        /* eUSCI_A clock source select */
#define UCSSEL_L                         (0x00c0)
#define UCSSEL0                          (0x0040)        /* eUSCI_A clock source select */
#define UCSSEL0_L                        (0x0040)
#define UCSSEL1                          (0x0080)        /* eUSCI_A clock source select */
#define UCSSEL1_L                        (0x0080)
#define UCSSEL_0                         (0x0000)        /* UCLK */
#define UCSSEL_1                         (0x0040)        /* ACLK */
#define UCSSEL_1_L                       (0x0040)
#define UCSSEL_2                         (0x0080)        /* SMCLK */
#define UCSSEL_2_L                       (0x0080)
#define UCSSEL__UCLK                     (0x0000)        /* UCLK */
#define UCSSEL__ACLK                     (0x0040)        /* ACLK */
#define UCSSEL__ACLK_L                   (0x0040)
#define UCSSEL__SMCLK                    (0x0080)        /* SMCLK */
#define UCSSEL__SMCLK_L                  (0x0080)
#define UCSYNC                           (0x0100)        /* Synchronous mode enable */
#define UCSYNC_H                         (0x0001)
#define UCSYNC_0                         (0x0000)        /* Asynchronous mode */
#define UCSYNC_1                         (0x0100)        /* Synchronous mode */
#define UCSYNC_1_H                       (0x0001)
#define UCSYNC__ASYNC                    (0x0000)        /* Asynchronous mode */
#define UCSYNC__SYNC                     (0x0100)        /* Synchronous mode */
#define UCSYNC__SYNC_H                   (0x0001)
#define UCMODE                           (0x0600)        /* eUSCI_A mode */
#define UCMODE_H                         (0x0006)
#define UCMODE0                          (0x0200)        /* eUSCI_A mode */
#define UCMODE0_H                        (0x0002)
#define UCMODE1                          (0x0400)        /* eUSCI_A mode */
#define UCMODE1_H                        (0x0004)
#define UCMODE_0                         (0x0000)        /* UART mode */
#define UCMODE_1                         (0x0200)        /* Idle-line multiprocessor mode */
#define UCMODE_1_H                       (0x0002)
#define UCMODE_2                         (0x0400)        /* Address-bit multiprocessor mode */
#define UCMODE_2_H                       (0x0004)
#define UCMODE_3                         (0x0600)        /* UART mode with automatic baud-rate detection */
#define UCMODE_3_H                       (0x0006)
#define UCSPB                            (0x0800)        /* Stop bit select */
#define UCSPB_H                          (0x0008)
#define UCSPB_0                          (0x0000)        /* One stop bit */
#define UCSPB_1                          (0x0800)        /* Two stop bits */
#define UCSPB_1_H                        (0x0008)
#define UC7BIT                           (0x1000)        /* Character length */
#define UC7BIT_H                         (0x0010)
#define UC7BIT_0                         (0x0000)        /* 8-bit data */
#define UC7BIT_1                         (0x1000)        /* 7-bit data */
#define UC7BIT_1_H                       (0x0010)
#define UC7BIT__8BIT                     (0x0000)        /* 8-bit data */
#define UC7BIT__7BIT                     (0x1000)        /* 7-bit data */
#define UC7BIT__7BIT_H                   (0x0010)
#define UCMSB                            (0x2000)        /* MSB first select */
#define UCMSB_H                          (0x0020)
#define UCMSB_0                          (0x0000)        /* LSB first */
#define UCMSB_1                          (0x2000)        /* MSB first */
#define UCMSB_1_H                        (0x0020)
#define UCPAR                            (0x4000)        /* Parity select */
#define UCPAR_H                          (0x0040)
#define UCPAR_0                          (0x0000)        /* Odd parity */
#define UCPAR_1                          (0x4000)        /* Even parity */
#define UCPAR_1_H                        (0x0040)
#define UCPAR__ODD                       (0x0000)        /* Odd parity */
#define UCPAR__EVEN                      (0x4000)        /* Even parity */
#define UCPAR__EVEN_H                    (0x0040)
#define UCPEN                            (0x8000)        /* Parity enable */
#define UCPEN_H                          (0x0080)
#define UCPEN_0                          (0x0000)        /* Parity disabled */
#define UCPEN_1                          (0x8000)        /* Parity enabled. Parity bit is generated (UCAxTXD) and expected
                                                            (UCAxRXD). In address-bit multiprocessor mode, the address bit
                                                            is included in the parity calculation. */
#define UCPEN_1_H                        (0x0080)

/* UCA0CTLW0_SPI Control Bits */
#define UCSTEM                           (0x0002)        /* STE mode select in master mode. */
#define UCSTEM_L                         (0x0002)
#define UCSTEM_0                         (0x0000)        /* STE pin is used to prevent conflicts with other masters */
#define UCSTEM_1                         (0x0002)        /* STE pin is used to generate the enable signal for a 4-wire 
                                                            slave */
#define UCSTEM_1_L                       (0x0002)
#define UCMST                            (0x0800)        /* Master mode select */
#define UCMST_H                          (0x0008)
#define UCMST_0                          (0x0000)        /* Slave mode */
#define UCMST_1                          (0x0800)        /* Master mode */
#define UCMST_1_H                        (0x0008)
#define UCMST__SLAVE                     (0x0000)        /* Slave mode */
#define UCMST__MASTER                    (0x0800)        /* Master mode */
#define UCMST__MASTER_H                  (0x0008)
#define UCCKPL                           (0x4000)        /* Clock polarity select */
#define UCCKPL_H                         (0x0040)
#define UCCKPL_0                         (0x0000)        /* The inactive state is low */
#define UCCKPL_1                         (0x4000)        /* The inactive state is high */
#define UCCKPL_1_H                       (0x0040)
#define UCCKPL__LOW                      (0x0000)        /* The inactive state is low */
#define UCCKPL__HIGH                     (0x4000)        /* The inactive state is high */
#define UCCKPL__HIGH_H                   (0x0040)
#define UCCKPH                           (0x8000)        /* Clock phase select */
#define UCCKPH_H                         (0x0080)
#define UCCKPH_0                         (0x0000)        /* Data is changed on the first UCLK edge and captured on the 
                                                            following edge. */
#define UCCKPH_1                         (0x8000)        /* Data is captured on the first UCLK edge and changed on the 
                                                            following edge. */
#define UCCKPH_1_H                       (0x0080)

/* UCA0CTLW1 Control Bits */
#define UCGLIT                           (0x0003)        /* Deglitch time */
#define UCGLIT_L                         (0x0003)
#define UCGLIT0                          (0x0001)        /* Deglitch time */
#define UCGLIT0_L                        (0x0001)
#define UCGLIT1                          (0x0002)        /* Deglitch time */
#define UCGLIT1_L                        (0x0002)
#define UCGLIT_0                         (0x0000)        /* Approximately 2 ns (equivalent of 1 delay element) */
#define UCGLIT_1                         (0x0001)        /* Approximately 50 ns */
#define UCGLIT_1_L                       (0x0001)
#define UCGLIT_2                         (0x0002)        /* Approximately 100 ns */
#define UCGLIT_2_L                       (0x0002)
#define UCGLIT_3                         (0x0003)        /* Approximately 200 ns */
#define UCGLIT_3_L                       (0x0003)

/* UCA0BRW Control Bits */
#define UCBR                             (0xffff)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR_L                           (0x00ff)
#define UCBR_H                           (0x00ff)
#define UCBR0                            (0x0001)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR0_L                          (0x0001)
#define UCBR1                            (0x0002)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR1_L                          (0x0002)
#define UCBR2                            (0x0004)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR2_L                          (0x0004)
#define UCBR3                            (0x0008)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR3_L                          (0x0008)
#define UCBR4                            (0x0010)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR4_L                          (0x0010)
#define UCBR5                            (0x0020)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR5_L                          (0x0020)
#define UCBR6                            (0x0040)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR6_L                          (0x0040)
#define UCBR7                            (0x0080)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR7_L                          (0x0080)
#define UCBR8                            (0x0100)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR8_H                          (0x0001)
#define UCBR9                            (0x0200)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR9_H                          (0x0002)
#define UCBR10                           (0x0400)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR10_H                         (0x0004)
#define UCBR11                           (0x0800)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR11_H                         (0x0008)
#define UCBR12                           (0x1000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR12_H                         (0x0010)
#define UCBR13                           (0x2000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR13_H                         (0x0020)
#define UCBR14                           (0x4000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR14_H                         (0x0040)
#define UCBR15                           (0x8000)        /* Clock prescaler setting of the Baud rate generator */
#define UCBR15_H                         (0x0080)

/* UCA0MCTLW Control Bits */
#define UCOS16                           (0x0001)        /* Oversampling mode enabled */
#define UCOS16_L                         (0x0001)
#define UCOS16_0                         (0x0000)        /* Disabled */
#define UCOS16_1                         (0x0001)        /* Enabled */
#define UCOS16_1_L                       (0x0001)
#define UCBRF                            (0x00f0)        /* First modulation stage select */
#define UCBRF_L                          (0x00f0)
#define UCBRF0                           (0x0010)        /* First modulation stage select */
#define UCBRF0_L                         (0x0010)
#define UCBRF1                           (0x0020)        /* First modulation stage select */
#define UCBRF1_L                         (0x0020)
#define UCBRF2                           (0x0040)        /* First modulation stage select */
#define UCBRF2_L                         (0x0040)
#define UCBRF3                           (0x0080)        /* First modulation stage select */
#define UCBRF3_L                         (0x0080)
#define UCBRS                            (0xff00)        /* Second modulation stage select */
#define UCBRS_H                          (0x00ff)
#define UCBRS0                           (0x0100)        /* Second modulation stage select */
#define UCBRS0_H                         (0x0001)
#define UCBRS1                           (0x0200)        /* Second modulation stage select */
#define UCBRS1_H                         (0x0002)
#define UCBRS2                           (0x0400)        /* Second modulation stage select */
#define UCBRS2_H                         (0x0004)
#define UCBRS3                           (0x0800)        /* Second modulation stage select */
#define UCBRS3_H                         (0x0008)
#define UCBRS4                           (0x1000)        /* Second modulation stage select */
#define UCBRS4_H                         (0x0010)
#define UCBRS5                           (0x2000)        /* Second modulation stage select */
#define UCBRS5_H                         (0x0020)
#define UCBRS6                           (0x4000)        /* Second modulation stage select */
#define UCBRS6_H                         (0x0040)
#define UCBRS7                           (0x8000)        /* Second modulation stage select */
#define UCBRS7_H                         (0x0080)

/* UCA0STATW Control Bits */
#define UCBUSY                           (0x0001)        /* eUSCI_A busy */
#define UCBUSY_L                         (0x0001)
#define UCBUSY_0                         (0x0000)        /* eUSCI_A inactive */
#define UCBUSY_1                         (0x0001)        /* eUSCI_A transmitting or receiving */
#define UCBUSY_1_L                       (0x0001)
#define UCBUSY__IDLE                     (0x0000)        /* eUSCI_A inactive */
#define UCBUSY__BUSY                     (0x0001)        /* eUSCI_A transmitting or receiving */
#define UCBUSY__BUSY_L                   (0x0001)
#define UCADDR_UCIDLE                    (0x0002)        /* Address received / Idle line detected */
#define UCADDR_UCIDLE_L                  (0x0002)
#define UCRXERR                          (0x0004)        /* Receive error flag */
#define UCRXERR_L                        (0x0004)
#define UCRXERR_0                        (0x0000)        /* No receive errors detected */
#define UCRXERR_1                        (0x0004)        /* Receive error detected */
#define UCRXERR_1_L                      (0x0004)
#define UCBRK                            (0x0008)        /* Break detect flag */
#define UCBRK_L                          (0x0008)
#define UCBRK_0                          (0x0000)        /* No break condition */
#define UCBRK_1                          (0x0008)        /* Break condition occurred */
#define UCBRK_1_L                        (0x0008)
#define UCPE                             (0x0010)        /* */
#define UCPE_L                           (0x0010)
#define UCPE_0                           (0x0000)        /* No error */
#define UCPE_1                           (0x0010)        /* Character received with parity error */
#define UCPE_1_L                         (0x0010)
#define UCOE                             (0x0020)        /* Overrun error flag */
#define UCOE_L                           (0x0020)
#define UCOE_0                           (0x0000)        /* No error */
#define UCOE_1                           (0x0020)        /* Overrun error occurred */
#define UCOE_1_L                         (0x0020)
#define UCFE                             (0x0040)        /* Framing error flag */
#define UCFE_L                           (0x0040)
#define UCFE_0                           (0x0000)        /* No error */
#define UCFE_1                           (0x0040)        /* Character received with low stop bit */
#define UCFE_1_L                         (0x0040)
#define UCLISTEN                         (0x0080)        /* Listen enable */
#define UCLISTEN_L                       (0x0080)
#define UCLISTEN_0                       (0x0000)        /* Disabled */
#define UCLISTEN_1                       (0x0080)        /* Enabled. UCAxTXD is internally fed back to the receiver */
#define UCLISTEN_1_L                     (0x0080)

/* UCA0RXBUF Control Bits */
#define UCRXBUF                          (0x00ff)        /* Receive data buffer */
#define UCRXBUF_L                        (0x00ff)
#define UCRXBUF0                         (0x0001)        /* Receive data buffer */
#define UCRXBUF0_L                       (0x0001)
#define UCRXBUF1                         (0x0002)        /* Receive data buffer */
#define UCRXBUF1_L                       (0x0002)
#define UCRXBUF2                         (0x0004)        /* Receive data buffer */
#define UCRXBUF2_L                       (0x0004)
#define UCRXBUF3                         (0x0008)        /* Receive data buffer */
#define UCRXBUF3_L                       (0x0008)
#define UCRXBUF4                         (0x0010)        /* Receive data buffer */
#define UCRXBUF4_L                       (0x0010)
#define UCRXBUF5                         (0x0020)        /* Receive data buffer */
#define UCRXBUF5_L                       (0x0020)
#define UCRXBUF6                         (0x0040)        /* Receive data buffer */
#define UCRXBUF6_L                       (0x0040)
#define UCRXBUF7                         (0x0080)        /* Receive data buffer */
#define UCRXBUF7_L                       (0x0080)

/* UCA0TXBUF Control Bits */
#define UCTXBUF                          (0x00ff)        /* Transmit data buffer */
#define UCTXBUF_L                        (0x00ff)
#define UCTXBUF0                         (0x0001)        /* Transmit data buffer */
#define UCTXBUF0_L                       (0x0001)
#define UCTXBUF1                         (0x0002)        /* Transmit data buffer */
#define UCTXBUF1_L                       (0x0002)
#define UCTXBUF2                         (0x0004)        /* Transmit data buffer */
#define UCTXBUF2_L                       (0x0004)
#define UCTXBUF3                         (0x0008)        /* Transmit data buffer */
#define UCTXBUF3_L                       (0x0008)
#define UCTXBUF4                         (0x0010)        /* Transmit data buffer */
#define UCTXBUF4_L                       (0x0010)
#define UCTXBUF5                         (0x0020)        /* Transmit data buffer */
#define UCTXBUF5_L                       (0x0020)
#define UCTXBUF6                         (0x0040)        /* Transmit data buffer */
#define UCTXBUF6_L                       (0x0040)
#define UCTXBUF7                         (0x0080)        /* Transmit data buffer */
#define UCTXBUF7_L                       (0x0080)

/* UCA0ABCTL Control Bits */
#define UCABDEN                          (0x0001)        /* Automatic baud-rate detect enable */
#define UCABDEN_L                        (0x0001)
#define UCABDEN_0                        (0x0000)        /* Baud-rate detection disabled. Length of break and synch field 
                                                            is not measured. */
#define UCABDEN_1                        (0x0001)        /* Baud-rate detection enabled. Length of break and synch field 
                                                            is measured and baud-rate settings are changed accordingly. */
#define UCABDEN_1_L                      (0x0001)
#define UCBTOE                           (0x0004)        /* Break time out error */
#define UCBTOE_L                         (0x0004)
#define UCBTOE_0                         (0x0000)        /* No error */
#define UCBTOE_1                         (0x0004)        /* Length of break field exceeded 22 bit times */
#define UCBTOE_1_L                       (0x0004)
#define UCSTOE                           (0x0008)        /* Synch field time out error */
#define UCSTOE_L                         (0x0008)
#define UCSTOE_0                         (0x0000)        /* No error */
#define UCSTOE_1                         (0x0008)        /* Length of synch field exceeded measurable time */
#define UCSTOE_1_L                       (0x0008)
#define UCDELIM                          (0x0030)        /* Break/synch delimiter length */
#define UCDELIM_L                        (0x0030)
#define UCDELIM0                         (0x0010)        /* Break/synch delimiter length */
#define UCDELIM0_L                       (0x0010)
#define UCDELIM1                         (0x0020)        /* Break/synch delimiter length */
#define UCDELIM1_L                       (0x0020)
#define UCDELIM_0                        (0x0000)        /* 1 bit time */
#define UCDELIM_1                        (0x0010)        /* 2 bit times */
#define UCDELIM_1_L                      (0x0010)
#define UCDELIM_2                        (0x0020)        /* 3 bit times */
#define UCDELIM_2_L                      (0x0020)
#define UCDELIM_3                        (0x0030)        /* 4 bit times */
#define UCDELIM_3_L                      (0x0030)

/* UCA0IRCTL Control Bits */
#define UCIREN                           (0x0001)        /* IrDA encoder/decoder enable */
#define UCIREN_L                         (0x0001)
#define UCIREN_0                         (0x0000)        /* IrDA encoder/decoder disabled */
#define UCIREN_1                         (0x0001)        /* IrDA encoder/decoder enabled */
#define UCIREN_1_L                       (0x0001)
#define UCIRTXCLK                        (0x0002)        /* IrDA transmit pulse clock select */
#define UCIRTXCLK_L                      (0x0002)
#define UCIRTXCLK_0                      (0x0000)        /* BRCLK */
#define UCIRTXCLK_1                      (0x0002)        /* BITCLK16 when UCOS16 = 1. Otherwise, BRCLK. */
#define UCIRTXCLK_1_L                    (0x0002)
#define UCIRTXPL                         (0x00fc)        /* Transmit pulse length */
#define UCIRTXPL_L                       (0x00fc)
#define UCIRTXPL0                        (0x0004)        /* Transmit pulse length */
#define UCIRTXPL0_L                      (0x0004)
#define UCIRTXPL1                        (0x0008)        /* Transmit pulse length */
#define UCIRTXPL1_L                      (0x0008)
#define UCIRTXPL2                        (0x0010)        /* Transmit pulse length */
#define UCIRTXPL2_L                      (0x0010)
#define UCIRTXPL3                        (0x0020)        /* Transmit pulse length */
#define UCIRTXPL3_L                      (0x0020)
#define UCIRTXPL4                        (0x0040)        /* Transmit pulse length */
#define UCIRTXPL4_L                      (0x0040)
#define UCIRTXPL5                        (0x0080)        /* Transmit pulse length */
#define UCIRTXPL5_L                      (0x0080)
#define UCIRRXFE                         (0x0100)        /* IrDA receive filter enabled */
#define UCIRRXFE_H                       (0x0001)
#define UCIRRXFE_0                       (0x0000)        /* Receive filter disabled */
#define UCIRRXFE_1                       (0x0100)        /* Receive filter enabled */
#define UCIRRXFE_1_H                     (0x0001)
#define UCIRRXPL                         (0x0200)        /* IrDA receive input UCAxRXD polarity */
#define UCIRRXPL_H                       (0x0002)
#define UCIRRXPL_0                       (0x0000)        /* IrDA transceiver delivers a high pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL_1                       (0x0200)        /* IrDA transceiver delivers a low pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL_1_H                     (0x0002)
#define UCIRRXPL__HIGH                   (0x0000)        /* IrDA transceiver delivers a high pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL__LOW                    (0x0200)        /* IrDA transceiver delivers a low pulse when a light pulse is 
                                                            seen */
#define UCIRRXPL__LOW_H                  (0x0002)
#define UCIRRXFL                         (0xfc00)        /* Receive filter length */
#define UCIRRXFL_H                       (0x00fc)
#define UCIRRXFL0                        (0x0400)        /* Receive filter length */
#define UCIRRXFL0_H                      (0x0004)
#define UCIRRXFL1                        (0x0800)        /* Receive filter length */
#define UCIRRXFL1_H                      (0x0008)
#define UCIRRXFL2                        (0x1000)        /* Receive filter length */
#define UCIRRXFL2_H                      (0x0010)
#define UCIRRXFL3                        (0x2000)        /* Receive filter length */
#define UCIRRXFL3_H                      (0x0020)
#define UCIRRXFL4                        (0x4000)        /* Receive filter length */
#define UCIRRXFL4_H                      (0x0040)
#define UCIRRXFL5                        (0x8000)        /* Receive filter length */
#define UCIRRXFL5_H                      (0x0080)

/* UCA0IE Control Bits */
#define UCRXIE                           (0x0001)        /* Receive interrupt enable */
#define UCRXIE_L                         (0x0001)
#define UCRXIE_0                         (0x0000)        /* Interrupt disabled */
#define UCRXIE_1                         (0x0001)        /* Interrupt enabled */
#define UCRXIE_1_L                       (0x0001)
#define UCTXIE                           (0x0002)        /* Transmit interrupt enable */
#define UCTXIE_L                         (0x0002)
#define UCTXIE_0                         (0x0000)        /* Interrupt disabled */
#define UCTXIE_1                         (0x0002)        /* Interrupt enabled */
#define UCTXIE_1_L                       (0x0002)
#define UCSTTIE                          (0x0004)        /* Start bit interrupt enable */
#define UCSTTIE_L                        (0x0004)
#define UCSTTIE_0                        (0x0000)        /* Interrupt disabled */
#define UCSTTIE_1                        (0x0004)        /* Interrupt enabled */
#define UCSTTIE_1_L                      (0x0004)
#define UCTXCPTIE                        (0x0008)        /* Transmit complete interrupt enable */
#define UCTXCPTIE_L                      (0x0008)
#define UCTXCPTIE_0                      (0x0000)        /* Interrupt disabled */
#define UCTXCPTIE_1                      (0x0008)        /* Interrupt enabled */
#define UCTXCPTIE_1_L                    (0x0008)

/* UCA0IFG Control Bits */
#define UCRXIFG                          (0x0001)        /* Receive interrupt flag */
#define UCRXIFG_L                        (0x0001)
#define UCRXIFG_0                        (0x0000)        /* No interrupt pending */
#define UCRXIFG_1                        (0x0001)        /* Interrupt pending */
#define UCRXIFG_1_L                      (0x0001)
#define UCTXIFG                          (0x0002)        /* Transmit interrupt flag */
#define UCTXIFG_L                        (0x0002)
#define UCTXIFG_0                        (0x0000)        /* No interrupt pending */
#define UCTXIFG_1                        (0x0002)        /* Interrupt pending */
#define UCTXIFG_1_L                      (0x0002)
#define UCSTTIFG                         (0x0004)        /* Start bit interrupt flag */
#define UCSTTIFG_L                       (0x0004)
#define UCSTTIFG_0                       (0x0000)        /* No interrupt pending */
#define UCSTTIFG_1                       (0x0004)        /* Interrupt pending */
#define UCSTTIFG_1_L                     (0x0004)
#define UCTXCPTIFG                       (0x0008)        /* Transmit ready interrupt enable */
#define UCTXCPTIFG_L                     (0x0008)
#define UCTXCPTIFG_0                     (0x0000)        /* No interrupt pending */
#define UCTXCPTIFG_1                     (0x0008)        /* Interrupt pending */
#define UCTXCPTIFG_1_L                   (0x0008)

/* UCA0IV Control Bits */
#define UCIV                             (0xffff)        /* eUSCI_A interrupt vector value */
#define UCIV_L                           (0x00ff)
#define UCIV_H                           (0x00ff)
#define UCIV0                            (0x0001)        /* eUSCI_A interrupt vector value */
#define UCIV0_L                          (0x0001)
#define UCIV1                            (0x0002)        /* eUSCI_A interrupt vector value */
#define UCIV1_L                          (0x0002)
#define UCIV2                            (0x0004)        /* eUSCI_A interrupt vector value */
#define UCIV2_L                          (0x0004)
#define UCIV3                            (0x0008)        /* eUSCI_A interrupt vector value */
#define UCIV3_L                          (0x0008)
#define UCIV4                            (0x0010)        /* eUSCI_A interrupt vector value */
#define UCIV4_L                          (0x0010)
#define UCIV5                            (0x0020)        /* eUSCI_A interrupt vector value */
#define UCIV5_L                          (0x0020)
#define UCIV6                            (0x0040)        /* eUSCI_A interrupt vector value */
#define UCIV6_L                          (0x0040)
#define UCIV7                            (0x0080)        /* eUSCI_A interrupt vector value */
#define UCIV7_L                          (0x0080)
#define UCIV8                            (0x0100)        /* eUSCI_A interrupt vector value */
#define UCIV8_H                          (0x0001)
#define UCIV9                            (0x0200)        /* eUSCI_A interrupt vector value */
#define UCIV9_H                          (0x0002)
#define UCIV10                           (0x0400)        /* eUSCI_A interrupt vector value */
#define UCIV10_H                         (0x0004)
#define UCIV11                           (0x0800)        /* eUSCI_A interrupt vector value */
#define UCIV11_H                         (0x0008)
#define UCIV12                           (0x1000)        /* eUSCI_A interrupt vector value */
#define UCIV12_H                         (0x0010)
#define UCIV13                           (0x2000)        /* eUSCI_A interrupt vector value */
#define UCIV13_H                         (0x0020)
#define UCIV14                           (0x4000)        /* eUSCI_A interrupt vector value */
#define UCIV14_H                         (0x0040)
#define UCIV15                           (0x8000)        /* eUSCI_A interrupt vector value */
#define UCIV15_H                         (0x0080)
#define UCIV_0                           (0x0000)        /* No interrupt pending */
#define UCIV_2                           (0x0002)        /* Interrupt Source: Receive buffer full; Interrupt Flag: 
                                                            UCRXIFG; Interrupt Priority: Highest */
#define UCIV_2_L                         (0x0002)
#define UCIV_4                           (0x0004)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG */
#define UCIV_4_L                         (0x0004)
#define UCIV_6                           (0x0006)        /* Interrupt Source: Start bit received; Interrupt Flag: UCSTTIFG */
#define UCIV_6_L                         (0x0006)
#define UCIV_8                           (0x0008)        /* Interrupt Source: Transmit complete; Interrupt Flag: 
                                                            UCTXCPTIFG; Interrupt Priority: Lowest */
#define UCIV_8_L                         (0x0008)
#define UCIV__NONE                       (0x0000)        /* No interrupt pending */
#define UCIV__UCRXIFG                    (0x0002)        /* Interrupt Source: Receive buffer full; Interrupt Flag: 
                                                            UCRXIFG; Interrupt Priority: Highest */
#define UCIV__UCRXIFG_L                  (0x0002)
#define UCIV__UCTXIFG                    (0x0004)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG */
#define UCIV__UCTXIFG_L                  (0x0004)
#define UCIV__UCSTTIFG                   (0x0006)        /* Interrupt Source: Start bit received; Interrupt Flag: UCSTTIFG */
#define UCIV__UCSTTIFG_L                 (0x0006)
#define UCIV__UCTXCPTIFG                 (0x0008)        /* Interrupt Source: Transmit complete; Interrupt Flag: 
                                                            UCTXCPTIFG; Interrupt Priority: Lowest */
#define UCIV__UCTXCPTIFG_L               (0x0008)


/*****************************************************************************
 eUSCI_A1 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_A1__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Ax__
#define __MSP430_HAS_EUSCI_Ax__
#endif
#define __MSP430_BASEADDRESS_EUSCI_A1__ 0x05E0
#define EUSCI_A1_BASE          __MSP430_BASEADDRESS_EUSCI_A1__

sfr_w(UCA1CTLW0);                             /* eUSCI_Ax Control Word Register 0 */
sfr_b(UCA1CTLW0_L);
sfr_b(UCA1CTLW0_H);
sfr_w(UCA1CTLW1);                             /* eUSCI_Ax Control Word Register 1 */
sfr_b(UCA1CTLW1_L);
sfr_b(UCA1CTLW1_H);
sfr_w(UCA1BRW);                               /* eUSCI_Ax Baud Rate Control Word Register */
sfr_b(UCA1BRW_L);
sfr_b(UCA1BRW_H);
sfr_w(UCA1MCTLW);                             /* eUSCI_Ax Modulation Control Word Register */
sfr_b(UCA1MCTLW_L);
sfr_b(UCA1MCTLW_H);
sfr_w(UCA1STATW);                             /* eUSCI_Ax Status Register */
sfr_b(UCA1STATW_L);
sfr_b(UCA1STATW_H);
sfr_w(UCA1RXBUF);                             /* eUSCI_Ax Receive Buffer Register */
sfr_b(UCA1RXBUF_L);
sfr_b(UCA1RXBUF_H);
sfr_w(UCA1TXBUF);                             /* eUSCI_Ax Transmit Buffer Register */
sfr_b(UCA1TXBUF_L);
sfr_b(UCA1TXBUF_H);
sfr_w(UCA1ABCTL);                             /* eUSCI_Ax Auto Baud Rate Control Register */
sfr_b(UCA1ABCTL_L);
sfr_b(UCA1ABCTL_H);
sfr_w(UCA1IRCTL);                             /* eUSCI_Ax IrDA Control Word Register */
sfr_b(UCA1IRCTL_L);
sfr_b(UCA1IRCTL_H);
sfr_w(UCA1IE);                                /* eUSCI_Ax Interrupt Enable Register */
sfr_b(UCA1IE_L);
sfr_b(UCA1IE_H);
sfr_w(UCA1IFG);                               /* eUSCI_Ax Interrupt Flag Register */
sfr_b(UCA1IFG_L);
sfr_b(UCA1IFG_H);
sfr_w(UCA1IV);                                /* eUSCI_Ax Interrupt Vector Register */
sfr_b(UCA1IV_L);
sfr_b(UCA1IV_H);

/* eUSCI_A1 Register Offsets */
#define OFS_UCA1CTLW0                    (0x0000)
#define OFS_UCA1CTLW0_L                  OFS_UCA1CTLW0
#define OFS_UCA1CTLW0_H                  OFS_UCA1CTLW0+1
#define OFS_UCA1CTLW1                    (0x0002)
#define OFS_UCA1CTLW1_L                  OFS_UCA1CTLW1
#define OFS_UCA1CTLW1_H                  OFS_UCA1CTLW1+1
#define OFS_UCA1BRW                      (0x0006)
#define OFS_UCA1BRW_L                    OFS_UCA1BRW
#define OFS_UCA1BRW_H                    OFS_UCA1BRW+1
#define OFS_UCA1MCTLW                    (0x0008)
#define OFS_UCA1MCTLW_L                  OFS_UCA1MCTLW
#define OFS_UCA1MCTLW_H                  OFS_UCA1MCTLW+1
#define OFS_UCA1STATW                    (0x000A)
#define OFS_UCA1STATW_L                  OFS_UCA1STATW
#define OFS_UCA1STATW_H                  OFS_UCA1STATW+1
#define OFS_UCA1RXBUF                    (0x000C)
#define OFS_UCA1RXBUF_L                  OFS_UCA1RXBUF
#define OFS_UCA1RXBUF_H                  OFS_UCA1RXBUF+1
#define OFS_UCA1TXBUF                    (0x000E)
#define OFS_UCA1TXBUF_L                  OFS_UCA1TXBUF
#define OFS_UCA1TXBUF_H                  OFS_UCA1TXBUF+1
#define OFS_UCA1ABCTL                    (0x0010)
#define OFS_UCA1ABCTL_L                  OFS_UCA1ABCTL
#define OFS_UCA1ABCTL_H                  OFS_UCA1ABCTL+1
#define OFS_UCA1IRCTL                    (0x0012)
#define OFS_UCA1IRCTL_L                  OFS_UCA1IRCTL
#define OFS_UCA1IRCTL_H                  OFS_UCA1IRCTL+1
#define OFS_UCA1IE                       (0x001A)
#define OFS_UCA1IE_L                     OFS_UCA1IE
#define OFS_UCA1IE_H                     OFS_UCA1IE+1
#define OFS_UCA1IFG                      (0x001C)
#define OFS_UCA1IFG_L                    OFS_UCA1IFG
#define OFS_UCA1IFG_H                    OFS_UCA1IFG+1
#define OFS_UCA1IV                       (0x001E)
#define OFS_UCA1IV_L                     OFS_UCA1IV
#define OFS_UCA1IV_H                     OFS_UCA1IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 eUSCI_A2 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_A2__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Ax__
#define __MSP430_HAS_EUSCI_Ax__
#endif
#define __MSP430_BASEADDRESS_EUSCI_A2__ 0x0600
#define EUSCI_A2_BASE          __MSP430_BASEADDRESS_EUSCI_A2__

sfr_w(UCA2CTLW0);                             /* eUSCI_Ax Control Word Register 0 */
sfr_b(UCA2CTLW0_L);
sfr_b(UCA2CTLW0_H);
sfr_w(UCA2CTLW1);                             /* eUSCI_Ax Control Word Register 1 */
sfr_b(UCA2CTLW1_L);
sfr_b(UCA2CTLW1_H);
sfr_w(UCA2BRW);                               /* eUSCI_Ax Baud Rate Control Word Register */
sfr_b(UCA2BRW_L);
sfr_b(UCA2BRW_H);
sfr_w(UCA2MCTLW);                             /* eUSCI_Ax Modulation Control Word Register */
sfr_b(UCA2MCTLW_L);
sfr_b(UCA2MCTLW_H);
sfr_w(UCA2STATW);                             /* eUSCI_Ax Status Register */
sfr_b(UCA2STATW_L);
sfr_b(UCA2STATW_H);
sfr_w(UCA2RXBUF);                             /* eUSCI_Ax Receive Buffer Register */
sfr_b(UCA2RXBUF_L);
sfr_b(UCA2RXBUF_H);
sfr_w(UCA2TXBUF);                             /* eUSCI_Ax Transmit Buffer Register */
sfr_b(UCA2TXBUF_L);
sfr_b(UCA2TXBUF_H);
sfr_w(UCA2ABCTL);                             /* eUSCI_Ax Auto Baud Rate Control Register */
sfr_b(UCA2ABCTL_L);
sfr_b(UCA2ABCTL_H);
sfr_w(UCA2IRCTL);                             /* eUSCI_Ax IrDA Control Word Register */
sfr_b(UCA2IRCTL_L);
sfr_b(UCA2IRCTL_H);
sfr_w(UCA2IE);                                /* eUSCI_Ax Interrupt Enable Register */
sfr_b(UCA2IE_L);
sfr_b(UCA2IE_H);
sfr_w(UCA2IFG);                               /* eUSCI_Ax Interrupt Flag Register */
sfr_b(UCA2IFG_L);
sfr_b(UCA2IFG_H);
sfr_w(UCA2IV);                                /* eUSCI_Ax Interrupt Vector Register */
sfr_b(UCA2IV_L);
sfr_b(UCA2IV_H);

/* eUSCI_A2 Register Offsets */
#define OFS_UCA2CTLW0                    (0x0000)
#define OFS_UCA2CTLW0_L                  OFS_UCA2CTLW0
#define OFS_UCA2CTLW0_H                  OFS_UCA2CTLW0+1
#define OFS_UCA2CTLW1                    (0x0002)
#define OFS_UCA2CTLW1_L                  OFS_UCA2CTLW1
#define OFS_UCA2CTLW1_H                  OFS_UCA2CTLW1+1
#define OFS_UCA2BRW                      (0x0006)
#define OFS_UCA2BRW_L                    OFS_UCA2BRW
#define OFS_UCA2BRW_H                    OFS_UCA2BRW+1
#define OFS_UCA2MCTLW                    (0x0008)
#define OFS_UCA2MCTLW_L                  OFS_UCA2MCTLW
#define OFS_UCA2MCTLW_H                  OFS_UCA2MCTLW+1
#define OFS_UCA2STATW                    (0x000A)
#define OFS_UCA2STATW_L                  OFS_UCA2STATW
#define OFS_UCA2STATW_H                  OFS_UCA2STATW+1
#define OFS_UCA2RXBUF                    (0x000C)
#define OFS_UCA2RXBUF_L                  OFS_UCA2RXBUF
#define OFS_UCA2RXBUF_H                  OFS_UCA2RXBUF+1
#define OFS_UCA2TXBUF                    (0x000E)
#define OFS_UCA2TXBUF_L                  OFS_UCA2TXBUF
#define OFS_UCA2TXBUF_H                  OFS_UCA2TXBUF+1
#define OFS_UCA2ABCTL                    (0x0010)
#define OFS_UCA2ABCTL_L                  OFS_UCA2ABCTL
#define OFS_UCA2ABCTL_H                  OFS_UCA2ABCTL+1
#define OFS_UCA2IRCTL                    (0x0012)
#define OFS_UCA2IRCTL_L                  OFS_UCA2IRCTL
#define OFS_UCA2IRCTL_H                  OFS_UCA2IRCTL+1
#define OFS_UCA2IE                       (0x001A)
#define OFS_UCA2IE_L                     OFS_UCA2IE
#define OFS_UCA2IE_H                     OFS_UCA2IE+1
#define OFS_UCA2IFG                      (0x001C)
#define OFS_UCA2IFG_L                    OFS_UCA2IFG
#define OFS_UCA2IFG_H                    OFS_UCA2IFG+1
#define OFS_UCA2IV                       (0x001E)
#define OFS_UCA2IV_L                     OFS_UCA2IV
#define OFS_UCA2IV_H                     OFS_UCA2IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 eUSCI_A3 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_A3__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Ax__
#define __MSP430_HAS_EUSCI_Ax__
#endif
#define __MSP430_BASEADDRESS_EUSCI_A3__ 0x0620
#define EUSCI_A3_BASE          __MSP430_BASEADDRESS_EUSCI_A3__

sfr_w(UCA3CTLW0);                             /* eUSCI_Ax Control Word Register 0 */
sfr_b(UCA3CTLW0_L);
sfr_b(UCA3CTLW0_H);
sfr_w(UCA3CTLW1);                             /* eUSCI_Ax Control Word Register 1 */
sfr_b(UCA3CTLW1_L);
sfr_b(UCA3CTLW1_H);
sfr_w(UCA3BRW);                               /* eUSCI_Ax Baud Rate Control Word Register */
sfr_b(UCA3BRW_L);
sfr_b(UCA3BRW_H);
sfr_w(UCA3MCTLW);                             /* eUSCI_Ax Modulation Control Word Register */
sfr_b(UCA3MCTLW_L);
sfr_b(UCA3MCTLW_H);
sfr_w(UCA3STATW);                             /* eUSCI_Ax Status Register */
sfr_b(UCA3STATW_L);
sfr_b(UCA3STATW_H);
sfr_w(UCA3RXBUF);                             /* eUSCI_Ax Receive Buffer Register */
sfr_b(UCA3RXBUF_L);
sfr_b(UCA3RXBUF_H);
sfr_w(UCA3TXBUF);                             /* eUSCI_Ax Transmit Buffer Register */
sfr_b(UCA3TXBUF_L);
sfr_b(UCA3TXBUF_H);
sfr_w(UCA3ABCTL);                             /* eUSCI_Ax Auto Baud Rate Control Register */
sfr_b(UCA3ABCTL_L);
sfr_b(UCA3ABCTL_H);
sfr_w(UCA3IRCTL);                             /* eUSCI_Ax IrDA Control Word Register */
sfr_b(UCA3IRCTL_L);
sfr_b(UCA3IRCTL_H);
sfr_w(UCA3IE);                                /* eUSCI_Ax Interrupt Enable Register */
sfr_b(UCA3IE_L);
sfr_b(UCA3IE_H);
sfr_w(UCA3IFG);                               /* eUSCI_Ax Interrupt Flag Register */
sfr_b(UCA3IFG_L);
sfr_b(UCA3IFG_H);
sfr_w(UCA3IV);                                /* eUSCI_Ax Interrupt Vector Register */
sfr_b(UCA3IV_L);
sfr_b(UCA3IV_H);

/* eUSCI_A3 Register Offsets */
#define OFS_UCA3CTLW0                    (0x0000)
#define OFS_UCA3CTLW0_L                  OFS_UCA3CTLW0
#define OFS_UCA3CTLW0_H                  OFS_UCA3CTLW0+1
#define OFS_UCA3CTLW1                    (0x0002)
#define OFS_UCA3CTLW1_L                  OFS_UCA3CTLW1
#define OFS_UCA3CTLW1_H                  OFS_UCA3CTLW1+1
#define OFS_UCA3BRW                      (0x0006)
#define OFS_UCA3BRW_L                    OFS_UCA3BRW
#define OFS_UCA3BRW_H                    OFS_UCA3BRW+1
#define OFS_UCA3MCTLW                    (0x0008)
#define OFS_UCA3MCTLW_L                  OFS_UCA3MCTLW
#define OFS_UCA3MCTLW_H                  OFS_UCA3MCTLW+1
#define OFS_UCA3STATW                    (0x000A)
#define OFS_UCA3STATW_L                  OFS_UCA3STATW
#define OFS_UCA3STATW_H                  OFS_UCA3STATW+1
#define OFS_UCA3RXBUF                    (0x000C)
#define OFS_UCA3RXBUF_L                  OFS_UCA3RXBUF
#define OFS_UCA3RXBUF_H                  OFS_UCA3RXBUF+1
#define OFS_UCA3TXBUF                    (0x000E)
#define OFS_UCA3TXBUF_L                  OFS_UCA3TXBUF
#define OFS_UCA3TXBUF_H                  OFS_UCA3TXBUF+1
#define OFS_UCA3ABCTL                    (0x0010)
#define OFS_UCA3ABCTL_L                  OFS_UCA3ABCTL
#define OFS_UCA3ABCTL_H                  OFS_UCA3ABCTL+1
#define OFS_UCA3IRCTL                    (0x0012)
#define OFS_UCA3IRCTL_L                  OFS_UCA3IRCTL
#define OFS_UCA3IRCTL_H                  OFS_UCA3IRCTL+1
#define OFS_UCA3IE                       (0x001A)
#define OFS_UCA3IE_L                     OFS_UCA3IE
#define OFS_UCA3IE_H                     OFS_UCA3IE+1
#define OFS_UCA3IFG                      (0x001C)
#define OFS_UCA3IFG_L                    OFS_UCA3IFG
#define OFS_UCA3IFG_H                    OFS_UCA3IFG+1
#define OFS_UCA3IV                       (0x001E)
#define OFS_UCA3IV_L                     OFS_UCA3IV
#define OFS_UCA3IV_H                     OFS_UCA3IV+1

/* No control bits available or already defined for another module */

/*****************************************************************************
 eUSCI_B0 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_B0__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Bx__
#define __MSP430_HAS_EUSCI_Bx__
#endif
#define __MSP430_BASEADDRESS_EUSCI_B0__ 0x0640
#define EUSCI_B0_BASE          __MSP430_BASEADDRESS_EUSCI_B0__

sfr_w(UCB0CTLW0);                             /* eUSCI_Bx Control Word Register 0 */
sfr_b(UCB0CTLW0_L);
sfr_b(UCB0CTLW0_H);
sfr_w(UCB0CTLW1);                             /* eUSCI_Bx Control Word Register 1 */
sfr_b(UCB0CTLW1_L);
sfr_b(UCB0CTLW1_H);
sfr_w(UCB0BRW);                               /* eUSCI_Bx Baud Rate Control Word Register */
sfr_b(UCB0BRW_L);
sfr_b(UCB0BRW_H);
sfr_w(UCB0STATW);                             /* eUSCI_Bx Status Register */
sfr_b(UCB0STATW_L);
sfr_b(UCB0STATW_H);
sfr_w(UCB0TBCNT);                             /* eUSCI_Bx Byte Counter Threshold Register */
sfr_b(UCB0TBCNT_L);
sfr_b(UCB0TBCNT_H);
sfr_w(UCB0RXBUF);                             /* eUSCI_Bx Receive Buffer Register */
sfr_b(UCB0RXBUF_L);
sfr_b(UCB0RXBUF_H);
sfr_w(UCB0TXBUF);                             /* eUSCI_Bx Transmit Buffer Register */
sfr_b(UCB0TXBUF_L);
sfr_b(UCB0TXBUF_H);
sfr_w(UCB0I2COA0);                            /* eUSCI_Bx I2C Own Address 0 Register */
sfr_b(UCB0I2COA0_L);
sfr_b(UCB0I2COA0_H);
sfr_w(UCB0I2COA1);                            /* eUSCI_Bx I2C Own Address 1 Register */
sfr_b(UCB0I2COA1_L);
sfr_b(UCB0I2COA1_H);
sfr_w(UCB0I2COA2);                            /* eUSCI_Bx I2C Own Address 2 Register */
sfr_b(UCB0I2COA2_L);
sfr_b(UCB0I2COA2_H);
sfr_w(UCB0I2COA3);                            /* eUSCI_Bx I2C Own Address 3 Register */
sfr_b(UCB0I2COA3_L);
sfr_b(UCB0I2COA3_H);
sfr_w(UCB0ADDRX);                             /* eUSCI_Bx I2C Received Address Register */
sfr_b(UCB0ADDRX_L);
sfr_b(UCB0ADDRX_H);
sfr_w(UCB0ADDMASK);                           /* eUSCI_Bx I2C Address Mask Register */
sfr_b(UCB0ADDMASK_L);
sfr_b(UCB0ADDMASK_H);
sfr_w(UCB0I2CSA);                             /* eUSCI_Bx I2C Slave Address Register */
sfr_b(UCB0I2CSA_L);
sfr_b(UCB0I2CSA_H);
sfr_w(UCB0IE);                                /* eUSCI_Bx Interrupt Enable Register */
sfr_b(UCB0IE_L);
sfr_b(UCB0IE_H);
sfr_w(UCB0IFG);                               /* eUSCI_Bx Interrupt Flag Register */
sfr_b(UCB0IFG_L);
sfr_b(UCB0IFG_H);
sfr_w(UCB0IV);                                /* eUSCI_Bx Interrupt Vector Register */
sfr_b(UCB0IV_L);
sfr_b(UCB0IV_H);

/* eUSCI_B0 Register Offsets */
#define OFS_UCB0CTLW0                    (0x0000)
#define OFS_UCB0CTLW0_L                  OFS_UCB0CTLW0
#define OFS_UCB0CTLW0_H                  OFS_UCB0CTLW0+1
#define OFS_UCB0CTLW1                    (0x0002)
#define OFS_UCB0CTLW1_L                  OFS_UCB0CTLW1
#define OFS_UCB0CTLW1_H                  OFS_UCB0CTLW1+1
#define OFS_UCB0BRW                      (0x0006)
#define OFS_UCB0BRW_L                    OFS_UCB0BRW
#define OFS_UCB0BRW_H                    OFS_UCB0BRW+1
#define OFS_UCB0STATW                    (0x0008)
#define OFS_UCB0STATW_L                  OFS_UCB0STATW
#define OFS_UCB0STATW_H                  OFS_UCB0STATW+1
#define OFS_UCB0TBCNT                    (0x000A)
#define OFS_UCB0TBCNT_L                  OFS_UCB0TBCNT
#define OFS_UCB0TBCNT_H                  OFS_UCB0TBCNT+1
#define OFS_UCB0RXBUF                    (0x000C)
#define OFS_UCB0RXBUF_L                  OFS_UCB0RXBUF
#define OFS_UCB0RXBUF_H                  OFS_UCB0RXBUF+1
#define OFS_UCB0TXBUF                    (0x000E)
#define OFS_UCB0TXBUF_L                  OFS_UCB0TXBUF
#define OFS_UCB0TXBUF_H                  OFS_UCB0TXBUF+1
#define OFS_UCB0I2COA0                   (0x0014)
#define OFS_UCB0I2COA0_L                 OFS_UCB0I2COA0
#define OFS_UCB0I2COA0_H                 OFS_UCB0I2COA0+1
#define OFS_UCB0I2COA1                   (0x0016)
#define OFS_UCB0I2COA1_L                 OFS_UCB0I2COA1
#define OFS_UCB0I2COA1_H                 OFS_UCB0I2COA1+1
#define OFS_UCB0I2COA2                   (0x0018)
#define OFS_UCB0I2COA2_L                 OFS_UCB0I2COA2
#define OFS_UCB0I2COA2_H                 OFS_UCB0I2COA2+1
#define OFS_UCB0I2COA3                   (0x001A)
#define OFS_UCB0I2COA3_L                 OFS_UCB0I2COA3
#define OFS_UCB0I2COA3_H                 OFS_UCB0I2COA3+1
#define OFS_UCB0ADDRX                    (0x001C)
#define OFS_UCB0ADDRX_L                  OFS_UCB0ADDRX
#define OFS_UCB0ADDRX_H                  OFS_UCB0ADDRX+1
#define OFS_UCB0ADDMASK                  (0x001E)
#define OFS_UCB0ADDMASK_L                OFS_UCB0ADDMASK
#define OFS_UCB0ADDMASK_H                OFS_UCB0ADDMASK+1
#define OFS_UCB0I2CSA                    (0x0020)
#define OFS_UCB0I2CSA_L                  OFS_UCB0I2CSA
#define OFS_UCB0I2CSA_H                  OFS_UCB0I2CSA+1
#define OFS_UCB0IE                       (0x002A)
#define OFS_UCB0IE_L                     OFS_UCB0IE
#define OFS_UCB0IE_H                     OFS_UCB0IE+1
#define OFS_UCB0IFG                      (0x002C)
#define OFS_UCB0IFG_L                    OFS_UCB0IFG
#define OFS_UCB0IFG_H                    OFS_UCB0IFG+1
#define OFS_UCB0IV                       (0x002E)
#define OFS_UCB0IV_L                     OFS_UCB0IV
#define OFS_UCB0IV_H                     OFS_UCB0IV+1

/* eUSCI_B0 Control Bits */

/* UCB0CTLW0 Control Bits */
#define UCTXSTT                          (0x0002)        /* Transmit START condition in master mode */
#define UCTXSTT_L                        (0x0002)
#define UCTXSTT_0                        (0x0000)        /* Do not generate START condition */
#define UCTXSTT_1                        (0x0002)        /* Generate START condition */
#define UCTXSTT_1_L                      (0x0002)
#define UCTXSTP                          (0x0004)        /* Transmit STOP condition in master mode */
#define UCTXSTP_L                        (0x0004)
#define UCTXSTP_0                        (0x0000)        /* No STOP generated */
#define UCTXSTP_1                        (0x0004)        /* Generate STOP */
#define UCTXSTP_1_L                      (0x0004)
#define UCTXNACK                         (0x0008)        /* Transmit a NACK */
#define UCTXNACK_L                       (0x0008)
#define UCTXNACK_0                       (0x0000)        /* Acknowledge normally */
#define UCTXNACK_1                       (0x0008)        /* Generate NACK */
#define UCTXNACK_1_L                     (0x0008)
#define UCTR                             (0x0010)        /* Transmitter/receiver */
#define UCTR_L                           (0x0010)
#define UCTR_0                           (0x0000)        /* Receiver */
#define UCTR_1                           (0x0010)        /* Transmitter */
#define UCTR_1_L                         (0x0010)
#define UCTR__RX                         (0x0000)        /* Receiver */
#define UCTR__TX                         (0x0010)        /* Transmitter */
#define UCTR__TX_L                       (0x0010)
#define UCTXACK                          (0x0020)        /* Transmit ACK condition in slave mode */
#define UCTXACK_L                        (0x0020)
#define UCTXACK_0                        (0x0000)        /* Do not acknowledge the slave address */
#define UCTXACK_1                        (0x0020)        /* Acknowledge the slave address */
#define UCTXACK_1_L                      (0x0020)
#define UCSSEL_3                         (0x00c0)        /* SMCLK */
#define UCSSEL_3_L                       (0x00c0)
#define UCSSEL__UCLKI                    (0x0000)        /* UCLKI */
#define UCMM                             (0x2000)        /* Multi-master environment select */
#define UCMM_H                           (0x0020)
#define UCMM_0                           (0x0000)        /* Single master environment. There is no other master in the 
                                                            system. The address compare unit is disabled. */
#define UCMM_1                           (0x2000)        /* Multi-master environment */
#define UCMM_1_H                         (0x0020)
#define UCMM__SINGLE                     (0x0000)        /* Single master environment. There is no other master in the 
                                                            system. The address compare unit is disabled. */
#define UCMM__MULTI                      (0x2000)        /* Multi-master environment */
#define UCMM__MULTI_H                    (0x0020)
#define UCSLA10                          (0x4000)        /* Slave addressing mode select */
#define UCSLA10_H                        (0x0040)
#define UCSLA10_0                        (0x0000)        /* Address slave with 7-bit address */
#define UCSLA10_1                        (0x4000)        /* Address slave with 10-bit address */
#define UCSLA10_1_H                      (0x0040)
#define UCSLA10__7BIT                    (0x0000)        /* Address slave with 7-bit address */
#define UCSLA10__10BIT                   (0x4000)        /* Address slave with 10-bit address */
#define UCSLA10__10BIT_H                 (0x0040)
#define UCA10                            (0x8000)        /* Own addressing mode select */
#define UCA10_H                          (0x0080)
#define UCA10_0                          (0x0000)        /* Own address is a 7-bit address */
#define UCA10_1                          (0x8000)        /* Own address is a 10-bit address */
#define UCA10_1_H                        (0x0080)

/* UCB0CTLW1 Control Bits */
#define UCASTP                           (0x000c)        /* Automatic STOP condition generation */
#define UCASTP_L                         (0x000c)
#define UCASTP0                          (0x0004)        /* Automatic STOP condition generation */
#define UCASTP0_L                        (0x0004)
#define UCASTP1                          (0x0008)        /* Automatic STOP condition generation */
#define UCASTP1_L                        (0x0008)
#define UCASTP_0                         (0x0000)        /* No automatic STOP generation. The STOP condition is generated 
                                                            after the user sets the UCTXSTP bit. The value in UCBxTBCNT is
                                                            a don't care. */
#define UCASTP_1                         (0x0004)        /* UCBCNTIFG is set with the byte counter reaches the threshold 
                                                            defined in UCBxTBCNT */
#define UCASTP_1_L                       (0x0004)
#define UCASTP_2                         (0x0008)        /* A STOP condition is generated automatically after the byte 
                                                            counter value reached UCBxTBCNT. UCBCNTIFG is set with the 
                                                            byte counter reaching the threshold */
#define UCASTP_2_L                       (0x0008)
#define UCSWACK                          (0x0010)        /* SW or HW ACK control */
#define UCSWACK_L                        (0x0010)
#define UCSWACK_0                        (0x0000)        /* The address acknowledge of the slave is controlled by the 
                                                            eUSCI_B module */
#define UCSWACK_1                        (0x0010)        /* The user needs to trigger the sending of the address ACK by 
                                                            issuing UCTXACK */
#define UCSWACK_1_L                      (0x0010)
#define UCSTPNACK                        (0x0020)        /* ACK all master bytes */
#define UCSTPNACK_L                      (0x0020)
#define UCSTPNACK_0                      (0x0000)        /* Send a non-acknowledge before the STOP condition as a master 
                                                            receiver (conform to I2C standard) */
#define UCSTPNACK_1                      (0x0020)        /* All bytes are acknowledged by the eUSCI_B when configured as 
                                                            master receiver */
#define UCSTPNACK_1_L                    (0x0020)
#define UCCLTO                           (0x00c0)        /* Clock low timeout select */
#define UCCLTO_L                         (0x00c0)
#define UCCLTO0                          (0x0040)        /* Clock low timeout select */
#define UCCLTO0_L                        (0x0040)
#define UCCLTO1                          (0x0080)        /* Clock low timeout select */
#define UCCLTO1_L                        (0x0080)
#define UCCLTO_0                         (0x0000)        /* Disable clock low timeout counter */
#define UCCLTO_1                         (0x0040)        /* 135 000 SYSCLK cycles (approximately 28 ms) */
#define UCCLTO_1_L                       (0x0040)
#define UCCLTO_2                         (0x0080)        /* 150 000 SYSCLK cycles (approximately 31 ms) */
#define UCCLTO_2_L                       (0x0080)
#define UCCLTO_3                         (0x00c0)        /* 165 000 SYSCLK cycles (approximately 34 ms) */
#define UCCLTO_3_L                       (0x00c0)
#define UCETXINT                         (0x0100)        /* Early UCTXIFG0 */
#define UCETXINT_H                       (0x0001)
#define UCETXINT_0                       (0x0000)        /* UCTXIFGx is set after an address match with UCxI2COAx and the 
                                                            direction bit indicating slave transmit */
#define UCETXINT_1                       (0x0100)        /* UCTXIFG0 is set for each START condition */
#define UCETXINT_1_H                     (0x0001)

/* UCB0STATW Control Bits */
#define UCBBUSY                          (0x0010)        /* Bus busy */
#define UCBBUSY_L                        (0x0010)
#define UCBBUSY_0                        (0x0000)        /* Bus inactive */
#define UCBBUSY_1                        (0x0010)        /* Bus busy */
#define UCBBUSY_1_L                      (0x0010)
#define UCBBUSY__IDLE                    (0x0000)        /* Bus inactive */
#define UCBBUSY__BUSY                    (0x0010)        /* Bus busy */
#define UCBBUSY__BUSY_L                  (0x0010)
#define UCGC                             (0x0020)        /* General call address received */
#define UCGC_L                           (0x0020)
#define UCGC_0                           (0x0000)        /* No general call address received */
#define UCGC_1                           (0x0020)        /* General call address received */
#define UCGC_1_L                         (0x0020)
#define UCSCLLOW                         (0x0040)        /* SCL low */
#define UCSCLLOW_L                       (0x0040)
#define UCSCLLOW_0                       (0x0000)        /* SCL is not held low */
#define UCSCLLOW_1                       (0x0040)        /* SCL is held low */
#define UCSCLLOW_1_L                     (0x0040)
#define UCBCNT                           (0xff00)        /* Hardware byte counter value */
#define UCBCNT_H                         (0x00ff)
#define UCBCNT0                          (0x0100)        /* Hardware byte counter value */
#define UCBCNT0_H                        (0x0001)
#define UCBCNT1                          (0x0200)        /* Hardware byte counter value */
#define UCBCNT1_H                        (0x0002)
#define UCBCNT2                          (0x0400)        /* Hardware byte counter value */
#define UCBCNT2_H                        (0x0004)
#define UCBCNT3                          (0x0800)        /* Hardware byte counter value */
#define UCBCNT3_H                        (0x0008)
#define UCBCNT4                          (0x1000)        /* Hardware byte counter value */
#define UCBCNT4_H                        (0x0010)
#define UCBCNT5                          (0x2000)        /* Hardware byte counter value */
#define UCBCNT5_H                        (0x0020)
#define UCBCNT6                          (0x4000)        /* Hardware byte counter value */
#define UCBCNT6_H                        (0x0040)
#define UCBCNT7                          (0x8000)        /* Hardware byte counter value */
#define UCBCNT7_H                        (0x0080)

/* UCB0TBCNT Control Bits */
#define UCTBCNT                          (0x00ff)        /* Byte counter threshold value */
#define UCTBCNT_L                        (0x00ff)
#define UCTBCNT0                         (0x0001)        /* Byte counter threshold value */
#define UCTBCNT0_L                       (0x0001)
#define UCTBCNT1                         (0x0002)        /* Byte counter threshold value */
#define UCTBCNT1_L                       (0x0002)
#define UCTBCNT2                         (0x0004)        /* Byte counter threshold value */
#define UCTBCNT2_L                       (0x0004)
#define UCTBCNT3                         (0x0008)        /* Byte counter threshold value */
#define UCTBCNT3_L                       (0x0008)
#define UCTBCNT4                         (0x0010)        /* Byte counter threshold value */
#define UCTBCNT4_L                       (0x0010)
#define UCTBCNT5                         (0x0020)        /* Byte counter threshold value */
#define UCTBCNT5_L                       (0x0020)
#define UCTBCNT6                         (0x0040)        /* Byte counter threshold value */
#define UCTBCNT6_L                       (0x0040)
#define UCTBCNT7                         (0x0080)        /* Byte counter threshold value */
#define UCTBCNT7_L                       (0x0080)

/* UCB0I2COA0 Control Bits */
#define I2COA0                           (0x03ff)        /* I2C own address */
#define I2COA0_L                         (0x00ff)
#define I2COA0_H                         (0x0003)
#define I2COA00                          (0x0001)        /* I2C own address */
#define I2COA00_L                        (0x0001)
#define I2COA01                          (0x0002)        /* I2C own address */
#define I2COA01_L                        (0x0002)
#define I2COA02                          (0x0004)        /* I2C own address */
#define I2COA02_L                        (0x0004)
#define I2COA03                          (0x0008)        /* I2C own address */
#define I2COA03_L                        (0x0008)
#define I2COA04                          (0x0010)        /* I2C own address */
#define I2COA04_L                        (0x0010)
#define I2COA05                          (0x0020)        /* I2C own address */
#define I2COA05_L                        (0x0020)
#define I2COA06                          (0x0040)        /* I2C own address */
#define I2COA06_L                        (0x0040)
#define I2COA07                          (0x0080)        /* I2C own address */
#define I2COA07_L                        (0x0080)
#define I2COA08                          (0x0100)        /* I2C own address */
#define I2COA08_H                        (0x0001)
#define I2COA09                          (0x0200)        /* I2C own address */
#define I2COA09_H                        (0x0002)
#define UCOAEN                           (0x0400)        /* Own Address enable register */
#define UCOAEN_H                         (0x0004)
#define UCOAEN_0                         (0x0000)        /* The slave address defined in I2COA0 is disabled */
#define UCOAEN_1                         (0x0400)        /* The slave address defined in I2COA0 is enabled */
#define UCOAEN_1_H                       (0x0004)
#define UCOAEN__DISABLE                  (0x0000)        /* The slave address defined in I2COA0 is disabled */
#define UCOAEN__ENABLE                   (0x0400)        /* The slave address defined in I2COA0 is enabled */
#define UCOAEN__ENABLE_H                 (0x0004)
#define UCGCEN                           (0x8000)        /* General call response enable */
#define UCGCEN_H                         (0x0080)
#define UCGCEN_0                         (0x0000)        /* Do not respond to a general call */
#define UCGCEN_1                         (0x8000)        /* Respond to a general call */
#define UCGCEN_1_H                       (0x0080)

/* UCB0I2COA1 Control Bits */
#define I2COA1                           (0x03ff)        /* I2C own address */
#define I2COA1_L                         (0x00ff)
#define I2COA1_H                         (0x0003)
#define I2COA10                          (0x0001)        /* I2C own address */
#define I2COA10_L                        (0x0001)
#define I2COA11                          (0x0002)        /* I2C own address */
#define I2COA11_L                        (0x0002)
#define I2COA12                          (0x0004)        /* I2C own address */
#define I2COA12_L                        (0x0004)
#define I2COA13                          (0x0008)        /* I2C own address */
#define I2COA13_L                        (0x0008)
#define I2COA14                          (0x0010)        /* I2C own address */
#define I2COA14_L                        (0x0010)
#define I2COA15                          (0x0020)        /* I2C own address */
#define I2COA15_L                        (0x0020)
#define I2COA16                          (0x0040)        /* I2C own address */
#define I2COA16_L                        (0x0040)
#define I2COA17                          (0x0080)        /* I2C own address */
#define I2COA17_L                        (0x0080)
#define I2COA18                          (0x0100)        /* I2C own address */
#define I2COA18_H                        (0x0001)
#define I2COA19                          (0x0200)        /* I2C own address */
#define I2COA19_H                        (0x0002)

/* UCB0I2COA2 Control Bits */
#define I2COA2                           (0x03ff)        /* I2C own address */
#define I2COA2_L                         (0x00ff)
#define I2COA2_H                         (0x0003)
#define I2COA20                          (0x0001)        /* I2C own address */
#define I2COA20_L                        (0x0001)
#define I2COA21                          (0x0002)        /* I2C own address */
#define I2COA21_L                        (0x0002)
#define I2COA22                          (0x0004)        /* I2C own address */
#define I2COA22_L                        (0x0004)
#define I2COA23                          (0x0008)        /* I2C own address */
#define I2COA23_L                        (0x0008)
#define I2COA24                          (0x0010)        /* I2C own address */
#define I2COA24_L                        (0x0010)
#define I2COA25                          (0x0020)        /* I2C own address */
#define I2COA25_L                        (0x0020)
#define I2COA26                          (0x0040)        /* I2C own address */
#define I2COA26_L                        (0x0040)
#define I2COA27                          (0x0080)        /* I2C own address */
#define I2COA27_L                        (0x0080)
#define I2COA28                          (0x0100)        /* I2C own address */
#define I2COA28_H                        (0x0001)
#define I2COA29                          (0x0200)        /* I2C own address */
#define I2COA29_H                        (0x0002)

/* UCB0I2COA3 Control Bits */
#define I2COA3                           (0x03ff)        /* I2C own address */
#define I2COA3_L                         (0x00ff)
#define I2COA3_H                         (0x0003)
#define I2COA30                          (0x0001)        /* I2C own address */
#define I2COA30_L                        (0x0001)
#define I2COA31                          (0x0002)        /* I2C own address */
#define I2COA31_L                        (0x0002)
#define I2COA32                          (0x0004)        /* I2C own address */
#define I2COA32_L                        (0x0004)
#define I2COA33                          (0x0008)        /* I2C own address */
#define I2COA33_L                        (0x0008)
#define I2COA34                          (0x0010)        /* I2C own address */
#define I2COA34_L                        (0x0010)
#define I2COA35                          (0x0020)        /* I2C own address */
#define I2COA35_L                        (0x0020)
#define I2COA36                          (0x0040)        /* I2C own address */
#define I2COA36_L                        (0x0040)
#define I2COA37                          (0x0080)        /* I2C own address */
#define I2COA37_L                        (0x0080)
#define I2COA38                          (0x0100)        /* I2C own address */
#define I2COA38_H                        (0x0001)
#define I2COA39                          (0x0200)        /* I2C own address */
#define I2COA39_H                        (0x0002)

/* UCB0ADDRX Control Bits */
#define ADDRX                            (0x03ff)        /* Received Address Register */
#define ADDRX_L                          (0x00ff)
#define ADDRX_H                          (0x0003)
#define ADDRX0                           (0x0001)        /* Received Address Register */
#define ADDRX0_L                         (0x0001)
#define ADDRX1                           (0x0002)        /* Received Address Register */
#define ADDRX1_L                         (0x0002)
#define ADDRX2                           (0x0004)        /* Received Address Register */
#define ADDRX2_L                         (0x0004)
#define ADDRX3                           (0x0008)        /* Received Address Register */
#define ADDRX3_L                         (0x0008)
#define ADDRX4                           (0x0010)        /* Received Address Register */
#define ADDRX4_L                         (0x0010)
#define ADDRX5                           (0x0020)        /* Received Address Register */
#define ADDRX5_L                         (0x0020)
#define ADDRX6                           (0x0040)        /* Received Address Register */
#define ADDRX6_L                         (0x0040)
#define ADDRX7                           (0x0080)        /* Received Address Register */
#define ADDRX7_L                         (0x0080)
#define ADDRX8                           (0x0100)        /* Received Address Register */
#define ADDRX8_H                         (0x0001)
#define ADDRX9                           (0x0200)        /* Received Address Register */
#define ADDRX9_H                         (0x0002)

/* UCB0ADDMASK Control Bits */
#define ADDMASK                          (0x03ff)        /* */
#define ADDMASK_L                        (0x00ff)
#define ADDMASK_H                        (0x0003)
#define ADDMASK0                         (0x0001)        /* */
#define ADDMASK0_L                       (0x0001)
#define ADDMASK1                         (0x0002)        /* */
#define ADDMASK1_L                       (0x0002)
#define ADDMASK2                         (0x0004)        /* */
#define ADDMASK2_L                       (0x0004)
#define ADDMASK3                         (0x0008)        /* */
#define ADDMASK3_L                       (0x0008)
#define ADDMASK4                         (0x0010)        /* */
#define ADDMASK4_L                       (0x0010)
#define ADDMASK5                         (0x0020)        /* */
#define ADDMASK5_L                       (0x0020)
#define ADDMASK6                         (0x0040)        /* */
#define ADDMASK6_L                       (0x0040)
#define ADDMASK7                         (0x0080)        /* */
#define ADDMASK7_L                       (0x0080)
#define ADDMASK8                         (0x0100)        /* */
#define ADDMASK8_H                       (0x0001)
#define ADDMASK9                         (0x0200)        /* */
#define ADDMASK9_H                       (0x0002)

/* UCB0I2CSA Control Bits */
#define I2CSA                            (0x03ff)        /* I2C slave address */
#define I2CSA_L                          (0x00ff)
#define I2CSA_H                          (0x0003)
#define I2CSA0                           (0x0001)        /* I2C slave address */
#define I2CSA0_L                         (0x0001)
#define I2CSA1                           (0x0002)        /* I2C slave address */
#define I2CSA1_L                         (0x0002)
#define I2CSA2                           (0x0004)        /* I2C slave address */
#define I2CSA2_L                         (0x0004)
#define I2CSA3                           (0x0008)        /* I2C slave address */
#define I2CSA3_L                         (0x0008)
#define I2CSA4                           (0x0010)        /* I2C slave address */
#define I2CSA4_L                         (0x0010)
#define I2CSA5                           (0x0020)        /* I2C slave address */
#define I2CSA5_L                         (0x0020)
#define I2CSA6                           (0x0040)        /* I2C slave address */
#define I2CSA6_L                         (0x0040)
#define I2CSA7                           (0x0080)        /* I2C slave address */
#define I2CSA7_L                         (0x0080)
#define I2CSA8                           (0x0100)        /* I2C slave address */
#define I2CSA8_H                         (0x0001)
#define I2CSA9                           (0x0200)        /* I2C slave address */
#define I2CSA9_H                         (0x0002)

/* UCB0IE Control Bits */
#define UCRXIE0                          (0x0001)        /* Receive interrupt enable 0 */
#define UCRXIE0_L                        (0x0001)
#define UCRXIE0_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE0_1                        (0x0001)        /* Interrupt enabled */
#define UCRXIE0_1_L                      (0x0001)
#define UCTXIE0                          (0x0002)        /* Transmit interrupt enable 0 */
#define UCTXIE0_L                        (0x0002)
#define UCTXIE0_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE0_1                        (0x0002)        /* Interrupt enabled */
#define UCTXIE0_1_L                      (0x0002)
#define UCSTPIE                          (0x0008)        /* STOP condition interrupt enable */
#define UCSTPIE_L                        (0x0008)
#define UCSTPIE_0                        (0x0000)        /* Interrupt disabled */
#define UCSTPIE_1                        (0x0008)        /* Interrupt enabled */
#define UCSTPIE_1_L                      (0x0008)
#define UCALIE                           (0x0010)        /* Arbitration lost interrupt enable */
#define UCALIE_L                         (0x0010)
#define UCALIE_0                         (0x0000)        /* Interrupt disabled */
#define UCALIE_1                         (0x0010)        /* Interrupt enabled */
#define UCALIE_1_L                       (0x0010)
#define UCNACKIE                         (0x0020)        /* Not-acknowledge interrupt enable */
#define UCNACKIE_L                       (0x0020)
#define UCNACKIE_0                       (0x0000)        /* Interrupt disabled */
#define UCNACKIE_1                       (0x0020)        /* Interrupt enabled */
#define UCNACKIE_1_L                     (0x0020)
#define UCBCNTIE                         (0x0040)        /* Byte counter interrupt enable */
#define UCBCNTIE_L                       (0x0040)
#define UCBCNTIE_0                       (0x0000)        /* Interrupt disabled */
#define UCBCNTIE_1                       (0x0040)        /* Interrupt enabled */
#define UCBCNTIE_1_L                     (0x0040)
#define UCCLTOIE                         (0x0080)        /* Clock low timeout interrupt enable */
#define UCCLTOIE_L                       (0x0080)
#define UCCLTOIE_0                       (0x0000)        /* Interrupt disabled */
#define UCCLTOIE_1                       (0x0080)        /* Interrupt enabled */
#define UCCLTOIE_1_L                     (0x0080)
#define UCRXIE1                          (0x0100)        /* Receive interrupt enable 1 */
#define UCRXIE1_H                        (0x0001)
#define UCRXIE1_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE1_1                        (0x0100)        /* Interrupt enabled */
#define UCRXIE1_1_H                      (0x0001)
#define UCTXIE1                          (0x0200)        /* Transmit interrupt enable 1 */
#define UCTXIE1_H                        (0x0002)
#define UCTXIE1_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE1_1                        (0x0200)        /* Interrupt enabled */
#define UCTXIE1_1_H                      (0x0002)
#define UCRXIE2                          (0x0400)        /* Receive interrupt enable 2 */
#define UCRXIE2_H                        (0x0004)
#define UCRXIE2_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE2_1                        (0x0400)        /* Interrupt enabled */
#define UCRXIE2_1_H                      (0x0004)
#define UCTXIE2                          (0x0800)        /* Transmit interrupt enable 2 */
#define UCTXIE2_H                        (0x0008)
#define UCTXIE2_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE2_1                        (0x0800)        /* Interrupt enabled */
#define UCTXIE2_1_H                      (0x0008)
#define UCRXIE3                          (0x1000)        /* Receive interrupt enable 3 */
#define UCRXIE3_H                        (0x0010)
#define UCRXIE3_0                        (0x0000)        /* Interrupt disabled */
#define UCRXIE3_1                        (0x1000)        /* Interrupt enabled */
#define UCRXIE3_1_H                      (0x0010)
#define UCTXIE3                          (0x2000)        /* Transmit interrupt enable 3 */
#define UCTXIE3_H                        (0x0020)
#define UCTXIE3_0                        (0x0000)        /* Interrupt disabled */
#define UCTXIE3_1                        (0x2000)        /* Interrupt enabled */
#define UCTXIE3_1_H                      (0x0020)
#define UCBIT9IE                         (0x4000)        /* Bit position 9 interrupt enable */
#define UCBIT9IE_H                       (0x0040)
#define UCBIT9IE_0                       (0x0000)        /* Interrupt disabled */
#define UCBIT9IE_1                       (0x4000)        /* Interrupt enabled */
#define UCBIT9IE_1_H                     (0x0040)

/* UCB0IFG Control Bits */
#define UCRXIFG0                         (0x0001)        /* eUSCI_B receive interrupt flag 0 */
#define UCRXIFG0_L                       (0x0001)
#define UCRXIFG0_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG0_1                       (0x0001)        /* Interrupt pending */
#define UCRXIFG0_1_L                     (0x0001)
#define UCTXIFG0                         (0x0002)        /* eUSCI_B transmit interrupt flag 0 */
#define UCTXIFG0_L                       (0x0002)
#define UCTXIFG0_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG0_1                       (0x0002)        /* Interrupt pending */
#define UCTXIFG0_1_L                     (0x0002)
#define UCSTPIFG                         (0x0008)        /* STOP condition interrupt flag */
#define UCSTPIFG_L                       (0x0008)
#define UCSTPIFG_0                       (0x0000)        /* No interrupt pending */
#define UCSTPIFG_1                       (0x0008)        /* Interrupt pending */
#define UCSTPIFG_1_L                     (0x0008)
#define UCALIFG                          (0x0010)        /* Arbitration lost interrupt flag */
#define UCALIFG_L                        (0x0010)
#define UCALIFG_0                        (0x0000)        /* No interrupt pending */
#define UCALIFG_1                        (0x0010)        /* Interrupt pending */
#define UCALIFG_1_L                      (0x0010)
#define UCNACKIFG                        (0x0020)        /* Not-acknowledge received interrupt flag */
#define UCNACKIFG_L                      (0x0020)
#define UCNACKIFG_0                      (0x0000)        /* No interrupt pending */
#define UCNACKIFG_1                      (0x0020)        /* Interrupt pending */
#define UCNACKIFG_1_L                    (0x0020)
#define UCBCNTIFG                        (0x0040)        /* Byte counter interrupt flag */
#define UCBCNTIFG_L                      (0x0040)
#define UCBCNTIFG_0                      (0x0000)        /* No interrupt pending */
#define UCBCNTIFG_1                      (0x0040)        /* Interrupt pending */
#define UCBCNTIFG_1_L                    (0x0040)
#define UCCLTOIFG                        (0x0080)        /* Clock low timeout interrupt flag */
#define UCCLTOIFG_L                      (0x0080)
#define UCCLTOIFG_0                      (0x0000)        /* No interrupt pending */
#define UCCLTOIFG_1                      (0x0080)        /* Interrupt pending */
#define UCCLTOIFG_1_L                    (0x0080)
#define UCRXIFG1                         (0x0100)        /* eUSCI_B receive interrupt flag 1 */
#define UCRXIFG1_H                       (0x0001)
#define UCRXIFG1_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG1_1                       (0x0100)        /* Interrupt pending */
#define UCRXIFG1_1_H                     (0x0001)
#define UCTXIFG1                         (0x0200)        /* eUSCI_B transmit interrupt flag 1 */
#define UCTXIFG1_H                       (0x0002)
#define UCTXIFG1_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG1_1                       (0x0200)        /* Interrupt pending */
#define UCTXIFG1_1_H                     (0x0002)
#define UCRXIFG2                         (0x0400)        /* eUSCI_B receive interrupt flag 2 */
#define UCRXIFG2_H                       (0x0004)
#define UCRXIFG2_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG2_1                       (0x0400)        /* Interrupt pending */
#define UCRXIFG2_1_H                     (0x0004)
#define UCTXIFG2                         (0x0800)        /* eUSCI_B transmit interrupt flag 2 */
#define UCTXIFG2_H                       (0x0008)
#define UCTXIFG2_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG2_1                       (0x0800)        /* Interrupt pending */
#define UCTXIFG2_1_H                     (0x0008)
#define UCRXIFG3                         (0x1000)        /* eUSCI_B receive interrupt flag 3 */
#define UCRXIFG3_H                       (0x0010)
#define UCRXIFG3_0                       (0x0000)        /* No interrupt pending */
#define UCRXIFG3_1                       (0x1000)        /* Interrupt pending */
#define UCRXIFG3_1_H                     (0x0010)
#define UCTXIFG3                         (0x2000)        /* eUSCI_B transmit interrupt flag 3 */
#define UCTXIFG3_H                       (0x0020)
#define UCTXIFG3_0                       (0x0000)        /* No interrupt pending */
#define UCTXIFG3_1                       (0x2000)        /* Interrupt pending */
#define UCTXIFG3_1_H                     (0x0020)
#define UCBIT9IFG                        (0x4000)        /* Bit position 9 interrupt flag */
#define UCBIT9IFG_H                      (0x0040)
#define UCBIT9IFG_0                      (0x0000)        /* No interrupt pending */
#define UCBIT9IFG_1                      (0x4000)        /* Interrupt pending */
#define UCBIT9IFG_1_H                    (0x0040)

/* UCB0IV Control Bits */
#define UCIV_10                          (0x000a)        /* Interrupt Source: Slave 3 Data received; Interrupt Flag: 
                                                            UCRXIFG3 */
#define UCIV_10_L                        (0x000a)
#define UCIV_12                          (0x000c)        /* Interrupt Source: Slave 3 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG3 */
#define UCIV_12_L                        (0x000c)
#define UCIV_14                          (0x000e)        /* Interrupt Source: Slave 2 Data received; Interrupt Flag: 
                                                            UCRXIFG2 */
#define UCIV_14_L                        (0x000e)
#define UCIV_16                          (0x0010)        /* Interrupt Source: Slave 2 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG2 */
#define UCIV_16_L                        (0x0010)
#define UCIV_18                          (0x0012)        /* Interrupt Source: Slave 1 Data received; Interrupt Flag: 
                                                            UCRXIFG1 */
#define UCIV_18_L                        (0x0012)
#define UCIV_20                          (0x0014)        /* Interrupt Source: Slave 1 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG1 */
#define UCIV_20_L                        (0x0014)
#define UCIV_22                          (0x0016)        /* Interrupt Source: Data received; Interrupt Flag: UCRXIFG0 */
#define UCIV_22_L                        (0x0016)
#define UCIV_24                          (0x0018)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG0 */
#define UCIV_24_L                        (0x0018)
#define UCIV_26                          (0x001a)        /* Interrupt Source: Byte counter zero; Interrupt Flag: UCBCNTIFG */
#define UCIV_26_L                        (0x001a)
#define UCIV_28                          (0x001c)        /* Interrupt Source: Clock low timeout; Interrupt Flag: UCCLTOIFG */
#define UCIV_28_L                        (0x001c)
#define UCIV_30                          (0x001e)        /* Interrupt Source: Nineth bit position; Interrupt Flag: 
                                                            UCBIT9IFG; Priority: Lowest */
#define UCIV_30_L                        (0x001e)
#define UCIV__UCALIFG                    (0x0002)        /* Interrupt Source: Arbitration lost; Interrupt Flag: UCALIFG; 
                                                            Interrupt Priority: Highest */
#define UCIV__UCALIFG_L                  (0x0002)
#define UCIV__UCNACKIFG                  (0x0004)        /* Interrupt Source: Not acknowledgment; Interrupt Flag: 
                                                            UCNACKIFG */
#define UCIV__UCNACKIFG_L                (0x0004)
#define UCIV__UCSTPIFG                   (0x0008)        /* Interrupt Source: Stop condition received; Interrupt Flag: 
                                                            UCSTPIFG */
#define UCIV__UCSTPIFG_L                 (0x0008)
#define UCIV__UCRXIFG3                   (0x000a)        /* Interrupt Source: Slave 3 Data received; Interrupt Flag: 
                                                            UCRXIFG3 */
#define UCIV__UCRXIFG3_L                 (0x000a)
#define UCIV__UCTXIFG3                   (0x000c)        /* Interrupt Source: Slave 3 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG3 */
#define UCIV__UCTXIFG3_L                 (0x000c)
#define UCIV__UCRXIFG2                   (0x000e)        /* Interrupt Source: Slave 2 Data received; Interrupt Flag: 
                                                            UCRXIFG2 */
#define UCIV__UCRXIFG2_L                 (0x000e)
#define UCIV__UCTXIFG2                   (0x0010)        /* Interrupt Source: Slave 2 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG2 */
#define UCIV__UCTXIFG2_L                 (0x0010)
#define UCIV__UCRXIFG1                   (0x0012)        /* Interrupt Source: Slave 1 Data received; Interrupt Flag: 
                                                            UCRXIFG1 */
#define UCIV__UCRXIFG1_L                 (0x0012)
#define UCIV__UCTXIFG1                   (0x0014)        /* Interrupt Source: Slave 1 Transmit buffer empty; Interrupt 
                                                            Flag: UCTXIFG1 */
#define UCIV__UCTXIFG1_L                 (0x0014)
#define UCIV__UCRXIFG0                   (0x0016)        /* Interrupt Source: Data received; Interrupt Flag: UCRXIFG0 */
#define UCIV__UCRXIFG0_L                 (0x0016)
#define UCIV__UCTXIFG0                   (0x0018)        /* Interrupt Source: Transmit buffer empty; Interrupt Flag: 
                                                            UCTXIFG0 */
#define UCIV__UCTXIFG0_L                 (0x0018)
#define UCIV__UCBCNTIFG                  (0x001a)        /* Interrupt Source: Byte counter zero; Interrupt Flag: UCBCNTIFG */
#define UCIV__UCBCNTIFG_L                (0x001a)
#define UCIV__UCCLTOIFG                  (0x001c)        /* Interrupt Source: Clock low timeout; Interrupt Flag: UCCLTOIFG */
#define UCIV__UCCLTOIFG_L                (0x001c)
#define UCIV__UCBIT9IFG                  (0x001e)        /* Interrupt Source: Nineth bit position; Interrupt Flag: 
                                                            UCBIT9IFG; Priority: Lowest */
#define UCIV__UCBIT9IFG_L                (0x001e)


/*****************************************************************************
 eUSCI_B1 Registers
*****************************************************************************/

#define __MSP430_HAS_EUSCI_B1__               /* Definition to show that module is available */
#ifndef __MSP430_HAS_EUSCI_Bx__
#define __MSP430_HAS_EUSCI_Bx__
#endif
#define __MSP430_BASEADDRESS_EUSCI_B1__ 0x0680
#define EUSCI_B1_BASE          __MSP430_BASEADDRESS_EUSCI_B1__

sfr_w(UCB1CTLW0);                             /* eUSCI_Bx Control Word Register 0 */
sfr_b(UCB1CTLW0_L);
sfr_b(UCB1CTLW0_H);
sfr_w(UCB1CTLW1);                             /* eUSCI_Bx Control Word Register 1 */
sfr_b(UCB1CTLW1_L);
sfr_b(UCB1CTLW1_H);
sfr_w(UCB1BRW);                               /* eUSCI_Bx Baud Rate Control Word Register */
sfr_b(UCB1BRW_L);
sfr_b(UCB1BRW_H);
sfr_w(UCB1STATW);                             /* eUSCI_Bx Status Register */
sfr_b(UCB1STATW_L);
sfr_b(UCB1STATW_H);
sfr_w(UCB1TBCNT);                             /* eUSCI_Bx Byte Counter Threshold Register */
sfr_b(UCB1TBCNT_L);
sfr_b(UCB1TBCNT_H);
sfr_w(UCB1RXBUF);                             /* eUSCI_Bx Receive Buffer Register */
sfr_b(UCB1RXBUF_L);
sfr_b(UCB1RXBUF_H);
sfr_w(UCB1TXBUF);                             /* eUSCI_Bx Transmit Buffer Register */
sfr_b(UCB1TXBUF_L);
sfr_b(UCB1TXBUF_H);
sfr_w(UCB1I2COA0);                            /* eUSCI_Bx I2C Own Address 0 Register */
sfr_b(UCB1I2COA0_L);
sfr_b(UCB1I2COA0_H);
sfr_w(UCB1I2COA1);                            /* eUSCI_Bx I2C Own Address 1 Register */
sfr_b(UCB1I2COA1_L);
sfr_b(UCB1I2COA1_H);
sfr_w(UCB1I2COA2);                            /* eUSCI_Bx I2C Own Address 2 Register */
sfr_b(UCB1I2COA2_L);
sfr_b(UCB1I2COA2_H);
sfr_w(UCB1I2COA3);                            /* eUSCI_Bx I2C Own Address 3 Register */
sfr_b(UCB1I2COA3_L);
sfr_b(UCB1I2COA3_H);
sfr_w(UCB1ADDRX);                             /* eUSCI_Bx I2C Received Address Register */
sfr_b(UCB1ADDRX_L);
sfr_b(UCB1ADDRX_H);
sfr_w(UCB1ADDMASK);                           /* eUSCI_Bx I2C Address Mask Register */
sfr_b(UCB1ADDMASK_L);
sfr_b(UCB1ADDMASK_H);
sfr_w(UCB1I2CSA);                             /* eUSCI_Bx I2C Slave Address Register */
sfr_b(UCB1I2CSA_L);
sfr_b(UCB1I2CSA_H);
sfr_w(UCB1IE);                                /* eUSCI_Bx Interrupt Enable Register */
sfr_b(UCB1IE_L);
sfr_b(UCB1IE_H);
sfr_w(UCB1IFG);                               /* eUSCI_Bx Interrupt Flag Register */
sfr_b(UCB1IFG_L);
sfr_b(UCB1IFG_H);
sfr_w(UCB1IV);                                /* eUSCI_Bx Interrupt Vector Register */
sfr_b(UCB1IV_L);
sfr_b(UCB1IV_H);

/* eUSCI_B1 Register Offsets */
#define OFS_UCB1CTLW0                    (0x0000)
#define OFS_UCB1CTLW0_L                  OFS_UCB1CTLW0
#define OFS_UCB1CTLW0_H                  OFS_UCB1CTLW0+1
#define OFS_UCB1CTLW1                    (0x0002)
#define OFS_UCB1CTLW1_L                  OFS_UCB1CTLW1
#define OFS_UCB1CTLW1_H                  OFS_UCB1CTLW1+1
#define OFS_UCB1BRW                      (0x0006)
#define OFS_UCB1BRW_L                    OFS_UCB1BRW
#define OFS_UCB1BRW_H                    OFS_UCB1BRW+1
#define OFS_UCB1STATW                    (0x0008)
#define OFS_UCB1STATW_L                  OFS_UCB1STATW
#define OFS_UCB1STATW_H                  OFS_UCB1STATW+1
#define OFS_UCB1TBCNT                    (0x000A)
#define OFS_UCB1TBCNT_L                  OFS_UCB1TBCNT
#define OFS_UCB1TBCNT_H                  OFS_UCB1TBCNT+1
#define OFS_UCB1RXBUF                    (0x000C)
#define OFS_UCB1RXBUF_L                  OFS_UCB1RXBUF
#define OFS_UCB1RXBUF_H                  OFS_UCB1RXBUF+1
#define OFS_UCB1TXBUF                    (0x000E)
#define OFS_UCB1TXBUF_L                  OFS_UCB1TXBUF
#define OFS_UCB1TXBUF_H                  OFS_UCB1TXBUF+1
#define OFS_UCB1I2COA0                   (0x0014)
#define OFS_UCB1I2COA0_L                 OFS_UCB1I2COA0
#define OFS_UCB1I2COA0_H                 OFS_UCB1I2COA0+1
#define OFS_UCB1I2COA1                   (0x0016)
#define OFS_UCB1I2COA1_L                 OFS_UCB1I2COA1
#define OFS_UCB1I2COA1_H                 OFS_UCB1I2COA1+1
#define OFS_UCB1I2COA2                   (0x0018)
#define OFS_UCB1I2COA2_L                 OFS_UCB1I2COA2
#define OFS_UCB1I2COA2_H                 OFS_UCB1I2COA2+1
#define OFS_UCB1I2COA3                   (0x001A)
#define OFS_UCB1I2COA3_L                 OFS_UCB1I2COA3
#define OFS_UCB1I2COA3_H                 OFS_UCB1I2COA3+1
#define OFS_UCB1ADDRX                    (0x001C)
#define OFS_UCB1ADDRX_L                  OFS_UCB1ADDRX
#define OFS_UCB1ADDRX_H                  OFS_UCB1ADDRX+1
#define OFS_UCB1ADDMASK                  (0x001E)
#define OFS_UCB1ADDMASK_L                OFS_UCB1ADDMASK
#define OFS_UCB1ADDMASK_H                OFS_UCB1ADDMASK+1
#define OFS_UCB1I2CSA                    (0x0020)
#define OFS_UCB1I2CSA_L                  OFS_UCB1I2CSA
#define OFS_UCB1I2CSA_H                  OFS_UCB1I2CSA+1
#define OFS_UCB1IE                       (0x002A)
#define OFS_UCB1IE_L                     OFS_UCB1IE
#define OFS_UCB1IE_H                     OFS_UCB1IE+1
#define OFS_UCB1IFG                      (0x002C)
#define OFS_UCB1IFG_L                    OFS_UCB1IFG
#define OFS_UCB1IFG_H                    OFS_UCB1IFG+1
#define OFS_UCB1IV                       (0x002E)
#define OFS_UCB1IV_L                     OFS_UCB1IV
#define OFS_UCB1IV_H                     OFS_UCB1IV+1

/* No control bits available or already defined for another module */

/************************************************************
* TLV Descriptors
************************************************************/

#define __MSP430_HAS_TLV__                    /* Definition to show that Module is available */

#define TLV_START              (0x1A08)       /* Start Address of the TLV structure */
#define TLV_END                (0x1AFF)       /* End Address of the TLV structure */

#define TLV_LDTAG              (0x01)         /*  Legacy descriptor (1xx, 2xx, 4xx families) */
#define TLV_PDTAG              (0x02)         /*  Peripheral discovery descriptor */
#define TLV_Reserved3          (0x03)         /*  Future usage */
#define TLV_Reserved4          (0x04)         /*  Future usage */
#define TLV_BLANK              (0x05)         /*  Blank descriptor */
#define TLV_Reserved6          (0x06)         /*  Future usage */
#define TLV_Reserved7          (0x07)         /*  Serial Number */
#define TLV_DIERECORD          (0x08)         /*  Die Record  */
#define TLV_ADCCAL             (0x11)         /*  ADC12 calibration */
#define TLV_ADC12CAL           (0x11)         /*  ADC12 calibration */
#define TLV_ADC10CAL           (0x13)         /*  ADC10 calibration */
#define TLV_REFCAL             (0x12)         /*  REF calibration */
#define TLV_TAGEXT             (0xFE)         /*  Tag extender */
#define TLV_TAGEND             (0xFF)         //  Tag End of Table

/************************************************************
* Interrupt Vectors (offset from 0xFF80 + 0x10 for Password)
************************************************************/

#define SDHS_VECTOR            (14)                     /* 0xFFAC */
#define SAPH_VECTOR            (15)                     /* 0xFFAE */
#define HSPLL_VECTOR           (16)                     /* 0xFFB0 */
#define UUPS_VECTOR            (17)                     /* 0xFFB2 */
#define LEA_VECTOR             (18)                     /* 0xFFB4 */
#define PORT9_VECTOR           (19)                     /* 0xFFB6 */
#define PORT8_VECTOR           (20)                     /* 0xFFB8 */
#define PORT7_VECTOR           (21)                     /* 0xFFBA */
#define EUSCI_B1_VECTOR        (22)                     /* 0xFFBC */
#define EUSCI_A3_VECTOR        (23)                     /* 0xFFBE */
#define EUSCI_A2_VECTOR        (24)                     /* 0xFFC0 */
#define PORT6_VECTOR           (25)                     /* 0xFFC2 */
#define PORT5_VECTOR           (26)                     /* 0xFFC4 */
#define TIMER4_A1_VECTOR       (27)                     /* 0xFFC6 */
#define TIMER4_A0_VECTOR       (28)                     /* 0xFFC8 */
#define AES256_VECTOR          (29)                     /* 0xFFCA */
#define RTC_C_VECTOR           (30)                     /* 0xFFCC */
#define LCD_C_VECTOR           (31)                     /* 0xFFCE */
#define PORT4_VECTOR           (32)                     /* 0xFFD0 */
#define PORT3_VECTOR           (33)                     /* 0xFFD2 */
#define TIMER3_A1_VECTOR       (34)                     /* 0xFFD4 */
#define TIMER3_A0_VECTOR       (35)                     /* 0xFFD6 */
#define PORT2_VECTOR           (36)                     /* 0xFFD8 */
#define TIMER2_A1_VECTOR       (37)                     /* 0xFFDA */
#define TIMER2_A0_VECTOR       (38)                     /* 0xFFDC */
#define PORT1_VECTOR           (39)                     /* 0xFFDE */
#define TIMER1_A1_VECTOR       (40)                     /* 0xFFE0 */
#define TIMER1_A0_VECTOR       (41)                     /* 0xFFE2 */
#define DMA_VECTOR             (42)                     /* 0xFFE4 */
#define EUSCI_A1_VECTOR        (43)                     /* 0xFFE6 */
#define TIMER0_A1_VECTOR       (44)                     /* 0xFFE8 */
#define TIMER0_A0_VECTOR       (45)                     /* 0xFFEA */
#define ADC12_B_VECTOR         (46)                     /* 0xFFEC */
#define EUSCI_B0_VECTOR        (47)                     /* 0xFFEE */
#define EUSCI_A0_VECTOR        (48)                     /* 0xFFF0 */
#define WDT_VECTOR             (49)                     /* 0xFFF2 */
#define TIMER0_B1_VECTOR       (50)                     /* 0xFFF4 */
#define TIMER0_B0_VECTOR       (51)                     /* 0xFFF6 */
#define COMP_E_VECTOR          (52)                     /* 0xFFF8 */
#define UNMI_VECTOR            (53)                     /* 0xFFFA */
#define SYSNMI_VECTOR          (54)                     /* 0xFFFC */
#define RESET_VECTOR           ("reset")                /* 0xFFFE Reset (Highest Priority) */


/************************************************************
* Memory Boundary Definitions
************************************************************/

#define TINYRAM_START           0x000A
#define TINYRAM_LENGTH          0x0016
#define BSL_START               0x1000
#define BSL_LENGTH              0x0800
#define CAL_CONF_START          0x1900
#define CAL_CONF_LENGTH         0x0100
#define TLVMEM_START            0x1A00
#define TLVMEM_LENGTH           0x0100
#define BOOTROM_START           0x1B00
#define BOOTROM_LENGTH          0x0100
#define RAM_START               0x1C00
#define RAM_LENGTH              0x1000
#define LEARAM_START            0x2C00
#define LEARAM_LENGTH           0x1000
#define FRAM_START              0x4000
#define FRAM_LENGTH             0x40000

/************************************************************
* End of Modules
************************************************************/

#ifdef __cplusplus
}
#endif /* extern "C" */

#ifndef EXCLUDE_LEGACY
#include "legacy.h"
#endif

#endif /* #ifndef __MSP430FR60471 */


