/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: FuncTransformOps.td                                                  *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::transform::ApplyFuncToLLVMConversionPatternsOp,
::mlir::transform::CastAndCallOp,
::mlir::transform::ReplaceFuncSignatureOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace transform {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_FuncTransformOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::transform::TransformHandleTypeInterface>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TransformHandleTypeInterface instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_FuncTransformOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::transform::TransformValueHandleTypeInterface>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TransformValueHandleTypeInterface instance, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_FuncTransformOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::SymbolRefAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: symbol reference attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_FuncTransformOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::DenseI32ArrayAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: i32 dense array attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_FuncTransformOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_FuncTransformOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_region_constraint_FuncTransformOps1(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((::llvm::hasNItemsOrLess(region, 1)))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: region with at most 1 blocks";
  }
  return ::mlir::success();
}
} // namespace transform
} // namespace mlir
namespace mlir {
namespace transform {

//===----------------------------------------------------------------------===//
// ::mlir::transform::ApplyFuncToLLVMConversionPatternsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase::ApplyFuncToLLVMConversionPatternsOpGenericAdaptorBase(ApplyFuncToLLVMConversionPatternsOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
ApplyFuncToLLVMConversionPatternsOpAdaptor::ApplyFuncToLLVMConversionPatternsOpAdaptor(ApplyFuncToLLVMConversionPatternsOp op) : ApplyFuncToLLVMConversionPatternsOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ApplyFuncToLLVMConversionPatternsOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult ApplyFuncToLLVMConversionPatternsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute ApplyFuncToLLVMConversionPatternsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ApplyFuncToLLVMConversionPatternsOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> ApplyFuncToLLVMConversionPatternsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void ApplyFuncToLLVMConversionPatternsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void ApplyFuncToLLVMConversionPatternsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult ApplyFuncToLLVMConversionPatternsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void ApplyFuncToLLVMConversionPatternsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState) {
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__);
  auto __res__ = ::llvm::dyn_cast<ApplyFuncToLLVMConversionPatternsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::ImplicitLocOpBuilder &builder) {
  return create(builder, builder.getLoc());
}

void ApplyFuncToLLVMConversionPatternsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes) {
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes);
  auto __res__ = ::llvm::dyn_cast<ApplyFuncToLLVMConversionPatternsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes) {
  return create(builder, builder.getLoc(), resultTypes);
}

void ApplyFuncToLLVMConversionPatternsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ApplyFuncToLLVMConversionPatternsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ApplyFuncToLLVMConversionPatternsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ApplyFuncToLLVMConversionPatternsOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ApplyFuncToLLVMConversionPatternsOp ApplyFuncToLLVMConversionPatternsOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ApplyFuncToLLVMConversionPatternsOp::verifyInvariantsImpl() {
  return ::mlir::success();
}

::llvm::LogicalResult ApplyFuncToLLVMConversionPatternsOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ApplyFuncToLLVMConversionPatternsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ApplyFuncToLLVMConversionPatternsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace transform
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::ApplyFuncToLLVMConversionPatternsOp)

namespace mlir {
namespace transform {

//===----------------------------------------------------------------------===//
// ::mlir::transform::CastAndCallOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CastAndCallOpGenericAdaptorBase::CastAndCallOpGenericAdaptorBase(CastAndCallOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> CastAndCallOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::UnitAttr CastAndCallOpGenericAdaptorBase::getInsertAfterAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().insert_after);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool CastAndCallOpGenericAdaptorBase::getInsertAfter() {
  auto attr = getInsertAfterAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::std::optional< ::mlir::SymbolRefAttr > CastAndCallOpGenericAdaptorBase::getFunctionName() {
  auto attr = getFunctionNameAttr();
  return attr ? ::std::optional< ::mlir::SymbolRefAttr >(attr) : (::std::nullopt);
}

} // namespace detail
CastAndCallOpAdaptor::CastAndCallOpAdaptor(CastAndCallOp op) : CastAndCallOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult CastAndCallOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_function_name = getProperties().function_name; (void)tblgen_function_name;
  auto tblgen_insert_after = getProperties().insert_after; (void)tblgen_insert_after;

  if (tblgen_insert_after && !((::llvm::isa<::mlir::UnitAttr>(tblgen_insert_after))))
    return emitError(loc, "'transform.func.cast_and_call' op ""attribute 'insert_after' failed to satisfy constraint: unit attribute");

  if (tblgen_function_name && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_function_name))))
    return emitError(loc, "'transform.func.cast_and_call' op ""attribute 'function_name' failed to satisfy constraint: symbol reference attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CastAndCallOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange CastAndCallOp::getInputsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CastAndCallOp::getOutputsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CastAndCallOp::getFunctionMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult CastAndCallOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.function_name;
       auto attr = dict.get("function_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `function_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.insert_after;
       auto attr = dict.get("insert_after");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `insert_after` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute CastAndCallOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.function_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("function_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.insert_after;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("insert_after",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CastAndCallOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.function_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.insert_after.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> CastAndCallOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "function_name")
      return prop.function_name;

    if (name == "insert_after")
      return prop.insert_after;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void CastAndCallOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "function_name") {
       prop.function_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.function_name)>>(value);
       return;
    }

    if (name == "insert_after") {
       prop.insert_after = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.insert_after)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void CastAndCallOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.function_name) attrs.append("function_name", prop.function_name);

    if (prop.insert_after) attrs.append("insert_after", prop.insert_after);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult CastAndCallOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFunctionNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps2(attr, "function_name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getInsertAfterAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps1(attr, "insert_after", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult CastAndCallOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.function_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.insert_after)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void CastAndCallOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.function_name);

  writer.writeOptionalAttribute(prop.insert_after);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

bool CastAndCallOp::getInsertAfter() {
  auto attr = getInsertAfterAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::std::optional< ::mlir::SymbolRefAttr > CastAndCallOp::getFunctionName() {
  auto attr = getFunctionNameAttr();
  return attr ? ::std::optional< ::mlir::SymbolRefAttr >(attr) : (::std::nullopt);
}

void CastAndCallOp::setInsertAfter(bool attrValue) {
    auto &odsProp = getProperties().insert_after;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void CastAndCallOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  odsState.addOperands(insertion_point);
  if (inputs)
    odsState.addOperands(inputs);
  if (outputs)
    odsState.addOperands(outputs);
  if (function)
    odsState.addOperands(function);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (inputs ? 1 : 0), (outputs ? 1 : 0), (function ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (insert_after) {
    odsState.getOrAddProperties<Properties>().insert_after = insert_after;
  }
  if (function_name) {
    odsState.getOrAddProperties<Properties>().function_name = function_name;
  }
  (void)odsState.addRegion();
  odsState.addTypes(result);
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, insertion_point, insert_after, inputs, outputs, function_name, function);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  return create(builder, builder.getLoc(), result, insertion_point, insert_after, inputs, outputs, function_name, function);
}

void CastAndCallOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  odsState.addOperands(insertion_point);
  if (inputs)
    odsState.addOperands(inputs);
  if (outputs)
    odsState.addOperands(outputs);
  if (function)
    odsState.addOperands(function);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (inputs ? 1 : 0), (outputs ? 1 : 0), (function ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (insert_after) {
    odsState.getOrAddProperties<Properties>().insert_after = insert_after;
  }
  if (function_name) {
    odsState.getOrAddProperties<Properties>().function_name = function_name;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, insertion_point, insert_after, inputs, outputs, function_name, function);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/::mlir::UnitAttr insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  return create(builder, builder.getLoc(), resultTypes, insertion_point, insert_after, inputs, outputs, function_name, function);
}

void CastAndCallOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  odsState.addOperands(insertion_point);
  if (inputs)
    odsState.addOperands(inputs);
  if (outputs)
    odsState.addOperands(outputs);
  if (function)
    odsState.addOperands(function);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (inputs ? 1 : 0), (outputs ? 1 : 0), (function ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (insert_after) {
    odsState.getOrAddProperties<Properties>().insert_after = ((insert_after) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (function_name) {
    odsState.getOrAddProperties<Properties>().function_name = function_name;
  }
  (void)odsState.addRegion();
  odsState.addTypes(result);
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, insertion_point, insert_after, inputs, outputs, function_name, function);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  return create(builder, builder.getLoc(), result, insertion_point, insert_after, inputs, outputs, function_name, function);
}

void CastAndCallOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  odsState.addOperands(insertion_point);
  if (inputs)
    odsState.addOperands(inputs);
  if (outputs)
    odsState.addOperands(outputs);
  if (function)
    odsState.addOperands(function);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (inputs ? 1 : 0), (outputs ? 1 : 0), (function ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (insert_after) {
    odsState.getOrAddProperties<Properties>().insert_after = ((insert_after) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (function_name) {
    odsState.getOrAddProperties<Properties>().function_name = function_name;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, insertion_point, insert_after, inputs, outputs, function_name, function);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value insertion_point, /*optional*/bool insert_after, /*optional*/::mlir::Value inputs, /*optional*/::mlir::Value outputs, /*optional*/::mlir::SymbolRefAttr function_name, /*optional*/::mlir::Value function) {
  return create(builder, builder.getLoc(), resultTypes, insertion_point, insert_after, inputs, outputs, function_name, function);
}

void CastAndCallOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<CastAndCallOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void CastAndCallOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

CastAndCallOp CastAndCallOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<CastAndCallOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CastAndCallOp CastAndCallOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult CastAndCallOp::verifyInvariantsImpl() {
  auto tblgen_function_name = getProperties().function_name; (void)tblgen_function_name;
  auto tblgen_insert_after = getProperties().insert_after; (void)tblgen_insert_after;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps1(*this, tblgen_insert_after, "insert_after")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps2(*this, tblgen_function_name, "function_name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_FuncTransformOps1(*this, region, "conversions", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::llvm::LogicalResult CastAndCallOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CastAndCallOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr function_nameAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> functionOperands;
  ::llvm::SMLoc functionOperandsLoc;
  (void)functionOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> inputsOperands;
  ::llvm::SMLoc inputsOperandsLoc;
  (void)inputsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> outputsOperands;
  ::llvm::SMLoc outputsOperandsLoc;
  (void)outputsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand insertion_pointRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> insertion_pointOperands(&insertion_pointRawOperand, 1);  ::llvm::SMLoc insertion_pointOperandsLoc;
  (void)insertion_pointOperandsLoc;
  std::unique_ptr<::mlir::Region> conversionsRegion = std::make_unique<::mlir::Region>();
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  ::mlir::OptionalParseResult parseResultfunction_nameAttr =
    parser.parseOptionalAttribute(function_nameAttr, parser.getBuilder().getType<::mlir::NoneType>());
  if (parseResultfunction_nameAttr.has_value() && failed(*parseResultfunction_nameAttr))
    return ::mlir::failure();
  if (parseResultfunction_nameAttr.has_value() && succeeded(*parseResultfunction_nameAttr))
  if (function_nameAttr) result.getOrAddProperties<CastAndCallOp::Properties>().function_name = function_nameAttr;
  if (function_nameAttr) {
  }

  {
    functionOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      functionOperands.push_back(operand);
    }
  }
  if (!functionOperands.empty()) {
  }
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  {
    inputsOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      inputsOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  if (::mlir::succeeded(parser.parseOptionalArrow())) {

  {
    outputsOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      outputsOperands.push_back(operand);
    }
  }
  }
  if (::mlir::succeeded(parser.parseOptionalKeyword("after"))) {
    result.getOrAddProperties<CastAndCallOp::Properties>().insert_after = parser.getBuilder().getUnitAttr();  } else {
  if (parser.parseKeyword("before"))
    return ::mlir::failure();
  }

  insertion_pointOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(insertion_pointRawOperand))
    return ::mlir::failure();

  {
     auto parseResult = parser.parseOptionalRegion(*conversionsRegion);
     if (parseResult.has_value() && failed(*parseResult))
       return ::mlir::failure();
  }
  if (!conversionsRegion->empty()) {

  if (conversionsRegion->empty()) conversionsRegion->emplaceBlock();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addRegion(std::move(conversionsRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(inputsOperands.size()), static_cast<int32_t>(outputsOperands.size()), static_cast<int32_t>(functionOperands.size())}), result.getOrAddProperties<CastAndCallOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(::llvm::concat<const ::mlir::OpAsmParser::UnresolvedOperand>(insertion_pointOperands, inputsOperands, outputsOperands, functionOperands), allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CastAndCallOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if (getFunctionNameAttr()) {
    _odsPrinter << ' ';
    _odsPrinter.printAttributeWithoutType(getFunctionNameAttr());
  }
  if (getFunction()) {
    _odsPrinter << ' ';
    if (::mlir::Value value = getFunction())
      _odsPrinter << value;
  }
  if (getInputs()) {
    _odsPrinter << "(";
    if (::mlir::Value value = getInputs())
      _odsPrinter << value;
    _odsPrinter << ")";
  }
  if (getOutputs()) {
    _odsPrinter << ' ' << "->";
    _odsPrinter << ' ';
    if (::mlir::Value value = getOutputs())
      _odsPrinter << value;
  }
  if ((getInsertAfterAttr() && getInsertAfterAttr() != ((false) ? ::mlir::OpBuilder((*this)->getContext()).getUnitAttr() : nullptr))) {
    _odsPrinter << ' ' << "after";
  } else {
    _odsPrinter << ' ' << "before";
  }
  _odsPrinter << ' ';
  _odsPrinter << getInsertionPoint();
  if (!getConversions().empty()) {
    _odsPrinter << ' ';
    _odsPrinter.printRegion(getConversions());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("function_name");
  elidedAttrs.push_back("insert_after");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getInsertAfterAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("insert_after");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace transform
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::CastAndCallOp)

namespace mlir {
namespace transform {

//===----------------------------------------------------------------------===//
// ::mlir::transform::ReplaceFuncSignatureOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReplaceFuncSignatureOpGenericAdaptorBase::ReplaceFuncSignatureOpGenericAdaptorBase(ReplaceFuncSignatureOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::SymbolRefAttr ReplaceFuncSignatureOpGenericAdaptorBase::getFunctionName() {
  auto attr = getFunctionNameAttr();
  return attr;
}

::llvm::ArrayRef<int32_t> ReplaceFuncSignatureOpGenericAdaptorBase::getArgsInterchange() {
  auto attr = getArgsInterchangeAttr();
  return attr;
}

::llvm::ArrayRef<int32_t> ReplaceFuncSignatureOpGenericAdaptorBase::getResultsInterchange() {
  auto attr = getResultsInterchangeAttr();
  return attr;
}

::mlir::UnitAttr ReplaceFuncSignatureOpGenericAdaptorBase::getAdjustFuncCallsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().adjust_func_calls);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ReplaceFuncSignatureOpGenericAdaptorBase::getAdjustFuncCalls() {
  auto attr = getAdjustFuncCallsAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
ReplaceFuncSignatureOpAdaptor::ReplaceFuncSignatureOpAdaptor(ReplaceFuncSignatureOp op) : ReplaceFuncSignatureOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ReplaceFuncSignatureOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_adjust_func_calls = getProperties().adjust_func_calls; (void)tblgen_adjust_func_calls;
  auto tblgen_args_interchange = getProperties().args_interchange; (void)tblgen_args_interchange;
  if (!tblgen_args_interchange) return emitError(loc, "'transform.func.replace_func_signature' op ""requires attribute 'args_interchange'");
  auto tblgen_function_name = getProperties().function_name; (void)tblgen_function_name;
  if (!tblgen_function_name) return emitError(loc, "'transform.func.replace_func_signature' op ""requires attribute 'function_name'");
  auto tblgen_results_interchange = getProperties().results_interchange; (void)tblgen_results_interchange;
  if (!tblgen_results_interchange) return emitError(loc, "'transform.func.replace_func_signature' op ""requires attribute 'results_interchange'");

  if (tblgen_function_name && !((::llvm::isa<::mlir::SymbolRefAttr>(tblgen_function_name))))
    return emitError(loc, "'transform.func.replace_func_signature' op ""attribute 'function_name' failed to satisfy constraint: symbol reference attribute");

  if (tblgen_args_interchange && !((::llvm::isa<::mlir::DenseI32ArrayAttr>(tblgen_args_interchange))))
    return emitError(loc, "'transform.func.replace_func_signature' op ""attribute 'args_interchange' failed to satisfy constraint: i32 dense array attribute");

  if (tblgen_results_interchange && !((::llvm::isa<::mlir::DenseI32ArrayAttr>(tblgen_results_interchange))))
    return emitError(loc, "'transform.func.replace_func_signature' op ""attribute 'results_interchange' failed to satisfy constraint: i32 dense array attribute");

  if (tblgen_adjust_func_calls && !((::llvm::isa<::mlir::UnitAttr>(tblgen_adjust_func_calls))))
    return emitError(loc, "'transform.func.replace_func_signature' op ""attribute 'adjust_func_calls' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

void ReplaceFuncSignatureOp::getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn) {
  auto resultGroup0 = getODSResults(0);
  if (!resultGroup0.empty())
    setNameFn(*resultGroup0.begin(), "transformed_module");
  auto resultGroup1 = getODSResults(1);
  if (!resultGroup1.empty())
    setNameFn(*resultGroup1.begin(), "transformed_function");
}

::llvm::LogicalResult ReplaceFuncSignatureOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.adjust_func_calls;
       auto attr = dict.get("adjust_func_calls");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `adjust_func_calls` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.args_interchange;
       auto attr = dict.get("args_interchange");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `args_interchange` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.function_name;
       auto attr = dict.get("function_name");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `function_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.results_interchange;
       auto attr = dict.get("results_interchange");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `results_interchange` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ReplaceFuncSignatureOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.adjust_func_calls;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("adjust_func_calls",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.args_interchange;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("args_interchange",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.function_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("function_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.results_interchange;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("results_interchange",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ReplaceFuncSignatureOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.adjust_func_calls.getAsOpaquePointer()), 
    llvm::hash_value(prop.args_interchange.getAsOpaquePointer()), 
    llvm::hash_value(prop.function_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.results_interchange.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ReplaceFuncSignatureOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "adjust_func_calls")
      return prop.adjust_func_calls;

    if (name == "args_interchange")
      return prop.args_interchange;

    if (name == "function_name")
      return prop.function_name;

    if (name == "results_interchange")
      return prop.results_interchange;
  return std::nullopt;
}

void ReplaceFuncSignatureOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "adjust_func_calls") {
       prop.adjust_func_calls = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.adjust_func_calls)>>(value);
       return;
    }

    if (name == "args_interchange") {
       prop.args_interchange = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.args_interchange)>>(value);
       return;
    }

    if (name == "function_name") {
       prop.function_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.function_name)>>(value);
       return;
    }

    if (name == "results_interchange") {
       prop.results_interchange = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.results_interchange)>>(value);
       return;
    }
}

void ReplaceFuncSignatureOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.adjust_func_calls) attrs.append("adjust_func_calls", prop.adjust_func_calls);

    if (prop.args_interchange) attrs.append("args_interchange", prop.args_interchange);

    if (prop.function_name) attrs.append("function_name", prop.function_name);

    if (prop.results_interchange) attrs.append("results_interchange", prop.results_interchange);
}

::llvm::LogicalResult ReplaceFuncSignatureOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAdjustFuncCallsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps1(attr, "adjust_func_calls", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getArgsInterchangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps3(attr, "args_interchange", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getFunctionNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps2(attr, "function_name", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getResultsInterchangeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps3(attr, "results_interchange", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ReplaceFuncSignatureOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.adjust_func_calls)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.args_interchange)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.function_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.results_interchange)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReplaceFuncSignatureOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.adjust_func_calls);
  writer.writeAttribute(prop.args_interchange);
  writer.writeAttribute(prop.function_name);
  writer.writeAttribute(prop.results_interchange);
}

::mlir::SymbolRefAttr ReplaceFuncSignatureOp::getFunctionName() {
  auto attr = getFunctionNameAttr();
  return attr;
}

::llvm::ArrayRef<int32_t> ReplaceFuncSignatureOp::getArgsInterchange() {
  auto attr = getArgsInterchangeAttr();
  return attr;
}

::llvm::ArrayRef<int32_t> ReplaceFuncSignatureOp::getResultsInterchange() {
  auto attr = getResultsInterchangeAttr();
  return attr;
}

bool ReplaceFuncSignatureOp::getAdjustFuncCalls() {
  auto attr = getAdjustFuncCallsAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void ReplaceFuncSignatureOp::setArgsInterchange(::llvm::ArrayRef<int32_t> attrValue) {
  getProperties().args_interchange = ::mlir::Builder((*this)->getContext()).getDenseI32ArrayAttr(attrValue);
}

void ReplaceFuncSignatureOp::setResultsInterchange(::llvm::ArrayRef<int32_t> attrValue) {
  getProperties().results_interchange = ::mlir::Builder((*this)->getContext()).getDenseI32ArrayAttr(attrValue);
}

void ReplaceFuncSignatureOp::setAdjustFuncCalls(bool attrValue) {
    auto &odsProp = getProperties().adjust_func_calls;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  odsState.addOperands(module);
  odsState.getOrAddProperties<Properties>().function_name = function_name;
  odsState.getOrAddProperties<Properties>().args_interchange = args_interchange;
  odsState.getOrAddProperties<Properties>().results_interchange = results_interchange;
  if (adjust_func_calls) {
    odsState.getOrAddProperties<Properties>().adjust_func_calls = adjust_func_calls;
  }
  odsState.addTypes(transformed_module);
  odsState.addTypes(transformed_function);
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, transformed_module, transformed_function, module, function_name, args_interchange, results_interchange, adjust_func_calls);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  return create(builder, builder.getLoc(), transformed_module, transformed_function, module, function_name, args_interchange, results_interchange, adjust_func_calls);
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  odsState.addOperands(module);
  odsState.getOrAddProperties<Properties>().function_name = function_name;
  odsState.getOrAddProperties<Properties>().args_interchange = args_interchange;
  odsState.getOrAddProperties<Properties>().results_interchange = results_interchange;
  if (adjust_func_calls) {
    odsState.getOrAddProperties<Properties>().adjust_func_calls = adjust_func_calls;
  }
  assert(resultTypes.size() == 2u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, module, function_name, args_interchange, results_interchange, adjust_func_calls);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::mlir::DenseI32ArrayAttr args_interchange, ::mlir::DenseI32ArrayAttr results_interchange, /*optional*/::mlir::UnitAttr adjust_func_calls) {
  return create(builder, builder.getLoc(), resultTypes, module, function_name, args_interchange, results_interchange, adjust_func_calls);
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  odsState.addOperands(module);
  odsState.getOrAddProperties<Properties>().function_name = function_name;
  odsState.getOrAddProperties<Properties>().args_interchange = odsBuilder.getDenseI32ArrayAttr(args_interchange);
  odsState.getOrAddProperties<Properties>().results_interchange = odsBuilder.getDenseI32ArrayAttr(results_interchange);
  if (adjust_func_calls) {
    odsState.getOrAddProperties<Properties>().adjust_func_calls = ((adjust_func_calls) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.addTypes(transformed_module);
  odsState.addTypes(transformed_function);
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, transformed_module, transformed_function, module, function_name, args_interchange, results_interchange, adjust_func_calls);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type transformed_module, ::mlir::Type transformed_function, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  return create(builder, builder.getLoc(), transformed_module, transformed_function, module, function_name, args_interchange, results_interchange, adjust_func_calls);
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  odsState.addOperands(module);
  odsState.getOrAddProperties<Properties>().function_name = function_name;
  odsState.getOrAddProperties<Properties>().args_interchange = odsBuilder.getDenseI32ArrayAttr(args_interchange);
  odsState.getOrAddProperties<Properties>().results_interchange = odsBuilder.getDenseI32ArrayAttr(results_interchange);
  if (adjust_func_calls) {
    odsState.getOrAddProperties<Properties>().adjust_func_calls = ((adjust_func_calls) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 2u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, module, function_name, args_interchange, results_interchange, adjust_func_calls);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value module, ::mlir::SymbolRefAttr function_name, ::llvm::ArrayRef<int32_t> args_interchange, ::llvm::ArrayRef<int32_t> results_interchange, /*optional*/bool adjust_func_calls) {
  return create(builder, builder.getLoc(), resultTypes, module, function_name, args_interchange, results_interchange, adjust_func_calls);
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 2u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ReplaceFuncSignatureOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ReplaceFuncSignatureOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 2u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ReplaceFuncSignatureOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReplaceFuncSignatureOp ReplaceFuncSignatureOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult ReplaceFuncSignatureOp::verifyInvariantsImpl() {
  auto tblgen_adjust_func_calls = getProperties().adjust_func_calls; (void)tblgen_adjust_func_calls;
  auto tblgen_args_interchange = getProperties().args_interchange; (void)tblgen_args_interchange;
  if (!tblgen_args_interchange) return emitOpError("requires attribute 'args_interchange'");
  auto tblgen_function_name = getProperties().function_name; (void)tblgen_function_name;
  if (!tblgen_function_name) return emitOpError("requires attribute 'function_name'");
  auto tblgen_results_interchange = getProperties().results_interchange; (void)tblgen_results_interchange;
  if (!tblgen_results_interchange) return emitOpError("requires attribute 'results_interchange'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps2(*this, tblgen_function_name, "function_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps3(*this, tblgen_args_interchange, "args_interchange")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps3(*this, tblgen_results_interchange, "results_interchange")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_FuncTransformOps1(*this, tblgen_adjust_func_calls, "adjust_func_calls")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSResults(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_FuncTransformOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ReplaceFuncSignatureOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ReplaceFuncSignatureOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::SymbolRefAttr function_nameAttr;
  ::mlir::DenseI32ArrayAttr args_interchangeAttr;
  ::mlir::DenseI32ArrayAttr results_interchangeAttr;
  ::mlir::OpAsmParser::UnresolvedOperand moduleRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> moduleOperands(&moduleRawOperand, 1);  ::llvm::SMLoc moduleOperandsLoc;
  (void)moduleOperandsLoc;
  ::llvm::ArrayRef<::mlir::Type> allOperandTypes;
  ::llvm::ArrayRef<::mlir::Type> allResultTypes;

  if (parser.parseCustomAttributeWithFallback(function_nameAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (function_nameAttr) result.getOrAddProperties<ReplaceFuncSignatureOp::Properties>().function_name = function_nameAttr;
  if (parser.parseKeyword("args_interchange"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(args_interchangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (args_interchangeAttr) result.getOrAddProperties<ReplaceFuncSignatureOp::Properties>().args_interchange = args_interchangeAttr;
  if (parser.parseKeyword("results_interchange"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(results_interchangeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (results_interchangeAttr) result.getOrAddProperties<ReplaceFuncSignatureOp::Properties>().results_interchange = results_interchangeAttr;
  if (parser.parseKeyword("at"))
    return ::mlir::failure();

  moduleOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(moduleRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  ::mlir::FunctionType allOperand__allResult_functionType;
  if (parser.parseType(allOperand__allResult_functionType))
    return ::mlir::failure();
  allOperandTypes = allOperand__allResult_functionType.getInputs();
  allResultTypes = allOperand__allResult_functionType.getResults();
  result.addTypes(allResultTypes);
  if (parser.resolveOperands(moduleOperands, allOperandTypes, parser.getNameLoc(), result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReplaceFuncSignatureOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getFunctionNameAttr());
  _odsPrinter << ' ' << "args_interchange";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getArgsInterchangeAttr());
  _odsPrinter << ' ' << "results_interchange";
  _odsPrinter << ' ' << "=";
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getResultsInterchangeAttr());
  _odsPrinter << ' ' << "at";
  _odsPrinter << ' ';
  _odsPrinter << getModule();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("function_name");
  elidedAttrs.push_back("args_interchange");
  elidedAttrs.push_back("results_interchange");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAdjustFuncCallsAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("adjust_func_calls");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printFunctionalType(getOperation()->getOperandTypes(), getOperation()->getResultTypes());
}

} // namespace transform
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::transform::ReplaceFuncSignatureOp)


#endif  // GET_OP_CLASSES

