# This file allows users to call find_package(MLIR) and pick up our targets.

# Compute the installation prefix from this LLVMConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" REALPATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

set(LLVM_VERSION 22.0.0)
find_package(LLVM ${LLVM_VERSION} EXACT REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "mlir-linalg-ods-yaml-gen;mlir-pdll;mlir-tblgen;MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToROCDLLibraryCalls;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToEmitC;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRShardToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRPtrToLLVM;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToAMX;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU;MLIRXeVMToLLVM;MLIRXeGPUToXeVM;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmNeonVectorTransformOps;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRArmSVEVectorTransformOps;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncShardingExtensions;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRFuncUtils;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRXeVMDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRShardDialect;MLIRShardTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPtrMemorySpaceInterfaces;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSMT;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVImageInterfaces;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorShardingExtensions;MLIRTensorAllExtensions;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialectInterfaces;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformTuneExtension;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRWasmSSADialect;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRXeGPUUtils;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRIndexingMapOpInterface;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRemarkStreamer;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRTargetIRDLToCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRPtrToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRXeVMToLLVMIRTranslation;MLIRTargetLLVMIRTransforms;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRXeVMTarget;MLIRExportSMTLIB;MLIRTargetWasmImport;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRExecutionEngineShared;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRRegisterAllDialects;MLIRRegisterAllPasses;MLIRRegisterAllExtensions;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIEmitC;obj.MLIRCAPIEmitC;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPIIndex;obj.MLIRCAPIIndex;MLIRCAPIIRDL;obj.MLIRCAPIIRDL;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;obj.MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPISMT;obj.MLIRCAPISMT;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExportSMTLIB;obj.MLIRCAPIExportSMTLIB;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;mlir-lsp-server;MLIRMlirOptMain;mlir-opt;mlir-pdll-lsp-server;mlir-query;mlir-reduce;mlir-rewrite;MLIR;mlir-translate;tblgen-lsp-server;tblgen-to-irdl;mlir-runner")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")
set(MLIR_PDLL_TABLEGEN_EXE "mlir-pdll")
set(MLIR_SRC_SHARDER_TABLEGEN_EXE "mlir-src-sharder")
set(MLIR_IRDL_TO_CPP_EXE "mlir-irdl-to-cpp")
set(MLIR_INSTALL_AGGREGATE_OBJECTS "1")
set(MLIR_ENABLE_BINDINGS_PYTHON "0")
set(MLIR_ENABLE_EXECUTION_ENGINE "1")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRPresburger;MLIRAnalysis;MLIRAsmParser;MLIRBytecodeReader;MLIRBytecodeWriter;MLIRBytecodeOpInterface;MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToROCDLLibraryCalls;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToEmitC;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRShardToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRPtrToLLVM;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToAMX;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU;MLIRXeVMToLLVM;MLIRXeGPUToXeVM;MLIRObservers;MLIRDebug;MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmNeonVectorTransformOps;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRArmSVEVectorTransformOps;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncInlinerExtension;MLIRFuncShardingExtensions;MLIRFuncAllExtensions;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRFuncUtils;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRXeVMDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardingInterface;MLIRShardDialect;MLIRShardTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenACCMPCommon;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPtrMemorySpaceInterfaces;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSMT;MLIRSparseTensorEnums;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVImageInterfaces;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorShardingExtensions;MLIRTensorAllExtensions;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialectInterfaces;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformTuneExtension;MLIRTransformDialectUtils;MLIRUBDialect;MLIRDialectUtils;MLIRVectorDialect;MLIRMaskableOpInterface;MLIRMaskingOpInterface;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRWasmSSADialect;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRXeGPUUtils;MLIRDialect;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRDestinationStyleOpInterface;MLIRFunctionInterfaces;MLIRIndexingMapOpInterface;MLIRInferIntRangeInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRMemorySlotInterfaces;MLIRParallelCombiningOpInterface;MLIRRuntimeVerifiableOpInterface;MLIRShapedOpInterfaces;MLIRSideEffectInterfaces;MLIRSubsetOpInterface;MLIRTilingInterface;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRValueBoundsOpInterface;MLIRInferIntRangeCommon;MLIRParser;MLIRPass;MLIRQuery;MLIRQueryMatcher;MLIRReduce;MLIRRemarkStreamer;MLIRRewrite;MLIRRewritePDL;MLIRSupport;MLIRTableGen;MLIRTargetCpp;MLIRTargetIRDLToCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRSPIRVTarget;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRPtrToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRXeVMToLLVMIRTranslation;MLIRTargetLLVMIRTransforms;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRTargetLLVM;MLIRNVVMTarget;MLIRROCDLTarget;MLIRXeVMTarget;MLIRExportSMTLIB;MLIRTargetWasmImport;MLIRLspServerSupportLib;MLIRLspServerLib;MLIROptLib;MLIRQueryLib;MLIRReduceLib;MLIRTblgenLib;MLIRTranslateLib;MLIRPDLLAST;MLIRPDLLCodeGen;MLIRPDLLODS;MLIRPluginsLib;MLIRTransformUtils;MLIRTransforms;MLIRExecutionEngineUtils;MLIRExecutionEngine;MLIRExecutionEngineShared;MLIRJitRunner;mlir_float16_utils;MLIRSparseTensorRuntime;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;mlir_arm_sme_abi_stubs;mlir_arm_runner_utils;MLIRRegisterAllDialects;MLIRRegisterAllPasses;MLIRRegisterAllExtensions;MLIRCAPIDebug;obj.MLIRCAPIDebug;MLIRCAPIAMDGPU;obj.MLIRCAPIAMDGPU;MLIRCAPIArith;obj.MLIRCAPIArith;MLIRCAPIAsync;obj.MLIRCAPIAsync;MLIRCAPIControlFlow;obj.MLIRCAPIControlFlow;MLIRCAPIEmitC;obj.MLIRCAPIEmitC;MLIRCAPIMath;obj.MLIRCAPIMath;MLIRCAPIMemRef;obj.MLIRCAPIMemRef;MLIRCAPIGPU;obj.MLIRCAPIGPU;MLIRCAPIIndex;obj.MLIRCAPIIndex;MLIRCAPIIRDL;obj.MLIRCAPIIRDL;MLIRCAPILLVM;obj.MLIRCAPILLVM;MLIRCAPILinalg;obj.MLIRCAPILinalg;MLIRCAPIMLProgram;obj.MLIRCAPIMLProgram;MLIRCAPINVGPU;obj.MLIRCAPINVGPU;MLIRCAPINVVM;obj.MLIRCAPINVVM;MLIRCAPIROCDL;obj.MLIRCAPIROCDL;MLIRCAPISCF;obj.MLIRCAPISCF;MLIRCAPIShape;obj.MLIRCAPIShape;MLIRCAPISparseTensor;obj.MLIRCAPISparseTensor;MLIRCAPIFunc;obj.MLIRCAPIFunc;MLIRCAPISPIRV;obj.MLIRCAPISPIRV;MLIRCAPITensor;obj.MLIRCAPITensor;MLIRCAPITransformDialect;obj.MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;obj.MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;obj.MLIRCAPIQuant;MLIRCAPIOpenMP;obj.MLIRCAPIOpenMP;MLIRCAPIPDL;obj.MLIRCAPIPDL;MLIRCAPIVector;obj.MLIRCAPIVector;MLIRCAPISMT;obj.MLIRCAPISMT;MLIRCAPIConversion;obj.MLIRCAPIConversion;MLIRCAPIInterfaces;obj.MLIRCAPIInterfaces;MLIRCAPIIR;obj.MLIRCAPIIR;MLIRCAPIRegisterEverything;obj.MLIRCAPIRegisterEverything;MLIRCAPITransforms;obj.MLIRCAPITransforms;MLIRCAPITarget;obj.MLIRCAPITarget;MLIRCAPIExportSMTLIB;obj.MLIRCAPIExportSMTLIB;MLIRCAPIExecutionEngine;obj.MLIRCAPIExecutionEngine;MLIRMlirOptMain;MLIR")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffineAnalysis;MLIRAffineDialect;MLIRAffineTransforms;MLIRAffineTransformOps;MLIRAffineUtils;MLIRAMDGPUDialect;MLIRAMDGPUTransforms;MLIRAMDGPUUtils;MLIRAMXDialect;MLIRAMXTransforms;MLIRArithDialect;MLIRArithValueBoundsOpInterfaceImpl;MLIRArithTransforms;MLIRArithUtils;MLIRArmNeonDialect;MLIRArmNeonTransforms;MLIRArmNeonVectorTransformOps;MLIRArmSMEDialect;MLIRArmSMETransforms;MLIRArmSVEDialect;MLIRArmSVETransforms;MLIRArmSVEVectorTransformOps;MLIRAsyncDialect;MLIRAsyncTransforms;MLIRBufferizationDialect;MLIRBufferizationPipelines;MLIRBufferizationTransformOps;MLIRBufferizationTransforms;MLIRComplexDialect;MLIRControlFlowDialect;MLIRControlFlowTransforms;MLIRDLTITransformOps;MLIRDLTIDialect;MLIREmitCDialect;MLIREmitCTransforms;MLIRFuncDialect;MLIRFuncTransforms;MLIRFuncTransformOps;MLIRFuncUtils;MLIRGPUDialect;MLIRGPUTransforms;MLIRGPUTransformOps;MLIRGPUPipelines;MLIRGPUUtils;MLIRIndexDialect;MLIRIRDL;MLIRLinalgDialect;MLIRLinalgTransformOps;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMDialect;MLIRNVVMDialect;MLIRROCDLDialect;MLIRVCIXDialect;MLIRXeVMDialect;MLIRMathDialect;MLIRMathTransforms;MLIRMemRefDialect;MLIRMemRefTransformOps;MLIRMemRefTransforms;MLIRMemRefUtils;MLIRShardDialect;MLIRShardTransforms;MLIRMLProgramDialect;MLIRMLProgramTransforms;MLIRMPIDialect;MLIRNVGPUDialect;MLIRNVGPUUtils;MLIRNVGPUTransformOps;MLIRNVGPUTransforms;MLIROpenACCDialect;MLIROpenACCTransforms;MLIROpenMPDialect;MLIRPDLDialect;MLIRPDLInterpDialect;MLIRPtrMemorySpaceInterfaces;MLIRPtrDialect;MLIRQuantDialect;MLIRQuantTransforms;MLIRQuantUtils;MLIRSCFDialect;MLIRSCFTransformOps;MLIRSCFTransforms;MLIRSCFUtils;MLIRShapeDialect;MLIRShapeOpsTransforms;MLIRSMT;MLIRSparseTensorDialect;MLIRSparseTensorPipelines;MLIRSparseTensorTransformOps;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRVDialect;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRTensorDialect;MLIRTensorInferTypeOpInterfaceImpl;MLIRTensorTilingInterfaceImpl;MLIRTensorTransforms;MLIRTensorTransformOps;MLIRTensorUtils;MLIRTosaDialect;MLIRTosaShardingInterfaceImpl;MLIRTosaTransforms;MLIRTransformDebugExtension;MLIRTransformDialect;MLIRTransformDialectIRDLExtension;MLIRTransformLoopExtension;MLIRTransformPDLExtension;MLIRTransformDialectTransforms;MLIRTransformTuneExtension;MLIRTransformDialectUtils;MLIRUBDialect;MLIRVectorDialect;MLIRVectorTransforms;MLIRVectorTransformOps;MLIRVectorUtils;MLIRWasmSSADialect;MLIRX86VectorDialect;MLIRX86VectorTransforms;MLIRXeGPUDialect;MLIRXeGPUTransforms;MLIRXeGPUUtils;MLIRSPIRVTarget;MLIRTargetLLVMIRTransforms;MLIRNVVMTarget;MLIRROCDLTarget;MLIRXeVMTarget")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRAMDGPUToROCDL;MLIRArithAttrToLLVMConversion;MLIRArithToAMDGPU;MLIRArithToArmSME;MLIRArithToEmitC;MLIRArithToLLVM;MLIRArithToSPIRV;MLIRArmNeon2dToIntr;MLIRArmSMEToSCF;MLIRArmSMEToLLVM;MLIRAsyncToLLVM;MLIRBufferizationToMemRef;MLIRComplexDivisionConversion;MLIRComplexToLibm;MLIRComplexToROCDLLibraryCalls;MLIRComplexToLLVM;MLIRComplexToSPIRV;MLIRComplexToStandard;MLIRControlFlowToLLVM;MLIRControlFlowToSCF;MLIRControlFlowToSPIRV;MLIRConvertToEmitC;MLIRConvertToLLVMInterface;MLIRConvertToLLVMPass;MLIRFuncToEmitC;MLIRFuncToLLVM;MLIRFuncToSPIRV;MLIRGPUToGPURuntimeTransforms;MLIRGPUToLLVMSPV;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRIndexToLLVM;MLIRIndexToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToEmitC;MLIRMathToFuncs;MLIRMathToLibm;MLIRMathToLLVM;MLIRMathToROCDL;MLIRMathToSPIRV;MLIRMemRefToEmitC;MLIRMemRefToLLVM;MLIRMemRefToSPIRV;MLIRShardToMPI;MLIRMPIToLLVM;MLIRNVGPUToNVVM;MLIRNVVMToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRPtrToLLVM;MLIRReconcileUnrealizedCasts;MLIRSCFToControlFlow;MLIRSCFToEmitC;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRShapeToStandard;MLIRSPIRVAttrToLLVMConversion;MLIRSPIRVToLLVM;MLIRTensorToLinalg;MLIRTensorToSPIRV;MLIRTosaToArith;MLIRTosaToLinalg;MLIRTosaToMLProgram;MLIRTosaToSCF;MLIRTosaToTensor;MLIRUBToLLVM;MLIRUBToSPIRV;MLIRVectorToAMX;MLIRVectorToArmSME;MLIRVectorToGPU;MLIRVectorToLLVM;MLIRVectorToLLVMPass;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRVectorToXeGPU;MLIRXeVMToLLVM;MLIRXeGPUToXeVM")
set_property(GLOBAL PROPERTY MLIR_EXTENSION_LIBS "MLIRFuncInlinerExtension;MLIRFuncShardingExtensions;MLIRFuncAllExtensions;MLIRTensorShardingExtensions;MLIRTensorAllExtensions")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRTargetCpp;MLIRTargetIRDLToCpp;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSMEToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRBuiltinToLLVMIRTranslation;MLIRGPUToLLVMIRTranslation;MLIRLLVMIRToLLVMTranslation;MLIRLLVMToLLVMIRTranslation;MLIRLLVMIRToNVVMTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRPtrToLLVMIRTranslation;MLIRSPIRVToLLVMIRTranslation;MLIRVCIXToLLVMIRTranslation;MLIRXeVMToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRFromLLVMIRTranslationRegistration;MLIRExportSMTLIB;MLIRTargetWasmImport")
set_property(GLOBAL PROPERTY MLIR_UPSTREAM_CAPI_LIBS "MLIRCAPIDebug;MLIRCAPIAMDGPU;MLIRCAPIArith;MLIRCAPIAsync;MLIRCAPIControlFlow;MLIRCAPIEmitC;MLIRCAPIMath;MLIRCAPIMemRef;MLIRCAPIGPU;MLIRCAPIIndex;MLIRCAPIIRDL;MLIRCAPILLVM;MLIRCAPILinalg;MLIRCAPIMLProgram;MLIRCAPINVGPU;MLIRCAPINVVM;MLIRCAPIROCDL;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPISparseTensor;MLIRCAPIFunc;MLIRCAPISPIRV;MLIRCAPITensor;MLIRCAPITransformDialect;MLIRCAPITransformDialectTransforms;MLIRCAPIQuant;MLIRCAPIOpenMP;MLIRCAPIPDL;MLIRCAPIVector;MLIRCAPISMT;MLIRCAPIConversion;MLIRCAPIInterfaces;MLIRCAPIIR;MLIRCAPIRegisterEverything;MLIRCAPITransforms;MLIRCAPITarget;MLIRCAPIExportSMTLIB;MLIRCAPIExecutionEngine")

# Provide all our library targets to users.
# More specifically, configure MLIR so that it can be directly included in a top
# level CMakeLists.txt, but also so that it can be imported via `find_package`.
# This is based on how LLVM handles exports.
if(NOT TARGET MLIRSupport)
  include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")
endif()

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
