/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: PtrOps.td                                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace ptr {
// ptr.atomicrmw binary operations
enum class AtomicBinOp : uint32_t {
  xchg = 0,
  add = 1,
  sub = 2,
  _and = 3,
  nand = 4,
  _or = 5,
  _xor = 6,
  max = 7,
  min = 8,
  umax = 9,
  umin = 10,
  fadd = 11,
  fsub = 12,
  fmax = 13,
  fmin = 14,
  uinc_wrap = 15,
  udec_wrap = 16,
};

::std::optional<AtomicBinOp> symbolizeAtomicBinOp(uint32_t);
::llvm::StringRef stringifyAtomicBinOp(AtomicBinOp);
::std::optional<AtomicBinOp> symbolizeAtomicBinOp(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForAtomicBinOp() {
  return 16;
}


inline ::llvm::StringRef stringifyEnum(AtomicBinOp enumValue) {
  return stringifyAtomicBinOp(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<AtomicBinOp> symbolizeEnum<AtomicBinOp>(::llvm::StringRef str) {
  return symbolizeAtomicBinOp(str);
}
} // namespace ptr
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::ptr::AtomicBinOp, ::mlir::ptr::AtomicBinOp> {
  template <typename ParserT>
  static FailureOr<::mlir::ptr::AtomicBinOp> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for ptr.atomicrmw binary operations");

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::AtomicBinOp> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::AtomicBinOp>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [xchg, add, sub, _and, nand, _or, _xor, max, min, umax, umin, fadd, fsub, fmax, fmin, uinc_wrap, udec_wrap] for ptr.atomicrmw binary operations, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::ptr::AtomicBinOp>, std::optional<::mlir::ptr::AtomicBinOp>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::ptr::AtomicBinOp>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::ptr::AtomicBinOp>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::AtomicBinOp> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::AtomicBinOp>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [xchg, add, sub, _and, nand, _or, _xor, max, min, umax, umin, fadd, fsub, fmax, fmin, uinc_wrap, udec_wrap] for ptr.atomicrmw binary operations, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::ptr::AtomicBinOp value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::ptr::AtomicBinOp> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::ptr::AtomicBinOp getEmptyKey() {
    return static_cast<::mlir::ptr::AtomicBinOp>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::ptr::AtomicBinOp getTombstoneKey() {
    return static_cast<::mlir::ptr::AtomicBinOp>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::ptr::AtomicBinOp &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::ptr::AtomicBinOp &lhs, const ::mlir::ptr::AtomicBinOp &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace ptr {
// Atomic ordering for LLVM's memory model
enum class AtomicOrdering : uint32_t {
  not_atomic = 0,
  unordered = 1,
  monotonic = 2,
  acquire = 3,
  release = 4,
  acq_rel = 5,
  seq_cst = 6,
};

::std::optional<AtomicOrdering> symbolizeAtomicOrdering(uint32_t);
::llvm::StringRef stringifyAtomicOrdering(AtomicOrdering);
::std::optional<AtomicOrdering> symbolizeAtomicOrdering(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForAtomicOrdering() {
  return 6;
}


inline ::llvm::StringRef stringifyEnum(AtomicOrdering enumValue) {
  return stringifyAtomicOrdering(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<AtomicOrdering> symbolizeEnum<AtomicOrdering>(::llvm::StringRef str) {
  return symbolizeAtomicOrdering(str);
}
} // namespace ptr
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::ptr::AtomicOrdering, ::mlir::ptr::AtomicOrdering> {
  template <typename ParserT>
  static FailureOr<::mlir::ptr::AtomicOrdering> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Atomic ordering for LLVM's memory model");

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::AtomicOrdering> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::AtomicOrdering>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [not_atomic, unordered, monotonic, acquire, release, acq_rel, seq_cst] for Atomic ordering for LLVM's memory model, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::ptr::AtomicOrdering>, std::optional<::mlir::ptr::AtomicOrdering>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::ptr::AtomicOrdering>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::ptr::AtomicOrdering>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::AtomicOrdering> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::AtomicOrdering>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [not_atomic, unordered, monotonic, acquire, release, acq_rel, seq_cst] for Atomic ordering for LLVM's memory model, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::ptr::AtomicOrdering value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::ptr::AtomicOrdering> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::ptr::AtomicOrdering getEmptyKey() {
    return static_cast<::mlir::ptr::AtomicOrdering>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::ptr::AtomicOrdering getTombstoneKey() {
    return static_cast<::mlir::ptr::AtomicOrdering>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::ptr::AtomicOrdering &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::ptr::AtomicOrdering &lhs, const ::mlir::ptr::AtomicOrdering &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace ptr {
// Pointer add flags
enum class PtrAddFlags : uint32_t {
  none = 0,
  nusw = 1,
  nuw = 2,
  inbounds = 3,
};

::std::optional<PtrAddFlags> symbolizePtrAddFlags(uint32_t);
::llvm::StringRef stringifyPtrAddFlags(PtrAddFlags);
::std::optional<PtrAddFlags> symbolizePtrAddFlags(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForPtrAddFlags() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(PtrAddFlags enumValue) {
  return stringifyPtrAddFlags(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<PtrAddFlags> symbolizeEnum<PtrAddFlags>(::llvm::StringRef str) {
  return symbolizePtrAddFlags(str);
}
} // namespace ptr
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::ptr::PtrAddFlags, ::mlir::ptr::PtrAddFlags> {
  template <typename ParserT>
  static FailureOr<::mlir::ptr::PtrAddFlags> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for Pointer add flags");

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::PtrAddFlags> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::PtrAddFlags>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "expected one of [none, nusw, nuw, inbounds] for Pointer add flags, got: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::ptr::PtrAddFlags>, std::optional<::mlir::ptr::PtrAddFlags>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::ptr::PtrAddFlags>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::ptr::PtrAddFlags>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::ptr::PtrAddFlags> attr = ::mlir::ptr::symbolizeEnum<::mlir::ptr::PtrAddFlags>(enumKeyword))
      return attr;
    return parser.emitError(loc, "expected one of [none, nusw, nuw, inbounds] for Pointer add flags, got: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::ptr::PtrAddFlags value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::ptr::PtrAddFlags> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::ptr::PtrAddFlags getEmptyKey() {
    return static_cast<::mlir::ptr::PtrAddFlags>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::ptr::PtrAddFlags getTombstoneKey() {
    return static_cast<::mlir::ptr::PtrAddFlags>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::ptr::PtrAddFlags &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::ptr::PtrAddFlags &lhs, const ::mlir::ptr::PtrAddFlags &rhs) {
    return lhs == rhs;
  }
};
}

