# This file allows users to call find_package(MLIR) and pick up our targets.


# Compute the installation prefix from this MLIRConfig.cmake file location.
get_filename_component(MLIR_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)
get_filename_component(MLIR_INSTALL_PREFIX "${MLIR_INSTALL_PREFIX}" PATH)

find_package(LLVM REQUIRED CONFIG
             HINTS "${MLIR_INSTALL_PREFIX}/lib/cmake/llvm")

set(MLIR_EXPORTED_TARGETS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMemRefToLLVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRDialectUtils;MLIRVector;MLIRX86Vector;MLIRX86VectorTransforms;MLIRDialect;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerLib;MLIRReduceLib;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIDebug;MLIRCAPIAsync;MLIRCAPIGPU;MLIRCAPILLVM;MLIRCAPILinalg;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPISparseTensor;MLIRCAPIStandard;MLIRCAPITensor;MLIRCAPIConversion;MLIRCEXECUTIONENGINE;MLIRCAPIIR;MLIRCAPIRegistration;MLIRCAPITransforms;MLIRMlirOptMain;MLIR")
set(MLIR_CMAKE_DIR "${MLIR_INSTALL_PREFIX}/lib/cmake/mlir")
set(MLIR_INCLUDE_DIRS "${MLIR_INSTALL_PREFIX}/include")
set(MLIR_TABLEGEN_EXE "mlir-tblgen")

# For mlir_tablegen()
set(MLIR_INCLUDE_DIR "/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_lang_llvm-13/mlir-13/work/build/tools/mlir/include")
set(MLIR_MAIN_SRC_DIR "/opt/local/var/macports/build/_opt_bblocal_var_buildworker_ports_build_ports_lang_llvm-13/mlir-13/work/llvm-project-13.0.1.src/mlir")

set_property(GLOBAL PROPERTY MLIR_ALL_LIBS "MLIRAnalysis;MLIRLoopAnalysis;MLIRPresburger;MLIRAffineToStandard;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMemRefToLLVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV;MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRDialectUtils;MLIRVector;MLIRX86Vector;MLIRX86VectorTransforms;MLIRDialect;MLIRExecutionEngine;MLIRJitRunner;mlir_c_runner_utils;mlir_runner_utils;mlir_async_runtime;MLIRIR;MLIRCallInterfaces;MLIRCastInterfaces;MLIRControlFlowInterfaces;MLIRCopyOpInterface;MLIRDataLayoutInterfaces;MLIRDerivedAttributeOpInterface;MLIRInferTypeOpInterface;MLIRLoopLikeInterface;MLIRSideEffectInterfaces;MLIRVectorInterfaces;MLIRViewLikeInterface;MLIRParser;MLIRPass;MLIRReduce;MLIRRewrite;MLIRSupport;MLIROptLib;MLIRTableGen;MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport;MLIRLspServerLib;MLIRReduceLib;MLIRTransformUtils;MLIRTransforms;MLIRTranslation;MLIRCAPIDebug;MLIRCAPIAsync;MLIRCAPIGPU;MLIRCAPILLVM;MLIRCAPILinalg;MLIRCAPISCF;MLIRCAPIShape;MLIRCAPISparseTensor;MLIRCAPIStandard;MLIRCAPITensor;MLIRCAPIConversion;MLIRCEXECUTIONENGINE;MLIRCAPIIR;MLIRCAPIRegistration;MLIRCAPITransforms;MLIRMlirOptMain;MLIR")
set_property(GLOBAL PROPERTY MLIR_DIALECT_LIBS "MLIRAffine;MLIRAffineTransforms;MLIRAffineUtils;MLIRArmNeon;MLIRArmSVE;MLIRArmSVETransforms;MLIRAsync;MLIRAsyncTransforms;MLIRAMX;MLIRAMXTransforms;MLIRComplex;MLIRDLTI;MLIREmitC;MLIRGPUOps;MLIRGPUTransforms;MLIRLinalgAnalysis;MLIRLinalg;MLIRLinalgTransforms;MLIRLinalgUtils;MLIRLLVMIRTransforms;MLIRLLVMIR;MLIRNVVMIR;MLIRROCDLIR;MLIRMath;MLIRMathTransforms;MLIRMemRef;MLIRMemRefTransforms;MLIRMemRefUtils;MLIROpenACC;MLIROpenMP;MLIRPDL;MLIRPDLInterp;MLIRQuant;MLIRSCF;MLIRSCFTransforms;MLIRShape;MLIRShapeOpsTransforms;MLIRSparseTensor;MLIRSparseTensorTransforms;MLIRSparseTensorUtils;MLIRSPIRV;MLIRSPIRVModuleCombiner;MLIRSPIRVConversion;MLIRSPIRVTransforms;MLIRSPIRVUtils;MLIRStandard;MLIRStandardOpsTransforms;MLIRTensor;MLIRTensorTransforms;MLIRTosa;MLIRTosaTransforms;MLIRVector;MLIRX86Vector;MLIRX86VectorTransforms")
set_property(GLOBAL PROPERTY MLIR_CONVERSION_LIBS "MLIRAffineToStandard;MLIRArmNeon2dToIntr;MLIRAsyncToLLVM;MLIRComplexToLLVM;MLIRComplexToStandard;MLIRGPUToGPURuntimeTransforms;MLIRGPUToNVVMTransforms;MLIRGPUToROCDLTransforms;MLIRGPUToSPIRV;MLIRGPUToVulkanTransforms;MLIRLinalgToLLVM;MLIRLinalgToSPIRV;MLIRLinalgToStandard;MLIRLLVMCommonConversion;MLIRMathToLibm;MLIRMathToLLVM;MLIRMemRefToLLVM;MLIROpenACCToLLVM;MLIROpenACCToSCF;MLIROpenMPToLLVM;MLIRPDLToPDLInterp;MLIRSCFToGPU;MLIRSCFToOpenMP;MLIRSCFToSPIRV;MLIRSCFToStandard;MLIRShapeToStandard;MLIRSPIRVToLLVM;MLIRStandardToLLVM;MLIRStandardToSPIRV;MLIRTosaToLinalg;MLIRTosaToSCF;MLIRTosaToStandard;MLIRVectorToROCDL;MLIRVectorToLLVM;MLIRVectorToGPU;MLIRVectorToSCF;MLIRVectorToSPIRV")
set_property(GLOBAL PROPERTY MLIR_TRANSLATION_LIBS "MLIRSPIRVDeserialization;MLIRSPIRVSerialization;MLIRSPIRVBinaryUtils;MLIRSPIRVTranslateRegistration;MLIRArmNeonToLLVMIRTranslation;MLIRArmSVEToLLVMIRTranslation;MLIRAMXToLLVMIRTranslation;MLIRLLVMToLLVMIRTranslation;MLIRNVVMToLLVMIRTranslation;MLIROpenACCToLLVMIRTranslation;MLIROpenMPToLLVMIRTranslation;MLIRROCDLToLLVMIRTranslation;MLIRX86VectorToLLVMIRTranslation;MLIRTargetLLVMIRExport;MLIRToLLVMIRTranslationRegistration;MLIRTargetLLVMIRImport")

# Provide all our library targets to users.
include("${MLIR_CMAKE_DIR}/MLIRTargets.cmake")

# By creating these targets here, subprojects that depend on MLIR's
# tablegen-generated headers can always depend on these targets whether building
# in-tree with MLIR or not.
if(NOT TARGET mlir-tablegen-targets)
  add_custom_target(mlir-tablegen-targets)
endif()
if(NOT TARGET mlir-headers)
  add_custom_target(mlir-headers)
endif()
if(NOT TARGET mlir-generic-headers)
  add_custom_target(mlir-generic-headers)
endif()
if(NOT TARGET mlir-doc)
  add_custom_target(mlir-doc)
endif()
