/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.Logger;
import org.apache.maven.api.cli.logging.AccumulatingLogger;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.api.services.LookupException;
import org.apache.maven.api.services.MessageBuilderFactory;

@Immutable
@Experimental
public interface ParserRequest {
    @Nonnull
    public String command();

    @Nonnull
    public String commandName();

    @Nonnull
    public Logger logger();

    @Nonnull
    public MessageBuilderFactory messageBuilderFactory();

    @Nonnull
    public List<String> args();

    @Nonnull
    public Lookup lookup();

    @Nullable
    public Path cwd();

    @Nullable
    public Path mavenHome();

    @Nullable
    public Path userHome();

    @Nullable
    public InputStream stdIn();

    @Nullable
    public OutputStream stdOut();

    @Nullable
    public OutputStream stdErr();

    public boolean embedded();

    @Nonnull
    public static Builder mvn(@Nonnull String[] args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.mvn(Arrays.asList(args), messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvn(@Nonnull List<String> args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.builder("mvn", "Maven", args, messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnenc(@Nonnull String[] args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.mvnenc(Arrays.asList(args), messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnenc(@Nonnull List<String> args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.builder("mvnenc", "Maven Password Encrypting Tool", args, messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnsh(@Nonnull String[] args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.mvnsh(Arrays.asList(args), messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnsh(@Nonnull List<String> args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.builder("mvnsh", "Maven Shell Tool", args, messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnup(@Nonnull String[] args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.mvnup(Arrays.asList(args), messageBuilderFactory);
    }

    @Nonnull
    public static Builder mvnup(@Nonnull List<String> args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return ParserRequest.builder("mvnup", "Maven Upgrade Tool", args, messageBuilderFactory);
    }

    @Nonnull
    public static Builder builder(@Nonnull String command, @Nonnull String commandName, @Nonnull List<String> args, @Nonnull MessageBuilderFactory messageBuilderFactory) {
        return new Builder(command, commandName, args, messageBuilderFactory);
    }

    public static class Builder {
        private final String command;
        private final String commandName;
        private final List<String> args;
        private final MessageBuilderFactory messageBuilderFactory;
        private final Logger logger;
        private Lookup lookup = EMPTY_LOOKUP;
        private Path cwd;
        private Path mavenHome;
        private Path userHome;
        private InputStream stdIn;
        private OutputStream stdOut;
        private OutputStream stdErr;
        private boolean embedded = false;
        private static final Lookup EMPTY_LOOKUP = new Lookup(){

            public <T> T lookup(Class<T> type) {
                throw new LookupException("empty lookup");
            }

            public <T> T lookup(Class<T> type, String name) {
                throw new LookupException("empty lookup");
            }

            public <T> Optional<T> lookupOptional(Class<T> type) {
                return Optional.empty();
            }

            public <T> Optional<T> lookupOptional(Class<T> type, String name) {
                return Optional.empty();
            }

            public <T> List<T> lookupList(Class<T> type) {
                return List.of();
            }

            public <T> Map<String, T> lookupMap(Class<T> type) {
                return Map.of();
            }
        };

        private Builder(String command, String commandName, List<String> args, MessageBuilderFactory messageBuilderFactory) {
            this.command = Objects.requireNonNull(command, "command");
            this.commandName = Objects.requireNonNull(commandName, "commandName");
            this.args = Objects.requireNonNull(args, "args");
            this.messageBuilderFactory = Objects.requireNonNull(messageBuilderFactory, "messageBuilderFactory");
            this.logger = new AccumulatingLogger();
        }

        public Builder lookup(@Nonnull Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup);
            return this;
        }

        public Builder cwd(Path cwd) {
            this.cwd = cwd;
            return this;
        }

        public Builder mavenHome(Path mavenHome) {
            this.mavenHome = mavenHome;
            return this;
        }

        public Builder userHome(Path userHome) {
            this.userHome = userHome;
            return this;
        }

        public Builder stdIn(InputStream stdIn) {
            this.stdIn = stdIn;
            return this;
        }

        public Builder stdOut(OutputStream stdOut) {
            this.stdOut = stdOut;
            return this;
        }

        public Builder stdErr(OutputStream stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        public Builder embedded(boolean embedded) {
            this.embedded = embedded;
            return this;
        }

        public ParserRequest build() {
            return new ParserRequestImpl(this.command, this.commandName, List.copyOf(this.args), this.lookup.lookupOptional(Logger.class).orElse(this.logger), this.messageBuilderFactory, this.lookup, this.cwd, this.mavenHome, this.userHome, this.stdIn, this.stdOut, this.stdErr, this.embedded);
        }

        private static class ParserRequestImpl
        implements ParserRequest {
            private final String command;
            private final String commandName;
            private final Logger logger;
            private final MessageBuilderFactory messageBuilderFactory;
            private final List<String> args;
            private final Lookup lookup;
            private final Path cwd;
            private final Path mavenHome;
            private final Path userHome;
            private final InputStream stdIn;
            private final OutputStream stdOut;
            private final OutputStream stdErr;
            private final boolean embedded;

            private ParserRequestImpl(String command, String commandName, List<String> args, Logger logger, MessageBuilderFactory messageBuilderFactory, Lookup lookup, Path cwd, Path mavenHome, Path userHome, InputStream stdIn, OutputStream stdOut, OutputStream stdErr, boolean embedded) {
                this.command = Objects.requireNonNull(command, "command");
                this.commandName = Objects.requireNonNull(commandName, "commandName");
                this.args = List.copyOf((Collection)Objects.requireNonNull(args, "args"));
                this.logger = Objects.requireNonNull(logger, "logger");
                this.messageBuilderFactory = Objects.requireNonNull(messageBuilderFactory, "messageBuilderFactory");
                this.lookup = Objects.requireNonNull(lookup, "lookup");
                this.cwd = cwd;
                this.mavenHome = mavenHome;
                this.userHome = userHome;
                this.stdIn = stdIn;
                this.stdOut = stdOut;
                this.stdErr = stdErr;
                this.embedded = embedded;
            }

            @Override
            public String command() {
                return this.command;
            }

            @Override
            public String commandName() {
                return this.commandName;
            }

            @Override
            public Logger logger() {
                return this.logger;
            }

            @Override
            public MessageBuilderFactory messageBuilderFactory() {
                return this.messageBuilderFactory;
            }

            @Override
            public List<String> args() {
                return this.args;
            }

            @Override
            public Lookup lookup() {
                return this.lookup;
            }

            @Override
            public Path cwd() {
                return this.cwd;
            }

            @Override
            public Path mavenHome() {
                return this.mavenHome;
            }

            @Override
            public Path userHome() {
                return this.userHome;
            }

            @Override
            public InputStream stdIn() {
                return this.stdIn;
            }

            @Override
            public OutputStream stdOut() {
                return this.stdOut;
            }

            @Override
            public OutputStream stdErr() {
                return this.stdErr;
            }

            @Override
            public boolean embedded() {
                return this.embedded;
            }
        }
    }
}

