/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@ThreadSafe
public interface ProtoSession {
    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public Map<String, String> getEffectiveProperties();

    @Nonnull
    public Instant getStartTime();

    @Nonnull
    public Path getTopDirectory();

    @Nonnull
    public Path getRootDirectory();

    @Nonnull
    default public Builder toBuilder() {
        try {
            return new Builder(this.getUserProperties(), this.getSystemProperties(), this.getStartTime(), this.getTopDirectory(), this.getRootDirectory());
        }
        catch (IllegalStateException e) {
            return new Builder(this.getUserProperties(), this.getSystemProperties(), this.getStartTime(), this.getTopDirectory(), null);
        }
    }

    public static Builder newBuilder() {
        return new Builder().withStartTime(MonotonicClock.now());
    }

    public static class Builder {
        private Map<String, String> userProperties;
        private Map<String, String> systemProperties;
        private Instant startTime;
        private Path topDirectory;
        private Path rootDirectory;

        private Builder() {
        }

        private Builder(Map<String, String> userProperties, Map<String, String> systemProperties, Instant startTime, Path topDirectory, Path rootDirectory) {
            this.userProperties = userProperties;
            this.systemProperties = systemProperties;
            this.startTime = startTime;
            this.topDirectory = topDirectory;
            this.rootDirectory = rootDirectory;
        }

        public Builder withUserProperties(@Nonnull Map<String, String> userProperties) {
            this.userProperties = new HashMap<String, String>(userProperties);
            return this;
        }

        public Builder withSystemProperties(@Nonnull Map<String, String> systemProperties) {
            this.systemProperties = new HashMap<String, String>(systemProperties);
            return this;
        }

        public Builder withStartTime(@Nonnull Instant startTime) {
            this.startTime = Objects.requireNonNull(startTime, "startTime");
            return this;
        }

        public Builder withTopDirectory(@Nonnull Path topDirectory) {
            this.topDirectory = Objects.requireNonNull(topDirectory, "topDirectory");
            return this;
        }

        public Builder withRootDirectory(@Nullable Path rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public ProtoSession build() {
            return new Impl(this.userProperties, this.systemProperties, this.startTime, this.topDirectory, this.rootDirectory);
        }

        private static class Impl
        implements ProtoSession {
            private final Map<String, String> userProperties;
            private final Map<String, String> systemProperties;
            private final Map<String, String> effectiveProperties;
            private final Instant startTime;
            private final Path topDirectory;
            private final Path rootDirectory;

            private Impl(Map<String, String> userProperties, Map<String, String> systemProperties, Instant startTime, Path topDirectory, Path rootDirectory) {
                this.userProperties = Map.copyOf(userProperties);
                this.systemProperties = Map.copyOf(systemProperties);
                HashMap<String, String> cp = new HashMap<String, String>(systemProperties);
                cp.putAll(userProperties);
                this.effectiveProperties = Map.copyOf(cp);
                this.startTime = Objects.requireNonNull(startTime);
                this.topDirectory = Objects.requireNonNull(topDirectory);
                this.rootDirectory = rootDirectory;
            }

            @Override
            public Map<String, String> getUserProperties() {
                return this.userProperties;
            }

            @Override
            public Map<String, String> getSystemProperties() {
                return this.systemProperties;
            }

            @Override
            public Map<String, String> getEffectiveProperties() {
                return this.effectiveProperties;
            }

            @Override
            public Instant getStartTime() {
                return this.startTime;
            }

            @Override
            public Path getTopDirectory() {
                return this.topDirectory;
            }

            @Override
            public Path getRootDirectory() {
                if (this.rootDirectory == null) {
                    throw new IllegalStateException("root directory not set");
                }
                return this.rootDirectory;
            }
        }
    }
}

