/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.compat.interactivity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.services.Prompter;
import org.apache.maven.api.services.PrompterException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.components.interactivity.OutputHandler;
import org.eclipse.sisu.Priority;

@Named
@Singleton
@Priority(value=10)
@Experimental
public class LegacyPlexusInteractivity
implements org.codehaus.plexus.components.interactivity.Prompter,
InputHandler,
OutputHandler {
    private final Prompter prompter;

    @Inject
    public LegacyPlexusInteractivity(Prompter prompter) {
        this.prompter = prompter;
    }

    public String readLine() throws IOException {
        try {
            return this.prompter.prompt(null);
        }
        catch (PrompterException e) {
            throw new IOException("Unable to prompt", e);
        }
    }

    public String readPassword() throws IOException {
        try {
            return this.prompter.promptForPassword(null);
        }
        catch (PrompterException e) {
            throw new IOException("Unable to prompt", e);
        }
    }

    public List<String> readMultipleLines() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = this.readLine();
        while (line != null && !line.isEmpty()) {
            lines.add(line);
            line = this.readLine();
        }
        return lines;
    }

    public void write(String line) throws IOException {
        try {
            this.prompter.showMessage(line);
        }
        catch (PrompterException e) {
            throw new IOException("Unable to prompt", e);
        }
    }

    public void writeLine(String line) throws IOException {
        try {
            this.prompter.showMessage(line + System.lineSeparator());
        }
        catch (PrompterException e) {
            throw new IOException("Unable to prompt", e);
        }
    }

    public String prompt(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.prompter.prompt(message, null, null);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, String defaultReply) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.prompter.prompt(message, null, defaultReply);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.prompter.prompt(message, possibleValues, null);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String prompt(String message, List possibleValues, String defaultReply) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.prompter.prompt(message, possibleValues, defaultReply);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to prompt", (Throwable)e);
        }
    }

    public String promptForPassword(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            return this.prompter.promptForPassword(message);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to promptForPassword", (Throwable)e);
        }
    }

    public void showMessage(String message) throws org.codehaus.plexus.components.interactivity.PrompterException {
        try {
            this.prompter.showMessage(message);
        }
        catch (PrompterException e) {
            throw new org.codehaus.plexus.components.interactivity.PrompterException("Unable to showMessage", (Throwable)e);
        }
    }
}

