/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.value;

import hidden.org.apache.jackrabbit.value.BaseValue;
import hidden.org.apache.jackrabbit.value.BinaryValue;
import hidden.org.apache.jackrabbit.value.BooleanValue;
import hidden.org.apache.jackrabbit.value.DateValue;
import hidden.org.apache.jackrabbit.value.DoubleValue;
import hidden.org.apache.jackrabbit.value.LongValue;
import hidden.org.apache.jackrabbit.value.NameValue;
import hidden.org.apache.jackrabbit.value.PathValue;
import hidden.org.apache.jackrabbit.value.ReferenceValue;
import hidden.org.apache.jackrabbit.value.StringValue;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;

public class ValueFactoryImpl
implements ValueFactory {
    private static final ValueFactory valueFactory = new ValueFactoryImpl();

    protected ValueFactoryImpl() {
    }

    public static ValueFactory getInstance() {
        return valueFactory;
    }

    public Value createValue(boolean value) {
        return new BooleanValue(value);
    }

    public Value createValue(Calendar value) {
        return new DateValue(value);
    }

    public Value createValue(double value) {
        return new DoubleValue(value);
    }

    public Value createValue(InputStream value) {
        return new BinaryValue(value);
    }

    public Value createValue(long value) {
        return new LongValue(value);
    }

    public Value createValue(Node value) throws RepositoryException {
        return new ReferenceValue(value);
    }

    public Value createValue(String value) {
        return new StringValue(value);
    }

    public Value createValue(String value, int type) throws ValueFormatException {
        BaseValue val;
        switch (type) {
            case 1: {
                val = new StringValue(value);
                break;
            }
            case 6: {
                val = BooleanValue.valueOf(value);
                break;
            }
            case 4: {
                val = DoubleValue.valueOf(value);
                break;
            }
            case 3: {
                val = LongValue.valueOf(value);
                break;
            }
            case 5: {
                val = DateValue.valueOf(value);
                break;
            }
            case 7: {
                val = NameValue.valueOf(value);
                break;
            }
            case 8: {
                val = PathValue.valueOf(value);
                break;
            }
            case 9: {
                val = ReferenceValue.valueOf(value);
                break;
            }
            case 2: {
                val = new BinaryValue(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type constant: " + type);
            }
        }
        return val;
    }
}

