#ifndef XDKWRL_PRETTYPRINTER_H
#define XDKWRL_PRETTYPRINTER_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/proto.h>
#include <iostream>
#include <map>
#include <stack>

namespace wrl
{
  class Scene;
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of PrettyPrinter
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API PrettyPrinter
  {
  public:
    PrettyPrinter(std::ostream& s);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFBool&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFColor&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFFloat&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFImage&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFInt32&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFNode&     v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFRotation& v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFString&   v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFTime&     v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFVec2f&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const SFVec3f&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFColor&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFFloat&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFInt32&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFNode&     v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFRotation& v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFString&   v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFTime&     v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFVec2f&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const MFVec3f&    v);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const Node::FieldHandle& h);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const Node::EventInHandle& h);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const Node::EventOutHandle& h);
    friend XDKWRL_API PrettyPrinter& operator<<(PrettyPrinter& p,const Scene& s);
  protected:
    void inc();
    void dec();
    void newline();
  private:
    std::ostream*                            ostm_;
    int                                      indent_;
    bool                                     bol_;
    std::map<Node*,std::string>              definedNodes_;
    std::stack<ProtoDeclaration::BindingMap> fieldBindingsStack_;
    std::stack<ProtoDeclaration::BindingMap> eventInBindingsStack_;
    std::stack<ProtoDeclaration::BindingMap> eventOutBindingsStack_;
    unsigned int                             forcep_;
    bool                                     forcePrinting_;
  };
};
#endif // XDKWRL_PRETTYPRINTER_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("." "../../../src/xdkwrl/tools/")
// End:
