#ifndef XDKWRL_TRIMMEDSURFACE_H
#define XDKWRL_TRIMMEDSURFACE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of TrimmedSurface
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API TrimmedSurface : public Node
  {
   public:
     TrimmedSurface(const char* name="");
     virtual ~TrimmedSurface();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     trimmingContour;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     surface;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     addTrimmingContour;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     removeTrimmingContour;
      /*!
       * Set event associated to exposedField trimmingContour
       */
       EventIn<MFNode>     set_trimmingContour;
      /*!
       * Set event associated to exposedField surface
       */
       EventIn<SFNode>     set_surface;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField trimmingContour
       */
       EventOut<MFNode>     trimmingContour_changed;
      /*!
       * Changed event associated to exposedField surface
       */
       EventOut<SFNode>     surface_changed;
  //!@}
  };
};
//************************************************************
// Implementation of TrimmedSurface
//************************************************************
/*!
 * Returns <code>"TrimmedSurface"</code>. Useful for printing.
 */
inline const char*
wrl::TrimmedSurface::typeName() const
{
  return "TrimmedSurface";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::TrimmedSurface::nbFields() const
{
   return 2;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::TrimmedSurface::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::TrimmedSurface::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_TRIMMEDSURFACE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
