#ifndef XDKWRL_TEXTURETRANSFORM_H
#define XDKWRL_TEXTURETRANSFORM_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of TextureTransform
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API TextureTransform : public Node
  {
   public:
     TextureTransform(const char* name="");
     virtual ~TextureTransform();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       center.setXY(0.0f,0.0f);
       \endcode
       */
       SFVec2f    center;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       rotation = 0.0f;
       \endcode
       */
       SFFloat    rotation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       scale.setXY(1.0f,1.0f);
       \endcode
       */
       SFVec2f    scale;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       translation.setXY(0.0f,0.0f);
       \endcode
       */
       SFVec2f    translation;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField center
       */
       EventIn<SFVec2f>    set_center;
      /*!
       * Set event associated to exposedField rotation
       */
       EventIn<SFFloat>    set_rotation;
      /*!
       * Set event associated to exposedField scale
       */
       EventIn<SFVec2f>    set_scale;
      /*!
       * Set event associated to exposedField translation
       */
       EventIn<SFVec2f>    set_translation;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField center
       */
       EventOut<SFVec2f>    center_changed;
      /*!
       * Changed event associated to exposedField rotation
       */
       EventOut<SFFloat>    rotation_changed;
      /*!
       * Changed event associated to exposedField scale
       */
       EventOut<SFVec2f>    scale_changed;
      /*!
       * Changed event associated to exposedField translation
       */
       EventOut<SFVec2f>    translation_changed;
  //!@}
  };
};
//************************************************************
// Implementation of TextureTransform
//************************************************************
/*!
 * Returns <code>"TextureTransform"</code>. Useful for printing.
 */
inline const char*
wrl::TextureTransform::typeName() const
{
  return "TextureTransform";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::TextureTransform::nbFields() const
{
   return 4;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::TextureTransform::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::TextureTransform::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_TEXTURETRANSFORM_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
