#ifndef XDKWRL_SWITCH_H
#define XDKWRL_SWITCH_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/sfint32.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Switch
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Switch : public Node
  {
   public:
     Switch(const char* name="");
     virtual ~Switch();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     choice;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       whichChoice = -1;
       \endcode
       */
       SFInt32    whichChoice;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField choice
       */
       EventIn<MFNode>     set_choice;
      /*!
       * Set event associated to exposedField whichChoice
       */
       EventIn<SFInt32>    set_whichChoice;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField choice
       */
       EventOut<MFNode>     choice_changed;
      /*!
       * Changed event associated to exposedField whichChoice
       */
       EventOut<SFInt32>    whichChoice_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Switch
//************************************************************
/*!
 * Returns <code>"Switch"</code>. Useful for printing.
 */
inline const char*
wrl::Switch::typeName() const
{
  return "Switch";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Switch::nbFields() const
{
   return 2;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Switch::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Switch::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_SWITCH_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
