#ifndef XDKWRL_SOUND_H
#define XDKWRL_SOUND_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Sound
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Sound : public Node
  {
   public:
     Sound(const char* name="");
     virtual ~Sound();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       direction.setXYZ(0.0f,0.0f,1.0f);
       \endcode
       */
       SFVec3f    direction;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       intensity = 1.0f;
       \endcode
       */
       SFFloat    intensity;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       location.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    location;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       maxBack = 10.0f;
       \endcode
       */
       SFFloat    maxBack;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       maxFront = 10.0f;
       \endcode
       */
       SFFloat    maxFront;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       minBack = 1.0f;
       \endcode
       */
       SFFloat    minBack;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       minFront = 1.0f;
       \endcode
       */
       SFFloat    minFront;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       priority = 0.0f;
       \endcode
       */
       SFFloat    priority;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     source;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       spatialize = true;
        \endcode
       */
       SFBool     spatialize;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField direction
       */
       EventIn<SFVec3f>    set_direction;
      /*!
       * Set event associated to exposedField intensity
       */
       EventIn<SFFloat>    set_intensity;
      /*!
       * Set event associated to exposedField location
       */
       EventIn<SFVec3f>    set_location;
      /*!
       * Set event associated to exposedField maxBack
       */
       EventIn<SFFloat>    set_maxBack;
      /*!
       * Set event associated to exposedField maxFront
       */
       EventIn<SFFloat>    set_maxFront;
      /*!
       * Set event associated to exposedField minBack
       */
       EventIn<SFFloat>    set_minBack;
      /*!
       * Set event associated to exposedField minFront
       */
       EventIn<SFFloat>    set_minFront;
      /*!
       * Set event associated to exposedField priority
       */
       EventIn<SFFloat>    set_priority;
      /*!
       * Set event associated to exposedField source
       */
       EventIn<SFNode>     set_source;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField direction
       */
       EventOut<SFVec3f>    direction_changed;
      /*!
       * Changed event associated to exposedField intensity
       */
       EventOut<SFFloat>    intensity_changed;
      /*!
       * Changed event associated to exposedField location
       */
       EventOut<SFVec3f>    location_changed;
      /*!
       * Changed event associated to exposedField maxBack
       */
       EventOut<SFFloat>    maxBack_changed;
      /*!
       * Changed event associated to exposedField maxFront
       */
       EventOut<SFFloat>    maxFront_changed;
      /*!
       * Changed event associated to exposedField minBack
       */
       EventOut<SFFloat>    minBack_changed;
      /*!
       * Changed event associated to exposedField minFront
       */
       EventOut<SFFloat>    minFront_changed;
      /*!
       * Changed event associated to exposedField priority
       */
       EventOut<SFFloat>    priority_changed;
      /*!
       * Changed event associated to exposedField source
       */
       EventOut<SFNode>     source_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Sound
//************************************************************
/*!
 * Returns <code>"Sound"</code>. Useful for printing.
 */
inline const char*
wrl::Sound::typeName() const
{
  return "Sound";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Sound::nbFields() const
{
   return 10;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Sound::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Sound::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_SOUND_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
