#ifndef XDKWRL_PLANESENSOR_H
#define XDKWRL_PLANESENSOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfvec2f.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of PlaneSensor
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API PlaneSensor : public Node
  {
   public:
     PlaneSensor(const char* name="");
     virtual ~PlaneSensor();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       autoOffset = true;
       \endcode
       */
       SFBool     autoOffset;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       enabled = true;
       \endcode
       */
       SFBool     enabled;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       maxPosition.setXY(-1.0f,-1.0f);
       \endcode
       */
       SFVec2f    maxPosition;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       minPosition.setXY(0.0f,0.0f);
       \endcode
       */
       SFVec2f    minPosition;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       offset.setXYZ(0.0f,0.0f,0.0f);
       \endcode
       */
       SFVec3f    offset;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField autoOffset
       */
       EventIn<SFBool>     set_autoOffset;
      /*!
       * Set event associated to exposedField enabled
       */
       EventIn<SFBool>     set_enabled;
      /*!
       * Set event associated to exposedField maxPosition
       */
       EventIn<SFVec2f>    set_maxPosition;
      /*!
       * Set event associated to exposedField minPosition
       */
       EventIn<SFVec2f>    set_minPosition;
      /*!
       * Set event associated to exposedField offset
       */
       EventIn<SFVec3f>    set_offset;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isActive;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    trackPoint_changed;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    translation_changed;
      /*!
       * Changed event associated to exposedField autoOffset
       */
       EventOut<SFBool>     autoOffset_changed;
      /*!
       * Changed event associated to exposedField enabled
       */
       EventOut<SFBool>     enabled_changed;
      /*!
       * Changed event associated to exposedField maxPosition
       */
       EventOut<SFVec2f>    maxPosition_changed;
      /*!
       * Changed event associated to exposedField minPosition
       */
       EventOut<SFVec2f>    minPosition_changed;
      /*!
       * Changed event associated to exposedField offset
       */
       EventOut<SFVec3f>    offset_changed;
  //!@}
  };
};
//************************************************************
// Implementation of PlaneSensor
//************************************************************
/*!
 * Returns <code>"PlaneSensor"</code>. Useful for printing.
 */
inline const char*
wrl::PlaneSensor::typeName() const
{
  return "PlaneSensor";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::PlaneSensor::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::PlaneSensor::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::PlaneSensor::nbEventsOut() const
{
   return 3;
}
#endif // XDKWRL_PLANESENSOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
