#ifndef XDKWRL_NURBSSURFACE_H
#define XDKWRL_NURBSSURFACE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of NurbsSurface
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API NurbsSurface : public Node
  {
   public:
     NurbsSurface(const char* name="");
     virtual ~NurbsSurface();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFVec3f default value
       */
       MFVec3f    controlPoint;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     texCoord;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       uTessellation = 0;
       \endcode
       */
       SFInt32    uTessellation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       vTessellation = 0;
       \endcode
       */
       SFInt32    vTessellation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    weight;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ccw = true;
        \endcode
       */
       SFBool     ccw;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       solid = true;
        \endcode
       */
       SFBool     solid;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       uDimension = 0;
        \endcode
       */
       SFInt32    uDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    uKnot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       uOrder = 3;
        \endcode
       */
       SFInt32    uOrder;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       vDimension = 0;
        \endcode
       */
       SFInt32    vDimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    vKnot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       vOrder = 3;
        \endcode
       */
       SFInt32    vOrder;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField controlPoint
       */
       EventIn<MFVec3f>    set_controlPoint;
      /*!
       * Set event associated to exposedField texCoord
       */
       EventIn<SFNode>     set_texCoord;
      /*!
       * Set event associated to exposedField uTessellation
       */
       EventIn<SFInt32>    set_uTessellation;
      /*!
       * Set event associated to exposedField vTessellation
       */
       EventIn<SFInt32>    set_vTessellation;
      /*!
       * Set event associated to exposedField weight
       */
       EventIn<MFFloat>    set_weight;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField controlPoint
       */
       EventOut<MFVec3f>    controlPoint_changed;
      /*!
       * Changed event associated to exposedField texCoord
       */
       EventOut<SFNode>     texCoord_changed;
      /*!
       * Changed event associated to exposedField uTessellation
       */
       EventOut<SFInt32>    uTessellation_changed;
      /*!
       * Changed event associated to exposedField vTessellation
       */
       EventOut<SFInt32>    vTessellation_changed;
      /*!
       * Changed event associated to exposedField weight
       */
       EventOut<MFFloat>    weight_changed;
  //!@}
  };
};
//************************************************************
// Implementation of NurbsSurface
//************************************************************
/*!
 * Returns <code>"NurbsSurface"</code>. Useful for printing.
 */
inline const char*
wrl::NurbsSurface::typeName() const
{
  return "NurbsSurface";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::NurbsSurface::nbFields() const
{
   return 13;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::NurbsSurface::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::NurbsSurface::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_NURBSSURFACE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
