#ifndef XDKWRL_NURBSPOSITIONINTERPOLATOR_H
#define XDKWRL_NURBSPOSITIONINTERPOLATOR_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfint32.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of NurbsPositionInterpolator
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API NurbsPositionInterpolator : public Node
  {
   public:
     NurbsPositionInterpolator(const char* name="");
     virtual ~NurbsPositionInterpolator();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       dimension = 0;
       \endcode
       */
       SFInt32    dimension;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFVec3f default value
       */
       MFVec3f    keyValue;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    keyWeight;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    knot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       order = 4;
       \endcode
       */
       SFInt32    order;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFFloat>    set_fraction;
      /*!
       * Set event associated to exposedField dimension
       */
       EventIn<SFInt32>    set_dimension;
      /*!
       * Set event associated to exposedField keyValue
       */
       EventIn<MFVec3f>    set_keyValue;
      /*!
       * Set event associated to exposedField keyWeight
       */
       EventIn<MFFloat>    set_keyWeight;
      /*!
       * Set event associated to exposedField knot
       */
       EventIn<MFFloat>    set_knot;
      /*!
       * Set event associated to exposedField order
       */
       EventIn<SFInt32>    set_order;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFVec3f>    value_changed;
      /*!
       * Changed event associated to exposedField dimension
       */
       EventOut<SFInt32>    dimension_changed;
      /*!
       * Changed event associated to exposedField keyValue
       */
       EventOut<MFVec3f>    keyValue_changed;
      /*!
       * Changed event associated to exposedField keyWeight
       */
       EventOut<MFFloat>    keyWeight_changed;
      /*!
       * Changed event associated to exposedField knot
       */
       EventOut<MFFloat>    knot_changed;
      /*!
       * Changed event associated to exposedField order
       */
       EventOut<SFInt32>    order_changed;
  //!@}
  };
};
//************************************************************
// Implementation of NurbsPositionInterpolator
//************************************************************
/*!
 * Returns <code>"NurbsPositionInterpolator"</code>. Useful for printing.
 */
inline const char*
wrl::NurbsPositionInterpolator::typeName() const
{
  return "NurbsPositionInterpolator";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::NurbsPositionInterpolator::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::NurbsPositionInterpolator::nbEventsIn() const
{
   return 1;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::NurbsPositionInterpolator::nbEventsOut() const
{
   return 1;
}
#endif // XDKWRL_NURBSPOSITIONINTERPOLATOR_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
