#ifndef XDKWRL_NURBSCURVE_H
#define XDKWRL_NURBSCURVE_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mffloat.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/fieldtypes/sfint32.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of NurbsCurve
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API NurbsCurve : public Node
  {
   public:
     NurbsCurve(const char* name="");
     virtual ~NurbsCurve();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFVec3f default value
       */
       MFVec3f    controlPoint;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    weight;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       tessellation = 0;
       \endcode
       */
       SFInt32    tessellation;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFFloat default value
       */
       MFFloat    knot;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       order = 3;
        \endcode
       */
       SFInt32    order;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField controlPoint
       */
       EventIn<MFVec3f>    set_controlPoint;
      /*!
       * Set event associated to exposedField weight
       */
       EventIn<MFFloat>    set_weight;
      /*!
       * Set event associated to exposedField tessellation
       */
       EventIn<SFInt32>    set_tessellation;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField controlPoint
       */
       EventOut<MFVec3f>    controlPoint_changed;
      /*!
       * Changed event associated to exposedField weight
       */
       EventOut<MFFloat>    weight_changed;
      /*!
       * Changed event associated to exposedField tessellation
       */
       EventOut<SFInt32>    tessellation_changed;
  //!@}
  };
};
//************************************************************
// Implementation of NurbsCurve
//************************************************************
/*!
 * Returns <code>"NurbsCurve"</code>. Useful for printing.
 */
inline const char*
wrl::NurbsCurve::typeName() const
{
  return "NurbsCurve";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::NurbsCurve::nbFields() const
{
   return 5;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::NurbsCurve::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::NurbsCurve::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_NURBSCURVE_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
