#ifndef XDKWRL_INDEXEDFACESET_H
#define XDKWRL_INDEXEDFACESET_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfint32.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfnode.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of IndexedFaceSet
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API IndexedFaceSet : public Node
  {
   public:
     IndexedFaceSet(const char* name="");
     virtual ~IndexedFaceSet();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     color;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     coord;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     normal;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     texCoord;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ccw = true;
        \endcode
       */
       SFBool     ccw;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    colorIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       colorPerVertex = true;
        \endcode
       */
       SFBool     colorPerVertex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       convex = true;
        \endcode
       */
       SFBool     convex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    coordIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       creaseAngle = 0.0f;
        \endcode
       */
       SFFloat    creaseAngle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    normalIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       normalPerVertex = true;
        \endcode
       */
       SFBool     normalPerVertex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       solid = true;
        \endcode
       */
       SFBool     solid;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFInt32 default value
       */
       MFInt32    texCoordIndex;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_colorIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_coordIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_normalIndex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFInt32>    set_texCoordIndex;
      /*!
       * Set event associated to exposedField color
       */
       EventIn<SFNode>     set_color;
      /*!
       * Set event associated to exposedField coord
       */
       EventIn<SFNode>     set_coord;
      /*!
       * Set event associated to exposedField normal
       */
       EventIn<SFNode>     set_normal;
      /*!
       * Set event associated to exposedField texCoord
       */
       EventIn<SFNode>     set_texCoord;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField color
       */
       EventOut<SFNode>     color_changed;
      /*!
       * Changed event associated to exposedField coord
       */
       EventOut<SFNode>     coord_changed;
      /*!
       * Changed event associated to exposedField normal
       */
       EventOut<SFNode>     normal_changed;
      /*!
       * Changed event associated to exposedField texCoord
       */
       EventOut<SFNode>     texCoord_changed;
  //!@}
  };
};
//************************************************************
// Implementation of IndexedFaceSet
//************************************************************
/*!
 * Returns <code>"IndexedFaceSet"</code>. Useful for printing.
 */
inline const char*
wrl::IndexedFaceSet::typeName() const
{
  return "IndexedFaceSet";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::IndexedFaceSet::nbFields() const
{
   return 14;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::IndexedFaceSet::nbEventsIn() const
{
   return 4;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::IndexedFaceSet::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_INDEXEDFACESET_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
