#ifndef XDKWRL_GROUP_H
#define XDKWRL_GROUP_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfnode.h>
#include <xdkwrl/fieldtypes/sfvec3f.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Group
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Group : public Node
  {
   public:
     Group(const char* name="");
     virtual ~Group();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to MFNode default value
       */
       MFNode     children;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxCenter.setXYZ(0.0f,0.0f,0.0f);
        \endcode
       */
       SFVec3f    bboxCenter;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       bboxSize.setXYZ(-1.0f,-1.0f,-1.0f);
        \endcode
       */
       SFVec3f    bboxSize;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     addChildren;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFNode>     removeChildren;
      /*!
       * Set event associated to exposedField children
       */
       EventIn<MFNode>     set_children;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField children
       */
       EventOut<MFNode>     children_changed;
  //!@}
  };
};
//************************************************************
// Implementation of Group
//************************************************************
/*!
 * Returns <code>"Group"</code>. Useful for printing.
 */
inline const char*
wrl::Group::typeName() const
{
  return "Group";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Group::nbFields() const
{
   return 3;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Group::nbEventsIn() const
{
   return 2;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Group::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_GROUP_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
