#ifndef XDKWRL_GEOVIEWPOINT_H
#define XDKWRL_GEOVIEWPOINT_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>
#include <xdkwrl/fieldtypes/sfnode.h>
#include <xdkwrl/fieldtypes/sfrotation.h>
#include <xdkwrl/fieldtypes/sfstring.h>
#include <xdkwrl/fieldtypes/sftime.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of GeoViewpoint
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API GeoViewpoint : public Node
  {
   public:
     GeoViewpoint(const char* name="");
     virtual ~GeoViewpoint();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       fieldOfView = 0.785398f;
       \endcode
       */
       SFFloat    fieldOfView;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       headlight = true;
       \endcode
       */
       SFBool     headlight;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       jump = true;
       \endcode
       */
       SFBool     jump;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
       \endcode
       */
       MFString   navType;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       description = string("");
        \endcode
       */
       SFString   description;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to SFNode default value
       */
       SFNode     geoOrigin;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
        \endcode
       */
       MFString   geoSystem;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       orientation.setAxisAndAngle(0.0f,0.0f,1.0f,0.0f);
        \endcode
       */
       SFRotation orientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       position = string("0 0 100000");
        \endcode
       */
       SFString   position;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       speedFactor = 1.0f;
        \endcode
       */
       SFFloat    speedFactor;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFBool>     set_bind;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFString>   set_orientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<SFString>   set_position;
      /*!
       * Set event associated to exposedField fieldOfView
       */
       EventIn<SFFloat>    set_fieldOfView;
      /*!
       * Set event associated to exposedField headlight
       */
       EventIn<SFBool>     set_headlight;
      /*!
       * Set event associated to exposedField jump
       */
       EventIn<SFBool>     set_jump;
      /*!
       * Set event associated to exposedField navType
       */
       EventIn<MFString>   set_navType;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFTime>     bindTime;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventOut<SFBool>     isBound;
      /*!
       * Changed event associated to exposedField fieldOfView
       */
       EventOut<SFFloat>    fieldOfView_changed;
      /*!
       * Changed event associated to exposedField headlight
       */
       EventOut<SFBool>     headlight_changed;
      /*!
       * Changed event associated to exposedField jump
       */
       EventOut<SFBool>     jump_changed;
      /*!
       * Changed event associated to exposedField navType
       */
       EventOut<MFString>   navType_changed;
  //!@}
  };
};
//************************************************************
// Implementation of GeoViewpoint
//************************************************************
/*!
 * Returns <code>"GeoViewpoint"</code>. Useful for printing.
 */
inline const char*
wrl::GeoViewpoint::typeName() const
{
  return "GeoViewpoint";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::GeoViewpoint::nbFields() const
{
   return 10;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::GeoViewpoint::nbEventsIn() const
{
   return 3;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::GeoViewpoint::nbEventsOut() const
{
   return 2;
}
#endif // XDKWRL_GEOVIEWPOINT_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
