#ifndef XDKWRL_GEOORIGIN_H
#define XDKWRL_GEOORIGIN_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfstring.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sfstring.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of GeoOrigin
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API GeoOrigin : public Node
  {
   public:
     GeoOrigin(const char* name="");
     virtual ~GeoOrigin();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       
       \endcode
       */
       MFString   geoSystem;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       geoCoords = string("");
       \endcode
       */
       SFString   geoCoords;
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       rotateYUp = false;
        \endcode
       */
       SFBool     rotateYUp;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * Set event associated to exposedField geoSystem
       */
       EventIn<MFString>   set_geoSystem;
      /*!
       * Set event associated to exposedField geoCoords
       */
       EventIn<SFString>   set_geoCoords;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
      /*!
       * Changed event associated to exposedField geoSystem
       */
       EventOut<MFString>   geoSystem_changed;
      /*!
       * Changed event associated to exposedField geoCoords
       */
       EventOut<SFString>   geoCoords_changed;
  //!@}
  };
};
//************************************************************
// Implementation of GeoOrigin
//************************************************************
/*!
 * Returns <code>"GeoOrigin"</code>. Useful for printing.
 */
inline const char*
wrl::GeoOrigin::typeName() const
{
  return "GeoOrigin";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::GeoOrigin::nbFields() const
{
   return 3;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::GeoOrigin::nbEventsIn() const
{
   return 0;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::GeoOrigin::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_GEOORIGIN_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
