#ifndef XDKWRL_EXTRUSION_H
#define XDKWRL_EXTRUSION_H

#include <xdkwrl/config.h>
#include <xdkwrl/node.h>
#include <xdkwrl/fieldtypes/mfrotation.h>
#include <xdkwrl/fieldtypes/mfvec2f.h>
#include <xdkwrl/fieldtypes/mfvec3f.h>
#include <xdkwrl/fieldtypes/sfbool.h>
#include <xdkwrl/fieldtypes/sffloat.h>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of Extrusion
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  class XDKWRL_API Extrusion : public Node
  {
   public:
     Extrusion(const char* name="");
     virtual ~Extrusion();
     virtual inline unsigned int nbFields() const;
     virtual FieldHandle field(const std::string& n);
     virtual FieldHandle field(unsigned int i);
     virtual bool isSetToDefaultValue(unsigned int i) const;
     virtual inline unsigned int nbEventsIn() const;
     virtual EventInHandle eventIn(const std::string& n);
     virtual EventInHandle eventIn(unsigned int i);
     virtual inline unsigned int nbEventsOut() const;
     virtual EventOutHandle eventOut(const std::string& n);
     virtual EventOutHandle eventOut(unsigned int i);
     inline const char* typeName() const;
     virtual Node* duplicate() const;
     virtual Node* duplicate(std::map<const Node*,Node*>&) const;
     /*!@name Exposed Fields
      * A field that is capable of receiving events via an eventIn to 
      * change its value(s), and generating events via an eventOut 
      * when its value(s) change.
      */
      //!@{
     //!@}
     /*!@name Fields
      * A property or attribute of a node. Each node type has a fixed set
      * of fields. Fields may contain various kinds of data and one or many
      * values. Each field has a default value.
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       beginCap = true;
        \endcode
       */
       SFBool     beginCap;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       ccw = true;
        \endcode
       */
       SFBool     ccw;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       convex = true;
        \endcode
       */
       SFBool     convex;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       creaseAngle = 0.0f;
        \endcode
       */
       SFFloat    creaseAngle;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           crossSection.push_back(SFVec2f(1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,-1.0f));
    crossSection.push_back(SFVec2f(-1.0f,1.0f));
    crossSection.push_back(SFVec2f(1.0f,1.0f));
        \endcode
       */
       MFVec2f    crossSection;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       endCap = true;
        \endcode
       */
       SFBool     endCap;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           orientation.push_back(SFRotation(0.0f,0.0f,1.0f,0.0f));
        \endcode
       */
       MFRotation orientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           scale.push_back(SFVec2f(1.0f,1.0f));
        \endcode
       */
       MFVec2f    scale;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
       solid = true;
        \endcode
       */
       SFBool     solid;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this field.
       * Default value is set to 
       \code
           spine.push_back(SFVec3f(0.0f,0.0f,0.0f));
    spine.push_back(SFVec3f(0.0f,1.0f,0.0f));
        \endcode
       */
       MFVec3f    spine;
     //!@}
     /*!@name Events In
      * 
      */
      //!@{
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFVec2f>    set_crossSection;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFRotation> set_orientation;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFVec2f>    set_scale;
      /*!
       * See <a href="#_details" class="md">Detailed Description</a>
       * for meaning of this event.
       */
       EventIn<MFVec3f>    set_spine;
  //!@}
     /*!@name Events Out
      * 
      */
      //!@{
  //!@}
  };
};
//************************************************************
// Implementation of Extrusion
//************************************************************
/*!
 * Returns <code>"Extrusion"</code>. Useful for printing.
 */
inline const char*
wrl::Extrusion::typeName() const
{
  return "Extrusion";
}
/*!
 * Returns the number of fields (exposed or not) for this node type.
 */
inline unsigned int
wrl::Extrusion::nbFields() const
{
   return 10;
}
/*!
 * Returns the number of events in for this node type.
 */
inline unsigned int
wrl::Extrusion::nbEventsIn() const
{
   return 4;
}
/*!
 * Returns the number of events out for this node type.
 */
inline unsigned int
wrl::Extrusion::nbEventsOut() const
{
   return 0;
}
#endif // XDKWRL_EXTRUSION_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/nodes")
// End:
