#ifndef XDKWRL_SFTIME_H
#define XDKWRL_SFTIME_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of SFTime
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a time value as a (float) number of seconds. Below is
   * included the documentation for this field type from the ISO standard.   
   * \htmlinclude sftime.html
   */
  class XDKWRL_API SFTime 
  {
  public:
    inline SFTime();
    inline SFTime(const double b);
    inline double nbSeconds() const;
    inline void setNbSeconds(const double n);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    inline bool operator==(const SFTime& t) const;
    friend std::ostream& operator<<(std::ostream& s,const SFTime& t);
  protected:
  private:
    long double value_;
  };
  //************************************************************
  // Implementation of SFTime
  //************************************************************
  /*!
   * Creates a SFTime with default value 0.0f. 
   */
  inline
  SFTime::SFTime()
    : value_(0)
  {
  }
  inline
  SFTime::SFTime(const double b)
    : value_(b)
  {
  } 
  inline double
  SFTime::nbSeconds() const
  {
    return value_;
  }
  inline void
  SFTime::setNbSeconds(const double n)
  {
    value_ = n;
  }
  inline const char*
  SFTime::typeName()
  {
    return "SFTime";
  }
  inline FieldTypeId
  SFTime::typeId()
  {
    return sfTime;
  }  
  inline bool
  SFTime::operator==(const SFTime& t) const
  {
    return value_ == t.value_;
  }
};

#endif // XDKWRL_SFTIME_H
