#ifndef XDKWRL_SFROTATION_H
#define XDKWRL_SFROTATION_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  SFRotation
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a rotation of a given angle around an axis. Below is
   * included the documentation for this field type from the ISO standard.   
   * \htmlinclude sfrotation.html
   */
  class XDKWRL_API SFRotation 
  {
  public:
    inline SFRotation();
    inline SFRotation(const float x,const float y,const float z,
		      const float angle);
    inline SFRotation& operator=(const SFRotation& r);
    inline const float* axis() const;
    inline float angle() const;
    inline void setAxis(const float x,const float y,const float z);
    inline void setAngle(const float);
    inline void setAxisAndAngle(const float x,const float y,const float z,
				const float a);
    inline bool operator==(const SFRotation& r) const;
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const SFRotation& f);
  protected:
  private:
    float axis_[3];
    float angle_;
  };
  //************************************************************
  // Implementation of SFRotation
  //************************************************************
  inline
  SFRotation::SFRotation()
    : angle_(0.0f)
  {
    axis_[0] = 0.0f;
    axis_[1] = 0.0f;
    axis_[2] = 1.0f;
  }
  inline
  SFRotation::SFRotation(const float x,const float y,const float z,
			 const float a)
    : angle_(a)    
  {
    axis_[0] = x;
    axis_[1] = y;
    axis_[2] = z;
  }    
  inline SFRotation&
  SFRotation::operator=(const SFRotation& r)
  {
    axis_[0] = r.axis_[0];
    axis_[1] = r.axis_[1];
    axis_[2] = r.axis_[2];
    angle_ = r.angle_;
    return *this;
  }
  inline const float*
  SFRotation::axis() const
  {
    return axis_;
  }
  inline float
  SFRotation::angle() const
  {
    return angle_;
  }
  inline void
  SFRotation::setAxis(const float x,const float y,const float z)
  {
    axis_[0] = x;
    axis_[1] = y;
    axis_[2] = z;
  }
  inline void
  SFRotation::setAngle(const float a)
  {
    angle_ = a;
  }
  inline void
  SFRotation::setAxisAndAngle(const float x,const float y,const float z,
			      const float a)
  {
    axis_[0] = x;
    axis_[1] = y;
    axis_[2] = z;
    angle_ = a;
  }
  inline bool
  SFRotation::operator==(const SFRotation& r) const
  {
    return
      axis_[0] == r.axis_[0] &&
      axis_[1] == r.axis_[1] &&
      axis_[2] == r.axis_[2] &&
      angle_ == r.angle_;
  }
  inline const char*
  SFRotation::typeName()
  {
    return "SFRotation";
  }
  inline FieldTypeId
  SFRotation::typeId()
  {
    return sfRotation;
  }  
};

#endif // XDKWRL_SFROTATION_H
