#ifndef XDKWRL_SFBOOL_H
#define XDKWRL_SFBOOL_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes.h>
#include <iostream>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of SFBool
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   *
   * Represents a boolean value. Below is included the documentation for
   * this field type from the ISO standard.
   * \htmlinclude sfbool.html
   */
  class XDKWRL_API SFBool 
  {
  public:
    inline SFBool();
    inline SFBool(const bool b);
    inline SFBool& operator=(const bool b);
    inline SFBool& operator=(const SFBool b);
    inline operator bool() const;
    inline bool operator==(const SFBool& b);
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const SFBool& f);
  protected:
  private:
    bool value_;
  };
  //************************************************************
  // Implementation of SFBool
  //************************************************************
  /*!
   * Creates a SFBool with default value false. 
   */
  inline
  SFBool::SFBool()
    : value_(false)
  {
  }
  /*!
   * Creates a SFBool with value \p b.
   */
  inline
  SFBool::SFBool(const bool b)
    : value_(b)
  {
  } 
  inline SFBool&
  SFBool::operator=(const bool b)
  {
    value_ = b;
    return *this;
  }
  inline SFBool&
  SFBool::operator=(const SFBool b)
  {
    value_ = b.value_;
    return *this;
  }
  inline
  SFBool::operator bool() const
  {
    return value_;
  }
  inline bool
  SFBool::operator==(const SFBool& b)
  {
    return value_ == b.value_;
  }
  inline const char*
  SFBool::typeName()
  {
    return "SFBool";
  }
  inline FieldTypeId
  SFBool::typeId()
  {
    return sfBool;
  }  
};

#endif // XDKWRL_SFBOOL_H
