#ifndef XDKWRL_MFTIME_H
#define XDKWRL_MFTIME_H

#include <xdkwrl/config.h>
#include <xdkwrl/fieldtypes/sftime.h>
#include <deque>
#include <algorithm>
#include <iterator>

namespace wrl
{
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  // Interface of  MFTime
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  /*! \ingroup fieldtypes
   * 
   * A MFTime is a container of SFTime. It is implemented using a STL's
   * deque so you can benefit from its interface. Most common
   * functionnalities you would use are:
   \code
   MFTime mf;
   mf.push_back(SFTime(60.0f));  // push_back (60.0f); would fail since
   mf.push_front(SFTime(30.0f)); // constructor SFTime(float) is explicit
   mf[0].setNbSeconds(10.0f); 
   \endcode
   * but since it uses STL principles, you have all useful concepts such as
   * iterator, algorithms, etc...
   *
   * Below is included the documentation for this field type from the ISO
   * standard.
   * \htmlinclude sftime.html
   */
  class XDKWRL_API MFTime : public std::deque<SFTime>
  {
  public:
    static inline const char* typeName();
    static inline FieldTypeId typeId();
    friend std::ostream& operator<<(std::ostream& s,const MFTime& f);
  };
  //************************************************************
  // Implementation of MFTime
  //************************************************************
  inline const char*
  MFTime::typeName()
  {
    return "MFTime";
  }
  inline FieldTypeId
  MFTime::typeId()
  {
    return mfTime;
  }  
}

#endif // XDKWRL_MFTIME_H

// Local variables section.
// This is only used by emacs!
// Local Variables:
// ff-search-directories: ("../../" "../../../src/xdkwrl/fieldtypes")
// End:
