/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#ifndef DS_STRTOK_H
#define DS_STRTOK_H
#include <DSCore.h>

/*!
 * @header DSStrTok
 * @discussion The StrTok class is a simple string tokeniser.  It breaks up an input string according to a seperator.
 */

/*!
 * @class DSStrTok
 * @discussion The StrTok class is a simple string tokeniser.  It breaks up an input string according to a seperator.
 */
class EXPSYM DSStrTok {
	private:
		int nElements;
		char ** Elements;
	public:

		/*!
		 * @function DSStrTok
		 * @discussion This constructs a new StrTok for a specified input string, and a specified character to use for breaking it up.
		 * @param string The input string to be broken up.
		 * @param sep The character to use as a seperator.
		 */
		DSStrTok(char * string, char sep=' ');
		/*!
		 * @function ~DSStrTok
		 * @discussion Destroys a StrTok.
		 */
		~DSStrTok();

		/*!
		 * @function getElement
		 * @discussion This function retrieves the specified portion of the broken string.
		 * @param i The 0-based index number of the portion of the string needed.
		 * @result A pointer to the portion of the string requested.
		 */
		char * getElement(int i);
		/*!
		 * @function getNumElements
		 * @discussion This function retrieves the number of portions in the broken string.
		 * @result The number of portions in the larger string.
		 */
		int getNumElements();
};

#endif
