/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

/*!
 * @header DSComponent
 * @discussion This header serves the <A HREF="Classes/DSComponent/index.html">DSComponent</A> class.  It provides the
 * interfaces supported in libds for modules that are loaded on demand.
 */
#ifndef DS_COMPONENT_H
#define DS_COMPONENT_H

#include <DSCore.h>

#include <DSTSHashTable.h>

/*!
 * @class DSComponent
 * @discussion This class provides simple methods for handling self-registering components. 
 */
class EXPSYM DSComponent
{
	private:
		DSTSHashTable * tshashreg;
		DSHashTable * hashreg;
		DSList * listreg;

	public:
		/*!
			@function DSComponent
			@discussion Create a component object.
			@param hash Specifies a HashTable where components should register themselves.
		*/
		DSComponent(DSHashTable * hash);
		/*!
			@function DSComponent
			@discussion Create a component object.
			@param hash Specifies a TSHashTable where components should register themselves.
		*/
		DSComponent(DSTSHashTable * hash);
		/*!
			@function DSComponent
			@discussion Create a component object.
			@param hash Specifies a List where components should register themselves.
		*/
		DSComponent(DSList * list);
		/*!
			@function ~DSComponent
			@discussion Destroy a Thread object.  If a thread has been initiated, it is not terminated.
		*/
		~DSComponent();

		DEPRECATED int loadcomponents(char * dir, char * key_symbol, char * value_symbol);

		/*!
		 * @function loadComponentsPrefixes
		 * @discussion Registers a directory of components into the hashtable.
		 * @param dir Specifies the directory to be searched for components.
		 * @param key_symbol Specifies the exported symbol in the components to return the type of the component.  As of 1.5.2, a negative type indicates a load failure.
		 * @param value_symbol Specifies the name of the exported symbol that should be called (by the application) and will be entered into the value field of the HashTable.
		 * @param with_prefix Specifies if symbols when loaded should be prefixed by their library name, ie., function func in library liblib.so would be liblib_func if TRUE, otherwise just func.
		 * @result The number of components successfully loaded.
		 */
		int loadComponentsPrefixed(char * dir, char * key_symbol, char * value_symbol, BOOL with_prefix=TRUE);


};

#endif

