#!/bin/sh

prefix=__PREFIX
exec_prefix=${prefix}
confdir=${prefix}/etc/junkbuster
logfile=${prefix}/var/log/junkbuster.log

checkinstall() 
{
	# test if conf file is present
	if [ ! -f "$confdir/configfile" ]; then
		echo "Error: $confdir/configfile is missing!"
		echo "Try copying $confdir/configfile.sample to $confdir/configfile"
		echo "        and $confdir/blockfile.sample  to $confdir/blockfile"
		echo "        and $confdir/cookiefile.sample to $confdir/cookiefile"
		exit 1
	fi

	# test if log is present with proper ownership
	if [ ! -f "$logfile" ]
	then
		touch $logfile
		chmod 0644 $logfile
	fi
	chown nobody $logfile
	chgrp nobody $logfile
}

case "$1" in
start)
	checkinstall
	cd ${confdir}
	echo "`date`: Starting junkbuster" >>$logfile
	su -fm nobody -c "$exec_prefix/sbin/junkbuster configfile &"
	;;
stop)
	echo "`date`: Stopping junkbuster" >>$logfile
	killall junkbuster
	;;
restart)
	$0 stop
	$0 start
	;;
*)
	echo "Usage: `basename $0` {start|stop|restart}" >&2
	exit 1
	;;
esac

exit 0

