/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.checksum;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Algorithm;

public final class Checksum
extends AbstractModelObject<Checksum>
implements Domain {
    private static final long serialVersionUID = -5866288321297540463L;
    private final Set<Algorithm> algorithms = new LinkedHashSet<Algorithm>();
    private Boolean individual;
    private String name;
    private Boolean artifacts;
    private Boolean files;
    @JsonIgnore
    private final org.jreleaser.model.api.checksum.Checksum immutable = new org.jreleaser.model.api.checksum.Checksum(){
        private static final long serialVersionUID = -8504526869358696688L;

        public String getName() {
            return Checksum.this.name;
        }

        public boolean isIndividual() {
            return Checksum.this.isIndividual();
        }

        public Set<Algorithm> getAlgorithms() {
            return Collections.unmodifiableSet(Checksum.this.algorithms);
        }

        public boolean isArtifacts() {
            return Checksum.this.isArtifacts();
        }

        public boolean isFiles() {
            return Checksum.this.isFiles();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Checksum.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.checksum.Checksum asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Checksum source) {
        this.name = this.merge(this.name, source.name);
        this.individual = this.merge(this.individual, source.individual);
        this.artifacts = this.merge(this.artifacts, source.artifacts);
        this.files = this.merge(this.files, source.files);
        this.setAlgorithms(this.merge(this.algorithms, source.algorithms));
    }

    public String getResolvedName(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.name, (TemplateContext)props);
    }

    public String getResolvedName(JReleaserContext context, Algorithm algorithm) {
        String resolvedName = context.getModel().getChecksum().getResolvedName(context);
        int pos = resolvedName.lastIndexOf(".");
        resolvedName = pos != -1 ? resolvedName.substring(0, pos) + "_" + algorithm.formatted() + resolvedName.substring(pos) : resolvedName + "." + algorithm.formatted();
        return resolvedName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIndividual() {
        return null != this.individual && this.individual != false;
    }

    public void setIndividual(Boolean individual) {
        this.individual = individual;
    }

    public boolean isIndividualSet() {
        return null != this.individual;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(Set<Algorithm> algorithms) {
        this.algorithms.clear();
        this.algorithms.addAll(algorithms);
    }

    public boolean isArtifacts() {
        return null == this.artifacts || this.artifacts != false;
    }

    public void setArtifacts(Boolean artifacts) {
        this.artifacts = artifacts;
    }

    public boolean isArtifactsSet() {
        return null != this.artifacts;
    }

    public boolean isFiles() {
        return null == this.files || this.files != false;
    }

    public void setFiles(Boolean files) {
        this.files = files;
    }

    public boolean isFilesSet() {
        return null != this.files;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", this.name);
        props.put("individual", this.isIndividual());
        props.put("algorithms", this.algorithms);
        props.put("artifacts", this.isArtifacts());
        props.put("files", this.isFiles());
        return props;
    }
}

