/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.SpecPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileUtils;

public class SpecPackagerProcessor
extends AbstractRepositoryPackagerProcessor<SpecPackager> {
    public SpecPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPrepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        this.setupFiles(distribution, props);
        super.doPrepareDistribution(distribution, props);
    }

    private void setupFiles(Distribution distribution, TemplateContext props) throws PackagerProcessingException {
        Artifact artifact = (Artifact)props.get("distributionArtifact");
        Path artifactPath = artifact.getResolvedPath(this.context, distribution);
        if (distribution.getType() == Distribution.DistributionType.FLAT_BINARY) {
            props.set("projectVersion", (Object)this.context.getModel().getProject().version().toRpmVersion());
            props.set("specDirectories", Collections.emptyList());
            props.set("specBinaries", Collections.singletonList(distribution.getExecutable().resolveExecutable("linux")));
            props.set("specFiles", Collections.emptyList());
            return;
        }
        try {
            FileUtils.CategorizedArchive categorizedArchive = FileUtils.categorizeUnixArchive((String)distribution.getExecutable().resolveWindowsExtension(), (Path)artifactPath);
            props.set("specDirectories", (Object)categorizedArchive.getDirectories());
            props.set("specBinaries", (Object)categorizedArchive.getBinaries());
            props.set("specFiles", (Object)categorizedArchive.getFiles());
            props.set("projectVersion", (Object)this.context.getModel().getProject().version().toRpmVersion());
        }
        catch (IOException e) {
            throw new PackagerProcessingException("ERROR", (Throwable)e);
        }
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.setOrEmpty("distributionJavaMainClass", distribution.getJava().getMainClass());
        props.setOrEmpty("distributionJavaMainModule", distribution.getJava().getMainModule());
        props.set("specPackageName", (Object)((SpecPackager)this.packager).getPackageName());
        props.set("specRelease", (Object)((SpecPackager)this.packager).getRelease());
        props.set("specRequires", (Object)((SpecPackager)this.packager).getRequires());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.set("specRepositoryUrl", (Object)releaser.getResolvedRepoUrl(this.context, ((SpecPackager)this.packager).getRepository().getOwner(), ((SpecPackager)this.packager).getRepository().getResolvedName()));
        props.set("specRepositoryCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context, ((SpecPackager)this.packager).getRepository().getOwner(), ((SpecPackager)this.packager).getRepository().getResolvedName()));
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "app.spec".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve(((SpecPackager)this.packager).getPackageName().concat(".spec")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

