/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.announce;

import java.util.Locale;
import org.jreleaser.model.api.announce.Announcer;
import org.jreleaser.util.StringUtils;

public interface RedditAnnouncer
extends Announcer {
    public static final String TYPE = "reddit";
    public static final String REDDIT_CLIENT_ID = "REDDIT_CLIENT_ID";
    public static final String REDDIT_CLIENT_SECRET = "REDDIT_CLIENT_SECRET";
    public static final String REDDIT_USERNAME = "REDDIT_USERNAME";
    public static final String REDDIT_PASSWORD = "REDDIT_PASSWORD";

    public String getClientId();

    public String getClientSecret();

    public String getUsername();

    public String getPassword();

    public String getSubreddit();

    public String getTitle();

    public String getText();

    public String getTextTemplate();

    public String getUrl();

    public SubmissionType getSubmissionType();

    public static enum SubmissionType {
        SELF,
        LINK;


        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static SubmissionType of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return SubmissionType.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

