/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.decl.AbstractHasTopLevelRules;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSNamespaceRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CascadingStyleSheet
extends AbstractHasTopLevelRules
implements ICSSSourceLocationAware {
    private final ICommonsList<CSSImportRule> m_aImportRules = new CommonsArrayList();
    private final ICommonsList<CSSNamespaceRule> m_aNamespaceRules = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return this.m_aImportRules.isNotEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int n) {
        return (CSSImportRule)this.m_aImportRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        this.m_aImportRules.add((Object)cSSImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int n, @Nonnull CSSImportRule cSSImportRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSImportRule, (String)"ImportRule");
        if (n >= this.getImportRuleCount()) {
            this.m_aImportRules.add((Object)cSSImportRule);
        } else {
            this.m_aImportRules.add(n, (Object)cSSImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule cSSImportRule) {
        return this.m_aImportRules.removeObject((Object)cSSImportRule);
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int n) {
        return this.m_aImportRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllImportRules() {
        return this.m_aImportRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSImportRule> getAllImportRules() {
        return (ICommonsList)this.m_aImportRules.getClone();
    }

    public boolean hasNamespaceRules() {
        return this.m_aNamespaceRules.isNotEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int n) {
        return (CSSNamespaceRule)this.m_aNamespaceRules.getAtIndex(n);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        this.m_aNamespaceRules.add((Object)cSSNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int n, @Nonnull CSSNamespaceRule cSSNamespaceRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSNamespaceRule, (String)"NamespaceRule");
        if (n >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add((Object)cSSNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(n, (Object)cSSNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule cSSNamespaceRule) {
        return this.m_aNamespaceRules.removeObject((Object)cSSNamespaceRule);
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int n) {
        return this.m_aNamespaceRules.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        return this.m_aNamespaceRules.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSNamespaceRule> getAllNamespaceRules() {
        return (ICommonsList)this.m_aNamespaceRules.getClone();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CascadingStyleSheet cascadingStyleSheet = (CascadingStyleSheet)object;
        return this.m_aImportRules.equals(cascadingStyleSheet.m_aImportRules) && this.m_aNamespaceRules.equals(cascadingStyleSheet.m_aNamespaceRules) && this.m_aRules.equals(cascadingStyleSheet.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append((Iterable)this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", (Object)this.m_aRules).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

