/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.BindingGroup;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestElementSchema;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.gui.JFactory;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMeterGuiComponent
extends JPanel
implements JMeterGUIComponent,
Printable {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(AbstractJMeterGuiComponent.class);
    private boolean enabled = true;
    @API(status=API.Status.INTERNAL, since="5.2.0")
    @Deprecated
    protected NamePanel namePanel;
    private final JTextArea commentField = JFactory.tabMovesFocus((JTextArea)new JTextArea());
    @API(status=API.Status.EXPERIMENTAL, since="5.6.3")
    protected final BindingGroup bindingGroup = new BindingGroup();

    protected AbstractJMeterGuiComponent() {
        this.namePanel = new NamePanel();
        this.init();
    }

    @Override
    public void setName(String name) {
        this.namePanel.setName(name);
    }

    public void setComment(String comment) {
        this.commentField.setText(comment);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        log.debug("Setting enabled: {}", (Object)enabled);
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        NamePanel namePanel = this.getNamePanel();
        if (namePanel != null) {
            return namePanel.getName();
        }
        return "";
    }

    public String getComment() {
        return this.commentField.getText();
    }

    @API(status=API.Status.DEPRECATED, since="5.2.0")
    @Deprecated
    protected NamePanel getNamePanel() {
        return this.namePanel;
    }

    protected Component createTitleLabel() {
        return JFactory.big((JLabel)new JLabel(this.getStaticLabel()));
    }

    @Override
    public void configure(TestElement element) {
        this.setName(element.getName());
        this.enabled = element.isEnabled();
        this.commentField.setText(element.getComment());
        this.bindingGroup.updateUi(element);
    }

    @Override
    public void clearGui() {
        this.initGui();
        this.enabled = true;
    }

    private void initGui() {
        this.setName(this.getStaticLabel());
        this.commentField.setText("");
    }

    private void init() {
        this.initGui();
    }

    @Override
    @API(status=API.Status.EXPERIMENTAL, since="5.6.3")
    public void modifyTestElement(TestElement element) {
        JMeterGUIComponent.super.modifyTestElement(element);
        this.modifyTestElementEnabledAndComment(element);
        this.bindingGroup.updateElement(element);
    }

    @API(status=API.Status.DEPRECATED, since="5.6.3")
    protected void configureTestElement(TestElement mc) {
        mc.setName((String)StringUtils.defaultIfEmpty((CharSequence)this.getName(), null));
        TestElementSchema.INSTANCE schema = TestElementSchema.INSTANCE;
        mc.set(schema.getGuiClass(), this.getClass());
        mc.set(schema.getTestClass(), mc.getClass());
        this.modifyTestElementEnabledAndComment(mc);
    }

    private void modifyTestElementEnabledAndComment(TestElement mc) {
        log.debug("setting element to enabled: {}", (Object)this.enabled);
        mc.set(TestElementSchema.INSTANCE.getEnabled(), this.enabled ? null : Boolean.FALSE);
        mc.setComment((String)StringUtils.defaultIfEmpty((CharSequence)this.getComment(), null));
    }

    protected Container makeTitlePanel() {
        JPanel titlePanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        titlePanel.add(this.createTitleLabel(), "span 2");
        JTextField nameField = this.namePanel.getNameField();
        titlePanel.add(JMeterUtils.labelFor(nameField, "name"));
        titlePanel.add(nameField);
        titlePanel.add(JMeterUtils.labelFor(nameField, "testplan_comments"));
        this.commentField.setWrapStyleWord(true);
        this.commentField.setLineWrap(true);
        titlePanel.add(this.commentField);
        return this.wrapTitlePanel(titlePanel);
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.2.0")
    protected Container wrapTitlePanel(Container titlePanel) {
        VerticalPanel vp = new VerticalPanel();
        vp.add(titlePanel);
        return vp;
    }

    protected Border makeBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 5, 10);
    }

    protected JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    protected JScrollPane makeScrollPane(Component comp, int verticalPolicy, int horizontalPolicy) {
        JScrollPane pane = new JScrollPane(comp, verticalPolicy, horizontalPolicy);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    @Override
    public String getStaticLabel() {
        return JMeterUtils.getResString(this.getLabelResource());
    }

    @Override
    public String getDocAnchor() {
        String label = JMeterUtils.getResString(this.getLabelResource(), new Locale("", ""));
        return label.replace(' ', '_');
    }

    @Override
    public JComponent getPrintableComponent() {
        return this;
    }
}

