/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.reporters.ResultCollectorHelper;
import org.apache.jmeter.reporters.Summariser;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.ObjectProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jorphan.util.JMeterError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultCollector
extends AbstractListenerElement
implements SampleListener,
Clearable,
Serializable,
TestStateListener,
Remoteable,
NoThreadClone {
    private static final Logger log = LoggerFactory.getLogger(ResultCollector.class);
    private static final long serialVersionUID = 234L;
    private static final String TEST_IS_LOCAL = "*local*";
    private static final String TESTRESULTS_START = "<testResults>";
    private static final String TESTRESULTS_START_V1_1_PREVER = "<testResults version=\"";
    private static final String TESTRESULTS_START_V1_1_POSTVER = "\">";
    private static final String TESTRESULTS_END = "</testResults>";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final int MIN_XML_FILE_LEN = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length() + "<testResults>".length() + "</testResults>".length();
    public static final String FILENAME = "filename";
    private static final String SAVE_CONFIG = "saveConfig";
    private static final String ERROR_LOGGING = "ResultCollector.error_logging";
    private static final String SUCCESS_ONLY_LOGGING = "ResultCollector.success_only_logging";
    private static final boolean SAVING_AUTOFLUSH = JMeterUtils.getPropDefault("jmeter.save.saveservice.autoflush", false);
    private static final Object LOCK = new Object();
    private static final Map<String, FileEntry> files = new HashMap<String, FileEntry>();
    private static Thread shutdownHook;
    private static int instanceCount;
    private volatile transient PrintWriter out;
    private volatile boolean inTest = false;
    private volatile boolean isStats = false;
    private volatile Summariser summariser;

    public ResultCollector() {
        this(null);
    }

    public ResultCollector(Summariser summer) {
        this.setErrorLogging(false);
        this.setSuccessOnlyLogging(false);
        this.setProperty(new ObjectProperty(SAVE_CONFIG, new SampleSaveConfiguration()));
        this.summariser = summer;
    }

    @Override
    public Object clone() {
        ResultCollector clone = (ResultCollector)super.clone();
        clone.setSaveConfig((SampleSaveConfiguration)clone.getSaveConfig().clone());
        clone.summariser = this.summariser;
        return clone;
    }

    private void setFilenameProperty(String f) {
        this.setProperty(FILENAME, f);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public boolean isErrorLogging() {
        return this.getPropertyAsBoolean(ERROR_LOGGING);
    }

    public final void setErrorLogging(boolean errorLogging) {
        this.setProperty(new BooleanProperty(ERROR_LOGGING, errorLogging));
    }

    public final void setSuccessOnlyLogging(boolean value) {
        if (value) {
            this.setProperty(new BooleanProperty(SUCCESS_ONLY_LOGGING, true));
        } else {
            this.removeProperty(SUCCESS_ONLY_LOGGING);
        }
    }

    public boolean isSuccessOnlyLogging() {
        return this.getPropertyAsBoolean(SUCCESS_ONLY_LOGGING, false);
    }

    public boolean isSampleWanted(boolean success) {
        boolean errorOnly = this.isErrorLogging();
        boolean successOnly = this.isSuccessOnlyLogging();
        return ResultCollector.isSampleWanted(success, errorOnly, successOnly);
    }

    public static boolean isSampleWanted(boolean success, boolean errorOnly, boolean successOnly) {
        return !errorOnly && !successOnly || success && successOnly || !success && errorOnly;
    }

    public void setFilename(String f) {
        if (this.inTest) {
            return;
        }
        this.setFilenameProperty(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded(String host) {
        Object object = LOCK;
        synchronized (object) {
            if (--instanceCount <= 0) {
                if (shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(shutdownHook);
                } else {
                    log.warn("Should not happen: shutdownHook==null, instanceCount={}", (Object)instanceCount);
                }
                ResultCollector.finalizeFileOutput();
                this.out = null;
                this.inTest = false;
            }
        }
        if (this.summariser != null) {
            this.summariser.testEnded(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testStarted(String host) {
        Object object = LOCK;
        synchronized (object) {
            if (instanceCount == 0) {
                shutdownHook = new Thread(new ShutdownHook());
                Runtime.getRuntime().addShutdownHook(shutdownHook);
            }
            ++instanceCount;
            try {
                if (this.out == null) {
                    try {
                        this.out = ResultCollector.getFileWriter(this.getFilename(), this.getSaveConfig());
                    }
                    catch (FileNotFoundException e) {
                        this.out = null;
                    }
                }
                if (this.getVisualizer() != null) {
                    this.isStats = this.getVisualizer().isStats();
                }
            }
            catch (Exception e) {
                log.error("Exception occurred while initializing file output.", (Throwable)e);
            }
        }
        this.inTest = true;
        if (this.summariser != null) {
            this.summariser.testStarted(host);
        }
    }

    @Override
    public void testEnded() {
        this.testEnded(TEST_IS_LOCAL);
    }

    @Override
    public void testStarted() {
        this.testStarted(TEST_IS_LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadExistingFile() {
        Visualizer visualizer = this.getVisualizer();
        if (visualizer == null) {
            return;
        }
        boolean parsedOK = false;
        String filename = this.getFilename();
        File file = new File(filename);
        if (file.exists()) {
            try (BufferedReader dataReader = Files.newBufferedReader(file.toPath());){
                String line = dataReader.readLine();
                dataReader.close();
                if (line == null) {
                    log.warn("{} is empty", (Object)filename);
                    return;
                }
                if (!line.startsWith("<?xml ")) {
                    CSVSaveService.processSamples(filename, visualizer, this);
                    parsedOK = true;
                    return;
                }
                try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
                     BufferedInputStream bufferedInputStream = new BufferedInputStream(fis);){
                    SaveService.loadTestResults(bufferedInputStream, new ResultCollectorHelper(this, visualizer));
                    parsedOK = true;
                    return;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) return;
                    log.warn("Failed to load {} using XStream. Error was: {}", (Object)filename, (Object)e.toString());
                }
                return;
            }
            catch (IOException | RuntimeException | JMeterError e) {
                log.warn("Problem reading JTL file: {}", (Object)file, (Object)e);
                return;
            }
            finally {
                if (!parsedOK) {
                    GuiPackage.showErrorMessage("Error loading results file - see log file", "Result file loader");
                }
            }
        } else {
            GuiPackage.showErrorMessage("Error loading results file - could not open file", "Result file loader");
        }
    }

    private static void writeFileStart(PrintWriter writer, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            writer.print(XML_HEADER);
            writer.print("\n");
            String pi = saveConfig.getXmlPi();
            if (pi.length() > 0) {
                writer.println(pi);
            }
            writer.print(TESTRESULTS_START_V1_1_PREVER);
            writer.print(SaveService.getVERSION());
            writer.print(TESTRESULTS_START_V1_1_POSTVER);
            writer.print("\n");
        } else if (saveConfig.saveFieldNames()) {
            writer.println(CSVSaveService.printableFieldNamesToString(saveConfig));
        }
    }

    private static void writeFileEnd(PrintWriter pw, SampleSaveConfiguration saveConfig) {
        if (saveConfig.saveAsXml()) {
            pw.print("\n");
            pw.print(TESTRESULTS_END);
            pw.print("\n");
        }
    }

    private static PrintWriter getFileWriter(String pFilename, SampleSaveConfiguration saveConfig) throws IOException {
        if (pFilename == null || pFilename.length() == 0) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Getting file: {} in thread {}", (Object)pFilename, (Object)Thread.currentThread().getName());
        }
        String filename = FileServer.resolveBaseRelativeName(pFilename);
        filename = new File(filename).getCanonicalPath();
        FileEntry fe = files.get(filename);
        PrintWriter writer = null;
        boolean trimmed = true;
        if (fe == null) {
            trimmed = saveConfig.saveAsXml() ? ResultCollector.trimLastLine(filename) : new File(filename).exists();
            File pdir = new File(filename).getParentFile();
            if (pdir != null) {
                if (pdir.mkdirs() && log.isInfoEnabled()) {
                    log.info("Folder at {} was created", (Object)pdir.getAbsolutePath());
                }
                if (!pdir.exists()) {
                    log.warn("Error creating directories for {}", (Object)pdir);
                }
            }
            writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename, trimmed)), SaveService.getFileEncoding(StandardCharsets.UTF_8.name())), SAVING_AUTOFLUSH);
            if (log.isDebugEnabled()) {
                log.debug("Opened file: {} in thread {}", (Object)filename, (Object)Thread.currentThread().getName());
            }
            files.put(filename, new FileEntry(writer, saveConfig));
        } else {
            writer = fe.pw;
        }
        if (!trimmed) {
            log.debug("Writing header to file: {}", (Object)filename);
            ResultCollector.writeFileStart(writer, saveConfig);
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean trimLastLine(String filename) {
        try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
            String line;
            long len = raf.length();
            if (len < (long)MIN_XML_FILE_LEN) {
                boolean bl = false;
                return bl;
            }
            raf.seek(len - (long)TESTRESULTS_END.length() - 10L);
            long pos = raf.getFilePointer();
            int end = 0;
            while ((line = raf.readLine()) != null && (end = line.indexOf(TESTRESULTS_END)) < 0) {
                pos = raf.getFilePointer();
            }
            if (line == null) {
                log.warn("Unexpected EOF trying to find XML end marker in {}", (Object)filename);
                boolean bl = false;
                return bl;
            }
            raf.setLength(pos + (long)end);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            if (!log.isWarnEnabled()) return false;
            log.warn("Error trying to find XML terminator. {}", (Object)e.toString());
            return false;
        }
    }

    @Override
    public void sampleStarted(SampleEvent e) {
    }

    @Override
    public void sampleStopped(SampleEvent e) {
    }

    @Override
    public void sampleOccurred(SampleEvent event) {
        SampleResult result = event.getResult();
        if (this.isSampleWanted(result.isSuccessful())) {
            this.sendToVisualizer(result);
            if (this.out != null && !this.isResultMarked(result) && !this.isStats) {
                SampleSaveConfiguration config = this.getSaveConfig();
                result.setSaveConfig(config);
                try {
                    if (config.saveAsXml()) {
                        SaveService.saveSampleResult(event, this.out);
                    } else {
                        CSVSaveService.saveSampleResult(event, this.out);
                    }
                }
                catch (Exception err) {
                    log.error("Error trying to record a sample", (Throwable)err);
                }
            }
        }
        if (this.summariser != null) {
            this.summariser.sampleOccurred(event);
        }
    }

    protected final void sendToVisualizer(SampleResult r) {
        if (this.getVisualizer() != null) {
            this.getVisualizer().add(r);
        }
    }

    private boolean isResultMarked(SampleResult res) {
        String filename = this.getFilename();
        return res.markFile(filename);
    }

    public void flushFile() {
        if (this.out != null) {
            log.info("forced flush through ResultCollector#flushFile");
            this.out.flush();
        }
    }

    private static void finalizeFileOutput() {
        for (Map.Entry<String, FileEntry> me : files.entrySet()) {
            String key = me.getKey();
            FileEntry value = me.getValue();
            try {
                log.debug("Closing: {}", (Object)key);
                ResultCollector.writeFileEnd(value.pw, value.config);
                value.pw.close();
                if (!value.pw.checkError()) continue;
                log.warn("Problem detected during use of {}", (Object)key);
            }
            catch (Exception ex) {
                log.error("Error closing file {}", (Object)key, (Object)ex);
            }
        }
        files.clear();
    }

    public SampleSaveConfiguration getSaveConfig() {
        try {
            return (SampleSaveConfiguration)this.getProperty(SAVE_CONFIG).getObjectValue();
        }
        catch (ClassCastException e) {
            this.setSaveConfig(new SampleSaveConfiguration());
            return this.getSaveConfig();
        }
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.getProperty(SAVE_CONFIG).setObjectValue(saveConfig);
    }

    @Override
    public void clearData() {
    }

    private static final class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.info("Shutdown hook started");
            Object object = LOCK;
            synchronized (object) {
                ResultCollector.finalizeFileOutput();
            }
            log.info("Shutdown hook ended");
        }
    }

    private static class FileEntry {
        final PrintWriter pw;
        final SampleSaveConfiguration config;

        FileEntry(PrintWriter printWriter, SampleSaveConfiguration sampleSaveConfiguration) {
            this.pw = printWriter;
            this.config = sampleSaveConfiguration;
        }
    }
}

