/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jmeter.protocol.http.sampler.HTTPAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.util.JMeterUtils;

public class HTTPFileImpl
extends HTTPAbstractImpl {
    private static final int MAX_BYTES_TO_STORE_PER_REQUEST = JMeterUtils.getPropDefault((String)"httpsampler.max_bytes_to_store_per_request", (int)0xA00000);

    protected HTTPFileImpl(HTTPSamplerBase base) {
        super(base);
    }

    public boolean interrupt() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HTTPSampleResult res = new HTTPSampleResult();
        res.setHTTPMethod("GET");
        res.setURL(url);
        res.setSampleLabel(url.toString());
        InputStream is = null;
        res.sampleStart();
        int bufferSize = 4096;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bufferSize);
        URLConnection conn = url.openConnection();
        is = conn.getInputStream();
        byte[] readBuffer = new byte[bufferSize];
        int bytesReadInBuffer = 0;
        long totalBytes = 0L;
        boolean storeInBOS = true;
        while ((bytesReadInBuffer = is.read(readBuffer)) > -1) {
            if (storeInBOS) {
                if (totalBytes + (long)bytesReadInBuffer <= (long)MAX_BYTES_TO_STORE_PER_REQUEST) {
                    bos.write(readBuffer, 0, bytesReadInBuffer);
                } else {
                    bos.write(readBuffer, 0, (int)((long)MAX_BYTES_TO_STORE_PER_REQUEST - totalBytes));
                    storeInBOS = false;
                }
            }
            totalBytes += (long)bytesReadInBuffer;
        }
        byte[] responseData = bos.toByteArray();
        res.sampleEnd();
        res.setResponseData(responseData);
        res.setBodySize(totalBytes);
        res.setResponseCodeOK();
        res.setResponseMessageOK();
        res.setSuccessful(true);
        StringBuilder ctb = new StringBuilder("text/html");
        String contentEncoding = this.getContentEncoding();
        if (contentEncoding.length() > 0) {
            ctb.append("; charset=");
            ctb.append(contentEncoding);
        }
        String ct = ctb.toString();
        res.setContentType(ct);
        res.setEncodingAndType(ct);
        HTTPSampleResult hTTPSampleResult = res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
        bos.close();
        IOUtils.closeQuietly((Closeable)is, null);
        return hTTPSampleResult;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        HTTPSampleResult hTTPSampleResult2 = this.errorResult(e, res);
                        return hTTPSampleResult2;
                    }
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    IOUtils.closeQuietly(is, null);
                }
            }
        }
    }
}

