/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached.test;

import com.danga.MemCached.MemCachedClient;
import com.danga.MemCached.SockIOPool;
import java.util.Hashtable;

public class MemCachedTest {
    private static Hashtable<Integer, StringBuilder> threadInfo = new Hashtable();

    public static void main(String[] args) {
        int i;
        String[] serverlist = new String[]{"cache1.int.meetup.com:12345", "cache0.int.meetup.com:12345"};
        SockIOPool pool = SockIOPool.getInstance();
        pool.setServers(serverlist);
        pool.setInitConn(5);
        pool.setMinConn(5);
        pool.setMaxConn(50);
        pool.setMaintSleep(30L);
        pool.setNagle(false);
        pool.initialize();
        int threads = Integer.parseInt(args[0]);
        int runs = Integer.parseInt(args[1]);
        int size = 1024 * Integer.parseInt(args[2]);
        int[] obj = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            obj[i2] = i2;
        }
        String[] keys = new String[size];
        for (i = 0; i < size; ++i) {
            keys[i] = "test_key" + i;
        }
        for (i = 0; i < threads; ++i) {
            bench b = new bench(runs, i, obj, keys);
            b.start();
        }
        i = 0;
        while (i < threads) {
            if (threadInfo.containsKey(new Integer(i))) {
                System.out.println(threadInfo.get(new Integer(i)));
                ++i;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        pool.shutDown();
        System.exit(1);
    }

    private static class bench
    extends Thread {
        private int runs;
        private int threadNum;
        private int[] object;
        private String[] keys;
        private int size;

        public bench(int runs, int threadNum, int[] object, String[] keys) {
            this.runs = runs;
            this.threadNum = threadNum;
            this.object = object;
            this.keys = keys;
            this.size = object.length;
        }

        public void run() {
            int i;
            StringBuilder result = new StringBuilder();
            MemCachedClient mc = new MemCachedClient();
            mc.setCompressEnable(false);
            mc.setCompressThreshold(0L);
            long start = System.currentTimeMillis();
            for (int i2 = 0; i2 < this.runs; ++i2) {
                mc.delete(this.keys[i2]);
            }
            long elapse = System.currentTimeMillis() - start;
            float avg = (float)elapse / (float)this.runs;
            result.append("\nthread " + this.threadNum + ": runs: " + this.runs + " deletes of obj " + this.size / 1024 + "KB -- avg time per req " + avg + " ms (total: " + elapse + " ms)");
            start = System.currentTimeMillis();
            for (i = 0; i < this.runs; ++i) {
                mc.set(this.keys[i], this.object);
            }
            elapse = System.currentTimeMillis() - start;
            avg = (float)elapse / (float)this.runs;
            result.append("\nthread " + this.threadNum + ": runs: " + this.runs + " stores of obj " + this.size / 1024 + "KB -- avg time per req " + avg + " ms (total: " + elapse + " ms)");
            start = System.currentTimeMillis();
            for (i = 0; i < this.runs; ++i) {
                mc.get(this.keys[i]);
            }
            elapse = System.currentTimeMillis() - start;
            avg = (float)elapse / (float)this.runs;
            result.append("\nthread " + this.threadNum + ": runs: " + this.runs + " gets of obj " + this.size / 1024 + "KB -- avg time per req " + avg + " ms (total: " + elapse + " ms)");
            threadInfo.put(new Integer(this.threadNum), result);
        }
    }
}

