/*
 * Decompiled with CFR 0.152.
 */
package com.danga.MemCached;

import com.danga.MemCached.LineInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufArrayInputStream
extends InputStream
implements LineInputStream {
    private ByteBuffer[] bufs;
    private int currentBuf = 0;

    public ByteBufArrayInputStream(List<ByteBuffer> bufs) throws Exception {
        this(bufs.toArray(new ByteBuffer[0]));
    }

    public ByteBufArrayInputStream(ByteBuffer[] bufs) throws Exception {
        if (bufs == null || bufs.length == 0) {
            throw new Exception("buffer is empty");
        }
        this.bufs = bufs;
        for (ByteBuffer b : bufs) {
            b.flip();
        }
    }

    @Override
    public int read() {
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                return this.bufs[this.currentBuf].get();
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length);
        --this.currentBuf;
        return -1;
    }

    @Override
    public int read(byte[] buf) {
        int len = buf.length;
        int bufPos = 0;
        do {
            if (this.bufs[this.currentBuf].hasRemaining()) {
                int n = Math.min(this.bufs[this.currentBuf].remaining(), len - bufPos);
                this.bufs[this.currentBuf].get(buf, bufPos, n);
                bufPos += n;
            }
            ++this.currentBuf;
        } while (this.currentBuf < this.bufs.length && bufPos < len);
        --this.currentBuf;
        if (bufPos > 0 || bufPos == 0 && len == 0) {
            return bufPos;
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        byte[] b = new byte[1];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean eol = false;
        while (this.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
            } else if (eol) {
                if (b[0] == 10) break;
                eol = false;
            }
            bos.write(b, 0, 1);
        }
        if (bos == null || bos.size() <= 0) {
            throw new IOException("++++ Stream appears to be dead, so closing it down");
        }
        return bos.toString().trim();
    }

    @Override
    public void clearEOL() throws IOException {
        byte[] b = new byte[1];
        boolean eol = false;
        while (this.read(b, 0, 1) != -1) {
            if (b[0] == 13) {
                eol = true;
                continue;
            }
            if (!eol) continue;
            if (b[0] == 10) break;
            eol = false;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufArrayIS: ");
        sb.append(this.bufs.length).append(" bufs of sizes: \n");
        for (int i = 0; i < this.bufs.length; ++i) {
            sb.append("                                        ").append(i).append(":  ").append(this.bufs[i]).append("\n");
        }
        return sb.toString();
    }
}

