/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

public class LU {
    private double[][] LU_;
    private int[] pivot_;

    public LU(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        this.LU_ = new double[n][n2];
        LU.insert_copy(this.LU_, dArray);
        this.pivot_ = new int[n];
        LU.factor(this.LU_, this.pivot_);
    }

    public static int factor(double[][] dArray, int[] nArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = Math.min(n2, n);
        int n4 = 0;
        while (n4 < n3) {
            double d;
            int n5 = n4;
            double d2 = Math.abs(dArray[n4][n4]);
            int n6 = n4 + 1;
            while (n6 < n2) {
                d = Math.abs(dArray[n6][n4]);
                if (d > d2) {
                    n5 = n6;
                    d2 = d;
                }
                ++n6;
            }
            nArray[n4] = n5;
            if (dArray[n5][n4] == 0.0) {
                return 1;
            }
            if (n5 != n4) {
                double[] dArray2 = dArray[n4];
                dArray[n4] = dArray[n5];
                dArray[n5] = dArray2;
            }
            if (n4 < n2 - 1) {
                d = 1.0 / dArray[n4][n4];
                int n7 = n4 + 1;
                while (n7 < n2) {
                    double[] dArray3 = dArray[n7];
                    int n8 = n4;
                    dArray3[n8] = dArray3[n8] * d;
                    ++n7;
                }
            }
            if (n4 < n3 - 1) {
                int n9 = n4 + 1;
                while (n9 < n2) {
                    double[] dArray4 = dArray[n9];
                    double[] dArray5 = dArray[n4];
                    double d3 = dArray4[n4];
                    int n10 = n4 + 1;
                    while (n10 < n) {
                        int n11 = n10;
                        dArray4[n11] = dArray4[n11] - d3 * dArray5[n10];
                        ++n10;
                    }
                    ++n9;
                }
            }
            ++n4;
        }
        return 0;
    }

    public double[][] getLU() {
        return LU.new_copy(this.LU_);
    }

    public int[] getPivot() {
        return LU.new_copy(this.pivot_);
    }

    protected static final void insert_copy(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        int n3 = n2 & 3;
        int n4 = 0;
        while (n4 < n) {
            double[] dArray3 = dArray[n4];
            double[] dArray4 = dArray2[n4];
            int n5 = 0;
            while (n5 < n3) {
                dArray3[n5] = dArray4[n5];
                ++n5;
            }
            int n6 = n3;
            while (n6 < n2) {
                dArray3[n6] = dArray4[n6];
                dArray3[n6 + 1] = dArray4[n6 + 1];
                dArray3[n6 + 2] = dArray4[n6 + 2];
                dArray3[n6 + 3] = dArray4[n6 + 3];
                n6 += 4;
            }
            ++n4;
        }
    }

    protected static double[] new_copy(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public static int[] new_copy(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
        return nArray2;
    }

    protected static double[][] new_copy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        int n3 = 0;
        while (n3 < n) {
            double[] dArray3 = dArray2[n3];
            double[] dArray4 = dArray[n3];
            int n4 = 0;
            while (n4 < n2) {
                dArray3[n4] = dArray4[n4];
                ++n4;
            }
            ++n3;
        }
        return dArray2;
    }

    public static final double num_flops(int n) {
        double d = n;
        return 2.0 * d * d * d / 3.0;
    }

    public double[] solve(double[] dArray) {
        double[] dArray2 = LU.new_copy(dArray);
        LU.solve(this.LU_, this.pivot_, dArray2);
        return dArray2;
    }

    public static void solve(double[][] dArray, int[] nArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            n2 = nArray[n6];
            d = dArray2[n2];
            dArray2[n2] = dArray2[n6];
            if (n5 == 0) {
                n = n5;
                while (n < n6) {
                    d -= dArray[n6][n] * dArray2[n];
                    ++n;
                }
            } else if (d == 0.0) {
                n5 = n6;
            }
            dArray2[n6] = d;
            ++n6;
        }
        n2 = n4 - 1;
        while (n2 >= 0) {
            d = dArray2[n2];
            n = n2 + 1;
            while (n < n4) {
                d -= dArray[n2][n] * dArray2[n];
                ++n;
            }
            dArray2[n2] = d / dArray[n2][n2];
            --n2;
        }
    }
}

